/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1987,1988
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:vgadefs.h 12.0$ */
/* $ACIS:vgadefs.h 12.0$ */
/* $Source: /ibm/acis/usr/sys/ca_atr/RCS/vgadefs.h,v $ */

#if !defined(lint) && !defined(LOCORE) && defined(RCS_HDRS)
static char *rcsidvgadefs = "$Header:vgadefs.h 12.0$";
#endif

/*
 * VGA hardware defines
 *
 * See IBM PS/2 Model 50 and 60 Technical Reference
 *
 */
#define	VGA_GRAPHICS_ADDR	0x3ce	/* graphics control registers */
#define	VGA_GRAPHICS_REG	0x3cf
#define	  VGA_GRA_ROTATE	0x03	/* rotation control mask */
#define	VGA_SEQUENCE_ADDR	0x3c4	/* sequence control registers */
#define	VGA_SEQUENCE_REG	0x3c5
#define	  VGA_SEQ_MAP_MASK	0x02	/* set active display maps */
#define	    VGA_MAP0		1
#define	    VGA_MAP1		2
#define	    VGA_MAP2		4
#define	    VGA_MAP3		8
#define	    VGA_MAP_ALL		(VGA_MAP0|VGA_MAP1|VGA_MAP2|VGA_MAP3)
#define	VGA_CRT_ADDR_MONO	0x3b4	/* crt control registers */
#define	VGA_CRT_REG_MONO	0x3b5
#define	VGA_CRT_ADDR_COLOR	0x3d4
#define	VGA_CRT_REG_COLOR	0x3d5
#define   VGA_CURSOR_HIGH	0x0e	/* cursor controles */
#define   VGA_CURSOR_LOW	0x0f
#define	VGA_DAC_ADDR		0x3c8	/* Digital -> analog color tables */
#define	VGA_DAC_DATA		0x3c9
/* adjust a color value to gray scale */
#define	VGA_GRAY(red,green,blue)	((((red)*30)+((green)*59)+((blue)*11))/100)
#define	VGA_COLOR_MASK		0x3f
#define VGA_STATUS_0		0x3c2	/* input status reg 0 */
#define   VGA_SWITCH_SENSE	0x10	/* sense return input from display */
#define VGA_STATUS_1_MONO	0x3ba	/* input status reg 0 mono emulation */
#define VGA_STATUS_1_COLOR	0x3da	/* input status reg 0 color emulation */
#define	  VGA_RETRACE		0x01	/* bit is on if we are in horizontal or vertical retrace */
#define	  VGA_VERT_RETRACE	0x08	/* bit is on if we are in vertical retrace */
#define VGA_MISC_OUT_READ	0x3cc	/* read port to the miscellaneous output reg */
#define	  VGA_EMUL_SELECT	0x01	/* selects the display emulation mode */
/* get the address of the currently active input status register 1 */
#define vga_get_status()	(in(VGA_MISC_OUT_READ) & VGA_EMUL_SELECT ? \
				    VGA_STATUS_1_COLOR : VGA_STATUS_1_MONO) 
/* get the state of the switch sense bit */
#define	vga_switch_sense()	(in(VGA_STATUS_0) & VGA_SWITCH_SENSE)
/* get the state of the retrace line (reg is the currently active status register 1) */
#define vga_retrace(reg)	(in(reg) & VGA_RETRACE)
/* get the state of the vertical retrace line (reg is the currently active status register 1) */
#define vga_vert_retrace(reg)	(in(reg) & VGA_VERT_RETRACE)

/*
 * bios controls defines.
 */
#define VIDEO	PCINT10		/* video interrupt code */
#define VGA_BIOS_MODE	0x00	/* ah set the vga display mode */
#define VGA_ALT_SELECT	0x12	/* ah alternate functions */
#define  VGA_ALT_SET_SCAN 0x30	/* bl set the scan lines */
#define  VGA_MAX_SCAN	0x2	/* max legal value for bl */

/*
 * ATTRIBUTES for monochrome monitors, monochrome emulation, and
 * color graphics emulation
 *
 * Bits 3 and 7 of the attribute byte have more than one definition
 *
 *    Bit 3 can be used for either Foreground Intensity or Character
 *    Block Select. When used for Charcater Block Select, the 128
 *    charcater codes can be used to address a range of 256 charcaters.
 *
 *    Bit 7 can be used for either Blink or Background Intensity charcaters.
 */
#define VGA_INTENSE		0x08
#define VGA_BLINK		0x80

/*
 * A/N and APA Color Graphics definitions
 *
 *   Note: current default setting of screen attribute byte is
 *	   white foreground, black background
 *
 *   Note: default settings for VGA_FG_DEFAULT and VGA_BG_DEFAULT must be
 *	   in sync with the default values defines in ../cacons/ibm_emul.c
 */

#define VGA_COLOR_SHIFT	   4	 /* num of bits to shift to get bg clr */
#define VGA_FG_MASK	  0x7	 /* flag, indicates type of masking    */
#define VGA_BG_MASK	  0x7 	 /*   that should be done	       */
#define VGA_FG_DEFAULT		   VGA_FG_MASK
#define VGA_BG_DEFAULT		   0
#define VGA_MAX_COLOR	256


/*
 *  DAC Color lookup table - 256 register settings
 *
 *  registers  00 - FF	 EGA colors
 *	       10 - 1F	 evenly spaced shades of gray
 *	       20 - F7	 24 distict color, 3 intensity levels,
 *			 3 saturation levels
 *	       F8 - FF	 non-standard, all set to EGA white
 *
 *  Note: The kernel driver has the ability to change the color
 *    table entries' setting of the red, green, blue values.
 *    They are currently normalized to a 32 bit quantity, where
 *    the high order bits are the most significant color bits
 *    based on the number of colors avaliable.
 *
 *    The #define CLRTBL_SHIFT is used to de-NORMALIZE the
 *    red, green, blue values when setting the color table.
 *    The maximum color count (bits) is the MAXIMUM_COLOR_COUNT
 *    byte, in ibm_emul.h ) times four. The number of bits to
 *    shift is the maximum color count - the significant bits.
 */

#ifdef STANDALONE
#define  CLRTBL_SHIFT  ( 0 )                          /* don't shift         */
#else  /* assume KERNEL */
#define  CLRTBL_SHIFT  ( (MAX_COLOR_COUNT * 4) - 6 )  /* normalize - sigbits */
#endif STANDALONE

/*
 * mode info for using bios req interface to set
 * the vga mode.
 */
struct vga_mode_param {
	u_char	bios_mode;
	u_char	scan;
};

struct vga_color {
   signed char red;
   signed char green;
   signed char blue;
};

/*
 * First 16 initial palette settings for various VGA modes.
 */

#define VGA_DEFAULT_COLORS { \
	{ 0x00, 0x00, 0x00 },		/* black    */\
	{ 0x00, 0x00, 0x2a },		/* blue     */\
	{ 0x00, 0x2a, 0x00 },		/* green    */\
	{ 0x00, 0x2a, 0x2a },		/* cyan     */\
	{ 0x3f, 0x00, 0x00 },		/* red      */\
	{ 0x2a, 0x00, 0x2a },		/* magenta  */\
	{ 0x2a, 0x15, 0x00 },		/* brown    */\
	{ 0x2a, 0x2a, 0x2a },		/* white    */\
	{ 0x15, 0x15, 0x15 },		/* gray     */\
	{ 0x15, 0x15, 0x2a },		/* l.blue   */\
	{ 0x15, 0x2a, 0x15 },		/* l.green  */\
	{ 0x15, 0x2a, 0x2a },		/* l.cyan   */\
	{ 0x3f, 0x15, 0x15 },		/* l.red    */\
	{ 0x2a, 0x15, 0x2a },		/* l.magenta*/\
	{ 0x3f, 0x3f, 0x15 },		/* yellow   */\
	{ 0x3f, 0x3f, 0x3f },		/* i.white  */\
}

/* char codes */
#define	BLANK		0x20


/* macro definitions */
#define SAVE_TEXT_SCREEN()	\
		copy_screen_in((char *)vga_screen_window,local_text_buffer)
#define RESTORE_TEXT_SCREEN()	\
		copy_screen_out(local_text_buffer,(char *)vga_screen_window)

#define VGA_IN_FOREGROUND	(vga_fgbg == VGA_FOREGROUND)

/* macro to convert the cursor position into an offset */
#define CUR_OFFSET(x,y) ((x * VGA_COLUMNS + y) * VGA_CELL_SIZE)

#ifdef KERNEL
#define	VGA_LOCK_SCREEN(s)	(s=KLSSPL(),vga_screen_lock++,splx(s))
#define	VGA_UNLOCK_SCREEN(s)	(s=KLSSPL(),vga_screen_lock--,splx(s))
#else !KERNEL
/* STANDALONE doesn't take interrupts */
#define VGA_LOCK_SCREEN(s)	(vga_screen_lock = 1)
#define VGA_UNLOCK_SCREEN(s)	(vga_screen_lock = 0)
#endif !KERNEL
#define	VGA_SCREEN_LOCKED	(vga_screen_lock)
