/*
 * 5799-WZQ (C) COPYRIGHT = NONE
 * LICENSED MATERIALS - PROPERTY OF IBM
 */
/* $Header:readdir.c 12.0$ */
/* $ACIS:readdir.c 12.0$ */
/* $Source: /ibm/acis/usr/src/lib/libc/gen/RCS/readdir.c,v $ */

#ifndef lint
static char *rcsid = "$Header:readdir.c 12.0$";
#endif

#include <sys/nfs_defines.h>

/*
 * Copyright (c) 1983 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 */

#if defined(LIBC_SCCS) && !defined(lint)
static char sccsid[] = "@(#)readdir.c	5.2 (Berkeley) 3/9/86";
#endif LIBC_SCCS and not lint

#ifdef VFS
/* @(#)readdir.c	1.2 87/07/22 3.2/4.3NFSSRC */
#endif VFS

#include <sys/param.h>
#include <sys/dir.h>

#ifdef VFS
extern int getdirentries();
#endif VFS

/*
 * get next entry in a directory.
 */
struct direct *
readdir(dirp)
	register DIR *dirp;
{
	register struct direct *dp;

	for (;;) {
		if (dirp->dd_loc == 0) {
#ifndef VFS
			dirp->dd_size = read(dirp->dd_fd, dirp->dd_buf, 
			    DIRBLKSIZ);
#else !VFS
			dirp->dd_size = getdirentries(dirp->dd_fd,
			    dirp->dd_buf, dirp->dd_bsize, &dirp->dd_bbase);
#endif !VFS
			if (dirp->dd_size <= 0)
				return NULL;
#ifdef VFS
			dirp->dd_entno = 0;
#endif VFS
		}
		if (dirp->dd_loc >= dirp->dd_size) {
			dirp->dd_loc = 0;
			continue;
		}
		dp = (struct direct *)(dirp->dd_buf + dirp->dd_loc);
#ifndef VFS
		if (dp->d_reclen <= 0 ||
		    dp->d_reclen > DIRBLKSIZ + 1 - dirp->dd_loc)
			return NULL;
#else !VFS
		if (dp->d_reclen <= 0)
			return NULL;
#endif !VFS
		dirp->dd_loc += dp->d_reclen;
#ifndef VFS
		if (dp->d_ino == 0)
#else !VFS
		dirp->dd_entno++;
		if (dp->d_fileno == 0)
#endif !VFS
			continue;
		return (dp);
	}
}

