/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1986,1987,1988
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:swapfpflag.c 12.0$ */
/* $ACIS:swapfpflag.c 12.0$ */
/* $Source: /ibm/acis/usr/src/lib/libc/ca/gen/RCS/swapfpflag.c,v $ */

#ifndef lint
static char *rcsid = "$Header:swapfpflag.c 12.0$";
#endif

#include <machine/fp.h>
#include <ieee.h>

/************************************************************************/
/* SWAPFPFLAG sets each exception flags marked in mask to each		*/
/*	corresponding setting in value.  The previous setting of each	*/
/*	of these flags is returned.  If, however, no exceptions are	*/
/*	marked in mask (mask = 0), then no flags are set and the	*/
/*	current setting of each of the flags marked in value is		*/
/*	returned.							*/
/************************************************************************/
FPEXCEPTION swapfpflag(mask,value)
FPEXCEPTION mask, value;
{
    FPEXCEPTION current_value,this_exception;
    FPEXCEPTION set_value = 0;
    FPEXCEPTION clr_value = 0;

	current_value = fptestflag();		/* read current setting */

#ifdef DEBUG
printf("swapfpflag: mask = %x, value = %x\n",mask,value);
printf("swapfpflag: current setting is %08.x\n",current_value);
#endif DEBUG

	mask &= FPALLEXCEPTIONS;		/* input validation */
	if (mask == 0)				/* no new setting */
		return(current_value & value);	/* return the setting of */
						/* flags marked in value */
	current_value &= mask;			/* the return value */
	this_exception = 1;			/* start with the rightmost */
						/* exception */
	do {
	    if (mask & 1) {			/* interested in this one? */
		if (value & this_exception)	/* set or clear? */
		    set_value |= this_exception;
		else
		    clr_value |= this_exception;
	    } /* end if */
	    this_exception <<= 1;		/* advance to next exception */
	} while (mask >>= 1);			/* adjust mask so that the */
						/* rightmost bit is always */
						/* = current exception */
	if (set_value) fpsetflag(set_value);
	if (clr_value) fpclrflag(clr_value);

#ifdef DEBUG
printf("swapfpflag: new setting will be %08.x\n",fptestflag());
#endif DEBUG
	return(current_value);
}
