/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1986
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:setjmp.s 12.0$ */
/* $ACIS:setjmp.s 12.0$ */
/* $Source: /ibm/acis/usr/src/lib/libc/ca/gen/RCS/setjmp.s,v $ */

	.data
rcsid:	.asciz	"$Header:setjmp.s 12.0$"
	.text

#include <syscall.h>
#include "LINKG.h"

 #	Save/restore context subroutines
 #
 #	setjmp(jmpbuf);			/* save registers (including stack */
 #		 r2			/* pointer) and return zero */
 #
 #	longjmp(jmpbuf, value);		/* restore registers (including stack */
 #		  r2	 r3		/* pointer) and return value to the */
 #					/* last caller of setjmp */
 #
 #	where jmpbuf is an array of 32 bit words used as follows:
 #
 #	----------------------------
 #	| value of r1 from setjmp  | 0x00  (stack pointer from setjmp)
 #	----------------------------
 #	| value of r6 from setjmp  | 0x04
 #	----------------------------
 #	| value of r7 from setjmp  | 0x08
 #	----------------------------
 #	| value of r8 from setjmp  | 0x0C
 #	----------------------------
 #	| value of r9 from setjmp  | 0x10
 #	----------------------------
 #	| value of r10 from setjmp | 0x14
 #	----------------------------
 #	| value of r11 from setjmp | 0x18
 #	----------------------------
 #	| value of r12 from setjmp | 0x1C
 #	----------------------------
 #	| value of r13 from setjmp | 0x20
 #	----------------------------
 #	| value of r14 from setjmp | 0x24
 #	----------------------------
 #	| value of r15 from setjmp | 0x28  (return address to setjmp)
 #	----------------------------
 #	| sigmask at time of setjmp| 0x2C  (restored during longjump)
 #	----------------------------
 #	|			   |
 # 	| 4 unused words     	   |
 #	|			   |
 #	----------------------------


ENTRY(setjmp)
	sts	r1,0(r2)		#save caller's stack pointer
	stm	r6,4(r2)		#save r6 thru r15 in jmpbuf
	cas	r5,r2,r0		#r5 -> jmpbuf
	cal	r2,-1(r0)		#mask all (most) signals
	svc	SYS_sigsetmask(r0)	#set mask and return previous mask
	sts	r2,0x2C(r5)		#remember previous mask
	svc	SYS_sigsetmask(r0)	#reset previous mask
	brx	r15			#return to calling routine
	x	r2,r2			#return value of zero

ENTRY(longjmp)
	cas	r5,r2,r0		#r5 -> jmpbuf
	ls	r2,0x2C(r5)		#signal mask at time of setjmp
	svc	SYS_sigsetmask(r0)	#restore signal mask
	lm	r6,4(r5)		#restore r6 thru r15 from jmpbuf
	ls	r1,0(r5)		#restore r1 from jmpbuf
	brx	r15			#return to caller of setjmp
	cas	r2,r3,r0		#return 2nd longjmp parm to setjmp

ENTRY(_setjmp)
	sts	r1,0(r2)		#save caller's stack pointer
	stm	r6,4(r2)		#save r6 thru r15 in jmpbuf
	brx	r15			#return to calling routine
	x	r2,r2			#return value of zero

ENTRY(_longjmp)
	lm	r6,4(r2)		#restore r6 thru r15 from jmpbuf
	ls	r1,0(r2)		#restore r1 from jmpbuf
	brx	r15			#return to caller of setjmp
	cas	r2,r3,r0		#return 2nd longjmp parm to setjmp

	TTNOFRM
