/*
 * 5799-WZQ (C) COPYRIGHT = NONE
 * LICENSED MATERIALS - PROPERTY OF IBM
 */
/* $Header:prvderr.c 12.0$ */
/* $ACIS:prvderr.c 12.0$ */
/* $Source: /ibm/acis/usr/src/ibm/rvd/lib/RCS/prvderr.c,v $ */

#ifndef lint
static char *rcsid = "$Header:prvderr.c 12.0$";
#endif


#ifndef lint
static char rcsid_prvderr_c[] = "$Header:prvderr.c 12.0$";
#endif lint

/* Copyright 1984 by the Massachusetts Institute of Technology */
/* See permission and disclaimer notice in the file "notice.h" */
#include "notice.h"


#include <stdio.h>
#include <sys/types.h>
#include <machineio/vdconst.h>

extern	char	*myname;	/* should point to argv[0] */

/*
 * Routine to print out appropriate error message for virtual disk error
 * codes.
 * 	rvderrno	---	value of vd error code
 *	message	---	string to print along with message.
 *
 * written by Michael Greenwald, August 1982
 */

prvderr(rvderrno, message)

int	rvderrno;
char	*message;

{
	char	*errmes;

	if (rvderrno == RVDENOER)
		return;

	if(! message)		/* just in case */
		message = "";

	switch (rvderrno) {

/* local */
	case RVDETIM:
		errmes = "Timeout";
		break;

	case RVDEBVER:
		errmes = "Incompatible versions of RVD";
		break;

/* Standard */
	case RVDEND:
		errmes = "Client has no pack spun up on this drive";
		break;

	case RVDEBPWD:
		errmes = "Bad password for requested spinup mode";
		break;

	case RVDEOMD:
		errmes = "Pack is in use in a conflicting spinup mode";
		break;

	case RVDECKSM:
		errmes = "Invalid checksum on packet received by RVD server";
		break;

	case RVDEIDX:
		errmes = "Bad index supplied to RVD server. Corrected";
		break;

	case RVDEPACK:
		errmes = "Pack name not found";
		break;

	case RVDESPN:
		errmes = "This client is already using this drive for another disk pack";
		break;

	case RVDETBMD:
		errmes = "Requested spinup mode temporarily unavailable";
		break;

	case RVDEPDIS:
		errmes = "Requested physical device temporarily disabled";
		break;

	case RVDEBMD:
		errmes = "Unknown spinup mode";
		break;

	case RVDEPKT:
		errmes = "Server received packet of unknown type";
		break;

	case RVDENAH:
		errmes = "Server doesn't believe this client is active";
		break;

	case RVDEXMD:
		errmes = "Pack is in use in exclusive mode";
		break;

	case RVDEZBL:
		errmes = "Zero blocks of data requested";
		break;

	case RVDETBL:
		errmes = "Too many blocks requested at once";
		break;

	case RVDEPNM:
		errmes = "Pack not physically mounted at server";
		break;

	case RVDETCG:
		errmes = "Too many connections for server to support";
		break;

	case RVDETGH:
		errmes = "Too many connections for this client";
		break;

	case RVDESNA:
		errmes = "RVD Server is not currently accepting requests";
		break;

	case RVDEIDA:
		errmes = "(Warning). Identical pack already spun up in this mode on this drive";
		break;

	default:
		errmes = "Unknown error type";
	}
	fprintf(stderr, "%s: %s.\t\n%s\n", myname, errmes, message);
}
