/*
 * 5799-WZQ (C) COPYRIGHT = NONE
 * LICENSED MATERIALS - PROPERTY OF IBM
 */
/* $Header:virtd.h 12.0$ */
/* $ACIS:virtd.h 12.0$ */
/* $Source: /ibm/acis/usr/src/ibm/rvd/h/RCS/virtd.h,v $ */

#if !defined(lint) && !defined(LOCORE) && defined(RCS_HDRS)
static char *rcsidvirtd = "$Header:virtd.h 12.0$";
#endif


/* Copyright 1984 by the Massachusetts Institute of Technology */
/* See permission and disclaimer notice in the file "notice.h" */
#include "notice.h"

/* This file contains the definitions for the virtual disk descriptor
 * structure.  Virtual disk descriptors are read in from the virtual
 * disk descriptor files at startup time; they may also be created,
 * modified, and deleted as a result of control messages.
 */

#include <sys/types.h>
#ifndef	IPPROTO_RVD
#include <netinet/in.h>
#endif	IPPROTO_RVD
#include "obj.h"

#define	NDESC		16		/* description length	*/

struct virtd	{			/* virtual disk descriptor */

/* The first three fields are not stored in the disk file */

	struct	virtd	*vd_forw;	/* forward link */
	struct	virtd	*vd_back;	/* backward link */
	obj_type	vd_type;	/* object type */

/* The information read in from the disk starts here */

	char		vd_desc[NDESC+1]; /* description */
	char		vd_pack[VD_NAME_LEN+1]; /* packname */
	char		vd_ropasswd[VD_CAPAB_LEN+1]; /* read only */
	char		vd_expasswd[VD_CAPAB_LEN+1]; /* exclusive */
	char		vd_shpasswd[VD_CAPAB_LEN+1]; /* shared */
	u_long		vd_uid;		/* pack unique id */
	long		vd_offset;	/* offset on raw disk */
	long		vd_blocks;	/* number of blocks in virtual pack */
	int		vd_modes;	/* current modes of allowable opens */
	u_long		vd_created;	/* create time for database entry */
	u_long		vd_accessed;	/* access time for client */
	u_long		vd_modified;	/* modify time for client */
	struct	in_addr	vd_host;	/* owning machine - doesn't need */
					/* a password to spin it up */

/* End of information actually stored on disk; rest is in-core only but
 * is stored as "spare information" in the on-disk copy and read in as 0's
 */

	u_char		vd_mode;	/* current open mode */
	char		vd_uu1;		/* unused */
	int		vd_links;	/* number of opens on this disk */
	struct	physd	*pd_forw;	/* pointer to phys disk descriptor */
	struct	physd	*pd_back;	/* ditto */
	int		vd_modes_orig;	/* original modes of allowable opens */
};

/* Modes (others in rvdconst.h) */

#define	RVDMNONE	0	/* unopened */

struct	virtd_q	{		/* a queue of virtual disks */
	struct	virtd	*vq_forw; /* forward link */
	struct	virtd	*vq_back; /* backward link */
};

#ifdef	q_head
#undef	q_head
#endif	q_head

#define	q_head(p, t)	((t)((struct qelem *) p)->q_forw)

#define	forall(h, t)	{ t *p, *q; \
			  for(q = (t *) &(h), p = q_head(q, t *); \
			  p != q; p = q_head(p, t *))

#define	end		}
