/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1986
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:el_lib.c 12.0$ */
/* $ACIS:el_lib.c 12.0$ */
/* $Source: /ibm/acis/usr/src/ibm/lpfilter/tools/RCS/el_lib.c,v $ */

#ifndef lint
static char *rcsid = "$Header:el_lib.c 12.0$";
#endif

#include <stdio.h>
#include <utils.h>
#include <hash.h>
#include <environ.h>
#include <err_log.h>

/***===================================================================***/

#define WHERE_AM_I "el_lib.c"

/***===================================================================***/

int
el_mailreport(infil,outfil,el)
register3 FILE      *infil;
register4 FILE      *outfil;
register7 error_log *el;
{
register1 environ *env;
register2 int      ch;
register5 char    *user;
register6 char    *host;
char cmd[60];

    D_ENTRY3(el_debug,"el_mailreport(0x%x,0x%x,0x%x)\n",infil,outfil,el);
    env= el->el_env;
    if (env) {
	user= env_String(env,"user",NULL);
	host= env_String(env,"host",NULL);
	if (user&&host) 
	   sprintf(cmd,"mail %s@%s",user,host);
	else if (user)
	   sprintf(cmd,"mail %s",user);
	else RETURN(FALSE);
	outfil= u_popen(cmd,"w");
	if (!outfil)
	   RETURN(FALSE);
	while ((ch=getc(infil))!=EOF) {
	    putc(ch,outfil);
	}
        RETURN(TRUE);
    }
    RETURN(FALSE);
}

/***===================================================================***/

int 
el_txtopen(el,type)
register2 error_log *el;
register3 char      *type;
{
register1 environ *env;
register4 char *cmd;
register5 char *files;
register6 FILE *fil;

    D_ENTRY2(el_debug,"el_txtopen(0x%x,%s)\n",el,type);
    env= el->el_env;
    if (env) {
	cmd=   env_String(env,"command",NULL);
	files= env_String(env,"files",NULL);
    }
    else cmd= files= NULL;
    fil= el->el_file;
    if (!fil)
       RETURN(FALSE);
    fprintf(fil,"%s\n",u_Date());
    if (files&&cmd) {
	fprintf(fil,"\"%s %s\" reported the following errors:\n",cmd,files);
    }
    else if (files) {
	fprintf(fil,"The following errors were reported printing \"%s\":\n",
								     files);
    }
    else if (cmd) {
	fprintf(fil,"\"%s\" reported the following errors:\n",cmd);
    }
    else {
	fprintf(fil,"Your job reported the following errors:\n");
    }
    el->el_end= ftell(fil);
    RETURN(TRUE);
}

/***===================================================================***/

int 
el_txtclose(el)
register1 error_log *el;
{
    D_ENTRY1(el_debug,"el_txtclose(0x%x)\n",el);
    RETURN(TRUE);
}

/***===================================================================***/

int 
el_txtreport(infil,outfil,el)
register2 FILE      *infil;
register3 FILE      *outfil;
register4 error_log *el;
{
register1 int ch;

    D_ENTRY3(el_debug,"el_txtreport(0x%x,0x%x,0x%x)\n",infil,outfil,el);
    if ((!infil)||(!outfil)) 
	RETURN(FALSE);
    while (ch=getc(infil)) {
	putc(ch,outfil);
    }
    RETURN(TRUE);
}

