/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1986
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:printer.c 12.0$ */
/* $ACIS:printer.c 12.0$ */
/* $Source: /ibm/acis/usr/src/ibm/lib/pmp/RCS/printer.c,v $ */

#ifndef lint
static char *rcsid = "$Header:printer.c 12.0$";
#endif

#include <stdio.h>
#include <utils.h>
#include <hash.h>
#include <pmp_utils.h>
#include <pmp_commands.h>
#include <char.h>
#include <font.h>
#include <text.h>
#include <move.h>
#include <creg.h>
#include <vector.h>
#include <rp.h>
#include <vp.h>
#include <printer.h>

/***===================================================================***/

#define WHERE_AM_I	printer.c

int	pr_debug;

int	pr_constraint=	100;
int	pr_traytmp=	P_NO_TRAY;
int	pr_tray=		P_MAIN_TRAY;
int	pr_copies=	1;
int	pr_tmpcopyknt=	0;

/***============================================================***/

#ifdef DEBUG_UTILS
u_debug_arg	pr_debug_args[]= {
#ifdef FILE_UTILS
	"uf",	&u_fdebug,
#endif /* FILE_UTILS */
	"p",	&pr_debug,
	"rp",	&rp_debug,
	"u",	&u_debug,
	"ht",	&ht_debug,
	"fnt",	&fnt_debug,
	"ch",	&ch_debug,
	"cr",	&cr_debug,
	"pu",	&pu_debug,
	"txt",	&txt_debug,
	"vp",	&vp_debug,
	"v",	&v_debug,
	"vf",	&v_f_debug,
	"vP",	&v_p_debug,
	NULL,	NULL
};

#endif /* DEBUG_UTILS */

/***===================================================================***/

int
pr_open(outfil)
register1 FILE *outfil;
{
static int beenhere= FALSE;

    D_ENTRY1(pr_debug,"pr_open(0x%x)\n",outfil);
    if (!beenhere) {
	ch_init(pr_constraint);
	fnt_init(pr_constraint);
	cr_init(pr_constraint);
    }
    if (rp_file!=outfil)
	rp_init(outfil);
    else
	rp_clear();
    vp_init();
    if (rp_orient!=vp_orient) 
	rp_rotate(vp_orient);
    RETURN(TRUE);
}

/***===================================================================***/

int
pr_eject(clear)
register1 int clear;
{
register2 int copies;
register3 int tray;

    D_ENTRY1(pr_debug,"pr_eject(%d)\n",clear);
    vp_flush(VP_NONE);
    if		(pr_tmpcopyknt)		copies= pr_tmpcopyknt;
    else if	(pr_copies)		copies= pr_copies;
    else				copies= 1;
    if		(pr_traytmp!=RP_NO_TRAY)	tray=	pr_traytmp;
    else if	(pr_tray!=RP_NO_TRAY)	tray=	pr_tray;
    else				tray=	RP_MAIN_TRAY;
    while (copies>1) {
	rp_eject(RP_SAVE_PAGE_MAP,tray);
	copies--;
    }
    if (clear) 
	rp_eject(RP_CLEAR_PAGE_MAP,tray);
    else
    	rp_eject(RP_SAVE_PAGE_MAP,tray);
    pr_traytmp= P_NO_TRAY;
    pr_tmpcopyknt= 0;
    RETURN(TRUE);
}

/***===================================================================***/

int
pr_set_display(num)
register1 int num;
{
register2 int pnum;

    D_ENTRY1(pr_debug,"pr_set_display(%d)\n",num);
    if ((num>=RP_MIN_DISPLAY)&&(num<=RP_MAX_DISPLAY)) {
       pnum= ((num%10)&0xFF);
       pnum|= ((((num/10)%10)<<4)&0xF0);
       rp_set_display(pnum);
       RETURN(TRUE);
    }
    else {
	rp_set_display(RP_CLEAR_DISPLAY);
	RETURN(FALSE);
    }
}

/***===================================================================***/

int
pr_image(height,width,length,encoding,image)
register1 int	height,width;
register3 int	length,encoding;
register5 char	*image;
{
    D_ENTRY5(pr_debug,"pr_image(%d,%d,%d,%d,0x%x)\n",height,width,length,
							   encoding,image);

    vp_flush(VP_NONE);
    if (encoding!=P_RASTER) {
	error1("r_image -- unknown encoding 0x%x\n",encoding);
	action("assuming P_RASTER. good luck\n");
    }
    length= height*((width+7)/8);
    rp_image(height,width,length,image);
    RETURN(TRUE);
}


/***===================================================================***/

int
pr_set_pgwidth(width)
register1 int	width;
{
   D_ENTRY1(pr_debug,"pr_set_pgwidth(%d)\n",width);
   RETURN(FALSE);
}

/***===================================================================***/

int
pr_set_pgheight(height)
register1 int	height;
{
   D_ENTRY1(pr_debug,"pr_set_pgheight(%d)\n",height);
   RETURN(FALSE);
}

/***===================================================================***/
