/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1986
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:ibmfonts.h 12.0$ */
/* $ACIS:ibmfonts.h 12.0$ */
/* $Source: /ibm/acis/usr/src/ibm/fdb_ca/h/RCS/ibmfonts.h,v $ */

#if !defined(lint) && !defined(LOCORE)  && defined(RCS_HDRS)
static char *rcsidibmfonts = "$Header:ibmfonts.h 12.0$";
#endif


/*
 * ibmfonts.h - C type defintions for processing IBM font information
 */
#ifndef _IBMFONTS
#define _IBMFONTS

/*----------Per character data table--------------------------------------*/
struct ibm_cdata {
    string fni_id;		/* Graphic character identifier */
    string source;		/* Who owns this character def */
    int fni_char_inc;	/* Increment following this character */
    int fni_box_size_x; 	/* Number of columns */
    int fni_box_size_y; 	/* Number of rows */
#ifdef ibm3820
    int fni_ascender;
    int fni_descender;
    int fni_baseline_offset;
#endif
    int fni_pattern_offset;	/* Offset of pattern in ibm_patterns */
    int fni_a_space;		/* Space before the first dot */
    int fni_b_space;	/* Width of dots */
    int fni_c_space;		/* Space after the last dot */
};

/*-----------------------Per Font data--------------------------------------*/


typedef struct ibm_fd_struct {
    char* pool;				/* palloc pool for this font def */
    char* source;			/* the ibm copyright */
    string bfn_name; 			/* a short unique id for this font 
					   descriptor*/
    string fnd_family;			/* e.g. times, helvetica */
    string fnd_typeface;		/* e.g. roman, italic */
    string fnd_weight_class;
    string fnd_width_class;
    int fnd_vertical_size;		/* Tenths of points, nominal design 
					   target */
    int fnd_horizontial_size;	/* Tenths of points, nominal design 
					   target, ifless than
					   'vertical_point_size' then it is
					   considered condensed */
#ifndef ibm3820
    int fnd_print_direction;	/* Tenths of degrees measured clockwise
					   from normal */
    int fnd_rotation;		/* Tenths of degrees measured clockwise
					   from the print direction */
    int fnd_underscore_width;
    int fnd_underscore_position;
    string fnc_spaceing;		/* Kerned or Fixed_width */
#endif
    string fnc_box;			/* fixed_width or varible */
    int fnc_max_x;			/* Max pattern box width */
    int fnc_max_y;			/* Max number of rows in a pattern box */
    int fnc_patterns_size;		/* Number of bytes of pattern data */
#ifndef ibm3820
    int fnc_uniform_inline_offset;
    int fno_x_orientation;		/* Print Direction */
#endif
    int fno_y_orientation;		/* Character Rotation */
    int fno_uniform_baseline_offset;	/* row of baseline */
    int fno_uniform_character_increment;
    int fno_variable_space_increment;
    int fno_baseline_extent;
    string fno_fixed_width;
    int fno_em_space;
    int fno_figure_space;
    int fno_default_baseline_increment; 
#ifdef ibm3820
    int fno_uniform_a_space;
#endif   
    symtab_type fni_c_index;		/* Per character data index by
					   graphic character name */
    int fng_patterns_fill;		/* how full patterns is currently */
    byte *fng_patterns;			/* The pattern data */
} ibm_fd_type;

#endif	_IBMFONTS
