/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1986
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:vload.c 12.0$ */
/* $ACIS:vload.c 12.0$ */
/* $Source: /ibm/acis/usr/src/ibm/aedtest/RCS/vload.c,v $ */

#ifndef lint
static char *rcsid = "$Header:vload.c 12.0$";
#endif

/* vload.c -- modified to use external arrays, not files */
#include "vikst.h"

extern INT16 a2910_size,a29116_size,aaddr_size,ablck_size,
			abuffer_size,abufn_size,afastbuf_size,along_size,
			arzdz_size,ascpad_size,asram_size,aybus_size,
			glasstty_size;

extern unsigned char a2910[],a29116[],aaddr[],ablck[],
			abuffer[],abufn[],afastbuf[],along[],
			arzdz[],ascpad[],asram[],aybus[],glasstty[];

#ifdef BSD
extern int v_control;	/* ioctl for device aed */
extern FILE *spool;
#endif

load(src)
char *src;
{ INT16 fn,len,loc;
  unsigned char *array; INT16 array_size;
  if (!strcmp(src,"2910.vkt"))
	{
	array = a2910;
	array_size = a2910_size;
	}
  else if (!strcmp(src,"29116.vkt"))
	{
	array = a29116;
	array_size = a29116_size;
	}
  else if (!strcmp(src,"blck.vkt"))
	{
	array = ablck;
	array_size = ablck_size;
	}
  else if (!strcmp(src,"buffer.vkt"))
	{
	array = abuffer;
	array_size = abuffer_size;
	}
  else if (!strcmp(src,"bufn.vkt"))
	{
	array = abufn;
	array_size = abufn_size;
	}
  else if (!strcmp(src,"fastbuf.vkt"))
	{
	array = afastbuf;
	array_size = afastbuf_size;
	}
  else if (!strcmp(src,"long.vkt"))
	{
	array = along;
	array_size = along_size;
	}
  else if (!strcmp(src,"rzdz.vkt"))
	{
	array = arzdz;
	array_size = arzdz_size;
	}
  else if (!strcmp(src,"scpad.vkt"))
	{
	array = ascpad;
	array_size = ascpad_size;
	}
  else if (!strcmp(src,"sram.vkt"))
	{
	array = asram;
	array_size = asram_size;
	}
  else if (!strcmp(src,"ybus.vkt"))
	{
	array = aybus;
	array_size = aybus_size;
	}
  else if (!strcmp(src,"glasstty.vkt"))
	{
	array = glasstty;
	array_size = glasstty_size;
	}
  else 
	{
	PRINTF("Microcode array %s not found.\n",src);
       return;
    }
#ifdef (1) /* BSD */
  ioctl(v_control,AEDRESET); /* reset Viking */
  ioctl(v_control,AEDDELAY); 
   /* copy microcode array into control store */
  write(v_control,array,array_size); 
  p2m("Microcode array %s loaded.\n",src);
  ioctl(v_control,AEDSTART); /* start Viking */
#else
  vread(&loc,1,0);	/* reset Viking */
  /* delay(BUSWAIT); */
   /* copy microcode array into control store */
   vwrite(array,array_size/2,0X0000); 
  p2m("Microcode array %s loaded.\n",src);
  vread(&fn,1,SR);	/* start Viking */
#endif
}
