/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1986
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:vbuf.c 12.0$ */
/* $ACIS:vbuf.c 12.0$ */
/* $Source: /ibm/acis/usr/src/ibm/aedtest/RCS/vbuf.c,v $ */

#ifndef lint
static char *rcsid = "$Header:vbuf.c 12.0$";
#endif

/* vbuf.c */
#include "vikst.h"
#define MAXTIME 120
/* MAXTIME is defined in seconds */
#define rev(X) ((((unsigned)X)<<8)|(((unsigned)X)>>8))
#define REV(X) ((((unsigned)X)<<8)|(((unsigned)X)>>8))
typedef struct cnode { INT16 bit[4];
		       INT16 unum; } err;
static err chip[16];
static INT16 errs;

#ifdef BSD
  extern FILE *out,*spool;
	extern dumpspool();
	extern int v_control;
#endif

buffer()
{ INT16 a,i,k;
  INT16 h,m,s,t1,t2;
  extern UINT16 zero;
  UINT16 type,bits,order;
  UINT16 finished,j;

  load("fastbuf.vkt");
  chip[0].unum = 47;   chip[1].unum = 57;
  chip[2].unum = 48;   chip[3].unum = 58;
  chip[4].unum = 30;   chip[5].unum = 38;
  chip[6].unum = 31;   chip[7].unum = 39;
  chip[8].unum =  1;   chip[9].unum =  9;
  chip[10].unum =  2;  chip[11].unum = 10;
  chip[12].unum = 18;  chip[13].unum = 21;
  chip[14].unum = 19;  chip[15].unum = 22;
  for (a=0; a<4; a++)
      for (k=0; k<16; k++)  chip[k].bit[a] = 0;
  finished = false;
  errs = false;
  realtime(&h,&m,&s,&t1);
  t1 = 60*m + s;
  while( finished == false)
     { if (look(&type,&order,&bits))
#ifndef NOTIMEOUT
	 abortb("Time out in Buffer test\n");
#else
	{
	p1d("\007Time out in Buffer test -- continuing\n");
	p2d("look returned %x\n",type);
	dumptime();
	return(0);
	}
#endif
	/* PRINTF("debug vbuf: type=%0x\n",type); */
       switch(type)
	  { case vikdone: finished=true;
			  if (order!=0) buferr();
			  break;
	    case chkpt:   realtime(&h,&m,&s,&t2);
			  t2 = 60*m + s -t1;
			  if (t2<0) t2+=3600;/*see if its so late that we otta*/
			  if (t2>MAXTIME) vikstop;   /*stop request*/
			  VIKCONT;
			  /* p1m("."); */
			  break;
	    default:	  abortb("Unknown error from Viking Display test\n");
			  break;
	  }
     }
  if (errs == false) return(errs);
  p1d("\n");
  p3d("%4s\n%7s"," ","chip ->");
  for (i=0; i<=7; i++) p3d("%6s%2d","U",chip[i].unum);
  p1d("\n");
  for (k=0; k<=3; k++)
      { p3d("%-4s%-3d","bit",k);
	for (i=0; i<=7; i++)
	    { p2d("%8d",chip[i].bit[k]);
	    }
	p1d("\n");
      }
  p1d("\n");
  p3d("%4s\n%7s"," ","chip ->");
  for (i=8; i<16; i++) p3d("%6s%2d","U",chip[i].unum);
  p1d("\n");
  for (k=0; k<=3; k++)
      { p3d("%-4s%-3d","bit",k);
	for (i=8; i<16; i++)
	    p2d("%8d",chip[i].bit[k]);
	p1d("\n");
      }
  return(errs);
}

buferr()
{ UINT16 b;
  INT16 r,s,t,u;
  errs = 0xaaaa;
  for (r=0; r<64; r++)
     {	vread(&s,1,SR);
	t = r/4;
	u = r%4;
#ifndef BSD
	chip[t].bit[u] =  REV(s);
#else
	chip[t].bit[u] =  s;
#endif
     }
}
