/*
 * 5799-WZQ (C) COPYRIGHT = NONE
 * LICENSED MATERIALS - PROPERTY OF IBM
 */
/* $Header:quot.c 12.0$ */
/* $ACIS:quot.c 12.0$ */
/* $Source: /ibm/acis/usr/src/etc/RCS/quot.c,v $ */

#ifndef lint
static char *rcsid = "$Header:quot.c 12.0$";
#endif

#include <sys/nfs_defines.h>

#ifndef lint
static char *sccsid = "@(#)quot.c	4.11 (Berkeley) 85/09/09";
#endif

#ifdef VFS
/* @(#)quot.c	1.4 87/07/24 3.2/4.3NFSSRC */
#endif VFS

/*
 * quot
 */

#include <stdio.h>
#include <ctype.h>
#include <sys/param.h>
#ifdef VFS
#include <fstab.h>
#include <mntent.h>
#include <sys/time.h>
#include <sys/vnode.h>
#include <ufs/inode.h>
#include <ufs/fs.h>
#include <sys/stat.h>
#else VFS
#define vax
#include <sys/inode.h>
#undef vax
#include <sys/fs.h>
#endif VFS
#include <sys/file.h>

#define	ISIZ	(MAXBSIZE/sizeof(struct dinode))
union {
	struct fs u_sblock;
	char dummy[SBSIZE];
} sb_un;
#define sblock sb_un.u_sblock
struct dinode itab[MAXBSIZE/sizeof(struct dinode)];

struct du {
	struct	du *next;
	long	blocks;
	long	blocks30;
	long	blocks60;
	long	blocks90;
	long	nfiles;
	int	uid;
#define	NDU	2048
} du[NDU];
int	ndu;
#define	DUHASH	8209	/* smallest prime >= 4 * NDU */
#define	HASH(u)	((u) % DUHASH)
struct	du *duhash[DUHASH];

#define	TSIZE	500
int	sizes[TSIZE];
long	overflow;

int	nflg;
int	fflg;
int	cflg;
int	vflg;
int	hflg;
#ifdef VFS
int	aflg;
#endif VFS
long	now;

unsigned	ino;

char	*malloc();
char	*getname();

char	*progname;

main(argc, argv)
	int argc;
	char *argv[];
{
	register int n;

	progname = argv[0];
	now = time(0);
	argc--, argv++;
	while (argc > 0 && argv[0][0] == '-') {
		register char *cp;

		for (cp = &argv[0][1]; *cp; cp++)
			switch (*cp) {
			case 'n':
				nflg++; break;
			case 'f':
				fflg++; break;
			case 'c':
				cflg++; break;
			case 'v':
				vflg++; break;
			case 'h':
				hflg++; break;
#ifdef VFS
			case 'a':
				aflg++; break;
#endif VFS
			default:
				fprintf(stderr,
#ifndef VFS
				    "usage: %s [ -nfcvh ] [ device ... ]\n",progname);
#else !VFS			
				    "usage: %s [ -nfcvha ] [filesystem ...]\n",progname);
#endif !VFS
				exit(1);
			}
		argc--, argv++;
	}
#ifndef VFS
	if (argc == 0)
#else !VFS
	if (aflg) {
#endif !VFS
		quotall();
#ifdef VFS
	}
#endif VFS
#ifndef VFS
	while (argc-- > 0)
		if (check(*argv++, (char *)NULL) == 0)
			report();
#else !VFS
	while (argc-- > 0) {
		if (getdev(argv) == 0 && check(*argv, (char *)NULL) == 0)
			report();
		argv++;
	}
#endif !VFS
	exit (0);
}

#ifndef VFS
#include <fstab.h>

quotall()
{
	register struct fstab *fs;
	register char *cp;
	char dev[80], *rindex();

	if (setfsent() == 0) {
		fprintf(stderr, "%s: no %s file\n",progname, FSTAB);
		exit(1);
	}
	while (fs = getfsent()) {
		if (strcmp(fs->fs_type, FSTAB_RO) &&
		    strcmp(fs->fs_type, FSTAB_RW) &&
		    strcmp(fs->fs_type, FSTAB_RQ))
			continue;
		cp = rindex(fs->fs_spec, '/');
		if (cp == 0)
			continue;
		sprintf(dev, "/dev/r%s", cp + 1);
		if (check(dev, fs->fs_file) == 0)
			report();
	}
	endfsent();
}
#else !VFS
quotall()
{
	FILE *fstab;
	register struct mntent *mntp;
	register char *cp;
	char dev[80], *rindex();

	fstab = setmntent(MNTTAB, "r");
	if (fstab == NULL) {
		fprintf(stderr, "%s: no %s file \n",progname, MNTTAB);
		exit(1);
	}
	while (mntp = getmntent(fstab)) {
		if ((   (strcmp(mntp->mnt_type, MNTTYPE_42) != 0) &&
			(strcmp(mntp->mnt_type, MNTTYPE_43) != 0) &&
			(strcmp(mntp->mnt_type, MNTTYPE_UFS) != 0)   ))
			continue;
		cp = rindex(mntp->mnt_fsname, '/');
		if (cp == 0)
			continue;
		sprintf(dev, "/dev/r%s", cp + 1);
		if (check(dev, mntp->mnt_dir) == 0)
			report();
	}
	endmntent(fstab);
}
#endif !VFS

check(file, fsdir)
	char *file;
	char *fsdir;
{
	register int i, j, nfiles;
	register struct du **dp;
	daddr_t iblk;
	int c, fd;

	/*
	 * Initialize tables between checks;
	 * because of the qsort done in report()
	 * the hash tables must be rebuilt each time.
	 */
	for (i = 0; i < TSIZE; i++)
		sizes[i] = 0;
	overflow = 0;
	for (dp = duhash; dp < &duhash[DUHASH]; dp++)
		*dp = 0;
	ndu = 0;
	fd = open(file, O_RDONLY);
	if (fd < 0) {
		fprintf(stderr, "%s: ",progname);
		perror(file);
		return (-1);
	}
	printf("%s", file);
	if (fsdir == NULL) {
		register struct fstab *fs = getfsspec(file);
		if (fs != NULL)
			fsdir = fs->fs_file;
	}
	if (fsdir != NULL && *fsdir != '\0')
		printf(" (%s)", fsdir);
	printf(":\n");
	sync();
	bread(fd, SBLOCK, (char *)&sblock, SBSIZE);
	if (nflg) {
		if (isdigit(c = getchar()))
			ungetc(c, stdin);
		else while (c != '\n' && c != EOF)
			c = getchar();
	}
	nfiles = sblock.fs_ipg * sblock.fs_ncg;
	for (ino = 0; ino < nfiles; ) {
		iblk = fsbtodb(&sblock, itod(&sblock, ino));
		bread(fd, iblk, (char *)itab, sblock.fs_bsize);
		for (j = 0; j < INOPB(&sblock) && ino < nfiles; j++, ino++) {
			if (ino < ROOTINO)
				continue;
			acct(&itab[j]);
		}
	}
	close(fd);
	return (0);
}

acct(ip)
	register struct dinode *ip;
{
	register struct du *dp;
	struct du **hp;
	long blks, frags, size;
	int n;
	static fino;

	if ((ip->di_mode & IFMT) == 0)
		return;
	/*
	 * By default, take block count in inode.  Otherwise (-h),
	 * take the size field and estimate the blocks allocated.
	 * The latter does not account for holes in files.
	 */
	if (!hflg)
		size = ip->di_blocks / 2;
	else {
		blks = lblkno(&sblock, ip->di_size);
		frags = blks * sblock.fs_frag +
			numfrags(&sblock, dblksize(&sblock, ip, blks));
		size = frags * sblock.fs_fsize / 1024;
	}
	if (cflg) {
		if ((ip->di_mode&IFMT) != IFDIR && (ip->di_mode&IFMT) != IFREG)
			return;
		if (size >= TSIZE) {
			overflow += size;
			size = TSIZE-1;
		}
		sizes[size]++;
		return;
	}
	hp = &duhash[HASH(ip->di_uid)];
	for (dp = *hp; dp; dp = dp->next)
		if (dp->uid == ip->di_uid)
			break;
	if (dp == 0) {
		if (ndu >= NDU)
			return;
		dp = &du[ndu++];
		dp->next = *hp;
		*hp = dp;
		dp->uid = ip->di_uid;
		dp->nfiles = 0;
		dp->blocks = 0;
		dp->blocks30 = 0;
		dp->blocks60 = 0;
		dp->blocks90 = 0;
	}
	dp->blocks += size;
#define	DAY (60 * 60 * 24)	/* seconds per day */
	if (now - ip->di_atime > 30 * DAY)
		dp->blocks30 += size;
	if (now - ip->di_atime > 60 * DAY)
		dp->blocks60 += size;
	if (now - ip->di_atime > 90 * DAY)
		dp->blocks90 += size;
	dp->nfiles++;
	while (nflg) {
		register char *np;

		if (fino == 0)
			if (scanf("%d", &fino) <= 0)
				return;
		if (fino > ino)
			return;
		if (fino < ino) {
			while ((n = getchar()) != '\n' && n != EOF)
				;
			fino = 0;
			continue;
		}
		if (np = getname(dp->uid))
			printf("%.7s	", np);
		else
			printf("%d	", ip->di_uid);
		while ((n = getchar()) == ' ' || n == '\t')
			;
		putchar(n);
		while (n != EOF && n != '\n') {
			n = getchar();
			putchar(n);
		}
		fino = 0;
		break;
	}
}

bread(fd, bno, buf, cnt)
	unsigned bno;
	char *buf;
{

	lseek(fd, (long)bno * DEV_BSIZE, L_SET);
	if (read(fd, buf, cnt) != cnt) {
		fprintf(stderr, "%s: read error at block %u\n",progname, bno);
		exit(1);
	}
}

qcmp(p1, p2)
	register struct du *p1, *p2;
{
	char *s1, *s2;

	if (p1->blocks > p2->blocks)
		return (-1);
	if (p1->blocks < p2->blocks)
		return (1);
	s1 = getname(p1->uid);
	if (s1 == 0)
		return (0);
	s2 = getname(p2->uid);
	if (s2 == 0)
		return (0);
	return (strcmp(s1, s2));
}

report()
{
	register i;
	register struct du *dp;

	if (nflg)
		return;
	if (cflg) {
		register long t = 0;

		for (i = 0; i < TSIZE - 1; i++)
			if (sizes[i]) {
				t += i*sizes[i];
				printf("%d	%d	%D\n", i, sizes[i], t);
			}
		printf("%d	%d	%D\n",
		    TSIZE - 1, sizes[TSIZE - 1], overflow + t);
		return;
	}
	qsort(du, ndu, sizeof (du[0]), qcmp);
	for (dp = du; dp < &du[ndu]; dp++) {
		register char *cp;

		if (dp->blocks == 0)
			return;
		printf("%5D\t", dp->blocks);
		if (fflg)
			printf("%5D\t", dp->nfiles);
		if (cp = getname(dp->uid))
			printf("%-8.8s", cp);
		else
			printf("#%-8d", dp->uid);
		if (vflg)
			printf("\t%5D\t%5D\t%5D",
			    dp->blocks30, dp->blocks60, dp->blocks90);
		printf("\n");
	}
}

#ifndef VFS
/* rest should be done with nameserver or database */
#endif !VFS

#include <pwd.h>
#ifndef VFS
#include <grp.h>
#endif VFS
#include <utmp.h>

struct	utmp utmp;
#ifndef VFS
#define	NMAX	(sizeof (utmp.ut_name))
#define SCPYN(a, b)	strncpy(a, b, NMAX)

#define NUID	64	/* power of 2 */
#define UIDMASK	0x3f
#else !VFS
#define	NUID	2048
#define	NMAX	(sizeof (utmp.ut_name))
#endif !VFS

#ifndef VFS
struct ncache {
	int	uid;
	char	name[NMAX+1];
} nc[NUID];
#else !VFS
char	names[NUID][NMAX+1];
#endif !VFS
char	outrangename[NMAX+1];
int	outrangeuid = -1;

#ifndef VFS
char *
getname(uid)
	int uid;
{
	register struct passwd *pw;
	struct passwd *getpwent();
	extern int _pw_stayopen;
	register int cp;

	_pw_stayopen = 1;
	cp = uid & UIDMASK;
	if (uid >= 0 && nc[cp].uid == uid && nc[cp].name[0])
		return (nc[cp].name);
	pw = getpwuid(uid);
	if (!pw)
		return (0);
	nc[cp].uid = uid;
	SCPYN(nc[cp].name, pw->pw_name);
	return (nc[cp].name);
}
#else !VFS
char *
getname(uid)
	int uid;
{
	register struct passwd *pw;
	static init;
	struct passwd *getpwent();
	
	if (uid >= 0 && uid < NUID && names[uid][0])
		return (&names[uid][0]);
	if (uid >= 0 && uid == outrangeuid)
		return (outrangename);
rescan:
	if (init == 2) {
		if (uid < NUID)
			return (0);
		setpwent();
		while (pw = getpwent()) {
			if (pw->pw_uid != uid)
				continue;
			outrangeuid = pw->pw_uid;
			strncpy(outrangename, pw->pw_name, NMAX);
			endpwent();
			return (outrangename);
		}
		endpwent();
		return (0);
	}
	if (init == 0)
		setpwent(), init = 1;
	while (pw = getpwent()) {
		if (pw->pw_uid < 0 || pw->pw_uid >= NUID) {
			if (pw->pw_uid == uid) {
				outrangeuid = pw->pw_uid;
				strncpy(outrangename, pw->pw_name, NMAX);
				return (outrangename);
			}
			continue;
		}
		if (names[pw->pw_uid][0])
			continue;
		strncpy(names[pw->pw_uid], pw->pw_name, NMAX);
		if (pw->pw_uid == uid)
			return (&names[uid][0]);
	}
	init = 2;
	goto rescan;
}

getdev(devpp)
	char **devpp;
{
	struct stat statb;
	FILE *fstab;
	struct mntent *mntp;
	
	if (stat(*devpp, &statb) < 0) {
		perror(*devpp);
		return (-1);
	}
	if ((statb.st_mode & S_IFMT) == S_IFBLK ||
	    (statb.st_mode & S_IFMT) == S_IFCHR)
		return (0);
	fstab = setmntent(MNTTAB, "r");
	if (fstab == NULL) {
		fprintf(stderr, "%s: no %s file\n",progname, MNTTAB);
		exit(1);
	}
	while (mntp = getmntent(fstab)) {
		if (strcmp(mntp->mnt_dir, *devpp) == 0) {
			if ((   (strcmp(mntp->mnt_type, MNTTYPE_42) != 0) &&
				(strcmp(mntp->mnt_type, MNTTYPE_43) != 0) &&
				(strcmp(mntp->mnt_type, MNTTYPE_UFS) != 0) )) {
				fprintf(stderr,
				    "%s: %s not 4.3 filesystem\n",
				    progname, *devpp);
				return (-1);
			}
			*devpp = malloc(strlen(mntp->mnt_fsname) + 1);
			strcpy(*devpp, mntp->mnt_fsname);
			endmntent(fstab);
			return (0);
		}
	}
	endmntent(fstab);
	return (-1);
}
#endif !VFS

