/*
 * stdio.h
 *
 * defines the structure used by the level 2 I/O ("standard I/O") routines
 * and some of the associated values and macros.
 *
 * Copyright (C) Microsoft Corporation, 1984
 */

#define  BUFSIZ  512
#define  _NFILE  20
#define  FILE    struct _iobuf
#define  EOF     (-1)

#ifdef M_I86LM
#define  NULL    0L
#else
#define  NULL    0
#endif

extern FILE {
	char *_ptr;
	int   _cnt;
	char *_base;
	char  _flag;
	char  _file;
	} _iob[_NFILE];

#define  stdin   (&_iob[0])
#define  stdout  (&_iob[1])
#define  stderr  (&_iob[2])

#define  _IOREAD    0x01
#define  _IOWRT     0x02
#define  _IONBF     0x04
#define  _IOMYBUF   0x08
#define  _IOEOF     0x10
#define  _IOERR     0x20
#define  _IOSTRG    0x40
#define  _IORW      0x80

#define  getc(f)    (--(f)->_cnt >= 0 ? 0xff & *(f)->_ptr++ : _filbuf(f))
#define  putc(c,f)  (--(f)->_cnt >= 0 ? 0xff & (*(f)->_ptr++ = (c)) : \
		     _flsbuf((c),(f)))

#define  getchar()   getc(stdin)
#define  putchar(c)  putc((c),stdout)

#define  feof(f)     ((f)->_flag & _IOEOF)
#define  ferror(f)   ((f)->_flag & _IOERR)
#define  fileno(f)   ((f)->_file)

FILE *fopen(), *freopen(), *fdopen();
long tell(), ftell();
char *gets(), *fgets();
