/*
 * signal.h
 *
 * define signal values.  Only SIGINT is recognized on DOS.
 *
 * Copyright (C) Microsoft Corporation, 1984
 */

#define NSIG 17

#define SIGHUP  1
#define SIGINT  2       /* interrupt - corresponds to DOS int 23H */
#define SIGQUIT 3
#define SIGILL  4
#define SIGTRAP 5
#define SIGIOT  6
#define SIGEMT  7
#define SIGFPE  8       /* floating point exception */
#define SIGKILL 9       /* kill (cannot be caught or ignored) */
#define SIGBUS  10
#define SIGSEGV 11
#define SIGSYS  12
#define SIGPIPE 13
#define SIGALRM 14
#define SIGTERM 15

int (*signal())();
#define SIG_DFL (int (*)())0
#define SIG_IGN (int (*)())1
