/*
 * assert.h
 *
 * defines the assert macro.  Relies on the fact that stderr always has
 * a file handle of 2 to avoid requiring the inclusion of stdio.h whenever
 * assert.h is included.
 *
 * Copyright (C) Microsoft Corporation, 1984
 */

#ifndef NDEBUG
#define assert(x) { \
	if (!(x)) { \
		fprintf(2,"Assertion failed: file %s, line %d\n", __FILE__, __LINE__); \
		exit(1); \
		} \
	}
#else
#define assert(x)
#endif
