/*
 *	@(#) h/stat.h 1.2 84/09/16 Copyright Microsoft Corporation, 1983
 *
 *	Copyright (C) Microsoft Corporation, 1983
 *
 *	This Module contains Proprietary Information of Microsoft
 *	Corporation and AT&T, and should be treated as Confidential.
 */
/*
 *	@(#) h/stat.h 1.2 84/09/16 Copyright Microsoft Corporation, 1983
 */




/*
 * THIS FILE CONTAINS CODE WHICH IS DESIGNED TO BE
 * PORTABLE BETWEEN DIFFERENT MACHINE ARCHITECTURES
 * AND CONFIGURATIONS. IT SHOULD NOT REQUIRE ANY
 * MODIFICATIONS WHEN ADAPTING XENIX TO NEW HARDWARE.
 */



/***	stat.h
 *
 *	MODIFICATION HISTORY
 *	M000	14 Apr 83	andyp
 *	- 3.0 upgrade. (uncommented). Dropped multiplexed file stuff.
 *	  Added semaphores.  Added comments.  st_uid, st_gid changed
 *	  from short to ushort.
 */

/***	stat -- structure returned by stat, fstat system calls.
 *
 */

struct stat {	/* see stat(2) */
	dev_t	st_dev;		/* id of device containing directory entry */
	ino_t	st_ino;		/* inode number */
	ushort	st_mode;	/* file mode, see mknod(2) */
	short	st_nlink;	/* # of links */
	ushort	st_uid;		/* owner uid */
	ushort	st_gid;		/* owner gid */
	dev_t	st_rdev;	/* id of device.  Only defined for character
				 * and block special files.
				 */
	off_t	st_size;	/* file size in bytes */
		/* all times measured in seconds since 'the epoch' */
	time_t	st_atime;	/* time of last access */
	time_t	st_mtime;	/* time of last data modification */
	time_t	st_ctime;	/* time of last file status 'change' */
};

#define	S_IFMT	0170000		/* type of file */
#define		S_IFDIR	0040000	/* directory */
#define		S_IFCHR	0020000	/* character special */
#define		S_IFBLK	0060000	/* block special */
#define		S_IFREG	0100000	/* regular */
#define		S_IFIFO	0010000	/* fifo */
#define		S_IFNAM	0050000	/* name space entry */
#define	S_INSEM		01	/* semaphore */
#define	S_INSHD		02	/* shared memory */
#define	S_ISUID	04000		/* set user id on execution */
#define	S_ISGID	02000		/* set group id on execution */
#define	S_ISVTX	01000		/* save swapped text even after use */
#define	S_IREAD	00400		/* read permission, owner */
#define	S_IWRITE	00200	/* write permission, owner */
#define	S_IEXEC	00100		/* execute/search permission, owner */
