/*
 *	@(#) h/inode.h 1.5 84/09/16 Copyright Microsoft Corporation, 1983
 *
 *	Copyright (C) Microsoft Corporation, 1983
 *
 *	This Module contains Proprietary Information of Microsoft
 *	Corporation and AT&T, and should be treated as Confidential.
 */
/*
 *	@(#) h/inode.h 1.5 84/09/16 Copyright Microsoft Corporation, 1983
 */




/*
 * THIS FILE CONTAINS CODE WHICH IS DESIGNED TO BE
 * PORTABLE BETWEEN DIFFERENT MACHINE ARCHITECTURES
 * AND CONFIGURATIONS. IT SHOULD NOT REQUIRE ANY
 * MODIFICATIONS WHEN ADAPTING XENIX TO NEW HARDWARE.
 */



/*
 * The I node is the focus of all
 * file activity in unix. There is a unique
 * inode allocated for each active file,
 * each current directory, each mounted-on
 * file, text file, and the root. An inode is 'named'
 * by its dev/inumber pair. (iget/iget.c)
 * Data, from mode on, is read in
 * from permanent inode on volume.
 */

#define	NADDR	13
#define	NSADDR	(NADDR*sizeof(daddr_t)/sizeof(short))

/* file dependent part for named files */

struct iisem {              /* semaphore */
    int  i_scount;          /* current semaphore count */
    int  i_eflag;           /* err flg */
    struct file *i_headw;   /* first waiter */
    struct file *i_tailw;   /* last waiter */
};

struct iisd {                /* shared data */
    mloc_t   i_buf;          /* address of kernel copy */
    unsigned i_limit;        /* limit (size (in bytes) - 1) of segment */
    int      i_vnum;         /* version number */
    int      i_snum;         /* serial # for getv, waitv */
    int      i_flags;        /* LOCKED, etc. */
    short    i_daddr;        /* swap (disk) address of shared segment */
    char     i_ccount;	     /* number of loaded references */
};

struct  inode {
	char    i_flag;
	cnt_t	i_count;	/* reference count */
	dev_t	i_dev;		/* device where inode resides */
	ino_t	i_number;	/* i number, 1-to-1 with device address */
	ushort	i_mode;
	short	i_nlink;	/* directory entries */
	ushort	i_uid;		/* owner */
	ushort	i_gid;		/* group of owner */
	off_t	i_size;		/* size of file */
	union {                 /* file type dependent section */
	    struct {                /* files which have data blocks */
		union {
		    daddr_t i_a[NADDR];     /* if normal file/directory */
		    short   i_f[NSADDR];    /* if fifio's */
		} i_p;
		daddr_t i_l;                /* last logical block read (for read-ahead) */
	    } i_blks;
	    struct {                /* name type files */
		long i_type;
		union {
		    struct iisem i_sem;
		    struct iisd i_sd;
		} i_ndata;
	    } i_namef;
	} i_fdep;
	struct  locklist *i_locklist;  /* locked region list */
};


extern struct inode inode[];	/* The inode table itself */

/* flags */
#define	ILOCK	01		/* inode is locked */
#define	IUPD	02		/* file has been modified */
#define	IACC	04		/* inode access time to be updated */
#define	IMOUNT	010		/* inode is mounted on */
#define	IWANT	020		/* some process waiting on lock */
#define	ITEXT	040		/* inode is pure text prototype */
#define	ICHG	0100		/* inode has been changed */

/* modes */
#define	IFMT	0170000		/* type of file */
#define		IFDIR	0040000	/* directory */
#define		IFCHR	0020000	/* character special */
#define		IFBLK	0060000	/* block special */
#define		IFREG	0100000	/* regular */
#define		IFMPC	0030000	/* multiplexed char special */
#define		IFMPB	0070000	/* multiplexed block special */
#define		IFIFO	0010000	/* fifo special */
#define         IFNAM   0050000 /* name special */
#define	ISUID	04000		/* set user id on execution */
#define	ISGID	02000		/* set group id on execution */
#define ISVTX	01000		/* save swapped text even after use */
#define	IREAD	0400		/* read, write, execute permissions */
#define	IWRITE	0200
#define	IEXEC	0100

#define i_addr  i_fdep.i_blks.i_p.i_a
#define i_lastr i_fdep.i_blks.i_l
#define i_rdev  i_fdep.i_blks.i_p.i_a[0]

#define i_faddr i_fdep.i_blks.i_p.i_a
#define	NFADDR	10
#define	PIPSIZ	NFADDR*BSIZE
#define i_frptr i_fdep.i_blks.i_p.i_f[NSADDR-5]
#define i_fwptr i_fdep.i_blks.i_p.i_f[NSADDR-4]
#define i_frcnt i_fdep.i_blks.i_p.i_f[NSADDR-3]
#define i_fwcnt i_fdep.i_blks.i_p.i_f[NSADDR-2]
#define i_fflag i_fdep.i_blks.i_p.i_f[NSADDR-1]
#define	IFIR	01
#define	IFIW	02

/* types for IFNAM type files */
#define IFSEM   1L              /* semaphore type */
#define IFSHD   2L              /* shared data */
#define IFXXX	3L		/* Reserved for future use by Microsoft */
