/*
 *	@(#) h/tty.h 1.2 84/09/16 Copyright Microsoft Corporation, 1983
 *
 *	Copyright (C) Microsoft Corporation, 1983
 *
 *	This Module contains Proprietary Information of Microsoft
 *	Corporation and AT&T, and should be treated as Confidential.
 */
/*
 *	@(#) h/tty.h 1.2 84/09/16 Copyright Microsoft Corporation, 1983
 */




/*
 * THIS FILE CONTAINS CODE WHICH IS DESIGNED TO BE
 * PORTABLE BETWEEN DIFFERENT MACHINE ARCHITECTURES
 * AND CONFIGURATIONS. IT SHOULD NOT REQUIRE ANY
 * MODIFICATIONS WHEN ADAPTING XENIX TO NEW HARDWARE.
 */



#include	"termio.h"

/*
 * A clist structure is the head of a linked list queue of characters.
 * The routines getc* and putc* manipulate these structures.
 */
struct clist {
	int	c_cc;		/* character count */
	struct cblock	*c_cf;	/* pointer to first */
	struct cblock	*c_cl;	/* pointer to last */
};

/*
 * A tty structure is needed for each UNIX character device that
 * is used for normal terminal IO.
 */
struct tty {
	struct clist	t_rawq;	/* raw input queue */
	struct clist	t_canq;	/* canonical queue */
	struct clist	t_outq;	/* output queue */
	struct cblock	*t_buf;	/* buffer pointer */
	int	(*t_proc)();	/* routine for device functions */
	ushort	t_iflag;	/* input modes */
	ushort	t_oflag;	/* output modes */
	ushort	t_cflag;	/* control modes */
	ushort	t_lflag;	/* line discipline modes */
	short	t_state;	/* internal state */
	short	t_pgrp;		/* process group name */
	char	t_line;		/* line discipline */
	char	t_delct;	/* delimiter count */
	char	t_col;		/* current column */
	char	t_row;		/* current row */
	uchar_t	t_cc[NCC+2];	/* settable control chars */
};

/*
 * The structure of a clist block
 */
#define	CLSIZE	24
struct cblock {
	struct cblock	*c_next;
	char	c_first;
	char	c_last;
	char	c_data[CLSIZE];
};

extern	struct cblock	cfree[];
extern	struct cblock	*getcb();
extern	struct cblock	*getcf();
extern	struct clist	ttnulq;

struct chead {
	struct cblock	*c_next;
	int	c_size;
};
extern	struct chead	cfreelist;

struct inter {
	int	cnt;
};

/* control characters */	/* pick up from termio.h */

/* default control chars */	/* pick up from termio.h */

#define	TTIPRI	28
#define	TTOPRI	29

/* limits */
extern	int	ttlowat[], tthiwat[];
#define	TTYHOG	256
#define	TTXOLO	60
#define	TTXOHI	180

/* input modes */		/* pick up from termio.h */

/* output modes */		/* pick up from termio.h */

/* control modes */		/* pick up from termio.h */

/* line discipline 0 modes */	/* pick up from termio.h */

/* default speed */		/* pick up from termio.h */

/* Hardware bits */
#define	DONE	0200
#define	IENABLE	0100
#define	OVERRUN	040000
#define	FRERROR	020000
#define	PERROR	010000

/* Internal state */
#define	TIMEOUT	01		/* Delay timeout in progress */
#define	WOPEN	02		/* Waiting for open to complete */
#define	ISOPEN	04		/* Device is open */
#define	TBLOCK	010
#define	CARR_ON	020		/* Software copy of carrier-present */
#define	BUSY	040		/* Output in progress */
#define	OASLP	0100		/* Wakeup when output done */
#define	IASLP	0200		/* Wakeup when input done */
#define	TTSTOP	0400		/* Output stopped by ctl-s */
#define	EXTPROC	01000		/* External processing */
#define	TACT	02000
#define	ESC	04000		/* Last char escape */
#define	RTO	010000
#define	TTIOW	020000
#define	TTXON	040000
#define	TTXOFF	0100000

/* l_output status */
#define	CPRES	1

/* device commands */
#define	T_OUTPUT	0
#define	T_TIME		1
#define	T_SUSPEND	2
#define	T_RESUME	3
#define	T_BLOCK		4
#define	T_UNBLOCK	5
#define	T_RFLUSH	6
#define	T_WFLUSH	7
#define	T_BREAK		8
