 '       IBM BASIC Compiler/2 ISAM Demonstration -- Include File (MAIL.INC)
 '

TYPE RecStruc		       'the structure of each record in the file
    LastName	as STRING*15   'used as first key
    FirstName	as STRING*10   'used as first key
    address	as STRING*30
    zip 	as LONG        '1st component of split key 2
    sex 	as STRING*1    '2nd component of split key 2
    age 	as INTEGER
    income	as LONG        '3rd component of split key 2
END TYPE

TYPE SplitKey		       'the structure of the split key
    zip 	as LONG        '1st component of split key
    sex 	as STRING*1    '2nd component of split key
    income	as LONG        '3rd component of split key
END TYPE

 '$include:'isam.inc'
DIM RecDes as RecordDescriptor
DIM KeyDes(6) as FieldDescriptor
DIM ML as RecStruc  : DIM SearchKey as SplitKey
DEFINT A-Z
 '
 '  isam record description
 '
RecDes.nfields = 6		   '2 keys - 6 fields defined
RecDes.flags   = 0		   'non-segmented
RecDes.minAllocation = 0	   'default record allocation - 8 bytes
 '
 '  description of first key within record
 '
KeyDes(1).fName    = "NAME"        'Name of 1st key field
KeyDes(1).dType    = IT.STRING%    'character string (IT.STRING%=5)
KeyDes(1).Segment  = 1		   'in segment 1
KeyDes(1).Position = 1		   'position 1 of record
KeyDes(1).Length   = 25 	   'Length of field is 25 bytes
KeyDes(1).Handle   = 1		   'key number is 1
KeyDes(1).Flags    = 1281	   'duplicates allowed, case insensitive
KeyDes(1).reserved = 0		   'reserved -- set to zero
 '
 '  description of second key within record
 '
KeyDes(2).fName    = "ZIP"         '1st part of split key
KeyDes(2).dType    = IT.LONG%	   'long integer (IT.LONG%=14)
KeyDes(2).Segment  = 1		   'in segment 1
KeyDes(2).Position = 56 	   'Start of key is at 56th byte of rec.
KeyDes(2).Length   = 4		   'Length of the field is 4 bytes
KeyDes(2).Handle   = 2		   'This is key number 2
KeyDes(2).Flags    = 258	   'duplicates allowed, split key
KeyDes(2).reserved = 0		   'reserved -- set to 0
 '
KeyDes(3).fName    = "SEX"         '2nd part of split key
KeyDes(3).dType    = IT.STRING%    'character string (IT.STRING%=5)
KeyDes(3).Segment  = 1		   'in segment 1
KeyDes(3).Position = 60 	   'Start of key is at 6Oth byte of rec.
KeyDes(3).Length   = 1		   'Length of the field is 1 byte
KeyDes(3).Handle   = 2		   'This is key number 2
KeyDes(3).Flags    = 1282	   'duplicates allowed, case insensitive, split
KeyDes(3).reserved = 0		   'reserved -- set to 0
 '
KeyDes(4).fName    = "INCOME"      '3rd part of split key
KeyDes(4).dType    = IT.LONG%	   'long integer (IT.LONG%=14)
KeyDes(4).Segment  = 1		   'in segment 1
KeyDes(4).Position = 63 	   'Start of key is at 63rd byte of rec.
KeyDes(4).Length   = 4		   'Length of the field is 4 bytes
KeyDes(4).Handle   = 2		   'This is key number 2
KeyDes(4).Flags    = 258	   'duplicates allowed, split key
KeyDes(4).reserved = 0		   'reserved -- set to 0
 '
 ' Non keyed fields
KeyDes(5).fName    = "ADDRESS"     'Field name
KeyDes(5).dType    = IT.STRING%    'character string (IT.STRING%=5)
KeyDes(5).Segment  = 1		   'in segment 1
KeyDes(5).Position = 26 	   'Start of key is at 26th byte of rec.
KeyDes(5).Length   = 30 	   'Length of key field is 30 bytes
KeyDes(5).Handle   = 0		   'This is not a key field
KeyDes(5).Flags    = 0		   'non key field
KeyDes(5).reserved = 0		   'reserved -- set to 0
 '
KeyDes(6).fName    = "AGE"         'Field name
KeyDes(6).dType    = IT.INTEGER%   'integer (IT.INTEGER%=1)
KeyDes(6).Segment  = 1		   'in segment 1
KeyDes(6).Position = 61 	   'Start of key is at 62nd byte of rec.
KeyDes(6).Length   = 2		   'Length of key field is 2 bytes
KeyDes(6).Handle   = 0		   'This is not a key field
KeyDes(6).Flags    = 0		   'non key field
KeyDes(6).reserved = 0		   'reserved -- set to 0
 '
 '
keynum=1			   'current key (Name)
RecLen=LEN(ML)			   'the length of the isam record
 '
 ' ----- End of include file -----
