'                IBM Personal Computer -- BASIC Compiler/2
'                       ISAM Demonstration Program
'
'
'       This example program shows a realistic application using ISAM
'       and the advanced features of BASIC.  You will note that much of
'       this program is involved in the user interface.  This is because
'       the ISAM interface is powerful and yet simple.
'
'       The program solves the following problem.  Zeck, French and Rowe
'       advertising agency maintain and have access to a large data base
'       of names that they want to sell to various clients.  The two basic
'       requirements are:
'
'               - be able to maintain the data base.  That is
'                 add, delete and update individual records
'
'               - generate mailing lists tailored to each clients needs.
'                 (ie - give me all all the people in Grand Island NY over 30)
'
'       The program is organized into 4 sections:
'
'               - the main menu.  Selects one of the three major functions.
'
'               - create and open a new data base, or open an existing
'                 data base.
'
'               - update the data base.  The available functions are:
'                 Add a new record, Delete an existing one, selectively
'                 update an existing one.  You are able to search for
'                 a record and move to the next/previous one.
'
'               - print out the data base.  There are 4 selection criteria
'                 to limit the number of records printed.
'


'$Include: 'mail.inc'

ENTER$ = chr$(13)


'               Function Definitions
'=========================================================================

def FNcheck.open:		'Check to make sure the data base is open

   if filenum <> -1 then _
       Fncheck.open = -1: Exit def

   call mess("There is no open data base. Press SPACE to continue ..")
   call get.key(23, 78, " ")
   FnCheck.open = 0

end def

Def FNget.string$(lin, col, prompt$)	'Get an input at line & col putting a
					'print prompt on the status line
    call mess(prompt$)
    if col > 55 then nspace = 80 - col else nspace = 25
    locate lin, col: print string$(nspace, 32)	'clear out old value
    locate lin, col
    line input "",C$
    FNget.string$ = Ucase$(C$)

end def


Def FNupdate.string$(lin, col, oldval$) 'Get an input at line & col
					'if there is no input return oldval
    locate lin, col
    line input "",c$

    if c$ = "" then _
	FNupdate.string$ = oldval$ _
    else _
	FNupdate.string$ = UCASE$(c$)

end def

Def FNcheck.Comma$(s$)			'Insure there is a comma in the string
					'add one if there isn't one
    if instr(s$, ",") = 0 then s$ = s$ + ","
    FNcheck.Comma$ = s$

end def
'


begin:				'Start main line code
'=========================================================================

filenum = -1			'Isam file is closed

'Print out a little Banner

mess1$ = "IBM Personal Computer -- BASIC Compiler/2"
mess2$ = "           ISAM Demonstration"

cls
for i=2 to 22

    locate 8, i-1: print " " mess1$;
    locate 9, i-1: print " " mess2$;
next i

locate 7, 20: print string$(45, 205);
locate 10, 20: print string$(45, 205)

for i=1 to 400: x = sin(i): next i	'Delay loop

while c$ <> "E"

'       Redraw the main menu

    cls
    locate 1,20: print chr$(201)+string$(33, 205)+chr$(187);
    locate 2,20: print chr$(186)+"     Zeck,  French  &  Rowe      "+chr$(186);
    locate 3,20: print chr$(186)+"       Advertising Agency        "+chr$(186);
    locate 4,20: print chr$(200)+string$(33, 205)+chr$(188);

    color 15,2
    locate 6,23: print "Direct Mailing Referral System"
    color 2,0

    locate 10, 25: print "Name of Data Base: ";
    color 15,2: print dbName$;: color 2, 0

    locate 12, 27: print " Press O to Open Data Base";
    locate 13, 27: print " Press U to Update Data Base";
    locate 14, 27: print " Press P to Print Mailing Labels";
    locate 15, 27: print " Press E to Exit System";

    locate 17, 25: print "Enter your selection _";

    call get.key(17, 46, "OUPE")

    'Decide which function is requested

    If C$ = "O" then gosub open.db _
    else If C$ = "U" then gosub update.db _
    else If C$ = "P" then gosub print.db

wend		'   End of main.loop

gosub closedb
end
'


open.db:	'Try to open the data base.  If the data base does not
		'exist, then create a new one and open it.
'=======================================================================


    gosub closedb

    locate 23, 1: print string$(80, 32);		'Clear line first
    locate 23, 1: Input "Name of the data base"; dbName$
    filenum=miopen(dbName$, io.update%) 		'io.update% = 2
    if ixstat = 0 then return

    if ixstat <> 7 then gosub isamErr: return

    locate 24, 1: print "Creating a new data base ....            ";

    'The data base doesn't exist so create the data base

    status=micreate(dbname$, RecDes, KeyDes(1))
    if ixstat <> 0 then gosub isamErr

    filenum=miopen(dbname$, io.update%)
    if ixstat <> 0 then gosub isamErr

    return

closedb:			'Close any open data base

    if filenum = -1 then return

    status=miclose(filenum)
    if ixstat <> 0 then gosub isamErr

    filenum = -1
    return
'



update.db:			'ADD or delete records from the data base
'==========================================================================


    if not Fncheck.open then return

    cls
    locate 1, 20: print "Update the " dbName$ " data base ";

    locate 5, 7: print "Last Name:                                  First Name:";
    locate 6, 7: print "Address:                                    Zip:";

    locate 8, 30: print "Market Selectors";
    locate 9, 1: print string$(80, 205);

    locate 13, 7: print "Sex                                        Income";
    locate 14, 7: print "Age";

    locate 18, 5: print "Options are: Add, Delete or Update person."
    locate 19, 5: print "             Search for, move to Next or Previous person.";
    locate 20, 5: print "             Exit to main menu";
    locate 22, 20: print "Enter Selection";

    status=miseek(filenum, keynum, 0, 25, is.first%)   'Seek to the first record
    gosub read.record

    while(c$ <> "E")

	call get.key(22, 36, "ADUESNP")
	gosub redraw.form

	if c$ = "A" then gosub add.record _
	else if c$ = "D" then gosub delet.record _
	else if c$ = "U" then gosub update.record _
	else if c$ = "S" then gosub search.record _
	else if c$ = "N" then gosub next.record _
	else if c$ = "P" then gosub previous.record
    wend

    c$ = ""
    return



redraw.form:			'Print out the current values in the record

    locate 5, 20: print ML.LastName;
    locate 5, 65: print ML.FirstName;
    locate 6, 20: print ML.address;
    locate 6, 65: print ML.zip;
    locate 13, 20: print ML.sex;
    locate 13, 65: print using "$$##,###"; ML.income;
    locate 14, 20: print using "##"; ML.age;
    return

delet.record:			'Delete the current record

    status=midelete(filenum)
    goto read.record

update.record:			'Modify the current values of a record
    ML.LastName = FNupdate.string$(5, 20, ML.LastName)
    ML.FirstName = FNupdate.string$(5, 65, ML.FirstName)
    ML.address = FNcheck.Comma$(FNupdate.string$(6, 20, ML.address))
    ML.zip = Val(FNupdate.string$(6, 65, str$(ML.zip) ))


    ML.sex = FNupdate.string$(13, 20, ML.sex)
    ML.age = Val(FNupdate.string$(14, 20, str$(ML.age) ))
    ML.income = Val(FNupdate.string$(13, 65, str$(ML.income) ))

    status=mirewrite(filenum, ML, RecLen)
    if not (ixstat = 0 or ixstat = 12) then gosub isamErr

    gosub redraw.form
    return

add.record:			'Add a new record to the file

    ML.LastName = FNget.string$(5, 20, "Last Name")
    ML.FirstName = FNget.string$(5, 65, "First Name")
    ML.address = FNcheck.Comma$(FNget.string$(6,20,"Address, City STATE"))
    ML.zip = Val(FNget.string$(6, 65, "Zip"))

    ML.sex = FNget.string$(13, 20, "Male Female")
    ML.age = Val(FNget.string$(14, 20, "Age"))
    ML.income = Val(FNget.string$(13, 65, "Income"))

    status=miwrite(filenum, ML, RecLen)
    if not (ixstat = 0 or ixstat = 12) then gosub isamErr

    gosub redraw.form
    return


search.record:			'Search for a new record

    ML.LastName = FNget.string$(5, 20, "Last Name")
    ML.FirstName = FNget.string$(5, 65, "First Name")

    status=misavefp(filenum)

    status=miseek(filenum, 1, ML, 25, is.equal%)
    if ixstat = 10 then _
	call mess("Name not found"): status=mirestorefp(filenum): return

    goto read.record		'Common code for next/previous

next.record:			'move the next record

    status=minext(filenum, keynum)
    goto read.record		'Common code for next/previous

previous.record:		'move to the previous

    status=miprev(filenum, keynum)

read.record:
    if ixstat = 11 then call mess("Beginning/End of Data file reached"): return
    if (ixstat <> 0 and ixstat <> 12) then gosub isamErr: return

    length=miread(filenum, ML, RecLen)
    if ixstat <> 0 then gosub isamErr: return

    gosub redraw.form
    return
'


print.db:		'Print out select records of the db
'==========================================================================

    if not Fncheck.open then return
    cls
    locate 1, 10: print "Print Mailing labels Market Selection";

    locate 3, 5: print "Do you Want output to Printer or File:";
    call get.key(3, 52, "PF")

    if c$ = "P" then outName$ = "prn"
    if c$ = "F" then locate 4, 17: Input "File Name: ",outName$

    call mess("Press RETURN for all Zips")
    locate 6, 5:  Input "Enter Lower Zip code: ",Select.Zip.Low&
    locate 6, 40: Input "Enter Upper Zip code: ",Select.Zip.High&
    if Select.Zip.High& = 0 then Select.Zip.High& = 99999

    call mess("Press RETURN for any Sex")
    locate 8, 5: print "Males, Females:";
    call get.key(8, 30, "FM"+ENTER$)
    if c$ = ENTER$ then sex.list$ = "FM" else sex.list$ = c$

    call mess("Press RETURN for all Incomes")
    locate 10, 5:  Input "Minimum income:  ",Select.Income.Low&
    locate 10, 40: Input "Maximum income:  ",Select.Income.High&
    if Select.Income.High& = 0 then Select.Income.High& = 999999

    call mess("Press RETURN for all Ages")
    locate 12, 5:  Input "Minimum Age:  ",Select.Age.Low
    locate 12, 40: Input "Maximum Age:  ",Select.Age.High
    if Select.Age.High = 0 then Select.Age.High = 999

    Open outname$ for Output as 1
    rcount = 0

    'Set up the constant part of the search key

    Zip.Current& = Select.Zip.Low& - 1
    ML.zip = 0

    SearchKey.sex = ""
    SearchKey.income = Select.Income.Low&

    status=miseek(filenum, 2, SearchKey, 9, 0)

    'For each zip code in the range

    while ((ixstat = 0 or ixstat = 12) and ML.zip <= Select.Zip.High&)

	'For each zip code in the range seek to the first set
	'of records that fulfill the search criteria

	SearchKey.zip = Zip.Current& + 1

	status=miseek(filenum, 2, SearchKey, 9, 4)
	if ixstat = 10 then goto print.end

	length=miread(filenum, ML, RecLen)

	SearchKey.zip = ML.zip
	Zip.Current& = ML.zip

	for sex = 1 to len(sex.list$)

	    SearchKey.sex = mid$(sex.list$, sex, 1)

	    status=miseek(filenum, 2, SearchKey, 9, is.not.less%)
	    if ixstat = 0 or ixstat = 12 then _
		length=miread(filenum, ML, RecLen)

		if ixstat <> 0 and ixstat <> 10 and ixstat <> 11 then _
		    gosub isamErr: goto print.end

	    'Read and print records while the zip is constant and the
	    'values of the records fall within the high limits of the search

	    while ixstat = 0 and _
		  ML.zip = Zip.Current& and _
		  ML.sex = SearchKey.sex and _
		  ML.income <= Select.Income.High&

		'Since Age isn't a component in the split key we must examine
		'BOTH bounds of the selection criteria

		if ML.age < Select.Age.Low or _
		   ML.age > Select.Age.High then goto next.print

		print #1, ML.FirstName;
		print #1, ML.LastName

		'Extract the Address,City-State comma separated
		'pair into two lines

		iComma = instr(ML.address, ",")
		print #1, left$(ML.address, iComma-1)
		print #1, mid$(ML.address$, iComma+2) " " tab(25) ML.zip

		print #1,
		rcount = rcount + 1

    next.print:
		status=minext(filenum, 2)

		if ixstat = 0 or ixstat = 12 then _
		    length=miread(filenum, ML, RecLen)

		if ixstat <> 0 and ixstat <> 11 and ixstat <> 12 then _
		    gosub isamErr: goto print.end

	    Wend
	next sex

    Wend

print.end:

    close #1
    call mess(str$(rcount)+" Mailing labels printed. Press SPACE to continue..")
    call get.key(23, 78, " ")
    return
'


'               General purpose utility Functions
'============================================================================


isamErr:		'Print out ISAM error message

    call mess("A serious ISAM Error has occurred"+str$(ixstat)+" Press SPACE to continue ...")

    call get.key(23, 78, " ")
    return


'       Subprogram to get.key a key from the user.  The key is then converted
'       to upper case and checked to make sure its in a list of valid types

sub get.key(x, y, valid.chars$) static
    shared c$, ENTER$

    locate x, y, 1
    c$ = ""
    while c$ = "" : c$ = UCASE$(inkey$) : wend

    if instr(valid.chars$, c$) <> 0 then _
       print C$;: _
       call mess(""): _                     'Clear out any old errors
       locate ,,0: _			    'Turn cursor off
       exit sub

    if c$ = ENTER$ then _
       c$ = "ENTER" _                       'Transform enter character
    else _
       print C$;

    call mess(C$+" is currently not a selection")
end sub


'       Subprogram to write out an error on the status line.

sub mess(message$) static

    locate 24, 1: print space$(78);
    locate 24, 1: print message$;

end sub
