' FILENAME = EX1.BAS

DEFINT A-Z

TYPE RecStruc			' The structure of the records in the file

    field1  AS	type		' type is one of the following: INTEGER, LONG,
    field2  AS	type		'     SINGLE, DOUBLE, STRING*bytecount, or
     .				'     a previously defined type.
     .
    fieldn  AS	type

END TYPE

'$INCLUDE: 'ISAM.H'
DIM RecDes AS RecordDescriptor
DIM KeyDes(n) AS FieldDescriptor	' n is the # of fields declared

' Below we set up the ISAM record descriptor

RecDes.nfields = 1			' # of fields declared
RecDes.flags = 0			' Nonsegmented records
RecDes.minAllocation = 0		' Default record allocation - 8 bytes

' Below we set up the ISAM key descriptor

KeyDes(1).fName = "    ?    "           ' Field Name
KeyDes(1).dType = ?			' Data type
KeyDes(1).Segment = 1			' Segment #1
KeyDes(1).Position = ?			' Position
KeyDes(1).Length = ?			' Length of field in bytes
KeyDes(1).Handle = ?			' Key number is ?
KeyDes(1).Flags = (? * 256) + ? 	' Flags, type of key
KeyDes(1).reserved = 0			' Reserved - Set to 0

FN$ = "    ?    "

KEYNUM = ?
KEYLEN = ?

' Below we create the ISAM file

STATUS=MICREATE(FN$,RecDes,KeyDes(1))
IF STATUS <> 0 THEN PRINT "File creation error, IXSTAT=";IXSTAT : GOTO DONE

' Below we open the file in update mode

FILENUM=MIOPEN(FN$,IO.UPDATE%)		'IO.UPDATE% = 2 (read/write)
IF IXSTAT <> 0 THEN PRINT "File open error, IXSTAT=";IXSTAT : GOTO DONE

'
    '
    ' In here you would put your BASIC program and
    ' the statements to update and use your ISAM file.
    '
'

DONE:

STATUS=MICLOSE(FILENUM)
IF IXSTAT <> 0 THEN PRINT "Error closing file. IXSTAT=";IXSTAT

END
