 $PASCAL '24398-16066 REV.5010 <881102.1602>'  "(*****************************************************************)  " "(*                                                               *)  " "(*  (C) COPYRIGHT HEWLETT-PACKARD COMPANY 1986.  ALL RIGHTS      *)  " "(*  RESERVED.  NO PART OF THIS PROGRAM MAY BE PHOTOCOPIED,       *)  " "(*  REPRODUCED, OR TRANSLATED TO ANOTHER PROGRAMMING LANGUAGE    *)  " "(*  WITHOUT THE PRIOR WRITTEN CONSENT OF THE HEWLETT-PACKARD     *)  " "(*  COMPANY.                                                     *)  " "(*                                                               *)  " "(*****************************************************************)  " "(*                                                               *)  " "(*      NAME:  EXER1                                             *)  " "(*    SOURCE:  24398-18066                                       *)  " "(*     RELOC:  24398-16066                                       *)  " "(*      PGMR:  DAVE GROVES / DISC MEMORY DIVISION  JAN 1986      *)  " "(*                                                               *)  " "(*****************************************************************)  " (*  Revision History:            DATE         PROGRAMER                   DESCRIPTION   $   --------    ---------------   --------------------------------------  $ #   01/06/86    D. GROVES/DMD     Created EXER1 son process from EXER.  # #                                 EXER was too large to accommodate new # !                                 routines for EAGLE and BFD Cache. !     #                                 Created separate source file for the  #                                  type declarations.       "                                 Added EAGLE and 7933XP/7935XP Cache "                                  routines.          $   04/14/86    D. Groves/DMD     Removed the input/output specifier from $ &                                 the program statement.  And added the file  & "                                 identifier to the WRITE statements. "     $                                 Moved ERROR_LOG and ZFLTLOG from EXER.  $     &                                 Added RSP, ISP and print_addr  procedures.  &     #   02-25-87    L. Doner/DMD      Removed Input and Output from program # '                                 statement. Redirected I/O on a few writelns.  '     $   02-27-87    L. Doner/DMD      Changed String functions to characters. $        03-03-87    L. Doner/DMD      Removed Main.      #   03-09-87    L. Doner/DMD      Modified ZHELP. Added Readcacheon and #                                  Readcacheoff.  See ZHELP.      #   03-24-87    L. Doner/DMD      Added Number of Write Cache Hits and  # %                                 transfered Cachetablearea to Disp_cache-  % "                                 stat_tble. See Disp_cache_stat_tbl. "     #   04-03-87    L. Doner/DMD      Changed formatting on cache hit % 's. #                                  See Disp_cache_stat_tble.      #   06-12-87    L. Doner/DMD      Added variable to Log_header. Prints  #                                  either 'Error' or 'Loop'.      $   06-17-87    L. Doner/DMD      Removed 795X from Amigo Clear command,  $ $                                 Added 795X to SDClear command in ZHELP. $     "   10-09-87    L. Doner/DMD      Fixed bug in ZRDTBLS. See ZRDTBLS.  "     $   11-02-87    L. Doner/DMD      Fixed bug in Error_log. See Error_log.  $     %   01-28-88    L. Doner/DMD      Moved Zcache_control from Exer to Exer1.  % #                                 Also, Checkqstat, Doutil, Xutil, and  #                                  Dash_write. Comp = nullcomp.   %************************************************************************** %           LINK :  link exer1.lod      &**************************************************************************)  &     $CDS OFF  $HEAPPARMS OFF,PARTIAL_EVAL OFF,RECURSIVE OFF$  $HEAP 0,IDSIZE 24,run_string 364,RANGE OFF$   	$HEAP_DISPOSE OFF$ 	     PROGRAM EXER1;      
$ include '[TYPE' $  
     VAR     f,    crt            : text;    M794X,    M7907,    M791X,    M793X,    M9140,    M9144,    EAGLE,    M795XA,     M795XB,     M795X          : boolean;     I              : bytetype;    lu_num         : lu_num_type;     line_cnt,     lu,     da,     cc             : wordtype;    parms          : parm_type;     addrmode       : wordtype;    spareblock     : boolean;     tape           : boolean;     disc           : boolean;     controller     : boolean;     iobuf          : iobuftype;     buffer         : bufrtype;    comp           : comptype;    print_paddr    : boolean;     info           : packed array [0..10] of bytetype;    isp,rsp,    ce_mode        : boolean;   
  outfile        : char64; 
     function get_buf $alias 'pas.parameters'$ (pos:wordtype;    var buffer:bufrtype; length:wordtype) :wordtype; external;      procedure getcode $ alias 'exec' $            (e,lu:wordtype;b:char2;l:wordtype);external;      procedure XUTIL (VAR LU,DA:WORDTYPE;VAR COMP:COMPTYPE;                  VAR IOBUF:IOBUFTYPE); EXTERNAL;       #procedure get_parms $alias 'pas.numericparms'$ (var parms:parm_type);  #   external;       procedure prtn (var parms:parm_type);external;      function ifbrk:wordtype;external;           procedure space $direct$ (I:bytetype);  	  var J :bytetype; 	       begin       for J := I downto 1 do write(f,' ');    end;  (* of space *)      function upcase(c:char):char;   begin   
  if c in ['a'..'z'] then  
     upcase:=chr(ord(c)-ord(' '))     else       upcase:=c;  end;      function more_lines:boolean;  var     c:char2;  begin     if (line_cnt > 20) and (outfile[1] = '1') and  {consol}        (buffer[299] = ord('1')) then      begin   
      writeln(crt);  
 '      prompt(crt,'More...(''s'' to stop listing)',chr(27),'A',chr(13));{go up} '       getcode(1,octal('101'),c,-1);   #      prompt(crt,chr(27),'J',chr(13));                  {clear screen} # 	      line_cnt:=0; 	       more_lines:=upcase(c[0]) <> 'S';      end      else       more_lines:=true;   end;      (**************************************)  (* Write byte in two digit hex format *)  (**************************************)  procedure writehex $DIRECT$(HEXNUM:BYTETYPE);     begin        write(f,' ',HEXCHAR[HEXNUM DIV 16],HEXCHAR[HEXNUM MOD 16]);    
  end;  (* of writehex *)  
         procedure prntaddr $DIRECT$(ADDR:ADDRTYPE);     begin       if ADDRMODE = 0 then        writeln(f,'Block Address = ',ADDR.BLOCK:1)      else        begin   
        writeln(f);  
         WRITE(f,'Cylinder = ',ADDR.CYLINDER:1);   	        SPACE(5);  	         WRITE(f,'Head = ',ADDR.HEAD:1);           if (spareblock) and (M7907) then            begin               writeln(f);             end           else            begin               SPACE(5);               WRITELN(f,'Sector = ',ADDR.SECTOR:1);             end;        end;    end;  (* prntaddr *)          procedure print_addr $direct$ (index:bytetype);     begin       {Cylinder}  !    write(f,(((info[0+index] mod 128) * 256) + info[1+index]):4);  !     space(4);       {Head}      write(f,info[2+index]:2);       space(3);       {Sector}      write(f,info[3+index]:3);     end;   (* of print_addr *)          procedure wrt_binary $direct$ (data_byte:bytetype);     var       K       : erraptype;      J       : wordtype;         begin       k.allbits := data_byte;       for J := 0 to 7 do            if k.b[J] then write(f,'1')         else write(f,'0');    end;  (* of wrt_binary *)           PROCEDURE DISP_CACHE_STAT_TBL $direct$;   %{************************************************************************} % ${* 03-24-87  L. Doner  : Passed cachetablearea to this procedure instead $ {*                       of extablearea.  %{*                     : Added new parameter, NCHWRIHITS, number of cache  % {*                       write hits and cache write hit %.  {* 03-25-87  L. Doner  : Fixed division by zero bugs.   {* 03-26-87  L. Doner  : Changed result to doubletype.  ${* 04-03-87  L. Doner  : Changed formatting on cache hits and result to  $ {*                       real_result.   %{************************************************************************} %   VAR       x      :wordtype;       real_result : real;       LU     :wordtype;         begin       LU := parms[3];   (* get passed value of LU *)      #    for x := 0 to 25 do               (* Retreive data from buffer *)  #       iobuf.cachetablearea.cachebyte[x] := buffer[x];           with IOBUF.CACHETABLEAREA do        begin   
        writeln(f);  
         writeln(f,'Cache Statistic Table Info');          writeln(f,'--------------------------');  
        writeln(f);  
         write(f,'Read cache ');           case CACHE_READ_STATUS of             0:  write(f,'enabled');             1:  write(f,'disabled by host');            2:  write(f,'not installed');             3:  write(f,'disabled because of RAM error');           end;          writeln(f,' on LU ',LU:1);              if EAGLE or M793X then            begin               write(f,'Write cache ');              case CACHE_WRITE_STATUS of                0: write(f,'enabled');                1: write(f,'disabled by host');                 2: write(f,'not installed');                3: write(f,'disabled because of RAM error');                4: write(f,'unknown status');                 5: write(f,'not installed');              end;  (* of case *)             end;  (* of EAGLE *)          writeln(f,' on LU ',LU:1);      
        writeln(f);  
         writeln (f,'Cache page size (bytes) = ', PAGESIZE:1);           writeln (f,'number of pages = ', NUMPAGES:1);   
        writeln(f);  
         writeln (f,'number of reads = ', NUMREADS:1);           writeln (f,'number of read hits = ', NUMRDHITS:1);  
        writeln(f);  
         writeln (f,'number of writes = ', NUMWRITES:1);           writeln (f,'number of write hits = ', NUMWRIHITS:1);  
        writeln(f);  
 !        writeln (f,'number of write cache hits = ',NCHWRIHITS:1);  ! 
        writeln(f);  
         if (NUMREADS<>0) then             real_result := (NUMRDHITS * 100) div NUMREADS           else            real_result := 0;           writeln (f,'read hit %  = ', real_result:1:2);          if (NUMWRITES<>0) then            real_result := (NUMWRIHITS * 100) div NUMWRITES           else            real_result := 0;           writeln (f,'write hit % = ', real_result:1:2);          if (NUMWRITES<>0) then            real_result := (NCHWRIHITS * 100) div NUMWRITES           else            real_result := 0;           writeln (f,'write cache hit % = ', real_result:1:2);          if ((NUMREADS + NUMWRITES)<>0) then   "          real_result := (NUMREADS * 100) div (NUMREADS + NUMWRITES) "         else            real_result := 0;           writeln (f,'read %      = ', real_result:1:2);        end; (* of table 7 *)     end;  (* of disp_cache_stat_tbl *)          PROCEDURE ZRDTBLS $direct$;   $(**********************************************************************) $ "(* 10-09-87  L. Doner   :  Found a bug in the Runout Table. The loop " $(*                         counted from 0 to 12 instead of 1 to 13. The  $ "(*                         first item is always 13. ( # of runouts)  " $(**********************************************************************) $   VAR       I        :wordtype;       J        :wordtype;       K        :wordtype;       index    :bytetype;       count    :wordtype;       tablenum :wordtype;       maxhead  :wordtype;       TBI      :array[0..168] of wordtype;        begin          (*********************************************)     (*  Get the passed data into the good buffer *)     (*********************************************)      for I := 0 to 298 do        iobuf.extablerarea.tbl[I] := buffer[I];           (*********************************)       (* put parms in proper variables *)       (*********************************)   
    tablenum := parms[4];  
 
    maxhead  := parms[5];  
     
    case tablenum of 
       7:  disp_cache_stat_tbl;            1:  with IOBUF.EXTABLERAREA do  	            BEGIN  	             WRITELN(f,'SPARE TRACK TABLE');               writeln(f);   	            J:=0;  	             FOR I:=0 TO MAXHEAD DO  
              BEGIN  
 "              WRITELN(f,'Head number =',(TBL[J]):3,'             '); " '              WRITELN(f,'# of secondary spares =',(TBL[J+1]*256+TBL[J+2]):3);  ' #              WRITELN(f,'# of tracks used =',(TBL[J+3]):3,'        '); # #              WRITELN(f,'# of logical tracks spared =',(TBL[J+4]):3);  #               IF (TBL[J+4] > 0) THEN                  BEGIN                   writeln(f);                   writeln(f,' CYL      TYPE      SCALAR');  '                writeln(f,'=====   =========   ======');             (*2525*)  '                 for K := 1 to TBL[J+4] do                     begin  (* write each line *)                      index := K*3+J+2;   $                    write(f,((TBL[index] MOD 128)*256+TBL[index+1]):4);  $                         space(4);                       if ((M7907) and (TBL[index] >= 128)) then                         write (f,'MAINT    ')                       else                        if TBL[index+2] >= 128 then                           write(f,'PRIMARY  ')  
                      else 
                         write(f,'SECONDARY');                           space(5);                       writeln(f,((TBL[index+2]) mod 128):3)                     end;  {for K} (* of write each line *)                end;  {if TBL}                J := J+5+TBL[J+4]*3;  &              writeln(f);                                          (*2525*)  & 
            end;  {for I}  
           end;   {with}             2:  with IOBUF.EXTABLERAREA do begin              for I := 0 to 168 do                if TBL[I]>127 then                  TBI[I] := TBL[I] - 256  	              else 	                 TBI[I] := TBL[I];                   for I := 0 TO 1 do  
              begin  
                 writeln(f);                   if I = 0 then                     writeln(f,'Head Alignment Offset table:')   
                else 
                   writeln(f,'Circumferential Skew table:');   "                writeln  (f,'        band  delta band  delta band'); " "                writeln  (f,'  Head    0    0-1    1    1-2    2 '); " "                writeln  (f,'  ====   ===   ===   ===   ===   ==='); "                 for J := 0 to MAXHEAD do                    begin                       if I = 0 then K := 0 else K := 78;                      write(f,'  ',J:2);                      write(f,'    ',TBI[J*6+K]:3);                       write(f,'   ',TBI[J*6+K+1]:3);                      write(f,'   ',TBI[J*6+K+2]:3);                      write(f,'   ',TBI[J*6+K+3]:3);                      write(f,'   ',TBI[J*6+K+4]:3);                      writeln(f);                     end;  {for J}                 end;   {for I}  %            writeln(f);                                          (*2525*)  %             WRITELN(f,'Current Cylinder Offset table:');              writeln(f,'  Head   Offset');               writeln(f,'  ====   ======');   '            FOR I:=0 TO MAXHEAD DO WRITELN(f,'   ',I:2,'     ',TBI[I+156]:3);  '           end;  {with}            3:  with IOBUF.EXTABLERAREA do  	            begin  	 
              writeln(f);  
               WRITELN(f,'Current Configuration Table:');  $              WRITELN(f,'Transfer length =',TBL[0]*16777216+TBL[1]*65536 $                +TBL[2]*256+TBL[3]);                 WRITELN(f,'Burst length =',TBL[4]);                 WRITELN(f,'Retry time =',TBL[5]*256+TBL[6]);                WRITE(f,'Status mask =');                 FOR I:=7 TO 14 DO WRITEHEX(TBL[I]);   
              WRITELN(f);  
               WRITELN(f,'RPS Window =',TBL[15]);                WRITELN(f,'RPS Advance =',TBL[16]);                 WRITE(f,'Set release S bit =');   $              IF TBL[17]<>0 THEN WRITELN(f,'ON') ELSE WRITELN(f,'OFF');  $               WRITE(f,'Set release T bit =');   $              IF TBL[18]<>0 THEN WRITELN(f,'ON') ELSE WRITELN(f,'OFF');  $               WRITE(f,'Option flag =');                 WRITEHEX(TBL[19]);  
              WRITELN(f);  
               WRITE(f,'Burst with EOI =');  $              IF TBL[20]<>0 THEN WRITELN(f,'ON') ELSE WRITELN(f,'OFF');  $               WRITE(f,'Return addressing mode =');  %              IF TBL[21]<>0 THEN WRITE(f,'SINGLE') ELSE WRITE(f,'THREE');  %               WRITELN(f,' vector mode');              end;  (* of table 3 *)  	      4,5:  begin  	               WRITELN(f,'Table not implemented');               end;        6:  with IOBUF.EXTABLERAREA do              begin (* table 6 *)   
              WRITELN(f);  
               WRITELN(f,'Runout Table:');                 WRITELN(f,'  Head   Offset');                 WRITELN(f,'  ====   ======');                 FOR I := 1 to TBL[0] do                   begin                     WRITE(f,'   ',I-1:2);                     if TBL[I] < 128 then                      WRITELN(f,'     ',TBL[I]:3)                     else                      WRITELN(f,'     ',(TBL[I] - 256):3);                  end;  {for I}               end;  (* of table 6 *)          end;  (* of case *)   end;  (* of zrdtbls *)          
procedure ZSENSE $DIRECT$; 
   var       x :bytetype;    begin       for x := 0 to 6 do        iobuf.extablerarea.tbl[x] := buffer[x];           with iobuf.exsencerarea do        begin   
        WRITELN(f);  
         writeln   %          (f,'Exhaust air temperature =',SENSOR[3]:3,' (+/-3) degrees C'); %         writeln   &          (f,'Actuator coil temperature =',SENSOR[4]:3,' (+/-3) degrees C'); & #        WRITE(f,'Hardware fault register = '); wrt_binary(sensor[5]);  # 
        WRITELN(f);  
 !        WRITE(f,'R/W fault register = ');  wrt_binary(sensor[6]);  ! 
        WRITELN(f);  
 
      end;  (* of with *)  
   end;  (* of ZSENSE *)           PROCEDURE prntstatus $DIRECT$;  $(*********************************************************************)  $ #(*  1-27-88  L. Doner  :  Added who_from to determine if this routine  #  (*                        was called from the father or the son.   $(*********************************************************************)  $   var       igntgt    :boolean;       I         :WORDTYPE;      J         :WORDTYPE;  
    bits      :ERRAPTYPE;  
 
    statusmsg :statustype; 
 
    who_from  : bytetype;  
       begin       (*****************************************)       (* reset environment from father program *)       (*****************************************)   
    addrmode := parms[3];  
         if parms[4] = 0 then        spareblock := true      else  
      spareblock := false; 
         disc       := false;      tape       := false;      controller := false;  
    case parms[5] of 
       0: disc := true;        1: tape := true;        2: controller := true;        otherwise   
        (* null *);  
     end;          who_from := buffer[20];       if (who_from = 99) then   
      for I := 0 to 19 do  
         statusmsg.unformatted_status.status[I] := buffer[I];          (*************************)       (* start decoding status *)       (*************************)       with statusmsg.unformatted_status do        begin   
        WRITELN(f);  
         WRITELN(f,'Status bytes returned (hex):');          for I := 0 to 9 do writehex(status[I]);   
        WRITELN(f);  
         for I := 10 to 19 do writehex(status[I]);   
        WRITELN(f);  
       end;          with statusmsg.formatted_status do        with errorstatus do begin   	      WRITELN(f);  	           WRITE(f,'Selected ');         if TAPE       then WRITE(f,'Tape')       else         if DISC       then WRITE(f,'Disc')       else         if CONTROLLER then WRITE(f,'Controller') else         WRITE(f,'Unknown device');            WRITELN(f,' unit = ',UNIT:1);   '      if UNITS <> 255 then WRITELN(f,'Unit ',UNITS:1,' with pending status');  '           (*********************************)         (*BEGINING OF STATUS BIT DECODING*)         (*********************************)   
      IGNTGT:=FALSE; 
           if STATUSWORDS[0] > 0 then          begin             WRITELN(f);             WRITELN(f,'**REJECT ERRORS**');             IF STATUSBITS[2] THEN WRITELN(f,'Channel parity');            IF STATUSBITS[5] THEN WRITELN(f,'Illegal opcode');             IF STATUSBITS[6] THEN WRITELN(f,'Module addressing');              IF STATUSBITS[7] THEN WRITELN(f,'Address bounds');            IF STATUSBITS[8] THEN WRITELN(f,'Parameter bounds');             IF STATUSBITS[9] THEN WRITELN(f,'Illegal parameter');               IF STATUSBITS[10] THEN WRITELN(f,'Message sequence');              IF STATUSBITS[12] THEN WRITELN(f,'Message length');           end;            if STATUSWORDS[1] > 0 then          begin (* bits 16 - 31 *)            WRITELN(f);             WRITELN(f,'**FAULT ERRORS**');            if STATUSBITS[17] then              begin  (* statusbit 17 *)                 WRITELN(f,'Cross unit err during COPY DATA');                 WRITELN(f,'Units which had errs are:');                 for I:=0 to 5 do if UNITC[I]<>255 then                  WRITELN(f,'UNIT = ',UNITC[I]:1);                IGNTGT := TRUE;               end;  (* of statusbit 17 *)              if STATUSBITS[19] then WRITELN(f,'Controller fault');              IF STATUSBITS[22] THEN WRITELN(f,'Unit fault');             if STATUSBITS[24] then              begin  (* statusbit 24 *)                 WRITELN(f,'Hardware failed diagnostic');                if not IGNTGT then                  begin (* print errors *)                    WRITELN(f);                     if M791X or M793X or EAGLE then                       begin  (* 791X/793X *)                        IF DIAGD.PARTA<>0 THEN  $                        WRITELN(f,'PART # = ',DIAGD.PARTA:1,' failed');  $                       IF DIAGD.PARTB<>0 THEN  $                        WRITELN(f,'PART # = ',DIAGD.PARTB:1,' failed');  $                       IF DIAGD.TESTA<>0 THEN  $                        WRITELN(f,'TERR = ',DIAGD.TESTA:1,' returned');  $                       IF DIAGD.TESTB<>0 THEN  $                        WRITELN(f,'TERR = ',DIAGD.TESTB:1,' returned');  $                     end;  (* of 791X/793X *)                    if M794X or M795X then                      begin  (* 794X *)                         if DIAGD.PARTA <> 0 then  "                        WRITELN(f,'FRA # ',DIAGD.PARTA:1,' failed'); "                       if DIAGD.PARTB <> 0 then  "                        WRITELN(f,'FRA # ',DIAGD.PARTB:1,' failed'); "                       WRITE(f,'Failed subtest = ');                         writehex(DIAGD.TESTA);                        WRITELN(f);                       end;   (* of 794X *)                    igntgt := true;                   end;  (* of print errors *)               end;  (* bit 24 *)      "          if STATUSBITS[26] or STATUSBITS[27] or STATUSBITS[28] then " 	            begin  	               WRITE(f,'Release required for ');   !              IF STATUSBITS[26] THEN WRITE(f,'OPERATOR REQUEST');  ! !              IF STATUSBITS[27] THEN WRITE(f,'DIAGNOSTIC RESULT'); ! #              IF STATUSBITS[28] THEN WRITE(f,'INTERNAL MAINTENANCE');  #               WRITELN(f,' before command can be executed');               end;            if STATUSBITS[30] then              WRITELN(f,'Power fail');            if STATUSBITS[31] then              WRITELN(f,'Retransmit');          end;  (* statusbits 16-31 *)            if STATUSWORDS[2] > 0 then          begin  (* bits 32-47 *)             WRITELN(f);             WRITELN(f,'**ACCESS ERRORS**');   %          IF STATUSBITS[32] THEN WRITELN(f,'Illegal parallel operation');  % !          IF STATUSBITS[33] THEN WRITELN(f,'Uninitialized media'); ! $          IF STATUSBITS[34] THEN WRITELN(f,'No more spares available');  $           IF STATUSBITS[35] THEN WRITELN(f,'Not ready');            IF STATUSBITS[36] THEN WRITELN(f,'Write protect');            IF STATUSBITS[37] THEN WRITELN(f,'No data found');  %          IF STATUSBITS[40] THEN WRITELN(f,'Unrecoverable data overflow'); %           if STATUSBITS[41] then              if not igntgt then  
              begin  
                 WRITELN(f,'Unrecoverable data');                  WRITELN(f,'  Address follows:');                  prntaddr(ADDRN);                  IGNTGT:=TRUE;   	              end; 	           IF STATUSBITS[43] THEN WRITELN(f,'End of file');            IF STATUSBITS[44] THEN WRITELN(f,'End of volume');          end;  (* of bits 32-47 *)             if STATUSWORDS[3] > 0 then          begin  (* bits 48-63 *)             WRITELN(f);             WRITELN(f,'**INFORMATION ERRORS**');            IF STATUSBITS[48] then              WRITELN(f,'Operator requested release');            IF STATUSBITS[49] THEN  "            WRITELN(f,'Release requested for a diagnostic result');  "           if STATUSBITS[50] then  "            WRITELN(f,'Release requested for internal maintenance'); "           if STATUSBITS[51] then  %            WRITELN(f,'Possible media wear, one or fewer spares remain');  % "          if STATUSBITS[48] or STATUSBITS[49] or STATUSBITS[50] then "             if NOT IGNTGT then  
              begin  
 "                WRITELN(f,'Unit requesting release is ',UNITC[0]:1); "                 IGNTGT:=TRUE;   	              end; 	           IF STATUSBITS[52] THEN WRITELN(f,'Latency induced');            IF STATUSBITS[55] THEN              WRITELN(f,'Automatic sparing invoked');   $          IF STATUSBITS[57] THEN WRITELN(f,'Recoverable data overflow'); $           if STATUSBITS[58] then              if not igntgt then  
              begin  
                 WRITELN(f,'Marginal data error');                   WRITELN(f,'  Address follows:');                  PRNTADDR(ADDRN);                  IGNTGT:=TRUE;   	              end; 	           if STATUSBITS[59] then              if not igntgt then  
              begin  
                 WRITELN(f,'Recoverable data error');                  WRITELN(f,'  Address follows:');                  PRNTADDR(ADDRN);                  IGNTGT:=TRUE;   	              end; 	 %          IF STATUSBITS[61] THEN WRITELN(f,'Maintenance track overflow');  %         end;  (* of bits 48-63 *)             if (NOT IGNTGT) and (NOT SPAREBLOCK) then           begin             WRITELN(f);             WRITELN(f,'New target address is:');  
          PRNTADDR(ADDRN); 
         end;            if not SPAREBLOCK then          begin  (* not SPAREBLOCK *)             if M791X or M793X or EAGLE then   	            begin  	               I := 0;   
              WRITELN(f);  
 
              repeat 
                 if DERRORN[I] <> 0 then                     begin                        WRITELN(f,'DERR ',DERRORN[I]:1,' returned');                     end;                   if (DERRORN[I] = 64) or (DERRORN[I] = 203) then                      begin                       WRITE(f,'Hardware fault reg = ');                       I := I + 1;                       wrt_binary(DERRORN[I]);                       WRITELN(f,' binary');                       WRITELN(f);                     end;  {If Derrorn}                  I := I + 1;                 until I = 4;  (* end of repeat *)               end;  (* of 791X/793X *)            if M794X or M795X then              begin  (* 794X *)                  if derrorn[0] <> 0 then                   begin                     WRITELN(f);  !                   WRITE(f,'Fault code =');  writehex(derrorn[0]); !                    WRITELN(f);                      WRITE(f,'Status = '); wrt_binary(derrorn[1]);                      WRITELN(f);                   end;               end;  (* of 794X *)             if M7907 then               begin (* 7907 *)                if derrorn[1] <> 0 then                   begin                     WRITELN(f);                     WRITE(f,'P7 = ');                     wrt_binary(derrorn[0]);                     WRITELN(f);                     WRITE(f,'P8 = ');                     writehex(derrorn[1]);                     WRITELN(f);   
                end; 
             end;  (* of 7907 *)           end; (* not SPAREBLOCK *)       end;   (* of with *)    end;  (* of print status *)               procedure fault_header $DIRECT$;    begin       writeln   (f,'       Current             Target');      write   (f,'   Cyl  Head  Sect     Cyl  Head  Sect    Fault Code   ');          if isp then         begin           if M7907 then             WRITELN(f,'<  P7  > <  P8  >')          else            WRITELN(f,'Subtest   Status');        end       else        begin   
        WRITE(f,'  HFR');  
         if EAGLE then             WRITE(f,'    Activity');  
        WRITELN(f);  
       end;          write   #(f,'  =================   =================  ============  ========'); #     if isp or EAGLE then        WRITE(f,' ========');       WRITELN(f);     end;  (* of fault_header *)           PROCEDURE LOG_HEADER $direct$;  ${**********************************************************************} $ ${* 6-12-87  L. Doner : Added count_type to print either Error or Loop *} $ ${**********************************************************************} $ var   
   count_type : bytetype;  
       begin       count_type := buffer[1];      case count_type of        77:                {Read ERT or Run logs, print 'Error'}  	          writeln  	 (f,'       Logical      Error  Error          ');          99:                {Print option of WTR ERT, print 'Loop'}   	          writeln  	 (f,'       Logical      Error  Loop           ');   	      otherwise ;  	     end;      writeln   (f,'   Cyl  Head  Sect  Type   Count   Error  ');       writeln   (f,'  ================  =====  =====  ========');     end;  (* of log_header *)           procedure prnt_fault_error $direct$;    begin       if rsp then         begin  (* 791X/793X/EAGLE *)  
        WRITELN(f);  
         WRITELN(f,'HFR values:');           if M791X then             begin    (* 791X *)               WRITELN(f,' XXXXXXX0 Destructive write fault');               WRITELN(f,' XXXXXX1X AGC fault');               WRITELN(f,' XXXXX0XX Power fail warning');              WRITELN(f,' XXXX1XXX On track');              WRITELN(f,' XXX0XXXX Offtrack during write');               WRITELN(f,' XX1XXXXX Spindle speed OK');              WRITELN(f,' X1XXXXXX 7912 drive indicator');              WRITELN(f,' 1XXXXXXX Speed indicator pulses');              WRITELN(f);   #            WRITELN(f,'If DERR 64 then an HFR value of 1 in any bit'); # $            WRITELN(f,'indicates that bit caused the error regardless'); $             WRITELN(f,'of the sense of the bit');             end;   (* 791X *)               if M793X then   
          begin (* 793X *) 
             WRITELN(f,' XXXXXXX1 spindle speed is down');               WRITELN(f,' XXXXXX1X heads are off track');               WRITELN(f,' XXXX1XXX track follower PLL error');              WRITELN(f,' XXX1XXXX top door is open');              WRITELN(f,' XX1XXXXX emergency retract is set');              WRITELN(f,' X1XXXXXX power failure');               WRITELN(f,' 1XXXXXXX r/w fault');   
          end;  (* 793X *) 
             if EAGLE then             begin (* EAGLE *)               WRITELN(f,' XXXXXXX1 spindle speed is down');               WRITELN(f,' XXXXXX1X servo timing error');              WRITELN(f,' XXXXX1XX heads off track');               WRITELN(f,' XXXX1XXX AGC error');               WRITELN(f,' XXX1XXXX sector timing error');               WRITELN(f,' XX1XXXXX data overrun');              WRITELN(f,' X1XXXXXX unused');              WRITELN(f,' 1XXXXXXX unused');                  WRITELN(f);   	            write  	 (f,'An (E) after the fault code indicates an event, ');   
            writeln  
 (f,'and a (F) indicates a fault.');                   WRITELN(f);               WRITELN(f,'Activity indicator values:');  
            writeln  
 (f,'  0 = no seeks');   
            writeln  
 
(f,'  1 = 1 seek');  
 
            writeln  
 
(f,'  2 = 2 seeks'); 
 
            writeln  
 
(f,'  3 = 3 seeks'); 
 
            writeln  
 
(f,'  4 = 4 seeks'); 
 
            writeln  
 (f,'  5 = 5 - 7 seeks                     (1 sec)');  
            writeln  
 (f,'  6 = 8 - 200 seeks                   (1-30 sec)');   
            writeln  
 (f,'  7 = 201 - 2,000 seeks               (30 sec - 5 min)');   
            writeln  
 (f,'  8 = 2,001 - 12,000 seeks            (5 - 30 min)');   
            writeln  
 (f,'  9 = 12,001 - 25,000 seeks           (30-60 min)');  
            writeln  
 (f,' 10 = 25,001 - 150,000 seeks          (1-6 hrs)');  
            writeln  
 (f,' 11 = 150,001 - 600,000 seeks         (6-24 hrs)');   
            writeln  
 (f,' 12 = 600,001 - 4,000,000 seeks       (1-7 days)');   
            writeln  
 (f,' 13 = 4,000,001 - 16,000,000 seeks    (1-4 weeks)');  
            writeln  
 (f,' 14 = 16,000,001 - 100,000,000 seeks  (1-6 months)');   
            writeln  
 (f,' 15 = > 100,000,000 seeks             ( > 6 months)');  
          end; (* EAGLE *) 
       end;    end;  (* of prnt_fault_error *)           PROCEDURE PRT_ERROR_INFO $direct$ (logtype:wordtype);   ${*********************************************************************}  $ ${*  9-1-87  L. Doner  : Mod to 795XA/795XB bit 0 in error byte.       }  $ ${*********************************************************************}  $       begin       WRITELN(f);       WRITELN(f,'TYPE:');           if rsp then         begin           WRITELN(f,'  COR  =  ECC correctable error');           WRITELN(f,'  UNC  =  ECC uncorrectable error');   
        if not EAGLE then  
           begin  (* not EAGLE *)              WRITELN(f,'  CRC  =  only CRC detected error');               WRITELN(f,'  F/S  =  formatter/separator error');               WRITELN(f,'  UNR  =  unrecoverable error');             end;  (* of not EAGLE *)        end;  (* of 791X or 793X or EAGLE *)          if isp then         begin           WRITELN(f,'  REC  =  Recoverable error');           WRITELN(f,'  M-RE =  Marginal data/retries');         end;  
    if M7907 or M795X then 
       WRITELN(f,'  UNR  =  Unrecoverable data error');  
    if M794X or M795X then 
       WRITELN(f,'  M-EC =  Marginal data/ECC corrected');   	    if M795XA then 	       writeln(f,'  FIFO =  FIFO data lost or track offset');  	    if M795XB then 	       writeln(f,'  T-OF =  Track offset invoked');  	    if M794X then  	       WRITELN(f,'  UNC  =  Uncorrectable data error');      WRITELN(f);       WRITELN(f,'ERROR BYTE:');       
    if M791X or M793X then 
       begin   #        WRITELN(f,'XXXXXX00  ECC found correctable error (ERT only)'); #         WRITELN(f,'XXXXXX01  ECC found uncorrectable error');           WRITELN(f,'XXXXXX10  ECC did not detect an error');           WRITELN(f,'XXXXX1XX  error is in header not body');           WRITELN(f,'XXXX1XXX  CRC did not detect error');          WRITELN(f,'XXX1XXXX  first retry did not get data');           WRITELN(f,'XX1XXXXX  extra offset was used (ERT only)');           WRITELN(f,'X1XXXXXX  Formatter/Separator error');   "        WRITELN(f,'1XXXXXXX  unrecoverable error (run-time only)');  "       end;  (* of 793X/791X errors *)       	    if EAGLE then  	       begin           WRITELN(f,'XXXXXXX0 ECC correctable error');          WRITELN(f,'XXXXXXX1 ECC uncorrectable error');          if logtype <> 198 then            writeln(f,'XXXXXX1X Not used')           else             WRITELN(f,'XXXXXX1X No error detected');          WRITELN(f,'XXXXX1XX error in sector header');           WRITELN(f,'XXXX1XXX error in sector body');           if logtype <> 198 then            begin (* run log *)   "            WRITELN(f,'XXX1XXXX data not recovered on first retry'); "             WRITELN(f,'XX1XXXXX CRC byte(s) in error');               WRITELN(f,'X1XXXXXX ECC byte(s) in error');               WRITELN(f,'1XXXXXXX unrecoverable error');            end  (* of run log *)           else            begin  (* ERT log *)              WRITELN(f,'XXX1XXXX CRC byte(s) in error');               WRITELN(f,'XX1XXXXX Parity bit enabled');               WRITELN(f,'X1XXXXXX Data underrun/overrun fault');              WRITELN(f,'1XXXXXXX ECC byte(s) in error');             end;   (* of ERT log *)   
      end;  (* of EAGLE *) 
         if isp then         begin           if M795XA then            writeln(f,'XXXXXXX1  FIFO or track offset');          if M795XB then            writeln(f,'XXXXXXX1  Track offset invoked');          WRITELN(f,  'XXXXXX1X  REC ');          WRITELN(f,  'XXXXX1XX  M-RE');          if M794X or M795X then            WRITELN(f,'XXXX1XXX  M-EC');          if M7907 or M795X then            WRITELN(f,'XXX1XXXX  UNR')          else            WRITELN(f,'XXX1XXXX  UNC');           WRITELN(f,  'XX1XXXXX  Error in data');           WRITELN(f,  'X1XXXXXX  Error in header');           write  (f,  '1XXXXXXX  ');          if M7907 then             WRITELN(f,'Other error');           if M794X then             WRITELN(f,'Address mark error');          if M795X then             writeln(f,'No data sync');          if M794X then             WRITELN(f,'00000000  UNC error during write');        end;    end;  (* of prt_error_info *)               
PROCEDURE ZHELP $direct$;  
 &(*************************************************************************)  & &(* 3-9-1987   L. Doner  :    Added Readcacheon,  Readcacheoff            *)  & &(*                  Also changed cacheon,cacheoff to Eagle only commands.*)  & &(* 6-17-87    L. Doner  : Removed 795X from Amclear, added 795X to SDClear)  & &(*************************************************************************)  &     var     keep_going:boolean;       procedure writit(s:char72);   begin   
  if keep_going then 
     begin         keep_going:=more_lines;         if keep_going then          writeln(f,s);         line_cnt:=succ(line_cnt);   
    end;  {if keep_going}  
 end;   {writit}       	  begin   {zhelp}  	     keep_going:=true;       line_cnt:=0;      writit('');       if (M7907 or M794X) and ce_mode then        writit('AMCLEAR        - amigo clear selected device');   
    if EAGLE or M793X then 
         writit('CACHE LOG      - display cache error log');   	    if EAGLE then  	       begin   $        writit('CACHEON        - enables disc cache (read and write)');  $ $        writit('CACHEOFF       - disables disc cache (read and write)'); $       end;  
    if EAGLE or M793X then 
 !        writit('CACHE STATS    - displays cache statistic table'); ! #    writit('CHANGE LU      - change the lu that you are working on '); #     writit('CANCEL         - cancel transaction');      writit('CICLEAR        - channel independent clear');   
    if ce_mode then  
       writit('CLEAR LOGS     - erase logs');      writit('DESCRIBE       - describe selected unit');  
    if ce_mode then  
       writit('DIAG           - perform internal diagnostics');      writit('ERT LOG        - output error rate test log');      writit('EXIT           - exit program or command');       writit('FAULT LOG      - output fault log');      writit('HELP           - output help information');   
    if ce_mode then  
       writit('INIT MEDIA     - initialize media');      writit('INPUT          - change input file or lu');       writit('OUTPUT         - change output file or lu');      writit('PRESET         - update device logs');  
    if EAGLE or M793X then 
       begin           writit('READCACHEOFF   - disables read cache');           writit('READCACHEON    - enables read cache');        end;      writit('REQSTAT        - request status');  
    if EAGLE or M793X then 
       writit('RESET STATS    - clear cache statistics table');      if M791X or M793X or M795X or EAGLE then        writit('REV            - output firmware revision');      if M791X or M793X or EAGLE then           writit('RF SECTOR      - read full sector');  !    writit('RO ERT         - perform read-only error rate test');  !     writit('RUN LOG        - output run log data');       if (M791X or M793X or M795X or EAGLE) and ce_mode then        writit('SDCLEAR        - clear selected device');   	    if M793X then  	       writit('SENSE          - output sensor data');      if M794X or M7907 or M795X then         writit('SERVO          - perform servo test');  	    if eagle then  	       writit('SERVO          - perform butterfly seek test');   
    if ce_mode then  
       writit('SPARE          - spare block');       writit('TABLES         - output device tables');      writit('TERM           - input/output at terminal');      writit('UNIT           - set unit number');   	    if EAGLE then  	       begin           writit('WRITECACHEOFF  - disables write cache');          writit('WRITECACHEON   - enables write cache');         end;  
    if ce_mode then  
 %      writit('WTR ERT        - perform write-then-read error rate test');  %   END;          PROCEDURE ZRFSECT $DIRECT$;     var   
    J           :wordtype; 
     status_bits :erraptype;   
    temp        :bytetype; 
   begin       (************************************************)      (*  Get the passed data into the correct buffer *)      (************************************************)      for J := 0 to 279 do        iobuf.extablerarea.tbl[J] := buffer[J];       "    for J := 280 to 285 do                  (* get passed address *) "       comp.address.full_addr[J-280] := buffer[J];       
    addrmode := parms[3];  
         with IOBUF.EXRFSECTRAREA do         begin           if EAGLE then             begin (* reorder header bytes *)              temp  := status;  status := pcyl1;              pcyl1 := pcyl2;   pcyl2  := spare;              spare := temp;    temp   := psect;              psect := head;    head   := temp;             end; (* of reorder header bytes *)              status_bits.allbits := status;      
        WRITELN(f);  
         prntaddr(comp.address);           if (not EAGLE) and (not status_bits.b[0]) then            WRITELN(f,'Sector sync bit missing');               WRITE(f,'Physical spare = ');           if EAGLE then             WRITELN(f,spare:3)          else            WRITELN(f,(status mod 128):3);              WRITELN(f,'Physical sector  = ',PSECT:3);           WRITELN(f,'Head = ',(HEAD mod 16):2);           if EAGLE then   !          WRITELN(f,'Logical cylinder = ',(pcyl1 * 256 + pcyl2):4) !         else  "          WRITELN(f,'Physical cylinder = ',(pcyl2 * 256 + pcyl1):4); "     
        if not EAGLE then  
           begin               WRITELN(f,'Logical spare = ',(spare mod 128):1);              if (status mod 128) <> 1 then   
              begin  
 %                WRITE(f,'Sector ',(spare mod 128):1,' has been spared ');  %                 if spare < 128 then                     WRITELN(f,'(secondary)')  
                else 
                   WRITELN(f,'(primary)');   	              end  	             else                WRITELN(f,'No sector sparing has occurred');            end  (* not EAGLE *)          else            begin (* EAGLE *)               if (spare = 123) and (not status_bits.b[1]) then                WRITELN(f,'No sector sparing has occurred')               else  
              begin  
                 WRITE(f,'Sector ',spare:1,' has been spared');                  if status_bits.b[1] then                    WRITELN(f,'(primary)')  
                else 
                   WRITELN(f,'(secondary)');   	              end; 	           end;  (* of EAGLE *)              for J := 1 to 256 do            if J mod 16 = 1 then  	            begin  	 
              WRITELN(f);  
               WRITE(f,J:3,':  ');                 writehex(DATA[J]);              end             else              writehex(data[J]);  
         WRITELN(f); 
 	      end;  {with} 	 
  end;  (* of rf sector *) 
     PROCEDURE ERROR_LOG $direct$ (logtype:wordtype);  !{****************************************************************} ! !{*  9-2-87  L. Doner  :  FIFO bit prints out for 795XA's only.  *} ! !{*                       Added T-OF for 795XB 's.               *} ! !{* 11-2-87  L. Doner  :  For 791X and 793X drives, added a check*} ! !{*                       for bit.b[3] set. Print out 'UNC' if it*} ! !{*                       is. (First retry did not get data.)    *} ! !{****************************************************************} !       var       bits    :erraptype;   
    buf     :char4;  
     x       :wordtype;        begin       (*********************************)       (* get buffer from passed string *)       (*********************************)       for x := 0 to 10 do         info[x] := buffer[x];           space(2);       print_addr(4);     (* print logical address *)      space(2);       bits.allbits := info[8];      if ISP then         begin           if bits.b[7] and M795XA then buf := 'FIFO';           if bits.b[7] and M795XB then buf := 'T-OF';           if bits.b[6]           then buf := 'REC ';          if bits.b[5]           then buf := 'M-RE';          if bits.b[4] and (M794X or M795X) then buf:='M-EC';           if bits.b[3] and (M7907 or M795X) then buf:='UNR ';           if bits.b[3] and  M794X           then buf:='UNC ';           write(F,buf);         end;      	    if EAGLE then  	       begin           case (info[8] mod 2) of             0: write(F,'COR ');             1: write(F,'UNC ');           end;  (* of case *)   
      end; (* of EAGLE *)  
         if M793X or M791X  then         begin  (* 793X/791X *)  
        if bits.b[0] then  
 
          write(f,'UNR ')  
         else  
        if bits.b[1] then  
 
          write(f,'F/S ')  
         else  
        if bits.b[3] then  
 
          write(f,'UNC ')  
         else          case (info[8] mod 4) of             0: if logtype = 197 then write(f,'CRC ')               else write(f,'COR ');            1: write(f,'UNC ');             2: write(f,'CRC ');             3: write(f,'CRC ');           end;  (* of case *)         end; (* of 793X/791X *)           space(5);       write(f,info[9]:3);  (* occurrence count *)       space(2);       wrt_binary(info[8]);      writeln(f);   
  end;  (* of error_log *) 
         procedure zfltlog $DIRECT$;     VAR       I        :wordtype;       J        :wordtype;       inum     :wordtype;       K        :erraptype;      activity :activitytype;         begin       (**********************************************)      (* Get parameters and buffer from data passed *)      (**********************************************)      if parms[3] = 0 then  
      print_paddr := true  
     else        print_paddr := false;           for I := 0 to 298 do        iobuf.extablerarea.tbl[I] := buffer[I];           with iobuf.exfltlograrea do         begin           if parms[4] = 1 then            begin               writeln(f,'# faults logged = ',parms[5]:1);               writeln(f);   
            fault_header;  
           end;          FOR I := 0 TO flt[0]-1 DO             begin (* display each fault *)  !            FOR inum := 0 TO 10 DO info[inum] := flt[I*11+inum+1]; !             if info[0] >= 128 then  
              begin  
                 if print_paddr then                     begin                       write(F,' *');                      print_addr(0);                    end   
                else 
                   write(F,'  Physical address');  	              end  	             else  
              begin  
 
                space(2);  
                 print_addr(0);  	              end; 	             if info[4] >= 128 then                begin (* physical address *)                  if print_paddr then                     begin                       write(F,'   *');                      print_addr(4);                    end   
                else 
                   write(F,'    Physical address');                end  (* of physical address *)              else  
              begin  
 
                space(4);  
                 print_addr(4);  	              end; 	             if  ISP then  
              begin  
 
                space(6);  
                 writehex(info[8]);        (* error value *)                   if M7907 then                     begin   !                    space(8);  wrt_binary(info[9]);   (* stat1 *)  !                     space(3);                     end   
                else 
                   begin   "                    space(9); writehex(info[9]);        (* stat1 *)  "                     space(7);                     end;                  writehex(info[10]);       (* stat2 *)   	              end; 	             if RSP then                 begin (* 791X or 793X or EAGLE *)   
                space(3);  
                 if not EAGLE then                     begin                       if info[10] <> 0 then                         write(F,'TERR ')                      else                        write(F,'DERR ');                        write(F,info[9]:3);       (* error value *)                        space(6);                       wrt_binary(info[8]);  (* HFR *)                     end   
                else 
                   begin  (* EAGLE *)                      case (info[10] mod 2) of                        0:  write(F,'DERR ');                         1:  write(F,'TERR ');                       end;                       write(F,info[9]:3);       (* error value *)                        case (info[10] mod 4) of                        0,1: write(F,' (E)');                         2,3: write(F,' (F)');                       end;                      space(2);                       wrt_binary(info[8]);  (* HFR *)                       space(5);                       with activity do                        begin                           activity_byte := info[10];  $                        write(F,nibble[0]:2);  (* activity indicator *)  $ 
                      end; 
                   end;   (* of EAGLE *)                 end;  (* of 791X or 793X or EAGLE *)              writeln(F);  (* display line *)             end; (* of display each fault *)        end;    end;  (* of zfltlog *)          FUNCTION CHECKQSTAT $DIRECT$ (print_status:boolean) :boolean;   $(**********************************************************************) $  (* 1-26-88  L. Doner  : Modified for son program. (print_status)   $(**********************************************************************) $   begin   
    if IOBUF.QSTAT=0 then  
       checkqstat := true      else        begin           if (IOBUF.QSTAT = 1) or (IOBUF.QSTAT = 2) then            if IOBUF.FQSTAT = 0 then  	            begin  	               if print_status then                  begin                     buffer[20] := 7;   {from Son}                     prntstatus;   
                end; 
             end             else              writeln(f,'Error during Request Status');           checkqstat := false;        end;    end;  (* of checkqstat *)       procedure dash_write $DIRECT$;  var I :bytetype;    begin       for i := 0 to 60 do write(F,'-');       writeln(F);     end;      &FUNCTION DOUTIL $DIRECT$(unum,utype,ulgn:wordtype;uparm1:bytetype) :boolean; &   begin       with IOBUF.EXMISCTAREA do         begin   
        UTILNUM  := UNUM;  
 
        UTILTYPE := UTYPE; 
 
        PARMLGN  := ULGN;  
         PARM1    := UPARM1;   
        EXLGN    := 1024;  
       end;      XUTIL(LU,DA,COMP,IOBUF);      doutil := checkqstat(true);     end;      PROCEDURE ZCACHE_CONTROL $direct$ (option:wordtype);  '(****************************************************************************) ' '(* 3-6-1987  L. Doner    Original version                                   *) ' '(* 1-28-1988  L. Doner   Moved to son to make father smaller. New Good_end  *) ' '(*                       Bad_end. No Outbuf. Added comp := nullcomp. Endit. *) ' '(****************************************************************************) ' '(* OPTION : Parameter passed to this procedure to indicate utility required.*) ' (* ------   
(*      1 : Read Cache On  
 
(*      2 : Read Cache Off 
 
(*      3 : Write Cache On 
 (*      4 : Write Cache Off   (*      5 : Read and Write Cache On   (CACHEON)   (*      6 : Read and Write Cache Off  (CACHEOFF)  '(****************************************************************************) ' var   	  endit : boolean; 	     Procedure Good_end $direct$;  Begin     writeln(f);     writeln(f,'CACHE CONTROL UTILITY COMPLETED');     dash_write;     endit := true;  end;      Procedure Bad_end $direct$;   Begin     writeln(f);     writeln(f,'CACHE CONTROL UTILITY FAILED');    dash_write;     endit := true;  end;      BEGIN   	  endit := false;  	 	  lu := buffer[0]; 	 	  da := buffer[1]; 	 
  comp := nullcomp;  
       writeln(f);     dash_write;     case OPTION of      1,2:  writeln(f,'READ CACHE CONTROL UTILITY');      3,4:  writeln(f,'WRITE CACHE CONTROL UTILITY');       5,6:  writeln(f,'CACHE CONTROL UTILITY');     end;                                           {Read Cache Status}    if DOUTIL (196,2,1,7) then                                          {196 = Read Cache Status}                                           {  2 = Device send text }                                           {  1 = # parameters sent}                                           {  7 = Cache table area }         with IOBUF.CACHETABLEAREA do          begin   !          if ((option<>3) and (option<>4)) then    {Reading Cache} ! 	            begin  	               case CACHE_READ_STATUS of                   0,1: writeln(f);  
                  3: begin 
                        writeln(f);  '                       writeln(f,'Read Cache disabled because of RAM error.'); '                        bad_end;   
                     end;  
 
                  2: begin 
                        writeln(f);  !                       writeln(f,'Read Cache is not installed.');  !                        bad_end;   
                     end;  
                   otherwise   
                     begin 
                        writeln(f);                          writeln(f,'Unknown Read Cache Status.');                           bad_end;   
                     end;  
 
              end; {case}  
               if NOT endit then   
              begin  
                  if ((option=2) and (cache_write_status=0)) then                      begin                       writeln(f);   "                    writeln(f,'Write Cache is currently enabled.');  " $                    writeln(f,'Write Cache must be disabled prior to ',  $                     'disabling Read Cache.');                       bad_end;                    end;                end;  {Not endit}               end; {option <>3 and option<>4}                 if NOT endit then             begin   &            if ((option<>1) and (option<>2)) then        {Writing to cache}  &               case CACHE_WRITE_STATUS of                  0,1: writeln(f);  
                  3: begin 
                        writeln(f);  '                      writeln(f,'Write Cache disabled because of RAM error.'); '                        bad_end;   
                     end;  
 
                2,5: begin 
                        writeln(f);  !                       writeln(f,'Write Cache is not installed.'); !                        bad_end;   
                     end;  
 
                otherwise  
 
                     begin 
                        writeln(f);                          writeln(f,'Unknown Write Cache status.');                          bad_end;   
                     end;  
 
              end; {case}  
             end;  {not endit}                 if NOT endit then             begin   %            if ((option=1) or (option=5)) then    {Read Cache On, Cacheon} %               if((option=1) and (cache_read_status=0)) then                   begin                     writeln(f,'Read Cache is already enabled.');                    good_end;   
                end  
 	              else 	 !                if DOUTIL(211,0,1,1) then     {Enable read cache}  ! &                                              {211 : Cache Control Utility}  & &                                              {  0 : No execution message }  & &                                              {  1 : # parameters sent    }  & &                                              {  1 : Read on, write off   }  &                   begin                       writeln(f,'Read Cache is enabled.');                      if (option=1) then good_end;                    end   
                else 
                   bad_end;   {end if doutil}            end;  {Not endit}                 if NOT endit then             begin   '            if ((option=3) or (option=5)) then       {Write Cache On, Cacheon} ' 
              begin  
                  if ((option=3) and (cache_read_status<>0)) then                      begin   '                    writeln(f,'Read Cache must be enabled for Write Cache to', '                     ' be enabled.');                      bad_end;                    end;                  if NOT endit then                   begin   !                  if ((option=3) and (cache_write_status=0)) then  ! 
                    begin  
 "                      writeln(f,'Write Cache is already enabled.');  "                       good_end;                       end   %                  else                               {Enable Write Cache}  %                     if DOUTIL(211,0,1,3) then   '                                                {211 : Cache Control Utility}  ' '                                                {  0 : No execution message }  ' '                                                {  1 : # parameters sent    }  ' '                                                {  3 : Read on, write on    }  '                       begin                           writeln(f,'Write Cache is enabled.');                           good_end;   
                      end  
                     else    {failed}                        bad_end;                  end; {Not endit}                end;  {option=3 or option=5}            end;   {Not endit}                if NOT endit then             begin   &            if ((option=4) or (option=6)) then             {Write cache off} &               if ((option=4) and (cache_write_status=1)) then                   begin                      writeln(f,'Write Cache is already disabled.');                     good_end;   
                end  
 #              else                              {Disable Write Cache}  #                 if DOUTIL(211,0,1,1) then   &                                              {211 : Cache Control Utility}  & &                                              {  0 : No execution message }  & &                                              {  1 : # parameters sent    }  & &                                              {  1 : Read on, write off   }  &                   begin                       writeln(f,'Write Cache is disabled.');                      if (option=4) then good_end;                    end                   else  {failed}  
                  bad_end; 
           end;  {Not endit}                 if NOT endit then             begin   &            if ((option=2) or (option=6)) then    {Read cache off, Cacheoff} &               if ((option=2) and (cache_read_status=1)) then                  begin                      writeln(f,'Read Cache is already disabled.');                      good_end;   
                end  
 	              else 	 "                if DOUTIL(211,0,1,0) then       {Disable Read Cache} " &                                              {211 : Cache Control Utility}  & &                                              {  0 : No execution message }  & &                                              {  1 : # parameters sent    }  & &                                              {  0 : Read off, write off  }  &                   begin                       writeln(f,'Read Cache is disabled.');                       good_end;                     end                   else   {failed}                     bad_end;         {end if doutil}             end; {Not endit}            end      {with iobuf.cachetablearea}       else        bad_end;  END;       {ZCACHE_CONTROL}       begin   {exer1}       	  M794X  := false; 	 	  M7907  := false; 	 	  M791X  := false; 	 	  M793X  := false; 	 	  M9140  := false; 	 	  M9144  := false; 	 	  EAGLE  := false; 	 	  M795X  := false; 	       get_parms(parms);   (* get passed parms *)    ce_mode:=parms[3] = 1;    rewrite(crt,'1','shared');    cc := get_buf(-1,buffer,bufrlen);   
  for i:=1 to 64 do  
     outfile[i]:=chr(buffer[i+299]);     if outfile[1] in ['1'..'9'] then      rewrite(f,outfile,'shared')      else       append(f,outfile,'shared');     (***************************************)     (* determine the model number of drive *)     (***************************************)   	  case parms[2] of 	     0: M794X  := true;      1: M7907  := true;      2: M791X  := true;      3: M793X  := true;      4: M9140  := true;      5: M9144  := true;      6: EAGLE  := true;      7: M795XA := true;      8: M795XB := true;    end;  (* of case *)         if M795XA or M795XB then M795X := true;     isp:= M7907 or M794X or M795X;    rsp:= M791X or M793X or EAGLE;  
  (**********************) 
 
  (*  determine command *) 
 
  (**********************) 
 	  case parms[1] of 	     1: ZHELP;   
    2: fault_header; 
 	    3: log_header; 	     4: prnt_fault_error;      5: prt_error_info(parms[3]);  	    6: prntstatus; 	     7: disp_cache_stat_tbl;       8: zsense;      9: zcache_control(parms[2]);      11: zrdtbls;      12: zrfsect;      13: error_log(parms[3]);      14: zfltlog;      otherwise   	      (* null *);  	   end;  (* of case *)   $  rewrite(f,'1','shared');  {this statement prevents printer page eject} $ 	  parms[1]:=ifbrk; 	   prtn(parms);     {Return the parameters to the father}  end. 