 ${*********************************************************************}  $ $PASCAL '91751-1X027 REV.5010 <880721.1126>'  ${*********************************************************************}  $ ${                                                                     }  $ ${    FILE:   XSCH.PAS                                                 }  $ ${    SOURCE: 91751-18027                                              }  $ ${    RELOC.: 91751-1X027                                              }  $ ${                                                                     }  $ ${  ***************************************************************    }  $ ${  * (C) COPYRIGHT HEWLETT-PACKARD COMPANY 1982.  ALL RIGHTS     *    }  $ ${  * RESERVED.  NO PART OF THIS PROGRAM MAY BE PHOTOCOPIED,      *    }  $ ${  * REPRODUCED OR TRANSLATED TO ANOTHER PROGRAM LANGUAGE WITHOUT*    }  $ ${  * THE PRIOR WRITTEN CONSENT OF HEWLETT-PACKARD COMPANY.       *    }  $ ${  ***************************************************************    }  $ ${                                                                     }  $ ${---------------------------------------------------------------------}  $ ${                                                                     }  $ ${  Contains the following procedures and functions :                  }  $ ${                                                                     }  $ ${  - GEN_CLEAN_UP_LINKDOWN clean VC & EQT tables, timers & Q length   }  $ ${                                                                     }  $ ${  - XSCH : - P_NEWREQUEST :                                          }  $ ${               - READ_REQ                                            }  $ ${               - WRITE_REQ                                           }  $ ${               - ( control ) : - F0_CLEARDEVICE                      }  $ ${                               - F6_EQTTYPE                          }  $ ${                               - F16_INTERRUPT                       }  $ ${                               - F26_FLUSH                           }  $ ${                               - F31_ESTCIRC                         }  $ ${                               - F32_CLEARCIRC                       }  $ ${                                                                     }  $ ${           - P_SPECIALREQUEST :                                      }  $ ${               - P_SPECREQ_REPLY                                     }  $ ${               - P_SPECREQ0  ( enable network )                      }  $ ${               - P_SPECREQ1  ( allocate pool/modify SVC )            }  $ ${               - P_SPECREQ23 ( get pool info/release pool )          }  $ ${               - P_SPECREQ4  ( enable tracing )                      }  $ ${               - P_SPECREQ5  ( disable tracing )                     }  $ ${               - P_SPECREQ6  ( get incoming call info )              }  $ ${               - P_SPECREQ7  ( deallocate a pool LU )                }  $ ${               - P_SPECREQ8  ( get network state )                   }  $ ${               - P_SPECREQ9  ( shutdown )                            }  $ ${                                                                     }  $ ${           - P_HANDSHAKEREAD                                         }  $ ${                                                                     }  $ ${           - RESET_AND_EQTCLEAR                                      }  $ ${                                                                     }  $ ${           - P_QBITDATAREAD process compl. of direct Q bit data read }  $ ${                                                                     }  $ ${           - P_DATAPKTWRITE process completion by the card of a data }  $ ${                                                          pkt write. }  $ ${                                                                     }  $ ${---------------------------------------------------------------------}  $     ${---------------------------------------------------------------------}  $ ${                                                                     }  $ ${ HISTORY :                                                           }  $ ${                                                                     }  $ ${ Original    : 2201                                                  }  $ ${ Change #1   : 2401                                                  }  $ ${   .access to CUD                                                    }  $ ${   .user access to Q-bit data packets                                }  $ ${   .flow control enhancements                                        }  $ ${   .no automatic pool vc deallocation                                }  $ ${ Change #2   : 2440                                                  }  $ ${   .Soft Error bit set in status when CN31 issued while              }  $ ${    network is not ready yet.                                        }  $ ${   .Support of RTE-A3 and new compiler.                              }  $ ${ Change #3   : 5.0   (BG)                                            }  $ ${   .Implementation of a Restart Delay Time Out. (M2)                 }  $ ${   .Improve the Restart Network process. (M13)                       }  $ ${   .Add special requests 8 GetNetworkState and 9 ShutDown. (M19)     }  $ ${   .Add a read flush in the network restart process.       (M19)     }  $ ${   .Adapt variable REGAB to a global declaration. (M27)              }  $ ${   .Updated no abort error processing. (M28)                         }  $ ${   .Load segment XSEG3 before each call to XSUSP. (M30)              }  $ ${   .Move Gen_clean_up_linkdown outside of procedure XSCH, to allow   }  $ ${    it to be accessed from procedure do_shutdown in XSEG3. (M30)     }  $ ${   .When a CN32 close VC is received for an open circuit,            }  $ ${    reset any running VCTO timer. (M37)                              }  $ ${ Change #4   : 5.1    (BG)                                           }  $ ${   .Correct XSUSP case number from 3 to 7,  to improve error         }  $ ${    reporting.                                               (M46)   }  $ ${   .Improve error detection in P_specialreq6.                (M52)   }  $ ${   .Suppress the READFLUSH in the network restart procedure. (M53)   }  $ ${   .Modify F31_estcirc to reject the request if the EQT is not in    }  $ ${    state P1 instead of just P4 state ( data transfer ready ). (M54) }  $ ${   .Remove procedure DO_SHUTDOWN from XSEG3 and process shutdown     }  $ ${    from procedure P_specreq9 completely.                    (M63)   }  $ ${                                                                     }  $ ${*********************************************************************}  $     
$STANDARD_LEVEL 'HP1000'$  
 $RANGE OFF$   $CDS OFF$   	$HEAP_DISPOSE OFF$ 	 $SUBPROGRAM , RECURSIVE OFF$  $HEAP 2$      PROGRAM   XSCHEDULE ;            $title 'X.25/1000  XSCH scheduler'$       { Includes  XTBLG.PASI, XTBLV.PASI, XNETG.PASI }    $LIST OFF$    $INCLUDE 'XTBLG.PASI'$    $INCLUDE 'XTBLV.PASI'$    $INCLUDE 'XNETG.PASI'$    $LIST ON, PAGE$   {*** PROCEDURES AND FUNCTIONS IN SYSTEM LIBRARY ***}       	 $ HEAPPARMS OFF$  	 ! procedure STOP $alias 'EXEC' {PROGRAM COMPLETION}$ (icode:word);  !   external;       $ procedure  XEXEC2 $alias 'EXEC' {direct write}$ {special for messages}  $   (icode, icnwd: word; ibuf: XMSGtype; ilen: word );    external;        procedure  RNRQ (icon,rn:word; var Istat:word);    external;        {special for shutdown, release of class numbers}    procedure CLRQ $ alias 'CLRQ' , noabort $     (icode : word; class_number: word ) ; external ;        procedure ABREG ( var areg, breg : word ) ;    external;        procedure IOWRITE $alias 'EXEC', NOABORT $                      { class I/O write-read to LU 0 }   !  (icode,icnwd: word; var ibuf: a25W; ilen,ip1,ip2,iclass: word);  !   external;       ! procedure LOADSEG $alias 'pas.segmentload'$     {M30 BG 16FEB87}  !            ( Segname : string5 ); external ;       {*** PROCEDURES AND FUNCTIONS IN MODULE XNETM ***}         procedure XMSGWR (msglu:word;msgindex:byte;lunb:word); $direct$     external;        procedure  INGNRES ( rescause : byte ) ; $direct$  external ;      
 procedure  LINKDOWN 
 !    (eqtptr : EqtPtrType ; reason : word ) ; $direct$  external ;  !     ! procedure  LINKUP ( eqtptr : EqtPtrType ) ; $direct$  external ;  !     
 procedure  EQTCLEAR 
 !    ( EP: EqtPtrType; EQTid,Status : word) ; $direct$  external ;  !     $ procedure ESTABLISHCIRCUIT (eqtptr: EqtPtrType) ; $direct$  external ;  $      procedure P1SETUP (VCP: VCptrType ) ; $direct$  external ;        procedure D1CLEANUP (vcp: VCptrType) ; $direct$  external ;      # Procedure FLUSH_MESSAGE (EQP: EQTPTRtype;LastB: EMAPTRtype); $direct$ #   external;        $page$    {*** PROCEDURES AND FUNCTIONS IN MODULE XRECV ***}       	 procedure  XSEND  	     ( Messagetype : XSENDmsg;         EPTR : EqtPtrType;        EQTid : bits2; {1=write eqt; 2=read eqt}        W3value,        W4value : word);    external;            {*** PROCEDURES AND FUNCTIONS IN MODULE XSEG4 ***}        Procedure  PKTHD ;  $direct$  external ;        Procedure  XPKT  ;  $direct$  external ;       	 Procedure  PDSUP  	   ( var Task : byte; var ibuf : ibuftype;   !    var ilen : word; var immrq : bitsword ); $direct$  external ;  !          {*** PROCEDURES AND FUNCTIONS IN MODULE XSEG3 ***}        procedure XSUSP (n:word); $direct$  external ;        $skip_text on$                         {M63 BG 20JUL88}   Procedure DO_SHUTDOWN  { referenced by p_specreq9 }         ( var reply_synch_RN1, reply_synch_RN2 : word ) ;                                                external ;                                          {M30 BG 16FEB87}   $skip_text off$      ! {*** PROCEDURES AND FUNCTIONS REFERENCED FROM X25LB LIBRARY ***}  !      Procedure XTMGR {access and update XTBL in SAM}    (f:word; var index,length: word; var T: XTBLwordstype;     WriteResLu: word);     external; { referenced by special requests 1 modify SVC }               {        and by special requests 9 shut down  }            $page$    {****************************************}    PROCEDURE  GEN_CLEAN_UP_LINKDOWN; $direct$    {****************************************}        { called from P_HandshakeRead in XSCH   }   {        from XSCH if IP1HandshakeWrite }   {        from "do_shutdown" in XSEG3    }       BEGIN         with NETWP^ do  begin       {--------------------------------------------}        {Phase 1: clean up of all VC tables of NETWP }        {--------------------------------------------}   
       VCPTR := FirstVC ;  
        {Explore circular list (always at least one vc):}         repeat          {} with VCPTR^ do begin         {}   {}         {}   {}  If VCtype = pvc          {}   {}  then  D1CleanUp (VCPTR)   
       {}   {}  else begin 
        {}   {}      AssociatedEQT := NIL ;         {}   {}      X25P := P1;  { Call Set Up Ready }         {}   {}      PktWriteNeeded := false;         {}   {}      Flushdata := false;   
       {}   {}  end; 
        {}   {}  Cause := 0;   
       {}   {}  Diag := 0; 
        {}   {}  DataAvailable := false;          {}   {}  MSGinProgress := false;          {}   {}  VCTO := -1;          {}   {}  RetryCtr := 0;         {}   {}  CallRetryCtr := 0;         {}   {}  Setup_ema_user := false;         {}   {}         {}   {}  VCPTR := NextVC ;          {}   {}         {} end {with VCPTR^};         {}          until  VCPTR = FirstVC ;            {------------------------------------------------}        {Phase 2: clean up EQT tables and send Link Down }        {------------------------------------------------}          EQTPTR := FirstEqt ;          While ( EQTPTR <> NIL ) do begin          {}   With EQTPTR^, EQText do begin   #       {}   {}   If (EqtType = pooleqttype) and (AssociatedVC <> nil)  #        {}   {}   then {Set active pool lus down}         {}   {}      Downflag := true;   "       {}   {}   If EqtType <> pvceqttype then AssociatedVC := nil;  "        {}   {}   {Update EMA pointers and variables}         {}   {}   EMAcounter := 0;          {}   {}   Nextbuffertoread := nil;          {}   {}   {Nextfreebuffer unchanged}          {}   {}         {}   {}   LINKDOWN ( EQTPTR , GenResCause );   $       {}   {}      {Note: sets NoReq state and estcircreceived =false}  $        {}   {}   EQTPTR := NextEQT         {}   end   	       end{while}; 	  $page$        {-------------------------------------------}       {Phase 3: Clean up timers for this network  }       {-------------------------------------------}          { If ReadWaitTO <> -1 }   "        GlobalTOctr:= GlobalTOctr - X25TOctr; { update global ctr }  "         X25TOctr := 0;          RestConfWaitTO := -1;   
        RestRetryCtr := 0; 
          RestartDelayWaitTO := -1 ;               {M2 BG 25apr85}            ResetDelayWaitTO := -1 ;                {M13 BG 21may86}            {--------------------------------------------}        {Phase 4: Q Length clean up                  }        {--------------------------------------------}            QLength := 0;      
   end {with Netwp}  
      END ; { GEN_CLEAN_UP_LINKDOWN }                      $page$  ${*********************************************************************}  $ ${                                                                     }  $ ${!}    PROCEDURE  XSCH ;       $direct$                             {!}  $ ${                                                                     }  $ ${  Process information placed by XRECV into the folling variables :   }  $ ${    XNETip1    : XNET mail identifier, used to recognize action      }  $ ${    XNETip2    : write EQT address                                   }  $ ${    XNETip3    : new request type; 1 = read, 2 = write, 3 = control  }  $ ${    CURRENTNET : network index to current network beeing looked at   }  $ ${    XNETstatus : completion status word : EQT5 (RTE6) or DVT6 (RTEA) }  $ ${    XNETtlog   : completion transmission log, XNETibuf word size     }  $ ${    XNETibuf   : buffer received containing mail to XNET             }  $ ${    SAMOK      : true if not previously blocked due to lack of SAM.  }  $ ${                                                                     }  $ ${  Contains the following procedures and functions :                  }  $ ${                                                                     }  $ ${    - P_NEWREQUEST                                                   }  $ ${    - P_SPECIALREQUEST                                               }  $ ${    - P_HANDSHAKEREAD                                                }  $ ${    - RESET_AND_EQTCLEAR                                             }  $ ${    - P_QBITDATAREAD                                                 }  $ ${                                                                     }  $ ${*********************************************************************}  $ $page$  ${*********************************************************************}  $ ${                                                                     }  $ ${!}    PROCEDURE    P_NEWREQUEST ;         $direct$                 {!}  $ ${                                                                     }  $ ${  Contains the following procedures and functions :                  }  $ ${    - READ_REQ                                                       }  $ ${    - WRITE_REQ                                                      }  $ ${    - ( control ) : _ F0_CLEARDEVICE                                 }  $ ${                    _ F6_EQTTYPE                                     }  $ ${                    _ F16_INTERRUPT                                  }  $ ${                    _ F26_FLUSH                                      }  $ ${                    _ F31_ESTCIRC                                    }  $ ${                    _ F32_CLEARCIRC                                  }  $ ${                                                                     }  $ ${*********************************************************************}  $       LABEL 99 ; { to speed up EQTSEARCH phase }        TYPE          CONVREQTYPE = record  { to access request code and subf }                       case boolean of                         false: ( W  : word ) ;                        true : ( W1 : EqtW1Type ) ;                     end ;         VAR           CONVREQ  : convreqtype ;      SENDDVX  : boolean ;      INET     : 0..4096 ;  
    EQTADD, S, T : word ;  
 "    PDSUPreq : boolean ; {true:req comes from PDSUP/false:from DVX}  "      $subtitle 'P_NEWREQUEST' , page$     {*****************************************}     PROCEDURE  READ_REQ  ;            $direct$    {*****************************************}         { Note: MUST be sent only on READ eqt ! (no verif here) }         BEGIN       "   With Netwp^, EQTPTR^, WriteReadEQT[2] {read eqt},AssociatedVC^ do "     begin        If EstCircReceived  { Link is UP; no CN 32B issued }        then begin          If Not MSGinProgress          then begin  { illegal read : no DATA yet ! }          {}          { READ request is tranported only }         {}          { once unsolicited data has been received }         {}   if SystemType = RTE_A          {M34 BG 15JUN87}          {}     then S := HardErrorStatusA         {}     else S := HardErrorStatus ;   
       {}   T := 0 ; 
        {}   SendDvx := true ;          {}   Currentnet := -1 ;         end  	       else begin  	        {}  { store request in read eqt table : }         {}  W1 := convreq.W1 ; { record assignement }         {}  W2 := XNETIBUF.W[4] ; { @ in SAM }           {}  W3 := - XNETIBUF.W[5] ; { positive length in bytes }           {}  EqtStatus := 0 ;   
       {}  EQTtlog := 0 ;  
        {}          {}  case RequestSubf of         {}  0, 8 : { Read without/with flush }   	       {}    begin 	        {}      ReqState := ReadState ;  !       {}      If  EMAcounter > 0  then  Setup_ema_user := true ;  !        {}      { if no Data in EMA , wait for data pkt }  	       {}    end ; 	        {}  1 : { Direct Read }  	       {}    begin 	        {}      If DataAvailable   
       {}      then begin  
        {}      {} GlobalRead := ReadQbitData;          {}      {} RespEQT := EQTPTR;         {}      {} ReqState := ReadState;         {}      {} {Cancel Timer suppressed:}  	       {}      end 	        {}      else begin { Qbit read illegal if no }          {}      {}         { Data Available on card  }           {}      {} if SystemType = RTE_A        {M34 BG 15JUN87}           {}      {}   then S := HardErrorStatusA         {}      {}   else S := HardErrorStatus ;   
       {}      {} T := 0 ; 
        {}      {} SendDVX := true ;          {}      {} CurrentNet := -1 ;  	       {}      end 	        {}    end {direct read};          {}          {} Otherwise  { illegal subf }           {}       if SystemType = RTE_A          {M34 BG 15JUN87}           {}         then S := HardErrorStatusA         {}         else S := HardErrorStatus ;          {}       T := 0 ;         {}       SendDvx:= true ;         {}       CurrentNet := -1 ;  
       {} end {case} 
        end       end       else   { not EstCircReceived }          If AssociatedVC <> nil then           begin             EMAcounter := 0;              Nextbuffertoread := nil ;           end ;         end {with}       	  end {READ_REQ};  	  $page$     {***************************************}     PROCEDURE  WRITE_REQ ;          $direct$    {***************************************}         {Note: MUST be sent ONLY on WRITEeqt ! (no verif here)}     {      DVX00 does not send it BEFORE CN 31B           }   "  {But beware: DVXOO may send it just after a CN 32B without wait !} " "  {            (in this case, EstCircReceived is false)            } "       BEGIN       !    If (XNETIBUF.W[5]=0) and ((RequestSubf=0) or (RequestSubf=4))  !     then begin { zero length : complete immediately }         S := 0 ;        T := 0 ;        SendDVX := true ;         CurrentNet := -1 ;      end       else begin        With EQTPTR^, WriteReadEQT [1] , AssociatedVC^ do begin           If EstCircReceived  {verify no CN 32B issued!}          then begin {process normally}           {} {Link is UP, so we are in state P4}          {}          {} ReqState:= WriteState;           {} W1:= convreq.W1; {record assignement}          {} W2 := XNETIBUF.W[4];           {} W3 := - XNETIBUF.W[5]; {positive length in bytes}          {} EQTstatus:=0; EQTtlog:=0;          {} WriteCount := 0;           {}  "        {} If X25D = d1    {we could check RNR=false and Window ok}  "         {} then PKTwriteNeeded := true;           {}          {} {Note: do not set PKTwriteNeeded to false here}          end           {else: ignore; link down soon on this pvc}        end {with}      end {if};   	  end {WRITE_REQ}; 	  $page$     {*******************************************}     PROCEDURE   F0_CLEARDEVICE ;        $direct$    {*******************************************}         {Complete as soon as possible, but must wait until   }    {WriteCount=0.     }    {If VC is in state D1, then initialize a RESET.}        VAR   index : word;         BEGIN           {No need to store the request in eqt table}       
    With EQTPTR^ do  
       begin           If WriteReadEqt [WriteReadEqtIndex].ReqState  = NoReq           then begin {complete the request and do nothing}          {}   S:=0; T:=0; SendDvx:=true;           {}   CurrentNet := -1           end   	        else begin 	         {}   EQTCLEAR (EQTPTR,WriteReadEQTindex, 0 {status} );          {}   If Eqttype <> padeqttype           {}   then begin           {}   {}   {set index to "other" eqt:}   $        {}   {}     If WriteReadEqtIndex=1 then index:=2 else index:=1;  $         {}   {}           {}   {}   EQTCLEAR (EQTPTR, index, SoftErrorStatus )  	        {}   end;  	         {}          {}   If EstCircReceived {Verify if link really up!}           {}   then begin           {}      With AssociatedVC^ do begin           {}      {}  If (X25P = P4) and (X25D = d1)          {}      {}  then begin {initialize a Reset}           {}      {}       X25D := d4 {send reset};           {}      {}       Cause := 0 ; { ???? }          {}      {}       Diag := 0 ; { ????? }          {}      {}       PKTwriteNeeded := true;          {}      {}  end           {}      end {with AssociatedVC}           {}   end {if EstCircReceived}           {}   {else do nothing}        end       end {with Eqtptr}       
  end { F0_ClearDevice  }; 
  $page$     {**********************************************}    PROCEDURE   F6_EQTTYPE  ;              $direct$     {**********************************************}        {immediate completion}        BEGIN           {No need to store the request in eqt table}           CurrentNet := -1;       S:= 0; SendDVX := true;       
    With EQTPTR^ do begin  
         {Type Code stored in bits 0-3 of T:}      
         Case EQTtype  of  
                pvcEqtType :  T := 1;                 svcEqtType :  T := 2;                 PoolEqtType:  If Remote.W[1] = DummyNetwAdd.W[1]                            then T := 3                           else T := 4;                  padEqtType :  T := 5   
         end {case}; 
         {LU number stored in bits 4-11 of T:}          T:= T + WriteLUnb*16;         If WriteReadEQTindex = 2            then T:= T+16 ; { add 1 for read lu number }       
   end {with EQTPTR} 
 
  end { F6_EQTTYPE}; 
  $page$     {***************************************}     PROCEDURE   F16_INTERRUPT  ;     $direct$     {***************************************}         {Note: should be sent ONLY on WRITE eqt ! (no verif here) }     {      Link should be UP (VC associated and in state p4)  }     {Beware of possible previous CN 32B without wait!}        BEGIN       "    {Request completed only after receipt of interrupt conf packet}  "         With EQTPTR^, WriteReadEQT[1] , AssociatedVC^ do begin           If EstCircReceived {no previous CN 32B without wait}        then begin        {}        {}  If (X25P = P4) and (X25D = D1)   
     {}  then  begin 
      {}  {}        {}  {} {Note: we should have here X25EI=NotInterrupting}        {}  {}         {}  {} ReqState := CompleteWaitState ; {wait for int conf}         {}  {} {store req parm:}        {}  {}    W1:= ConvReq.W1 ;  {record assignement}       {}  {}    W2:=0; W3:=0; EQTstatus:=0; EQTtlog:=0;       {}  {} X25EI := SendInt;        {}  {} diag := XNETIBUF.B[9]; {interrupt user data byte}        {}  {}        {}  {} PKTwriteNeeded := true       {}  end  $     {}  else begin {must reject, because I cannot set EI in this case}  $      {}    S:= SoftErrorStatus;  T := 0; SendDvx := true       {}  end       {}        end {if estcircreceived}        {else ignore: link down soon}          end {with}        end { F16_INTERRUPT };   $page$     {*******************************************}     PROCEDURE   F26_FLUSH  ;            $direct$    {*******************************************}         {Note: should be sent only on READ eqt ! (no verif here)}     {      Link should be UP (VC associated and in state p4)  }     { Beware of possible previous CN 32B without wait!}         BEGIN           { Always immediate completion. }      { No need to store the request in read eqttable.}            If EQTPTR^.AssociatedVC <> nil        then  FLUSH_MESSAGE (EQTPTR,EQTPTR^.Nextbuffertoread);            S:=0; T:=0; SendDvx := true      
  end { F26_FLUSH }; 
  $page$     {***************************************}     PROCEDURE  F31_ESTCIRC  ;       $direct$    {***************************************}       $  { Establish virtual circuit normally completes with a LINKUP when   }  $ $  { the call is accepted by the remote.                               }  $ $  { If request option is "active mode",                               }  $ $  { followed later by either Est Circ Error or Link up (or Link down) }  $ $  { If request option is "passive mode",                              }  $ $  { followed later by link up (or link down) or possibly nothing!     }  $ $  {                                                                   }  $ $  { Note: it should be sent only on WRITE eqt (no verification here)  }  $ $  { Beware: reject with hard Error if CN31 on a down pool LU          }  $ $  {                                if Virtual Circuit already establ. }  $ $  {                                if Virtual Circuit is about closing}  $ $  {                                if open line not completed         }  $ $  { Beware: reject with soft Error if network not ready because       }  $ $  {         restart has not been sent or restart conf not received.   }  $ $  {                                                                   }  $ $  { Always immediate completion. No wait is made for the remote to    }  $ $  { accept the call.                                                  }  $     
  VAR status : word; 
       BEGIN         { No need to store the request parm in write eqt table}         With EQTPTR^ , EQText do begin         If  (( EQTtype = pooleqttype ) and ( downflag = true )) or          (( EstCircReceived ) and { EQT enabled }           ( AssociatedVC <> nil ) { EQT associated to VC } and  $       $skip_text on$                                   {M54 BG 16JUN88} $ "        ( AssociatedVC^.X25P = P4 ))   { data transfer ready state } "        $skip_text off$  $        ( AssociatedVC^.X25P <> P1 ))  { not in Call setup ready state } $    then { reject with hard error :                      }      {}   {    - CN31 on a down pool lu                   }      {}   {    - or Circuit not in Call setup ready state }      {}      {} if SystemType = RTE_A          {M34 BG 15JUN87}      {} then  #   {}  XSEND(NormalCompMsg, EQTPTR, 1{write EQT}, HardErrorStatusA, 0) #    {} else  #   {}  XSEND(NormalCompMsg, EQTPTR, 1{write EQT}, HardErrorStatus, 0)  #    {}      else If (( NETWP^.X25R = R4 ) or ( NETWP^.X25R = R3 ))   "   Then       { reject: network not ready because RESTART not sent } " "   {}         {         or RESTART CONF not received yet.          } " #   {}  XSEND(NormalCompMsg, EQTPTR, 1{Write EQT}, SoftErrorStatus, 0)  #    {}      else begin  { accept "establish circuit" command }      {}      {}  EstCircReceived := true;      {}  XSEND ( NormalCompMsg, EQTPTR, 1{write EQT}, 0, 0 );      {}      {}  If EQTtype = PvcEqtType  "   {}  then  LINKUP ( EQTPTR ) { immediate link up; nothing to do }  "    {}  else      {}    begin     {}     { we set incoming CUD to zero (meaningless value), }     {}     { because the circuit is established by a CN31B    }     {}     { and not by an incoming call .                    }     {}     CUDin := ZeroCUD;      {}      {}     { is establish circuit option = active mode ? }   !   {}     If (( XNETIBUF.W[4] <> 2 ) and ( XNETIBUF.W[4] <> -2 ))  !    {}     then EstablishCircuit ( EQTPTR );      {}     { else do nothing: SVC is now in "listen mode" }     {}    end     end;     end {with}  
  end {F31_ESTCIRC}; 
  $page$     {*************************************}     PROCEDURE  F32_CLEARCIRC    ; $direct$    {*************************************}         {Note: should be sent ONLY on WRITE Eqt (no verif here)}    {      Link may be down                }    {Immediate completion, followed by Link Down }    {No need to store the request in eqt table}         BEGIN           With EQTPTR^, EQText  do begin      !       EstCircReceived := false; {Must NOT check if already false} !            XSEND ( NormalCompMsg,EQTPTR, 1 {write eqt}, 0,0) ;               { PVC : - If state D1 ( Flow control ready ) }        {         then  send RESET Cause 0, DIAG 0.  }        {       - Set ReqState to LinkDownState.     }              If EqtType = pvceqttype  	       then begin  	             {always a VC associated, and in state p4}               With AssociatedVC^ do begin               {} If X25D = d1               {}   then begin               {}              X25D := d4 {send reset};              {}              Cause := 0 ;              {}              Diag := 0 ; { ?? }              {}              PKTwriteNeeded := true;               {}            end               {} {If not d1, do NOT change}               end {with};                   WriteReadEqt [1].ReqState := LinkDownState;               WriteReadEqt [2].ReqState := LinkDownState         end   $page$          else begin  {not pvceqttype}              { SVC enabled in listen mode :                       }          { - Send LinkDown to DVX.                            }          { - If POOL EQT set POOL EQT Down, but don't release }                   If AssociatedVC = nil               then begin {listen mode}              {}    If EQTtype = pooleqttype  !            {}    then {Set pool eqt down, but do not release it}  !             {}       Downflag :=true;               {}    LINKDOWN (EQTPTR,clear);  { reason = clear }              {}    EMAcounter := 0;              {}    Nextbuffertoread:=nil;              end                   else begin  { EQT WITH ASSOCIATED VC }              {}              {} With AssociatedVC^ do begin              {}  #            {}   {X25P is not P1 (because there is an associated vc)}  #             {}   Case  X25P  of               {}      {}              {}     P5: { Send Call }  #            {}      {} { circuit not yet established; cancel process } #             {}      {} begin  #            {}      {}   CallRetryCtr :=0; {stop further call retries} #             {}      {}   P1SETUP ( AssociatedVC );              {}      {} end;               {}      {}              {}     P2, { Send Call Conf }               {}     P3, { Wait Call Conf }               {}     P4: { Data Transfer ready }              {}      {} begin              {}      {}              {}      {}   If X25P = P4               {}      {}   then begin               {}      {}    {}   If  EqtType <> padeqttype              {}      {}    {}   then   $            {}      {}    {}     {cancel possible request on read eqt:}  $ "            {}      {}    {}     WriteReadEqt[2].ReqState := Noreq;  "             {}      {}   end;               {}      {}              {}      {}    X25P  := p8 ; { SEND CLEAR }              {}      {}    Cause := 0 ;              {}      {}    Diag  := 0 ; { ?? }               {}      {}    PKTwriteNeeded := true;               {}      {}  "            {}      {}    { Could be waiting for reset conf (D3), }  " "            {}      {}    { cancel timer & decrease timer counters } " "            {}      {}    if VCTO <> -1  then     { M37 BG 26AUG87 } "             {}      {}      begin               {}      {}        VCTO := -1;               {}      {}        RetryCtr := 0;  #            {}      {}        NETWP^.X25TOctr := NETWP^.X25TOctr - 1 ; #             {}      {}        GlobalTOctr := GlobalTOctr - 1 ;              {}      {}      end;              {}      {}  #            {}      {}    {Cut links, send Link and EQT down only on } #             {}      {}    {return in state P1}              {}      {}              {}      {} end;               {}     Otherwise {do not change}              {}      {}              {}    end {case X25P}               {}end {with associatedvc}               end          end          end {with EQTPTR}     end {F32_clearcirc} ;    $page$     {***************************************************}     BEGIN            { P_NEWREQUEST body }    {***************************************************}          SendDvx := false ;  { will be changed if needed }      
   If EQTPTR <> NIL  
     then                 {the request comes directly from PDSUP}    $     PDSUPreq := true   {EQTPTR,NETWP,CURRENTNET,WriteReadEqtIndex set}  $        else  begin          {the request does not come from PDSUP}           PDSUPreq := false ;      !      {*********************************************************}  ! !      {  EQTSEARCH:                                             }  ! !      {*********************************************************}  !     $      {Uses the EQTaddress to search for the corresponding EQT record }  $ $      {and sets CurrentNet,NETWP,EQTPTR and writeReadEqtIndex         }  $ $      {(If not found, sets EQTPTR=NIL)                                }  $           {Loop over all networks: (always at least one network) }        For INET := 1 to NbOfNetworks do begin        {}  CurrentNet := INET;         {}  NETWP := NetwPtrTbl [ INET ]  ;         {}  { Loop over all EQTs of this network: }         {}  { (always at least one EQT) }         {}    EQTPTR := NETWP^.FirstEQT ;         {}    Repeat {until EQTPTR = NIL}         {}    {}        {}    {} With EQTPTR^ do begin        {}    {}      If (XNETIBUF.W[2] = WriteEQTadd)        {}    {}      then begin        {}    {}          WriteReadEqtIndex := 1; {write eqt}         {}    {}          goto  99        {}    {}      end;        {}    {}      If (XNETIBUF.W[2] = ReadEQTadd)         {}    {}      then begin        {}    {}          WriteReadEqtIndex := 2;{read Eqt}         {}    {}          goto 99         {}    {}      end;        {}    {}      EQTPTR := NextEQT   
      {}    {} end {with}; 
       {}    {}        {}    Until EQTPTR = NIL        {}        end {for};        {EQTPTR is NIL here (if no jump  to 99) }        99:         {------ end of  EQTSEARCH  -----------------------------}       end {if EQTPTR <> nil} ;    $page$   	   If EQTPTR = NIL 	 !   then begin      { UNKNOEN EQT: bug, SET HARD ERROR IN STATUS }  !         if SystemType = RTE_A          {M34 BG 15JUN87}             then S := HardErrorStatusA            else S := HardErrorStatus ;           T :=0 ;   
        SendDvx := true ;  
 
        Currentnet := -1 ; 
    end     else begin  {normal case}  
     With NETWP^ do begin  
 
        If State <> ready  
 	        then begin 	          {}   If State = CardError  { SET HARD ERROR IN STATUS }            {}   then begin           {}     if SystemType = RTE_A          {M34 BG 15JUN87}          {}       then S := HardErrorStatusA           {}       else S := HardErrorStatus ;          {}     T := 0 ;           {}     SendDvx := true ;  	        {}   end;  	         {}          {}   { If handshakeread, just ignore; }           {}   { linkdowns will be sent soon!  }          {}          {}   CurrentNet := -1           end    $page$           else begin   { network state is ready }           {}  With EQTPTR^ do begin   #        {}    {-----------------------------------------------------}  # #        {}    {  Process New Request:                               }  # #        {}    {-----------------------------------------------------}  # #        {}     CONVREQ.W := XNETIBUF.W[3]; {decode req code and subf}  #         {}     RequestType:= ConvReq.W1.ReqCode;          {}     RequestSubf:= ConvReq.W1.ReqSubf ;           {}          {}     If (RequestType = 3 {control}) and           {}        (EqtType = PADeqtType) and          {}        (Not PDSUPreq)  
        {}     then begin  
 #        {}        { transmit to PDSUP only CN not coming from PDSUP }  #         {}        Task:=0; {New request}  {EQTPTR already set}          {}        PDSUP ( Task, XNETIBUF, XNETtlog, Immrq);            {}        CONVREQ.W := XNETIBUF.W[3]; {decode PDSUP req}           {}        RequestType:=ConvReq.W1.ReqCode;          {}        RequestSubf :=ConvReq.W1.ReqSubf;   
        {}     end;  
         {}     Case RequestType of    	        {}     {}  	         {}     {}   0: {NO_OP} begin            {}     {}              {} S:=0; T:=0; SendDvx:= true;           {}     {}              {} CurrentNet:= -1           {}     {}              end;           {}     {}   1:  READ_REQ ;            {}     {}   2:  WRITE_REQ ;           {}     {}   3:  {control}           {}     {}       begin           {}     {}       Case REQUESTSUBF of           {}     {}          0: F0_CLEARDEVICE;           {}     {}          6: F6_EQTTYPE;           {}     {}         14: F16_INTERRUPT;          {}     {}         22: F26_FLUSH ;           {}     {}         25: F31_ESTCIRC;          {}     {}         26: F32_CLEARCIRC;          {}     {}         Otherwise {Unknown control}   !        {}     {}           if SystemType = RTE_A {M34 BG 15JUN87} !         {}     {}             then S := HardErrorStatusA          {}     {}             else S := HardErrorStatus ;           {}     {}           T := 0;           {}     {}           SendDVX := true;          {}     {}           CurrentNet := -1 ;          {}     {}       end {case requestSubf}          {}     {}       end {control request}           {}     end {case RequestType}   $        {}    {-------------------------------------------------------}  $ $        {}    {-------------------------------------------------------}  $         {}  end {with EQTPTR}           end        end {with Netwp}      end;          If SendDvx       then XSEND( NormalCompMsg, EQTPTR, WriteReadEQTindex, S, T);        
  end  {  P_NEWREQUEST } ; 
  $subtitle ' ' , page$  $ {********************************************************************}  $ $ {                                                                    }  $ $ {!}   PROCEDURE    P_SPECIALREQUEST ;     $direct$                 {!}  $ $ {                                                                    }  $ $ {  Contains the following procedures and functions :                 }  $ $ {   - P_SPECIALREQUEST : SPECREQ_REPLY                               }  $ $ {                        P_SPECREQ0  ( enable network )              }  $ $ {                        P_SPECREQ1  ( allocate pool/modify SVC )    }  $ $ {                        P_SPECREQ23 ( get pool info/release pool )  }  $ $ {                        P_SPECREQ4  ( enable tracing )              }  $ $ {                        P_SPECREQ5  ( disable tracing )             }  $ $ {                        P_SPECREQ6  ( get incoming call info )      }  $ $ {                        P_SPECREQ7  ( deallocate a pool LU )        }  $ $ {                        P_SPECREQ8  ( get network state )           }  $ $ {                        P_SPECREQ9  ( shutdown )                    }  $ $ {                                                                    }  $ $ {********************************************************************}  $       VAR  ERROR, ILEN : word; FOUND : boolean; IBUF : A25W;        {***********************}     PROCEDURE SPECREQ_REPLY ;     $direct$    {***********************}   "                              { updated no abort error processing }  "   CONST                       { M28 BG 12FEB87 }          EXEC20NoAbort = 20 - 32768 ; {no abort bit set}         BEGIN   {Reply mechanism: class I/O; unlock Resource number}          noabort_error := false ;          {Issue a class I/O write/Read on LU 0, no wait:}      #    IOWRITE(EXEC20NoAbort ,0,IBUF,ILEN,0,0,XNETibuf.w[2]+NoWaitBit );  #       begin { no abort error processing }          {}    { error such as wrong or deallocated class number }          {} noabort_error := true ;        end ;  { end of no abort error processing }       $    ABREG ( regab.w.A, regab.w.B ) ; { reg A tested later for "no SAM"}  $         { to stop effective processing of request }       if  noabort_error  then  regab.w.A := -3 ;          { Unlock RN to indicate that request has been processed: }      { nowait bit 15 = 1 ;  unlock bit 2 = 1 }       RNRQ ( -32764 {100004B}, XNETibuf.W[1], dummy1 ) ;        END ; {SPECREQ_REPLY}    $page$   $  {*******************************************************************}  $ $  {                                                                   }  $ $  {  procedure  P_SPECREQ0      ENABLE NETWORK                        }  $ $  {                                                                   }  $ $  {                                                                   }  $ $  { Implement the Restart Network ( RN ) command of XMOD.             }  $ $  {                                                                   }  $ $  { Entry parameter  :                                                }  $ $  {  XNETIBUF.W[3] : Network LU of network to restart.                }  $ $  {                                                                   }  $ $  { Return Parameter : 2 words                                        }  $ $  {  IBUF[1] = error code                                             }  $ $  {  0 : given network found and Network state is CardError           }  $ $  {  2 : given network found and Network state is NOT CardError       }  $ $  { -2 : given network is NOT found .                                 }  $ $  {                                                                   }  $ $  {  IBUF[2] = 0 : special request code  ( tag field )                }  $ $  {                                                                   }  $ $  { The request is accepted only if Network State is CardError.       }  $ $  {                                                                   }  $ $  {*******************************************************************}  $       PROCEDURE  P_SPECREQ0 ; { ENABLE NETWORK  }    $direct$         VAR I : byte;         BEGIN       #    {Find network table corresponding to indicated LU and set NETWP^:} #         I:=1; Found:=false;  {Indicated LU may not exist}       repeat        NETWP := NetwPtrTbl[I];         If Netwp^.CardWriteLU = XNETIBUF.W[3] +SessionBit   
        then Found := true 
         else I := I+1         until  ( Found or ( I > NBofNetworks )) ;           If FOUND         { known Network ? }        then  { verif network state }           If NETWP^.STATE = CardError   
          then Error := 0  
           else Error := 2 { Network state not "card error" }        else  Error := -2 ; { Unknown Network }           IBUF[1] := Error ;      IBUF[2] := 0 ; { special request code }       ILEN := 2 ; { length of buffer returned }       	    SPECREQ_REPLY; 	         If (( Error = 0 ) and ( regab.w.A >= 0 ))         then begin { effectively process the request }  
        CurrentNet := I ;  
         Netwp^.state:= ready; { must remove error state }                                 { before INGNRES }          INGNRES ( XINITschedule );        end ;         end { P_SPECREQ0 } ;   $page$   $  {*******************************************************************}  $ $  {                                                                   }  $ $  {  PROCEDURE     P_SPECIALREQ1                                      }  $ $  {                                                                   }  $ $  {  Executes the ALLOCATE POOL and MODIFY SVC special request 1      }  $ $  {                                                                   }  $ $  {                                                                   }  $ $  {  XNETibuf.W3  = Network Write LU number                           }  $ $  {  XNETibuf.W4  = 1 : special request code   ( tag field )          }  $ $  {  XNETibuf.W5  = Offset in XTBL in SAM of SVCentry, if Modify req. }  $ $  {                 place holder, if Allocate Pool request.           }  $ $  {  XNETibuf.W6  = Write LU number, if Modify SVC; 0 if allocate Pool}  $ $  {  XNETibuf.W7  = Write EQT address                                 }  $ $  {  XNETibuf.W8  = Read  EQT address                                 }  $ $  {  XNETibuf.W9  = Facilities                                        }  $ $  {  XNETibuf.W10 = \  PTW                                            }  $ $  {  XNETibuf.W11 = /  ( Packet size, Throughput class, Window size ) }  $ $  {  XNETibuf.W12 - W15 = Remote Network Address                      }  $ $  {  XNETibuf.W16 = CUG number                                        }  $ $  {  XNETibuf.W17 = Call User Data field length                       }  $ $  {  XNETibuf.W18 - W25 = Call User Data field                        }  $ $  {                                                                   }  $ $  {  W6 to W25 have the format described for an XTBL SVC entry.       }  $ $  {                                                                   }  $ $  {  Returned parameters :  3 words                                   }  $ $  {    IBUF[1] := error code  0 if no error                           }  $ $  {                           1 if no pool lu available ( allocate )  }  $ $  {                           3 if SVC modified with duplicate address}  $ $  {                           4 if lu currently opened ( modify )     }  $ $  {    IBUF[2] := 1  special request code  ( tag field )              }  $ $  {    IBUF[3] := XNETIBUF.W[6] SVC write LU nbr or allocated Pool LU }  $ $  {                                                                   }  $ $  {  Referenced procedures and functions :  XTMGR                     }  $ $  {                                                                   }  $ $  {*******************************************************************}  $       PROCEDURE  P_SPECREQ1 ;   $direct$        VAR           Equal: boolean;  I: byte; L : word;   
    EP : EqtPtrType; 
       BEGIN       "  {Find network table corresponding to indicated LU and set NETWP:}  "          I:=0;        Repeat  {Note: XMOD already checked existence of this LU#}           I:=I+1;         Netwp := NetwptrTbl [I];        Until Netwp^.CardWriteLU = (XNETibuf.w[3] + SessionBit) ;        {transfer of EQT info from XNETIBUF into variable XTBL:}           For I:=1 to XTBLsvcEntryLength            do XTBL.Words[I] := XNETIBUF.W[I+5] ;        Error:=0;          {Differentiate between Allocate pool and Modify svc requests:}     If  XTBL.SVCentry.WriteLUnumber = 0     then begin   {------------------------------------}                  {   ALLOCATE  POOL                   }                  {------------------------------------}      {search free pool eqt (i.e. with no associatedVC, with add=0 }     {and not down}         Found := false;  EQTPTR:= NETWP^.FirstPoolEQT;          While (EQTPTR<>Nil) and (Not found) do begin          {} with EQTPTR^, EQText do begin          {}    If EQTtype = PoolEqtType   	       {}    then  	        {}    {} If (AssociatedVC=Nil) and          {}    {}    (Remote.W[1]=DummyNetwAdd.W[1]) and         {}    {}    (downflag=false)          {}    {} then Found := true         {}    {} else EQTPTR := NextEQT         {}    else EQTPTR := nil; {end of Pool eqt group}  
       {} end {with} 
 
       end {while};  
     If Found  !    then XNETIBUF.W[6] := EQTPTR^.WriteLUnb  { allocated Pool LU } !     else Error := 1 {no pool lu available};         end          {--- END  ALLOCATE  POOL ------------}         else begin   {-------------------------------------}                 {    MODIFY SVC WITH ADDRESS          }                 {-------------------------------------}           {Find EQT table record corresponding to indicated EQT:}  "       EQTPTR := NETWP^.FirstSVCeqt;  {Note: XMOD checked existence} " !       While ( EQTPTR^.WriteLUnb <> XTBL.SVCentry.WriteLUnumber )  !           do  EQTPTR := EQTPTR^.NextEQT ;            {Check that no F31 (establish Circuit) has been sent:}   #       If EQTPTR^.EstCircReceived then Error:=4; {LU currently opened} #          { Verify that no other SVC with address }       { has the same remote address:          }         EP:= Netwp^.FirstSVCeqt; {loop over SVC with address}         While (EP <> nil) and (error=0) do begin   
         With EP^ do begin 
 !           If EQTtype <> svcEQTtype {end of svc with add group ?}  ! 
           then EP := nil  
            else begin              {} If EP = EQTPTR             {} then EP:= NextEQT {skip over modified EQT}             {} else begin             {}   {compare addresses:}             {}      Equal:=true; I:=1;              {}      While (Equal) and (I<=4) do  !           {}      {}  If Remote.W[I] = XTBL.SVCentry.SVCaddr.W[I] !            {}      {}  then I:=I+1             {}      {}  else Equal := false;              {}   If Equal then Error := 3 {duplicate add}             {}            else EP := NextEQT;  	           {} end  	            end           end {with EP}  	       end {while} 	   end;         {--- END MODIFY SVC  -----------------}      
  {prepare results:} 
     IBUF[1] := error ;      IBUF[2] := 1 ; { special request code }   $    IBUF[3] := XNETIBUF.W[6] ; { SVC write LU number / allocated Pool }  $     ILEN := 3 ; { length of buffer returned }       
    SPECREQ_REPLY ;  
         If (( error = 0 ) and ( regab.w.A >= 0 ))       then begin {effectively process the request}        {Update XNET internal tables (EQT record):}            With EQTPTR^, XTBL.SVCentry , EQText do begin                Facilities := SVCfacilities;                DesiredPTW := PTW;                Remote     := SVCaddr;                CUGnb      := SVCCUGnb ;                CUDout     := SVCCUD;  {PM 21/4/82}            end {with EQTPTR};             {Update XTBL in SAM, if modify SVC request}            If XTBL.SVCentry.WriteLUnumber <> 0  
         then begin  
             L:= XTBLsvcEntryLength;   !            XTMGR ( 2{write}, XNETIBUF.W[5]{offset given by XMOD}, !                     L{length}, XTBL.words, WriteReservedLU );            end {if XTBL};       end;  
  end { P_SPECREQ1}; 
      $page$   $  {*******************************************************************}  $ $  {                                                                   }  $ $  {  PROCEDURE     P_SPECIALREQ23                                     }  $ $  {                                                                   }  $ $  {  Executes the GET POOL INFO special request 2                     }  $ $  {       and the RELEASE POOL & GET POOL INFO special request 3.     }  $ $  {                                                                   }  $ $  {  If W6 is 0, XNET retreives its first internal Pool Lu.           }  $ $  {  If W6 contains a Pool Lu number, XNET retreives the next Pool Lu.}  $ $  {  Starting from the selected Pool Lu table, XNET then returns the  }  $ $  {  the information available about this Pool Lu if it is allocated  }  $ $  {  otherwise, about the first allocated Pool Lu after this one.     }  $ $  {                                                                   }  $ $  {  XNETibuf.W3  = Network Write LU number                           }  $ $  {  XNETibuf.W4  = 2 or 3  special request code   ( tag field )      }  $ $  {  XNETibuf.W5  = place holder, undefined XTBL offset               }  $ $  {  XNETibuf.W6  = Write LU number  or  0                            }  $ $  {                                                                   }  $ $  {  Returned parameters :  22 words                                  }  $ $  {    IBUF[1] := error code                                          }  $ $  {    IBUF[2] := 2 or 3  special request code  ( tag field )         }  $ $  {    IBUF[3] to IBUF[22] = SVCentry table   20 words                }  $ $  {                                                                   }  $ $  {  Error = 0  if no error                                           }  $ $  {  Error = 4  if indicated Pool Lu nbr is in use ( VC associated )  }  $ $  {                                                                   }  $ $  {*******************************************************************}  $       PROCEDURE P_SPECREQ23 ;  $direct$         VAR  I : byte; EP : EQTptrType;         BEGIN       "   {Find Network table corresponding to indicated LU and set NETWP:} "           I:=0;   #      Repeat        {Note: XMOD already checked existence of this LU#} # 	         I := I+1; 	          Netwp := NetwPtrTbl [I];         Until Netwp^.cardWriteLU = (XNETibuf.W[3] + Sessionbit);         With NETWP^ do begin        Error := 0;           EP := FirstPoolEQT;           If XNETIBUF.W[6] > 0  { writelunumber has been provided }       then begin            { W[6] indicates a Pool LU #      }       {}   #     {} {Search Pool EQT with this LU# (existence verified by XMOD):}  #      {}    While EP^.WriteLUnb <> XNETIBUF.W[6]        {}       do EP := EP^.NextEqt;        {}        {} {Verify if not NOW in use:}        {}    If EP^.AssociatedVC = nil  #     {}    then  EQTPTR:= EP {Memorize to be able to release later on} #      {}    else  Error:= 4; {Lu now in use}        {}        {} {Set EP to next Pool LU (if any):}       {}    EP := EP^.NextEQT;        {}    If EP <> nil        {}    then If EP^.EQTtype <> PoolEqtType then EP:= nil;       end;            { Find first "allocated" Pool LU, starting with EP }        { if Pool lu was not indicated, start with FirstPoolEqt }  
     Found := false; 
      While (EP<>Nil) and (Not Found) do begin   
     {} With EP^ do begin  
      {}    If EQTtype = PoolEQTtype        {}    then   !     {}    {} If Remote.W[1] <> DummyNetwAdd.W[1]  {"allocated"?}  !      {}    {} then Found := true       {}    {} else EP := NextEQT       {}    else EP := nil; {end of Pool EQT group}       {} end {with EP}   	     end {while};  	  $page$   	     If Not found  	      then  IBUF[3] := 0    { Pool WriteLunumber = 0 }        else begin        {} With XTBL.SVCentry, EP^, EQText do begin       {}      WriteLUnumber   := WriteLUnb ;        {}      WriteEQTaddress := WriteEQTadd;       {}      ReadEQTaddress  := ReadEQTadd ;       {}      SVCFacilities   := Facilities ;       {}      PTW             := DesiredPTW ;       {}      SVCaddr         := Remote     ;       {}      SVCCUGnb        := CUGnb      ;       {}      If AssociatedVC <> nil        {}      then reserved := 1 {LU in use}   	     {}      else  	      {}         If Downflag        {}         then reserved := 2 {LU down}       {}         else reserved := 0 {LU closed}       {}        {} end {with XTBL};       {}   !     {} For I:=1 to XTBLsvcEntryLength    { move table to buffer } !      {}  do  IBUF [I+2] := XTBL.Words [I];       end;            IBUF [1] := Error ;  #     IBUF [2] := XNETIBUF.W [ 4 ] ; { special request code : 2 or 3 }  #      ILEN := XTBLsvcEntryLength + 2 ;   
     SPECREQ_REPLY ; 
          { Update internal table only            }       { if reply successful and "releasePool":}         If (( regab.w.A >= 0 ) and              ( XNETIBUF.W[4] = 3 ) and ( Error = 0 ))          then begin {release pool LU: EQTPTR}          {}   {Note: no verif! no VC should be associated!}          {}   With EQTPTR^, EQText do begin          {}           Remote := DummyNetwAdd;          {}           CUGnb :=  PoolDefaultCUG;          {}           Facilities := PoolDefaultFacilities;         {}           DesiredPTW:= PoolDefaultPTW;         {}           Downflag := false;         {}   end {with EQTPTR}          end;   
   end {with Netwp}  
 
  end {P_SPECREQ23}; 
      $page$   $  {*******************************************************************}  $ $  {                                                                   }  $ $  {  PROCEDURE     P_SPECIALREQ4                                      }  $ $  {                                                                   }  $ $  {  Executes the ENABLE TRACING MODE  special request 4  for XPLOG   }  $ $  {                                                                   }  $ $  {  XNETibuf.W2  = XPLOG class number for communication -  LogClass  }  $ $  {  XNETibuf.W4  = 4  special request code   ( tag field )           }  $ $  {                                                                   }  $ $  {  Returned parameters :  2 words                                   }  $ $  {    IBUF[1] := error code  always 0 ( no error )                   }  $ $  {    IBUF[2] := 4  special request code  ( tag field )              }  $ $  {                                                                   }  $ $  {*******************************************************************}  $       PROCEDURE P_SPECREQ4 ;    $direct$        begin            IBUF [1] := 0; { no error }        IBUF [2] := XNETIBUF.W [ 4 ] ; { special request code : 4 }        ILEN := 2 ;      
     SPECREQ_REPLY;  
          If regab.w.A >= 0       then begin           LogClass := XNETIBUF.W [ 2 ];           XMSGWR ( 1 {LU} , TracingOn ,0 );        end;       
   end {P_SPECREQ4}; 
     $page$  $  {*******************************************************************}  $ $  {                                                                   }  $ $  {  PROCEDURE     P_SPECIALREQ5                                      }  $ $  {                                                                   }  $ $  {  Executes the DISABLE TRACING MODE  special request 5  for XPLOG  }  $ $  {                                                                   }  $ $  {  XNETibuf.W4  = 5  special request code   ( tag field )           }  $ $  {                                                                   }  $ $  {  Returned parameters :  1 word                                    }  $ $  {    IBUF[1] := error code  always 0 ( no error )                   }  $ $  {    IBUF[2] := 5  special request code  ( tag field )              }  $ $  {                                                                   }  $ $  {*******************************************************************}  $        PROCEDURE P_SPECREQ5 ;    $ direct $          begin           IBUF [1] := 0; {no error}        IBUF [2] := XNETIBUF.W [ 4 ] ; { special request code : 5 }        ILEN := 1 ;            {For this request, we always act even if no SAM for reply}    
     LOGCLASS := 0;  
      XMSGWR ( 1 {LU}, TracingOff ,0);       
     SPECREQ_REPLY;  
          { If regab.w.A >= 0  then  nothing other to do }       
   end {P_SPECREQ5}; 
      $page$   $  {*******************************************************************}  $ $  {                                                                   }  $ $  {  PROCEDURE     P_SPECIALREQ6                                      }  $ $  {                                                                   }  $ $  {  Executes the GET INCOMING CALL INFO special request 6.           }  $ $  {  Existence of this SVC write LU in this network is assumed to     }  $ $  {  have been tested by the caller.                                  }  $ $  {                                                                   }  $ $  {  XNETibuf.W3  = Network Write LU number                           }  $ $  {  XNETibuf.W4  = 6  special request code   ( tag field )           }  $ $  {  XNETibuf.W5  = SVC write LU                                      }  $ $  {  XNETibuf.W6  = type of VC                                        }  $ $  {                                                                   }  $ $  {  Returned parameters :  15 words                                  }  $ $  {    IBUF[1] := error code                                          }  $ $  {    IBUF[2] := 6  special request code  ( tag field )              }  $ $  {    IBUF[3] to IBUF[6] = SVC calling address                       }  $ $  {    IBUF[7] := Call User Data length                               }  $ $  {    IBUF[8] to IBUF[15] = Call User Data array                     }  $ $  {                                                                   }  $ $  {  Error =  0   if no error                                         }  $ $  {  Error = -2   if unknown network LU                               }  $ $  {  Error = -4   if unexpected type of VC                            }  $ $  {               or unknown SVC write LU.                            }  $ $  {  Error = -12  if VC not established                               }  $ $  {                                                                   }  $ $  {*******************************************************************}  $       PROCEDURE  P_SPECREQ6 ;  $direct$         TYPE      "    VCtype = (Notfound, PVCtype, SVCtype, POOLSVCtype,PADSVCtype );  " 	    parm = record  	              case boolean of                 True : (Typeofvc : VCtype);                 False: (W6       : word  );  	             end;  	       VAR       I: byte; L: word; Parm6: parm;      found : boolean ;         BEGIN         Error := 0;     I := 1 ;    Found := false;  { Indicated Network LU may not exist }         repeat      NETWP := NetwPtrTbl[I];       If Netwp^.CardWriteLU = XNETIBUF.W[3] + SessionBit        then Found := true  
      else I := I+1  
   until  ( Found  or  ( I > NBofNetworks )) ;        $page$     If not found    then  error := -2  { unknown network }    else begin      { Set EQTPTR according with type of VC }        Parm6.W6 := XNETIBUF.W[6]; { type of VC }         EQTPTR := NETWp^.firsteqt;        CASE Parm6.TypeofVC of          SVCtype     : EQTPTR := NETWp^.firstSVCeqt;           POOLSVCtype : EQTPTR := NETWp^.firstPOOLeqt;          PADSVCtype  : EQTPTR := NETWp^.firstPADeqt;   $        otherwise   error := -4 { invalid type of VC } {M52 BG 17JUN88}  $       end;{CASE}  
   end ; { if not found }  
        If error = 0      then begin   !     {Find EQT table record corresponding to indicated write LU }  !        found := false ;          while ( not found and ( EQTPTR <> NIL )) do begin           with  EQTPTR^  do begin             If  WriteLUnb = XNETIBUF.W[5] { SVC write LU }                then  found := true               else  EQTPTR := NextEQT ;           end; { with }         end; { while }       
       If not found  
 $       then error := -4 { invalid SVC write LU number } {M52 BG 17JUN88} $          { Check that Circuit is established : }         else            If NOT EQTPTR^.EstCircReceived and   $            NOT ( EQTPTR^.associatedVC^.X25P = P4 { data xfer ready } )  $             then Error := -12 ; { VC not established }                                   { No significant incoming CUD }             end ; { if error }       
     { prepare results: }  
 "     If error <> 0                                  {M52 BG 17JUN88} "      then          begin           FOR I := 3 to 15 do IBUF[I] := 0 ;          end       else   { no error }         begin           WITH EQTPTR^, EQText do begin             {remote adddress}               FOR I := 3 to 6 do IBUF[I] := remote.W[I-2];              {incoming call user data}               L := CUDin.length;   
             IBUF[7] := L; 
              L := ( L + 1 ) DIV 2; {length in words}               FOR I := 8 TO (8+L-1) do IBUF[I] := CUDIN.W[I-7];           end; { with }         end; { If error }           IBUF[1]:= error;        IBUF[2]:= 6 ; { special request code }         ILEN := 15;  {15=1(error)+1(req code)+4(address)+9(CUDin)}        
     SPECREQ_REPLY ; 
          { If (( error = 0 ) and ( regab.w.A >= 0 )) }       {   then nothing other to do }       
  end { P_SPECREQ6}; 
   $PAGE$  $  {*******************************************************************}  $ $  {                                                                   }  $ $  {  PROCEDURE     P_SPECIALREQ7                                      }  $ $  {                                                                   }  $ $  {  Executes the DEALLOCATE POOL special request 7                   }  $ $  {                                                                   }  $ $  {  XNETibuf.W3  = Network Write LU number                           }  $ $  {  XNETibuf.W4  = 7  special request code   ( tag field )           }  $ $  {  XNETibuf.W5  = SVC write LU                                      }  $ $  {                                                                   }  $ $  {  Returned parameters :  2 words                                   }  $ $  {    IBUF[1] := error code                                          }  $ $  {    IBUF[2] := 7  special request code  ( tag field )              }  $ $  {                                                                   }  $ $  {  Error = 0  if no error                                           }  $ $  {  Error = 4  if this pool LU is active                             }  $ $  {                                                                   }  $ $  {*******************************************************************}  $       PROCEDURE  P_SPECREQ7 ;   $direct$        VAR I: byte;        BEGIN       "  {Find network table corresponding to indicated LU and set NETWP:}  "      I := 0 ;         Repeat  {Note: XMOD already checked existence of this LU#}    	       I := I+1 ;  	        Netwp := NetwptrTbl [I];        Until Netwp^.CardWriteLU = (XNETibuf.w[3] + SessionBit) ;        Error := 0 ;      "  {Set EQTPTR to first pool eqt, xmod checked that it is a Pool LU}  "      EQTPTR := NETWp^.firstpooleqt;         {Find EQT table record corresponding to indicated LU }    {Note: XMOD checked existence}       While ( EQTPTR^.WriteLUnb <> XNETIBUF.W[5] )           do  EQTPTR := EQTPTR^.NextEQT ;         {Check that this eqt is not active}        If EQTPTR^.AssociatedVC <> nil        then           error := 4 ;  { this pool LU is active }      
  {prepare results:} 
      IBUF[1] := error ;        IBUF[2] := 7 ; { special request reply }        ILEN := 2;       
     SPECREQ_REPLY ; 
          If (( error = 0 ) and ( regab.w.A >= 0 ))       then {Deallocate pool LU}          With Netwp^, EQTptr^, EQText do           Begin              Downflag   := false;              Remote     := Dummynetwadd;             Facilities := Pooldefaultfacilities;              DesiredPTW := PooldefaultPTW       ;              CUGnb      := PooldefaultCUG       ;   	        end {with} 	     
  end { P_SPECREQ7}; 
     $PAGE$  ${*********************************************************************}  $ ${                                                                     }  $ ${              SPECIAL REQUEST 8   GET NETWORK STATE       "GS"       }  $ ${                                                                     }  $ ${  Entry parameter                                                    }  $ ${   XNETibuf.W3  = Network Write LU number                            }  $ ${   XNETibuf.W4  = 8  special request code   ( tag field )            }  $ ${                                                                     }  $ ${  Parameters returned :  8 words                                     }  $ ${   IBUF[1] : error code    :  0 = given network found                }  $ ${                             -2 = given network is NOT found         }  $ ${   IBUF[2] : special request code = 8  ( tag field )                 }  $ ${   IBUF[3] : Network State :  0 = state_Ready                        }  $ ${                              1 = state_CardError                    }  $ ${                              2 = state_HandShakeWithCard            }  $ ${                             -1 = state_Unknown                      }  $ ${   IBUF[4] : Total number of establised Virtual Circuits for this Net}  $ ${   IBUF[5] : Total number of establised PVCs for this Network        }  $ ${   IBUF[6] : Total number of establised SVCs with addr. for this Net }  $ ${   IBUF[7] : Total number of establised PoolSVCs for this Network    }  $ ${   IBUF[8] : Total number of establised PADSVCs for this Network     }  $ ${                                                                     }  $ ${ If Network is not found,     error = -2 & IBUF[3] = state_Unknown   }  $ ${ If Network state is unknwon, error =  0 & IBUF[3] = state_Unknown   }  $ ${                                                                     }  $ ${*********************************************************************}  $      PROCEDURE P_SPECREQ8 ;  $ direct $      { ADDED M19 BG 16OCT86 }       CONST         Unknown_network_error = -2 ;      VAR         I : word ;      BEGIN         IBUF[4] := 0 ; { total number of established VCs }    IBUF[5] := 0 ; { total number of established PVCs }     IBUF[6] := 0 ; { total number of established SVCs w. addr.}     IBUF[7] := 0 ; { total number of established PoolSVCs }     IBUF[8] := 0 ; { total number of established PADSVCs }      "  {Find network table corresponding to indicated LU and set NETWP^:} "       Error := 0 ;    I := 1 ;    Found:=false;  {Indicated LU may not exist}         repeat      NETWP := NetwPtrTbl[I];       If Netwp^.CardWriteLU = XNETIBUF.W[3] + SessionBit        then Found := true  
      else I := I+1  
   until  ( Found  or  ( I > NBofNetworks )) ;         If Found         { known Network ? }    then     { yes, return the network state }  
  {} case  NETWP^.STATE of 
   {}  Ready :     {}   begin    {}   {}     {}   {} IBUF[3] := state_ready ;    {}   {}     {}   {} { get count of established VCs }    {}   {} with Netwp^ do    {}   {} begin     {}   {}     {}   {}   EQTptr := firstEQT ;    {}   {}     {}   {}   repeat  { loop over all EQTs of the network }     {}   {}   {}    {}   {}   {} with EQTptr^ do  
  {}   {}   {} begin 
   {}   {}   {}   if  EstCircReceived then     {}   {}   {}   begin    {}   {}   {}     { total nb of established VCs }    {}   {}   {}     IBUF[4] := IBUF[4] + 1 ;     {}   {}   {}     case EQTtype of    {}   {}   {}       PVCEqtType  : IBUF[5] := IBUF[5] + 1 ;     {}   {}   {}       SVCEqtType  : IBUF[6] := IBUF[6] + 1 ;     {}   {}   {}       PoolEqtType : IBUF[7] := IBUF[7] + 1 ;     {}   {}   {}       PADEqtType  : IBUF[8] := IBUF[8] + 1 ;     {}   {}   {}       otherwise   ; { should not occur }     {}   {}   {}     end ; { case EQTtype }     {}   {}   {}   end ; { if estcircreceived }     {}   {}   {}    {}   {}   {}   EQTptr := NextEqt ;    {}   {}   {}    {}   {}   {} end ; { with eqtptr^ }     {}   {}   {}    {}   {}   until EQTptr = NIL ;    {}   {}     {}   {} end ; { with Netwp }    {}   end ; { case network state is ready }    {}    {}  CardError         : IBUF[3] := state_Carderror ;    {}  HandshakeWithCard : IBUF[3] := state_HandShakeWithCard ;    {}    {}  otherwise   { unknown state }     {}    begin     {}      IBUF[3] := state_unknown ;    {}    end ;     {}  
  {} end   { case }  
   {}    else    { network not found }     {}    {}  begin     {}    error := Unknown_network_error ;    {}    IBUF[3] := state_unknown ;    {}  end ;     {}  	  { end if found } 	     	  IBUF[1]:= Error; 	   IBUF[2]:= 8 { special request code } ;    ILEN := 8 ; { length of buffer returned }         SPECREQ_REPLY;      
END ; { P_SPECREQ8 } 
     $page$  ${*********************************************************************}  $ ${                                                                     }  $ ${             SPECIAL REQUEST 9            SHUTDOWN                   }  $ ${                                                                     }  $ ${ Entry parameter :                                                   }  $ ${   XNETIBUF.W[4] = 9  special request code   ( tag field )           }  $ ${   XNETIBUF.W[5] = synchronization resource number #1                }  $ ${   XNETIBUF.W[6] = synchronization resource number #2                }  $ ${                                                                     }  $ ${ Buffer returned :   2 words                                         }  $ ${   IBUF[1] = error code     0 if no error                            }  $ ${                            1 if locking of reply_synch_RN2 failed   }  $ ${   IBUF[2] = 9 : special request code  ( tag field )                 }  $ ${                                                                     }  $ ${ Referenced Procedures and functions : RNRQ, CLRQ, specrequest_reply }  $ ${                                       GEN_CLEAN_UP_LINKDOWN, STOP,  }  $ ${                                       XEXEC2, XTMGR.                }  $ ${                                                                     }  $ ${*********************************************************************}  $     $PROCEDURE P_SPECREQ9 ;  $ direct $             { ADDED M19 BG 16OCT86 }  $     CONST         deallocate_noabort = 2 + noabortB14 ;       VAR         L, N, status : word ;       BEGIN       $  { XNETibuf.w [5] is the resource number #1 for synchronization with }  $ $  { the special request initiator and allows it to retreive the reply }  $ $  { and access the XTBL tables in SAM before XNET releases all        }  $ $  { resources.                                                        }  $ $  { At this point RN#1 has been allocated and locked by the special   }  $ $  { request initiator.                                                }  $     $  { Lock the second resource number in order to get the special req.  }  $ $  { initiator  waiting for XNET to flush all its class I/O requests,  }  $ $  { so the initiator will be able to send request to the link and     }  $ $  { close it. Otherwise pending requests from XNET would prevent      }  $ $  { others to come through.                                           }  $ $  { Lock no wait bit 15 = 1 ;  local lock bit 0 = 1 .                 }  $     !  RNRQ ( -32767 {100001B}, XNETibuf.W[6], status ) ; { lock RN2 }  !       if  status = 2  then  IBUF[1] := 0 { error code }                     else  IBUF[1] := 1 ; { locking RN2 failed }         IBUF[2] := 9 ;  { special request code }    ILEN    := 2 ;  { length of buffer returned }         SPECREQ_REPLY ; { to complete the caller's request }         If  regab.w.A >= 0  then { specreq_reply completed correctly }     begin       $   { Lock the first Resource Number and wait for the special request  }  $ $   { initiator to retrieve the special request reply returned by XNET }  $        RNRQ ( 1 {bit0 RN_local_lock}, XNETIbuf.W[5], status ) ;                                                     { suspend }   
   { end of suspension : } 
 !   { the special request initiator has received the reply now   }  ! !   { and also retrieved the network Lus from XTBL tables in SAM.}  !        RNRQ ( 32 {bit5 RN_deallocate}, XNETIbuf.W[5], status ) ;         { Clean up all VC and EQT tables, Timers and Qlenth    }      { Also send LinkDown to each EQT ( established or not )}          For  N := 1 to NbOfNetworks  Do       begin         NetwP := NetwPtrTbl [ N ] ;         NetwP^.GenResCause := CauseShutDown ;         Gen_Clean_Up_LinkDown ;       end ;             { Release XNET Class number }     { and also flush all XNET I/O Class requests to the cards }         CLRQ ( deallocate_noabort, XNETclassnbA ) ;       begin  { no abort error return processing }         abreg ( regab.w.A , regab.w.B ) ;       end ;         { Now that pending I/O class requests have been flushed  }      { allow the caller to continue and send the "close line".}          RNRQ ( 4 {bit2 RN_unlock}, XNETIbuf.W[6], status ) ;          { Release XTBL table from SAM. }      { Address of XTBL in word @XTBL will be reset to zero }         XTMGR ( 4 {deallocate}, dummy1 {place holder for offset},             L {length}, XTBL.words, WriteReservedLU ) ;         If  L = -2   !    then   { Error, XTBL table could not be deallocated from SAM } !       XEXEC2 ( 2, 1{lu}, ERRMSG6, -ERRMSGLength ) ;              { Output Shutdown message to the system console. }   "   { Procedure XMSGWR is not used as XNET class nb is now released.} "        XEXEC2 ( 2, 1{lu}, SDMSG1, 0 ) ; { skip a line }          XEXEC2 ( 2, 1{lu}, SDMSG1, -SDMSGLength ) ;      "   { to make sure previous message get output onto system console }  " "   { before XNET stops completly and its requests get aborted.    }  "        XEXEC2 ( 2, 1{lu}, SDMSG1, 0 ) ; { skip a line }           
   STOP ( EXEC6 ) ;  
      { Stop XNET overall activity, }        { Resources should be released, Resource & Class numbers }         { Pending requests should be aborted }   !     { ID segment should not be released as XNET has been RP'ed }  !      { On rescheduling, program should be reloaded from file }        end ; { if regab.w.A >= 0 }       
END ; { P_SPECREQ9 } 
 $PAGE$  !{****************************************************************} ! !{                                                                } ! !{                  P_SPECIALREQUEST  body                        } ! !{                                                                } ! !{  All special requests have the same first 5 word format :      } ! !{    W0 : XNET security code                                     } ! !{    W1 : resource number                                        } ! !{    W2 : XMOD classnumber                                       } ! !{    W3 : network write LU number                                } ! !{    W4 : special request code  ( variant record tag field )     } ! !{                                                                } ! !{  All buffers returned have the same first 2 word format :      } ! !{    W1 : error code                                             } ! !{    W2 : special request code  ( tag field )                    } ! !{                                                                } ! !{  An unknown request is returned with an error code = -99       } ! !{                                                                } ! !{****************************************************************} !     BEGIN       CurrentNet := -1; {convenient init}       If  XNETtlog > 0                              {M19 BG 19NOV86}  then  begin         { process only if correct security code }     If XNETIBUF.W[0] = XNETseccode    then          Case  XNETibuf.W [ 4 ]  of   { special request code }             0 :  P_SPECREQ0;   {enable network request }  "      1 :  P_SPECREQ1;   {allocate pool/modify svc special request}  "       2,                 {get pool info request}  !      3 :  P_SPECREQ23;  {release pool and get pool info request}  !       4 :  P_SPECREQ4 ;  {Enable Tracing}         5 :  P_SPECREQ5 ;  {Disable Tracing}        6 :  P_SPECREQ6 ;  {Obtain incoming call information}   #      7 :  P_SPECREQ7 ;  {Deallocate a pool LU independently of XMOD}  # #      8 :  P_SPECREQ8 ;  {Get Network State}         {M19 BG 16OCT86}  # #      9 :  P_SPECREQ9 ;  {Shut Down}                 {M19 BG 16OCT86}  #           otherwise { unknown request code }             IBUF[1] := -99 ;  { error code }               IBUF[2] := XNETibuf.W [4] ; { special request code }               ILEN    :=   2 ;   
           SPECREQ_REPLY;  
 	    end ; { case } 	       end ; { If XNETtlog > 0 }       
END ; { P_SPECIALREQUEST } 
 $page$  "{*****************************************************************}  " PROCEDURE    P_HANDSHAKEREAD ;          $direct$  "{*****************************************************************}  "     BEGIN        With Netwp^ do begin      {--------------------------------------------}      {Phase 1: General Clean UP (and Link downs)  }      {--------------------------------------------}          GEN_CLEAN_UP_LINKDOWN ;      #   {----------------------------------------------------------------}  # #   {Phase 2: Set Network state according to cause of general restart}  # #   {----------------------------------------------------------------}  #     
      Case GenResCause of  
       {}        {} CardDown  : { tenth IFCardError or tenth PowerFail }         {}                                    { Stop Recovery }   
      {}             begin 
       {}             {}  STATE := carderror;        {}             {}  Currentnet := -1;        {}             {}  GlobalWrite := NoWrite;        {}             {}  XMSGWR(1,RecoveryImp,CardWriteLU);   
      {}             end ; 
       {}  #      {} $SKIP_TEXT ON$                               {M13 BG 25APR86} #       {} XINITschedule, Powerfail : begin         {}                 STATE := ready ;         {}                 GlobalWrite := WConfigurationData ;        {}               end;         {} $SKIP_TEXT OFF$        {}        {} NetworkDown,   
      {} RestartInitiated, 
 #      {}   { After reception of a RESTART CONF pkt while in state R1 } # $      {}   { After reception of any pkt but RESTART while in state R2 }  $ 
      {} RestartReceived : 
 !      {}   { After reception of a RESTART pkt while in state R1 }  !       {}        {}   begin    { Link Disconnected }      {M2 BG 21jun85}        {}     {  RestartDelayTO is specified by XINIT }        {}     { There will be a delay if RestartDelayTO <> 0 }         {}        {}     if RestartDelayTO <> 0  then   
      {}       begin 
       {}         { initiate timer Restart Delay }         {}         { be careful with possible integer overflow }        {}         If ( 32767 - LastTime ) >= RestartDelayTO        {}         then   !      {}           RestartDelayWaitTO := RestartDelayTO + LastTime !       {}         else          {}           RestartDelayWaitTO := -32768 + RestartDelayTO         {}                                 + LastTime ;         {}  "      {}         X25TOctr := 1 ; { mutually exclusive with others }  "       {}         globalTOctr := globalTOctr + 1 ;   	      {}       end 	        {}     else  { RestartDelayTo = 0 , no delay or expired }    
      {}       begin 
       {}         { do not delay, restart Link right away }        {}         RestartDelayWaitTO := -1 ;         {}         State := ready ;         {}         GlobalWrite := Wopenline ;   
      {}       end ; 
 !      {}     end ;                                {M2 BG 21jun85}  !       {}        {} Otherwise { DVXschedule   }        {}           { XINITschedule }        {}           { PowerFail     }        {}           { IFCardError   }        {}         {}           { After that HandShake with card completed, }          {}           { the Restart Network Sequence will be :    }          {}           { - Configure Driver Response CN33 Write LU }          {}           { - Configure Driver Response CN33 Read  LU }          {}           { - Reset Card CN 35 'RS'  ( self test )    }          {}           { - Provide a delay for the modem lines     }          {}           {                       to settle down.     }          {}           { - Set Write Port ID CN 30 0               }          {}           { - Set Read  Port ID CN 30 1               }          {}           { - Write Configuration Data to Card        }          {}           { - Set Card Keep Alive Timer T3 on Read LU }          {}           { - Send Open Line command to level 2 CN 31 }          {}           { - Send Restart Request Packet to Network  }          {}           { - Send Read Header Request to Read LU     }         {}        {}           STATE := ready;  "      {}           GlobalWrite := WConfDvrRespWLU ; {M13 BG 25apr86} " 	      end {case};  	       {We already have GlobalRead=Noread}       
   end {with NETWP^} 
 
  end { P_HANDSHAKEREAD }; 
      $page$     {*********************************************}     procedure  RESET_AND_EQTCLEAR (EP: eqtPtrType);   $direct$    {*********************************************}         { Convenient for P_QBITDATAREAD }         begin          With EP^, AssociatedVC^ do begin             X25D := d4 { send reset } ;   	      Diag := 39 ; 	       Cause := 5 ; { Reset Local Proc err }         PktWriteNeeded := true;          { soft error completion on both eqts (write Eqt first): }              EQTCLEAR ( EP, 1, softerrorstatus );            If EqtType <> padeqttype              then EQTCLEAR( EP, 2, softerrorstatus );         end {with}     end {Reset_and_EqtClear};    $page$   !  {**************************************************************} ! !  {procedure P_INDREADFLUSH ;  $direct$                          } ! !  {**************************************************************} ! !  {Process completion of an Indirect DATA pkt read with flush.   } !     !  {**************************************************************} ! !  {procedure P_INDREADSAVE ;      $direct$                       } ! !  {**************************************************************} ! !  {Process completion of "indirect data pkt read without flush.  } !  $page$     {********************************************************}    PROCEDURE P_QBITDATAREAD ;  $direct$    {********************************************************}        {Process completion of direct Q bit DATA read.           }      
  VAR   S : -1..4 ;  
       BEGIN       !  With Netwp^,RespEQT^, WriteReadEQT[2]{readeqt},AssociatedVC^ do  !    begin       DataAvailable:= false;  MSGinProgress:= false;            Case ReqState  of      
        ReadState :  
           begin               If XNETpktTooLong = 1                 then RESET_AND_EQTCLEAR ( RespEQT )   !              else XSEND(DirectReadCompMsg,RespEqt,2,0,XNETtlog);  ! 
          end {ReadState}; 
             { CompleteWaitState : }               NoReq,          LinkDownState:               If GlobalRead=NoRead then CurrentNet:=-1;       end {case ReqState}         end {with}     end {P_QBITDATAREAD};    $page$   #  {*****************************************************************}  #   PROCEDURE    P_DATAPKTWRITE ;          $direct$   #  {*****************************************************************}  #       {process completion by the card of a data pkt write}        LABEL 98 ; {to speed up EQTPTR search}        VAR TSTMOD, TSTMOD2 : boolean ;         EPRLIM : byte ;         BEGIN           {use XNETIP2 to find EQT:}      EQTPTR:=NetwP^.firstEQT;      REPEAT {until EQTPTR = NIL}          WITH EQTPTR^ do begin            IF XNETIP2 = WriteEQTadd THEN goto 98;  
          EQTPTR:=NEXTEQT; 
 	       end;{WITH}  	     UNTIL EQTPTR = NIL;       {EQTPTR should never be nil}    98:       With NetwP^, EQTPTR^, WriteReadEqt[1] {writeEqt} do begin               Qlength := Qlength - 1;               WriteCount := WriteCount - 1;               If ReqState <> WriteState   	        then begin 	          {}   If (ReqState=CompleteWaitState) and (WriteCount<=0)   	        {}   then  	 #        {}     XSEND (NormalCompMsg, EQTPTR, 1, EQTstatus, EQTtlog) ;  #         end           else begin {test window }           {}With AssociatedVC^ do begin           {}   EPRLIM := EPR+EffectivePTW.OUTWDWsize-1;   "        {}   If EPRLIM>=8 then EPRLIM:=EPRLIM-8; {128 if extd numb}  "         {}   TSTMOD:= (epr<=eps); TSTMOD2:=(eps<=EPRLIM);           {}   If epr <= eprlim           {}   then TSTMOD := TSTMOD and TSTMOD2          {}   else TSTMOD := TSTMOD or TSTMOD2 ;           {}   If TSTMOD          {}   then {not window blocked}  PKTwriteNeeded:=true;   
        {}end {with} 
         end       end {with};         end  {  P_DATAPKTWRITE  };   $page$   $ {********************************************************************}  $     BEGIN             {  XSCH   body  }   $ {--------------------------------------------------------------------}  $ $ {                                                                    }  $ $ { Process information placed by XRECV into the folling variables :   }  $ $ {   XNETip1    : XNET mail identifier, used to recognize action      }  $ $ {   XNETip2    : write EQT address                                   }  $ $ {   XNETip3    : new request type; 1 = read, 2 = write, 3 = control  }  $ $ {   CURRENTNET : network index to current network beeing looked at   }  $ $ {   XNETstatus : completion status word : EQT5 (RTE6) or DVT6 (RTEA) }  $ $ {   XNETtlog   : completion transmission log, XNETibuf word size     }  $ $ {   XNETibuf   : buffer received containing mail to XNET             }  $ $ {   SAMOK      : true if not previously blocked due to lack of SAM.  }  $ $ {                                                                    }  $ $ {--------------------------------------------------------------------}  $      Case  XNETip1 of   { XNET mail indentifier }      {}      ip1TimeOut    :    { time out from the pseudo driver, }      {}  begin          { occurs periodically when nothing to do }      {}  {}  if SAMOK { not any previous SAM problem ? }     {}  {}    then CURRENTNET := -1  { skip dispatcher }      {}  {}    else CURRENTNET := 0 ; { dispatch all networks }      {}  end ;     {}      ip1NewRequest :  P_NEWREQUEST ;     {}      ip1SpecialReq :  P_SPECIALREQUEST ;     {}      otherwise {completion from card}      {}      {} NETWP := NetwPtrTbl [CURRENTNET];   {note: no verif}       {} With NETWP^ do begin       {}  {} If STATE <> ready      {}  {} then       {}  {}    case XNETip1 of       {}  {}    {}   $   {}  {}    {} ip1HandshakeWrite : GLOBALWRITE := WhandshakeCardRead;   $    {}  {}    {}      {}  {}    {} ip1HandshakeRead  :  P_HANDSHAKEREAD ;       {}  {}    {}      {}  {}    {} otherwise   CURRENTNET := -1 {ignore}      {}  {}    end {case}      {}  {} else begin     $page$   !   {}  {} {------------------------------------------------------} ! !   {}  {} {    PROCESS_CARD_STATUS                               } ! !   {}  {} {                                                      } ! !   {}  {} {    status bit 0 :  not used                          } ! !   {}  {} {    status bit 1 :  card needs configuration data     } ! !   {}  {} {    status bit 2 :  data available on card            } ! !   {}  {} {    status bit 3 :  maximum packet length exceeded    } ! !   {}  {} {    status bit 4 :  network down                      } ! !   {}  {} {    status bit 5 :  flush performed indication        } ! !   {}  {} {    status bit 6 :  programming error indication      } ! !   {}  {} {    status bit 7 :  unrecoverable card error          } ! !   {}  {} {------------------------------------------------------} !    {}  {}   #   {}  {} If ( XNETip3 = 3 { control } ) or ( XNETtlog = 0 { error } ) #    {}  {} then begin { TEST ERROR BITS }     {}  {}      {}  {}   If XNETstatus.bit6 = 1 { request error }  
   {}  {}    {} then begin 
    {}  {}    {}   LOADSEG ( 'XSEG3' ) ; {M30 BG 16FEB87}  !   {}  {}    {}   XSUSP ( 7 ) ; { suspend XNET } {M46 BG 11FEB88}  !    {}  {}    {}   LOADSEG ( 'XSEG4' ) ; {M30 BG 16FEB87}     {}  {}    {}   XNETip1:=Ip1CardStatus ;  
   {}  {}    {} end  
    {}  {}    {}   $   {}  {}   else  If XNETstatus.bit7 = 1 { unrecoverable Card Error ? }  $ 
   {}  {}    {} then begin 
    {}  {}    {}   If recoverycounter >=9  !   {}  {}    {}    then begin { 10th consecutive retry recovery }  ! !   {}  {}    {}    {} recoverycounter:=0;       { stop recovery }  !    {}  {}    {}    {} INGNRES ( CardDown ) ;     {}  {}    {}    end     {}  {}    {}   else begin     {}  {}    {}    {} recoverycounter := recoverycounter + 1 ;  !   {}  {}    {}    {} INGNRES ( IFCardError );  { M13 BG 22apr86 } !    {}  {}    {}    end ;     {}  {}    {}   XNETip1:= Ip1CardStatus ;   
   {}  {}    {} end  
    {}  {}    {}   $   {}  {}   else  If XNETstatus.bit1 = 1 { needs configuration data ? }  $ 
   {}  {}    {} then begin 
    {}  {}    {}   If recoverycounter >=9  !   {}  {}    {}    then begin { 10th consecutive retry recovery }  ! !   {}  {}    {}    {} recoverycounter:=0;       { stop recovery }  !    {}  {}    {}    {} INGNRES ( CardDown ) ;     {}  {}    {}    end     {}  {}    {}   else begin     {}  {}    {}    {} recoverycounter := recoverycounter + 1 ;     {}  {}    {}    {} INGNRES ( PowerFail ) ;      {}  {}    {}    end;      {}  {}    {}   XNETip1 := ip1CardStatus ;  
   {}  {}    {} end  
    {}  {}    {}      {}  {}   else  If XNETstatus.bit4 = 1 { Network down ? }   
   {}  {}    {} then begin 
    {}  {}    {}   {}  INGNRES ( NetworkDown );     {}  {}    {}   {}  XNETip1 := ip1CardStatus ;     {}  {}    {} end ;      {}  {}    {}      {}  {} { else no error }      {}  {}    {}      {}  {} end ; { if xnetip3 = 3 ... }     {}  {}      {}  {} XNETmoreDataOnCard := XNETstatus.bit2 ;      {}  {} XNETpktTooLong := XNETstatus.bit3 ;      {}  {}   #   {}  {} {--------  end  PROCESS-CARD_STATUS  ---------------------}  #  $page$      {}  {}  Case XNETip1 of { only completions from card }   #   {}  {}  {}              { May have been changed to ip1CardStatus }  #    {}  {}  {}              { by Process_card_status. }     {}  {}  {}      {}  {}  {} ip1PktHeader      : PKTHD ;      {}  {}  {}      {}  {}  {} ip1RestNonDataPkt :      {}  {}  {}   begin      {}  {}  {}     {} { Only if normal pkt numbering : }      {}  {}  {}     {} PKTheader.PKTbyte4.B := XNETIBUF.B[0] ;     {}  {}  {}     {} XNETibufByteIndex := 1 ;   
   {}  {}  {}     {} XPKT  
 
   {}  {}  {}   end; 
    {}  {}  {}      {}  {}  {} {ip1readflush/save    PM 11/82 }     {}  {}  {}      {}  {}  {} ip1QbitData       : P_QBITDATAREAD ;     {}  {}  {}      {}  {}  {} ip1QlengthGroup   :      {}  {}  {}   If X25R = R1 then      {}  {}  {}    begin     {}  {}  {}     If SAMOK then      {}  {}  {}      begin { not previously SAM blocked }      {}  {}  {}      {} If Qlength < MaxQlength   #   {}  {}  {}      {} then { not previously Q blocked: do not XDISP }  #    {}  {}  {}      {}   CurrentNet := -1     {}  {}  {}      {} else begin {previously Qlength blocked}      {}  {}  {}      {}   If (Qlength-1) >= MaxQlength  !   {}  {}  {}      {}    then {still Qlength blocked:do not XDISP} !    {}  {}  {}      {}      CurrentNet:=-1;  #   {}  {}  {}      {}    { else: no more Q blocked: XDISP CurrentNet } # 
   {}  {}  {}      {} end  
    {}  {}  {}      end  #   {}  {}  {}     else { previously SAM blocked: XDISP over all nets } #    {}  {}  {}         CurrentNet := 0 ;   !   {}  {}  {}     Qlength := Qlength -1 ; { update in all cases }  !    {}  {}  {}   end ; { else just ignore }     {}  {}  {}   !   {}  {}  {} ip1DataPktWrite   : If X25R=R1 then P_DATAPKTWRITE;  !    {}  {}  {}                     {else just ignore}     {}  {}  {}      {}  {}  {} ip1CardStatus     : {Nothing: goto Xdisp}  ;     {}  {}  {}      {}  {}  {} ip1IgnoreFromCard :      {}  {}  {}   If SAMOK {no previous SAM pb}      {}  {}  {}     then CurrentNet := -1  { skip XDISP }      {}  {}  {}     else CurrentNet := 0 ; { check all nets }      {}  {}  {}   $   {}  {}  {} ip1HandshakeWrite :            { Network state is Ready }  $ $   {}  {}  {} { After reception of a RESTART pkt while in state R1    }  $ $   {}  {}  {} {                                   'Restart Received'. }  $ $   {}  {}  {} { After recep. of a RESTART CONF pkt while in state R1  }  $ $   {}  {}  {} {                                   'Restart Initiated'.}  $ $   {}  {}  {} { After recep. of any pkt but RESTART while in state R2 }  $ $   {}  {}  {} {                                   'Restart Initiated'.}  $    {}  {}  {}   begin      {}  {}  {}     GEN_CLEAN_UP_LINKDOWN ;      {}  {}  {}     If GenResCause = RestartReceived  $   {}  {}  {}       then GlobalWrite := WRestartConf {restart received}  $ $   {}  {}  {}       else GlobalWrite := WRestart ;  {restart initiated}  $    {}  {}  {}   end ;      {}  {}  {}   !   {}  {}  {}                                      {M13 BG22apr86} ! !   {}  {}  {} ip1ConfDvrRespWLU : GlobalWrite := wConfDvrRespRLU ; !    {}  {}  {}      {}  {}  {} ip1ConfDvrRespRLU : GlobalWrite := wResetCard ;      {}  {}  {}       {}  {}  {} ip1ResetCard      :               {M13 BG 06JUN86}   
   {}  {}  {}  begin 
     {}  {}  {}   { Provide a Delay after resetting the Card    }        {}  {}  {}   { to allow for the modem lines to settle down.}        {}  {}  {}   { ResetDelayTO is defined by XINIT.           }        {}  {}  {}   { There will be a delay if ResetDelayTO <> 0  }       {}  {}  {}      {}  {}  {}   if ResetDelayTO <> 0  then     {}  {}  {}     begin      {}  {}  {}       { initiate timer Reset Delay }  !   {}  {}  {}       { be careful with possible integer overflow }  !    {}  {}  {}       If ( 32767 - LastTime ) >= ResetDelayTO   #   {}  {}  {}        then ResetDelayWaitTO := ResetDelayTO + LastTime  # "   {}  {}  {}        else ResetDelayWaitTO := -32768 + ResetDelayTO  " !   {}  {}  {}                                        + LastTime ;  !    {}  {}  {}   #   {}  {}  {}       X25TOctr := 1 ; { mutually exclusive with others } #    {}  {}  {}       globalTOctr := globalTOctr + 1 ;     {}  {}  {}     end   "   {}  {}  {}   else      { ResetDelayTo = 0, no delay or expired }  "    {}  {}  {}     begin      {}  {}  {}       ResetDelayWaitTO := -1 ;     {}  {}  {}       GlobalWrite := wSetWritePortID ;     {}  {}  {}     end ;   $   {}  {}  {} end ;                                    {M13 BG 06JUN86}  $    {}  {}  {}   !   {}  {}  {} ip1SetWritePortID : GlobalWrite := wSetReadPortID ;  !    {}  {}  {}   #   {}  {}  {} ip1SetReadPortID  : GlobalWrite := wConfigurationData ;  #    {}  {}  {}       {}  {}  {} ip1ConfigData     : GlobalWrite := wCardTimerT3 ;       {}  {}  {}      {}  {}  {} ip1CardTimerT3    : GlobalWrite := wOpenLine ;     {}  {}  {}   "   {}  {}  {} { Suppressed readflush in network restart procedure }  " "   {}  {}  {} $skip_text on$                      { M53 BG 15JUN8 }  "    {}  {}  {} ip1OpenLine       : GlobalWrite := wReadFlush ;      {}  {}  {}      {}  {}  {} ip1ReadFlush      : begin      {}  {}  {}                       recoverycounter := 0 ;     {}  {}  {}                       GlobalWrite := Wrestart ;       {}  {}  {}                       GlobalRead  := ReadHeader ;    !   {}  {}  {}                       X25R := R4 ;  { Send Restart } !    {}  {}  {}                     end ;      {}  {}  {} $skip_text off$      {}  {}  {}      {}  {}  {} ip1OpenLine       : begin      {}  {}  {}                       recoverycounter := 0 ;     {}  {}  {}                       GlobalWrite := Wrestart ;       {}  {}  {}                       GlobalRead  := ReadHeader ;    !   {}  {}  {}                       X25R := R4 ;  { Send Restart } !    {}  {}  {}                     end ;      {}  {}  {}   #   {}  {}  {} otherwise ; { do nothing }              {M13 BG 02JUN86} # #   {}  {}  {} { can happen if pending Read Header request is aborted } #    {}  {}  {} { e.g. during Network Restart procedure. }     {}  {}  {}      {}  {}  end { case completions from card }      {}  {} end { else of if state <> ready }   
   {}  end { with Netwp }  
 
   end { main case } 
   end {  XSCH };   . { end of program unit  XSCH } 