# {********************************************************************} # $PASCAL '91751-1X032 REV.5020 <900219.1424>' # {********************************************************************} ## {                                                                    } ## {    FILE:   XSEG3.PAS                                               } ## {    SOURCE: 91751-18032                                             } ## {    RELOC.: 91751-1X032                                             } ## {                                                                    } ## {  ***************************************************************   } ## {  * (C) COPYRIGHT HEWLETT-PACKARD COMPANY 1982.  ALL RIGHTS     *   } ## {  * RESERVED.  NO PART OF THIS PROGRAM MAY BE PHOTOCOPIED,      *   } ## {  * REPRODUCED OR TRANSLATED TO ANOTHER PROGRAM LANGUAGE WITHOUT*   } ## {  * THE PRIOR WRITTEN CONSENT OF HEWLETT-PACKARD COMPANY.       *   } ## {  ***************************************************************   } ## {                                                                    } ## {--------------------------------------------------------------------} ## {                                                                    } ## {  Contains the following procedures and functions :                 } ## {                                                                    } ## {  - XSUSP                                                           } ## {  - DO_SHUTDOWN                                                     } ## {  - TBLBUILD : - NEW_TOP_OF_HEAP                                    } ## {               - VCSEARCH                                           } ## {               - CHECKL                                             } ## {               - CALL_NEW                                           } ## {                                                                    } ## {--------------------------------------------------------------------} ## {                                                                    } ## { HISTORY :                                                          } ## {                                                                    } ## { Original   : 2401                                                  } ## {   .new module, due to the fact that XNET                           } ## {    had to be segmented for flow control enhancement                } ## {    modifications: this module is in charge of creating             } ## {    the tables used by XNET                                         } ## { Change #1 : 2440                                                   } ## {    PASCAL 2440 support                                             } ## { Change #2 : 5.0    (BG)                                            } ## {    .Add Restart Delay Time Out counter. (M2)                       } ## {    .Add tracing to display the size of EMA tables and buffers. (M5)} ## {    .Add initialization of Lastbufferfilled in EQT tables. (M10)    } ## {    .Add initialization of DDX60_entry_num and Timer_T3.  (M13)     } ## {    .Add new procedure DO_SHUTDOWN. (M19)                           } ## {    .Suppress $range off$, as this segment is not speed critical.   } ## {                                                           (M21)    } ## {    .Suppress duplicate procedure MSG1WRITE. (M29)                  } ## {    .Move procedure XSUSP from module XNETM.PAS to XSEG3.PAS. (M30) } ## {    .Add the type of XNET suspend in message printed by XSUSP.(M27) } ## {    .Add the creation of a dummy buffer of 1Kw in the heap.         } ## {     This to temporarily turn around the EM82 problem. (M34)        } ## {    .Suppress procedure VCSEARCH as it is a duplicate of the same   } ## {     in XNETM.                                         (M40)        } ## { Change #3 : 5.1    (BG)                                            } ## {    .Improve error reporting in case of XNET suspend.  (M46)        } ## {    .Check for enough EMA before creating a new oject and stop XNET } ## {     if EMA is too small.                              (M55)        } ## {    .Move procedure DO_SHUTDOWN from XSEG3 to XSCH. (M63)           } ## { Change #4 : 5.2    (BG)                                            } ## {    .Add initialization of fields TermMsgExpected, Send_DC1,        } ## {     and Terminal_Status in PAD EQT extent.                (M77)    } ## {    .Add initialization of field SendCRLF in EQTtblrec .   (M77)    } ## {    .Add initialization of field remaininglength in EQTtblrec. (M75)} ## {    .Move back procedure VCSEARCH from XNETM to save code space.    } ## {                                                           (M80)    } ## {                                                                    } ## {********************************************************************} #     
 $STANDARD_LEVEL 'HP1000'$ 
 $HEAP 2$  $SEGMENT, RECURSIVE OFF$ # $skip_text on$                                        {M21 BG 16JAN87} #  $RANGE OFF$   $skip_text off$  $RANGE ON$   $CDS OFF$   $HEAP_DISPOSE OFF$      { For using the short version }   { of heap management, so data space will be allocated }   { without adding a data size information.             }      PROGRAM XSEG3;       { Includes XTBLG.PASI, XTBLV.PASI, XNETG.PASI }  $LIST OFF$  {path directory must be provide in the installation procedure}  $INCLUDE 'XTBLG.PASI'$  $INCLUDE 'XTBLV.PASI'$  $INCLUDE 'XNETG.PASI'$   $LIST ON$      $PAGE$   $HEAPPARMS OFF$  procedure ABREG ( var A_reg, B_reg : word ) ; external ;                                                {M30 BG 16FEB87}       procedure STOP $alias 'EXEC' {PROGRAM COMPLETION}$ (icode:word);    external;     # procedure  XEXEC2 $alias 'EXEC' {direct write}$ {special for messages} #   (icode, icnwd: word; ibuf: XMSGtype; ilen: word );   external;      " procedure EXEC2 $alias 'EXEC' {write}$ {special for internal trace} "   (icode, icnwd: word; ibuf:pa75c; ilen:word);   external;     ! procedure SUSPEND $alias 'EXEC'$  (icode: word);  {M30 BG 16FEB87} !                                        external;      $skip_text on$                                {M80 BG 16FEB90}  
 procedure  VCSEARCH 
    ( NP: NetwPtrType; IVC: word; var VCP: VCptrType); $direct$   external;                                    {M40 BG 02SEP87}   $skip_text off$       procedure XTMGR  { access and update XTBL }    (f:word; var index, length : word; var T: XTBLwordsType;     WriteResLU : word);   external;      # procedure CNUM ( n : word ; var nbconv : pa6c ) ; $DIRECT$ external ; # #                                                       {M5 BG 22aug85} #     procedure GETHEAP2INFO $ alias 'Pas.GetMemInfo2' $                          $heapparms on$  #                        ( var heap2info : heap2infotype ) ; external ; # #                        $heapparms off$                {M5 BG 22aug85} #     function StrDsc ( buffer : pa75c ;                     startchar , nchars : word ) : double_word ;                                     external ;  {M5 BG 22OCT85}       procedure  MSG1WRITE ( Msglu : word; MSG : pa75c );  $direct$                                     external ; {M29 BG 16FEB87}      $SKIP_TEXT ON$        function DintToDecimal ( number : double_word ) : double_word ;                                       external ;    {M5 BG 22OCT85}        function DintToOctal ( number : double_word ) : double_word ;                                     external ;  {M5 BG 22OCT85}   $SKIP_TEXT OFF$      #{ Following procedures DITOA and DITOCTAL are for temporary use,     } # #{ as DintToDecimal and DintToOctal rev.2440 don't work. M5 BG 08NOV85} #    #{*********************************************************************} ##{                                                                     } ##{ FUNCTION    >>> DITOA <<<                                           } ##{                                                                     } ##{ ** Double Integer to ASCII character conversion. ( left justified ) } ##{ ** The string is 11 ASCII character long maximum.                   } ##{ ** ( defined by the constant  integer_string_length )               } ##{                                                                     } ##{ External Type declarations :  pa75c , word                          } ##{                                                                     } ##{ Procedures and Functions referenced :   NONE                        } ##{                                                                     } ##{ Global Variables accessed  :                                        } ##{                                                                     } ##{   READ ONLY :  NONE                                                 } ##{                                                                     } ##{   MODIFIED  :  NONE                                                 } ##{                                                                     } ##{*************************************************** update 30 OCT 85 } #    FUNCTION DITOA ( number : double_word ) : pa75c ;      TYPE       string10 = PACKED ARRAY [ 1..10 ] OF CHAR ;     CONST       base = 10 ;   zero_nine = string10 [ '0123456789' ] ;    integer_string_length = 75 ; { related to pa75c type }     VAR        I , J , lsd : word ;    string , string2 : pa75c ; 
  negatif : BOOLEAN ; 
    BEGIN        DITOA := ' ' ;   string := ' ' ;  	  string2 := ' ' ; 	 
  negatif := FALSE ; 
    
  IF number < 0  THEN 
    BEGIN       negatif := TRUE ;  
      number := - number ; 
    END ;        I := integer_string_length ;      #  {********* convert number to char. string right justified *********} #   REPEAT !      lsd := ( number MOD base ) + 1 ;  { least significant digit } !      string [ I ] := zero_nine [ lsd ] ;  	      I := I - 1 ; 	      number := number  DIV  base ;   UNTIL  (( number = 0 ) OR ( I <= 0 )) ;     
  { remove leading spaces } 
   I := 1 ;   WHILE  (( I <= integer_string_length )  AND !          ( string [ I ] = ' ' ))  DO  I := I + 1 ; { skip blanks } ! 	  string2 := ' ' ; 	   J := 1 ; 	  IF  negatif  THEN 	    BEGIN        string2 [ J ] := '-' ;  	      J := J + 1 ; 	    END ;        WHILE (( I <= integer_string_length )  AND           ( J <= integer_string_length ))  DO     BEGIN       string2 [ J ] := string [ I ] ;  	      I := I + 1 ; 	 	      J := J + 1 ; 	    END ;      
  DITOA := string2 ; 
     END ;  {  end of the procedure  DITOA  }                 #{*********************************************************************} ##{                                                                     } ##{ FUNCTION    >>> DITOCTAL <<<                                        } ##{                                                                     } ##{ ** Integer to octal character conversion.  ( left justified )       } ##{ ** The string is 11 ASCII character long.                           } ##{ ** ( defined by the constant  octal_string_length )                 } ##{                                                                     } ##{ External Type declarations :  pa75c                                 } ##{                                                                     } ##{ Procedures and Functions referenced :   NONE                        } ##{                                                                     } ##{ Global Variables accessed  :                                        } ##{                                                                     } ##{   READ ONLY :  NONE                                                 } ##{                                                                     } ##{   MODIFIED  :  NONE                                                 } ##{                                                                     } ##{*************************************************** update 30 OCT 85 } #     FUNCTION DITOCTAL ( number : INTEGER ) : pa75c ;      TYPE       string8 = PACKED ARRAY [ 1..8 ] OF CHAR ;     CONST        octal_string_length = 11 ;    base = 8 ;   zero_seven = string8 [ '01234567' ] ;     VAR     
  I , lsd : INTEGER ; 
  negative_number : BOOLEAN ;  	  string : pa75c ; 	    BEGIN     	  ditoctal := ' ' ; 	  string := ' ' ;    negative_number := FALSE ;        I := octal_string_length ;     #  {********** convert number to char. string right justified *********} #       IF  number < 0  THEN     BEGIN       negative_number := TRUE ;       { number := number + 32768 ; } { for a single word integer }          number := number - MININT ;  { for a double word integer }      END ;     !  REPEAT       { maximun loop count equals to octal_string_length } !    !      lsd := ( number MOD base ) + 1 ;  { least significant digit } !           string [ I ] := zero_seven [ lsd ] ;      	      I := I - 1 ; 	          number := number  DIV  base ;       UNTIL  (( number = 0 ) OR ( I <= 0 )) ;        IF  negative_number   THEN  "    string [ 1 ] := zero_seven [ 2 ] ;   { force sign digit to '1' } "       Ditoctal := string ;      END ;  {  end of the procedure  Ditoctal }                  {******************************}  PROCEDURE  XSUSP ( n : word ) ; $direct$  {******************************}     { Suspend XNET after a severe error }     #{ 1: invalid length of new request from DVX (XRECV).                  } ##{ 2: direct writing to write reserved LU completed in error (XSEND).  } ##{ 3: card EMA read completed in request error  (GLOBAL_READS).        } ##{ 4: VMAIO writing data to DVX00 completed in error (XDISP).          } ##{ 5: unexpected case of X25P when a VC timer has expired (TIMER_TESTS)} ##{ 6: unexpected case of X25P when sending packet to a VC (X25P_WRITES)} ##{ 7: card I/O completed in request error  (XSCH).                     } ##{ 8: direct writing to write reserved LU completed in error (XSEND).  } #     TYPE        Ptr_case = 1..4 ;         { added M46 BG 16FEB88 } 	  Ptr_type = record 	               case ptr_case of                   1 : ( N : NETWPtrtype ) ;                  2 : ( E : EQTPTRtype ) ;                   3 : ( V : VCPTRtype ) ;                   4 : ( A : double_word ) ;  	             end ; 	    VAR        I : word ;    Ptr_var : Ptr_type ;      &PROCEDURE DISPLAY_V ( V_name : double_word ; msglength : word ) ;    { M46 } &      BEGIN          msglength := msglength + 1 ;   { cnum ( V_name, nbconv ) ;}{ conversion decimal to ASCII }    { strmove ( 6, nbconv, 1, temp1_pa75c, msglength ) ; }    { msglength := msglength + 6 ; } "    temp2_pa75c := DITOA ( V_name ) ; { conversion decimal to ASCII } "    strmove ( 11, temp2_pa75c , 1, temp1_pa75c, msglength ) ;     msglength := msglength + 11 ;     temp2_pa75c := '    octal : ' ;     strmove ( 12, temp2_pa75c , 1, temp1_pa75c, msglength ) ;     msglength := msglength + 12 ;      temp2_pa75c := Ditoctal ( V_name ) ;    { desc_temp2_75c := DinttoOctal ( V_name ) ; }      strmove ( 6, temp2_pa75c , 6, temp1_pa75c, msglength ) ;      msglength := msglength + 6 ;  !    EXEC2 (2,1{lu}, temp1_pa75c, -msglength ) ; { output message } !     temp1_pa75c := ' ' ;     
  END ; { display_v } 
         BEGIN  { XSUSP }       $skip_text on$                               {M27 BG 11FEB87}   XEXEC2 (2,1{lu}, ERRMSG5, -ERRMSGLength);   $skip_text off$       temp1_pa75c := ERRMSG5 ; { "XNET SUSPENDED, SEVERE ERROR" } "  cnum ( n {suspend type}, nbconv ) ; { conversion decimal to ASCII } "   strmove ( 6, nbconv, 1, temp1_pa75c, ERRMSGlength +1 ) ;   msglength := errmsglength + 6 ;   EXEC2 (2,1{lu}, temp1_pa75c, 0 ) ;          { skip a line }     EXEC2 (2,1{lu}, temp1_pa75c, -msglength ) ; { output message }     temp1_pa75c := ' ' ;       CASE  n  OF         1 : begin            temp1_pa75c := #    '             INVALID LENGTH OF NEW REQUEST FROM DVX, XNETtlog = '; #
          msglength := 64 ; 
"          cnum ( XNETTlog, nbconv ) ; { conversion decimal to ASCII } "           strmove ( 6, nbconv, 1, temp1_pa75c, msglength ) ;            msglength := msglength + 6 ;         end ;         2,8 :         begin            temp1_pa75c :=  !    '             DIRECT WRITING TO WRITE RESERVED LU ERROR :  ' ; !
          msglength := 58 ; 
          strmove ( 4, REGAB.S, 1, temp1_pa75c, msglength ) ;            msglength := msglength + 4 ;         end ;         3 : begin            temp1_pa75c :=     '             CARD EMA READ COMPLETED IN REQUEST ERROR '; 
          msglength := 54 ; 
        end ;         4 : begin            temp1_pa75c := "    '             VMAIO WRITING DATA TO WRITE RESERVED LU ERROR :  '; "
          msglength := 62 ; 
          strmove ( 4, REGAB.S, 1, temp1_pa75c, msglength ) ;            msglength := msglength + 4 ;         end ;         5 : begin            temp1_pa75c :=     '             VC TIMER EXPIRED WITH UNEXPECTED X25P :  '; 
          msglength := 54 ; 
          case VCPTR^.X25P of              P1 : temp2_pa75c := 'P1' ;              P2 : temp2_pa75c := 'P2' ;              P3 : temp2_pa75c := 'P3' ;              P4 : temp2_pa75c := 'P4' ;              P5 : temp2_pa75c := 'P5' ;              P6 : temp2_pa75c := 'P6' ;              P7 : temp2_pa75c := 'P7' ;              P8 : temp2_pa75c := 'P8' ;  
          otherwise  end ; 
           strmove ( 2, temp2_pa75c, 1, temp1_pa75c, msglength ) ;             msglength := msglength + 2 ;         end ;         6 : begin            temp1_pa75c := !    '             UNEXPECTED CASE OF X25P WHILE SENDING PACKET : '; !
          msglength := 60 ; 
          case VCPTR^.X25P of              P1 : temp2_pa75c := 'P1' ;              P2 : temp2_pa75c := 'P2' ;              P3 : temp2_pa75c := 'P3' ;              P4 : temp2_pa75c := 'P4' ;              P5 : temp2_pa75c := 'P5' ;              P6 : temp2_pa75c := 'P6' ;              P7 : temp2_pa75c := 'P7' ;              P8 : temp2_pa75c := 'P8' ;  
          otherwise  end ; 
           strmove ( 2, temp2_pa75c, 1, temp1_pa75c, msglength ) ;             msglength := msglength + 2 ;         end ;         7 : begin            temp1_pa75c :=      '             CARD I/O COMPLETED IN REQUEST ERROR '; 
          msglength := 49 ; 
        end ;     	  OTHERWISE   end ; 	        EXEC2 (2,1{lu}, temp1_pa75c, -msglength ) ; { output message }    EXEC2 (2,1{lu}, temp1_pa75c, 0 ) ;          { skip a line }      #  temp1_pa75c := 'XNETip1      : ' ;                { M46 BG 16FEB88 } #	  msglength := 15 ; 	   display_v ( XNETip1, msglength ) ;        temp1_pa75c := 'REGAB.w.A    : ' ; 	  msglength := 15 ; 	   display_v ( REGAB.w.A, msglength ) ;        temp1_pa75c := 'XNETstatus   : ' ; 	  msglength := 15 ; 	  display_v ( XNETstatus.w, msglength ) ;        temp1_pa75c := 'REGAB.w.B    : ' ; 	  msglength := 15 ; 	   display_v ( REGAB.w.B, msglength ) ;        temp1_pa75c := 'XNETtlog     : ' ; 	  msglength := 15 ; 	  display_v ( XNETtlog, msglength ) ;        temp1_pa75c := 'NETWP        : ' ; 	  msglength := 15 ; 	   Ptr_var.N := NETWP ;    display_v ( Ptr_var.A, msglength ) ;        temp1_pa75c := 'EQTPTR       : ' ; 	  msglength := 15 ; 	  Ptr_var.E := EQTPTR ;    display_v ( Ptr_var.A, msglength ) ;        temp1_pa75c := 'VCPTR        : ' ; 	  msglength := 15 ; 	   Ptr_var.V := VCPTR ;    display_v ( Ptr_var.A, msglength ) ;       FOR  I := 0 TO 11  DO     BEGIN        temp1_pa75c := 'XNETibuf[' ;       msglength := 10 ; { 9 + 1 }        cnum ( I, nbconv ) ; { conversion decimal to ASCII }        strmove ( 2, nbconv, 5, temp1_pa75c, msglength ) ;        msglength := msglength + 2 ;       temp2_pa75c := '] : ' ;       strmove ( 4, temp2_pa75c, 1, temp1_pa75c, msglength ) ;        msglength := msglength + 3 ; { 4 - 1 }        display_v ( XNETibuf.w[I], msglength ) ;  
    END ; { for do } 
      EXEC2 (2,1{lu}, temp1_pa75c, 0 ) ;          { skip a line }       SUSPEND ( 7 ) ;     END ; { XSUSP }  $page$ #$SKIP_TEXT ON$                                         {M63 BG 20JUL88} ##{*********************************************************************} ##{                                                                     } ##{            DO_SHUTDOWN                                              } ##{                                                                     } ##{ Entry parameter :  reply synch. resource number 1 = XNETibuf word 5 } ##{                    reply synch. resource number 2 = XNETibuf word 6 } ##{                                                                     } ##{ Exit parameter  :  none                                             } ##{                                                                     } ##{ Referenced Procedures and functions : RNRQ, XTMGR, XEXEC2, CLRQ,    } ##{                                       Gen_Clean_Up_LinkDown, STOP   } ##{                                                                     } ##{ Referenced messages : ERRMSG6, SDMSG1                               } ##{                                                                     } ##{ Added  M19 BG 16FEB87                                               } ##{*********************************************************************} #    !PROCEDURE DO_SHUTDOWN ( reply_synch_RN1, reply_synch_RN2 : word ) ; !    CONST       deallocate_noabort = 2 + noabortB14 ;     VAR       L , N , status : word ;     BEGIN     #   { Lock the first Resource Number and wait for the special request  } ##   { initiator to retreive the special request reply returned by XNET } #       RNRQ ( 1 {bit0 RN_local_lock}, reply_synch_RN1, status ) ;                                                   { suspend }  
   { end of suspension : } 
    { the special request initiator has received the reply now   }      { and also retreived the network Lus from XTBL tables in SAM.}          RNRQ ( 32 {bit5 RN_deallocate}, reply_synch_RN1, status ) ;        { Clean up all VC and EQT tables, Timers and Qlenth    }    { Also send LinkDown for each VC ( established or not )}         For  N := 1 to NbOfNetworks  Do       begin         NetwP := NetwPtrTbl [ N ] ;         NetwP^.GenResCause := CauseShutDown ;         Gen_Clean_Up_LinkDown ;       end ;             { Release XNET Class number }     { and also flush all XNET I/O Class requests to the cards }         CLRQ ( deallocate_noabort, XNETclassnbA ) ;       begin  { no abort error return processing }         abreg ( regab.w.A , regab.w.B ) ;       end ;        { Now that pending I/O class requests have been flushed  }    { allow the caller to continue and send the "close line".}        RNRQ ( 4 {bit2 RN_unlock}, reply_synch_RN2, status ) ;        { Release XTBL table from SAM. }     { Address of XTBL in word @XTBL will be reset to zero }         XTMGR ( 4 {deallocate}, dummy1 {place holder for offset},             L {length}, XTBL.words, WriteReservedLU ) ;        If  L = -2  !    then   { Error, XTBL table could not be deallocated from SAM } !      XEXEC2 ( 2, 1{lu}, ERRMSG6, -ERRMSGLength ) ;            { Output Shutdown message to the system console. }  "   { Procedure XMSGWR is not used as XNET class nb is now released.} "       XEXEC2 ( 2, 1{lu}, SDMSG1, 0 ) ; { skip a line }         XEXEC2 ( 2, 1{lu}, SDMSG1, -SDMSGLength ) ;     !   { to make sure previous message get output onto system console } !!   { before XNET stops completly and its requests get aborted.    } !       XEXEC2 ( 2, 1{lu}, SDMSG1, 0 ) ; { skip a line }         	   STOP ( EXEC6 ) ; 	      { Stop XNET overall activity, }      { Resources should be released, Resource & Class numbers }      { Pending requests should be aborted }       { ID segment should not be released as XNET has been RP'ed }        { On rescheduling, program should be reloaded from file }     
END ; { DO_SHUTDOWN } 
 $page$ $SKIP_TEXT OFF$ {***********************************************}  PROCEDURE    TBLBUILD  ;                $direct$ {***********************************************}      "TYPE   dummy_buf_ptr  = ^dummy_buf_type ;           {M34 BG 25MAR87} " "       dummy_buf_type = array [ 1..1016 ] of word ; {M34 BG 25MAR87} " "       { To turn around the EM82 problem, create a dummy buffer.   } " "       { 8 words HEAP2 overhead + 1016 words = 1024, just one page } " "       { So the first network table will end at beginning of next  } " "       { to last page.                                             } "    VAR    INDEX   : word; {index into XTBL }         L       : word;        INET    : 1..maxNbofNetworks ;  
       I       : -1..4096; 
       VCP,PrevVCP : VCptrType;         IVC  : 0..4095;        EQTP, PrevEQTP : EQTptrType;         PADH   : XTBLpadSvcHeaderEntryType; 
       J      : word; 
       Previous : EMAPTRtype;        new_size , previous_toh : double_word ;  {M5 BG 22OCT85}          dummy_buf : dummy_buf_ptr ;              {M34 BG 25MAR87}              #$skip_text on$   { duplicate of procedure in XNETM.PAS  M29 BG 16FEB87} # {********************************************************}   procedure  MSG1WRITE (Msglu:word; MSG:pa75c);  $direct$  {********************************************************}    begin {write MSG on MSGLU}          EXEC2 (2,MsgLU, MSG, -75);      end {msg1write}; $skip_text off$       {*************************}  # PROCEDURE NEW_TOP_OF_HEAP ;                           {M5 BG 31OCT85} #  {*************************}      { utility procedure for tracing EMA objects size }       begin           temp1_pa75c := ' TBLBUILD : new top of heap : ' ;      temp2_pa75c := DITOA ( heap2info.toh ) ; { Dint to ascii }     { desc_temp2_75c := DintToDecimal ( heap2info.toh ) ; }       strmove ( 11 , temp2_pa75c , 1 , temp1_pa75c , 35 ) ;       temp2_pa75c := 'octal : ' ;       strmove ( 11 , temp2_pa75c , 1 , temp1_pa75c , 45 ) ;       temp2_pa75c := Ditoctal ( heap2info.toh ) ;     { desc_temp2_75c := DinttoOctal ( heap2info.toh ) ; }       strmove ( 11 , temp2_pa75c , 1 , temp1_pa75c , 55 ) ;       msg1write ( Msglu , temp1_pa75c ) ;      # end ;  { new_top_of_heap }                            {M5 BG 31OCT85} # $page$       {*****************************************************}   {                                                     }   {                    VCSEARCH                         }   {                                                     }   { Find a VC tbl, given a network ptr and a VC number. }   { Sequential search over circular list of VC tables   }   { of this network.                                    }   {                                                     }   { Called from TBLBUILD                                }   {                                                     }   {*****************************************************}     	 PROCEDURE VCSEARCH 	           ( NP  : NetwPtrType ; { identifies the network }               IVC : word   ;      { VC number } !             var VCP : VCptrType { result: ptr on VC rec if found } !!                                 {       : NIL if VC not found    } !            ); $direct$        VAR  VCfound    : boolean;        V          : VCptrType ;         LoopLimit  : VCptrtype;       BEGIN     
    VCfound := false; 
    V := NP^.FirstVC ;  {never NIL}  
    LoopLimit := V ; 
         repeat      {}     {}   if V^.VCnb = IVC     {}      then  VCfound := true      {}      else  V := V^.NextVC      {}     until ( VCfound or ( V = LoopLimit )) ;            if VCfound 	      then VCP := V 	
      else VCP := NIL 
    	  end {VCSEARCH } ; 	     $page$  {*******************************************}     procedure CHECKL ;            $direct$ {*******************************************}       {verify value of L for error return from XTMGR}     begin           If L = -1       then begin        { "SAM TABLE TOO SHORT" }           XEXEC2(2,1{lu},ERRMSG3, -ErrMsgLength) ;{INDEX error}            stop(exec6);       end    end {CHECKL} ;        {****************************************}   procedure CALL_NEW ;         $direct$    {****************************************}         var  enough_space : boolean ;         begin          GETHEAP2INFO ( heap2info ) ;       new_size := heap2info.toh - heap2info.tos ;      case EQTP^.EffectivePTW.Inpktsize OF         4   :   begin enough_space := ( new_size > 16   ); end;         5   :   begin enough_space := ( new_size > 32   ); end;         6   :   begin enough_space := ( new_size > 64   ); end;         7   :   begin enough_space := ( new_size > 128  ); end;         8   :   begin enough_space := ( new_size > 256  ); end;         9   :   begin enough_space := ( new_size > 512  ); end;         10  :   begin enough_space := ( new_size > 1024 ); end;         otherwise  	     end; { case } 	    
     If  enough_space 
 
     then  with  EQTP^  do 
        begin        {}  {Build EMA buffers list}        {}  case EffectivePTW.Inpktsize OF        {}     4   :   begin NEW(EMAPTR,1) ;  end;        {}     5   :   begin NEW(EMAPTR,2) ;  end;        {}     6   :   begin NEW(EMAPTR,3) ;  end;        {}     7   :   begin NEW(EMAPTR,4) ;  end;        {}     8   :   begin NEW(EMAPTR,5) ;  end;        {}     9   :   begin NEW(EMAPTR,6) ;  end;        {}     10  :   begin NEW(EMAPTR,7) ;  end;        {}     otherwise         {}  end; { case }  
       end  { with } 
     else        begin   { not enough space in EMA to build next object }     #         XEXEC2 ( 2, 1 {LU}, ERRMSG7, -ERRMSGLength ); {M55 BG 17JUN88} #             STOP ( exec6 ) ;             end ;     #      { if trace enabled display the new top of heap. } {M5 BG 22AUG85} #           if msglu <> 0 then  { only if tracing is enabled }         begin            GETHEAP2INFO ( heap2info ) ; 
          new_top_of_heap ; 
#        end ;                                           {M5 BG 22AUG85} #   end;  $page$  {************************************************************}   BEGIN  {  TBLBUILD    body  }  {************************************************************}        {------------------------------------}    {   obtain XTBL GLOBAL ENTRY         }    {------------------------------------}         L := XTBLglobalEntryLength;     INDEX := 0;     XTMGR ( 1, INDEX, L, XTBL.WORDS, WriteReservedLU );     CHECKL ; {stops if error}     INDEX := INDEX + L;          NbOfNetworks := XTBL.GLOBALENTRY.NbOfNetworks;     DDX60_entry_num := XTBL.GLOBALENTRY.DDX60_entry_num ;       {only useful components here}      {M13 BG 22APR86}        {--------------------------------------------}    {    Network by Network table creation       }    {--------------------------------------------}        { save Top Of Heap for tracing the size of EMA objects }    { and display the initial available heap size.         }                                             {M5 BG 22AUG85}        if msglu <> 0 then  { only if tracing is enabled }     begin        GETHEAP2INFO ( heap2info ) ;       new_size := heap2info.toh - heap2info.tos ;  !      previous_toh := heap2info.toh ;   { reference for next NEW } !       desc_temp2_75c := StrDsc ( temp2_pa75c , 1, 75 ) ;                                       { first time used }       temp2_pa75c := DITOA ( new_size ) ; { Dint to ascii } #    { desc_temp2_75c := DintToDecimal ( new_size ) ; }{ Dint to ascii } #      temp1_pa75c := ' TBLBUILD : total heap size : ' ;       strmove ( 11 , temp2_pa75c , 1 , temp1_pa75c , 35 ) ;       temp2_pa75c := 'octal : ' ;       strmove ( 11 , temp2_pa75c , 1 , temp1_pa75c , 45 ) ;        temp2_pa75c := Ditoctal ( new_size ) ;     { desc_temp2_75c := DintToOctal ( heap2info.toh ) ; }       strmove ( 11 , temp2_pa75c , 1 , temp1_pa75c , 55 ) ;       msg1write ( Msglu , temp1_pa75c ) ; 	     $SKIP_TEXT ON$ 	      temp1_pa75c := ' TBLBUILD : top of heap     : ' ;         temp2_pa75c := DITOA ( heap2info.toh ) ; { Dint to ascii }      { desc_temp2_75c := DintToDecimal ( heap2info.toh ) ; }       strmove ( 11 , temp2_pa75c , 1 , temp1_pa75c , 35 ) ;       temp2_pa75c := 'octal : ' ;       strmove ( 11 , temp2_pa75c , 1 , temp1_pa75c , 45 ) ;       temp2_pa75c := Ditoctal ( heap2info.toh ) ;     { desc_temp2_75c := DintToOctal ( heap2info.toh ) ; }       strmove ( 11 , temp2_pa75c , 1 , temp1_pa75c , 55 ) ;       msg1write ( Msglu , temp1_pa75c ) ;       temp1_pa75c := ' TBLBUILD : top of stack    : ' ;         temp2_pa75c := DITOA ( heap2info.tos ) ; { Dint to ascii }       { desc_temp2_75c := DintToDecimal ( heap2info.tos ) ;}       strmove ( 11 , temp2_pa75c , 1 , temp1_pa75c , 35 ) ;       temp2_pa75c := 'octal : ' ;       strmove ( 11 , temp2_pa75c , 1 , temp1_pa75c , 45 ) ;       temp2_pa75c := Ditoctal ( heap2info.toh ) ;     { desc_temp2_75c := DintToOctal ( heap2info.toh ) ; }       strmove ( 11 , temp2_pa75c , 1 , temp1_pa75c , 55 ) ;       msg1write ( Msglu , temp1_pa75c ) ;  
     $SKIP_TEXT OFF$ 
 #    end ;                                              {M5 BG 22aug85} #     { allocate a dummmy buffer in the heap } { to turn around the EM82 problem }  !  NEW ( dummy_buf ) ;                             {M34 BG 25MAR87} !   GETHEAP2INFO ( heap2info ) ;    previous_toh := heap2info.toh ;   { reference for next NEW } 	  new_top_of_heap ; 	     for INET := 1 TO  NBOFNETWORKS do begin  { build all tables for network INET }            { INET loop applies down to end of phase 3.2.3 }      {----------------------------------------------------------}  { Phase 1:  construct  Network header table                }  {----------------------------------------------------------}        NEW ( NETWP ); {allocate network header space}        NetwPTRtbl [ INET ] := NETWP ; {set up link}        {Obtain network header info from XTBL: }       L := XTBLnetworkHeaderEntryLength ;       XTMGR( 1, INDEX, L, XTBL.WORDS, WriteReservedLU);        CHECKL ;        INDEX:= INDEX + L;     !     $skip_text on$                                 {M5 BG 22aug85} !       msg1write(Msglu,' TBLBUILD: network'); {Test Only}  
     $skip_text off$ 
    !      { for tracing the size of EMA objects }       {M5 BG 22aug85} !       if msglu <> 0 then         begin            GETHEAP2INFO ( heap2info ) ;            new_size := previous_toh - heap2info.toh ;  #          previous_toh := heap2info.toh ;   { reference for next NEW } #          temp2_pa75c := DITOA ( new_size ) ; { Dint to ascii }         { desc_temp2_75c := DintToDecimal ( new_size ) ;}            temp1_pa75c := ' TBLBUILD : network table size : ' ;           strmove ( 11 , temp2_pa75c , 1 , temp1_pa75c , 35 ) ;           msg1write ( Msglu , temp1_pa75c ) ; 
          new_top_of_heap ; 
"        end ;                                          {M5 BG22aug85} "      With  NETWP^ do begin          { Note: this context applies until end of "for INET" }      $page$  !  With  XTBL do begin  {unpack XTBL NetworkHeader into NetwTblrec} !   {}  "  {}  CardWriteLU:= NetworkHeaderEntry.CardWriteLUbyte + SessionBit; "   {}    {}  NbofActivePVC := NetworkHeaderEntry.NbofActivePVC;    {}  NbofSVCwadd := NetworkHeaderEntry.NbofSVCwadd;    {}  NbofPOOLsvc := NetworkHeaderEntry.NbofPOOLsvc;    {}  NbofPADsvc := NetworkHeaderEntry.NbofPADsvc;    {}   {}  DefaultPTW := NetworkHeaderEntry.DefaultPTW ;    {}    {}  DCE := NetworkHeaderEntry.CardParm.cardP ;    {}    {}  ExtdPktNb := NetworkHeaderEntry.ExtdPktNb;    {}  CardParm := NetworkHeaderEntry.CardParm;   {}  LocalAddr:= NetworkHeaderEntry.LocalAddr;    {}   {}  FirstPVC := NetworkHeaderEntry.VCinfo.FirstPVC;    {}  NbofPVC :=  NetworkHeaderEntry.VCinfo.NbofPVC;   {}  LastPVC := FirstPVC + NbofPVC -1; {-1 if no PVC }   {}  FirstSVCin := NetworkHeaderEntry.Vcinfo.FirstSVCin;   {}  NbofSVCin := NetworkHeaderEntry.VCinfo.NbofSVCin;    {}  LastSVCin := FirstSVCin + NbofSVCin -1; {-1 if no svcin}   {}  FirstSVC2w := NetworkHeaderEntry.VCinfo.FirstSVC2w;   {}  NbofSVC2w := NetworkHeaderEntry.VCinfo.NbofSVC2w;    {}  LastSVC2w := FirstSVC2w + NbofSVC2w -1; {-1 if no svc2w}   {}  FirstSVCout := NetworkHeaderEntry.VCinfo.FirstSVCout;   {}  NbofSVCout := NetworkHeaderEntry.VCinfo.NbofSVCout;  !  {}  LastSVCout := FirstSVCout + NbofSVCout -1; {-1 if no svcout} !   {}    {}  RestartRetryNb := NetworkHeaderEntry.RestartRetryNb;    {}  RestConfTO := NetworkHeaderEntry.RestConfTO*100;    {}                              { convert in 10 ms }    {}  CallRetryNb := NetworkHeaderEntry.CallRetryNb;    {}  CallConfTO := NetworkHeaderEntry.CallConfTO * 100;    {}  ClearRetryNb := NetworkHeaderEntry.ClearRetryNb;    {}  ClearConfTO := NetworkHeaderEntry.ClearConfTO * 100;    {}  ResetRetryNb := NetworkHeaderEntry.ResetRetryNb;    {}  ResetConfTO := NetworkHeaderEntry.ResetConfTO * 100;  "  {}                                                 {M2 BG 23apr85} "  {}  RestartDelayTO := NetworkHeaderEntry.RestartDelayTO ;  "  {}                                 { in 10 ms }   {M13 BG 22apr86} " "  {}  ResetDelayTO := NetworkHeaderEntry.ResetDelayTO ; { in 10 ms } " "  {}                                                {M13 BG 21may86} " "  {}  Timer_T3       := NetworkHeaderEntry.Timer_T3 ; { in minutes } "   {}  	  end {with XTBL}; 	   {other initializations of NETWP^ if needed }        State := ready ; {convenient initialization}  "  $skip_text on$                                     {M13 BG22apr86} "       PowerFailCounter := 0;   $skip_text off$        RecoveryCounter := 0 ;        MaxQlength :=  DefaultPTW.OutTHcl + NbOfNetworks                       + MAXQlengthFineTune; 	       Qlength:= 0; 	       LogAct  := 0; {activity ctr for XPLOG}        LOGclass := 0; {Tracing OFF}        {ReadWaitTO:= -1;}{PM 11/82} X25TOctr:= 0;  $page$ !  {***************************************************************} !!  { Phase 2: construct all VC tables for this network:            } !!  {***************************************************************} !       {--------------------------------------------------------}    {PHASE 2.1: allocate all VC tables and link them together}    {--------------------------------------------------------}       NEW ( VCP ); {always at least one VC per network}       FirstVC :=  VCP ;            for I := 2 to NbofPVC+NbofSVCin+NbofSVC2w+NbofSVCout        do begin       {}  PREVVCP := VCP;        {}  NEW ( VCP );        {}  {init of VC will be done at end of handshake read}        {}  PREVVCP^.NEXTVC := VCP {linkage}        end {for};            VCP^.NEXTVC := FIRSTVC ; {circular list}        {other init:} RRobinLastVC := VCP ; {init with last VC }                        {RRobin loop will thus start with First VC}         { for tracing the size of EMA objects }         {M5 BG 22aug85}   
  if msglu <> 0 then 
    begin        GETHEAP2INFO ( heap2info ) ;        new_size := previous_toh - heap2info.toh ;  !      previous_toh := heap2info.toh ;   { reference for next NEW } !      temp2_pa75c := DITOA ( new_size ) ;      { desc_temp2_75c := DintToDecimal ( new_size ) ; }       temp1_pa75c := ' TBLBUILD : VCTBLs size     : ' ;       strmove ( 11 , temp2_pa75c , 1 , temp1_pa75c , 35 ) ;       temp2_pa75c := 'for total nb of VCs : ' ;       strmove ( 22 , temp2_pa75c , 1 , temp1_pa75c , 45 ) ;         cnum ( NbofPVC+NbofSVCin+NbofSVC2w+NbofSVCout , nbconv ) ;        strmove ( 6 , nbconv , 1 , temp1_pa75c , 70 ) ;       msg1write ( Msglu , temp1_pa75c ) ;       new_top_of_heap ;       end ;                                        {M5 BG 22aug85}        {---------------------------------------------------}   {PHASE 2.2: set VC number and type in each VC table:}   {---------------------------------------------------}     
      VCP := FIRSTVC; 
      {PVC loop:}       for I:= FirstPVC to LastPVC  do begin        {}  with VCP^ do begin       {} $skip_text on$                   {M5 BG 22aug85}       {}      msg1write(Msglu,' VCTBL: PVC'); {Test only}        {} $skip_text off$       {}      VCtype := pvc ;  
      {}      VCnb   := I; 
       {}      Setup_ema_user := false;        {}      AssociatedEQT := nil ;        {}              {will stay nil if PVC not used by EQT} 
      {}      VCP := NextVC 
       {}  end ; {with}        {} 
      end ; {end for} 
          { for tracing the new EMA objects }       {M5 BG 22aug85}        if msglu <> 0 then         begin            temp1_pa75c :=                 ' TBLBUILD : total nb of PVC            : ' ;            cnum ( LastPVC - FirstPVC + 1 , nbconv ) ;           strmove ( 6 , nbconv , 1 , temp1_pa75c , 41 ) ;           msg1write ( Msglu , temp1_pa75c ) ;         end ;                                 {M5 BG 22aug85}            {SVCin loop: }        for I := FirstSVCin to LastSVCin  do begin        {}  with VCP^ do begin        {} $skip_text on$                      {M5 BG 22aug85}        {}      msg1write(Msglu,' VCTBL: svc in'); {Test only}        {} $skip_text off$        {}      VCtype := svcin;        {}      VCnb := I;        {}      Setup_ema_user:=false; 
      {}      VCP := NextVC 
      {} end ; {with} 
       {}        end ; {end for SVCin loop}           { for tracing the new EMA objects }     {M5 BG 22aug85}        if msglu <> 0 then         begin            temp1_pa75c :=                 ' TBLBUILD : total nb of SVCin          : ' ;            cnum ( LastSVCin - FirstSVCin + 1 , nbconv ) ;           strmove ( 6 , nbconv , 1 , temp1_pa75c , 41 ) ;           msg1write ( Msglu , temp1_pa75c ) ;         end ;                                 {M5 BG 22aug85}            {Set up ptr on first SVCout or SVC2W (if any): }       if NbofSVCout + NbofSVC2w > 0          then FirstVCforCall := VCP           else FirstVCforCall := nil {no svc out or 2w} ;    If DCE    then begin  {store VC numbers in ascending order in each group}   
     {SVCout loop: } 
        for I := FirstSVCout to LastSVCout do begin          {}  with VCP^ do begin         {} $skip_text on$                 {M5 BG 22aug85}         {}      msg1write(Msglu,' VCTBL: svc out (DCE)');  
        {} $skip_text off$ 
         {}      VCtype := svcout ;         {}      VCnb   := I ;          {}      Setup_ema_user:=false;         {}      VCP := NextVC          {}  end ; {with}         end ; {end svcout loop}          !        { for tracing the new EMA objects }        {M5 BG 22aug85} ! 
        if msglu <> 0 then 
          begin  
            temp1_pa75c := 
                   ' TBLBUILD : total nb of SVCout ( DCE ) :' ;              cnum ( LastSVCout - FirstSVCout + 1 , nbconv ) ;             strmove ( 6 , nbconv , 1 , temp1_pa75c , 41 ) ;             msg1write ( Msglu , temp1_pa75c ) ;           end ;                             {M5 BG 22aug85}           {SVC 2w loop:   }          for I := FirstSVC2w to LastSVC2w  do begin         {} with VCP^ do begin         {} $skip_text on$                 {M5 BG 22aug85}         {}      msg1write(Msglu,' VCTBL: svc 2w (DCE)' );  
        {} $skip_text off$ 
        {}      VCtype := svc2w ;         {}      VCnb   := I ;          {}      Setup_ema_user:=false;         {}      VCP := NextVC         {} end ; {with}          {}          end ; {end SVC2w loop}             { for tracing the new EMA objects } {M5 BG 22aug85}  
        if msglu <> 0 then 
          begin  
            temp1_pa75c := 
                   ' TBLBUILD : total nb of SVC2w  ( DCE ) :' ;              cnum ( LastSVC2w - FirstSVC2w + 1 , nbconv ) ;             strmove ( 6 , nbconv , 1 , temp1_pa75c , 41 ) ;             msg1write ( Msglu , temp1_pa75c ) ;            end ;                                {M5 BG 22aug85}   end    else begin  !       { DTE: store VC numbers in decreasing order in each group } !        {SVC out loop:}          for I := LastSVCout downto FirstSVCout  do begin           {} With VCP^ do begin          {} $skip_text on$                {M5 BG 22aug85}          {}      msg1Write(msglu,' VCTBL: svcout (DTE)'); 
         {} $skip_text off$ 
         {}      VCtype:= svcout; 
         {}      VCnb := I; 
         {}      Setup_ema_user:=false;          {}      VCP := NextVC;           {} end ; {with}          {}           end ; {end SVCout loop}               { for tracing the new EMA objects }   {M5 BG 22aug85} 
         if msglu <> 0 then 
            begin 
             temp1_pa75c := 
                   ' TBLBUILD : total nb of SVCout ( DTE ) :' ;              cnum ( LastSVCout - FirstSVCout + 1 , nbconv ) ;               strmove ( 6 , nbconv , 1 , temp1_pa75c , 41 ) ;               msg1write ( Msglu , temp1_pa75c ) ;             end ;                               {M5 BG 22aug85}      
       {SVC2w loop:} 
         for I:= LastSVC2w  downto FirstSVC2w  do begin           {} with VCP^ do begin           {} $skip_text on$                 {M5 BG 22aug85}           {}      msg1write(Msglu,' VCTBL: svc 2w (DTE)' ); 
         {} $skip_text off$ 
         {}      VCtype  := svc2w ;          {}      VCnb    := I ;          {}      Setup_ema_user:=false;           {}      VCP := NextVC          {}  end ; {with}          {}          end ; {end SVC2w loop}               { for tracing the new EMA objects } {M5 BG 22aug85} 
         if msglu <> 0 then 
            begin 
             temp1_pa75c := 
                   ' TBLBUILD : total nb of SVC2w  ( DTE ) :' ;              cnum ( LastSVC2w - FirstSVC2w + 1 , nbconv ) ;               strmove ( 6 , nbconv , 1 , temp1_pa75c , 41 ) ;               msg1write ( Msglu , temp1_pa75c ) ;             end ;                             {M5 BG 22aug85}    end;      
  { END OF PHASE 2 } 
     $page$   {***********************************************************}   { PHASE 3: Construct all EQT tables                         }   {***********************************************************}       {-----------------------------------------------------------}   { PHASE 3.1: allocate all EQT tables and link them together }   {-----------------------------------------------------------}        { Note: EQT list is constructed from the last to the first!}    {       Last EQT points to NIL.                            }       FirstEQT := NIL ; {ptr on most recently linked rec}                                      {---------------------------}      For I := 1 to NbofPADsvc do begin{    PAD EQT tables         }        NEW ( EQTP, PADeqtType);       {---------------------------}      With EQTP^ do begin  
      NextEQT := FirstEQT; 
       NetwResp := NETWP;  
    end {with EQTP}; 
    FirstEQT := EQTP; {This EQT becomes the new FirstEQT}    end { PAD SVC loop};      "  { for tracing the size of EMA objects }            {M5 BG 22aug85} " 
  if msglu <> 0 then 
    begin        GETHEAP2INFO ( heap2info ) ;        new_size := previous_toh - heap2info.toh ;  !      previous_toh := heap2info.toh ;   { reference for next NEW } !      temp2_pa75c := DITOA ( new_size ) ;      { desc_temp2_75c := DintToDecimal ( new_size ) ; }        temp1_pa75c := ' TBLBUILD : PAD EQT tabLe size : ' ;       strmove ( 11 , temp2_pa75c , 1 , temp1_pa75c , 35 ) ;       temp2_pa75c := 'for total nb of PAD : ' ;       strmove ( 22 , temp2_pa75c , 1 , temp1_pa75c , 45 ) ;        cnum ( NbofPADsvc , nbconv ) ;       strmove ( 6 , nbconv , 1 , temp1_pa75c , 70 ) ;       msg1write ( Msglu , temp1_pa75c ) ;       new_top_of_heap ;  "    end ;                                            {M5 BG 22aug85} "      For I := 1 to NbofSVCwadd + NbofPOOLsvc                                      {---------------------------}      do begin                         { SVCw/add & POOL EQT tables}                                       {---------------------------}        NEW ( EQTP, SVCeqtType );       With EQTP^ do begin          NextEQT := FirstEQT;          SendLF := false; {always false for non PAD EQTs}         SendCRLF := false ;    { "" }      {M77 BG 25OCT89}         remaininglength := 0 ; { "" }      {M75 BG 26OCT89}  
        NetwResp := NETWP; 
     end {with EQTP}; 
      FirstEQT := EQTP; {this EQT becomes the new FirstEQT}   end {for} ;         { for tracing the size of EMA objects }        {M5 BG 22aug85}   
  if msglu <> 0 then 
    begin        GETHEAP2INFO ( heap2info ) ;        new_size := previous_toh - heap2info.toh ;         previous_toh := heap2info.toh ; { reference for next NEW }        temp2_pa75c := DITOA ( new_size ) ;      { desc_temp2_75c := DintToDecimal ( new_size ) ; }         temp1_pa75c := ' TBLBUILD : SVCwadd/POOL EQT tbl size :' ;         strmove ( 8 , temp2_pa75c , 1 , temp1_pa75c , 41 ) ;        temp2_pa75c := 'for total nb of SVC :' ;       strmove ( 22 , temp2_pa75c , 1 , temp1_pa75c , 45 ) ;       cnum ( NbofSVCwadd + NbofPOOLsvc , nbconv ) ;       strmove ( 6 , nbconv , 1 , temp1_pa75c , 70 ) ;       msg1write ( Msglu , temp1_pa75c ) ;       new_top_of_heap ;       end ;                                        {M5 BG 22aug85}        For I := 1 to NbofactivePVC                                      {---------------------------}      do begin                         {       PVC EQT tables      }                                       {---------------------------}        NEW ( EQTP, PVCeqtType );           {dummy parm : must not be SVCeqttype or PADeqttype}       With EQTP^ do begin          NextEQT := FirstEQT;          SendLF := false; {always false for non PAD EQTs}         SendCRLF := false ;    { "" }      {M77 BG 25OCT89}         remaininglength := 0 ; { "" }      {M75 BG 26OCT89}  
        NetwResp := NETWP; 
     end {with EQTP}; 
      FirstEQT := EQTP; {this EQT becomes the new FirstEQT}   end {for} ;         { for tracing the size of EMA objects }        {M5 BG 22aug85}   
  if msglu <> 0 then 
    begin        GETHEAP2INFO ( heap2info ) ;        new_size := previous_toh - heap2info.toh ;         previous_toh := heap2info.toh ; { reference for next NEW }        temp1_pa75c := ' TBLBUILD : PVC EQT tabLe size :' ;       temp2_pa75c := DITOA ( new_size ) ;      { desc_temp2_75c := DintToDecimal ( new_size ) ; }       strmove ( 10 , temp2_pa75c , 1 , temp1_pa75c , 35 ) ;        temp2_pa75c := 'for total nb of PVC :' ;       strmove ( 22 , temp2_pa75c , 1 , temp1_pa75c , 45 ) ;       cnum ( NbofactivePVC , nbconv ) ;       strmove ( 6 , nbconv , 1 , temp1_pa75c , 70 ) ;       msg1write ( Msglu , temp1_pa75c ) ;       new_top_of_heap ;     end ;                                   {M5 BG 22aug85}       {-----------------------------------------------------------}   {PHASE 3.2: initialize all EQT tables (& build EMA buffers) }   {sub-phases:   1. PVC EQTs                                  }   {              2. SVC EQTs (with address)                   }   {              3. POOL SVC EQTs (without address)           }   {              4. PAD (SVC) EQTs                            }   {-----------------------------------------------------------}            EQTP := FirstEQT ;    $page$    {------------------------------------------}    { Phase 3.2.1: PVCEQT loop:                }    {------------------------------------------}      
  L := XTBLPVCENTRYLENGTH; 
      for I := 1 to Nbofactivepvc    do begin       {obtain info from XTBL: }      XTMGR ( 1,INDEX,L,XTBL.WORDS, WriteReservedLU );       CHECKL ; {stops if any error}      INDEX := INDEX + L ;       msg1write ( MsgLu , ' TBLBUILD : EQTTBL : pvc') ;           {transfer from XTBL.PVCEntry into EQTP^:}      with EQTP^ , XTBL.PVCENTRY      do begin      {}      {}  EQTTYPE := PVCEQTTYPE;       {}  WriteLUnb := WriteLUnumber;      {}  WRITEEQTADD :=WRITEEQTADDRESS;       {}  READEQTADD := READEQTADDRESS;       {}  EffectivePTW := PTW ;      {}       {}  Facilities.T := 0 ;{CLEAN UP}       {}  Facilities.Dbit := PVCFacilities.Dbit ;      {}      {}  Nextbuffertoread := nil;      {}  EMAcounter := 0;      {}  sendrr := false;      {}  IVC := PVCNB ;       {}  VCSEARCH ( NETWP,IVC,VCP );      {}      if VCP = NIL      {}      then begin             { "UNKNOWN PVC" }       {}         XEXEC2(2,1{lu},ERRMSG4,-ErrMsgLength);       {}         STOP (EXEC6)      {}      end;      {}      {}  VCP^.X25P := P4; { permanent state for a PVC }       {}  { D1 clean up will be done at end of handshake read }      {}  { link together eqt and vc tables: }      {}    associatedVC := VCP;       {}    VCP^.associatedEQT := EQTP;      {}  {Build EMA buffers list}  	     {}  CALL_NEW; 	     {}       {}  Nextfreebuffer := EMAPTR;       {}  FOR J:=2 TO EffectivePTW.Inwdwsize DO BEGIN       {}     Previous := EMAPTR ;       {}     CALL_NEW ;       {}     Previous^.Next := EMAPTR ;  
     {}  END ; {FOR} 
      {}  Lastbufferfilled := EMAPTR ;     {M10 BG 07feb86}      {}  EMAPTR^.Next := Nextfreebuffer ; {Circular list}      {}       {}  EQTP := NEXTEQT ; {next EQT for loop}      {}       {}  { for tracing the size of EMA objects }       {}  if msglu <> 0 then      {M5 BG 22AUG85}       {}    begin      {}      GETHEAP2INFO ( heap2info ) ;      {}      new_size := previous_toh - heap2info.toh ;       {}      previous_toh := heap2info.toh ;       {}      temp2_pa75c := DITOA ( new_size ) ;      {}    { desc_temp2_75c := DintToDecimal ( new_size ) ; }      {}      temp1_pa75c := ' TBLBUILD : PVC buffer size :' ;       {}      strmove ( 8 , temp2_pa75c , 1 ,      {}                    temp1_pa75c , 35 ) ;      {}      temp2_pa75c := 'Effective inc. window :' ;      {}      strmove ( 22 , temp2_pa75c , 1 ,       {}                     temp1_pa75c , 45 ) ;       {}      cnum ( EffectivePTW.inwdwsize , nbconv );       {}      strmove ( 6 , nbconv , 1 , temp1_pa75c , 70 ) ;       {}      msg1write ( Msglu , temp1_pa75c ) ;       {}    end ;                             {M5 BG 22aug85}      {} 
     end {with EQTP^} 
  end {for (pvc loop) } ;    $page$   {---------------------------------------------}   { Phase 3.2.2: SVC EQT WITH ADD loop          }   {---------------------------------------------}      
  if nbofsvcwadd = 0 
 
  then  firstsvceqt := NIL 
  else  begin    {}   {}  {special ptr in network table:}  
  {}  FirstSVCeqt := EQTP; 
   {}   {}  {loop over SVC EQT with Add:}    {}  L := XTBLsvcEntryLength;    {}   {}  for I := 1 to NbofSVCwadd    {}  do begin    {}   {}    {info from XTBL:}   {}    XTMGR ( 1, INDEX, L, XTBL.WORDS, WriteReservedLU );    {}    CHECKL; {stops if error}   {}    INDEX:=INDEX+L;    {} 
  {}   $skip_text on$ 
  {}    msg1write ( MsgLu ,' TBLBUILD : EQTTBL : svc w add');    {}   $skip_text off$    {}   {}    {transfer from XTBL.SVCentry into EQTP^:}   {}    with EQTP^ , XTBL.SVCENTRY , EQText    {}    do begin    {}    {}    {}    {}  EQTTYPE := svceqttype;    {}    {}   {}    {}  WriteLUnb := WriteLUnumber;   {}    {}  WriteEQTadd := WriteEQTaddress;   {}    {}  ReadEQTadd := ReadEQTaddress;    {}    {}  Facilities := SVCfacilities;    {}    {}  desiredPTW := PTW;    {}    {}  remote     := SVCaddr;    {}    {}  CUGnb      := SVCCUGnb ;    {}    {}  CUDout     := SVCCUD ;    {}    {}  CUDin      := zeroCUD;   {}    {}  Downflag   := false; {unused for SVC w/add}   {}    {}  associatedVC := NIL;{not yet any}   {}    {}  { Convenient for CALL_NEW }   {}    {}  IF PTW.Inpktsize < DefaultPTW.Inpktsize    {}    {}  THEN EffectivePTW.Inpktsize :=    {}    {}                  DefaultPTW.Inpktsize   {}    {}  ELSE EffectivePTW.Inpktsize:=PTW.Inpktsize;    {}    {}  Nextbuffertoread := nil;    {}    {}  EMAcounter := 0; 
  {}    {}  sendrr:= false; 
   {}    {}    {}    {} { Build EMA buffers list. }   {}    {} { 7 buffers per SVC, whichever window size } 
  {}    {}  CALL_NEW; 
  {}    {}  Nextfreebuffer := EMAPTR;    {}    {}  FOR J:=2 TO 7 DO BEGIN    {}    {}     Previous:=EMAPTR;    {}    {}     CALL_NEW;    {}    {}     Previous^.Next:=EMAPTR; 
  {}    {}  END;{FOR} 
   {}    {}   {}    {}  Lastbufferfilled := EMAPTR ; {M10 BG 07feb86}   {}    {}  EMAPTR^.Next := Nextfreebuffer;    {}    {}                   { circular list }   {}    {}  EQTP := NextEqt ; {next eqt for loop}    {}    {}    {}    {}   {}    {}  { for tracing the size of EMA objects }   {}    {}  if msglu <> 0 then      {M5 BG 22AUG85} 	  {}    {}    begin 	   {}    {}      GETHEAP2INFO ( heap2info ) ;    {}    {}      new_size := previous_toh - heap2info.toh ;   {}    {}      previous_toh := heap2info.toh ;    {}    {}      temp1_pa75c :=    {}    {}            ' TBLBUILD : SVCwadd buffer size :';   {}    {}      temp2_pa75c := DITOA ( new_size ) ;   {}    {} { desc_temp2_75c := DintToDecimal ( new_size ) ; }   {}    {}      strmove( 10 , temp2_pa75c , 1 ,   {}    {}                    temp1_pa75c , 35 );    {}    {}      temp2_pa75c :=   {}    {}            'Effective inc. pkt size :' ;   {}    {}      strmove( 28 , temp2_pa75c , 1 ,   {}    {}                    temp1_pa75c , 45 );     {}    {}      cnum ( PKTsizetable [ EffectivePTW.inpktsize ] ,      {}    {}                                            nbconv ) ;    {}    {}      strmove( 6 , nbconv , 1 , temp1_pa75c , 70 );   {}    {}      msg1write ( Msglu , temp1_pa75c ) ;     {}    {}    end ;                              {M5 BG 22aug85}     {}    {}  	  {}    end {with} 	   {} end {for} 
  end; { else begin } 
 $page$   {---------------------------}   {Phase 3.2.3: POOL EQT loop }   {---------------------------}      
  If NbofPOOLsvc = 0 
 
  then FirstPoolEqt := NIL 
   else begin    {}  FirstPoolEqt := EQTP ;    {} !  {}  {obtain POOL SVC header and store into fixed variable POOLH:} !   {}    L := XTBLPoolSvcHeaderEntryLength;    {}    XTMGR(1,INDEX,L,XTBL.WORDS, WriteReservedLU );    {}    CHECKL ;   {}    INDEX := INDEX+L;    {}  #  {}    PoolDefaultFacilities:=XTBL.PoolSvcHeaderEntry.PoolFacilities; #   {}    PoolDefaultPTW := XTBL.PoolSVCheaderEntry.PTW;     {}    PoolDefaultCUG := XTBL.PoolSvcHeaderEntry.PoolCUGnumber;     {}   {}  {Loop over POOL EQTs: }   {}    L := XTBLpoolSvcEntryLength ;    {}   {}  for I := 1 to NbofPoolSVC    {}  do begin    {}    {}     XTMGR (1, INDEX, L, XTBL.WORDS, WriteReservedLU);   {}     CHECKL ;   {}      INDEX := INDEX + L;    {}      $skip_text on$  #  {}        msg1write(MsgLu,' TBLBUILD : EQTTBL : pool') ; {Test only} #  {}      $skip_text off$    {}   {}      {transfer from XTBL.PoolSVCentry into EQTP^ : }    {}      with EQTP^, XTBL.PoolSvcEntry , EQText, Netwp^ do begin     {}      {}  EQTTYPE := pooleqttype ;    {}      {}   {}      {}  WriteLUnb       := WriteLUnumber;    {}      {}  writeEQTadd     := WriteEQTaddress ;   {}      {}  ReadEQTadd      := ReadEQTaddress ;    {}      {}    {}      {}  Facilities      := PoolDefaultFacilities ;    {}      {}  DesiredPTW      := PoolDefaultPTW;    {}      {}  Remote          := DummyNetwAdd;    {}      {}  CUGnb           := PoolDefaultCUG;   {}      {}  CUDout          := Default_CUD;   {}      {}  CUDin           := ZeroCUD;   {}      {}  Downflag        := False;    {}      {}  associatedVC    := NIL ;   {}      {}  { Convenient for CALL_NEW }    {}      {}  IF DesiredPTW.Inpktsize < DefaultPTW.Inpktsize   {}      {}  THEN EffectivePTW.Inpktsize:=DefaultPTW.Inpktsize     {}      {}  ELSE EffectivePTW.Inpktsize:=DesiredPTW.Inpktsize;     {}      {}  Nextbuffertoread := nil;   {}      {}  EMAcounter      := 0;    {}      {}  sendrr:=false;   {}      {} { Build EMA buffers list }   {}      {} { 7 buffers per SVC, whichever window size }   {}      {}  CALL_NEW;    {}      {}  Nextfreebuffer := EMAPTR ;    {}      {}  FOR J:=2 TO 7 DO BEGIN   {}      {}     Previous := EMAPTR ; 
  {}      {}     CALL_NEW ; 
  {}      {}     Previous^.Next:=EMAPTR ;   {}      {}  END ; {FOR}   {}      {}  Lastbufferfilled := EMAPTR ;     {M10 BG 07feb86}     {}      {}  EMAPTR^.Next:=Nextfreebuffer ;   { circular list }    {}      {} EQTP := NextEQT ; {next eqt for loop }    {}      {}  "  {}      {}  { for tracing the size of EMA objects }{M5 BG 22aug85} "   {}      {}  if msglu <> 0 then 
  {}      {}    begin 
   {}      {}      GETHEAP2INFO ( heap2info ) ;    {}      {}      new_size := previous_toh - heap2info.toh ;   {}      {}      previous_toh := heap2info.toh ; "  {}      {}      temp1_pa75c := ' TBLBUILD : POOLSVC buffer size :'; "  {}      {}      temp2_pa75c := DITOA ( new_size ) ;  !  {}      {}    { desc_temp2_75c := DintToDecimal ( new_size ) ; } !"  {}      {}      strmove( 10 , temp2_pa75c , 1 , temp1_pa75c , 35 ); "   {}      {}      temp2_pa75c := 'Effective inc. pkt size :' ; "  {}      {}      strmove( 22 , temp2_pa75c , 1 , temp1_pa75c , 45 ); " #  {}      {}      cnum (PKTsizetable[EffectivePTW.inpktsize], nbconv); #   {}      {}      strmove ( 6 , nbconv , 1 , temp1_pa75c , 70 ) ;    {}      {}      msg1write ( Msglu , temp1_pa75c ) ;  !  {}      {}    end ;                              {M5 BG 22aug85} !   {}      {}  
  {}      end {with EQTP^} 
   {}    {}  end {for (pool eqt loop) }   end {else};  $page$    {----------------------------------}    {Phase 3.2.4: PAD EQT loop         }    {----------------------------------}     	  If NbofPADsvc = 0 	  then FirstPADeqt := NIL    else begin   {there is at least one PAD eqt}    {}  
  {}  FirstPADeqt := EQTP; 
  {}  {PAD Header from XTBL into PADH:}    {}      L := XTBLPADsvcHeaderEntryLength ;    {}      XTMGR (1, INDEX, L, XTBL.WORDS, WriteReservedLU);   	  {}      CHECKL ; 	  {}      INDEX := INDEX + L;    {}      PADH := XTBL.PADSVCheaderEntry ;    {}  {Loop over PAD EQTs: }    {}      L := XTBLPadSvcEntryLength ;    {}  For I := 1 to NbofPADSvc    {}  do begin   {}      XTMGR (1, INDEX, L, XTBL.WORDS, WriteReservedLU);  	  {}      CHECKL ; 	  {}      INDEX := INDEX + L;    {}      $skip_text on$  #  {}      msg1write ( MsgLu,' TBLBUILD : EQTTBL : Pad' ) ; {test only} #  {}      $skip_text off$   {}      {transfer from PADH and XTBL.PADsvcEntry into EQTP^:}    {}      With EQTP^ , XTBL.PADsvcEntry , EQText, Netwp^ do begin     {}      {}  EQTTYPE := padeqttype;    {}      {}   {}      {}  AssociatedVC     := NIL ;    {}      {}  WriteLUnb    := WriteLUnumber;   {}      {}  WriteEQTadd  := ReadWriteEQTaddress ;   {}      {}  ReadEQTadd   := ReadWriteEQTaddress ;    {}      {}   {}      {}  Facilities  :=  PADH.PADfacilities;    {}      {}  sendrr := false;   {}      {}  SendLF := false ;   {}      {}  SendCRLF := false ;              {M77 BG 25OCT89}   {}      {}  remaininglength := 0 ;           {M75 BG 26OCT89}    {}      {}  DesiredPTW  :=  PADH.PTW ;   {}      {}  Remote           := DummyNetwAdd;   {}      {}  CUGnb            := 0 ;    {}      {}  CUDin            := ZeroCUD;    {}      {}  Nextbuffertoread := nil;    {}      {}  EMAcounter := 0;    {}      {}  {initialise PDSUP area:}   {}      {}    ProcState := S0 ;   {}      {}    ProcStep := 0 ;   {}      {}    CircuitStateUP   := false ;   {}      {}    PADmsgExpected   := false ;  !  {}      {}    TermMsgExpected  := false ;       {M77 BG 29JUN89} ! !  {}      {}    Send_DC1         := false ;       {M77 BG 17OCT89} !  {}      {}    ParmChangeMask.w := 0 ;   {}      {}    PDSreq := 0 ;   {}      {}    PDSreqParm.w := 0 ;   {}      {}    NextPDSreq := nil ;    {}      {}    Terminal_Status.w := 0 ;         {M77 BG 29JUN89}    {}      {}  { Convenient for CALL_NEW }    {}      {}  IF DesiredPTW.Inpktsize < DefaultPTW.Inpktsize    {}      {}    THEN EffectivePTW.Inpktsize:=DefaultPTW.Inpktsize   !  {}      {}    ELSE EffectivePTW.Inpktsize:=DesiredPTW.Inpktsize; !  {}      {} { Build EMA buffers list }   {}      {} { 7 buffers per SVC, whichever window size }   {}      {}  CALL_NEW;   {}      {}  Nextfreebuffer := EMAPTR;    {}      {}  FOR J:=2 TO 7 DO BEGIN    {}      {}     Previous:=EMAPTR;  
  {}      {}     CALL_NEW; 
   {}      {}     Previous^.Next:=EMAPTR;   {}      {}  END;{FOR}   {}      {}  Lastbufferfilled := EMAPTR ;     {M10 BG 07feb86}     {}      {}  EMAPTR^.Next:=Nextfreebuffer;    { circular list }    {}      {}  EQTP := Nexteqt ; {next eqt for loop}    {}      {}  "  {}      {}  { for tracing the size of EMA objects }{M5 BG 22aug85} "   {}      {}  if msglu <> 0 then 
  {}      {}    begin 
   {}      {}      GETHEAP2INFO ( heap2info ) ;    {}      {}      new_size := previous_toh - heap2info.toh ;   {}      {}      previous_toh := heap2info.toh ;   {}      {}      temp2_pa75c := DITOA ( new_size ) ;  !  {}      {}    { desc_temp2_75c := DintToDecimal ( new_size ) ; } ! "  {}      {}      temp1_pa75c := ' TBLBUILD : PADSVC buffer size :'; " "  {}      {}      strmove( 8 , temp2_pa75c , 1 , temp1_pa75c , 35 ); "   {}      {}      temp2_pa75c := 'Effective inc. pkt size :' ; "  {}      {}      strmove( 29 , temp2_pa75c , 1 , temp1_pa75c , 45 ); "#  {}      {}      cnum ( PKTsizetable[EffectivePTW.inpktsize], nbconv); #   {}      {}      strmove ( 6 , nbconv , 1 , temp1_pa75c , 70 ) ;    {}      {}      msg1write ( Msglu , temp1_pa75c ) ;  !  {}      {}    end ;                              {M5 BG 22aug85} !   {}      {}  
  {}      end {with} 
  {}  end {for (Pad svc eqt loop) }    end {else}     	  end {with NETWP^} 	 	 end {INET loop} ; 	     { for tracing the total EMA size in use }     {M5 22AUG85} 	 if msglu <> 0 then 	    begin      GETHEAP2INFO ( heap2info ) ;       new_size := heap2info.inittoh - heap2info.toh ;       temp2_pa75c := DITOA ( new_size ) ; { Dint to ascii }     { desc_temp2_75c := DintToDecimal ( new_size ) ;}       temp1_pa75c := ' TBLBUILD : total EMA size in use : ' ;       strmove ( 11 , temp2_pa75c , 1 , temp1_pa75c , 37 ) ;       msg1write ( Msglu , temp1_pa75c ) ;      temp1_pa75c := ' ' ;       msg1write ( Msglu , temp1_pa75c ) ;    end ;                                       {M5 22AUG85}      end {TBLBUILD} ;  .  