# {********************************************************************} #  $PASCAL ',4,3 91751-1X024 REV.5020 <900219.1423>' # {********************************************************************} ## {                                                                    } ## {    FILE:   XNETM.PAS                                               } ## {    SOURCE: 91751-18024                                             } ## {    RELOC.: 91751-1X024                                             } ## {                                                                    } ## {  ***************************************************************   } ## {  * (C) COPYRIGHT HEWLETT-PACKARD COMPANY 1982.  ALL RIGHTS     *   } ## {  * RESERVED.  NO PART OF THIS PROGRAM MAY BE PHOTOCOPIED,      *   } ## {  * REPRODUCED OR TRANSLATED TO ANOTHER PROGRAM LANGUAGE WITHOUT*   } ## {  * THE PRIOR WRITTEN CONSENT OF HEWLETT-PACKARD COMPANY.       *   } ## {  ***************************************************************   } ## {                                                                    } ## {--------------------------------------------------------------------} ## {                                                                    } ## {  Contains the following procedures and functions :                 } ## {  - MSG1WRITE                                                       } ## {  - MSGWRITE                                                        } ## {  - CNUM                                                            } ## {  - XMSGWR                                                          } ## {  - INGNRES                                                         } ## {  - EQTCLEAR                                                        } ## {  - FLUSH_MESSAGE                                                   } ## {  - LINKDOWN                                                        } ## {  - LINKUP                                                          } ## {  - ESTABLISHCIRCUIT                                                } ## { (- VCSEARCH )                                                      } ## {  - P1SETUP                                                         } ## {  - D1CLEANUP                                                       } ## {  - D1SETUP                                                         } ## { (- SETUP_EMA_STORAGE )                                             } ## {  - TIMER_TESTS : - TIMEREXCEEDED                                   } ## {                                                                    } ## {  XNET MAIN BODY :                                                  } ## {    phase 1 - verify scheduling parameters                          } ## {    phase 2 - set SESSIONBIT according to system used               } ## {    phase 3 - set up global variables                               } ## {    phase 4 - build XNET internal tables and buffers                } ## {    phase 5 - set up for general restart over all networks          } ## {    phase 6 - central processing XNET MAIN LOOP                     } ## {                                                                    } ## {--------------------------------------------------------------------} # $page$ # {--------------------------------------------------------------------} ## {                                                                    } ## { HISTORY :                                                          } ## {                                                                    } ## { Original    : 2201                                                 } ## { Change #1   : 2226                                                 } ## {   .support of RTE-A1                                               } ## { Change #2   : 2326                                                 } ## {   .support of RTE-A                                                } ## { Change #3   : 2401                                                 } ## {   .flow control enhancements                                       } ## {   .user access to Q-bit data packets                               } ## {   .user access to Call User Data field                             } ## {   .no automatic pool vc deallocation                               } ## { Change #4   : 2440                                                 } ## {   .PASCAL rev2440 support                                          } ## { Change #5   : 5.0         (BG)                                     } ## {   .Add Heap Initialization before Heap size testing. (M1)          } ## {   .Add timer Restart delay  (M2)                                   } ## {   .Add timer Reset delay  (M13)                                    } ## {   .Move up loading of segment XSEG4 at beginning of phase 5. (M13) } ## {   .Add a call to detach XNET from session. (M13)                   } ## {   .Move procedure XSUSP to module XSEG3.PAS. (M30)                 } ## {   .Add sending of CLEAR after RESET retry limit exceeded.  (M39)   } ## {   .Add a call to P1SETUP after CLEAR retry limit exceeded. (M39)   } ## { Change #6   : 5.2         (BG)                                     } ## {   .Correct restart retry counting.  (M66)                          } ## {   .Correct procedure FLUSH_MESSAGE for not allowing the setting    } ## {    of FLUSH_DATA when there is no message in progress. (M67)       } ## {   .Move procedure VCSEARCH to XSEG3 and XSEG4 (duplicated)         } ## {    Move procedure SETUP_EMA_STORAGE to XSEG4. To save code space.  } ## {                                                            (M80)   } ## {                                                                    } ## {********************************************************************} #     
 $STANDARD_LEVEL 'HP1000'$ 
  $RANGE OFF$ 	 $HEAP_DISPOSE OFF$ 	  $CDS   OFF$  $ HEAP 2 $   $RECURSIVE OFF$       PROGRAM  XNET ;     {path directory must be provided in the installation procedure}  $TITLE 'X.25/1000  XNET main program'$ $SUBTITLE 'X.25/1000 Globals  XTBLG', PAGE$  $INCLUDE 'XTBLG.PASI'$ $SUBTITLE 'X.25/1000 Globals  XTBLV', PAGE$  $INCLUDE 'XTBLV.PASI'$ $SUBTITLE 'XNET  Globals  XNETG', PAGE$  $INCLUDE 'XNETG.PASI'$      $page$   {-----------------------------------------------------}   { RTE and PASCAL utility subroutines:                 }   {-----------------------------------------------------}   $HEAPPARMS OFF$       procedure CNUMD (n:word; var Nbconv: pa6c);   external; {RTE positive binary to ASCII conversion}      procedure RMPAR $alias 'Pas.NumericParms' $  (var pa : PA5W );   external;      procedure PRTN (var pa: PA5W);   external;       procedure STOP $alias 'EXEC' {PROGRAM COMPLETION}$ (icode:word);    external;      $skip_text on$                                {M30 BG 16FEB87}  procedure SUSPEND $alias 'EXEC'$  (icode: word);   external;   $skip_text off$     # procedure  XEXEC2 $alias 'EXEC' {direct write}$ {special for messages} #   (icode, icnwd: word; ibuf: XMSGtype; ilen: word );   external;     " Function  XEXEC18 $alias 'EXEC'{class write}$ {special for messages} "    (icode,icnwd: word; ibuf: XMSGtype; ilen,ip1,ip2,iclass: word)    : word {Reg A only} ;   external;     # procedure EXEC2 $ alias 'EXEC'  {write} $ {special for internal trace} #  (icode:WORD; icnwd:WORD; ibuf: pa75c; ilen:WORD);   external;     ! procedure INITIALIZE_HEAP  $alias 'Pas.InitialHeap2'$ ; external ; !!                                                    {M1 BG 09AUG85} !     $HEAPPARMS ON$   procedure GETHEAP2INFO  $alias 'Pas.GetMemInfo2'$    ( var heap2info: heap2infotype);   external;   $HEAPPARMS OFF$      procedure WRDIRECT $ alias 'XLUEX'{direct write or read} $   ( icode : word;     var icnwd : XLUEXcnwdType ;      var ibuf : ibuftype; 
    ilen, ip1, ip2 : word); 
  external;      Function  CLASSGET $ alias 'EXEC' {Class I/O get}  $ 
   (  icode, iclass : word; 
 
      var ibuf : ibuftype; 
      ilen : word     ): word {returns A Register!} ;   external;       procedure LOADSEG $alias 'pas.segmentload'$      (Segname : string5); external;         procedure DTACH ( dummy : word ) ; external ; {M13 BG 04JUN86}       $ page $   {---------------------------------------------------------}   { XNET external modules :                                 }   {---------------------------------------------------------}      procedure  XOPSY ( var systemtype: word) ; { in module XGTAS }   external;      ! procedure TBLBUILD ; {Tables construction } $direct$ { in XSEG3 } !  external;      procedure XDISP ; {DISPATCHER} $direct$  { in module XDISP }   external;      procedure XRECV ; {obtain info} $direct$ { in module XRECV }   external;       procedure XSCH ; { scheduler } $direct$  { in module XSCH }   external;      procedure XSEND                          { in module XSEND } 
  (MessageType : XSENDmsg ; 
	   EP : EQTptrType; 	    EQTid : bits2;{1= write eqt; 2= read eqt}    W3value, 	   W4value : word); 	  external;       PROCEDURE XSUSP ( n : word ) ; $direct$  external ;  "                                 { in module XSEG4 }{M30 BG 16FEB87} "         $PAGE$   {---------------------------------------------------------}   { XNET internal utility subroutines:                      }   {---------------------------------------------------------}      {****************************}   {    MSG1WRITE and MSGWRITE  }   {used for trace}  {****************************}  { no trace }      PROCEDURE  MSG1WRITE ( Msglu : word ; MSG : pa75c ) ; $direct$       BEGIN  { write MSG on MSGLU }          EXEC2 ( 2, MsgLU, MSG, -75 ) ;      
 END { msg1write } ; 
    	 PROCEDURE MSGWRITE 	 !           ( msglu : word; msg1, msg2, msg3, msg4, msg5 : pa15c ); !    	 VAR  msg : pa75C ; 	 	      I : 0..100 ; 	      BEGIN     
   for I:= 1 to 15 do begin 
        Msg[I]:= msg1[I]; MSG[I+15]:= msg2[I]; MSG[I+30]:=msg3[I];         MSG[I+45]:= msg4[I]; msg[I+60]:=msg5[I];    end;        Exec2 ( 2, msglu, msg, -75);       END {MsgWrite};   { no trace}      {********************************************}   Procedure  CNUM ( n: word; var nbconv: PA6C ); $direct$  {********************************************}      { Used to convert a number in ASCII, right justified }   { Accepts positive and negative numbers }  { while RTE utility CNUMD treats all as 16 bit positive nb!}       BEGIN     If n >= 0 
   then  CNUMD ( n, nbconv) 
   else begin  
      CNUMD ( -n, nbconv); 
      nbconv [1] := '-'; {good enough for trace!}     end   END {CNUM};  $page$   {*********************************************************} " PROCEDURE  XMSGWR (msglu:word;x25msgIndex:byte;LuNb: word); $direct$ "  {*********************************************************}      { Used to format and print X25/1000 messages             }  { Example: ' X.25/1000: NETWORK READY            LU=218' }  {                                                        }  { For DVXschedule, Powerfail, Networkdown, IFCardError   }  { declared before RestartInitiated, output 2 lines:      }  { Example: ' X.25/1000: NETWORK DOWN             LU=218' }  {          ' X.25/1000: RECOVERY IN PROGRESS'            }  {                                                        }  { Note: accepts LUnb with sessionBit and removes it.     }  {       If LuNb = 0, does not print LU number            }       VAR   luchar : pa6c ;  
       I : 0..4096 ; 
      BEGIN          If LUnb <> 0 then LuNb := LUNb - SessionBit;      XMSG := msgX251000; {constant part of message}          For I:= 1 to X25MSGlength do  !        XMSG[ msgX251000length + I] := X25MSGarray[X25MSGindex,I]; !        If LuNb > 0      then begin          CNUMD (LuNb, LuChar); {>0, so no need to use CNUM}           XMSG[ msglunboffset + 1]:= 'L';           XMSG[ msglunboffset + 2]:= 'U';           XMSG[ msglunboffset + 3]:= '=';  
         For I:= 4 to 6 do 
              XMSG[ msglunboffset+I] := LUchar [ I ];      end;          {Try to send msg first with Class write; }      {If no SAM, send it with Direct Write    }          If XEXEC18 ( 18, msglu, XMSG, -XMSGlength,                 ip1ToIgnore, 0, XNETclassNb ) < 0     then { no SAM: use direct I/O }           XEXEC2 ( 2, MsgLu, XMSG, - XMSGlength ) ;         {Recovery message:}      If ( X25MsgIndex <= RestartInitiated )      then begin        If XEXEC18 ( 18, MsgLu, Recovery, -RecoveryLength,                                Ip1ToIgnore,0,XNETclassNb) < 0        then { no SAM : use direct I/O }            XEXEC2 ( 2, Msglu, Recovery, -RecoveryLength ) ;     end   END {XMSGWR};  $page$  {**********************************************************}  {                                                          }  {} PROCEDURE INGNRES ( CAUSEPARM : byte ) ;  $direct$     {}  {                                                          }  {  Initialize a general restart process on CURRENTNET      }  {                                                          }  {  Possible Cause parameters :  XINITschedule              }  {                               DVXschedule                }  {                               PowerFail                  }  {                               NetworkDown                }  {                               IFCardError                }  {                               CardDown                   }  {                                                          }  {  the Restart Network Sequence will be :                  }  {  -  Test Handshake with card Write LU   CN 6 or CN 32    }  {  -  Test Handshake with card Read  LU   CN 6             }  {     ( both Handshake statuses are not analyzed ! )       }  {  -  P_HandShakeRead  -  Gen_Clean_Up_LinkDown            }  {  -  Configure Driver Response CN33 Write LU              }  {  -  Configure Driver Response CN33 Read  LU              }  {  -  Reset Card CN 35 'RS'   ( initiate a self test )     }  {  -  Provide a delay to allow for the modem signals       }  {                                     to settle down.      }  {  -  Set Write Port ID CN 30 0                            }  {  -  Set Read  Port ID CN 30 1                            }  {  -  Write Configuration Data to Card                     }  {  -  Set Card Keep Alive Timer T3 on Read  LU             }  {  -  Send Open Line command to level 2  ( CN 31 )         }  {  -  Send Restart Request Packet to Network               }  {  -  Send Read Header Request to Read LU                  }  {                                                          }  {  Called from XNETM : phase 5 - first start XINITschedule }  {                              - restart     DVXschedule   }  {  Called from XDISP : GlobalReads - Process card status   }  {                                      cause = CardDown    }  {                                              IFCardError }  {                                              PowerFail   }  {                                              NetworkDown }  {  Called from XSCH  : XSCH body   - Process card status   }  {                                      cause = CardDown    }  {                                              IFCardError }  {                                              PowerFail   }  {                                              NetworkDown }  {                      Special Request 0 : Restart Network }  {                                    cause = XinitSchedule }  {                                                          }  {**********************************************************}       BEGIN        With NetwPtrTBL [ CURRENTNET ]^ do begin    {}    {}   If State <> carderror  	   {}   then begin 	   {}        State := HandshakeWithCard ;    {}        GenResCause := CAUSEPARM ;     {}        GlobalWrite := WHandshakeCardWrite;     {}        GlobalRead  := NoRead ;     {}       { Output message 'recovery in progress'      }     {}       { excepted for XINITschedule and DVXschedule }     {}        If GenResCause >= PowerFail     {}        then XMSGWR(1,GenResCause,CardWriteLU);    {}     {}        X25R := R4; #   {}                { special state: send restart but no VCpktWrites } #   {}        GWcause:=7 {network operational}; GWdiag := 0;    {}   end    end {with}  end {ingnres};  $page$   {*********************************************************}   {                                                         }   {} PROCEDURE EQTCLEAR ( EP : EqtPtrType ;                {}   {}                      EQTid, status : word) ; $direct$ {}   {                                                         }   { Attempts to clear the indicated EQT, by completing      }   { the request in progress (if any) with the given status. }   { The TLOG is set to zero.                                }   { Do not complete if write count is not 0, outstanding    }   { data packets are not yet acknowledged.                  }   { No more check if read from card in progress.            }   { If a read request is pending on a user EQT, but the     }   { request has not been transported to XNET because there  }   { is no data available yet, the ReqState is noReq and     }   { the read request on the user EQT is not completed.      }   {                                                         }   { Called from :                                           }   { - F0_CLEARDEVICE ( abort )                              }   { - RESET_AND_EQTCLEAR called from P_QBITDATAREAD         }   { - XPKT if mustsendsofterror at end of P and D level     }   {                                         processing.     }   {                                                         }   {*********************************************************}      
  VAR SendCompl : boolean; 
      BEGIN       With EP^, WriteReadEQT [eqtid] do begin          SendCompl := true;      
    Case ReqState of 
     {}  WriteState, Readstate, 
    {}  CompleteWaitState : 
    {}      {} If WriteCount > 0  { number of outstanding }      {}      {} then begin         { unacknowledged data packets }       {}      {}   SendCompl := false; {must wait}     {}      {}   ReqState := CompleteWaitState;     {}      {}   EQTstatus := status;      {}      {}   EQTtlog := 0; 	    {}      {} end; 	    {}  Otherwise  { Noreq. Request not transported yet }      {}             SendCompl := false;      {}      {}     end { case };          If sendcompl     then  XSEND ( NormalCompMsg, EP, EQTid, status, 0 ) ;       end {with EP}  	  END {EQTCLEAR }; 	 $page$    {*************************************************************}     {                                                             }     {} PROCEDURE FLUSH_MESSAGE ( eqp : EQTptrtype;               {}     {}                           Lastb : EMAPTRtype ) ; $direct$ {}     {                                                             }     {  Insures that last received message is flushed.             }     {                                                             }     {  Called from :                                              }     {  - EMA_USER_TRANSFER/COMPLETE_REQ  ( read request )         }     {  - F26 FLUSH if associated VC <> NIL                        }     {                                                             }     {*************************************************************}        VAR  bufferflushed : boolean;       BEGIN     	 WITH EQP^ DO BEGIN 	    
    bufferflushed := false; 
          IF EMAcounter > 0  { nb of EMA buffers with data available }       THEN begin      {}      {} { Partial data transfer may have occured, }      {} { flush the rest of the buffer.           }      {}      {} IF Lastb = Nextbuffertoread     {} THEN begin  {flush the rest of the current buffer}     {}    Nextbuffertoread := Nextbuffertoread^.Next;     {}    EMAcounter := EMAcounter - 1;     {} end;      {}      {} { Flush buffers while M bit = 1 }      {}     {} WHILE (EMAcounter > 0) AND (Lastb^.mbit ) DO BEGIN      {}    Lastb := Nextbuffertoread;     {}    Nextbuffertoread := Nextbuffertoread^.Next;     {}    EMAcounter := EMAcounter - 1;      {}    bufferflushed:=true;  	    {} END;{WHILE} 	     {}      {} { Flush the last buffer of the message (Mbit=0) }      {}     {} IF (EMAcounter <> 0) AND (bufferflushed)     {} THEN BEGIN      {}    Lastb := Nextbuffertoread;     {}    Nextbuffertoread := Nextbuffertoread^.Next;     {}    EMAcounter := EMAcounter - 1;     {} END;{IF}      {}      {} SENDRR := true;      {} { beware, VC could be in state P3 Wait Call Conf  }      {} {                  or in state P7 Wait Clear Conf }      {} { should then avoid sending RR.                   }     {} AssociatedVC^.PRTS := Lastb^.PR;      {} AssociatedVC^.Pktwriteneeded := true;      END; { IF EMAcounter > 0 }         { If no more data in EMA buffers but waiting more data to }     { complete the message, request to flush next coming data }     { packets until end of message.                           }     { Eqtptr^.AssociatedVC^.flushdata is tested in P_DATAPKT. }         IF ( AssociatedVC^.Msginprogress AND       {M67 BG 23AUG89}         (EMAcounter = 0) AND (Lastb^.Mbit))     THEN { Incoming data pkts must be flushed }        AssociatedVC^.flushdata := true;          AssociatedVC^.Msginprogress := false ;      END;{WITH}     
 end {flush message}; 
 $page$   {**************************************************************}    {                                                              }    {} PROCEDURE  LINKDOWN                                        {}    {}            ( EQTPTR: EqtPtrType; REASON: word ) ; $direct$ {}    {                                                              }    {  Send a LINKDOWN message to both user EQTs via DVX00. H-to-H }    {                          and only the single EQT if PAD.     }    {  Also set EstCircReceived to false.                          }    {                                                              }    {  Called from :                                               }    {  - P1SETUP        reason 'Clear' = 0                         }    {  - F32_CLEARCIRC  reason 'Clear' = 0                         }    {  - GEN_CLEAN_UP_LINKDOWN  reason 'GenResCause'               }    {                                                              }    {**************************************************************}        BEGIN         With EQTPTR^, EQText do begin    {}     {}  EstCircReceived := false;    {}    {}  {Clean up address if Pool: suppressed 12/83}     {}      {}  XSEND ( LinkDownMsg, EQTPTR, 1 {write eqt}, REASON ,0);     {}      {}  If EqtType <> padeqttype   !   {}  then XSEND ( LinkDownMsg, EQTPTR, 2 {read eqt}, REASON, 0)  !    {}  else begin {Clean up of READ EQT and of PDSUP area}     {}     WriteReadEQT[2].ReqState:=NoReq ;{read Eqt cleanup}      {}     PADmsgExpected := false; SendLF:=false;      {}  end    end {with}      end {linkdown} ;  $ page $  {******************************************************}  {                                                      }  {} PROCEDURE LINKUP ( EQTPTR: EQTptrType ) ; $direct$ {}  {                                                      }  { send LINK UP on both EQTs (if Host ot Host)          }  {             on single EQT (if PAD support)           }  { Also set EstCircReceived to true.                    }  {                                                      }  { Called from :                                        }  { - X25P_WRITES  P2: send call conf                    }  { - F31_ESTCIRC on a PVC                               }  { - SVCP3_CALLCONF  a call conf has been received      }  {                                                      }  {******************************************************}       BEGIN       With EQTPTR^ do begin    {}    {}  EstCircReceived := true; {even if already set}    {}      {Bit now always set even if PAD EQT or POOLEQT!}    {}   {}  XSEND ( LinkUpMsg, EQTPTR , 1 {write eqt},0,0);    {}    {}  If EQTtype <> PadEqtType    {}     then  XSEND( LinkUpMsg, EQTPTR, 2 {read eqt}, 0, 0)    {} 
  end {with EQTPTR} ; 
     end {linkup} ;  $page$  ! {***************************************************************} ! ! {                                                               } ! ! {} PROCEDURE ESTABLISHCIRCUIT ( EQTPTR: EqtPtrType) ; $direct$ {} ! ! {                                                               } ! ! {  Allocate an SVC if the EQT is configured with an address.    } ! ! {  If any suitable SVC is found prepare to send a call,         } ! ! {  link EQT and VC tables together.                             } ! ! {                                                               } ! ! {  EstCircError message is sent to DVX                          } ! ! {   - if there is no free suitable VC available for calling     } ! ! {   - if the EQT does not have a remote address configured,     } ! ! {     this is the case for PADEQT.                              } ! ! {                                                               } ! ! {  Called from F31_ESTCIRC in XSCH                              } ! ! {              CALL_COLLISION in XPKT                           } ! ! {                                                               } ! ! {***************************************************************} !      VAR  VCFOUND : boolean;        VCP : VCPtrType;       BEGIN        With  EQTPTR^ do begin             VCfound := false;         If REMOTE.W [1] <> DummyNetwAdd.W [1]        then begin {there is a Remote address}          {}          {}With NETWP^ do begin          {}  {Allocate an SVC (free and either 1wout or 2w) : }          {}      If FirstVCforCall <> nil  
        {}      then begin 
!        {}          VCP := FirstVCforCall; { explore circular list} !        {}          Repeat  {until VCfound or (VCP=FirstVC) }          {}           {}  If VCP^.AssociatedEQT = NIL         {}           {}  then VCfound := true          {}           {}  else VCP := VCP^.NextVC          {}          Until VCfound or (VCP = FirstVC) ;  
        {}      end; 
         {}          {}  If VCfound          {}  then begin         {}       With VCP^ do begin          {}        {} {Link together VC and EQT:}         {}        {}       AssociatedVC := VCP;          {}        {}       AssociatedEQT := EQTPTR ;         {}        {} If X25P = p1  { call setup ready }         {}        {} then begin          {}        {}        X25P := p5 ; { send call }          {}        {}        PKTwriteNeeded := true ;         {}        {} end;  #        {}        {} CallRetryCtr := CallRetryNb {reset Call retry nb} #        {}       end { with VCP }         {}  end         {}end { with NETWP^ }          end { if remote.add };     
       If not VCfound 
       then begin         {}  EstCircReceived := false;        {}  XSEND ( EstCircErrorMsg, EQTPTR, 1 {write Eqt}, 0,0)         end        end {with}  
  end {ESTABLISHCIRCUIT} ; 
 $page$   $skip_text on$                         {M80 BG 16FEB90}   {*****************************************************}   {                                                     }   {                    VCSEARCH                         }   {                                                     }   { Find a VC tbl, given a network ptr and a VC number. }   { Sequential search over circular list of VC tables   }   { of this network.                                    }   {                                                     }   { Called from TBLBUILD in XSEG3                       }   {             XPKT                                    }   {                                                     }   {*****************************************************}     	 PROCEDURE VCSEARCH 	           ( NP  : NetwPtrType ; { identifies the network }               IVC : word   ;      { VC number } !             var VCP : VCptrType { result: ptr on VC rec if found } !!                                 {       : NIL if VC not found    } !            ); $direct$        VAR  VCfound    : boolean;        V          : VCptrType ;         LoopLimit  : VCptrtype;       BEGIN     
    VCfound := false; 
    V := NP^.FirstVC ;  {never NIL}  
    LoopLimit := V ; 
         repeat      {}     {}   if V^.VCnb = IVC     {}      then  VCfound := true      {}      else  V := V^.NextVC      {}     until ( VCfound or ( V = LoopLimit )) ;            if VCfound 	      then VCP := V 	
      else VCP := NIL 
    	  end {VCSEARCH } ; 	  $skip_text off$  $page$   {**************************************************************}    {                                                              }    {} PROCEDURE  P1SETUP ( VCPTR: VCptrType ) ;  $direct$        {}    {                                                              }    {  Prepare VC after return in state P1                         }    {                                                              }    {  Called from :                                               }    {  - X25P_WRITES (XDISP) P6: after clear conf has been sent    }    {  - F32_CLEARCIRC (XSCH) on circuit not yet established       }    {  - P_LEVEL_TREATMENT (XPKT)                                  }    {      P7 ( wait clear conf ) : clear or clear conf received   }    {                                                              }    {**************************************************************}        VAR  EP : EqtPtrType;       BEGIN        With VCPTR^ do begin         X25P := p1;      PKTwriteNeeded := false;     
    If AssociatedEQT <> nil 
     then begin     {} With associatedEqt^, EQText do begin      {}      {}   { Update EMA pointers and variables }     {}   EMAcounter := 0;     {}   Nextbuffertoread := nil;     {}   {Nextfreebuffer unchanged}      {}      {}   MSGinprogress := false;      {} 
    {}   If EstCircReceived 
	    {}   then begin 	    {}   {} If CallRetryCtr > 0      {}   {} then begin     {}   {}  {}  X25P := p5; { send call packet }     {}   {}  {}  PKTwriteNeeded := true     {}   {} end "    {}   {} else begin {cut links VC <-> EQT and stay in Listen mode} "     {}   {}  {} If EQTtype = PoolEQTtype     {}   {}  {} then begin { no "listen mode" on POOL EQT }     {}   {}  {}    {Set pool eqt down, but do not release it}      {}   {}  {}    Downflag := true;      {}   {}  {}    EstCircReceived := false;      {}   {}  {}    XSEND(EstCircErrorMsg,AssociatedEQT,1,0,0);      {}   {}  {}    {deallocate pool: suppressed 12/83}  
    {}   {}  {} end; 
     {}   {}  {} AssociatedVC := nil;      {}   {}  {} AssociatedEQT := nil     {}   {} end      {}   end 	    {}   else begin 	     {}   {}  { Set pool eqt DOWN, but do not release it}     {}   {}  If EQTtype = pooleqttype     {}   {}  then   downflag := true;     {}   {}  EP := AssociatedEQT; {save for LINKDOWN}      {}   {}  {cut links VC <-> EQT:}      {}   {}       AssociatedVC := NIL; !    {}   {}       AssociatedEQT:= NIL; {previous value still in EP} !     {}   {}  LINKDOWN (EP, Clear) {Note: special "reason"}     {}   end;     {}   end {with associatedEqt}     end  	  end {with vcptr} 	 end; {P1SETUP}  $page$   {**************************************************************}    {                                                              }    {} PROCEDURE  D1CLEANUP ( VCPTR : VCptrType ) ; $direct$      {}    {                                                              }    {  Links are established between EQT and VC tables             }    {                                                              }    {  Called from :                                               }    {  - D1SETUP upon handling of reset packets                    }    {  - X25P_WRITES  P2: prepare and send call conf               }    {  - GEN_CLEAN_UP_LINKDOWN  phase 1 if VCtype is PVC           }    {  - SVCP3_CALLCONF P3 wait call conf, a call conf is accepted }    {                                                              }    {**************************************************************}        BEGIN        With VCPTR^ do begin       X25D := d1;      CallretryCtr := 0; {vc established: no retry needed}       X25EI := NotInterrupting;      X25RI := NotInterrupted; 
     X25RNR := false; 
      EPS := 0;       EPR := 0;       RPS := 0;       RPR := 0;      prts := 0;       Flushdata := false;      PKTwriteNeeded := false;       {Update EMA pointers and variables}       AssociatedEQT^.EMAcounter := 0;       associatedEQT^.Nextbuffertoread := nil;      {Nextfreebuffer unchanged}      {Lastbufferfilled unchanged}            {BG 02/86}       MSGinprogress := false;    end {with}      end {D1CleanUp};  $page$  ! {***************************************************************} ! ! {                                                               } ! ! {} PROCEDURE D1SETUP ( VCPTR : VCptrType ) ; $direct$          {} ! ! {                                                               } ! ! {  Process return in state D1 after handling of RESET.          } ! ! {  x25P = p4 ; there is an associatedeqt                        } ! ! {                                                               } ! ! {  Called from :                                                } ! ! {  - X25D_WRITES of ALL_VC_PKT_WRITES P4 D2 send reset conf     } ! ! {  - D_LEVEL_TREATMENT  D3 wait reset conf, reset conf received } ! ! {                                                               } ! ! {***************************************************************} !      BEGIN     
   D1CleanUp (VCPTR); 
        With VCPTR^,AssociatedEQT^ do begin    {}     {}  With WriteReadEqt[1] do begin { WRITE EQT }  
   {}  {} case ReqState of 
   {}  {}     {}  {}   CompleteWaitState:  "   {}  {}    XSEND(NormalCompMsg,AssociatedEQT,1,EQTstatus,Eqttlog); "   {}  {}     {}  {}   LinkDownState:  {special state for PVC only}    {}  {}    XSEND ( LinkdownMsg,AssociatedEQT,1, 0,0);    {}  {}    {}  {}   WriteState:     {}  {}    PktWriteNeeded := true; { process pending write }    {}  {}     {}  {}   Otherwise  { do nothing }  ;    {}  {}  
   {}  {}end {case}; 
    {}  end {with Write Eqt};    {}     {}  With WriteReadEqt[2] do begin  { READ EQT }  
   {}  {} case Reqstate of 
   {}  {}  
   {}  {}   LinkDownState: 
   {}  {}     XSEND ( LinkDownMsg,AssociatedEQT,2, 0,0 );    {}  {}    {}  {}   Otherwise { do nothing }  ;    {}  {} 	   {}  {}end {case} 	
   {}  end {with Read Eqt}; 
   end {with VCPTR^.AssociatedEQT};   end {D1SETUP} ;  $page$ " $skip_text on$                                      {M80 BG 16FEB90} ""  {*****************************************************************} ""  {                                                                 } ""  {} PROCEDURE SETUP_EMA_STORAGE ( EQTptr : EQTPTRtype ); $direct$ {} ""  {                                                                 } ""  {  Prepare parameters needed to issue a VMAIO Read                } ""  {  to move data from the card to an EMA buffer.                   } ""  {                                                                 } ""  {  Called from XPKT/P_DATA_RR_RNR/P_DATAPKT  ( 3 times )          } ""  {                                                                 } ""  {*****************************************************************} "      BEGIN          With NETWP^,EQTPTR^,Nextfreebuffer^ DO BEGIN            GlobalRead := CardEMAread ;  { Type of global read }             GRP2 := PKTsizetable[ EffectivePTW.Inpktsize ];                                       { maximum read byte length }         GRPP := Nextfreebuffer; { EMA buffer address }             Respeqt := EQTptr;  { EQT responsible for global read }      	    END ; { with } 	      END ; { Setup_ema_storage }   $skip_text off$  $page$   {*****************************************************}   {                                                     }   {} PROCEDURE  TIMER_TESTS  ;  $direct$               {}   {                                                     }   {  Process timers within XNET.                        }   {  The clock is provided by DVX00 every time a buffer }   {  is returned to XNET  ( TimerTestNeeded true ).     }   {                                                     }   {  Called from XNET main loop.                        }   {                                                     }   {  CurrentNet may have any value at this point.       }   {  CurrentNet will be set to 0 if any timer expired   }   {                            ( with action needed )   }   {                                                     }   {  CTR      : total number of timers processed        }   {  X25TOCTR : nb of active timers for this network    }   {  GLOBALTOCTR : total nb of active timers for the    }   {                entire X25 subsystem ;               }   {                all networks together.               }   {                                                     }   {*****************************************************}       VAR  INet,INetLim : 0..MaxNbOfNetworks; 
       Ctr : 0..1000; 
        VP, LoopLimit: VCptrType;        {**************************************************}     Function TimerExceeded ( var Timer: word) : boolean;  $direct$     {**************************************************}     "   {Use LastTime and NewTime to verify if "timer" is exceeded or not} "   {Note: basic hypothesis: at least one time per cycle!}         begin       If LastTime < Timer      then          If (LastTime <= NewTime) and (NewTime < Timer)          then TimerExceeded:= false          else TimerExceeded := true       else           If (Timer <= NewTime) and (NewTime < LastTime)          then TimerExceeded := true         else TimerExceeded := false    end { TimerExceeded };  $page$   {*************************}   begin { TIMER_TESTS }   {*************************}      If GlobalTOctr > 0    { at least one timer set }   then begin            { Iterate over the networks : }        INet :=1 ; 
  INetLim := NbOfNetworks ; 
       While ( INet <= INetLim ) and ( GlobalTOctr > 0 ) do   begin    {}   {} With NETWPTRtbl [ INet ]^ do    {} begin    {}    {}  {waiting for read after Unsol data ?} {PM 11/82}    {}   {}  Ctr:= 0; { Nb of timers processed }    {}   {}  If X25TOctr > 0  {waiting for at least one X25 packet?}    {}  then begin    {}    {}   If RestConfWaitTO <> -1 !  {}   then begin  { Note: mutually exclusive of other X25 events } !  {}   {}   {}   {} If TimerExceeded ( RestConfWaitTO )   {}   {} then begin  {-----  Restart  Conf  Wait  TO  -----}    {}   {} {}     {}   {} {}  {}        $SKIP_TEXT ON$          {M66 BG 23AUG89}     {}   {} {} If RestRetryCtr > 0   {}   {} {}  {}        $SKIP_TEXT OFF$    {}   {} {} If RestRetryCtr > 1   {}   {} {}  then begin { stay in state X25 R3 }   {}   {} {}    GlobalWrite := WRestart ;    {}   {} {}    GWdiag := 52 ;    {}   {} {}    GWcause := 1 ; { Restart: Local procedure error }    {}   {} {}    CurrentNet := 0 ;   {}   {} {}    RestRetryCtr := RestRetryCtr -1 ; 	  {}   {} {}  end ; 	!  {}   {} {} { else RestRetryCtr overflow, keep waiting FOREVER ! } !   {}   {} {}   {}   {} {} RestConfWaitTO := -1 ;     {}   {} {} X25TOctr := 0 ; { restConfWait mutually exclusive }    {}   {} {} Ctr := 1 ;    {}   {} {} "  {}   {} end {----------  end  Restart  Conf  Wait  TO  -----------} "  {}   {} { else continue to wait }    {}   end   {}   {}  #  {}   else If RestartDelayWaitTO <> -1                {M2 BG 24apr85} #!  {}   then begin  { Note: mutually exclusive of other X25 events } !  {}   {}   {}   {} If TimerExceeded ( RestartDelayWaitTO )     {}   {} then begin  {---------  Restart Delay TO  -----------}     {}   {} {}   {}   {} {} GlobalWrite := Wopenline ;   {}   {} {} state := ready ;    {}   {} {} CurrentNet := 0 ;    {}   {} {} RestartDelayWaitTO := -1 ;  { reset timer } !  {}   {} {} X25TOctr := 0 ; { RestartDelay TO mutually exclusive } !  {}   {} {} Ctr := 1 ;    {}   {} {}    {}   {} end {----------  end  Restart Delay TO  -----------}   {}   {} {else continue to wait}  #  {}   end                                             {M2 BG 24apr85} #  {}   {}  #  {}   else If ResetDelayWaitTO <> -1                 {M13 BG 21may86} #   {}   then begin  {Note: mutually exclusive of other X25 events}    {}   {}   {}   {} If TimerExceeded ( ResetDelayWaitTO )    {}   {} then begin  {---------  Reset Delay TO  -----------}    {}   {} {}   {}   {} {} GlobalWrite := WSetWritePortID ;    {}   {} {} CurrentNet := 0 ;    {}   {} {} ResetDelayWaitTO := -1 ;  { reset timer }    {}   {} {} X25TOctr := 0 ; { ResetDelay TO mutually exclusive }    {}   {} {} Ctr := 1 ;    {}   {} {}    {}   {} end {----------  end  Reset Delay TO  -----------}   {}   {} { else continue to wait }  #  {}   end                                            {M13 BG 21may86} #  {}   {}   {}   else begin   {}   {} "  {}   {} { Iterate over (never empty) circular list of VC tables : } "  {}   {} VP := FirstVC ; 
  {}   {} LoopLimit := VP ; 
  {}   {}    {}   {} Repeat    {}   {} {} With VP^ do begin    {}   {} {}   {}   {} {}  If VCTO <> -1  {Is timer set for this VC ?}    {}   {} {}  then begin    {}   {} {}  {}    {}   {} {}  {} {--------- Process VC Time out -------}    {}   {} {}  {}   {}   {} {}  {} If TimerExceeded( VCTO ) 
  {}   {} {}  {} then begin 
   {}   {} {}  {}    {}   {} {}  {}  Case X25P of   {}   {} {}  {}   P3: begin { wait call conf }   {}   {} {}  {}         X25P := P8 ; {send clear }     {}   {} {}  {}         Cause := 19 ; {clear local proc error }      {}   {} {}  {}         Diag := 49 ; { timer expired for call }    {}   {} {}  {}         PKTwriteNeeded := true ;    {}   {} {}  {}         CurrentNet := 0 ; !  {}   {} {}  {}         { CallRetryctr processed at return in P1 } !  {}   {} {}  {}       end ; { P3 }    {}   {} {}  {}    {}   {} {}  {}   P4: begin { X25D = d3 wait reset Conf }     {}   {} {}  {}        $SKIP_TEXT ON$          {M39 BG 04SEP87}     {}   {} {}  {}         If RetryCtr > 0   {}   {} {}  {}        $SKIP_TEXT OFF$    {}   {} {}  {}         If RetryCtr > 1   {}   {} {}  {}         then begin    {}   {} {}  {}           X25D := d4 ; { send reset }  !  {}   {} {}  {}           Cause := 5 ; { Reset Local Proc error } !!  {}   {} {}  {}           Diag := 51 ; { timer expired for Reset } !  {}   {} {}  {}           PKTwriteNeeded := true ;   {}   {} {}  {}           CurrentNet :=0 ;    {}   {} {}  {}           RetryCtr := RetryCtr -1 ;   {}   {} {}  {}          end  "  {}   {} {}  {}         else { retry limit exceeded, RetryCtr = 1 } "   {}   {} {}  {}          begin         {added M39 BG 01SEP87}   {}   {} {}  {}           if  VCtype = PVC    {}   {} {}  {}             then  RetryCtr := 0   {}   {} {}  {}             else begin { SVC }    {}   {} {}  {}               X25P := p8 ; { send clear } #  {}   {} {}  {}               Cause := 19 ; { clear local proc error } # #  {}   {} {}  {}               Diag := 51 ; { timer expired on reset } #  {}   {} {}  {}               PKTwriteNeeded := true ;    {}   {} {}  {}               CurrentNet := 0 ;    {}   {} {}  {}             end ;   {}   {} {}  {}          end ;   {}   {} {}  {}       end ; { P4 }    {}   {} {}  {}    {}   {} {}  {}   P7: begin { wait clear conf }     {}   {} {}  {}        $SKIP_TEXT ON$          {M39 BG 04SEP87}     {}   {} {}  {}         If RetryCtr > 0   {}   {} {}  {}        $SKIP_TEXT OFF$    {}   {} {}  {}         If RetryCtr > 1   {}   {} {}  {}         then begin    {}   {} {}  {}           X25P := p8 ; { send clear } !  {}   {} {}  {}           Cause := 19 ; { clear local proc error } ! !  {}   {} {}  {}           Diag := 50 ; { timer expired on clear } !  {}   {} {}  {}           PKTwriteNeeded := true ;    {}   {} {}  {}           CurrentNet := 0 ;    {}   {} {}  {}           RetryCtr := RetryCtr -1 ;   {}   {} {}  {}          end   {}   {} {}  {}         else  { clear retry limit exceeded }   {}   {} {}  {}          begin        {added M39 BG 01SEP87}  #  {}   {} {}  {}           RetryCtr := 0 ; { will be set up by XDISP } # #  {}   {} {}  {}                     { when a new CLEAR will be sent } # "  {}   {} {}  {}           AssociatedEqt^.EstCircReceived := false ; "  {}   {} {}  {}           P1SETUP ( VP ) ; { send LINKDOWN }   {}   {} {}  {}          end ;   {}   {} {}  {}       end ; { end P7 }    {}   {} {}  {}   {}   {} {}  {}    { Protection against undefined case }   {}   {} {}  {}   $skip_text on$      {M30 BG 11FEB87}   {}   {} {}  {}    otherwise  XSUSP(5)    {}   {} {}  {}   $skip_text off$    {}   {} {}  {}    otherwise  begin     {}   {} {}  {}                 VCPTR := VP ; { global access }     {}   {} {}  {}                 LOADSEG ( 'XSEG3' ) ; {M30}    {}   {} {}  {}                 XSUSP (5) ;    {}   {} {}  {}                 LOADSEG ( 'XSEG4' ) ; {M30}   {}   {} {}  {}               end;    {}   {} {}  {}   end ; { case X25P }    {}   {} {}  {}    {}   {} {}  {}  VCTO := -1 ;   {}   {} {}  {}  X25TOctr := X25TOctr -1 ;    {}   {} {}  {}  Ctr := Ctr + 1 ;    {}   {} {}  {}   {}   {} {}  {} end  { if TimerExceeded ( VCTO ) }    {}   {} {}  {}   {}   {} {}  end ; { if VCTO <> -1   --------------------}    {}   {} {}  
  {}   {} {}  VP := NextVC 
   {}   {} {}    {}   {} {} end { with VP }    {}   {} {}   {}   {} Until (( X25TOCtr <= 0 ) or ( VP = LoopLimit ))   {}   {}    {}   end ;    {}   {}   GlobalTOCtr := GlobalTOCtr - Ctr    {}   {}  end { if X25TOctr }    {}    {} end ; { with NETWPTRTBL }    {} 
  {} INet := INet + 1 
   {}   end ; { while }       end ;  { if GlobalToctr > 0 }       LastTime := NewTime ;       END { TIMER_TESTS } ;      	 $title ' ', page$ 	! {****************************************************************} ! BEGIN                  {   XNET  body  } ! {****************************************************************} !     {--------------------------------------} ! {PHASE 1 : verif scheduling parameters:} { P1 XNET security code } !! {--------------------------------------} { P2 scheduling type    } !!                                          { P3 Write Reserved LU  } !!                                          { P4 XNET class number  } !!                                          { P5 MSGLU for tracing  } !   RMPAR( PARM );     If PARM[1] <> XNETSECCODE     then  begin {Incorrect security code}        XEXEC2(2,1{lu},ERRMSG1,-errmsglength);  	      STOP (EXEC6) 	   end;        Case PARM [2] of   { scheduling type }      {}      {}   0  : { test of existence of XNET by XINIT }  
     {}      {}begin 
      {}      {}  {prepare parms to be returned to caller:}      {}      {}  PARM[3] := XNETSECCODE ;      {}      {}  {check EMA space available in XNET partition:}       {}      {}  INITIALIZE_HEAP ;           {M1 BG 09AUG85}       {}      {}  GETHEAP2INFO ( HEAP2INFO );      {}      {}  Size.DW := Heap2info.toh - Heap2info.tos ;       {}      {}  PARM[1] := Size.W2[1] ;       {}      {}  PARM[2] := Size.W2[2] ;       {}      {}  PRTN (PARM );       {}      {}  STOP (EXEC6); 	     {}      {}end; 	     {}       {}   1  : { Schedule by XINIT }  
     {}      {}begin 
      {}      {}  CauseParm := XINITschedule;       {}      {}  WriteReservedLU := PARM[3];  $     {}      {}  XNETclassNb := PARM[4] + NoDeallocateBit; {always keep} $      {}      {}  XNETclassNbA := PARM[4]; { Necessary for RTE-A }        {}      {}  XMSGWR (1 {LU}, X25started, 0); "     {}      {}  If Parm[5] > 0 then MSGLU := Parm[5] else MSGLU := 0 " !     {}      {}                 {non 0 to activate internal trace} !	     {}      {}end; 	     {}      {}   2  : { Re-schedule by DVX00, if XNET is dormant }      {}        { and DVX has some request to transport.   }  
     {}      {}begin 
     {}      {}  CauseParm := DVXschedule ;       {}      {}  WriteReservedLU := PARM[3]; #     {}      {}  XNETclassNb := PARM[4] + NoDeallocateBit;{always keep} #      {}      {}  XNETclassNbA := PARM[4]; { Necessary for RTE-A }         {}      {}  XMSGWR ( 1{lu},DVXschedule, 0{no lu to print});        {}      {}  MSGLU := 0; { cancel internal trace } 	     {}      {}end; 	     {}  	     {}  otherwise 	     {}          XEXEC2(2,1 {lu}, ERRMSG2 ,- ErrMsgLength);       {}          STOP (EXEC6);      {}     end {case};     "   DTACH ( dummy1 ) ;   { detach XNET from session } {M13 BG 04JUN86} "     $page$  {------------------------------------------------------------}  { PHASE 2: set SESSIONBIT according to system used           }  {------------------------------------------------------------}           XOPSY (SystemType);           If SystemType = RTE_A          then SessionBit := 0    {do not set session bit} 	         else begin 	               SessionBit := -32768; {convenient for XLUEX}                WriteReservedLU := WritereservedLU + SessionBit;          end;      {------------------------------------------------------------}  { PHASE 3: set up Global Variables                           }  {------------------------------------------------------------}           cnwdWriteResLU [1] := WriteReservedLU ;           cnwdReadResLU [1] := cnwdWriteResLU [1] + 1 ;               XNETclassNoWait := XNETclassNb  + NoWaitBit;            XNETclassNoWaitA:= XNETclassNbA + NoWaitBit;                     {bit 13 to 0: special for RTE-A  CC 5/83}        {---------------------------------------------------------}   { PHASE 4: Build XNET internal tables from XTBL info      }   {---------------------------------------------------------}           LOADSEG ( 'XSEG3' ) ;  	         TBLBUILD; 	      {---------------------------------------------------------}   { PHASE 5: set up for general restart over all networks   }   {---------------------------------------------------------}         {Special subphase to get rid of possible pending Wake-Me read}          LOADSEG ('XSEG4') ;        { M13 BG 02may86 }        If CauseParm = DVXschedule    then begin    {}    {} CnwdReadResLU [2] := 0;    {}    {} WRDIRECT (1, cnwdReadResLU, XNETIBUF, -12,0,0);    {}          {No need to verify if request: link down soon}    {}  "   {} Repeat  {eat up all completed req, including "wake-me" if any} " !   {} Until  ClassGet(21,XNETclassNoWait,XNETIBUF,maxibuflen) < 0; !   {}    end;         For CURRENTNET := 1 to NbofNetworks    do         INGNRES ( CauseParm ) ;  $page$   {---------------------------------------------------------}   { Phase 6: Central processing                             }   {---------------------------------------------------------}        {initializations before main loop:}           TimerTestNeeded := false ;      GlobalTOctr := 0 ; 	    LastTime := 0 ; 	    	    SAMOK := true ; 	
    NoSamCount := 0 ; 
         FirstPDSreq := nil ;     LastPDSreq := nil ;     XNETmoreDataOnCard := 0 ;          XRECVmorePDSUPreq := 0 ;  
    XRECVmoreDVXreq := 0 ; 
     XRECVreadPendingToDVX := false ;         $skip_text on$           { M13 BG 02may86 }     LOADSEG ('XSEG4') ;  	   $skip_text off$ 	         CURRENTNET := 0 ; { To dispatch over all networks.       }                        { No dispatch if currentnet = -1.      }                        { dispatch over only network n  if = n }          CONTINUE_XNET_MAIN_LOOP := true ;  { never reset in fact }         while  CONTINUE_XNET_MAIN_LOOP  do   { XNET MAIN LOOP }     begin      {}     {}    If CurrentNet <> -1     {}    then   XDISP ; { Dispatcher }      {}      {}    XRECV ; { central GET, obtain new mail }      {}     {}    XSCH ;  { Scheduler }      {} !    {}    If  TimerTestNeeded  then   { set true when new time is } !"    {}    begin                       { received from pseudo driver } "     {}    {}      {}    {}  TimerTestNeeded := false ;      {}    {}  #    {}    {}  TIMER_TESTS ;  { check if any active timer has expired } #     {}    {}     {}    end ;      {} 	    end ; { while } 	      { end of central processing phase }       END.  { end of module XNETM } 