 %{************************************************************************} % $PASCAL '91751-1X303 REV.5000 <870814.1534>'  %{************************************************************************} % %{                                                                        } % %{    FILE  : XLBUT.PAS                                                   } % %{    SOURCE: 91751-18303                                                 } % %{    RELOC.: 91751-1X303                                                 } % %{                                                                        } % %{  ***************************************************************       } % %{  * (C) COPYRIGHT HEWLETT-PACKARD COMPANY 1982.  ALL RIGHTS     *       } % %{  * RESERVED.  NO PART OF THIS PROGRAM MAY BE PHOTOCOPIED,      *       } % %{  * REPRODUCED OR TRANSLATED TO ANOTHER PROGRAM LANGUAGE WITHOUT*       } % %{  * THE PRIOR WRITTEN CONSENT OF HEWLETT-PACKARD COMPANY.       *       } % %{  ***************************************************************       } % %{                                                                        } % %{------------------------------------------------------------------------} % %{                                                                        } % %{    XLBUT  library contains the following procedures and functions :    } % %{                                                                        } % %{      VCentry_fetch       Used to retreive the VCentry from XTBL        } % %{                          corresponding to the specified LU.            } % %{                                                                        } % %{      VCsearch            Search the type of VC associated to that Lu.  } % %{                                                                        } % %{      NXTVC_search        Used to scan through the VCentries in XTBL    } % %{                          to access the VCentry corresponding to the    } % %{                          specified Lu.                                 } % %{                                                                        } % %{      hdr_search          Used to access a Network header within XTBL.  } % %{                                                                        } % %{      Check_Net_and_Pool  Finds the network LU corresponding to a given } % %{                          Pool LU. It is used by RPOOL.                 } % %{                                                                        } % %{      NXThdr_search       Computes offset to next header entry.         } % %{                                                                        } % %{      NACUGcheckmove      Checks Network address & CUG nb, moves to SVC } % %{                                                                        } % %{      EnablNetwork        Procedure for Network restart                 } % %{                                                                        } % %{      GetNetwState        Used to get network state and activity.       } % %{                                                                        } % %{      XNETtransfer        Provides a mailbox for communication w. XNET. } % %{                                                                        } % %{------------------------------------------------------------------------} % %{                                                                        } % %{ Original : 2201                                                        } % %{ Change #1: 2226                                                        } % %{ Change #2: 2326                                                        } % %{    .to support RTE-A                                                   } % %{ Change #3: 2401                                                        } % %{    .update rev code to 2401 (major PCO of the product)                 } % %{ Change #4: 2440                                                        } % %{    .Network LU parameter of RPOOL now optional.                        } % %{    .support new PASCAL                                                 } % %{    .support new file system                                            } % %{ Change #5: 5.0   BG                                                    } % %{    .Standardization of XNETtransfer interface among the different      } % %{     special request calls. (M19)                                       } % %{    .Add EnablNetwork and GetNetwState. (M19)                           } % %{                                                                        } % %{************************************************************************} %    $CDS OFF$ $STANDARD_LEVEL 'HP1000'$  $AUTOPAGE ON, LINESIZE 80, RECURSIVE OFF, HEAP 0, RANGE OFF$  $SUBPROGRAM$     PROGRAM XLBUT ;     { includes  XTBLG.PASI , XMDGB.PASI } %$PRIVATE_TYPES$  { for symbolic DEBUG requirements }       {M19 BG 18NOV86} % $LIST OFF$  $INCLUDE 'XTBLG.PASI'$  $INCLUDE 'XMDGB.PASI'$ $LIST ON$     $TITLE 'XMOD utility procedures'$ $SUBTITLE 'XMOD external procedures', PAGE$  "{---------------------- EXTERNAL PROCEDURE ------------------------} "    PROCEDURE GTOPT ( var systemtype: word );              EXTERNAL ;      PROCEDURE Get_HDRvar_entry $ALIAS 'GTNXT'$                 ( VAR Offset : WORD ;                   VAR entry  : HDRvartype ;                       entrylength ,                       requiredlength : WORD ) ;              EXTERNAL ;     PROCEDURE Get_AVC_entry $ALIAS 'GTNXT'$                 ( VAR offset : WORD ;                    VAR entry  : VCentrytype ;                       entrylength ,                       requiredlength : WORD ) ;              EXTERNAL ;     PROCEDURE Get_POOLHDR_entry $ALIAS 'GTNXT'$                 ( VAR offset : WORD ;                   VAR entry  : XTBLPOOLSVCheaderentrytype ;                       entrylength ,                       requiredlength : WORD ) ;              EXTERNAL ;      PROCEDURE Get_PADHDR_entry $ALIAS 'GTNXT'$                 ( VAR offset : WORD ;                    VAR entry  : XTBLPADSVCheaderentrytype ;                       entrylength ,                       requiredlength : WORD ) ;              EXTERNAL ;      PROCEDURE Get_AXTBL_word $ALIAS 'GTNXT'$                  ( VAR offset ,                       entry  : WORD ;                       entrylength ,                       requiredlength : WORD ) ;              EXTERNAL ;      PROCEDURE NACHK ( VAR NetaddCUG : ALTADentrytype ;                   VAR Error     : WORD  ) ;              EXTERNAL ;     PROCEDURE XNVFY ( error : word ) ;   {added M19 BG 14AUG87}  
                EXTERNAL ; 
     $SUBTITLE 'RTE external procedures', PAGE$      PROCEDURE RNREQUEST $ALIAS 'RNRQ'$                 (     Control_word  :  WORD ;                   VAR Resrce_numbr  ,                       Status        :  WORD 	                ) ; 	             EXTERNAL ;     "$skip_text on$                                       {M19 BG 12NOV86} " PROCEDURE Classio   $ALIAS 'EXEC'$ $skip_text off$  PROCEDURE Classio   $ALIAS 'EXEC' , noabort$                 (     Classiotype   ,                       Control_word  :  WORD ;                        buffer        :  XNETentrytype ;                       length        ,                       iop1          ,                       iop2          :  WORD ;                   VAR classnumber   :  WORD 	                ) ; 	             EXTERNAL ;     "$skip_text on$                                       {M19 BG 12NOV86} "PROCEDURE Xlassio   $ALIAS 'EXEC'$  { for RTE-A CC 9Jun83 } $skip_text off$  PROCEDURE Xlassio   $ALIAS 'EXEC' , noabort$                 (     Classiotype   ,                       Control_word  :  WORD ;                        buffer        :  XNETentrytype ;                       length        ,                       iop1          ,                       iop2          :  WORD ;                   VAR classnumber   :  WORD ;                       uv            :  WORD 	                ) ; 	             EXTERNAL ;     "$skip_text on$                                       {M19 BG 12NOV86} "PROCEDURE Classioget $ALIAS 'EXEC'$ $skip_text off$ PROCEDURE Classioget $ALIAS 'EXEC' , noabort$                 (     Classiotype   :  WORD ;                   VAR Classnumber   :  WORD ;                      $skip_text on$          {M19 BG 09SEP86}                       buffer        :  XNETreturntype ;                       $skip_text off$                        buffer        :  XNETreplytype ;                       length        :  WORD 	                ) ; 	             EXTERNAL ;     PROCEDURE ABREG ( VAR A_reg, B_reg : WORD ) ;              EXTERNAL ;     PROCEDURE ClassRequest $ alias 'CLRQ' , noabort $                ( funct : word ;  "                 VAR classnbr : word ) ; external ; {M19 BG 04NOV86} "         "{-------------------- END OF EXTERNAL PROCEDURES ------------------} " $PAGE$  PROCEDURE NXThdr_search ( VAR Offset   : WORD  ;                           VAR HDRvar   : HDRvartype                      ) ; forward;      PROCEDURE hdr_search ( VAR Offset     : WORD ;                             NetworkWlu : BYTE ;                         VAR HDRvar     : HDRvartype ;                        VAR error      : WORD ) ; forward;       PROCEDURE Check_Net_and_Pool (    POOL_LU : BYTE;   {CC 30Aug84}                                VAR Net_LU  : BYTE;                                VAR Error   : WORD ); FORWARD;      FUNCTION NXTVC_search ( VAR Offset        : WORD ;                              Nbofvc        : BYTE ;                              VCLUnumber    : BYTE ;                              VCentrylength : WORD ;                         VAR VCentry       : VCentryType                        ) : BOOLEAN ; forward;     PROCEDURE VCsearch ( VAR Offset     : WORD          ;                          VCLunumber : BYTE          ;                      VAR VCLutype   : VCtype        ;                      VAR VCentry    : VCentrytype   ;                           HDRvar     : HDRvartype                    ) ; forward;     PROCEDURE NACUGcheckmove ( VAR NetaddCUG : ALTADentrytype ;                            VAR SVCentry  : VCentryType    ;                            VAR error     : WORD                          ) ; forward;     $PROCEDURE EnablNetwork ( NWLU : word ;                   {M19 BG 19NOV86} $                         VAR error : word ) ; forward ;      PROCEDURE GetNetwState ( NwLu : word ;                           VAR NetworkStateTbl : A6W ;                           VAR error    : word $                       ) ; forward ;                     {M19 BG 19NOV86} $    $$skip_text on$                                           {M19 BG 09SEP86} $ PROCEDURE XNETtransfer ( VAR XNETentry       : XNETentrytype ;                           VAR VCoffset        ,                              error           : WORD                        ) ; forward; $skip_text off$     PROCEDURE XNETtransfer ( VAR NetwLu            : word ;                            VAR XNETinputbuff     : XNETibufftype ;                             VAR XNETreply         : XNETreplytype ;                           VAR error             : word                         ) ; forward ;     PROCEDURE VCentry_fetch (                        VAR LUnumbers : LUnumbers_type ;                        VAR TypeofVC  : VCtype         ;                        VAR VCentry   : VCentrytype    ;                         VAR VCoffset  ,                             Error     : WORD  ) ; VAR     Headervar   : HDRvartype  ;      Ptr, Offset : WORD ;     BEGIN         WITH Headervar, VCentry, PVCent, SVCent, POOLent DO     BEGIN #    {}  hdr_search ( Offset, lunumbers [ NetWlu ], Headervar, error ) ; #     {}      {}  LUnumbers [ NetWlu ] := CardWriteLUbyte ;       {}      {}  IF ( error = noerror ) THEN       {}  BEGIN       {}  {}  VCsearch ( Offset, Lunumbers [ SVCWlu ], TypeofVC,       {}  {}                                VCentry, Headervar ) ;       {}  {}  IF ( TypeofVC = Notfound )      {}  {}  THEN  error := invlunb      {}  {}  ELSE BEGIN      {}  {}  {}   { only meaningfull for SVC w /add }      {}  {}  {}  VCoffset := offset - XTBLSVCEntryLength ;       {}  {}  {}  IF ( TypeofVC = POOLSVCtype ) THEN      {}  {}  {}  BEGIN       {}  {}  {}  {}  VCoffset := 0 ;  Writelunumber := 0 ;       {}  {}  {}  {}           { move default CUG num    }      {}  {}  {}  {}  SVCCUGnb := SVChdr.POOLCUGnumber ;      {}  {}  {}  {}           { zero out remote net add }       {}  {}  {}  {}  FOR ptr := 1 TO 4 DO SVCaddr.W [ ptr ] := 0    
    {}  {}  {}  END  
     {}  {}  END       {}  END       END   END ;   
PROCEDURE VCsearch;  
 BEGIN       WITH HDRvar, NbofVcs, VCentry DO      BEGIN   
    VCLUtype := Notfound ; 
     
    IF ( VClunumber <> 0 ) 
     THEN  { search the type of VC associated to that LU }   !    {}BEGIN {............... PVC type of circuit ...............}  !     {}      {}  IF NXTVC_search ( Offset, NbofPVC, VCLunumber,      {}                    XTBLPVCentryLength, VCentry )       {}      {}  THEN                { it's a PVC type lu }      {}    VCLUtype := PVCtype       {}  #    {}  ELSE {.............. SVC W/ADD type of circuit .............}  #     {}      {}    IF NXTVC_search ( Offset, NbofSVC, VCLunumber,      {}                         XTBLSVCEntryLength, VCentry )      {}      {}    THEN              { it's a SVC with address type }      {}      VCLUtype := SVCtype       {}  $    {}    ELSE {............... POOL SVC type of circuit .............}  $     {}      {}      IF ( NbofPOOL <> 0 )      {}      THEN  
    {}        BEGIN  
     {}        {}  Get_POOLHDR_entry ( Offset, POOLent.SVChdr,   "    {}        {}                      XTBLPOOLSVCHeaderEntryLength,  " #    {}        {}                      XTBLPOOLSVCHeaderEntryLength ) ; #     {}        {}  !    {}        {}  IF NXTVC_search ( Offset, NbofPOOL, VCLunumber,  !      {}        {}                       XTBLPOOLSVCEntryLength ,        {}        {}                       VCentry )      {}        {}      {}        {}  THEN      { it's a POOL svc type }      {}        {}      VCLUtype := POOLSVCtype   
    {}        END ;  
     {}      {}      IF ( VCLUtype = Notfound )      {}              AND       {}         ( NbofPAD <> 0 )       {}      THEN  %    {}        BEGIN   {.............. PAD SVC type of circuit ...........} %     {}        {}      {}        {}  Get_PADHDR_entry ( Offset, PADent.PADhdr,   !    {}        {}                     XTBLPADSVCHeaderEntryLength,  ! "    {}        {}                     XTBLPADSVCHeaderEntryLength ) ; "     {}        {}       {}        {}  IF NXTVC_search ( Offset, NbofPAD, VCLunumber,       {}        {}                       XTBLPADSVCEntryLength,       {}        {}                       VCentry )      {}        {}      {}        {}  THEN      { it's a PAD SVC type }       {}        {}      VCLUtype := PADSVCtype  	    {}        END  	     {}END   { searching for a specific lu number }      $    ELSE                    { we just need POOL svc header information } $     
      IF ( NbofPOOL <> 0 ) 
       THEN          BEGIN           {}  Offset := Offset          {}              + NbofPVC * XTBLPVCEntryLength          {}              + NbofSVC * XTBLSVCEntryLength ;          {}          {}  Get_POOLHDR_entry ( Offset, POOLent.SVChdr,           {}                    XTBLPOOLSVCHeaderEntryLength,           {}                    XTBLPOOLSVCHeaderEntryLength ) ;          {}          {}  VCLUtype := POOLSVCtype           END       END   $SUBTITLE 'Check and move Net add & CUG'$   END;  FUNCTION NXTVC_search;  VAR       Found   : BOOLEAN ;       LUentry : WORD    ;       BEGIN   
    Found := false ; 
         WHILE ( ( Nbofvc > 0 ) AND NOT Found )      DO      BEGIN       {}  Get_AXTBL_word ( Offset, LUentry, VCentrylength, 1 ) ;      {}  NbofVC := NbofVC - 1 ;  #    {}      { relies on the fact that write LU number is always the }  #     {}          { first entry in any svc table }      {}  IF ( LUentry = VCLUnumber )       {}  THEN      {}      BEGIN   { reset pointer to beginning of table }       {}      {}  Offset := Offset - VCentrylength ;      {}      {}      { get the related entry }        {}      {}  Get_AVC_entry ( Offset, VCentry, VCentrylength,        {}      {}                  VCentrylength )  ;      {}      {}  found := true       {}      END       END ;       
    NXTVC_search := found  
     $SUBTITLE 'Search for a VC entry'$  END ;   PROCEDURE hdr_search;   VAR   
    NBofNet : WORD ; 
     BEGIN       WITH HDRvar, NbofVCs DO       BEGIN   
    {}  error := noerror ; 
     {}      {}  Offset := 8  ;      { get number of networks }      {}      {}  Get_AXTBL_word ( Offset, NBofnet, 1, 1 ) ;      {}      {}  IF ( NetworkWlu = 0 )       {}      AND   
    {}     ( NbofNet > 1 ) 
     {}  THEN { invalid LU number }      {}      error := NeedSN       {}  ELSE  	    {}      BEGIN  	     {}      {}          { get first network header }      {}      {}  NbofPVC  := 0 ; NbofSVC := 0 ;      {}      {}  NbofPOOL := 0 ; NbofPAD := 0 ;      {}      {}      {}      {}  Offset := XTBLGlobalentryLength ;       {}      {}      {}      {}  NXThdr_search ( Offset, HDRvar ) ;      {}      {}      {}      {}  IF ( NetworkWlu <> 0 )  
    {}      {}  THEN 
     {}      {}  BEGIN       {}      {}  {}  NbofNet := NbofNet - 1 ;  	    {}      {}  {} 	     {}      {}  {}  WHILE ( NbofNet <> 0 )      {}      {}  {}             AND      {}      {}  {}        ( NetworkWlu <> CardWriteLUbyte )       {}      {}  {}  DO      {}      {}  {}      BEGIN       {}      {}  {}          NXThdr_search ( Offset, HDRvar ) ;      {}      {}  {}          NbofNet := Nbofnet - 1      {}      {}  {}      END ;   	    {}      {}  {} 	     {}      {}  {}  IF ( NetworkWlu <> CardWriteLUbyte )      {}      {}  {}  THEN      {}      {}  {}      error := badNtwlu  	    {}      {}  END 	     {}     END     END  $SUBTITLE 'Search for Net LU'$  END; PROCEDURE Check_Net_and_Pool;    {CC 30Aug84}  {}  !{ This procedure is used to find the network LU corresponding to a !#{ given POOL LU: it is used by RPOOL and makes the Network LU parameter #{ optional in LUNumber.  { Input parameter: POOL LU #  { Output parameter: Network LU # {                   Error (0 if OK)  {}     VAR    Network,    Nb_of_Net,    Offset1,  
   Offset    : WORD; 
   Net_found : BOOLEAN;  
   HDRVar    : HdrVarType; 
    TypeofVC  : VCType; 
   SVCEntry  : VCEntryType; 
    BEGIN      
   Error := NoError; 
    Net_Found := False;     {First get number of networks configured}        Offset := 8 ; {Offset in XTBL to 'total number of networks'}     Get_AXTBL_word (Offset, Nb_of_Net, 1, 1);         Network := 1;  
   WITH HdrVar, NbOfVCs DO 
    BEGIN           WHILE (Network <= Nb_of_Net) AND (NOT Net_Found) DO       BEGIN              IF Network = 1          THEN           BEGIN  {Get first network header}                 NbOfPVC := 0; NbOfSVC := 0;             NbOfPOOL:= 0; NbOfPAD := 0;             Offset  := XTBLGlobalEntryLength;              END;               NxtHdr_Search (Offset, HdrVar); 
         Offset1 := Offset; 
 !{check now if there are any POOL LUs associated with this network} !     
         IF (NbOfPool = 0) 
          THEN TypeOfVC := NotFound "         ELSE VCSearch (Offset1, POOL_LU, TypeOfVC, SVCEntry,HDRVar); "    {Check now if the LU# corresponds to a POOL LU}               IF (TypeOfVC = NotFound) OR (TypeOfVC <> POOLSVCType)          THEN              Network := Network + 1          ELSE           BEGIN              Net_Found := TRUE;             Net_LU    := CardWriteLUByte;          END;      	      END; {WHILE} 	    %      IF NOT Net_Found THEN Error := InvLUNb; {could not find any net LU..} %%                                              {corresponding to this VC LU} %    END; {WITH} $SUBTITLE 'Search for next VC entry'$  END;  PROCEDURE NXThdr_search;     BEGIN  $    WITH HDRvar, NBofvcs DO      { compute offset to next header entry } $    BEGIN  &    {}  Offset := Offset +      { skip over PVC & SVC with address entries } &     {}      NbofPVC * XTBLPVCentryLength +      {}      NbofSVC * XTBLSVCentryLength ;      {}      {}  IF ( NbofPOOL <> 0 )      {}  THEN     {}      Offset := Offset + XTBLPOOLSVCheaderEntryLength  !    {}                       + NbofPOOL * XTBLPOOLsvcEntryLength ; !     {} 
    {}  IF ( NbofPAD <> 0 ) 
     {}  THEN      {}      Offset := Offset + XTBLPADSVCheaderEntryLength       {}                       + NbofPAD * XTBLPADSVCEntryLength ;       {}      {}  Get_HDRvar_entry ( Offset, HDRvar,      {}                     XTBLNetworkHeaderEntryLength,      {}                     HDRvarlength )       END   $SUBTITLE 'Search for a header entry'$  END;      
PROCEDURE NACUGcheckmove;  
 BEGIN       WITH Netaddcug, CUGnumbr, SVCentry, SVCent, SVCaddr DO     BEGIN  
        error := noerror ; 
             NACHK ( NetAddCug, error ) ;                  IF ( error = noerror )          THEN         BEGIN             IF NOT ( Netadd.W [ 1 ] = 0 )             THEN                   { Move to XNET entry }                 SVCaddr := Netadd ;                 IF NOT ( CUGnumbr.W < 0 )              THEN                 SVCCUGnb := B [ 2 ]         END          ELSE              IF ( error = - 1 )              THEN                  error := invneta              ELSE                  error := invcugn         END  END ; { NACUGcheckmove }     $SUBTITLE 'Enable Network for restart', page$  {+------------------------------------------------------+}  {!                                                      !}  {!  PROCEDURE EnablNetwork (                            !}  {!                 NWLU  : word   ;                     !}  {!             VAR error : word ) ;                     !}  {!                                                      !}  {!  error =  0  Network restart successful              !}  {!          -1  X.25/1000 subsystem inactive.           !}  {!          -2  unknown network                         !}  {!          -5  lack of resources to complete the req.  !}  {!              ( SAM or RN ).                          !}  {!          -99 Invalid request to XNET.                !}  {!                                                      !}  {!  added M19 BG 18NOV86                                !}  {+------------------------------------------------------+}      PROCEDURE EnablNetwork ;     VAR         XNETinputbuff   : XNETibufftype ;     XNETreply       : XNETreplytype ;     BEGIN        XNVFY ( error ) ;   { Verify that X.25 is active }        IF error <> 0 then  error := X25down    ELSE BEGIN    {}   {}  { Specify XNET special request code }    {}   {}  XNETinputbuff.XnetRequestCode := EnableNetw ;    {}  "  {}  { no additional parameter passed to  nor retreived from XNET } "   {}   {}  XNETtransfer ( NwLu { Lu of network to restart },    {}                 XNETinputbuff, XNETreply, error ) ;    {}   END ;      END ; { EnablNetwork }      $subtitle 'Get Network State', page$  {+------------------------------------------------------+}  {!                                                      !}  {!  PROCEDURE GetNetwState (                            !}  {!                 NwLu     : word ;                    !}  {!             VAR NetworkStateTbl : A6W ;              !}  {!             VAR error    : word                      !}  {!                  );                                  !}  {!                                                      !}  {!  Parameters returned in NetwStateTbl :               !}  {!    word 1 =  NetworkState                            !}  {!    word 2 =  total nb of established VCs             !}  {!    word 3 =  total nb of established PVCs            !}  {!    word 4 =  total nb of established SVC with addr.  !}  {!    word 5 =  total nb of established Pool SVCs       !}  {!    word 6 =  total nb of established PAD SVCs        !}  {!                                                      !}  {!    NetworkState = 0  state ready                     !}  {!                   1  state CardError                 !}  {!                   2  state HandShakeWithCard         !}  {!                  -1  state Unknown                   !}  {!                                                      !}  {!    If Error is not 0 all other entries are set to 0. !}  {!                                                      !}  {!  error =  0  Network restart successful              !}  {!          -1  X.25/1000 subsystem inactive.           !}  {!          -2  unknown network                         !}  {!          -5  lack of resources to complete the req.  !}  {!              ( SAM or RN ).                          !}  {!          -99 Invalid request to XNET.                !}  {!                                                      !}  {!  added M19 BG 18NOV86                                !}  {+------------------------------------------------------+}      PROCEDURE GetNetwState ;     VAR       XNETinputbuff   : XNETibufftype ;   XNETreply       : XNETreplytype ;     BEGIN        XNVFY ( error ) ;   { Verify that X.25 is active }        IF error <> 0 then  error := X25down    ELSE BEGIN    {}   {}  { Specify XNET special request code }    {}    {}  { no additional parameter passed to XNET }    {}   {}  XNETinputbuff.XnetRequestCode := GetNwState ;    {}   {}  XNETtransfer ( NwLu, XNETinputbuff,   {}                 XNETreply, error ) ;   END ;       IF  error = 0    then     begin       with  XNETreply.XNETobuff.obuf8  do       begin        {}       {}  NetworkStateTbl [1] := f_NetworkState ;       {}  NetworkStateTbl [2] := f_total_nb_established_VCs ;        {}  NetworkStateTbl [3] := f_total_nb_established_PVCs ;        {}  NetworkStateTbl [4] := f_total_nb_established_SVCwadd ;   !      {}  NetworkStateTbl [5] := f_total_nb_established_PoolSVCs ; !       {}  NetworkStateTbl [6] := f_total_nb_established_PADSVCs ;         {}  
      end ; { with } 
    end    else    { error <> 0 }     begin        {}         {}  NetworkStateTbl [1] := 0 ;  NetworkStateTbl [2] := 0 ;          {}  NetworkStateTbl [3] := 0 ;  NetworkStateTbl [4] := 0 ;          {}  NetworkStateTbl [5] := 0 ;  NetworkStateTbl [6] := 0 ;         {}     end ;      END ; { GetNetwState }     $SUBTITLE 'Transfer special request to XNET', page$   {**************************************************************}    {                                                              }    { PROCEDURE  XNETTRANSFER                                      }    {                                                              }    { Provide a mailbox access to submit special requests to XNET. }    { Two different Class I/O numbers are used :                   }    { - the XNET class number on which XNET is waiting for mail,   }    {   used to submit the request from the caller to XNET;        }    { - the XMOD class number used by XNET to return its reply to  }    {   the caller. The caller manages this class number.          }    { A Resource Number is allocated and used to synchronize the   }    { transfer and reply from XNET.                                }    { The entry buffer to XNET as well as the reply buffer,        }    { is a variant record whose format is a function of the        }    { special request code  which is the variant record tag field. }    {                                                              }    { parameters :                                                 }    {              VAR NetwLu            : word ;                  }    {              VAR XNETinputbuff     : XNETibufftype ;         }    {              VAR XNETreply         : XNETreplytype ;         }    {              VAR error             : word ;                  }    {                                                              }    { The different types are defined in XMDGB.PASI                }    {                                                              }    { Called from XINIT in XININ for shutdown                      }    {             XMOD  in XMDMD for GetPoolInfo, ReleasePool      }    {                                EnableNetw, GetNetworkState   }    {                   in XMDLI for GetNetworkState               }    {             X25LB in XLBGM for Al_Mod_Pool, InCalInfo        }    {                   in XLBMA for Al_Mod_Pool, DeallocatePool   }    {                                                              }    { Note : XPLOG has his own assembler routine to call XNET.     }    {                                                              }    {**************************************************************}       PROCEDURE XNETtransfer ;     CONST      !  Keepit =   8192 ;  { bit 13 : do not release XNET class number } !  nowait = -32768 ;  { bit 15 }    noabortB14 = 16384 ;  { bit 14 }  &  noabortB15 = -32768 ;  { bit 15 }                         {M18 BG 04NOV86} &  { funct 1 : assign class number ownership, for CLRQ }  &  funct  = 1 + nowait + noabortB14 ;                        {M19 BG 04NOV86} &  classiowrite      = 18 + noabortB15 ;   classiowriteread  = 20 + noabortB15 ;   classiogetcode    = 21 + noabortB15 ;  
  bitbucket         = 0  ; 
    $  RNallocatelock  = 10 + nowait ; { " 12B " local allocate; global lock } $  RNlock          = 02 ;          { " 02B " global lock }   RNdeallocate    = 32 ;          { " 40B " deallocate  }    noRNavailable   =  4 ;        XNETIP1          = 2 ;  { special request identifier }      TYPE        t_Xnetbufflength = array [ t_Xnet_request_code ] of word ;     CONST     %  XNETentrylength = t_XNETbufflength   { Length of special request buffer } %%                                       { passed to XNET.                  } %        [ { 0 : Enable Network ('RN') }       5 ,  !      { 1 : Allocate Pool/Modify SVC }    6 + XTBLSVCentrylength , ! !      { 2 : Get Pool Info ('DP') }        6 + XTBLSVCentrylength , ! !      { 3 : Release Pool  ('RP') }        6 + XTBLSVCentrylength , !      { 4 : Enable  Tracing }             5 ,       { 5 : Disable Tracing }             5 ,       { 6 : Get Incoming Call User Data } 7 ,       { 7 : Deallocate Pool (RPOOL) }     6 ,       { 8 : Get Network State ('GS') }    5 ,       { 9 : Shutdown }                    7   ] ;      &  XNETreplylength = t_XNETbufflength   { Length of buffer returned by XNET } & &                                       { upon special request completion.  } &         [ { 0 : Enable Network ('RN') }        2 ,        { 1 : Allocate Pool/Modify SVC }     3 ,        { 2 : Get Pool Info ('DP') }        13 , { 22 effectively }         { 3 : Release Pool  ('RP') }        13 , { 22 effectively }         { 4 : Enable  Tracing }              2 ,        { 5 : Disable Tracing }              2 ,        { 6 : Get Incoming Call User Data } 15 ,        { 7 : Deallocate Pool (RPOOL) }      2 ,        { 8 : Get Network State ('GS') }     8 ,        { 9 : Shutdown }                     2 ] ;     VAR        bufferlength ,    XNETclassnbr ,    XNETclass    ,    XMODclass    ,    SystemType   ,    Offset       ,    status       ,    A_reg        ,   B_reg        : WORD ;    XNETentry    : XNETentrytype ;         BEGIN       GTOPT ( SystemType ) ; { First check OpSys type }                           { if RTE-A then use UV to pass XnetIp1 }         WITH  XNETentry, XNETibuff  DO   BEGIN    {}    {}  error := norsrce ;    {}   {}  {-------------- get a resource number ------------}   {}  RNREQUEST ( RNallocatelock, resrcenumbr, status ) ;    {}    {}  if ( status <> noRNavailable )  then   {}  begin    {}   {}    {---- get a class number for xmod with no abort ----}    {}    XMODclass := 0 ;                    {M19 BG 04NOV86}    {}    A_reg := 0 ;                        {M19 BG 04NOV86}    {}    {}    ClassRequest ( funct, XMODclass ) ; {M19 BG 04NOV86}    {}   {}    begin  { no abort return for error processing }    {}      ABREG ( A_reg, B_reg ) ;   {}    end ;    {} !  {}    if ( A_reg = 0 ) then   { comes directly here if no error } !  {}    begin    {}    {} !  {}    {}  {-------- fill in XNET entry with control data -------} !!  {}    {}  {-------- subsystem security code and ----------------} !!  {}    {}  {-------- XNET mail box class number -----------------} !!  {}    {}  {-------- XMOD class number for XNET to reply --------} !   {}    {} !  {}    {}  offset := 0 ; { Get subsystem security code from XTBL } !   {}    {}   {}    {}  Get_AXTBL_word ( offset, Security_code, 1, 1 )  ;    {}    {}   {}    {}  offset := 2 ; { Get XNET class number from XTBL }    {}    {}   {}    {}  Get_AXTBL_word ( Offset, XNETclassnbr, 1, 1 )   ;    {}    {}   {}    {}  XMODclassnbr := XMODclass ;    {}    {} !  {}    {}  {-------- fill in XNET entry with user data ----------} !!  {}    {}  {-------- network write lu ---------------------------} !!  {}    {}  {-------- special request code -----------------------} !!  {}    {}  {-------- special request specific data --------------} !   {}    {}    {}    {}  NetworkWriteLu := NetwLu ;    {}    {}    {}    {}  { XNETibuff is a variant record, its first word, }    {}    {}  { the tag field is the special request code.     }  $  {}    {}  XNETibuff.XnetRequestCode := XNETinputbuff.XnetRequestCode ; $   {}    {}  XNETibuff := XNETinputbuff ;    {}    {}    {}    {}  {-------- transfer request to XNET --------}     {}    {}  A_reg := 0 ;                        {M19 BG 04NOV86}     {}    {}  bufferlength := XNETentrylength [ XNETRequestCode ] ;     {}    {}   {}    {}  if SystemType = RTE_A  then 	  {}    {}    begin 	  {}    {}      XNETclass := XNETclassnbr + nowait;  "  {}    {}      XLASSIO ( classiowriteread, bitbucket{control word}, "   {}    {}                XNETentry , bufferlength ,   {}    {}                XNETIP1, 0,    {}    {}                XNETclass, XNETIP1 ) ;    {}    {}   {}    {}      begin  { no abort return for error processing }   {}    {}        ABREG ( A_reg, B_reg ) ;     {M19 BG 07NOV86} 
  {}    {}      end ; 
   {}    {}   {}    {}    end    {}    {}  else 	  {}    {}    begin 	   {}    {}      XNETclass := XNETclassnbr + keepit + nowait;  "  {}    {}      CLASSIO ( classiowriteread, bitbucket{control word}, "   {}    {}                XNETentry , bufferlength ,   {}    {}                XNETIP1, 0,   {}    {}                XNETclass ) ;    {}    {}   {}    {}      begin  { no abort return for error processing }   {}    {}        ABREG ( A_reg, B_reg ) ;     {M19 BG 07NOV86} 
  {}    {}      end ; 
   {}    {} 	  {}    {}    end ; 	   {}    {}   {}    {}  if ( A_reg = 0 ) then   {}    {}  begin    {}    {}  {}   {}    {}  {}  {------ suspend on lock request ------}   {}    {}  {}  {------ synchronization with XNET ----}   {}    {}  {}  RNREQUEST ( RNlock, resrcenumbr, status ) ;    {}    {}  {}    {}    {}  {}  {-------- deallocate resource number --------}    {}    {}  {}  RNREQUEST ( RNdeallocate, resrcenumbr, status ) ;     {}    {}  {} #  {}    {}  {}  {-------- get XNET reply nowait/release class --------} # "  {}    {}  {}  A_reg := 0 ;                        {M19 BG 04NOV86} ""  {}    {}  {}  bufferlength := XNETreplylength [ XNETRequestCode ] ; "   {}    {}  {}    {}    {}  {}  CLASSIOGET ( classiogetcode, XMODclassnbr,    {}    {}  {}               XNETreply, bufferlength ) ;    {}    {}  {}   {}    {}  {}  begin  { no abort return for error processing }   {}    {}  {}    ABREG ( A_reg, B_reg ) ;     {M19 BG 07NOV86} 
  {}    {}  {}  end ; 
   {}    {}  {}    {}    {}  {}  if  A_reg >= 0  then    {}    {}  {}  begin  { XNET succeeded in sending reply }   {}    {}  {}  {}     { process XNET reply }  	  {}    {}  {}  {} 	  {}    {}  {}  {}  error := XNETreply.W1 ;  	  {}    {}  {}  {} 	   {}    {}  {}  end { Process XNET return data }    {}    {}  END { A-reg check upon Xnet transfer success }    {}    END { A-reg check upon class number allocation }    {}  END { status check upon resource number allocation }    END { with XNETentry }  END ; { XNETTRANSFER } { end XLBUT }  .  