&{***************************************************************************} & $PASCAL '91751-1X044 REV.5020 <891113.1753>' &{***************************************************************************} &&{                                                                           } &&{      FILE:   XINUT.PAS                                                    } &&{      SOURCE: 91751-18044                                                  } &&{      RELOC.: 91751-1X044                                                  } &&{                                                                           } &&{  ***************************************************************          } &&{  * (C) COPYRIGHT HEWLETT-PACKARD COMPANY 1982.  ALL RIGHTS     *          } &&{  * RESERVED.  NO PART OF THIS PROGRAM MAY BE PHOTOCOPIED,      *          } &&{  * REPRODUCED OR TRANSLATED TO ANOTHER PROGRAM LANGUAGE WITHOUT*          } &&{  * THE PRIOR WRITTEN CONSENT OF HEWLETT-PACKARD COMPANY.       *          } &&{  ***************************************************************          } &&{                                                                           } &&{---------------------------------------------------------------------------} &&{                                                                           } &&{ Contains the following procedures and functions :                         } &&{                                                                           } &&{  - CONT_ABORT             - CN35             - ADEQT_ENTRY                } &&{  - DIALOG                 - CN34             - SWITCH_PARM                } &&{  - EXEC_ERROR             - CN33             - FLOW_CNTRL_QS              } &&{  - CLASSMNGMT             - CN30             - CU_MRC_ARC                 } &&{  - XINHALT                - CN27             - DVXDFLT_CONF               } &&{  - LU_VERIFY              - CN26             - DVXANSWER                  } &&{  - NET_ADD_VERIFY         - CN20                                          } &&{  - CNTRL                  - CN11                                          } &&{  - XLCNTRL                - CN10                                          } &&{                                                                           } &&{---------------------------------------------------------------------------} &&{                                                                           } &&{ History :                                                                 } &&{   original version                  Rev 2201                              } &&{   revision #1                       Rev 2226                              } &&{     .support of RTE-A1                                                    } &&{   revision #2                       Rev 2326                              } &&{     .support of RTE-A                                                     } &&{   revision #3                       Rev 2401                              } &&{     .user accessible Q-bit data packet                                    } &&{     .flow control enhancement                                             } &&{   revision #4                       Rev 2440                              } &&{     .new PASCAL support                                                   } &&{     .new file management support                                          } &&{     .enhance test on LU_EQT_ent table access                              } &&{      in LU_VERIFY function. (MG 13Feb85)                                  } &&{   revision #5                       Rev 5.0    (BG)                       } &&{     .Add a $ char. after $include to prevent listing truncation.          } &&{     .Change the CN10 set timer function to operate only on the            } &&{      read LU.                                   (M18)                     } &&{     .Add the control CN26 flush read data. (M19)                          } &&{     .Add the control CN32 close line.  (M19)                              } &&{     .correct the no abort error processing. (M25)                         } &&{     .Moved function ClassMngmt from XININ. (M31)                          } &&{   revision #6                       Rev 5.1    (BG)                       } &&{     .Added comments.                                                      } &&{   revision #7                       Rev 5.2    (BG)                       } &&{     .Add control request 27B 'set program address'.  (M78)                } &&{                                                                           } &&{***************************************************************************} &    $STANDARD_LEVEL 'HP1000'$  $SUBPROGRAM$ $AUTOPAGE ON, HEAP 1, LINESIZE 80, RECURSIVE OFF$ $CDS OFF$  	$HEAP_DISPOSE OFF$ 	     PROGRAM XINUT (Answer_file);     { includes XTBLG.PASI, XTBLV.PASI, XINGB.PASI }  $LIST OFF$  $INCLUDE 'XTBLG.PASI'$  $INCLUDE 'XTBLV.PASI'$  $INCLUDE 'XINGB.PASI'$     $LIST ON$ $TITLE 'XINIT utility procedure', PAGE$      #{----------------------- RTE PROCEDURE ------------------------------} #     {@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@}      PROCEDURE CONTROL_REQUEST $ALIAS 'XLUEX', NOABORT$         ( Control_code  :   ONEWORD     ;           Control_word  :   WORDARRAY2  ;           Option_word   :   ONEWORD     ;      VAR  Control_class :   ONEWORD   ) ;              EXTERNAL ;      {@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@}      PROCEDURE XLCNTRL_REQUEST $ALIAS 'XLUEX', NOABORT$         ( Control_code  :   ONEWORD     ;            Control_word  :   WORDARRAY2  ;             Option_word1  :   ONEWORD     ;        VAR  Control_class :   ONEWORD     ;   
          Option_word2  ,  
           Option_word3  :   ONEWORD   ) ;               EXTERNAL ;      {@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@}      PROCEDURE CONTROL_GET     $ALIAS 'EXEC'$          ( Get_code  , Get_class,            Get_buff  , Get_bufl ,            Get_opt1  , Get_opt2 : ONEWORD ) ;              EXTERNAL ;      {@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@}  $PAGE$          {@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@}      PROCEDURE ABREG ( VAR A_reg ,                         B_reg : ONEWORD  ) ;              EXTERNAL ;      {@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@}      FUNCTION KCVT ( VAR number : ONEWORD  )   
              : ONEWORD ;  
             EXTERNAL ;      {@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@}      PROCEDURE AUREVOIR $ALIAS 'EXEC'$            ( exit_code, exit_type : ONEWORD ) ;               EXTERNAL ;      {@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@}     PROCEDURE ManageClassNumber $ALIAS 'CLRQ', NOABORT$             (   Functioncode  : ONEWORD ;             VAR class_number  : ONEWORD ;                 Parameter1    : ONEWORD ) ;                 EXTERNAL;                                {M31 BG 18FEB87}  {@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@}  $PAGE$  &{---------------------  XINIT PROCEDURES ----------------------------------} &    {@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@}     PROCEDURE MESS_WRITER ( msg_type : Xinit_msg_type ;                             msg  : Xinit_msg_list ;                              val  : TwoWord      {CC 23Nov82}                       ) ;              EXTERNAL ;      {@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@}       {@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@}       PROCEDURE EQCHK    ( VAR lueqtnum : ONEWORD ;                         VAR eqtadd   : ONEWORD                      ) ;               EXTERNAL ;      {@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@}       {@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@}       PROCEDURE Test_line_count ; $DIRECT$              EXTERNAL ;      {@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@}       PROCEDURE EndLine ; $DIRECT$              EXTERNAL ;      {@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@}       {@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@}      PROCEDURE QUEST_ANSWER ( prmpt : Xinit_msg_list ;                          anschk : answer_check_list ;                      VAR answr : Reply_type  
                       ) ; 
 
                EXTERNAL ; 
    {@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@}      $TITLE 'Misc. utility procedures', PAGE$ &{+-------------------------------------------------------------------------!} &&{!} PROCEDURE CONT_ABORT ( VAR err_path : poss_return_type ) ; $DIRECT$   {!} &&{+-------------------------------------------------------------------------+} &     ${ CONT_ABORT is called to set the ERR_PATH variable and help decide    } $ ${ whether XINIT should halt, which is the case if 'abort' is returned. } $ ${ Abort is true if options 'error' and 'interactive' are both not set. } $ ${ Unsatisfied questions will be repeated if CONT_ABORT returns 'none'. } $ ${ Enable_error_mode option will set DIALOG true and allow for output   } $ ${ of error messages at the console.                                    } $    BEGIN      err_path := none ;      update_answer_file := true ;          IF ( error IN Run_option )  $    THEN Run_option := Run_option + Run_option_set [ enable_error_mode ] $ "    ELSE IF NOT ( interactive IN Run_option ) THEN err_path := abort " $AUTOPAGE OFF$  END;  {+------------------------------------------!}  {!} FUNCTION DIALOG : BOOLEAN ;  $DIRECT$  {!}  {+------------------------------------------+}     "{ DIALOG is tested in MESS_WRITER for allowing error messages to be } ""{ output onto the console.                                          } "    BEGIN 
    DIALOG := false ; 
     IF ( interactive       IN Run_option )          OR         ( enable_error_mode IN Run_option )          OR         ( echo              IN Run_option )     THEN DIALOG := true ; END ;      {+----------------------------------------------------+}  {!} PROCEDURE EXEC_ERROR ( A_reg, B_reg : oneword  ; {!}  {!}                        lunumber : oneword ) ;    {!}  {!                                                    !}  {!  called from XINUT, XINNG, XININ modules.          !}  {+----------------------------------------------------+}      TYPE Reg_type = RECORD                   CASE Boolean OF                     true  : ( W : ONEWORD ) ;                     false : ( S : STRING2 ) ;                   END ;      VAR  Areg, Breg : Reg_type ;     BEGIN        $skip_text on$                        {M25 BG 06JAN87}      ABREG ( A_reg.W, B_reg.W ) ;  	   $skip_text off$ 	    Areg.W := A_reg ;   Breg.W := B_reg ;      writeln ( Output_lu )  ; #    write   ( Output_lu, space :10, 'EXEC ERROR : ', Areg.S, Breg.S ) ; #
    if  lunumber <> 0  then 
 #      writeln ( Output_lu, space :4, 'ON LU NUMBER : ', lunumber : 3 ) #     else        writeln ( Output_lu )  ;  { close line }     writeln ( Output_lu )  ;  { skip a line }      IF ( List IN Run_option ) THEN %    write ( List_file, comment, space:9,'EXEC ERROR : ', Areg.S, Breg.S ) ; %
    if  lunumber <> 0  then 
 "      write ( List_file, space:4,'ON LU NUMBER : ', lunumber : 3 ) ; "
    Test_line_count ; 
    END ;      $SUBTITLE 'CLRQ class Management', PAGE$ "{*******************************************************************} ""{                                                                   } ""{   FUNCTION   CLASSMNGMT    -   CLRQ                               } ""{                                                                   } ""{   Allocates and deallocates Class Numbers.                        } ""{                                                                   } ""{   Returns FALSE if an error occured along with a message index.   } ""{                                                                   } ""{*******************************************************************} "    FUNCTION ClassMngmt ( FUNC : FunctionType ;                       var ClassNumber : ClassNumberType ;                       var msgind : XINIT_msg_list ) : boolean ;     VAR   NoError : boolean ;     BEGIN          ClassMngmt := true ; 
    NoError := true ; 
         {+---------------------------------------------}      ManageClassNumber ( FUNC.W, Classnumber.W, 0 ) ;      {+---------------------------------------------}     begin { no abort error processing }        ABREG ( A_reg, B_reg ) ;       exec_error ( A_reg, B_reg , 0 ) ;        NoError := false ;      end ; { end of no abort error processing }          ABREG ( A_reg, B_reg ) ;      { Good return  }         if ( not NoError or ( A_reg <> 0 ))  then     begin     
      ClassMngmt := false ; 
          if ( FUNC.F.Func = 1 )       { Allocate Class Number  }         then Msgind := NOCLavail     { No Class Number available }         else Msgind := CLRQerror ;   { error on deallocation }         end ;     END ; { function ClassMngmt }  $page$   {+------------------------------------------------------------+}    {!} PROCEDURE XINHALT ( msgind : XINIT_msg_list ) ; $DIRECT$ {!}    {+------------------------------------------------------------+}      CONST 	    exit_code = 6 ; 		    exit_type = 0 ; 	    BEGIN     IF NOT ( msgind = noerr )     THEN MESS_WRITER ( ermsg, msgind, 0 ) ;          MESS_WRITER ( fullmsg, exitxinit,0 )  ;           close ( Input_lu ) ; close ( Output_lu ) ;      #    IF NOT ( Interactive IN Run_option ) THEN close ( answer_file ) ;  #         IF ( List IN Run_option )       THEN BEGIN  #        IF NOT ( Listnocctl IN Run_Option ) THEN Page ( List_file ) ;  #         close ( List_file ) END ;           AUREVOIR ( exit_code, exit_type )   $TITLE 'VERIFY LU & EQT NUMBERS'$  $AUTOPAGE ON$  END; &{+-------------------------------------------------------------------------!} &&{!                                                                         !} &&{!      }   FUNCTION LU_VERIFY ( VAR lueqtnum : ONEWORD ;           {      !} &&{!      }                        VAR eqtadd   : ONEWORD             {      !} &&{!      }                      ) : BOOLEAN ;                        {      !} &&{!                                                                         !} &&{+-------------------------------------------------------------------------+} & VAR  ptr : ONEWORD ;  goodlu : BOOLEAN ;  msgid  : err_msg_list ;  BEGIN          
WITH LU_EQT_table DO 
  BEGIN   IF ( next_free > max_num_of_lu ) THEN XINHALT ( lutbover );    WITH LU_EQT_ent [ next_free ] DO     BEGIN     %    $SKIP_TEXT ON$                                             {MG 13Feb85} %%    {This test should be performed before the WITH}            {MG 13Feb85} %%    {statement is invoqued otherwise we may access over the }  {MG 13Feb85} %%    {LU_EQT_ent table limit an thus abort this program....  }  {MG 13Feb85} % "    {}  IF ( next_free > max_num_of_lu ) THEN XINHALT ( lutbover ) ; "%    $SKIP_TEXT OFF$                                            {MG 13Feb85} %         {}  goodlu := true ; Lunum := Lueqtnum ; ptr:= 1 ;      {}      {}  WHILE ptr < next_free DO      {}  IF LUnum <> LU_EQT_ent [ ptr ].LUnum 
    {}  THEN ptr := ptr + 1 
     {}  ELSE "    {}  BEGIN ptr := next_free; goodlu := false; msgid := duplu END ; "     {}      {}  IF goodlu AND NOT ( prep IN Run_option )      {}  THEN     {}  BEGIN        { get eqt number and eqt address }      {}  {}  EQCHK ( lueqtnum, eqtadd ) ; 
    {}  {}  IF lueqtnum = 0 
     {}  {}  THEN BEGIN  msgid := inveqt ; goodlu := false  END      {}  {}  ELSE      {}  {}  BEGIN  eqtnum := lueqtnum ; ptr := 1 ;      {}  {}  {}      {}  {}  {}  WHILE ptr < next_free DO      {}  {}  {}  IF EQTnum <> LU_EQT_ent [ ptr ].EQTnum     {}  {}  {}  THEN ptr := ptr + 1  
    {}  {}  {}  ELSE 
 &    {}  {}  {}  BEGIN ptr := next_free; goodlu := false; msgid := dupeqt END &    {}  {}  END      {}  END ELSE lueqtnum := 0 ;     {}  IF goodlu     {}  THEN next_free := next_free + 1 #    {}  ELSE BEGIN Lueqtnum := 0 ; MESS_WRITER ( ermsg, msgid, 0 )  END #    END ; %  END;                                                         {MG 13Feb85} %	LU_VERIFY := goodlu 	 $TITLE 'VERIFY NETWORK ADDRESS'$ END ; &{+-------------------------------------------------------------------------!} &&{!                                                                         !} &&{!      }   FUNCTION NET_ADD_VERIFY ( netadd   : Net_add_entry_type {      !} &&{!      }                           ) : BOOLEAN ;                   {      !} &&{!                                                                         !} &&{+-------------------------------------------------------------------------+} &    VAR 	    ptr : ONEWORD ; 	    goodadd : BOOLEAN ;     BEGIN 
    goodadd := true ; 
     WITH Net_add_table      DO     BEGIN  	    {}  ptr := 1 ; 	     {}  WHILE ptr < next_free DO     {}  BEGIN      {}      IF ( netadd [ 1 ]  <> Net_add [ ptr, 1 ] )  	    {}          OR 	     {}         ( netadd [ 2 ]  <> Net_add [ ptr, 2 ] )      {}      THEN      {}          ptr := ptr + 1      {}      ELSE 
    {}          BEGIN 
     {}              ptr := next_free ;      {}              goodadd := false ; 
    {}          END ; 
    {}  END ;      {}  	    {}  IF goodadd 	     {}  THEN     {}      BEGIN     {}          Net_add [ next_free, 1 ] := 0 ;     {}          Net_add [ next_free, 2 ] := 0 ;     {}          Net_add [ next_free ] := netadd ;      {}          next_free := next_free + 1 ;      {}          NET_ADD_VERIFY := true ;     {}      END      {}  ELSE     {}      BEGIN      {}          MESS_WRITER ( ermsg, dupnad, 0 ) ;     {}          NET_ADD_VERIFY := false     {}      END     END  $TITLE 'RTE-VI CONTROL REQUEST'$ END ; &{+-------------------------------------------------------------------------!} &&{!                                                                         !} &&{!      }   FUNCTION CNTRL                                          {      !} &&{!      }                      ( function_code : ONEWORD ;          {      !} &&{!      }                            lunumber : ONEWORD ;           {      !} &&{!      }                            opt1     : ONEWORD ;           {      !} &&{!      }                        VAR Breg     : ONEWORD             {      !} &&{!      }                      ) : BOOLEAN ;                        {      !} &&{!                                                                         !} &&{!  Called for CN10, CN11, CN20, CN26, CN27, CN30, CN33, CN34, CN35        !} &&{!                                                                         !} &&{!  Modified no abort error processing. (M25 BG 06FEB87)                   !} &&{!  Modified transmission log parameter return. (M25 BG 13FEB87)           !} &&{+-------------------------------------------------------------------------+} &    CONST          no_wait_bit = no_abort_bit  ;   { Bit 15 set }     CN_code = 19 + no_abort_bit ;     GT_code = 21                ;     VAR         cntrl_word : WORDARRAY2 ;      CN_class, dummy1, dummy2, dummy3, dummy4 : ONEWORD ;     noabort_error : boolean ;     BEGIN          CNTRL := true ;  Breg := 0 ;     CN_class := no_wait_bit { + 0 } ;                                      { True LU number if RTE_VI }     cntrl_word [ 2 ] := function_code ;     cntrl_word [ 1 ] := lunumber + Nonsession ;      noabort_error := false ;      {+-------------------------------------------------------------+}   {!} CONTROL_REQUEST ( CN_code, cntrl_word, opt1, CN_class ) ; {!}   {+-------------------------------------------------------------+}   #    BEGIN  { no abort error return, will be skipped if normal return } #     {}     {} ABREG ( A_reg, B_reg ) ;      {} exec_error ( A_reg, B_reg, lunumber ) ;      {} noabort_error := true ;      {}      END ;  { end of noabort error processing }         ABREG ( A_reg, B_reg ) ; { here if it was a normal return }                                                   {M25 BG 13FEB87}      if  not noabort_error  then           begin              if        A_reg = -1   then  XINHALT ( NOCLavail )         else  if  A_reg < -1   then  XINHALT ( outofSAM ) ;      
        { else A_reg >=0 } 
    "        CN_class := CN_class - no_wait_bit ;  { class get with wait } "    %        {+---------------------------------------------------------------+} %%        CONTROL_GET ( GT_code, CN_class, dummy1, dummy2, dummy3, dummy4 ) ; %%        {+---------------------------------------------------------------+} %             ABREG ( A_reg, B_reg ) ;             If  OpsysType = RTE_VI  then  Breg := B_reg ; #        If  OpsysType = RTE_A   then  Breg := dummy4 ; {M25 BG 13FEB87} #           end { if }      !    else  CNTRL := false ;                        {M25 BG 13FEB87} !    $TITLE 'RTE-A CONTROL REQUEST'$ END ;     &{+-------------------------------------------------------------------------!} &&{!                                                                         !} &&{!      }   FUNCTION XLCNTRL  ( function_code ,                     {      !} &&{!      }                            lunumber ,                     {      !} &&{!      }                            opt1     ,                     {      !} &&{!      }                            opt2     ,                     {      !} &&{!      }                            opt3     : ONEWORD             {      !} &&{!      }                      ) : BOOLEAN ;                        {      !} &&{!                                                                         !} &&{!  Function called for CN20, CN40, CN50.                                  !} &&{!                                                                         !} &&{!  Modified no abort error processing. (M25 BG 06FEB87)                   !} &&{!                                                                         !} &&{+-------------------------------------------------------------------------+} &    CONST          no_wait_bit = no_abort_bit ;     CN_code = 19 + no_abort_bit ;  	    GT_code = 21 ; 	    VAR     cntrl_word : WORDARRAY2 ;      CN_class, dummy1, dummy2, dummy3, dummy4 : ONEWORD ;     noabort_error : boolean ;     BEGIN         XLCNTRL := true ; CN_class := no_wait_bit { + 0 } ;     cntrl_word [ 2 ] := function_code ;     cntrl_word [ 1 ] := lunumber + Nonsession ;      noabort_error := false ;      &{+------------------------------------------------------------------------+} & &{!} XLCNTRL_REQUEST ( CN_code, cntrl_word, opt1, CN_class, opt2, opt3 ) ;{!} & &{+------------------------------------------------------------------------+} & #    BEGIN  { no abort error return, will be skipped if normal return } #     {}     {} ABREG ( A_reg, B_reg ) ;      {} exec_error ( A_reg, B_reg, lunumber ) ;      {} noabort_error := true ;      {}      END ;  { end of noabort error processing }         ABREG ( A_reg, B_reg ) ; { here if it was a normal return }                                                   {M25 BG 13FEB87}      if  not noabort_error  then           begin              if        A_reg = -1   then  XINHALT ( NOCLavail )         else  if  A_reg < -1   then  XINHALT ( outofSAM ) ;     
        { else A_reg >= 0 } 
     "        CN_class := CN_class - no_wait_bit ; { class get with wait } "    $        {+-------------------------------------------------------------+} $%        CONTROL_GET ( GT_code, CN_class, dummy1, dummy2, dummy3, dummy4 ) ; %$        {+-------------------------------------------------------------+} $          end  { if }          else  XLCNTRL := false ;              {M25 BG 13FEB87}      $SUBTITLE 'LAP_B reset Control request'$  END;      {+----------------------------------------------------!}  {!} FUNCTION CN35 ( lunumber : ONEWORD ) : BOOLEAN ; {!}  {+----------------------------------------------------+}     CONST         CN35_code =  1856 ;   { CN 35B  }     RS_code   = 21075 ;   { 'RS'    }     VAR      dummy  : ONEWORD ;      goodlu : BOOLEAN ;     BEGIN  
    goodlu := true ; 
     IF NOT ( prep IN Run_option )       THEN          IF NOT CNTRL ( CN35_code, lunumber, RS_code, dummy )          THEN              goodlu := false ;       
    CN35 := goodlu ; 
 	    IF NOT goodlu  	     THEN          MESS_WRITER ( ermsg, CN35failed, 0 )  $SUBTITLE 'DVX00 PORT configuration'$   END;  !{+-------------------------------------------------------------!}  ! !{!} FUNCTION CN34 ( lunumber, LUtype : ONEWORD ) : BOOLEAN ;  {!}  ! !{+-------------------------------------------------------------+}  ! CONST       CN34_code = 1792 ;   { CN 34B  }      VAR       B_reg : ONEWORD  ;      goodlu : BOOLEAN ;      BEGIN   
    goodlu := true ; 
     IF NOT ( prep IN Run_option )       THEN          IF CNTRL ( CN34_code, lunumber, lutype, B_reg ) THEN          BEGIN           {}  IF NOT ( B_reg = security_code )          {}  THEN          {}          goodlu := false           END           ELSE              goodlu := false ;       
    CN34 := goodlu ; 
 	    IF NOT goodlu  	     THEN          MESS_WRITER ( ermsg, CN34failed, 0 )      $SUBTITLE 'DVX00, DVM00 DRIVER CNFGN'$  END;  ${+--------------------------------------------------------------------!} $ ${!} FUNCTION CN33 ( lunumber, DVMconf_option : ONEWORD ) : BOOLEAN ; {!} $ ${+--------------------------------------------------------------------+} $CONST      CN33_code = 1728 ;  { CN 33B }     VAR 
    dummy : ONEWORD ; 
    BEGIN  	    CN33 := true ; 	        IF NOT ( prep IN Run_option )      THEN  $        IF NOT CNTRL ( CN33_code, lunumber, DVMconf_option, dummy ) THEN $        BEGIN 
            CN33 := false ; 
             MESS_WRITER ( ermsg, CN33failed, 0 )         END $SUBTITLE 'CLOSE LINE'$ END ;  {+----------------------------------------------------!}  {!} FUNCTION CN32 ( lunumber : ONEWORD ) : BOOLEAN ; {!}  {+----------------------------------------------------+}  CONST                             {added M19 BG 04NOV86}      CN32_code = 1664 ;  { CN 32B }     VAR      dummy2 : ONEWORD ;     BEGIN      	    CN32 := true ; 	        IF NOT ( prep IN Run_option )      THEN        IF NOT CNTRL ( CN32_code, lunumber, security_code, dummy2 )         THEN BEGIN         CN32 := false ;          MESS_WRITER ( ermsg, CN32failed, 0 )       END ; $SUBTITLE 'DVM00 PORT CONFIGURATION'$ END ;   {+------------------------------------------------------------!}    {!} FUNCTION CN30 ( lunumber, Lutype : ONEWORD ) : BOOLEAN ; {!}    {+------------------------------------------------------------+}  CONST      CN30_code = 1536 ;  { CN 30B }     VAR 
    B_reg : ONEWORD ; 
     goodlu : BOOLEAN ;      BEGIN   
    goodlu := true ; 
         IF NOT ( prep IN Run_option )       THEN          IF CNTRL ( CN30_code, lunumber, lutype, B_reg ) THEN          BEGIN           {}  IF NOT ( B_reg = security_code )          {}  THEN          {}      goodlu := false ;          END          ELSE             goodlu := false ;      
    CN30 := goodlu ; 
        IF NOT goodlu      THEN          MESS_WRITER ( ermsg, CN30failed, 0 ) END ;  $SUBTITLE 'SET PROGRAM ADDRESS'$  !{+--------------------------------------------------------------!} ! !{!} FUNCTION CN27 ( lunumber, IDnumber : ONEWORD ) : BOOLEAN ; {!} ! !{+--------------------------------------------------------------+} ! !CONST                                       {added M78 BG 13NOV89} !     CN27_code = 1472 ;  { CN 27B }     VAR      dummy2 : ONEWORD ;     BEGIN      	    CN27 := true ; 	        IF NOT ( prep IN Run_option )      THEN        IF NOT CNTRL ( CN27_code, lunumber, IDnumber, dummy2 )        THEN BEGIN         CN27 := false ;          MESS_WRITER ( ermsg, CN27failed, 0 )       END ; END ;  $SUBTITLE 'FLUSH READ DATA'$  {+----------------------------------------------------!}  {                                                      }  {!} FUNCTION CN26 ( lunumber : ONEWORD ) : BOOLEAN ; {!}  {                                                      }  {   flush the network read lu number !                 }  {                               added M19 BG 05DEC86   }  {+----------------------------------------------------+}     CONST          CN26_code = 1408 ;  { CN 26B } VAR      dummy2 : oneword ;     BEGIN      	    CN26 := true ; 	        IF NOT ( prep IN Run_option )      THEN     BEGIN        IF NOT CNTRL ( CN26_code, Lunumber, security_code, dummy2 )           THEN           BEGIN           {}  CN26 := false ;            {}  MESS_WRITER ( ermsg, CN26failed, 0 )           END ;     END ;  END;  $SUBTITLE 'ENABLE PROGRAM SCHEDULING'$  #{+------------------------------------------------------------------+} # #{!} FUNCTION CN20 ( lunumber : ONEWORD ; DVXconf : DVX00_conf_type {!} # #{!}               ) : BOOLEAN ;                                    {!} # #{+------------------------------------------------------------------+} #    CONST      CN20_code = 1024 ;  { CN 20B }      CN40_code = 2048 ;  { CN 40B }      zero_char = '0'  ;      TYPE      Workrec_type = PACKED RECORD          CASE BOOLEAN OF           true  : ( W : ONEWORD ) ;           false : ( S : STRING2 )       END ;       VAR       Workrec : Workrec_type ;      dummy1  ,       dummy2  : ONEWORD ;       BEGIN   	    CN20 := true ; 	         IF NOT ( prep IN Run_option )          AND         NOT ( Dvxconf.ensched = nosched )      THEN          IF ( opsystype = RTE_VI ) THEN          BEGIN   #        {}  IF NOT CNTRL ( CN20_code, lunumber, dummy1, dummy2 ) THEN  # 	        {}  BEGIN  	         {}  {}  CN20 := false ;           {}  {}  MESS_WRITER ( ermsg, CN20failed, 0 )          {}  END           {}          END ELSE    { RTE_A CN20 processing }  { CC 7/83 }          BEGIN           {}  IF ( DVXconf.ensched = defltsched )           {}  THEN          {}      WITH Dvxconf DO           {}      IF ( primary.WA [ 1 ] <> 0 ) THEN           {}      BEGIN   { convert lu number to ASCII }          {}      {}  Workrec.W := KCVT ( Lunumber ) ;  !        {}      {}  IF ( lunumber < 10 )  { change space to zero } !         {}      {}  THEN Workrec.S [ 1 ] := zero_char ;            {}      {}      { rename primary program XXXXX : XXXlu }           {}      {}  primary.S [ 4 ] := workrec.S [ 1 ] ;          {}      {}  primary.S [ 5 ] := workrec.S [ 2 ] ;  	        {}      {} 	         {}      {}      IF ( Secondary.WA [ 1 ] <> 0 )  THEN          {}      {}      BEGIN   %        {}      {}      {}      { rename secondary program YYYYY : YYYlu } % !        {}      {}      {}  secondary.S [ 4 ] := workrec.S [ 1 ] ; !          {}      {}      {}  secondary.S [ 5 ] := workrec.S [ 2 ]           {}      {}      END           {}      END ;           {}          {}  WITH dvxconf DO           {}  IF NOT XLCNTRL ( CN20_code, lunumber,           {}                              primary.WA [ 1 ],           {}                              primary.WA [ 2 ],            {}                              primary.WA [ 3 ]  ) THEN   	        {}  BEGIN  	         {}  {}  CN20 := false ;           {}  {}  MESS_WRITER ( ermsg, CN20failed, 0 )  
        {}  END ELSE 
         {}  IF NOT XLCNTRL ( CN40_code, lunumber,           {}                              secondary.WA [ 1 ],           {}                              secondary.WA [ 2 ],   !        {}                              secondary.WA [ 3 ] ) THEN  ! 	        {}  BEGIN  	         {}  {}  CN20 := false ;           {}  {}  MESS_WRITER ( ermsg, CN40failed, 0 )          {}  END           END  { A CN20 processing }   { CC 7/83 }  $SUBTITLE 'DEFINE NETWORK BUFFER'$  END ;   !{+-------------------------------------------------------------!}  ! !{!} FUNCTION CN11 ( lunumber, buffadd : ONEWORD ) : BOOLEAN ; {!}  ! !{+-------------------------------------------------------------+}  ! CONST       CN11_code = 576 ;  { CN 11B }       VAR  
    dummy : ONEWORD ; 
    BEGIN  	    CN11 := true ; 	        IF NOT ( prep IN Run_option )      THEN  !        IF NOT CNTRL ( CN11_code, lunumber, buffadd, dummy )  THEN !        BEGIN 
        {}  CN11 := false ; 
         {}  MESS_WRITER ( ermsg, CN11failed, 0 )         END  END;  $SUBTITLE 'INITIALIZE TIMER T3'$  !{+--------------------------------------------------------------!} ! !{!} FUNCTION CN10 ( lunumber, timerval : ONEWORD ) : BOOLEAN ; {!} ! !{                                                                } ! !{   lunumber is the network write lu number !                    } ! !{   The CN10/50B is then issued to the network read lu number.   } ! !{                                                                } ! !{+--------------------------------------------------------------+} !    CONST     CN10_code =  512 ;  { CN 10B }   { For RTE-VI }     CN50_code = 2560 ;  { CN 50B }   { For A-series }     Subfunc   = 1280 ;  { 24xxB  }   { Subfunction code } VAR     iop1, 
    dummy : ONEWORD ; 
    BEGIN      	    CN10 := true ; 	        IF NOT ( prep IN Run_option )      THEN     BEGIN                            { compute IOP1 value }          iop1 := Subfunc + timerval ;     #                                                       {M18 BG 13OCT86} ##        lunumber := lunumber + 1;    { Has to be done on read lu only } #            IF ( opsystype = RTE_VI )  	        THEN BEGIN 	            IF NOT CNTRL ( CN10_code, Lunumber, iop1, dummy )              THEN             BEGIN             {}  CN10 := false ;              {}  MESS_WRITER ( ermsg, CN10failed, 0 )             END          END ELSE  #            IF NOT XLCNTRL ( CN50_code, Lunumber, iop1, dummy, dummy ) #             THEN             BEGIN             {}  CN10 := false ;              {}  MESS_WRITER ( ermsg, CN10failed, 0 )             END ;     END ;  END;  $TITLE 'ADD EQT IN NET QUEUE'$  $SUBTITLE ' '$  &{+------------------------------------------------------------------------+} & &{!} PROCEDURE ADEQT_ENTRY ( VAR newEQT_ptr :Xinit_eqt_entry_ptr_type ) ; {!} & &{+------------------------------------------------------------------------+} &BEGIN       WITH Xinit_gbl_entry, gbl_entry, curr_net_ptr^, Xinit_net DO      BEGIN     {}  neweqt_ptr^.next_eqt_ptr := NIL ;      {}     {}  IF ( eqt_head_ptr = NIL )      {}  THEN      {}      eqt_head_ptr := newEQT_ptr      {}  ELSE      {}      eqt_curr_ptr^.next_eqt_ptr := newEQT_ptr ;      {}      {}  eqt_curr_ptr := newEQT_ptr      END   $TITLE 'SWITCH UPPER & LOWER BYTE'$   END ;   "{+----------------------------------------------------------------+} " "{!} FUNCTION Switch_parm ( Oneword_value : ONEWORD ) : ONEWORD ; {!} " "{+----------------------------------------------------------------+} "         "{+----------------------------------------------------------------+} " "{!NOTE :                                                          !} " "{! The ZILOG  processor used on the LAP_B card has the peculiar   !} " "{! feature of reversing bytes in a double byte load. That is, the !} " "{! most significant Byte is put in the A register and the least   !} " "{! significant in the B register. This , forces us to switch the  !} " "{! two bytes of all the 16_bit word card parameters .........     !} " "{!                                                                !} " "{+----------------------------------------------------------------+} " VAR   	    temp : OCTET ; 	     LAP_B_parm : LAP_B_parm_type ;      BEGIN       WITH LAP_B_parm DO      BEGIN       {}  parm := Oneword_value ;       {}                  { switch half word around }       {}  temp           := halfparm [ 2 ] ;      {}  halfparm [ 2 ] := halfparm [ 1 ] ;      {}  halfparm [ 1 ] := temp ;      {}      {}  Switch_parm    := parm      END   $TITLE 'OFTEN ASKED QUESTIONS'$   $SUBTITLE 'FLOW CONTROL QUESTIONS'$   END;  &{+------------------------------------------------------------------------+} & &{!                                                                        !} & &{!  } PROCEDURE FLOW_CNTRL_QS (                                       {   !} & &{!  }                       VAR flqset  :  Flow_cntrl_Q_SET_type  ;   {   !} & &{!  }                           q1      :  prmpt_msg_list         ;   {   !} & &{!  }                           a1      :  Answer_check_list      ;   {   !} & &{!  }                       VAR PTW_tab :  PTWType                ;   {   !} & &{!  }                       VAR FAC_tab :  Facilitiestype         ;   {   !} & &{!  }                       VAR Max_PKSize : ONEWORD                  {   !} & &{!  }                         ) ;                                     {   !} & &{!                                                                        !} & &{+------------------------------------------------------------------------+} &     LABEL       100 ;       $BEGIN     { .... get PACKET size, WINDOW size, THROUGHPUT class ..... }  $ #            { ............... End to end confirmation ..............}  #         WITH answr, val, Xinit_gbl_entry, gbl_entry,           curr_net_ptr^, Xinit_net, PTW_tab, FAC_tab       DO      BEGIN       {}      {}  IF ( PS IN flqset )         { PACKET SIZE }       {}  THEN      {}      BEGIN   { get packet size }   #    {}      {}  {+--------------------------------------------------+} # #    {}      {}  {!                                                  !} # #    {}      {}  {!  }   QUEST_ANSWER ( q1, a1, answr ) ;        {   !} # #    {}      {}  {!                                                  !} # #    {}      {}  {+--------------------------------------------------+} #     {}      {}      {}      {}  CASE rep OF       {}      {}      again :       {}      {}          GOTO 100 ;      {}      {}      {}      {}      no    :       {}      {}        {}BEGIN       {}      {}        {}    Max_pksize := 0 ;       {}      {}        {}    IF NOT ( PSpc IN flqset )   #    {}      {}        {}    THEN    { do not ask that question again } #     {}      {}        {}        flqset := flqset  #    {}      {}        {}              - Flow_cntrl_Q_SET_type [ PS ] ; #     {}      {}        {}  #    {}      {}        {}    IF ( neg IN flqset )    { negociation ? }  #     {}      {}        {}    THEN      {}      {}        {}        PSbit := false ;      {}      {}        {}END ;       {}      {}      {}      {}      per_circuit :       {}      {}        {}BEGIN       { set PC flag }       {}      {}        {}    flqset := flqset  #    {}      {}        {}            + Flow_cntrl_Q_SET_type [ PSpc ] ; #     {}      {}        {}    Max_PKsize := 0 ;       {}      {}        {}END ;       {}      {}      {}      {}      ranking :   &    {}      {}        {}BEGIN       { set packet size for both directions }  &      {}      {}        {}            { PK size = log2 Of PKsize }       {}      {}        {}    OutPKTSize := rank [ 1 ] + 4  ;       {}      {}        {}    InPKTSize  := OutPKTSize ;      {}      {}        {}    Max_PKsize := num  [ 1 ] ;      {}      {}        {}      {}      {}        {}    IF NOT ( PSpc IN flqset )   #    {}      {}        {}    THEN    { do not ask that question again } #     {}      {}        {}        flqset := flqset  #    {}      {}        {}              - Flow_cntrl_Q_SET_type [ PS ] ; #     {}      {}        {}      {}      {}        {}    IF neg IN flqset      {}      {}        {}    THEN    { set negociation bit on }      {}      {}        {}        PSbit := true ;       {}      {}        {}      {}      {}        {}    IF  ( log = 2 )   !    {}      {}        {}    THEN    { set incomming packet size }  !     {}      {}        {}        BEGIN   !    {}      {}        {}            InPKTsize := rank [ 2 ] + 4 ;  ! !    {}      {}        {}            IF ( InPKTsize > OutPKTSize )  !     {}      {}        {}            THEN  !    {}      {}        {}                Max_PKsize := num [ 2 ] ;  !     {}      {}        {}        END ;       {}      {}        {}END ;   { numeric input }       {}      {}  END ;   { packet size reply processing }      {}      {}      {}      END ;   { packet size question answer processing }      {}      {}  q1 := succ ( q1 ) ;     { next question }       {}  a1 := succ ( a1 ) ;     { next answer check }       {}      {}  IF ( WS IN flqset )       {}  THEN  	    {}      BEGIN  	     {}      {}      {}      {}  #    {}      {}  {+--------------------------------------------------+} # #    {}      {}  {!                                                  !} # #    {}      {}  {!  }   QUEST_ANSWER ( q1, a1, answr ) ;        {   !} # #    {}      {}  {!                                                  !} # #    {}      {}  {+--------------------------------------------------+} #     {}      {}      {}      {}  CASE rep OF       {}      {}      again :       {}      {}          GOTO 100 ;      {}      {}      {}      {}      no    :       {}      {}        {}BEGIN       {}      {}        {}    IF NOT ( WSpc IN flqset )   #    {}      {}        {}    THEN    { do not ask that question again } #     {}      {}        {}        flqset := flqset  #    {}      {}        {}              - Flow_cntrl_Q_SET_type [ WS ] ; #     {}      {}        {}  #    {}      {}        {}    IF ( neg IN flqset )    { negociation ? }  #     {}      {}        {}    THEN      {}      {}        {}        WSbit := false ;      {}      {}        {}END ;       {}      {}      {}      {}      per_circuit :       {}      {}          flqset := flqset  #    {}      {}                      + Flow_cntrl_Q_SET_type [ WSpc ] ; #     {}      {}      {}      {}      numeric :   &    {}      {}        {}BEGIN       { set window size for both directions }  &     {}      {}        {}    OutWDWSize := num [ 1 ] ;       {}      {}        {}    InWDWSize  := OutWDWSize ;      {}      {}        {}      {}      {}        {}    IF NOT ( WSpc IN flqset )   #    {}      {}        {}    THEN    { do not ask that question again } #     {}      {}        {}        flqset := flqset  #    {}      {}        {}              - Flow_cntrl_Q_SET_type [ WS ] ; #     {}      {}        {}      {}      {}        {}    IF neg IN flqset      {}      {}        {}    THEN    { set negociation bit on }      {}      {}        {}        WSbit := true ;       {}      {}        {}      {}      {}        {}    IF  ( log = 2 )   !    {}      {}        {}    THEN    { set incomming window size }  !     {}      {}        {}        InWDWsize := num [ 2 ] ;      {}      {}        {}END ;   { numeric input }       {}      {}  END ;   { window size reply processing }      {}      {}      {}      END ;   { window size question answer processing }      {}      {}      {}  q1 := succ ( q1 ) ;     { next question }       {}  a1 := succ ( a1 ) ;       {}      {}  IF ( TC IN flqset )         { THROUGHPUT CLASS }      {}  THEN      {}      BEGIN   { get throughput class }      {}      {}      {}      {}  REPEAT  #    {}      {}  {+--------------------------------------------------+} # #    {}      {}  {!                                                  !} # #    {}      {}  {!  }   QUEST_ANSWER ( q1, a1, answr ) ;        {   !} # #    {}      {}  {!                                                  !} # #    {}      {}  {+--------------------------------------------------+} #     {}      {}      {}      {}      CASE rep OF       {}      {}          again :       {}      {}              GOTO 100 ;      {}      {}      {}      {}          no    :       {}      {}            {}BEGIN       {}      {}            {}    IF NOT ( TCpc IN flqset )   %    {}      {}            {}    THEN    { do not ask that question again } %     {}      {}            {}        flqset := flqset  %    {}      {}            {}              - Flow_cntrl_Q_SET_type [ TC ] ; %     {}      {}            {}  %    {}      {}            {}    IF ( neg IN flqset )    { negociation ? }  %     {}      {}            {}    THEN      {}      {}            {}        TCbit := false ;      {}      {}            {}END ;       {}      {}      {}      {}          per_circuit :       {}      {}              flqset := flqset  %    {}      {}                          + Flow_cntrl_Q_SET_type [ TCpc ] ; %     {}      {}      {}      {}          numeric :   '    {}      {}            {}BEGIN { set Throughput class for both directions } '     {}      {}            {}    OutTHCl := num [ 1 ] ;      {}      {}            {}      {}      {}            {}    IF  ( log = 2 )   #    {}      {}            {}    THEN    { set incomming window size }  #    {}      {}            {}        InTHCl := num [ 2 ]      {}      {}            {}    ELSE     {}      {}            {}        InTHCl := OutTHCl ;      {}      {}            {}  !    {}      {}            {}    IF ( OutTHCl > Max_thruput_class ) !     {}      {}            {}        OR      {}      {}            {}       ( InTHCl > Max_thruput_class )       {}      {}            {}    THEN     {}      {}            {}        BEGIN  &    {}      {}            {}            MESS_WRITER ( ermsg, invtcval, 0 ) ; &    {}      {}            {}            CONT_ABORT (local_rep);     {}      {}            {}            rep := local_rep;     {}      {}            {}        END      {}      {}            {}    ELSE     {}      {}            {}        BEGIN      {}      {}            {}            IF NOT ( TCpc IN flqset )       {}      {}            {}            THEN %    {}      {}            {}            { do not ask that question again  } %     {}      {}            {}            flqset := flqset  &    {}      {}            {}                - Flow_cntrl_Q_SET_type [ TC ] ; &     {}      {}            {}      {}      {}            {}            IF neg IN flqset  %    {}      {}            {}            THEN    { set negociation bit on } %     {}      {}            {}                TCbit := true ;       {}      {}            {}        END ;        {}      {}            {}END ;  { numeric reply processing }        {}      {}  "    {}      {}      END ; { case throughput class reply processing } "     {}      {}      {}      {}  UNTIL rep <> none ;       {}      {}      {}      {}      {}      {}  IF ( rep = abort )  
    {}      {}  THEN 
     {}      {}      XINHALT ( noerr ) ;       {}      {}      {}      END ;   { get throughput class }      {}      {}  q1 := succ ( q1 ) ;       {}  a1 := succ ( a1 ) ;       {}      {}  IF ( ak IN flqset )       {}  THEN  	    {}      BEGIN  	     {}      {}  %    {}      {}  {+------------------------------------------------------+} % %    {}      {}  {!                                                      !} % %    {}      {}  {!  }   QUEST_ANSWER ( q1, a1, answr ) ;            {   !} % %    {}      {}  {!                                                      !} % %    {}      {}  {+------------------------------------------------------+} %     {}      {}      {}      {}  CASE rep OF       {}      {}      again :       {}      {}          GOTO 100 ;      {}      {}      {}      {}      yes, no :       {}      {}        {}BEGIN       {}      {}        {}    IF NOT ( akpc IN flqset )   #    {}      {}        {}    THEN    { do not ask that question again } #     {}      {}        {}        flqset := flqset  &    {}      {}        {}                    - Flow_cntrl_Q_SET_type [ ak ] ; &     {}      {}        {}      {}      {}        {}    IF ( rep = yes )      {}      {}        {}    THEN      {}      {}        {}        Dbit := true      {}      {}        {}    ELSE      {}      {}        {}        Dbit := false ;       {}      {}        {}END ;       {}      {}      {}      {}      Per_circuit :       {}      {}          flqset := flqset  $    {}      {}                       + flow_cntrl_Q_SET_type [ akpc ] ;  $     {}      {}  !    {}      {}  END ; { case of end to end ACK reply processing }  !     {}      {}       {}      END ;   { end to end ACK question answer processing        {}  100 :       {}      END   { With Current_net_ptr^ }   $SUBTITLE 'FACILITIES QUESTIONS'$   END ;   ${+--------------------------------------------------------------------+} $ ${!                                                                    !} $ ${!  } PROCEDURE CU_MRC_ARC (                                      {   !} $ ${!  }                  VAR cmaset    :  Facil_opt_Q_SET_type ;    {   !} $ ${!  }                        q1      :  prmpt_msg_list     ;      {   !} $ ${!  }      { CUG check }     a1      :  Answer_check_list  ;      {   !} $ ${!  }      { mrc/arc check } a2      :  Answer_check_list  ;      {   !} $ ${!  }                  VAR Fac_tab   :  Facilitiestype     ;      {   !} $ ${!  }                  VAR CUGnumber :  OCTET                     {   !} $ ${!  }                     ) ;                                     {   !} $ ${!                                                                    !} $ ${+--------------------------------------------------------------------+} $     LABEL       100 ;           !BEGIN     { .... get CUG, make reverse charge call, accept .... }  !           { .... reverse charge call facilities .... }      WITH answr, val, Xinit_gbl_entry, gbl_entry,           curr_net_ptr^, Xinit_net, Fac_tab      DO      BEGIN   #    {}  IF ( cu IN cmaset )             { Closed user group facility } #     {}  THEN  	    {}      BEGIN  	     {}      {}      {}      {}  %    {}      {}  {+------------------------------------------------------+} % %    {}      {}  {!                                                      !} % %    {}      {}  {!  }   QUEST_ANSWER ( q1, a1, answr ) ;            {   !} % %    {}      {}  {!                                                      !} % %    {}      {}  {+------------------------------------------------------+} %     {}      {}      {}      {}  CUGnumber := 0 ;      {}      {}      {}      {}  CASE rep OF       {}      {}      again :       {}      {}          GOTO 100 ;      {}      {}      {}      {}      cug_num :       {}      {}          BEGIN       {}      {}              CUGnumber := Cnum.C ;       {}      {}              CUbit     := true           {}      {}          END ;       {}      {}      {}      {}      yes     :       {}      {}          cmaset := cmaset  $    {}      {}                       + Facil_opt_Q_SET_type [ cuyes ] ;  $     {}      {}      {}      {}      no      :       {}      {}          IF NOT ( cuyes IN cmaset )      {}      {}          THEN { do not ask for CUG number }      {}      {}              cmaset := cmaset  #    {}      {}                           - Facil_opt_Q_SET_type [ cu ] #     {}      {}          ELSE      {}      {}              CUbit := false      {}      {}      {}      {}  END   { CASE of CUG number reply processing }       {}      {}      {}      END ;   { CUG number question answer processing }       {}  q1 := succ ( q1 ) ;       {}       {}  IF ( mrc IN cmaset )        { make reverse charge call }       {}  THEN  	    {}      BEGIN  	     {}      {}      {}      {}  %    {}      {}  {+------------------------------------------------------+} % %    {}      {}  {!                                                      !} % %    {}      {}  {!  }   QUEST_ANSWER ( q1, a2, answr ) ;            {   !} % %    {}      {}  {!                                                      !} % %    {}      {}  {+------------------------------------------------------+} %     {}      {}      {}      {}  CASE rep OF       {}      {}      again :       {}      {}          GOTO 100 ;      {}      {}      {}      {}      yes, no :       {}      {}        {}BEGIN       {}      {}        {}    IF NOT ( mrcpc IN cmaset )  !    {}      {}        {}    THEN    { do not ask question again }  !     {}      {}        {}        cmaset := cmaset  $    {}      {}        {}                - Facil_opt_Q_SET_type [ mrc ] ; $     {}      {}        {}    IF ( rep = yes )      {}      {}        {}    THEN      {}      {}        {}        RCbit := true       {}      {}        {}    ELSE      {}      {}        {}        RCbit := false ;      {}      {}        {}END ;       {}      {}      {}      {}      Per_circuit :       {}      {}          cmaset := cmaset  !    {}      {}                  + Facil_opt_Q_SET_type [ mrcpc ] ; !     {}      {}  #    {}      {}  END ; { CASE of make reverse charge call reply proc. } #     {}      {}  &    {}      END ;   { Make reverse charge call question answer processing }  &     {}      {}  q1 := succ ( q1 ) ;       {}  !    {}  IF ( arc IN cmaset )        { accept reverse charge call } !     {}  THEN  	    {}      BEGIN  	     {}      {}      {}      {}  %    {}      {}  {+------------------------------------------------------+} % %    {}      {}  {!                                                      !} % %    {}      {}  {!  }   QUEST_ANSWER ( q1, a2, answr ) ;            {   !} % %    {}      {}  {!                                                      !} % %    {}      {}  {+------------------------------------------------------+} %     {}      {}      {}      {}  CASE rep OF       {}      {}      again :       {}      {}          GOTO 100 ;      {}      {}      {}      {}      yes, no :       {}      {}        {}BEGIN       {}      {}        {}    IF NOT ( arcpc IN cmaset )  !    {}      {}        {}    THEN    { do not ask question again }  !     {}      {}        {}        cmaset := cmaset  $    {}      {}        {}                - Facil_opt_Q_SET_type [ arc ] ; $     {}      {}        {}    IF ( rep = yes )      {}      {}        {}    THEN      {}      {}        {}        ARbit := true       {}      {}        {}    ELSE      {}      {}        {}        ARbit := false ;      {}      {}        {}END ;       {}      {}      {}      {}      Per_circuit :       {}      {}          cmaset := cmaset       {}      {}                  + Facil_opt_Q_SET_type [ arcpc ]       {}      {}  $    {}      {}  END   { CASE of accept reverse charge call reply proc. } $     {}      {}  '    {}      END ;   { Accept reverse charge call question answer processing }  '     {}      {}  100 :       {}      END   { WITH current_net_ptr^ }   $TITLE 'PRINT default DVX00 conf.'$   $SUBTITLE ' '$  END ;   {+--------------------------------+}  {!} PROCEDURE DVXDFLT_PRINTER ;  {!}  {+--------------------------------+}      { WARNING :                                                  }  {   This routine needs to be changed if any of the defaults  }  {   are changed. It is based on the default titles in &XINMS.}      BEGIN       { .... print standard configuration defaults .... }                               { print default header }                              {----------------------}  %    MESS_WRITER ( fullmsg, dflthdr3, 0 )    ; { 'VIRTUAL DRIVER CONF..' }  %     endline ;   { skip a line }                               { print DVX00 configuration defaults }            { Parm 1 Flush or eqt down on line disconnect }         {---------------------------------------------}       IF ( curr_step = step10 )  { PAD }  "    THEN MESS_WRITER ( fullmsg, fldflt2, 0 )     {'Set EQT down..'}  " "    ELSE MESS_WRITER ( fullmsg, fldflt1, 0 ) ;   {'Hard flush..  '}  "           { Parm 2 Action on unsolicited data available }         {---------------------------------------------}       IF NOT ( curr_step = step10 )  { Non PAD }  "    THEN MESS_WRITER ( fullmsg, scdflt1, 0 ) ;  {'prog sched ..NO' } "           { Parm 3 Action on READ configuration byte    }         {---------------------------------------------}       IF ( curr_step = step10 )       { PAD }   "    THEN MESS_WRITER ( fullmsg, srdflt1, 0 ) ;  {'Send...each EXEC'} "           { Parm 4 Custom subroutine entry number       }         {---------------------------------------------}   "    MESS_WRITER ( fullmsg, dddflt1, 0 ) ;       {'...Default entry'} "           { Parm 5 Action on unsolicited interrupts     }         {---------------------------------------------}       IF ( Curr_step = step10 )   "    THEN MESS_WRITER ( fullmsg, uedflt2, 0 )    {'Prog sched..YES'}  " "    ELSE MESS_WRITER ( fullmsg, uedflt1, 0 ) ;  {'Prog sched.. NO'}  "     $    IF ( Opsystype = RTE_A ) AND ( curr_step = step10 )  THEN {CC 7/83}  $     BEGIN   !    {}  MESS_WRITER ( fullmsg, pndflt1, 0 ) ;    {'Primar..CI.xx'} ! !    {}  MESS_WRITER ( fullmsg, pndflt2, 0 ) ;    {'Second..CM.xx'} ! "    {}  MESS_WRITER ( fullmsg, pndflt3, 0 )      {'Rename..enabled'} "     END ;       endline     { skip a line }   $TITLE 'DVX00 conf. questions'$   END ;   ${+--------------------------------------------------------------------+} $ ${!                                                                    !} $ ${!  } PROCEDURE DVX00_CONF (                                      {   !} $ ${!  }                  VAR DVX00qset :  DVX00_conf_Q_SET_type ;   {   !} $ ${!  }                        q1      :  prmpt_msg_list     ;      {   !} $ ${!  }                        a1      :  Answer_check_list  ;      {   !} $ ${!  }                        a2      :  Answer_check_list  ;      {   !} $ ${!  }            VAR DVX00_conf_word :  DVX00_conf_type           {   !} $ ${!  }                     ) ;                                     {   !} $ ${!                                                                    !} $ ${+--------------------------------------------------------------------+} $     LABEL       100 ;       $SUBTITLE 'RTE-A scheduling', PAGE$  	PROCEDURE XLSCHED ; 	LABEL 100 ; VAR   ptr : ONEWORD ; BEGIN      WITH answr, val, Xinit_gbl_entry, gbl_entry,           curr_net_ptr^, Xinit_net, DVX00_conf_word, Bconf DO     BEGIN      {}  FOR ptr := 1 to 6 DO &    {}  BEGIN primary.S [ ptr ] := space;  secondary.S [ ptr ] := space END ; &     {}              { PRIMARY PROGRAM NAME ? }     {+---------------------------------------------+}     {!} QUEST_ANSWER ( ddxq5_1, npname, answr ) ; {!}     {+---------------------------------------------+}      {}  IF Rep = again THEN GOTO 100 ;      {}      {}  IF ( st21[ 1 ] = nopname ) $    {}  THEN BEGIN  primary.WA [ 1 ] := 0 ; secondary.WA [ 1 ] := 0 ; END $     {}  ELSE     {}  BEGIN  #    {}  {}  FOR ptr := 1 TO Log  DO primary.S [ ptr ] := St21[ ptr ] ; #     {}  {}              { SECONDARY PROGRAM NAME ? }     {}  {+---------------------------------------------+}     {}  {!} QUEST_ANSWER ( ddxq5_2, npname, answr ) ; {!}     {}  {+---------------------------------------------+}      {}  {}  IF rep = again THEN GOTO 100 ;      {}  {}      {}  {}  IF ( st21[ 1 ] = nopname )      {}  {}  THEN secondary.WA [ 1 ] := 0      {}  {}  ELSE  &    {}  {}      FOR ptr := 1 TO Log  DO secondary.S [ ptr ] := st21[ ptr ] ; &     {}  {}     {}  {}              { PROGRAM RENAMING OPTION ? }     {}  {+---------------------------------------------+}     {}  {!} QUEST_ANSWER ( ddxq5_3, yesno, answr ) ;  {!}     {}  {+---------------------------------------------+}      {}  {}     {}  {}  CASE Rep OF      {}  {}      again :  GOTO 100 ;       {}  {}  
    {}  {}      no    :  ; 
      {}  {}                  { PROGRAM will be renamed : XXXLU }        {}  {}      yes   :  ensched := defltsched      {}  {}  END       {}  END       END ;     100 :   $SUBTITLE 'Reply processing'$   END ;   PROCEDURE DVXANSWER ( DVX00q, DVX00pc : DVX00_conf_Q_Type ) ;   BEGIN        WITH answr, val, Xinit_gbl_entry, gbl_entry, curr_net_ptr^,             Xinit_net, DVX00_conf_word, Bconf DO       CASE rep OF       {}      {}  yes,no      :   	    {}      BEGIN  	     {}      {}  IF NOT ( DVX00pc IN DVX00qset )       {}      {}  THEN DVX00qset := DVX00qset -   #    {}      {}                      DVX00_conf_Q_SET_type [ DVX00q ] ; #     {}      {}      {}      {}  CASE DVX00q OF  {-----------}   
    {}      {}  {}  fl  :  
     {}      {}  {}      IF ( curr_step = Step10 )       {}      {}  {}      THEN IF ( Rep = Yes )       {}      {}  {}           THEN  action_ondisc := eqt_down      {}      {}  {}           ELSE  action_ondisc := Hard_flush      {}      {}  {}      ELSE IF ( Rep = yes )       {}      {}  {}           THEN  action_ondisc := hard_flush       {}      {}  {}           ELSE  action_ondisc := eqt_down   ;   	    {}      {}  {} 	 
    {}      {}  {}  th  :  
     {}      {}  {}      IF ( rep = yes )      {}      {}  {}      THEN  action_onunscd := try_sched       {}      {}  {}      ELSE  action_onunscd := set_bit2  ;   	    {}      {}  {} 	 
    {}      {}  {}  sr  :  
     {}      {}  {}      IF ( rep = yes )      {}      {}  {}      THEN  action_onreadc := always_send       {}      {}  {}      ELSE  action_onreadc := send_onctrl ;   	    {}      {}  {} 	 
    {}      {}  {}  ue  :  
     {}      {}  {}      IF ( rep = yes ) THEN       {}      {}  {}      BEGIN       {}      {}  {}      {}  ensched := sched ;  
    {}      {}  {}      {} 
 "    {}      {}  {}      {}  IF ( Opsystype = RTE_A ) THEN  {CC 7/83} "      {}      {}  {}      {}  BEGIN   { Get primary & secondary }         {}      {}  {}      {}  {}  XLSCHED ;   { program names   }        {}      {}  {}      {}  {}       {}      {}  {}      {}  {}  IF ( Rep = again ) THEN GOTO 100       {}      {}  {}      {}  END       {}      {}  {}      END       {}      {}  {}      ELSE ensched := nosched   
    {}      {}  END  
     {}      END ; { yes no reply processing }       {}  	    {}  numeric :  	 	    {}      BEGIN  	     {}      {}  IF NOT ( DVX00pc IN DVX00qset )       {}      {}  THEN DVX00qset := DVX00qset -        {}      {}               DVX00_conf_Q_SET_type [ DVX00q ] ;        {}      {}      {}      {}  ddv_entrynum := num [ 1 ]   	    {}      END ;  	     {}      {}  per_circuit :   #    {}      DVX00qset := DVX00qset + DVX00_conf_Q_SET_type [ DVX00pc ] #     {}  $    END  {--------- CASE DVX00 configuration reply processing ---------} $ $SUBTITLE ' Main procedure '$   END ;   %BEGIN       { --------- DVX00 conf question answer main proc. ---------- } % 	    WITH answr DO  	     BEGIN       {}      {}  { Flush or EQT down }       {}  {-------------------}       {}  IF ( fl IN DVX00QSET ) THEN       {}  BEGIN       {}      IF NOT ( curr_step = step10 )       {}      THEN  QUEST_ANSWER ( q1, a1, answr )      {}      ELSE  QUEST_ANSWER ( succ ( q1 ), a1, answr ) ;       {}      IF answr.Rep = again THEN GOTO 100 ;      {}      DVXANSWER ( fl, flpc )      {}  END ;   #    {}  q1 := succ ( q1 ) ; q1 := succ ( q1 ) ; { skip two questions } #     {}      {}  { enable program scheduling on unsolicited data }       {}  {-----------------------------------------------}       {}  IF ( th IN DVX00QSET ) THEN       {}  BEGIN       {}      QUEST_ANSWER ( q1, a1, answr ) ;      {}      IF answr.Rep = again THEN GOTO 100  ;       {}      DVXANSWER ( th, thpc )      {}  END ;       {}  q1 := succ ( q1 ) ;       {}      {}  { send read configuration data }      {}  {------------------------------}      {}  IF ( sr IN DVX00QSET ) THEN       {}  BEGIN       {}      QUEST_ANSWER ( q1, a1, answr ) ;      {}      IF answr.Rep = again THEN GOTO 100  ;       {}      DVXANSWER ( sr, srpc )      {}  END ;       {}  q1 := succ ( q1 ) ;       {}      {}  { Custom subroutine entry number }      {}  {--------------------------------}      {}  IF ( dd IN DVX00QSET ) THEN       {}  BEGIN       {}      QUEST_ANSWER ( q1, a2, answr ) ;      {}      IF answr.Rep = again THEN GOTO 100  ;       {}      DVXANSWER ( dd, ddpc )      {}  END ;       {}  q1 := succ ( q1 ) ;       {}      {}  { enable program scheduling on unsolicited events }       {}  {-------------------------------------------------      {}  IF ( ue IN DVX00QSET ) THEN      {}  BEGIN      {}      QUEST_ANSWER ( q1, a1, answr ) ;     {}      IF answr.Rep = again THEN GOTO 100  ;      {}      DVXANSWER ( ue, uepc )     {}  END ;      {}     {}  100 :     END END ;     
{ END OF MODULE XINUT.PAS } 
 .  