 "$CDS ON$ $range on $ $DEBUG ON $ $HEAP_DISPOSE OFF$ $TRACE_BACK ON $ "$HEAP 1$ $HEAPPARMS OFF$ $LINESIZE 255$ $tables on$  $TITLE 'VTIMR GM Marion VCP     '$  $SUBTITLE 'Timeout Subroutines'$      $PASCAL ',4,80 92078-16124 REV.5020 <900105.1749>'  {    NAME:   VTIMR_SUB       SOURCE: 92078-18124       RELOC:  92078-16124      PGMR:   mh      !  **************************************************************** ! !  * (C) COPYRIGHT HEWLETT-PACKARD COMPANY 1989.  ALL RIGHTS      * ! !  * RESERVED.  NO PART OF THIS PROGRAM MAY BE PHOTOCOPIED,       * ! !  * REPRODUCED OR TRANSLATED TO ANOTHER PROGRAM LANGUAGE WITHOUT * ! !  * THE PRIOR WRITTEN CONSENT OF HEWLETT-PACKARD COMPANY.        * ! !  **************************************************************** !    {    'VCP Timeout Suproutines           }     	 MODULE  vtimr_sub; 	    { This subroutines handle timeouts for  VCP Monitor Program     
            Programmer:  MH 
                  Date:  22 Nov. 1989           Last modified:  <900105.1749>              ********************************************************      *                   HP CONFIDENTIAL                    *      * THIS MATERIAL IS PROPRIETARY TO HEWLETT-PACKARD AND  *      * MAY NOT BE USED, REPRODUCED, OR DISCLOSED OUTSIDE OF *      * HP WITHOUT THE PRIOR WRITTEN APPROVAL OF HP.         *      * COPYRIGHT (C) HEWLETT-PACKARD COMPANY 1985. ALL      *      * RIGHTS RESERVED.                                     *      ********************************************************      !  This program functions as the VCP timer program described in the !  "VCP SUPPORT For LAN 802.3  Environment     EXTERNAL  REFERENCE SPECIFICATION".   }     IMPORT $SEARCH '../rel/TRY_RECOVER.REL'$ try_recover,        $SEARCH '../rel/vcp_DECLS.REL'$ vcp_decls,        $SEARCH '../rel/TEST_PROCS.REL'$ test_procs;              EXPORT          PROCEDURE log_request_in_time_list(time_delay: shortint;                                     sequence  : shortint; "                                   sessionp  : completion_data_type); " "PROCEDURE service_timeouts(    VAR session   : completion_data_type; "                               VAR rtn2      : shortint); FUNCTION time_to_wait:shortint; 
PROCEDURE init_vtimr; 
 PROCEDURE remove_timeout( session_numb : byte );      $PAGE$     IMPLEMENT      "CONST TESTING = false; { THIS BOOLEAN CONSTANT IS USED FOR AUTOMATED " "                         SOFTWARE TESTING. WHEN SET TRUE, VTIMR WILL ""                         RUN 10 TIMES AS OFTEN AND ALL TIME DEPENDENT ""                         FUNCTIONS ARE ADJUSTED ACCORDINGLY. TIME OUT "                          VALUES IN SECONDS BECOME 1/10 SECONDS. }           ${ A time_rec is the dynamic data structure that contains the information $ &  used to pass a timeout message back to the timeout requestor. A note about &&  the session_id: a completion_data_type is a packed record sructure (defined &   in vcp_decls) defined:                  bits 15-12   : pad              bits 11-8    : completion type               bits  7-0    : session_id      $  The session_id is packed by VCPMT to contain a session id number and a $ %  "timeout_occured" completion type. This record is stored in the time_rec % $  and returned un-modified to VCPMT when the timeout time has expired. } $    TYPE  time_rec_ptr = ^time_rec;        time_rec = PACKED RECORD              time_list_next: time_rec_ptr; { next one to timeout }  #            time_rec_next: time_rec_ptr;  { next one of all time recs } # $            session_id: completion_data_type; { sess_id and get type 8 } $$                                           {for use in allocate_time_rec} $ #            sequence_number: shortint;    { session TO sequence numb } #&            time_delta: shortint;         { time this one sits at list head } &            busy: boolean;                { in use flag }        END;     !VAR   time_rec_base: time_rec_ptr; { head of the linked list of all !$                                                             time_rec's } $"      C_time_list_next: time_rec_ptr; { Current next one to timeout } "        time_list_base: time_rec_ptr; { head of the linked list of  $                                            time_rec's awaiting timeout } $      timeout_record: time_rec_ptr;     &      time_mark: integer ;  { Global saving of system time seconds used to  } &       old_time_mark: integer ; $                               { adjust if time scheduling falls behind } $           normal_sleep_time: shortint; { normal sleep time duration }           
      log_retry: shortint; 
           get_error_count: shortint;       trace_str: trace_string_type;  
      trace_pos: shortint; 
       trace_level: shortint;  $      session: completion_data_type; {moved up from log_timeout_request} $       dummy: shortint;          $PAGE$     $INCLUDE '../src/vcp_EXTERNALS.pasi'$ Function ElapsedTime:integer ;external;  procedure ResetTimer;external;      $PAGE$ $AUTOPAGE ON$         FUNCTION allocate_time_rec: time_rec_ptr;      %  { searches the linked list of all time_rec's for one that is not in use, % %    and returns a pointer to it. If all are busy, new's one up and returns %%    a pointer to it. If new fails due to no memory returns a NIL pointer. } %      VAR current_time_rec: time_rec_ptr;        last_time_rec: time_rec_ptr;       last_rec: time_rec_ptr;       got_one: boolean;  
      done: boolean; 
      BEGIN 
    got_one := false; 
    c_time_list_next := time_list_base;  
    last_rec := NIL; 
      { the following code looks for an entry in the time_list for the    same sessionnumber if we get one its no longer needed and "  it should be reused to minimize the heapspace and the class i/o's } "         WHILE (NOT got_one) AND (c_time_list_next <> NIL) DO       BEGIN         WITH c_time_list_next^ DO           BEGIN             IF (session_id.session <> session.session) THEN 	              BEGIN 	                last_rec := c_time_list_next;                 c_time_list_next := time_list_next;               END              ELSE                begin {else part of if then else }                 if last_rec <> NIL then                    last_rec^.time_list_next := time_list_next  
                else 
 '                if(time_list_next <> NIL) then time_list_base:= time_list_next '                  else time_list_base := NIL;                 current_time_rec := c_time_list_next;                  got_one := true;                END;{if then else}           END; { WITH }  
      END; { WHILE } 
        IF NOT got_one THEN       begin         got_one := false;        current_time_rec := time_rec_base;         last_time_rec := NIL;            WHILE (NOT got_one) AND (current_time_rec <> NIL) DO           BEGIN             WITH current_time_rec^ DO  	             BEGIN 	
               IF busy THEN 
                  BEGIN                    last_time_rec := current_time_rec;                    current_time_rec := time_rec_next;  
                 END 
	               ELSE 	                 got_one := true;  
             END; { WITH } 
         END; { WHILE } 
      end; {if not got_one} 
    IF NOT got_one THEN       BEGIN          TRY;            new(current_time_rec);          IF NOT recover THEN { new successful }           BEGIN      %            { extend the list and return the pointer to the new time_rec } %                current_time_rec^.time_rec_next := NIL;              current_time_rec^.time_list_next := NIL;                  IF last_time_rec <> NIL THEN               last_time_rec^.time_rec_next := current_time_rec;              allocate_time_rec := current_time_rec;                END { new successful }          ELSE           BEGIN { new failed probably not enough memory }             allocate_time_rec := NIL;            END;       END { NOT got_one }     ELSE { found a time_rec that was not being used }        allocate_time_rec := current_time_rec;     
  END; {allocate_time_rec } 
        PROCEDURE insert_in_time_list(t_rec: time_rec_ptr);     $  { receives a pointer to a time_rec with the time_delta field containing $ #    the period of the timeout request (number of seconds from now that ##    the timeout is supposed to occur.) Searches the timeout list headed # "    at time_list_base until it finds the proper place to insert this "$    timeout request. When the proper place is found, adjusts the time_rec $"    time_delta field for the proper delta from the timeout request in ""    front of it in the time list. Adjusts the time_delta field in the "#    following request for the proper delta from this timeout request. } #      VAR last_rec: time_rec_ptr;  
      done: boolean; 
      BEGIN  	    WITH t_rec^ DO 	      BEGIN             IF time_delta < 0 THEN time_delta := 2;         time_list_next := time_list_base;               IF time_list_base <> NIL THEN { time list is not empty }            BEGIN                  last_rec := NIL;  
            done := false; 
                WHILE (NOT done) AND (time_list_next <> NIL) DO      #      { step through the time list subtracting each entries time_delta # $        from the one we are trying to place. When the subject time_delta $ $        goes negative time_list_next will be pointing at the time_rec in $$        front of which we want to insert t_rec. T_rec will be inserted at $ %        the end of all time_rec's scheduled to timeout at the same time as % #        t_rec. time_deltas of zero will be inserted at the head of the ##        list or after all the zero time_deltas at the head of the list. #"        Negative time_deltas are set to zero before list insertion. } "    	              BEGIN 	 #                time_delta := time_delta - time_list_next^.time_delta; #                IF time_delta < 0 THEN { found proper place }                   BEGIN                          { first back up to last 0 or positive value }       %                    time_delta := time_delta + time_list_next^.time_delta; %    $                    { then adjust the following delta for the proper time $                      to follow the new insertion }                         time_list_next^.time_delta :=  "                            time_list_next^.time_delta - time_delta; "                     if ( time_list_next^.time_delta < 2 ) then                              time_list_next^.time_delta := 2;                         { insert into the time list }                          IF last_rec = NIL THEN { front of list }                       time_list_base := t_rec                     ELSE { insert into list }                        last_rec^.time_list_next := t_rec;                          done := true; { stop the looping }     
                  END 
 $                ELSE    { not at the proper place in the time list yet } $                  BEGIN                         last_rec := time_list_next; "                    time_list_next := time_list_next^.time_list_next; " 
                     
                   END;                END; { WHILE }                           IF NOT done THEN { end of time list, add to end }                            last_rec^.time_list_next := t_rec;           END                   ELSE { time list is empty }                        time_list_base := t_rec;        
      END; { WITH t_rec^ } 
       END; { insert_in_time_list }    PROCEDURE log_request_in_time_list(time_delay: shortint;                                       sequence  : shortint;  $                                      sessionp  : completion_data_type); $     "     { puts the current timeout request in the time list and handles "       all errors resulting from it }           BEGIN 
       session := sessionp; 
         timeout_record := allocate_time_rec; { get a new record }              { verify allocate successful, else return error to VCPMT }             IF timeout_record <> NIL THEN { ok }           BEGIN             WITH timeout_record^ DO  	             BEGIN 	               session_id := session;                sequence_number := sequence;  &               time_delta := time_delay * 100; { keep time in centiseconds } &                busy := true;                insert_in_time_list(timeout_record);              END;           END            ELSE    { no memory for new timeout record }               BEGIN             { log to trace file }                 log_retry := log_retry + 1;                 { this should never happen if it hapens              our heap is much too small and vcpmt will dy               any way otherwise it should only affect one              one session and repair itself if nobody hits               the break key on this system at the same time }                  END; { failure to log timeout request in time list }           END; { log_request_in_time_list }         FUNCTION time_to_wait:shortint; "  { tells us the time to wait until the next request should come in } "        begin $          if time_list_base <> NIL THEN {there is something to wait for } $ 	             begin 	                with time_list_base^ do 
                begin 
                  time_to_wait:=time_delta;  
                end; 
              end             else time_to_wait := 0;          end;     
PROCEDURE init_vtimr; 
      {      Initializes the first timeout record and  #    aborts if not enough memory for one timeout record. Does the first #     mark_time.     }       VAR          time: time_array_rec;    { time request variable }         error: boolean;          pos: shortint;       BEGIN         { if testing pick up testing parameters and setup testing IO }      
    trace_level := 0; 
 
    trace_str := ''; 
	    trace_pos := 1; 	     
    time_list_base := NIL; 
    time_rec_base := NIL;     time_rec_base := allocate_time_rec;  &    IF time_rec_base = NIL THEN { get an lu number and post the error before &                                     aborting VTIMR }       BEGIN          escape(recover_block);        END;         time_rec_base^.busy := false;  
    time_list_base := NIL; 
        ResetTimer;      time_mark := ElapsedTime div 10;     
  END; { init_vtimr } 
         "PROCEDURE service_timeouts(    VAR session   : completion_data_type; "                               VAR rtn2      : shortint); var    time_delay : shortint; BEGIN    time_mark := ElapsedTime div 10;   time_delay := (time_mark - old_time_mark) mod 32767 ;   old_time_mark := time_mark;   if time_list_base <> NIL THEN     begin  &      time_list_base^.time_delta := time_list_base^.time_delta - time_delay; & '      if time_list_base^.time_delta <= 0 then time_list_base^.time_delta := 1; '      IF (session.comp_type = timeout_occured) THEN         begin           WITH time_list_base^ DO             BEGIN                rtn2 := sequence_number;               { remove timeout from the time list }                session := session_id;                busy := false;              end;          end;      end;  end;  PROCEDURE remove_timeout( session_numb : byte ); VAR current_time_rec: time_rec_ptr;      last_time_rec: time_rec_ptr; 
    last_rec: time_rec_ptr; 
    got_one: boolean; 
{removes pending timeouts from the linked list}       BEGIN 	  got_one := false; 	  c_time_list_next := time_list_base;  	  last_rec := NIL; 	 !  { the following code looks for an entry in the time_list for the !    same sessionnumber if we get one its no longer needed and     it should be reused to minimize the heapspace }          WHILE (NOT got_one) AND (c_time_list_next <> NIL) DO       BEGIN         WITH c_time_list_next^ DO           BEGIN              IF (session_id.session <> session_numb) THEN 	              BEGIN 	                last_rec := c_time_list_next;                 c_time_list_next := time_list_next;               END              ELSE                begin {else part of if then else }                  busy := false;                 if last_rec <> NIL then                    last_rec^.time_list_next := time_list_next  
                else 
 '                if(time_list_next <> NIL) then time_list_base:= time_list_next '                  else time_list_base := NIL;                  got_one := true;                 current_time_rec := c_time_list_next;                END;{if then else}           END; { WITH }  
      END; { WHILE } 
   END;  END. 