 $$cds on $ $range off$ $DEBUG ON $     $HEAP_DISPOSE OFF$ $TRACE_BACK ON$ $ $HEAP 1$ $HEAPPARMS OFF$ $CODE_OFFSETS ON$ $tables on$  $TITLE 'VCPMT GM Marion Virtual '$  $SUBTITLE 'Control Panel Monitor'$  $PASCAL ',4,80 92078-16116 REV.5020 <900501.1538>'  	{    NAME:   vcpmt 	      SOURCE: 92078-18116       RELOC:  92078-16116      PGMR:   mh      !  **************************************************************** ! !  * (C) COPYRIGHT HEWLETT-PACKARD COMPANY 1989.  ALL RIGHTS      * ! !  * RESERVED.  NO PART OF THIS PROGRAM MAY BE PHOTOCOPIED,       * ! !  * REPRODUCED OR TRANSLATED TO ANOTHER PROGRAM LANGUAGE WITHOUT * ! !  * THE PRIOR WRITTEN CONSENT OF HEWLETT-PACKARD COMPANY.        * ! !  **************************************************************** ! }  {   LAN VCP Monitor                 }  PROGRAM VCPMT;     #{ This program handles FCL/IPL/VCP support for 12076 A-Series Interface #      This program functions as the VCP monitor program       }     $SUBTITLE 'tables Access Routines'$  $AUTOPAGE$  {  VCP Monitor IPL tables Access Routines    }     MODULE vcpmt_ipl_table;      { These routines handle IPL Table access for    Virtual Control Panel Monitor programs           }      IMPORT $SEARCH 'TRY_RECOVER.REL'$ try_recover,         $SEARCH 'vcp_DECLS.REL'$ vcp_decls,         $SEARCH 'TEST_PROCS.REL'$ test_procs,         $SEARCH 'VCPMT_TRACE.REL'$ vcpmt_trace;              EXPORT         PROCEDURE open_ipl_file_table(VAR table: ipl_file_table_type;                               VAR error: boolean;                               VAR busy: boolean);          FUNCTION read_ipl_file_table(VAR table: ipl_file_table_type;                         VAR error: boolean; %                        VAR eof_flag: boolean): ipl_file_table_record_type; %    FUNCTION get_ipl_file_name(pc_name: pc_logical_name_type;                             VAR error: boolean; !                           VAR busy: boolean): file_path_name_type; !     !FUNCTION get_pc_name(net_lu: shortint; LAN_addr: LAN_address_type; !                      VAR error: boolean;                       VAR busy: boolean): pc_logical_name_type;     &FUNCTION get_LAN_address(pc_name: pc_logical_name_type; VAR net_lu: shortint; &                          VAR error: boolean;                           VAR busy: boolean): LAN_address_type;      FUNCTION get_no_LAN_address(pc_name: pc_logical_name_type;                              pc_no: pc_logical_no_type;                           VAR net_lu: shortint;                           VAR error: boolean;                           VAR busy: boolean): LAN_address_type;     IMPLEMENT          $INCLUDE 'vcp_EXTERNALS.pasi'$     PROCEDURE open_ipl_file_table(VAR table: ipl_file_table_type;                               VAR error: boolean;                               VAR busy: boolean);       { Opens the file whose name is in the global constant     ipl_file_table_name which should be an ipl file table file.     Returns the passed file variable opened. If an open  &    error is because the file is already open, returns busy true. If another &!    error occurs, error is set and the error message is returned in !    trace_str }       BEGIN 	    error := false; 	 	    busy := false; 	     TRY;        reset(table,ipl_file_table_name,'SHARED');     IF recover THEN { file open error }       BEGIN          IF (recover_block^.error_type = fmp) AND             (recover_block^.error_number = -8) THEN                {file is in use, may want to try later }              busy := true              ELSE               BEGIN { other error }             strwrite(trace_str,1,trace_pos,              'unable to open IPL table file "',             ipl_file_table_name,'"');              trace_write;             strwrite(trace_str,1,trace_pos,             'a Pascal error type ',recover_block^.error_type, #            ' number ',recover_block^.error_number:1,' has occurred.'); #             trace_write;  
            error := true; 
           END;           END; { error processing }        END; { open_ipl_file_table }      FUNCTION read_ipl_file_table(VAR table: ipl_file_table_type;                         VAR error: boolean; %                        VAR eof_flag: boolean): ipl_file_table_record_type; %       { serialy reads one record from an open ipl file table file and   %  handles the appropriate errors, error messages are returned in the trace %   string }       VAR   table_record: ipl_file_table_record_type;       BEGIN 	    error := false; 	     eof_flag := false;      REPEAT        IF NOT eof(table) THEN         BEGIN            TRY;             read(table,table_record);           IF recover THEN  { read error }             BEGIN               strwrite(trace_str,1,trace_pos,               'while reading the IPL table file "',               ipl_file_table_name,'"');  
              trace_write; 
              strwrite(trace_str,1,trace_pos,               'a Pascal error type ',recover_block^.error_type, $              ' number ',recover_block^.error_number:1,' has occurred.'); $ 
              trace_write; 
               error := true;                table_record.c := ' ';               END; { read error }          END; { not eof }        IF eof(table) THEN eof_flag := true; { eof after read? } 
    UNTIL eof_flag OR 
 #            (table_record.c[1] <> '*'); { comment lines start w/ "*" } #         read_ipl_file_table := table_record;        END; { read_ipl_file_table }         FUNCTION get_ipl_file_name(pc_name: pc_logical_name_type;                             VAR error: boolean; !                           VAR busy: boolean): file_path_name_type; !     $  { gets the ipl_file_name for a node from the ipl file table file given $    the the pc_logical_name }       VAR   table: ipl_file_table_type;          hold_record: ipl_file_table_record_type;          test_record: ipl_file_table_record_type;  
        eof_flag: boolean; 
        match: boolean;          pos: shortint;         BEGIN  
     error := false; 
     open_ipl_file_table(table,error,busy);       IF NOT (busy OR error) THEN         BEGIN           match := false;           hold_record.default_use := '0';              REPEAT  "           test_record := read_ipl_file_table(table,error,eof_flag); "            IF NOT error THEN WITH test_record DO  	             BEGIN 	                IF pc_name = pc_logical_name THEN                   BEGIN                    match := true;                    IF hold_record.default_use <> '1' THEN                      hold_record := test_record                    ELSE  
                     BEGIN 
                        IF default_use = '1' THEN                           hold_record := test_record;                      END; 
                 END; 
             END;          UNTIL eof_flag OR error;               IF NOT (error OR busy) THEN             IF NOT match THEN  	             BEGIN 	               error := true;                 trace_str := 'no IPL file entry for name:'; 
               trace_write; 
                strwrite(trace_str,1,trace_pos,' "',pc_name);                 trace_str := strrtrim(trace_str) + '"'; 
               trace_write; 
             END;        END;       get_ipl_file_name := hold_record.IPL_file_name;  	     close(table); 	   END; { get_ipl_file_name }      !FUNCTION get_pc_name(net_lu: shortint; LAN_addr: LAN_address_type; !                      VAR error: boolean;                       VAR busy: boolean): pc_logical_name_type;     $  { gets the pc_logical_name of a node from the ipl file table file given $     the network lu and LAN address }       VAR   table: ipl_file_table_type;          hold_record: ipl_file_table_record_type;          test_record: ipl_file_table_record_type;  
        eof_flag: boolean; 
        match: boolean;          nlu: shortint;          pos: shortint;  
        lu_str: string[3]; 
        BEGIN      open_ipl_file_table(table,error,busy);       IF NOT (busy OR error) THEN         BEGIN           match := false;           hold_record.default_use := '0';           hold_record.pc_logical_name := ' ';              REPEAT  "           test_record := read_ipl_file_table(table,error,eof_flag); "            IF NOT error THEN WITH test_record DO  	             BEGIN 	                lu_str := '';                 strmove(3,network_lu,1,lu_str,1);                strread(lu_str,1,pos,nlu);                IF net_lu = nlu THEN                   BEGIN                    IF LAN_address = LAN_addr THEN  
                     BEGIN 
                       match := true;                        IF hold_record.default_use <> '1' THEN                          hold_record := test_record 
                       ELSE 
                          BEGIN                             IF default_use = '1' THEN                               hold_record := test_record;                          END;                      END; 
                 END; 
             END;          UNTIL eof_flag OR error;               IF NOT (busy OR error) THEN             IF NOT match THEN  	             BEGIN 	               error := true;                 strwrite(trace_str,1,trace_pos,                  'no IPL file entry for LU ',net_lu:3,' address ',                 LAN_addr); 
               trace_write; 
             END;        END;       get_pc_name := hold_record.pc_logical_name;  	     close(table); 	    END;  { get_pc_name }     &FUNCTION get_LAN_address(pc_name: pc_logical_name_type; VAR net_lu: shortint; &                          VAR error: boolean;                           VAR busy: boolean): LAN_address_type;     $  { gets the LAN address and network lu of a node from the ipl file table $     file given the pc_logical_name }       VAR   table: ipl_file_table_type;          hold_record: ipl_file_table_record_type;          test_record: ipl_file_table_record_type;  
        eof_flag: boolean; 
        match: boolean;          pos: shortint;  
        lu_str: string[3]; 
        name_str: string[32];         BEGIN       hold_record.LAN_address := ' ';      { cover error exit }      open_ipl_file_table(table,error,busy);       IF NOT (busy OR error) THEN         BEGIN           match := false;           hold_record.default_use := '0';          hold_record.network_lu := '  0';               name_str := '';  %         strmove(17,pc_name,1,name_str,1);          { for error printing } %          name_str := strrtrim(strltrim(name_str));              REPEAT  "           test_record := read_ipl_file_table(table,error,eof_flag); "            IF NOT error THEN WITH test_record DO  	             BEGIN 	                IF pc_logical_name = pc_name THEN                   BEGIN                    match := true;                    IF hold_record.default_use <> '1' THEN                      hold_record := test_record                    ELSE  
                     BEGIN 
                        IF default_use = '1' THEN                           hold_record := test_record;                      END; 
                 END; 
             END;          UNTIL eof_flag OR error;               IF NOT (busy OR error) THEN             IF NOT match THEN  	             BEGIN 	               error := true;                 strwrite(trace_str,1,trace_pos,                'no IPL file entry for pc_logical_name '); 
               trace_write; 
               trace_str := name_str; 
               trace_write; 
              END            ELSE  	             BEGIN 	                lu_str := '';                 strmove(3,hold_record.network_lu,1,lu_str,1); 	               TRY; 	                  strread(lu_str,1,pos,net_lu);                 IF recover THEN                   BEGIN                    error := true;                    net_lu := 0;                     strwrite(trace_str,1,trace_pos,name_str);                    trace_write;                    trace_str := "                    'IPL file entry does not contain a valid LAN lu'; "                   trace_write; 
                 END; 
             END;        END;       get_LAN_address := hold_record.LAN_address;  	     close(table); 	
   END; { get_LAN_address } 
     FUNCTION get_no_LAN_address(pc_name: pc_logical_name_type;                              pc_no: pc_logical_no_type;                           VAR net_lu: shortint;                           VAR error: boolean;                           VAR busy: boolean): LAN_address_type;     $  { gets the LAN address and network lu of a node from the ipl file table $     file given the pc_logical_name }       VAR   table: ipl_file_table_type;          hold_record: ipl_file_table_record_type;          test_record: ipl_file_table_record_type;  
        eof_flag: boolean; 
        match: boolean;          pos: shortint;  
        lu_str: string[3]; 
        name_str: string[32];         BEGIN       hold_record.LAN_address := ' ';      { cover error exit }      open_ipl_file_table(table,error,busy);       IF NOT (busy OR error) THEN         BEGIN           match := false;           hold_record.default_use := '0';          hold_record.network_lu := '  0';               name_str := '';  %         strmove(17,pc_name,1,name_str,1);          { for error printing } %          name_str := strrtrim(strltrim(name_str));              REPEAT  "           test_record := read_ipl_file_table(table,error,eof_flag); "            IF NOT error THEN WITH test_record DO  	             BEGIN 	&               IF (pc_logical_name = pc_name) or (pc_logical_no = pc_no) THEN &                  BEGIN                     pc_name := pc_logical_name;                     pc_no := pc_logical_no;                    match := true;                    IF hold_record.default_use <> '1' THEN                      hold_record := test_record                    ELSE  
                     BEGIN 
                        IF default_use = '1' THEN                           hold_record := test_record;                      END; 
                 END; 
             END;          UNTIL eof_flag OR error;               IF NOT (busy OR error) THEN             IF NOT match THEN  	             BEGIN 	               error := true;                 strwrite(trace_str,1,trace_pos,                'no IPL file entry for pc_logical_name '); 
               trace_write; 
               trace_str := name_str; 
               trace_write; 
              END            ELSE  	             BEGIN 	                lu_str := '';                 strmove(3,hold_record.network_lu,1,lu_str,1); 	               TRY; 	                  strread(lu_str,1,pos,net_lu);                 IF recover THEN                   BEGIN                    error := true;                    net_lu := 0;                     strwrite(trace_str,1,trace_pos,name_str);                    trace_write;                    trace_str := "                    'IPL file entry does not contain a valid LAN lu'; "                   trace_write; 
                 END; 
             END;        END;      get_no_LAN_address := hold_record.LAN_address;  	     close(table); 	
   END; { get_LAN_address } 
     END;      IMPORT $SEARCH 'TRY_RECOVER.REL'$ try_recover;  IMPORT $SEARCH 'VCP_DECLS.REL'$ vcp_decls;  IMPORT $SEARCH 'TEST_PROCS.REL'$ test_procs;  IMPORT $SEARCH 'VCPMT_TRACE.REL'$ VCPMT_trace;  IMPORT $SEARCH 'vtimr_sub.rel'$ vtimr_sub;  {IMPORT $SEARCH 'VCPMT_IPL_T.REL'$ VCPMT_ipl_table;} IMPORT VCPMT_ipl_table;          VAR   VCP_session_table_head: VCP_session_control_block_ptr;     
      i,pos: integer; 
       term_buff: term_buff_type;        in_string: term_string_type;  
      trans_log: shortint; 
 
      buff_size: shortint; 
      control_word: cntwd_type; 
      code: shortint; 
       dummy: shortint;       status: shortint;       timeout_value:shortint;       timeout_rtn1 :shortint;        status_error: boolean;       err_buff:  octal_numb_buffer;       uv_dummy: completion_data_type;       class_get_flag: completion_data_type;       session_numb_max: shortint;        session_numb: VCP_session_number_type;       session_ptr: VCP_session_control_block_ptr;       original_request: shortint;        parameter_1: shortint;        parameter_2: shortint;        a_reg: shortint;        b_reg: shortint;       prog_name: program_name_type;        class: shortint;        VCPMT_class: shortint;  &      VCPMT_get_class: shortint;    { class number with save class bit set } &       VTIMR_class: shortint;        VTIMR_active: boolean;        my_lsap: shortint;       master_timeout_seq: shortint;     
      number_lus: shortint; 
      lu_array: ARRAY [1..max_LAN_lus] OF shortint;      
    { standard I/O } 
           user_lu: shortint;      
    { error accumulators } 
           get_error_count: shortint;        class_error_count: shortint; 
      rmp_array:parm_array; 
       sap_f8_class:shortint; 
      sap_1_class:shortint; 

      sap_9_class:shortint; 
	      msg:shortint; 	 
      msgl:shortint; 
         VAR   global_remote_data: LAN_buffer_type; $      global_rtn1,global_rtn2,global_rtn3: shortint; { class get return } $ "      global_status,global_trans_log: shortint; { class get return } "       global_class_get_flag: completion_data_type;  $PAGE$  $INCLUDE 'VCP_EXTERNALS.pasi'$  $INCLUDE 'FMP_EXTERNALS.pasi'$       { We cheat pascal out of type checking here on the TOO variable.  !   The problem is that the 'data' type of VCP_Data is not available ! #   for use in the declarations, and I don't want to change them now. } #    FUNCTION buildtbuf(VAR from: rplrd;               VAR too :  LAN_buffer_type;               len,add: shortint): shortint; EXTERNAL;     %PROCEDURE return_to_session(VAR message: LAN_buffer_type; length: shortint; %!                                scb: VCP_session_control_block_ptr; !                                rtn1,rtn2,rtn3: shortint;                                   get_flag: completion_data_type);                               FORWARD;     $AUTOPAGE ON$  $PAGE$      PROCEDURE clear_LAN_class_entries;      { this procedure clears the LAN class entries for all network lus    initialized to VCPMT. Only used in error processing, so if an   error occurs, too bad, abort. }     
  VAR   lu_index: shortint; 
        control_word: cntwd_type;         lsap: shortint;       BEGIN     control_word[1] := clear_class_entry;     lsap := VCPMT_lsap;     dummy := 0;      control_word[0] := lu_array[lu_index];      FOR lu_index := 1 TO number_lus DO       BEGIN        { and now check if a dispatcher is running           }        { first look at sap F8                               }         code := io_control_code + no_abort;        control_word[1] := get_class_number;  	       dummy := 0; 	
       exec_error := false; 
        { mod for the changes for the 802.3 driver 8/2/85 JWHS}        io_control(code,control_word,my_lsap,0,20465,20465);         BEGIN          error_return(error_a_reg,error_b_reg);          exec_error := test_exec_error;          END;         a_b_register(status,dummy);         status_error := binand(status,error_bit_mask) <> 0;          return_parms(rmp_array);         sap_f8_class:=rmp_array[3];          sap_1_class:=-1;          { and now look for sap 9 }         code := io_control_code + no_abort;          control_word[1] := get_class_number; 	        dummy := 0; 	         exec_error := false;            { mod for the changes for the 802.3 driver 8/2/85 JWHS}           io_control(code,control_word,9,0,20465,20465);           BEGIN            error_return(error_a_reg,error_b_reg);            exec_error := test_exec_error;          END;           a_b_register(status,dummy);           status_error := binand(status,error_bit_mask) <> 0;          return_parms(rmp_array);          sap_9_class:=rmp_array[3];              if(sap_f8_class = sap_9_class) 	         then begin 	           {only do this if I'm realy workink on sap f8 } $          io_control(io_control_code + no_abort,control_word,lsap,0,0,0); $          BEGIN              error_return(error_a_reg,error_b_reg);              exec_error := test_exec_error;            END;          end; $        {this code is for 802.3 clearing of the class # from the special} $         {progam code that is in the driver for VCP   8/2/85 JWHS}  "        control_word[0] := lu_array[lu_index]; { might not be needed} "        {9 is the special program code}  '        io_control(io_control_code + no_abort,control_word,Vcp_program_code,0, '          0,0);         BEGIN            error_return(error_a_reg,error_b_reg);            exec_error := test_exec_error;          END;        END;    END;      PROCEDURE trace_error;       BEGIN 
    trace_level := 0; 
     IF NOT trace_post(-4) THEN ;    END; { trace_error }      PROCEDURE trace_session_entry(scb: VCP_session_control_block_ptr;                                rtn1: shortint;                                get_flag: completion_data_type);       BEGIN      WITH scb^ DO #      IF ((NOT active) AND (trace_level = 1)) OR (trace_level > 1) THEN #            BEGIN $          strwrite(trace_str,1,trace_pos,session_type,' session number ', $                     session_number:1);            trace_write;            IF active THEN             BEGIN               strwrite(trace_str,1,trace_pos,'state vector = ',                        state_vector); #              IF suspended THEN strwrite(trace_str,trace_pos,trace_pos, #                                           ' SUSPENDED');  
              trace_write; 
            END            ELSE             BEGIN               trace_str := 'initial entry';  
              trace_write; 
             END;  #          strwrite(trace_str,1,trace_pos,'class get compeltion type ', #                   get_flag.comp_type);           IF (get_flag.comp_type = timeout_occured) AND              (rtn1 <> timeout_seq) THEN $            strwrite(trace_str,trace_pos,trace_pos,' timeout not valid'); $           trace_write;            IF NOT trace_post(3) THEN trace_error;          END;        END; { trace_session_entry }      PROCEDURE trace_session_exit(scb: VCP_session_control_block_ptr);        VAR mem_info: info_rec;  
      min_space: shortint; 
      BEGIN      WITH scb^ DO #      IF ((NOT active) AND (trace_level = 1)) OR (trace_level > 1) THEN #            BEGIN $          strwrite(trace_str,1,trace_pos,session_type,' session number ', $                     session_number:1);            trace_write;            IF active THEN             BEGIN               strwrite(trace_str,1,trace_pos,'state vector = ',                        state_vector); #              IF suspended THEN strwrite(trace_str,trace_pos,trace_pos, #                                           ' SUSPENDED');             END            ELSE             BEGIN               strwrite(trace_str,1,trace_pos,'SESSION ENDED,');                   get_mem_info(mem_info); #              min_space := mem_info.high_toh - mem_info.high_tos - 264; # #              strwrite(trace_str,trace_pos,trace_pos,' min memory = ', #                       min_space:1,' words');              END;            trace_write;            IF NOT trace_post(4) THEN trace_error;          END;       END; { trace_session_exit }          
PROCEDURE get_error; 
    "  { Called to report class get error and increment get_error_counter. "     Reports error using global abreg error values error_a_reg and   "    error_b_reg. If global get_error_counter exceeds global constant " #    error_limit the program is aborted.                              } #      BEGIN      strwrite(trace_str,1,trace_pos,error_a_reg,error_b_reg);      trace_write;     IF NOT trace_post(-1) THEN trace_error;         get_error_count := get_error_count + 1;     IF get_error_count > get_error_limit THEN       BEGIN          IF NOT trace_post(-11) THEN trace_error;          clear_LAN_class_entries;  
        trace_close; 
 
        escape(NIL); 
       END; 
  END;  { get_error } 
         PROCEDURE class_error;      #  { Called to report class io error and increment class_error_counter. #     Reports error using global abreg error values error_a_reg and   #    error_b_reg. If global class_error_counter exceeds global constant # #    error_limit the program is aborted.                              } #      BEGIN      strwrite(trace_str,1,trace_pos,error_a_reg,error_b_reg);      trace_write;     IF NOT trace_post(-2) THEN trace_error;         class_error_count := class_error_count + 1;     IF class_error_count > class_error_limit THEN       BEGIN          IF NOT trace_post(-11) THEN trace_error;          clear_LAN_class_entries;  
        trace_close; 
 
        escape(NIL); 
       END;   END;  { class_error }      PROCEDURE up_shift(VAR s: string);      	  VAR i: shortint; 	       c: char;       BEGIN      FOR i := 1 TO strlen(s) DO       BEGIN  	        c := s[i]; 	        CASE c OF            'a'..'z': s[i] := chr(ord('A') + ord(c) - ord('a'));  
          otherwise; 
         END;        END;    END;     
PROCEDURE flush_completion; 
     %  { does a class_get_no_buff to flush current class completion and handles %     errors }        VAR dummy: shortint;       uv: completion_data_type;       BEGIN  {}  {   exec_error := false;  {   class_get_no_buff(class_get_code + no_abort, VCPMT_get_class,   {                     dummy,0,dummy,dummy,dummy,uv); {   BEGIN  {     error_return(error_a_reg,error_b_reg);  {     exec_error := test_exec_error;  {   END; {   IF exec_error THEN get_error ELSE get_error_count := 0;  {} 
  END; { flush_completion } 
         
PROCEDURE trace_level_set; 
    ! { On entry assume that a clsss read saving buffer has been done to !$   return the type flag, the next class get returns the same information. $"   The trace file name is in the buffer and the level is in the first "#   parameter. Handle any errors and call trace_control in "VCPMT_trace" #    to make the required trace state changes. }        VAR file_name: string[64];        file_name_buff: file_path_name_type;        level: shortint;       length: shortint;        trace_open_error: boolean;       BEGIN      exec_error := false;          class_get_trace(class_get_code + no_abort,VCPMT_get_class,                     file_name_buff,-64,level,                    dummy,dummy,uv_dummy);     BEGIN        error_return(error_a_reg,error_b_reg);        exec_error := test_exec_error;      END;     a_b_register(dummy,length);         IF exec_error THEN { rte error on exec call }       get_error      ELSE       BEGIN         get_error_count := 0;  &        trace_control(level,file_name_buff,length,false,0,trace_open_error); &       END;  
  END; { trace_level_set } 
     PROCEDURE VTIMR_error_trace;     ! { On entry assume that a clsss read saving buffer has been done to !$   return the type flag, the next class get returns the same information. $$   The trace/error number is in the first parameter, any optional message $ %   is in the buffer. Handle any errors and call trace_write and trace_post %   in "VCPMT_TRACE" to log the trace or report the error. }       VAR length: shortint;        optional_text: term_buff_type;        dummy: shortint;       uv_dummy: completion_data_type;       trace_error_code: shortint;       BEGIN      exec_error := false;         class_get_term(class_get_code + no_abort,VCPMT_get_class,                     optional_text,-72,trace_error_code,                    dummy,dummy,uv_dummy);     BEGIN        error_return(error_a_reg,error_b_reg);        exec_error := test_exec_error;      END;     a_b_register(dummy,length);         IF exec_error THEN { rte error on exec call }       get_error      ELSE       BEGIN         get_error_count := 0;  
        IF length > 0 THEN 
          BEGIN              strmove(length,optional_text,1,trace_str,1);              setstrlen(trace_str,length);              trace_write;            END;         IF NOT trace_post(trace_error_code) THEN trace_error;        END;  
  END; { trace_level_set } 
     PROCEDURE report_no_session(slu,pclass: shortint; busy: boolean);        { This procedure reports to the user and error printer that a !   session allocation failed because the maximum number of sessions ! #   has been reached or the remote node was already busy with a session #    from theis node. Slu and pclass are decoded thus:               slu      pclass                 0         0      no session, just print error             0         n      programatic session, send to class             n         x      interactive session, send to terminal          }      
  VAR len: shortint; 
	      pos: integer; 	 
      exec_code: shortint; 
      control_word: cntwd_type;       flag: completion_data_type;        class: shortint; 
      error_numb: shortint; 
      prompt: shortint;        term_buff: term_buff_type;        in_string: term_string_type;       BEGIN      IF busy THEN       error_numb := -24      ELSE       error_numb := -3;         IF NOT trace_post(error_numb) THEN trace_error;      
    in_string := ''; 
         IF busy THEN %      strwrite(in_string,1,pos,'RMVCP> VCP session already active, cannot', %                               ' initiate new session')      ELSE "      strwrite(in_string,1,pos,'RMVCP> Maximum number of sessions (', "                session_numb_max:1,                  ') exceded, unable to initiate session.');         len := - pos;         strread(in_string,1,pos,term_buff);         IF slu = 0 THEN  { programmatic session send to program }       BEGIN          exec_code := class_write_read_code + no_abort;          class := pclass;         flag.comp_type := program_read;       END      ELSE             { send to user's terminal }       BEGIN         exec_code := class_write_code + no_abort;         class := VCPMT_class;         flag.comp_type := terminal_write;          error_numb := 0;        END;          IF class <> 0 THEN       BEGIN         control_word[0] := slu;         control_word[1] := 0;  
        prompt := 0; 
         exec_error := false;         class_io_term(exec_code,control_word,term_buff,len, #                                         error_numb,prompt,class,flag); #        BEGIN            error_return(error_a_reg,error_b_reg);            exec_error := test_exec_error;          END;             IF exec_error THEN { rte error on exec call }           BEGIN #            IF slu = 0 THEN class_error_count := class_error_count - 1; #                              { don't abort if user program gone }               class_error;           END          ELSE           class_error_count := 0;        END;        END; { report_no_session }             FUNCTION get_scb(get_flag: completion_data_type):  '                                                VCP_session_control_block_ptr; '     % { This procedure is called after a class get and given the session number %    in the uv parameter. Given the session number, indexes into  $   the session table and returns a pointer to the session control block. $$   Checks for not active or end of table and returns NIL if not all ok. } $       VAR   sess_table_index: VCP_session_number_type;          sess_table_ptr: VCP_session_control_block_ptr;          not_ok: boolean;       BEGIN      get_scb := NIL; { cover not found exit     &    IF get_flag.session > 0 THEN  { try to find scb, else = 0 a dummy session & &                                  no session should be found, skip the whole &                                  thing }     BEGIN        sess_table_index := 1;       sess_table_ptr := VCP_session_table_head;        not_ok := false;           WHILE (sess_table_index < get_flag.session) AND              (sess_table_ptr <> NIL) DO         BEGIN           sess_table_ptr := sess_table_ptr^.next_scb;           sess_table_index := sess_table_index + 1;          END;            { If all ok then pass out sess_table_ptr }           IF sess_table_ptr <> NIL THEN         WITH sess_table_ptr^ DO           BEGIN              IF active AND (state_vector <> ended) THEN               get_scb := sess_table_ptr              ELSE not_ok := true;           END  
      ELSE not_ok := true; 
           { if tracing then log possible unexpected session numbers }             IF not_ok AND (trace_level > 0) THEN         BEGIN                { prepare trace_str for possible error message }               strwrite(trace_str,1,trace_pos,get_flag.session:1);            trace_write;  #          strwrite(trace_str,1,trace_pos,'class get completion type ', #                   get_flag.comp_type);            trace_write;                IF sess_table_ptr = NIL THEN  { not found, error }             BEGIN                IF NOT trace_post(10) THEN trace_error             END            ELSE { found, must not be active }              IF NOT trace_post(9) THEN trace_error;         END; { not ok }     END; { session_number > 0 }  	  END; { get_scb } 	     FUNCTION get_father(scb: VCP_session_control_block_ptr):  '                                                VCP_session_control_block_ptr; '      { returns pointer to ultimate father of a session }      
  VAR done: boolean; 
      BEGIN  	    done := false; 	     REPEAT        IF scb^.father <> NIL THEN         BEGIN %          IF scb^.father^.active THEN scb := scb^.father ELSE done := true; %        END        ELSE done := true;     UNTIL done;      get_father := scb; 
  END; { get_father } 
     PROCEDURE read_user(scb: VCP_session_control_block_ptr);     #{ posts a class read on the user whether terminal or program using scb^ #   from interactive_session }        VAR  control_word: cntwd_type;         flag: completion_data_type;         buff: term_buff_type;  
       lu: shortint; 
       class: shortint;       BEGIN 	    flag.word := 0; 	     IF scb <> NIL THEN       BEGIN          flag.session := scb^.session_number;          flag.comp_type := terminal_read;         scb := get_father(scb);         IF scb^.session_type = interactive THEN           BEGIN             class := scb^.user_class;             lu := scb^.user_lu;           END          ELSE           BEGIN             class := 0;           {lu := sys_console_lu;} 	           lu := 0; 	           END;       END      ELSE       BEGIN  
        flag.session := 0; 
	        class := 0; 	        {lu := sys_console_lu;}          lu := 0;        END;         IF class = 0 THEN  { actually read, else exit }       BEGIN          control_word[1] := echo;          control_word[0] := lu;          exec_error := false;          class_io_term(class_read_code+no_abort,control_word,                           buff,-80,0,0,VCPMT_class,flag);         BEGIN            error_return(error_a_reg,error_b_reg);            exec_error := test_exec_error;          END; !        IF exec_error THEN class_error ELSE class_error_count := 0; !       END; { if user_class = 0 }     END;  { read_user }      PROCEDURE write_user(scb: VCP_session_control_block_ptr; !                     user_msg: term_string_type; err_val: shortint; !                     prompt: boolean;                       sup_crlf: boolean);        { Handles all terminal or interactive program writes }           VAR control_word: cntwd_type;  
      exec_code: shortint; 
      buffer: term_buff_type;       length: shortint;       flag: completion_data_type; 	      lu: shortint; 	       class: shortint; 
      prompt_val: shortint; 
       caller_scb: VCP_session_control_block_ptr;       BEGIN         { set up session/non-session dependencies }     	    flag.word := 0; 	     IF scb <> NIL THEN       BEGIN          flag.session := scb^.session_number;         flag.comp_type := terminal_write;  
        caller_scb := scb; 
        scb := get_father(scb);         IF scb^.session_type = interactive THEN           BEGIN             class := scb^.user_class;             lu := scb^.user_lu;           END          ELSE           BEGIN             class := 0;           {lu := sys_console_lu;} 	           lu := 0; 	           flag.comp_type := console_write;            END;       END      ELSE       BEGIN  
        flag.session := 0; 
         flag.comp_type := console_write; 	        class := 0; 	        {lu := sys_console_lu;}          lu := 0;        END;         length := strlen(user_msg);      strmove(length,user_msg,1,buffer,1); 
    control_word[0] :=  lu; 
    "    IF sup_crlf THEN control_word[1] := transparent { suppress crlf } "     ELSE control_word[1] := 0;     
    IF class = 0 THEN 
      BEGIN         class := VCPMT_class;         exec_code := class_write_code + no_abort; 
        err_val := 0; 
         prompt_val := 0;       END      ELSE       BEGIN          exec_code := class_write_read_code + no_abort;          prompt_val := ord(prompt);         flag.comp_type := program_read;        END;          exec_error := false;      class_io_term(exec_code,control_word,buffer,-length,                       err_val,prompt_val,class,flag);     BEGIN        error_return(error_a_reg,error_b_reg);        exec_error := test_exec_error;      END;      IF exec_error THEN       BEGIN          IF lu = 0 THEN      $        { don't abort program if user program dies, but do abort session $ !          so that a new session can be started to regain control } !              BEGIN             class_error_count := class_error_count - 1;              scb^.state_vector := session_failed;             caller_scb^.state_vector := session_failed;            END;  
        class_error; 
      END     ELSE  class_error_count := 0;        END;  { write_user }     PROCEDURE report_network_error(driver_stat: shortint;                                        nlu: shortint; %                                       scb: VCP_session_control_block_ptr); %    % { This procedure is used to report network driver errors detected by error %#   status return after class get on network reads or writes. Errors are # $   written to the trace file if tracing is enabled, to the error_printer $    and to the session terminal if a session is interactive and "   active. On entry the parameter nlu contains the network lu and scb "#   contains the session control block pointer if a session is involved, #$   or NIL.                                                              } $       VAR error_buff: octal_numb_buffer;       error_number: shortint; 	      pos: integer; 	      term_str: term_string_type;       BEGIN     error_number := binand(driver_stat,error_code_mask) div 16;     octal_cnvrt(error_number,error_buff);     IF error_buff[5] = ' ' THEN error_buff[5] := '0';          strwrite(trace_str,1,trace_pos,'Driver error ',error_buff[5],   "                                           error_buff[6],'B on LU ', "!                                                            nlu:3); !     trace_write;      IF NOT trace_post(-13) THEN trace_error;              IF scb <> NIL THEN       IF get_father(scb)^.session_type = interactive THEN             { an interactive session needs to be notified }             BEGIN               term_str := '';  $          strwrite(term_str,1,pos,'RMVCP> Driver error "',error_buff[5], $                    error_buff[6],'B" on LU ',nlu:1);               write_user(scb,term_str,-13,false,false);      &        END; { interactive session, else trace error logging is sufficient } &      END; { report_network_error }         FUNCTION allocate_scb: VCP_session_control_block_ptr;         % { Searches the session table and returns a pointer to the first not active % %   session control block. If no not active scb's found, news up a new one, %%   initializes it, and returns a pointer to it. If unable to allocate a new % &   session (due to memory shortage/maximum number of sessions exceeded) will &
   return a NIL pointer.  } 
      VAR session_table_index: VCP_session_number_type; 
      found: boolean; 
      session_table_ptr: VCP_session_control_block_ptr;        last_session: VCP_session_control_block_ptr;       BEGIN     session_table_index := 0; 	    found := false; 	     session_table_ptr := VCP_session_table_head;          REPEAT       session_table_index := session_table_index + 1;       IF NOT session_table_ptr^.active THEN found := true        ELSE         BEGIN            last_session := session_table_ptr;           session_table_ptr := session_table_ptr^.next_scb;          END;     UNTIL found OR (session_table_ptr = NIL);      !    IF NOT found AND (session_table_index < session_numb_max) THEN !      BEGIN         new(session_table_ptr);          last_session^.next_scb := session_table_ptr;         session_table_index := session_table_index + 1;         session_table_ptr^.next_scb := nil;          session_table_ptr^.session_number := session_table_index;           session_table_ptr^.timeout_seq := 0;        END;         IF session_table_ptr <> NIL THEN WITH session_table_ptr^ DO       BEGIN          active := false;         pc_logical_name := ' ';          father := NIL;         timeout_seq := (timeout_seq + 1) mod 32768; 
        suspended := false; 
         fail_pending := false;        END;      allocate_scb := session_table_ptr;   END; { allocate_scb }     
PROCEDURE set_max_sessions; 
       { This procedure sets the maximum number of sessions (scb's)      that can be allocated given the amount of memory left between       the top of heap and top of stack. The global variable,      session_numb_max is set, the global constant #    VCP_session_control_block_size is the memory required for each scb, # #    and the global constant mem_space_fudge is the estimated amount of #!    stack and stack growth (for other than scb allocation) required !
    by the program. } 
      VAR mem_info: info_rec;       BEGIN 
    get_mem_info(mem_info); 
 #    session_numb_max := (mem_info.init_toh - mem_info.init_tos - 264 - # !              mem_space_fudge) div VCP_session_control_block_size; !    IF session_numb_max > 255 THEN session_numb_max := 255;    END;         PROCEDURE display_message(VAR message: LAN_buffer_type;                           length: shortint;                           scb: VCP_session_control_block_ptr;                            net_address: LAN_address_type;                           net_lu: shortint;                            sup_leader: boolean;                            sup_trailer: boolean);      # { Sends the VCP message to the lu specified. Called by unexpected and # &   interactive sessions. If scb is not nil but not interactive, message goes &
   to system console. 
     &   If scb is NIL, net_address and net_lu are used to get the pc_logical_name &#   from the ipl file table file, otherwise all three are taken from the #%   scb. Sup_leader and sup_trailer will suppress the printing of the leader %   and trailer respectivly. }        CONST border = ''>>------------------------------------------------------------------------<<'; '             hex_char = '0123456789ABCDEF';           cr = chr(13);           lf = chr(10);           del = chr(255);          null = chr(0);         VAR line: term_string_type; 
       pos: shortint; 
        in_pos: shortint; 
       in_number: shortint; 
        cr_pos: shortint;         lf_pos: shortint;        del_pos: shortint;  
       out_leng: shortint; 
       pc_name: pc_logical_name_type;        name_str: string[pc_logical_name_max];  
       ipl_error: boolean; 
       ipl_busy: boolean;         message_type: string[64];         time: time_array;        file_numb_buff: octal_numb_buffer;        addr_buff: LAN_address_type;  
       msg_type: shortint; 
      BEGIN            { If the scb exists take information from it, otherwise look it  !    up in the ipl file table                                      } !        IF scb <> NIL THEN WITH scb^ DO       BEGIN         net_address := LAN_address;         net_lu := LAN_lu;         pc_name := pc_logical_name;       END         ELSE   { no scb, get name from ipl file table }           BEGIN         pc_name := get_pc_name(net_lu, net_address,                                ipl_error,ipl_busy);          IF ipl_busy THEN pc_name := '<name undef. now>';         IF ipl_error THEN           BEGIN              pc_name := '<name unknown>';             IF NOT trace_post(-5) THEN trace_error;            END;        END;       { figure out the type of message that arrived }          WITH message.data DO       BEGIN             msg_type := VCP_type; 
        message_type := ''; 
         CASE msg_type OF      	          1: BEGIN 	                IF scb = NIL THEN                  message_type := 'Unexpected Message' 	               ELSE 	                 message_type := 'Message';                  { detect stray dump requests and dump data }      $               IF (length = LAN_header_length + VCP_type_length + 2) AND $                   (message.b[length - 1] = 1) THEN                   BEGIN                     message_type := 'Dump Request';                    msg_type := 3; { prevent data printing }  
                 END 
	               ELSE 	                  BEGIN                     IF message.b[length] = 0 THEN  
                     BEGIN 
                        IF message.b[length - 2] = 1 THEN                           BEGIN                            message_type := 'Dump Data';                            msg_type := 3;                          END;                       END                      ELSE  
                     BEGIN 
                        IF message.b[length - 1] = 1 THEN                           BEGIN                            message_type := 'Dump Data';                            msg_type := 3;                          END;                      END; 
                 END; 
             END;               2: message_type := 'Command';               3: message_type := 'Address Acquisition Request';                4: message_type := 'General Address Acquisition Reply';       !          5: message_type := 'Directed Address Acquisition Reply'; !     	          6: BEGIN 	               pos := VCP_data.RPL_request;                    octal_cnvrt(pos,file_numb_buff);                FOR pos := 2 TO 6 DO                   BEGIN  (                   IF file_numb_buff[pos] = ' ' THEN file_numb_buff[pos] := '0'; (
                 END; 
                file_numb_buff[1] := '#'; "               strwrite(message_type,1,pos,'Boot Request for File  ', "                                             file_numb_buff);              END;                7: message_type := 'Download (Boot) Record';      	          8: BEGIN 	                message_type := 'Download Acknowledgement';                IF VCP_data.download_ack = download_ack_val THEN                   message_type := message_type + ' ACK' 	               ELSE 	                 message_type := message_type + ' NAK';              END;               9: message_type := 'Break Request';      	         10: BEGIN 	                message_type := 'Dump Command';                 IF VCP_data.c0 = 0 THEN  !                 message_type := message_type + ': dump finished'; !                IF VCP_data.c0 = 255 THEN                   IF VCP_data.c1 = 0 THEN %                   message_type := message_type + ': dump request rejected' %
                 ELSE 
!                   message_type := message_type + ': dump aborted'; !               IF (VCP_data.c0 > 0) AND                   (VCP_data.c0 <= 128) THEN  '                 strwrite(message_type,1,pos,'Dump Command: send dump record', '                           ' length ',VCP_data.c0:1);              END;      	         11: BEGIN 	                   IF odd(VCP_data.LAN_addr[1]) THEN  { multicast }                  addr_buff := 'UNKNOWN' 	               ELSE 	                 FOR pos := 0 to 5 DO                     BEGIN                       addr_buff[2*pos+1] := "                       hex_char[1 + VCP_data.LAN_addr[pos+1] div 16]; "                      addr_buff[2*pos+2] := "                       hex_char[1 + VCP_data.LAN_addr[pos+1] mod 16]; "                   END;                    strwrite(message_type,1,pos,'Protocol Error: ');                 CASE VCP_data.error_numb OF                       1: strwrite(message_type,pos,pos, !                            'disengaged by BREAK from ',addr_buff); !                      2: strwrite(message_type,pos,pos, #                            'not in VCP (file server: ',addr_buff,')'); #                      3: strwrite(message_type,pos,pos,                              'in VCP with ',addr_buff);                       4: strwrite(message_type,pos,pos,                              'receiving Boot from ',addr_buff);      
                 OTHERWISE 
                       strwrite(message_type,pos,pos,                              'unknown error number ',                             VCP_data.error_numb:1);                    END;  { CASE }               END; { 11 }               OTHERWISE message_type := 'Unknown message type';      
        END { CASE } 
           END; { WITH message.data }       { Display the message for the user or console }      
    IF NOT sup_leader THEN 
        { Package and send the first line }           BEGIN         line := border;          strwrite(line,5,pos,'VCP ',message_type,' arrived');         write_user(scb,line,0,false,false);            { Package and send the second line }             name_str := '';          strmove(pc_logical_name_max,pc_name,1,name_str,1);         name_str := strrtrim(strltrim(name_str));         line := border;          strwrite(line,5,pos,'from ',name_str);         write_user(scb,line,0,false,false);           { Package and send the third line }             line := border;          strwrite(line,5,pos,'at address ',                              net_address,' on lu ',net_lu:1);         write_user(scb,line,0,false,false);        END;        { Send the text (if any) }          IF (msg_type = 1) OR (msg_type = 2) THEN       WITH message.data.VCP_data DO         BEGIN            in_pos := 1;              { set the length of the vcp data and trim the termination             flag, del, and null if necessary }     "          length := length - LAN_header_length - VCP_type_length - 1; "           IF ord(data[length + 1]) = 0 THEN length := length - 1;             IF msg_type = 1 THEN length := length - 1;               WHILE in_pos <= length DO             BEGIN               in_number := length - in_pos + 1;               IF in_number > 80 THEN in_number := 80;               line := '';                strmove(in_number,data,in_pos,line,1);               in_pos := in_pos + in_number;                 { send the record }      &              write_user(scb,line,0,false,true);    { let VCP supply crlfs } &     
            END; { WHILE } 
         END; { IF ... WITH }        { Package and send the last line }     
    IF NOT sup_trailer THEN 
      BEGIN         IF ((msg_type = 1) OR (msg_type = 2)) AND  !           ((strpos(line,lf) <> out_leng) OR (out_leng <= 1)) THEN !    $         { last line did not end in crlf, send 0 length record for crlf } $              write_user(scb,'',0,false,false);          
        format_time(time); 
        line := border;         strwrite(line,26,pos,time);         write_user(scb,line,0,false,false);           { one bLANk line to separate messages }             write_user(scb,'',0,false,false);        END;        END; {display_message}       FUNCTION extract_LAN_source_addr(VAR LAN_buff: LAN_buffer_type):  #                                                      LAN_address_type; #       CONST hex_char = '0123456789ABCDEF';        VAR   LAN_address: LAN_address_type;       BEGIN  
    WITH LAN_buff DO 
      BEGIN         LAN_address[1] := hex_char[1 + sa1 div 16];         LAN_address[2] := hex_char[1 + sa1 mod 16];         LAN_address[3] := hex_char[1 + sa2 div 16];         LAN_address[4] := hex_char[1 + sa2 mod 16];         LAN_address[5] := hex_char[1 + sa3 div 16];         LAN_address[6] := hex_char[1 + sa3 mod 16];         LAN_address[7] := hex_char[1 + sa4 div 16];         LAN_address[8] := hex_char[1 + sa4 mod 16];         LAN_address[9] := hex_char[1 + sa5 div 16];          LAN_address[10] := hex_char[1 + sa5 mod 16];          LAN_address[11] := hex_char[1 + sa6 div 16];          LAN_address[12] := hex_char[1 + sa6 mod 16];        END;     extract_LAN_source_addr := LAN_address;    END; { extract_LAN_source_addr }     PROCEDURE insert_LAN_dest_addr(VAR LAN_buff: LAN_buffer_type;                             VAR address: LAN_address_type);       VAR addr: string[12];  
      pos: shortint; 
      BEGIN     addr := '';     strwrite(addr,1,pos,address);  
    WITH LAN_buff DO 
      BEGIN          da1 := hex(str(addr,1,2));          da2 := hex(str(addr,3,2));          da3 := hex(str(addr,5,2));          da4 := hex(str(addr,7,2));          da5 := hex(str(addr,9,2));         da6 := hex(str(addr,11,2));        END;   END; { insert_LAN_dest_addr }     PROCEDURE set_timeout(scb: VCP_session_control_block_ptr;                       sec: shortint);      !  { sends a timeout request to VTIMR for the session and number of !    seconds specified }        VAR  buff: shortint;         flag: completion_data_type;       BEGIN      WITH scb^ DO       BEGIN         flag.word := 0;         flag.session := session_number;  #        flag.comp_type := timeout_occured; { to be returned by VTIMR } #            log_request_in_time_list(sec,timeout_seq,flag);        END;    END; { set_timeout }         #PROCEDURE VCP_net_write(VAR message: LAN_buffer_type; length: shortint; #                             address: LAN_address_type;  %                            net_lu: shortint; flag: completion_data_type); %     &  { All writes on the network go through here. Expects message.data.VCP_type & '    and VCP_data to be filled in. Length is the byte length of the VCP_data. } '       VAR cntwd: cntwd_type;  
      len: shortint; 
      BEGIN 
      WITH message DO 
        BEGIN           fc1 := 0; fc2 := 0; fc3 := 0;            insert_LAN_dest_addr(message,address); "          sa1 := 0; sa2 := 0; sa3 := 0; sa4 := 0; sa5 := 0; sa6 := 0; "
          dsap := VCP_lsap; 
          ssap := VCPMT_lsap;           cntl := ui_command;     {$SKIP_TEXT ON$   !!!!!!!!!! MAP !!!!!!!!!!            data.pad := 0;           data.s1 := 0;  $SKIP_TEXT OFF$  !!!!!!!!!! MAP OFF !!!!!!!}               cntwd[1] := send_message;           cntwd[0] := net_lu;                len := LAN_header_length + VCP_type_length + length;     "                 {!!!!!!!!!!!!! 802.3 !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!} "              CASE data.VCP_type OF                 2,10:  
               BEGIN 
                 dxsap := VCP_xsap;                  sxsap := DSVCP_xsap; 	               END; 	     	            4,5,7: 	 
               BEGIN 
                  dxsap := CP_xsap;                   sxsap := BS_xsap; 	               END; 	     
            9: BEGIN 
                  dxsap := IF_xsap;                  sxsap := DSVCP_xsap; 	               END; 	                 OTHERWISE { Should not occur } ;               END; { CASE }                data.VCP_type := -data.VCP_type;            len_802 := len - (2*LAN_addr_len + 2); "                 {!!!!!!!!!!!!! 802.3 OFF !!!!!!!!!!!!!!!!!!!!!!!!!!} "               exec_error := false;           class_io_LAN(class_write_code + no_abort,                         cntwd,message,-len,                        0,0,VCPMT_class,flag);           BEGIN              error_return(error_a_reg,error_b_reg);              exec_error := test_exec_error;            END; "          IF exec_error THEN class_error ELSE class_error_count := 0; "     $          IF trace_level > 1 THEN { display the out going message header $                                    important information }             BEGIN               strwrite(trace_str,1,trace_pos,net_lu:1);  
              trace_write; 
              strwrite(trace_str,1,trace_pos, !                'to address ',address,' VCP type ',data.VCP_type:1, !                ' and length ',length:1);  
              trace_write; 
              IF NOT trace_post(17) THEN trace_error;              END; { trace_level > 1 }              END;    END; { VCP_net_write }          PROCEDURE send_address_acq_reply(VAR message: LAN_buffer_type;                                      address: LAN_address_type;                                       net_lu: shortint;                                      ses_number: shortint);       { Sends an address acquisition reply to the node at the LAN  "   address. If ses_number is 0 send general, otherwise send direct } "       VAR  flag: completion_data_type;       BEGIN 
      WITH message DO 
        BEGIN                IF ses_number = 0 THEN data.VCP_type := 4 ELSE             data.VCP_type := 5;  { direct address reply }               flag.word := 0;           flag.session := ses_number;           flag.comp_type := remote_write;               VCP_net_write(message,0,address,net_lu,flag);              END;   END; { send_address_acq_reply }          #PROCEDURE addr_session(VAR message: LAN_buffer_type; length: shortint; #                            scb: VCP_session_control_block_ptr;                             rtn1,rtn2,rtn3: shortint;                            get_flag: completion_data_type);      # { Maintains addressing sessions. Message is expected to be an address #!   acquisition request, or a time-out. If it is anything else it is !"   passed back to a father session (if it exists) or to an unexpected " "   session for service determination. If scb is not active, it is an " #   initial entry, scb is set active. If scb is already active, session # %   state is in the state_vector. When session ends, scb is set not active. %        Parameters: $      message:   buffer from class get, if from VCP, contains VCP message $      length:    length of message from class get       scb:       pointer to the session control block       rtn1,2,3:  class get return parameters,     %                   on timeout entry, rtn1 contains the sequence number used % $                   by sessions to accept or ignore timeouts which are no $$                   longer valid, rtn2 contains the timeout program status $ #                   (0/-1) normal timeout/unable to log timeout request #    $      get_flag   class get uv_paramater containing completion type packed $$                 with session id, network lu, or nothing depending on the $ &                 completion type.                                          } &       VAR father_scb: VCP_session_control_block_ptr;  
           busy : boolean; 
 
           error: boolean; 
          BEGIN     !    IF trace_level > 0 THEN trace_session_entry(scb,rtn1,get_flag); !         WITH scb^ DO       BEGIN          { initial entry, setup scb }      
        IF NOT active THEN 
          BEGIN 
            active := true; 
             addr_retry_count := 0;             state_vector := net_read;  "            if(get_pc_name(lan_lu,lan_address,busy,error)<>' ') then " 	             begin 	              send_address_acq_reply(message,LAN_address,                                     LAN_lu,session_number);               set_timeout(scb,address_timeout);               end              else  	             begin 	              state_vector := session_failed;                active := false;              end;           END              ELSE   { not initial entry, figure out what happened }                CASE get_flag.comp_type OF      #            remote_read:  { a read came back, figure out what kind and #                            take appropriate action }                   IF message.data.VCP_type = 3 THEN     &               { we got another address request, must have missed the reply } &    
                BEGIN 
                  addr_retry_count := addr_retry_count + 1;                     IF addr_retry_count > address_retry_limit THEN                      BEGIN                       state_vector := session_failed;                        active := false;                     END                    ELSE                     BEGIN                        send_address_acq_reply(message,LAN_address,   "                                             LAN_lu,session_number); "                      set_timeout(scb,address_timeout);                      END; 	                END 	     !              ELSE  { any other response is considered a success } !                   active := false;         #            timeout_occured:     { bump the retry count and try again } #    &              IF timeout_seq = rtn1 THEN { Timeout Valid, Else ignore } BEGIN &                addr_retry_count := addr_retry_count + 1;                      IF addr_retry_count > address_retry_limit THEN                   BEGIN                     state_vector := session_failed;                      active := false; 
                  END 
 
                ELSE 
                  BEGIN                     send_address_acq_reply(message,LAN_address,  !                                           LAN_lu,session_number); !                    set_timeout(scb,address_timeout);                    END;  	              END; 	                OTHERWISE ; { ignore all other completion types }                END;  { CASE }              IF state_vector = session_failed THEN active := false;              IF trace_level > 0 THEN trace_session_exit(scb);           { check exit status and return to father if done or failed }               IF (NOT active) AND (father <> NIL) THEN           BEGIN             IF state_vector = session_failed THEN 	              BEGIN 	                rtn1 := -1;  { use rtn1 as a flag for failure }                  length := 0;               END              ELSE                rtn1 := 0;             father^.suspended := false;  { unsuspend father }     $          { prevent possible returns from recursive address sessions from $             causing multiple returns to the father session }                 father_scb := father;  
            father := NIL; 
    "          { send message with return_from_suspend to father session } "    #            return_to_session(message,length,father_scb,rtn1,rtn2,rtn3, # %                                                                get_flag); %               END;            END; { WITH scb^ }       END; { addr_session }                  %PROCEDURE dump_session(VAR message: LAN_buffer_type; VAR length: shortint; %                            scb: VCP_session_control_block_ptr;                         VAR rtn1,rtn2,rtn3: shortint;                        VAR get_flag: completion_data_type);         $ { Maintains VCP dump sessions. Message is expected to be a dump request, $'   dump record or timeout. If scb is not active, it is an initial entry, scb is ' '   set active. If scb is already active, session state is in the state_vector. '    When session ends, scb is set not active.         Parameters: $      message:   buffer from class get, if from VCP, contains VCP message $      length:    length of message from class get       scb:       pointer to the session control block       rtn1,2,3:  class get return parameters,     %                   on timeout entry, rtn1 contains the sequence number used % $                   by sessions to accept or ignore timeouts which are no $$                   longer valid, rtn2 contains the timeout program status $ #                   (0/-1) normal timeout/unable to log timeout request #    $      get_flag   class get uv_paramater containing completion type packed $$                 with session id, network lu, or nothing depending on the $                 completion type. }       VAR   new_scb: VCP_session_control_block_ptr;           { terminal communications }             user_msg: term_string_type;  
        err_val: shortint; 
         prompt: boolean;              pos: shortint;          dump_error: boolean;          fmp_error: shortint;            PROCEDURE report_dump_failure;          VAR fmp_error: shortint;         BEGIN  	      WITH scb^ DO 	        BEGIN           strwrite(trace_str,1,trace_pos,                       LAN_address,' and LAN lu ',                      LAN_lu:1);            trace_write;           strwrite(trace_str,1,trace_pos, !                    'at record number ',(dump_record_number + 1):1, !                    ' in state ',state_vector);            trace_write;            IF NOT trace_post(-23) THEN trace_error;            fmp_error := fmpclose(dump_dcb,fmp_error);           state_vector := session_failed;  
          active := false; 
         END;      END; { report_dump_failure }            FUNCTION get_user_msg: term_string_type;      "  { extracts a user terminal read message for the message and length "     variables passed into dump_session }           VAR user_msg: term_string_type;           BEGIN 
      user_msg := ''; 
      IF length > strmax(user_msg) THEN          strmove(strmax(user_msg),message.c,1,user_msg,1)        ELSE         strmove(length,message.c,1,user_msg,1);       get_user_msg := strrtrim(strltrim(user_msg));  
    END;  { get_user_msg } 
          PROCEDURE send_dump_control(c0,c1: byte);        { Sends the dump control bytes using address information in the      scb and the message buffer passed into dump_session }         VAR flag: completion_data_type;  
        cntwd: cntwd_type; 
        length: shortint;         BEGIN 
      WITH message, scb^ DO 
        BEGIN            data.VCP_type := 10;           data.VCP_data.c0 := c0;           data.VCP_data.c1 := c1;               flag.word := 0;           flag.session := session_number;           flag.comp_type := remote_write;                length := 2;             VCP_net_write(message,length,LAN_address,LAN_lu,flag);      
        END; { WITH } 
         END; { send_dump_control }       PROCEDURE request_dump_file_size;         { requests a file size from the user using scb info for  
      dump session } 
        VAR user_msg: term_string_type;         BEGIN      	      WITH scb^ DO 	        BEGIN                state_vector := dump_file_size_wait;           write_user(scb, ! 'VCMPT> enter number of 2048 byte pages of memory dump data from', !
            0,false,false); 
           user_msg := '       ';            strmove(pc_logical_name_max,                      PC_logical_name,1,user_msg,8);           write_user(scb,user_msg,0,false,false);           write_user(scb,  #           '        (none or zero length aborts dump)',0,false,false); #          write_user(scb,'',0,false,false);           write_user(scb,vcpmt_prompt,0,true,true);           read_user(scb);      
        END; { WITH scb^ } 
        END; { request_dump_file_size }       PROCEDURE request_dump_file_name;         { requests a file name from the user using scb info for  
      dump session } 
        VAR user_msg: term_string_type;         BEGIN      	      WITH scb^ DO 	        BEGIN             { Ask for file name }                state_vector := dump_file_name_wait;  &          write_user(scb,'VCMPT> enter file name for memory dump data from', &%                                                            0,false,false); %           user_msg := '       ';            strmove(PC_logical_name_max,                      PC_logical_name,1,user_msg,8);           write_user(scb,user_msg,0,false,false); &          write_user(scb,'        (no file name aborts dump)',0,false,false); &          write_user(scb,'',0,false,false);           write_user(scb,vcpmt_prompt,0,true,true);           read_user(scb);      
        END; { WITH scb^ } 
        END; { request_dump_file_name }           PROCEDURE open_dump_file(f_name: term_string_type);         { checks for directory path in dump file name for       dump session, sends a reject dump request on any error,  !      if no directory is specified tells the user that a directory ! #      is required. If successful sends command to dump first record. } #                { fmpparsepath parameters }          VAR f_name_str,dir,name,typex,qual,ds: file_path_name_string;           sc,ftype,size,rec_len: shortint;             file_error: shortint;         BEGIN  	      WITH scb^ DO 	        BEGIN           IF strlen(f_name) > 64 THEN setstrlen(f_name,64);           f_name_str := f_name;            dir := strrpt(' ',16);           name := strrpt(' ',16);           typex := strrpt(' ',4);            qual := ' ';           ds := strrpt(' ',64);               fmpparsepath(f_name_str,dir,name,typex,                           qual,sc,ftype,size,rec_len,ds);               dir := strrtrim(strltrim(dir));            IF strlen(dir) <= 0 THEN             BEGIN      #              { tell the user a full path name is required and retry } #         '              write_user(scb,'VCMPT> a full file directory path is required!', '%                                                            0,false,false); %              request_dump_file_name;             END            ELSE   { procede with open attempt }             BEGIN                   f_name_str := strrpt(' ',64);               ftype := 1;                    { file size adjustment }                    IF (dump_file_size + 1) > 32767 THEN                     BEGIN  { specify size in 128 block chunks }                    size := -((dump_file_size + 1) div 128); $                  IF (dump_file_size mod 128 <> 0) THEN size := size - 1; $	                END 	 &              ELSE { dump_file_size+1 <= 32767 } size := dump_file_size + 1; &                  fmpbuildpath(f_name_str,dir,name,typex,                               qual,sc,ftype,size,rec_len,ds);                       f_name_str := strrtrim(strltrim(f_name_str));               up_shift(f_name_str);                dump_file_name := ' ';                strmove(strlen(f_name_str),f_name_str,1,                                              dump_file_name,1);     %              file_error := fmpopen(dump_dcb,file_error,f_name_str,'WC',1); %                   IF file_error < 0 THEN 
                BEGIN 
                  f_name_str := '';                   name := strrtrim(strltrim(name));                        strwrite(f_name_str,1,pos, %                    'RMVCP> fmp error ',file_error:1,' opening dump file ', %                     dir,name);                   write_user(scb,f_name_str,-21,false,false);      %                  strwrite(trace_str,1,trace_pos,file_error:1,' on file'); %                   trace_write;                   strwrite(trace_str,1,trace_pos,dir,name);                    trace_write;                    IF NOT trace_post(-21) THEN trace_error;                      { start over }                        IF state_vector <> session_failed THEN                     request_dump_file_size;     	                END 	 &              ELSE   { file open successfully, send the first dump control } &
                BEGIN 
                    send_dump_control(dump_record_length div 2,0);                     set_timeout(scb,dump_timeout);                   state_vector := dump_record_wait;  
                END; 
                END;  { procede with dump request }      
        END; { WITH scb^ } 
    
    END; { open_dump_file } 
      PROCEDURE request_dump_comment;      !    { requests up to 256 bytes of user comments using scb info for ! 
      dump session } 
        VAR user_msg: term_string_type;          chars: shortint;          pos: shortint;         BEGIN  	      WITH scb^ DO 	        BEGIN            state_vector := dump_comment_wait;           chars := 256 - dump_comment_number + 1;           IF chars > 80 THEN chars := 80; %          write_user(scb,'VCMPT> for memory dump data from',0,false,false); %           user_msg := '       ';            strmove(PC_logical_name_max,                      PC_logical_name,1,user_msg,8);           write_user(scb,user_msg,0,false,false);               user_msg := '';            strwrite(user_msg,1,pos,'       enter up to ', %            chars:1,' dump comment characters (none terminates comments)'); %          write_user(scb,user_msg,0,false,false);               write_user(scb,'',0,false,false);           write_user(scb,vcpmt_prompt,0,true,true);           read_user(scb);  
        END; { WITH scb^ } 
     END;       PROCEDURE save_dump_record;         { Only entered with type 1 message and in dump_record_wait,       saves in dump file, checks for end, sets state vector      accordingly, and sends next dump control. Uses scb and       message from dump_session }     
   VAR data_leng: shortint; 
       error: shortint;         new_scb: VCP_session_control_block_ptr;         user_msg: term_string_type; 
       pos: shortint; 
        BEGIN          WITH scb^ DO         BEGIN               { First check for various kinds of errors }     #         data_leng := length - LAN_header_length - VCP_type_length - 2; #     "         IF message.data.VCP_data.data[data_leng + 1] <> chr(1) THEN "               { not a dump record, abort and display }                 BEGIN              report_dump_failure;               display_message(message,length,                              scb,LAN_address,                              LAN_lu,false,false);                 END { not a dump record }      !         ELSE  { is either a dump record or another dump request } !                BEGIN     "             IF data_leng = 0 THEN { another dump request, abort this ""                                     one and start anew recursively } " 
               BEGIN 
                 report_dump_failure;                   display_message(message,length,                                  scb,LAN_address,                                  LAN_lu,false,false);  %                 dump_session(message,length,scb,rtn1,rtn2,rtn3,get_flag); % 	               END 	                 ELSE      
               BEGIN 
                      IF data_leng <> dump_record_length THEN                       { something wrong abort }                         BEGIN                     write_user(scb, %                              'RMVCP> Received invalid dump record length', %                                  0,false,false);                      report_dump_failure;                     END 
                 ELSE 
                  { the real thing a dump record, save it }                         BEGIN  !                     strmove(data_leng,message.data.VCP_data.data, !                      1,dump_record.c,1);     &                     error := fmpwrite(dump_dcb,error,dump_record,data_leng); &                          IF error < 0 THEN                         BEGIN                               { abort the trace and tell the user }                               send_dump_control(255,255);                               user_msg := ''; &                         strwrite(user_msg,1,pos,'RMVCP> fmp error ',error:1, &                                  ' in writing to dump file ');  !                         write_user(scb,user_msg,-22,false,false); !                          user_msg := '';                           strmove(64,dump_file_name,1,user_msg,1);   !                         user_msg := strrtrim(strltrim(user_msg)); !                           write_user(scb,user_msg,0,false,false);       &                         strwrite(trace_str,1,trace_pos,error:1,' to file'); &                         trace_write;  !                         strwrite(trace_str,1,trace_pos,user_msg); !                         trace_write;                           IF NOT trace_post(-22) THEN trace_error;                               report_dump_failure;      
                       END 
                         ELSE  { no error }                             BEGIN                             { check for end of dump }      #                         dump_record_number := dump_record_number + 1; # "                         IF dump_record_number = dump_file_size THEN "                            BEGIN  %                             dump_record.c := ' '; { blank fill comments } %                              request_dump_comment;                             END                          ELSE                             BEGIN "                             IF (dump_record_number mod 256) = 0 THEN "                                BEGIN                                    { report amount so far }                                   if dump_record_number > 257 then   $                                   { go back and overwrite old message } $                                    begin                                      {******Y********}                                       user_msg := '&a-6R';                                      {******Z********}  &                                     write_user(scb,user_msg,0,false,false); &                                   end; %                                 user_msg := 'RMVCP> Continuing dump from'; % $                                 write_user(scb,user_msg,0,false,false); $                                  user_msg := '';  #                                 strwrite(user_msg,1,pos,'          ', ##                                                      pc_logical_name); #                                   user_msg := strrtrim(user_msg);   $                                 write_user(scb,user_msg,0,false,false); $                                  user_msg := '';                                  strwrite(user_msg,1,pos, &                                                '       to ',dump_file_name); &                                   user_msg := strrtrim(user_msg);   $                                 write_user(scb,user_msg,0,false,false); $                                      user_msg := ''; !                                 strwrite(user_msg,1,pos,'       ', ! %                                             (dump_record_number div 4):1, %&                                                         'k bytes complete'); & $                                 write_user(scb,user_msg,0,false,false); $!                                 write_user(scb,' ',0,false,false); !                               END; { report amount }     !                             IF state_vector <> session_failed THEN !                                BEGIN '                                 send_dump_control(dump_record_length div 2,0); '                                 set_timeout(scb,dump_timeout);                                END;                            END;                             END; { no error }                         END; { the real thing }     	               END; 	               END;           END;  { WITH scb^ }        END;  { save_dump_record }       BEGIN     	    { trace entry } 	    !    IF trace_level > 0 THEN trace_session_entry(scb,rtn1,get_flag); !         WITH scb^ DO       BEGIN         IF NOT active THEN { initialize }           BEGIN                 IF (get_flag.comp_type = remote_read) AND                 (message.data.VCP_type = 1) AND "               (length = LAN_header_length + VCP_type_length + 2) AND "               (message.b[length - 1] = 1) THEN     !           { This is a valid dump request,procede, else not a dump, !&                                             should never happen, just exit } &    	              BEGIN 	                active := true;                  dump_file_name := ' ';                  dump_file_size := 0;                  dump_record_number := 0;                  dump_father_lu := 1;                 dump_father_class := 0;                  dump_error := false;                 dump_comment_number := 1;                  state_vector := dump_file_name_wait;                   { find father session for lu number and class }                     new_scb := get_father(scb);                 IF new_scb^.session_type = interactive THEN                   BEGIN                     dump_father_lu := new_scb^.user_lu;                     dump_father_class := new_scb^.user_class;                    END;                   { Ask for dump size }                     request_dump_file_size;                   END; { valid dump request }                END   { initialize }              ELSE                BEGIN { continuation entry }                  IF NOT ((get_flag.comp_type = timeout_occured) AND #                   (timeout_seq <> rtn1)) THEN { ignores old timeouts } #	              BEGIN 	                timeout_seq := (timeout_seq + 1) mod 32768;                          { The only thing a dump session will suspend for is                   an addressing session. }                     IF state_vector = address_session_st THEN                   BEGIN                         state_vector := continue_state;                       { check error on return }                          IF rtn1 < 0 THEN { address session failed,  !                                       we no longer have control } !                           report_dump_failure;                        END; { return from addressing sesson }                                     #               { handle the return based return type and state vector } #                                 IF state_vector <> session_failed THEN                        CASE get_flag.comp_type OF  
                     
                     terminal_read,                     program_read:  
                     
"                  { used to get file names and comments, handle based "                    on state vector }     
                      BEGIN 
                         CASE state_vector OF                                dump_file_size_wait:                                 BEGIN                               user_msg := get_user_msg;                                   IF strlen(user_msg) <= 0 THEN                                     { reject the dump request and fail                                   the dump session }                                     BEGIN  "                                  send_dump_control(255,0); {reject} "                                   state_vector := session_failed;                                     active := false;                                 END                                    ELSE                                     BEGIN                                        TRY; %                                    strread(user_msg,1,pos,dump_file_size); %                                  IF RECOVER THEN                                     BEGIN                                         { error reading file size }                                           write_user(scb, $                                'VCMPT> invalid file size specification', $"                                                      0,false,false); "&                                       IF state_vector <> session_failed THEN &                                           request_dump_file_size;                                      END                                    ELSE                                      IF dump_file_size > 0 THEN                                       BEGIN &                                        dump_file_size := dump_file_size * 8; &                                        request_dump_file_name;                                       END                                      ELSE                                       BEGIN  %                                        send_dump_control(255,0); {reject} %#                                        state_vector := session_failed; #                                         active := false;  !                                      END;  { dump file size = 0 } !                                    END; { not zero length read }                                  END; { dump file size wait }                                    dump_file_name_wait:                                 BEGIN                               user_msg := get_user_msg;                                   IF strlen(user_msg) <= 0 THEN                                     { reject the dump request and fail                                   the dump session }                                     BEGIN  "                                  send_dump_control(255,0); {reject} "                                   state_vector := session_failed;                                     active := false;                                 END                                    ELSE     #                               { get the file name, check for directory ##                                 (must be specified), and create file } #                                    open_dump_file(user_msg);                                 END; { wait for file name }                                        dump_comment_wait:     "                            { adds up to 256 bytes of comments in the "                              last record }                                 BEGIN                               user_msg := get_user_msg;     $                              IF (dump_comment_number + strlen(user_msg)) $                                   > 257 THEN                                 BEGIN  %                                  IF (257 - dump_comment_number) >= 0 THEN %                                    setstrlen(user_msg, %                                                 257 - dump_comment_number) %                                   ELSE                                      setstrlen(user_msg,0);                                  END;                                    IF strlen(user_msg) > 0 THEN                                 BEGIN                                   strmove(strlen(user_msg), !                                          user_msg,1,dump_record.c, !                                          dump_comment_number);                                    dump_comment_number :=  &                                      dump_comment_number + strlen(user_msg) &                                               + 1;                                  END;                                     IF (dump_comment_number >= 257) OR                                   (strlen(user_msg) <= 0) THEN                                     BEGIN %                                  send_dump_control(0,0); { tell VCP end of %"                                                               dump } "    %                                  fmp_error := fmpwrite(dump_dcb,fmp_error, % "                                                        dump_record, " &                                                        dump_record_length); &                                  IF fmp_error < 0 THEN                                     BEGIN                                           user_msg := '';                                        strwrite(user_msg,1,pos, !                                               'RMVCP> fmp error ', !                                               fmp_error:1,  &                                               ' in writing to dump file '); & !                                      write_user(scb,user_msg,-22, ! &                                                               false,false); &                                      user_msg := '';  !                                      strmove(64,dump_file_name,1, !%                                                               user_msg,1); %                                      user_msg := %                                              strrtrim(strltrim(user_msg)); %                                        write_user(scb,user_msg,0,  %                                                              false,false); %    "                                      strwrite(trace_str,1,trace_pos, " %                                                  fmp_error:1,' to file'); %                                       trace_write; "                                      strwrite(trace_str,1,trace_pos, "$                                                               user_msg); $                                       trace_write;                                        IF NOT trace_post(-22) THEN                                           trace_error;                                          END;      "                                  fmp_error := fmptruncate(dump_dcb, "                                                   fmp_error,  %                                                  dump_record_number + 1); %                                   fmp_error := fmpclose(dump_dcb,  !                                                        fmp_error); !                                   active := false;                                 END                               ELSE  request_dump_comment;                                  END; { dump_comment_wait }                                       OTHERWISE      !                          { this should not happen, but if it does !                            just reset the timeout and ignore }                                  set_timeout(scb,dump_timeout);                             END;  { CASE state_vector }     !                      END;  { terminal or program read completion } !                             remote_read:     "                  { accept memory dump data from remote and send next "                     record request, abort on any error }                           CASE message.data.VCP_type OF                             1:  { most likely a dump record }                               BEGIN     !                            IF state_vector = dump_record_wait THEN !                                   save_dump_record      #                            ELSE  { some kind of spurrious VCP message ##                                    display it for possible users, then # #                                    decide what to do based on state } #                                  BEGIN                                 write_user(scb, $       'RMVCP> The followin VCP message arrived while you were entering', $                                    0,false,false);                                     display_message(message,length,                                                   scb,LAN_address,   "                                                LAN_lu,false,false); "    $                                IF state_vector <> dump_comment_wait THEN $                                   report_dump_failure;                                   END; { not dump_record_wait }                               END; { type 1 message }      #                        3:  { address acquisition request is allowed } #                              BEGIN                              new_scb := allocate_scb;                              IF new_scb <> NIL THEN                               BEGIN                                 new_scb^.pc_logical_name :=                                                   pc_logical_name;   "                                new_scb^.LAN_address := LAN_address; "                                 new_scb^.LAN_lu := LAN_lu;  "                                new_scb^.session_type := addressing; "                                new_scb^.father := scb;                                     continue_state := state_vector; !                                state_vector := address_session_st; !                                 suspended := true;      "                                addr_session(message,length,new_scb, "#                                              rtn1,rtn2,rtn2,get_flag); #                              END     $                            ELSE { not enough memory to start new session $ $                                   send one directed address acquisition $                                   reply anyway }                                   BEGIN                                      report_no_session(dump_father_lu,  %                                                  dump_father_class,false); %                                send_address_acq_reply(message, !                                                       LAN_address, !                                                        LAN_lu, #                                                       session_number); # !                                set_timeout(scb,net_read_timeout); !                                   END; { not enough memory }                                END; { address acquisition request }                                                                              OTHERWISE { just abort }                           BEGIN  "                            IF state_vector <> dump_record_wait THEN " 
                           
                              write_user(scb, $       'RMVCP> The followin VCP message arrived while you were entering', $                                    0,false,false);                                 display_message(message,length,                                              scb,LAN_address,                                               LAN_lu,false,false);      "                            IF state_vector <> dump_comment_wait THEN "                               report_dump_failure;                                END; { OTHERWISE }                             END; { remote read: CASE VCP_type }                             remote_write,                      timeout_occured:                       { only get here on some kind of write error                       or timeout, just abort if waiting for a dump                       record, else just ignore }                           IF state_vector = dump_record_wait THEN                         BEGIN  "                          send_dump_control(255,255); { abort dump } "                           report_dump_failure;                          END;                         OTHERWISE; { ignore }                        END; { IF NOT session_failed CASE get_flag }                   END; { not an old timeout occurance }               END; { continuation entry }              IF (state_vector = session_failed) AND active THEN            report_dump_failure;      
      { trace exit } 
             IF trace_level > 0 THEN trace_session_exit(scb);           { check active and return to father if done }      %        IF (NOT active) AND (father <> NIL) THEN  { session must be done } %          BEGIN             IF state_vector = session_failed THEN 	              BEGIN 	                 rtn1 := -1; { use rtn1 as a failure flag }                  length := 0;               END              ELSE                rtn1 := 0;                 { pass the message we received back to the father }     "            father^.suspended := false; { un-suspend father session } "                  { prevent possible recursive returns from triggering                 multiple returns to father }                  new_scb := father;  
            father := NIL; 
                return_to_session(message,length,new_scb,rtn1,rtn2,                                         rtn3,get_flag);            END; { father <> NIL }                END; { WITH scb^ }       END; { dump_session }             $PROCEDURE RPL_session(VAR message: LAN_buffer_type; VAR length: shortint; $                          scb: VCP_session_control_block_ptr;                       VAR rtn1,rtn2,rtn3: shortint;                        VAR get_flag: completion_data_type);      $ { Maintains VCP RPL sessions. Message is expected to be an RPL request, $$   RPL record acknowledgement, or timeout. If scb is not active, it is an $ #   initial entry, scb is set active. If scb is already active, session # %   state is in the state_vector. When session ends, scb is set not active. %        Parameters: $      message:   buffer from class get, if from VCP, contains VCP message $      length:    length of message from class get       scb:       pointer to the session control block       rtn1,2,3:  class get return parameters,     %                   on timeout entry, rtn1 contains the sequence number used % $                   by sessions to accept or ignore timeouts which are no $$                   longer valid, rtn2 contains the timeout program status $ #                   (0/-1) normal timeout/unable to log timeout request #    $      get_flag   class get uv_paramater containing completion type packed $$                 with session id, network lu, or nothing depending on the $ &                 completion type.                                          } &      VAR   new_scb: VCP_session_control_block_ptr;         RPL_file_name_str: file_path_name_string;         file_error: shortint;  
        ipl_busy: boolean; 

        ipl_error: boolean; 
        octal_file_name: octal_numb_buffer;  
        i: shortint; 
        f_lu: shortint;  
        f_class: shortint; 
         out_str: term_string_type;          pos: shortint;             { fmpparsepath parameters }              dir,name,typex,qual,ds: file_path_name_string;          sc,ftype,size,rec_len: shortint;           PROCEDURE report_RPL_failure;          VAR fmp_error: shortint;         BEGIN  	      WITH scb^ DO 	        BEGIN           strwrite(trace_str,1,trace_pos,                       LAN_address,' and LAN lu ',                      LAN_lu:1);            trace_write;           strwrite(trace_str,1,trace_pos, &          'at record number ',RPL_record_number:1,' in state ',state_vector); &           trace_write;            IF NOT trace_post(-20) THEN trace_error;           fmp_error := fmpclose(RPL_dcb,fmp_error);           state_vector := session_failed;  
          active := false; 
         END;      END;            PROCEDURE trace_RPL_retry;         BEGIN  	      WITH scb^ DO 	        BEGIN           strwrite(trace_str,1,trace_pos,                       LAN_address,' and LAN lu ',                      LAN_lu:1);            trace_write;           strwrite(trace_str,1,trace_pos, &          'at record number ',RPL_record_number:1,' in state ',state_vector); &           trace_write;            IF NOT trace_post(5) THEN trace_error;          END;      END;        FUNCTION get_next_RPL_record: boolean;        { reads the next RPL record from the RPL file and returns it in       the scb. If type 1 then calculates checksum and load address.   "    Returns failed in boolean function return, false if successful } "       TYPE            ck_sum_rec = PACKED RECORD CASE boolean OF                        false: (i: integer);  !                       true: (w: PACKED ARRAY [0..1] OF shortint); !                   END;         VAR length: shortint;          fmp_error: shortint;         error: boolean; 
        eof: boolean; 
 
        raw_rec: RPL_data; 
 
        i: shortint; 
         ck_temp: ck_sum_rec; 
        ck_sum: ck_sum_rec; 
         out_str: term_string_type;          pos: shortint;         BEGIN  	      WITH scb^ DO 	        BEGIN           error := false;           eof := false;                IF RPL_file_type_number = 1 THEN             BEGIN                IF state_vector = RPL_chunk_pause THEN 
                BEGIN 
                  RPL_record.load_address := 0;                   state_vector := RPL_ack_wait;                       if rpl_record_number > 257 then                     begin                       { go back and overwrite old message }                        {******Y********}                        out_str := '&a-6R';                        {******Z********}                        write_user(scb,out_str,0,false,false);                      end; !                  out_str := 'RMVCP> Continuing Boot of file name'; !                   write_user(scb,out_str,0,false,false);                    out_str := '';                    strwrite(out_str,1,pos,'          ',                                             RPL_file_name);                   out_str := strrtrim(out_str);                    write_user(scb,out_str,0,false,false);                    out_str := ''; #                  strwrite(out_str,1,pos,'       to ',pc_logical_name); #                  out_str := strrtrim(out_str);                    write_user(scb,out_str,0,false,false);                        out_str := '';                   strwrite(out_str,1,pos,'       ',  %                    ((rpl_record_number + 1) div 4):1,'k bytes complete'); %                   write_user(scb,out_str,0,false,false);                    write_user(scb,' ',0,false,false);     	                END 	               ELSE     { is RPL_ack_wait } 
                BEGIN 
                  { JDJ -- performace hacks     "                  RPL_record.load_address := (RPL_record.load_address "                                                + 128) mod 32768;}                         { If is not the first download record, bump the  !                    load address by the number of bytes sent by the !                    last record.  }                       IF RPL_record_length > 6 THEN BEGIN  $                     RPL_record.load_address := (RPL_record.load_address $!                            + (RPL_record_length DIV 2)) mod 32768; !                   END;                       IF RPL_record.load_address < 0 THEN                       RPL_record.load_address := 0;     
                  {JDJ end} 
                   IF (RPL_record.load_address = 0) AND                      (RPL_record_number <> 0) AND                      (RPL_record_number < RPL_file_size) THEN                         { send eof for end of chunk }                         BEGIN                       state_vector := RPL_eoc_wait;                        WITH RPL_record DO                         BEGIN                            word_count := 0;                            zero := 0;                            load_address := 0;                            data[0] := 0;     { checksum }                          END;                       RPL_record_length := 6; { bytes }                      END;                  END; { NOT RPL_chunk_pause }                   IF state_vector = RPL_ack_wait THEN                   { read the next record and calculate checksum }     
                BEGIN 
                  IF RPL_record_number < RPL_file_size THEN                        { not at eof yet }                         BEGIN         { *                if(rpl_record_number mod maxblock) = 0 then      *                 begin   }                      RPL_record_length := fmpRPLread(RPL_dcb, $                                          fmp_error,rpl_rd,256*maxblock); $  { *                   rpl_rec_mod := 1;     *                  MAXLOOP := (LENGTH+255) DIV 256;  
    *                 end; 
    *                 IF MAXLOOP>= RPL_REC_MOD THEN BEGIN       *                   RPL_record.data := rpl_raw[rpl_rec_mod];       *                   rpl_rec_mod := rpl_rec_mod + 1 ;      *                   LENGTH := 256;  
    *                  END 
 
    *                 ELSE 
     *                  BEGIN     *                   LENGTH := -1; 
    *                  END; 
     *                 IF length > 0 THEN     *                   BEGIN     *                     ck_temp.i := 0;      *                     ck_sum.i := RPL_record.load_address;     *                     FOR i := 0 TO (length div 2) - 1 DO     *                       BEGIN      *                         ck_temp.w[1] := RPL_record.data[i];      *                         ck_sum.i := ck_sum.i + ck_temp.i;      *                       END;     *                     RPL_record.checksum := ck_sum.w[1];       *                     RPL_record.word_count := length div 2;       *                     RPL_record_length := length + 6;      }                     RPL_record_number := RPL_record_number +  !                                        RPL_record_length DIV 256; !  { *                   END     }        { *                 ELSE}{ fmp_error }                       IF fmp_error < 0 THEN                          error := true;                         END                       ELSE eof := true;                     END; { RPL_ack_wait, read next record }                  END  { type 1 file }               ELSE   { must be type 7 }                  { only entry to here is RPL_ack_wait }                 BEGIN               IF RPL_record_number < RPL_file_size THEN                  { not at eof yet }     
                BEGIN 
!                  length := fmpread(RPL_dcb,fmp_error,raw_rec,256); !                   RPL_record.type_seven_data := raw_rec;                       IF length >= 0 THEN                     BEGIN                        RPL_record_length := length;                        RPL_record_number := RPL_record_number + 1;                      END                    ELSE if length = -1 then eof := true                   else error := true;     	                END 	                  ELSE eof := true;                  END;                IF error OR (state_vector = session_failed) THEN                 BEGIN               state_vector := RPL_eof_wait;               fail_pending := true;                WITH RPL_record DO 
                BEGIN 
                   word_count := 0;                    zero := 0;                   load_address := -2;                   data[0] := -2;     { checksum }  
                END; 
              RPL_record_length := 6; { bytes }     
              IF error THEN 
                BEGIN 
                  strwrite(trace_str,1,trace_pos,length:1);                    trace_write;                    RPL_file_name_str := '';  !                  strmove(64,RPL_file_name,1,RPL_file_name_str,1); !&                  RPL_file_name_str := strrtrim(strltrim(RPL_file_name_str)); &                  strwrite(trace_str,1,trace_pos,                       'in Boot file ',RPL_file_name_str);                    trace_write;                   IF NOT trace_post(-19) THEN                      trace_error;                  END; { error }                 END { error or session_failed }                ELSE                 IF eof THEN     	              BEGIN 	                state_vector := RPL_eof_wait;                  WITH RPL_record DO                   BEGIN                      word_count := 0;                      zero := 0;                      load_address := 0;                      data[0] := 0;     { checksum }                    END;                 RPL_record_length := 6; { bytes }  	              END; 	    
        END; { WITH } 
          get_next_RPL_record := error;          END; { get_next_RPL_record }        PROCEDURE send_RPL_record;        { Sends the RPL record currently contained in the scb. Uses the      message buffer passed into RPL_session. }                     VAR flag: completion_data_type;  
        cntwd: cntwd_type; 
        length: shortint;             BEGIN 
      WITH message, scb^ DO 
        BEGIN           data.VCP_type := 7;           IF RPL_record_length > 6 THEN       { We cheat pascal out of type checking here on the TOO variable.  !   The problem is that the 'data' type of VCP_Data is not available ! #   for use in the declarations, and I don't want to change them now. } #                length := buildtbuf(rpl_rd,message,  %                                RPL_record_length,RPL_record.load_address) %           ELSE             BEGIN              data.VCP_data.download_record := RPL_record;              length := RPL_record_length;            END;           flag.word := 0;           flag.session := session_number;           flag.comp_type := remote_write;                 VCP_net_write(message,length,LAN_address,LAN_lu,flag);            IF state_vector = RPL_ack_wait THEN              set_timeout(scb,RPL_timeout)            ELSE              set_timeout(scb,net_read_timeout);     
        END; { WITH } 
         END; { send_RPL_record }            BEGIN  { RPL_session }     	    { trace entry } 	    !    IF trace_level > 0 THEN trace_session_entry(scb,rtn1,get_flag); !         WITH scb^ DO       BEGIN             { initial entry }      
        IF NOT active THEN 
          BEGIN                 IF (get_flag.comp_type = remote_read) AND  '               (message.data.VCP_type = 6) THEN { This is a valid RPL request, '%                                                  procede, else not an RPL, %&                                             should never happen, just exit } &	              BEGIN 	                active := true;                 RPL_file_name := ' ';                  RPL_file_type_number := 0;                 RPL_file_size := 0;                 RPL_record_number := 0;                 RPL_retry_count := 0;                 RPL_record_length := 0;                 RPL_record.zero := 0; $                RPL_record.load_address := -128; { if type 1 first record $ %                                                    will roll this over to %                                                       zero }                  RPL_file_name_str := '';                 ipl_error := false;                 state_vector := RPL_ack_wait;                    { find file name }                     IF message.data.VCP_data.RPL_request = 0 THEN     #              { go to the IPL_file_table for a default boot file name } #                      BEGIN #                    RPL_file_name := get_ipl_file_name(pc_logical_name, #                                                        ipl_error,                                                          ipl_busy);                              IF (ipl_error OR ipl_busy) THEN 
                      BEGIN 
!                        ipl_error := true;  { don't retry if busy } !                        IF NOT trace_post(-5) THEN trace_error;  
                      END; 
    
                  END 
     $                ELSE  { make a file name out of the RPL request number } $                      BEGIN                     i := message.data.VCP_data.RPL_request;                     octal_cnvrt(i,octal_file_name);                          FOR i := 2 TO 6 DO 
                      BEGIN 
                         IF octal_file_name[i] = ' ' THEN  #                                            octal_file_name[i] := '0'; # 
                      END; 
                         octal_file_name[1] := 'P';                      strmove(6,octal_file_name,1,RPL_file_name,1);                         END;                     IF NOT ipl_error THEN                      { open the RPL file and determine the file type }                        BEGIN                         { If no directory specified, add the default }       "                    strmove(64,RPL_file_name,1,RPL_file_name_str,1); "'                    RPL_file_name_str := strrtrim(strltrim(RPL_file_name_str)); '                         dir := strrpt(' ',64);                     name := strrpt(' ',16);                     typex := strrpt(' ',4);                      qual := ' ';                     ds := strrpt(' ',64);      !                    fmpparsepath(RPL_file_name_str,dir,name,typex, !!                                    qual,sc,ftype,size,rec_len,ds); !                        dir := strrtrim(strltrim(dir));  %                    IF strlen(dir) <= 0 THEN dir := boot_file_default_dir; %                         RPL_file_name_str := strrpt(' ',64);      !                    fmpbuildpath(RPL_file_name_str,dir,name,typex, !!                                    qual,sc,ftype,size,rec_len,ds); !        '                    RPL_file_name_str := strrtrim(strltrim(RPL_file_name_str)); '                    RPL_file_name := ' ';  %                    strmove(strlen(RPL_file_name_str),RPL_file_name_str,1, %#                                                      RPL_file_name,1); #                      { get the file size }                          file_error := fmpsize(RPL_file_name_str,                                                    RPL_file_size);   %                    { ****mh**** switch to filemanger for P-files 4/10/90} %                            { get the file size }                          if (file_error = -6) and  "                       (message.data.VCP_data.RPL_request <> 0) THEN "
                      begin 
                        dir := '/0/';                          RPL_file_name_str := strrpt(' ',64);      #                        fmpbuildpath(RPL_file_name_str,dir,name,typex, # $                                         qual,sc,ftype,size,rec_len,ds); $                                 RPL_file_name_str :=  &                                      strrtrim(strltrim(RPL_file_name_str)); &                        RPL_file_name := ' ';  &                        strmove(strlen(RPL_file_name_str),RPL_file_name_str, & &                                                         1,RPL_file_name,1); &                          file_error := fmpsize(RPL_file_name_str,   "                                                     RPL_file_size); "                        if (file_error = -6) THEN                           begin                             dir := boot_file_default_dir;                               RPL_file_name_str := strrpt(' ',64);       %                            fmpbuildpath(RPL_file_name_str,dir,name,typex, % &                                             qual,sc,ftype,size,rec_len,ds); &                                     RPL_file_name_str :=  &                                      strrtrim(strltrim(RPL_file_name_str)); &                            RPL_file_name := ' ';                              strmove(strlen(RPL_file_name_str),  &                                       RPL_file_name_str,1,RPL_file_name,1); &                           end;  
                      end; 
                    { ****mh**** end changes 4/10/90}                   { open the file }                         IF file_error >= 0 THEN     $                      RPL_file_type_number := fmpopen(RPL_dcb,file_error, $ $                                                      RPL_file_name_str, $                                                       'ROS',1)                          ELSE RPL_file_type_number := file_error;                           { check and report errors }                          IF (RPL_file_type_number <> 7) AND  #                       (RPL_file_type_number <> 1) THEN { open error } #
                      BEGIN 
                         ipl_error := true;                          IF RPL_file_type_number < 0 THEN  #                          strwrite(trace_str,1,trace_pos,file_error:1) #                         ELSE                           strwrite(trace_str,1,trace_pos,  &                              'illegal file type: ',RPL_file_type_number:1); &                             trace_write;                         strwrite(trace_str,1,trace_pos,                            'for Boot file ',RPL_file_name_str);                          trace_write;                         IF NOT trace_post(-18) THEN                            trace_error;                       END; { open error }                        END; { file open }                     IF NOT ipl_error THEN                   BEGIN                     IF trace_level > 0 THEN 
                      BEGIN 
!                        strwrite(trace_str,1,trace_pos,LAN_address, !                                 ' at lu ',LAN_lu:1);                          trace_write;                          strwrite(trace_str,1,trace_pos,'file = ',                                      RPL_file_name_str);                          trace_write;                          IF NOT trace_post(6) THEN trace_error;  
                      END; 
                        ipl_error := get_next_RPL_record; 
                  END 
                    ELSE  { ipl_error from open }                       BEGIN                      { make up reject RPL record and send it, end                    this session }                         WITH scb^.RPL_record DO 
                      BEGIN 
                         word_count := 0;                          zero := 0;                         load_address := -1;                         data[0] := -1;             { checksum }  
                      END; 
!                    RPL_record_length := 6;               { bytes } !                    state_vector := RPL_eof_wait; "                    fail_pending := true; { error flag for subsequent " $                                                         session entry } $                   END;                     IF NOT ipl_error THEN      '                { First record has been fetched, actually start the download } '                      BEGIN  $                    state_vector := RPL_ack_wait; { set the wait state } $     "                    out_str := 'RMVCP> Boot started from file name'; "                     write_user(scb,out_str,0,false,false);                      out_str := '';                     strwrite(out_str,1,pos,                      '          ',RPL_file_name);                     out_str := strrtrim(out_str);                      write_user(scb,out_str,0,false,false);                      out_str := '';                     strwrite(out_str,1,pos,                      '       to ',pc_logical_name);                     out_str := strrtrim(out_str);                      write_user(scb,out_str,0,false,false);                      write_user(scb,' ',0,false,false);                        END;                      send_RPL_record;                       END { valid RPL request }                  ELSE report_RPL_failure;                END  { initial entry }     %        ELSE { continuation entry, check state vector and completion type } %               IF NOT ((get_flag.comp_type = timeout_occured) AND "                 (timeout_seq <> rtn1)) THEN { ignores old timeouts } "            BEGIN               timeout_seq := (timeout_seq + 1) mod 32768;                IF fail_pending THEN      $                { nothing else matters, this is a session failure entry, $ #                  probably waiting in an RPL_eof_wait from sending the #                  error back to the remote node }     
                BEGIN 
                  IF state_vector = RPL_eof_wait THEN                     BEGIN                         IF ((get_flag.comp_type = remote_read) AND                            (message.data.vcp_type = 8) AND                           (message.data.VCP_data.download_ack = $                                                    download_nak_val)) OR $ "                         (get_flag.comp_type = timeout_occured) THEN "                             { resend the rejection message }                             BEGIN                            RPL_retry_count := RPL_retry_count + 1;  !                          IF RPL_retry_count > RPL_retry_limit THEN !                             report_RPL_failure                            ELSE                             BEGIN  #                              IF trace_level > 0 THEN trace_RPL_retry; #                               send_RPL_record;                              END; 
                        END 
                       ELSE     { end the session }                         report_RPL_failure;                         END                    ELSE report_RPL_failure;                     END { record number < 0 = failing session }                     ELSE  { not a failing session, carry on with RPL }  
                BEGIN 
    !                { The only thing an RPL session will suspend for is !                   an addressing session. }                       IF state_vector = address_session_st THEN                     BEGIN                           state_vector := continue_state;                         { check error on return }                             IF rtn1 < 0 THEN { address session failed,   "                                         we no longer have control } "                            report_RPL_failure;                          END; { return from addressing sesson }                            IF state_vector <> session_failed THEN                          CASE get_flag.comp_type OF                            remote_read:                             CASE message.data.VCP_type OF                               8: { download acknowledge }     !                            IF message.data.VCP_data.download_ack = ! #                                                 download_ack_val THEN #                              BEGIN     !                                IF ((length >= (LAN_header_length + !$                                                VCP_type_length + 4)) AND $$                                    (message.data.VCP_data.load_address = $                                      RPL_record.load_address))                                          OR                                         (length <= LAN_header_length +  #                                              VCP_type_length + 2) THEN #    $                              { this is not a spurious ACK or there is no $&                                                                    address } &                                BEGIN                                       RPL_retry_count := 0;                                        CASE state_vector OF                                         RPL_ack_wait:                                           BEGIN $                                        ipl_error := get_next_RPL_record; $                                         send_RPL_record;                                        END;                                         RPL_eoc_wait:                                           BEGIN  $                                        state_vector := RPL_chunk_pause; $ %                                        set_timeout(scb,net_read_timeout); %                                       END;                                         RPL_eof_wait:                                           BEGIN                                         IF trace_level > 0 THEN                                           BEGIN %                                            strwrite(trace_str,1,trace_pos, % &                                                     LAN_address,' and lu ', &                                                     LAN_lu:1);                                              trace_write; "                                            IF NOT trace_post(7) THEN "                                               trace_error;                                            END;                                          i := fmpclose(RPL_dcb,i);  %                                        active := false; { successful end } %                                       END;     &                                    OTHERWISE ; { should not happen, ignore } &                                       END; { CASE state_vector }                                     END '                              ELSE { not spurious ACK, set timeout and leave  } '                                BEGIN "                                  IF state_vector = RPL_ack_wait THEN "                                      set_timeout(scb,RPL_timeout)                                     ELSE  #                                    set_timeout(scb,net_read_timeout); #                                 END;     !                              END  { postive download acknowledge } !                                 ELSE { NAK }                                   BEGIN #                                RPL_retry_count := RPL_retry_count + 1; #$                                IF RPL_retry_count < RPL_retry_limit THEN $                                  BEGIN  &                                    IF trace_level > 0 THEN trace_RPL_retry; &                                     send_RPL_record;                                   END                                  ELSE                                   report_RPL_failure;                                END;                                3: { address acquisition request }                                   BEGIN                                new_scb := allocate_scb;                                IF new_scb <> NIL THEN                                   BEGIN                                     new_scb^.pc_logical_name :=  "                                                    pc_logical_name; "#                                   new_scb^.LAN_address := LAN_address; #                                   new_scb^.LAN_lu := LAN_lu; #                                   new_scb^.session_type := addressing; #                                    new_scb^.father := scb;      !                                   continue_state := state_vector; ! #                                   state_vector := address_session_st; #                                   suspended := true;     #                                   addr_session(message,length,new_scb, # %                                                 rtn1,rtn2,rtn2,get_flag); %                                  END      &                               ELSE { not enough memory to start new session &%                                      send one directed address acquisition %                                       reply anyway }                                       BEGIN                                     new_scb := get_father(scb);                                    IF new_scb^.session_type =  "                                                    interactive THEN "                                      BEGIN                                          f_lu := new_scb^.user_lu;   #                                       f_class := new_scb^.user_class; #                                      END                                    ELSE                                       BEGIN                                        f_lu := 0;                                         f_class := 0;                                      END;     $                                   report_no_session(f_lu,f_class,false); $ !                                   send_address_acq_reply(message, ! #                                                          LAN_address, #                                                           LAN_lu,   %                                                          session_number); %"                                   set_timeout(scb,net_read_timeout); "                                     END; { not enough memory }                                   END; { address acquisition request }                                     6: { RPL request }                                   BEGIN  %                               timeout_seq := (timeout_seq + 1) mod 32768; %     #                               IF ((state_vector = RPL_chunk_pause) OR #"                                   (state_vector = RPL_eoc_wait)) AND " #                                  (message.data.vcp_data.RPL_request = #                                     octal('77777')) THEN          $                                 { normal continuation after 32k chunk } $                                      BEGIN !                                   state_vector := RPL_chunk_pause; ! "                                   ipl_error := get_next_RPL_record; "                                   send_RPL_record;                                   END      #                               ELSE { a new RPL request, start over by #%                                      setting active false and calling self %                                      recursively }                                       BEGIN                                     report_RPL_failure;  !                                   RPL_session(message,length,scb, ! $                                               rtn1,rtn2,rtn3,get_flag); $                                 END;                                  END; { RPL request }      %                          OTHERWISE  { some kind of error, display message %                                        and end the session }                               BEGIN  %                               timeout_seq := (timeout_seq + 1) mod 32768; %                               display_message(message,                                                 length,scb,  !                                               LAN_address,LAN_lu, !                                                false,false);                                 report_RPL_failure;                              END;                             END; { remote_read: CASE VCP_type }                           remote_write,                        timeout_occured:     !                    { only get here on some kind of write error, or !                       valid timeout, retry }                             BEGIN                            RPL_retry_count := RPL_retry_count + 1;  "                          timeout_seq := (timeout_seq + 1) mod 32768; " "                          IF (RPL_retry_count < RPL_retry_limit) AND "                              ((state_vector = RPL_ack_wait) OR                                (state_vector = RPL_eoc_wait) OR                                (state_vector = RPL_eof_wait)) THEN                              BEGIN  #                              IF trace_level > 0 THEN trace_RPL_retry; #                               send_RPL_record;                             END                            ELSE                             report_RPL_failure;                          END;                               OTHERWISE ;  { Ignore }                         END;  { CASE get_flag.comp_type }                      END; { not a failing session }                  END; { not old timeout }                  IF (state_vector = session_failed) AND active THEN             report_rpl_failure;              { trace exit }              IF trace_level > 0 THEN trace_session_exit(scb);             { check active and return to father if done }      %        IF (NOT active) AND (father <> NIL) THEN  { session must be done } %          BEGIN             IF state_vector = session_failed THEN 	              BEGIN 	                 rtn1 := -1; { use rtn1 as a failure flag }                  length := 0;               END              ELSE                rtn1 := 0;                 { pass the message we received back to the father }     "            father^.suspended := false; { un-suspend father session } "                  { prevent possible recursive returns from triggering                 multiple returns to father }                  new_scb := father;  
            father := NIL; 
                return_to_session(message,length,new_scb,rtn1,rtn2,                                         rtn3,get_flag);            END; { father <> NIL }            END; { WITH scb^ }    END; { RPL_SESSION }                      &PROCEDURE unexpected_session(VAR message: LAN_buffer_type; length: shortint; &                                network_lu: shortint;                                  source_address: LAN_address_type;                                  rtn1,rtn2,rtn3: shortint;                                get_flag: completion_data_type);     % { Is entered when incomming read LAN address and lu have no active session %&   or at termination of an addressing session with no father. Type of message &!   is checked and proper session is launched. If the global boolean ! &   display_unexpected_messages is true the incomming message is displayed on & $   the system console. No scb is associated with an unexpected session } $      VAR   new_scb: VCP_session_control_block_ptr;         error: boolean;  
        ipl_busy: boolean; 
         busy: boolean;       BEGIN     	    { trace entry } 	    
    IF trace_level > 0 THEN 
      BEGIN          strwrite(trace_str,1,trace_pos,unexpected,' session');  
        trace_write; 
 "        strwrite(trace_str,1,trace_pos,'class get completion type ', "                   get_flag.comp_type);  
        trace_write; 
         IF NOT trace_post(3) THEN trace_error;        END;     	    error := false; 	     ipl_busy := false;         IF display_unexpected_messages THEN !      display_message(message,length,NIL,source_address,network_lu, !                          false,false);         CASE message.data.VCP_type OF         { Check for RPL request }            6: BEGIN              new_scb := allocate_scb;              IF new_scb <> NIL THEN 	              BEGIN 	                 WITH new_scb^ DO                   BEGIN &                    pc_logical_name := get_pc_name(network_lu,source_address, &"                                                     error,ipl_busy); "                     LAN_address := source_address;                     LAN_lu := network_lu;                      session_type := RPL;                    END;                 IF NOT (error OR ipl_busy) THEN &                  RPL_session(message,length,new_scb,rtn1,rtn2,rtn3,get_flag) &                ELSE error := true;               END              ELSE 	              BEGIN 	                report_no_session(0,0,false);                  error := true;  	              END; 	                IF error THEN 	              BEGIN 	                   { some problem exists, send abort message!!!!}                      insert_LAN_dest_addr(message, source_address);                     message.data.VCP_type := 7; { download record }                     WITH message.data.VCP_data.download_record DO                   BEGIN                      type_seven_data[0] := 0;                     type_seven_data[1] := -3;                     type_seven_data[2] := -3;                   END; { WITH download_record }                     get_flag.word := 0;                 get_flag.comp_type := remote_write;      &                VCP_net_write(message,6,source_address,network_lu,get_flag); &     	              END; 	           END;             { Check for address acquisition request }            3: BEGIN                 { check for multicast or direct address }     $            IF odd(message.da1) THEN { multicast address odd first byte } $ 	             begin 	&              if(get_pc_name(NETWORK_LU,SOURCE_address,busy,error)<>' ') then & 
               begin 
&                  send_address_acq_reply(message,source_address,network_lu,0) &	               end; 	              end              ELSE 	              BEGIN 	                 new_scb := allocate_scb;                  IF new_scb <> NIL THEN                   BEGIN                      WITH new_scb^ DO 
                      BEGIN 
                         LAN_address := source_address;                         LAN_lu := network_lu;                         session_type := addressing;  
                      END; 
#                    addr_session(message,length,new_scb,rtn1,rtn2,rtn3, # !                                                        get_flag); !
                  END 
                ELSE { not enough memory to start new session }                   BEGIN                     report_no_session(0,0,false);     $                 { send one direct address acquisition reply anyway, give $'                   it a bogus session number not 0 to force direct not general} '     !                    send_address_acq_reply(message,source_address, !                                            network_lu,-1);                        END;  	              END; 	               END;          { type 1, check for dump request }            1: BEGIN      "            IF length = LAN_header_length + VCP_type_length + 2 THEN "	              BEGIN 	                IF message.b[length - 1] = 1 THEN                   BEGIN                      new_scb := allocate_scb;                      IF new_scb <> NIL THEN 
                      BEGIN 
                         WITH new_scb^ DO                           BEGIN                              LAN_address := source_address;                             LAN_lu := network_lu;                             session_type := dump;                            END; %                        dump_session(message,length,new_scb,rtn1,rtn2,rtn3, % #                                                            get_flag); #                      END                      ELSE 
                      BEGIN 
                        report_no_session(0,0,false);                              WITH message.data DO                           BEGIN                             VCP_type := 10; #                            VCP_data.c0 := 255; { reject dump request } #                            VCP_data.c1 := 0;                            END;                         get_flag.word := 0;                         get_flag.comp_type := remote_write;      %                        VCP_net_write(message,2,source_address,network_lu, %                                       get_flag);      
                      END; 
                   END;  	              END; 	           END;      %   { Type 11 VCP error message, check type: If error is 'forced disengage' %!     it is OK, any other error message should not be received by an !      unexpected session and is an error. }      #      11: IF message.data.VCP_data.error_numb <> 1 THEN error := true; #     %  { All other types should not be received by an unexpected session, hence %    should be logged as errors. }                OTHERWISE error := true;     END; { case }       { If an error condition exists report message type received }         IF error THEN       BEGIN           strwrite(trace_str,1,trace_pos,message.data.VCP_type:1);   
        trace_write; 
         IF NOT trace_post(-14) THEN trace_error;        END;     
    IF trace_level > 0 THEN 
      BEGIN          strwrite(trace_str,1,trace_pos,unexpected,' session');  
        trace_write; 
         IF NOT trace_post(4) THEN trace_error;        END;       END; { unexpected session }         &PROCEDURE interactive_session(VAR message: LAN_buffer_type; length: shortint; &!                                scb: VCP_session_control_block_ptr; !                                rtn1,rtn2,rtn3: shortint;                                   get_flag: completion_data_type);          $  { Maintains programmatic and terminal VCP interactive sessions. Message $ %    may be either from VCP, User (terminal or program), or timeout. If scb %#    is not active, it is an initial entry, scb is set active. If scb is # &    already active, session state is in the state_vector. When session ends, & 
    scb is set not active. 
        Parameters: $      message:   buffer from class get, if from VCP, contains VCP message $      length:    length of message from class get       scb:       pointer to the session control block       rtn1,2,3:  class get return parameters,      $                   on initial entry rtn1 contains terminal lu number for $ &                   user interactive session or class number for programmatic &                    interactive session     %                   on timeout entry, rtn1 contains the sequence number used % $                   by sessions to accept or ignore timeouts which are no $$                   longer valid, rtn2 contains the timeout program status $ #                   (0/-1) normal timeout/unable to log timeout request #    $      get_flag   class get uv_paramater containing completion type packed $$                 with session id, network lu, or nothing depending on the $                 completion type. }       VAR user_msg: term_string_type;  
      pos: shortint; 
 
      exec_code: shortint; 
       break_toggle: boolean;            PROCEDURE write_net(length: shortint);      #  { uses the LAN_buffer_type message and scb^ from interactive session #     to send the message out on the LAN }         VAR   flag: completion_data_type;         BEGIN 
      WITH message, scb^ DO 
        BEGIN           flag.word := 0;           flag.session := session_number;           flag.comp_type := remote_write;                 VCP_net_write(message,length,LAN_address,LAN_lu,flag);               END;      END; { write_net }        PROCEDURE process_command;         { Processes the user command contained in the message or if       not a command for VCPMT passes the entire message on to 
      VCP at the other end. 
          Understands the following commands:              /B or /Break         send a break to vcp command         /E or /Exit  exit the interactive session  #        /W or /Wait          enter a net_read state until data arrives # #        /R or /Read          enter a net_read state until data arrives #                                 or read timeout occurs  #        /? or /Help          print the pc_logical_name and LAN_address #                                and LAN_lu for this session     #      After each network write will enter the net_read state until data #      arrives or a read timeout occurs. }         TYPE  cmd_type = (b,break,e,exit,w,wait,r,read,help);         CONST cr = chr(13);            null = chr(0);          VAR cmd: cmd_type;          cmd_str: string[80];          pos: shortint;          msg_str: term_string_type;          name_str: string[pc_logical_name_max];         BEGIN             { get the start of the message to see if it is a command }            IF (length > 0) AND          (scb^.state_vector = user_read) THEN     "         { at least there is some user data that we are waiting for } "            BEGIN                cmd_str := '';            IF length > strmax(cmd_str) THEN              strmove(strmax(cmd_str),message.c,1,cmd_str,1)            ELSE              strmove(length,message.c,1,cmd_str,1);     '          cmd_str := strrtrim(strltrim(cmd_str)) + ' ';{ insure at least one  } ''          setstrlen(cmd_str,strpos(cmd_str,' '));      { bLANk in cmd_str     } '           IF cmd_str[1] = '/' THEN             BEGIN                IF cmd_str[2] = '?' THEN cmd_str := ' help '               ELSE cmd_str[1] := ' ';             END      '          ELSE cmd_str[1] := 'X';    { first character is not '/', cause it to '&                                                           fail the strread } &           TRY;             strread(cmd_str,1,pos,cmd);           IF NOT RECOVER THEN                 CASE cmd OF                     B ,  BREAK : WITH message.data DO                               BEGIN                                   VCP_type := 9; { break request }                                   VCP_data.security_code                                       := break_security_code;  !                                length := 2; { bytes of vcp data } !                                 write_net(length);                                  scb^.state_vector := net_read;                                END;                      W ,  WAIT   : scb^.state_vector := net_read_wait;                     R ,  READ   : scb^.state_vector := net_read;                    E ,  EXIT   : WITH scb^ DO                                 BEGIN  #                                 IF NOT suspended THEN active := false #                                  ELSE state_vector := ended;      %                              { tell user we are done, prompt true to keep % "                                user program from waiting for more } "                                      write_user(scb,  &                                            'VCP Interactive Session Ended', &                                             0,true,false);                                              IF ENTVC_class <> 0 THEN                                     { tell ENTVC to terminate }                                         BEGIN                                       get_flag.word := 0; %                                      get_flag.comp_type := terminal_write; %                                           exec_error := false;                                       class_io_no_buff( $                                                  class_write_read_code + $                                                    no_abort,                                                    0,pos,0,0,0, $                                                   ENTVC_class,get_flag); $                                      BEGIN                                          error_return(error_a_reg,   %                                                             error_b_reg); % #                                        exec_error := test_exec_error; #                                       END;     "                                { DON'T TEST FOR SUCCESS IT IS OK FOR "                                       ENTVC TO BE GONE!  }                                          END; { terminate ENTVC }                                         END; { EXIT WITH scb^ }                        HELP        : WITH scb^ DO                                 BEGIN                                  msg_str := '';                                   name_str := '';  %                                 strwrite(name_str,1,pos,pc_logical_name); % %                                 name_str := strrtrim(strltrim(name_str)); %                                      strwrite(msg_str,1,pos, !                                         ' In VCP with ',name_str); !#                                 write_user(scb,msg_str,0,false,false); #                                 msg_str := '';  #                                 strwrite(msg_str,1,pos,' at address ' #!                                  ,LAN_address,' on lu ',LAN_lu:1); !#                                 write_user(scb,msg_str,0,false,false); #                                  write_user(scb,  !' Commands /BREAK, /EXIT, /WAIT, /READ, /?, /HELP',0,false,false); ! !                                 write_user(scb,'',0,false,false); !                                 IF NOT scb^.suspended THEN                                     BEGIN  '                                     write_user(scb,VCPMT_prompt,0,true,true); '%                                     IF scb^.state_vector <> session_failed %                                       THEN BEGIN                                           read_user(scb);  $                                         scb^.state_vector := user_read; $                                       END;                                    END;                                END;                  END  { NOT RECOVER THEN CASE }                ELSE   { failed strread, must not be a command }                  IF NOT scb^.suspended THEN                   WITH message.data DO { send what the user typed }                  BEGIN              { regardless of content }                    strmove(length,message.c,1,VCP_data.data,1);                   length := length + 1;                   VCP_data.data[length] := cr;  { append cr }                   IF odd(length) THEN                     BEGIN                       length := length + 1;                        VCP_data.data[length] := null;                      END;                    VCP_type := 2;                    write_net(length);                    scb^.state_vector := net_read;  
                END; 
                END        ELSE   { zero length user read or not waiting for read }         BEGIN           IF (scb^.state_vector = user_read_abort) OR                (scb^.state_vector = user_read_abort_complete) THEN              BEGIN               write_user(scb,     !               'RMVCP> Command not processed due to status change', !                         14,false,false);               IF NOT trace_post(14) THEN trace_error;              END;            IF NOT scb^.suspended THEN             BEGIN               scb^.state_vector := user_read;               write_user(scb,VCPMT_prompt,0,true,true); $              IF scb^.state_vector <> session_failed THEN read_user(scb); $             END;          END;            IF (scb^.state_vector = net_read) THEN          set_timeout(scb,net_read_timeout);             END;  { process_command }           PROCEDURE process_net_read;     "  { Processes network reads for interactive sessions, displays and/or "    creates daughter sessions and routes the message to them.     Uses scb^ and message from interactive session. }          VAR  new_scb: VCP_session_control_block_ptr;          supress_leader: boolean;           supress_trailer: boolean;          msg_str: term_string_type;         BEGIN     "    { bump the timeout sequence so we will ignore the timeout on this "       read }           scb^.timeout_seq := (scb^.timeout_seq + 1) mod 32768;      %    { if a user read is pending, queue the received while entering command %      message on the user_lu or class and change the state to       user_read_abort }           IF scb^.state_vector = user_read THEN         BEGIN           scb^.state_vector := user_read_abort;           write_user(scb,  ''RMVCP> The following VCP message received while you were entering a command', '                    0,false,false);          END;     %    { if the state is net_read_wait, a read completion always downgrades it %	      to net read } 	          IF scb^.state_vector = net_read_wait THEN          scb^.state_vector := net_read;          $      { If the message is type 1 then figure out if it is a dump request $ "        or requires continuation, or is a completion. Handle message "%        formating for continuation and completions and spawn a dump_session %
        for dump requests } 
          IF message.data.VCP_type = 1 THEN         BEGIN !          IF (length = LAN_header_length + VCP_type_length + 2) AND !             (message.b[length - 1] = 1) THEN             BEGIN      "             { dump request, if a continue read is pending, close it "                and restore the continue status }                   IF scb^.state_vector = net_read_continue THEN 
                BEGIN 
    $                { since the message is a dump request, the following will $%                  only print the trailer line to close the continue message %                  on the users terminal }                        display_message(message,                                   length,scb,' ',0,true,false);                   scb^.state_vector := scb^.continue_state;  
                END; 
                     { now display the dump request }                    display_message(message,                                  length,scb,' ',0,false,false);                      { try to start a dump session to handle the dump }                    new_scb := allocate_scb;                IF new_scb <> NIL THEN 
                BEGIN 
                   WITH new_scb^ DO                     BEGIN                        pc_logical_name := scb^.pc_logical_name;                        LAN_address := scb^.LAN_address;                        LAN_lu := scb^.LAN_lu;                        father := scb;                       session_type := dump;                      END;                   scb^.suspended := true;                   scb^.continue_state := scb^.state_vector;                   scb^.state_vector := dump_session_st; "                  dump_session(message,length,new_scb,rtn1,rtn2,rtn3, "                                                        get_flag);      	                END 	              ELSE  { If we can' start dump session                         send a dump reject request on the LAN }     
                BEGIN 
 $                  report_no_session(scb^.user_lu,scb^.user_class,false); $                   WITH message.data DO                     BEGIN                       VCP_type := 10;                        VCP_data.c0 := 255; { reject dump request }                        VCP_data.c1 := 0;                      END;                   write_net(2);                    set_timeout(scb,net_read_timeout);  
                END; 
            END                ELSE                { This is a normal type one message from VCP }                 BEGIN      #            { If a net_read_continue was pending, supress printing the #"              leader of the message and restore the state that was in ""              effect when the first part of the message was originaly "               received }                   IF scb^.state_vector = net_read_continue THEN 
                BEGIN 
                  supress_leader := true;                   scb^.state_vector := scb^.continue_state; 	                END 	!              ELSE supress_leader := false; { do print the leader } !        "             { now, if this message is not complete (flag byte = 255) "$               suppress the trailer part of the message, save the current $                 state in the continue state, and set the state to                  net_read_continue }      &              IF ((message.b[length] = 0) AND (message.b[length - 2] = 255)) &                                           OR  '                 ((message.b[length] = 255) AND (message.b[length - 1] = 255)) ' 	              THEN 	
                BEGIN 
                   supress_trailer := true;                   scb^.continue_state := scb^.state_vector;                   scb^.state_vector := net_read_continue; 	                END 	 	              ELSE 	                    supress_trailer := false;                       { now display the message }                    display_message(message,                                 length,scb,' ',0,                                   supress_leader,supress_trailer);                      { if no net_read_continue and we are not currently                  waiting on a user read (as evidenced by a !                user_read_abort) then write out the next prompt and !                post the next user read }                   IF (scb^.state_vector <> net_read_continue) AND                   (scb^.state_vector <> user_read_abort) THEN 
                BEGIN 
                  scb^.state_vector := user_read;                   write_user(scb,VCPMT_prompt,0,true,true); #                  IF scb^.state_vector = user_read THEN read_user(scb); # 
                END; 
                 END; { type 1 but not dump request }             END  { type 1 vcp message }            ELSE              BEGIN   { Handle all the other types }                   { if there is a net_read_continue, end it by printing              the trailer, and restore the continue_status }               IF scb^.state_vector = net_read_continue THEN             BEGIN                  { since the message is not type 1, the following will  #              only print the trailer line to close the continue message #              on the users terminal }                    display_message(message,                               length,scb,' ',0,true,false);               scb^.state_vector := scb^.continue_state;              END;                      { now display the received message }                display_message(message,                              length,scb,' ',0,false,false);                    { handle the various types of messages }               CASE message.data.VCP_type OF      
            6: BEGIN 
     #               { type 6 is an RPL request, try to spawn an RPL session #                 and suspend this current session }                      new_scb := allocate_scb;                  IF new_scb <> NIL THEN                     BEGIN                      WITH new_scb^ DO                         BEGIN                           pc_logical_name := scb^.pc_logical_name;                           LAN_address := scb^.LAN_address;                          LAN_lu := scb^.LAN_lu;                          session_type := RPL;                          father := scb; 
                       END; 
                      scb^.suspended := true;                       scb^.continue_state := scb^.state_vector;                      scb^.state_vector := RPL_session_st;                       RPL_session(message,length,new_scb,                                     rtn1,rtn2,rtn3,get_flag);                     END     
                 ELSE 
    !                   { no memory to initiate a new session, report it !                      and sent a download abort message }                         BEGIN     %                     report_no_session(scb^.user_lu,scb^.user_class,false); %                          WITH message DO                         BEGIN                            data.VCP_type := 7; { download record }                          END; { WITH message }      !                     WITH message.data.VCP_data.download_record DO !                        BEGIN                          type_seven_data[0] := 0;                           type_seven_data[1] := -3;                           type_seven_data[2] := -3;                         END; { WITH download_record }                           write_net(6);      "                   { since we expect an immediate error message from " %                     VCP, set the timeout and don't post a new user_read } %                         set_timeout(scb,net_read_timeout);                        END; 	               END; 	         
            3: BEGIN 
     "                { Type 3 is an address acquisition request. Since we "!                  are in a session with the remote node, attempt to !                    start an addressing session to send a directed                     address acquisition reply. }                      new_scb := allocate_scb;                  IF new_scb <> NIL THEN                     BEGIN                      WITH new_scb^ DO                         BEGIN                           pc_logical_name := scb^.pc_logical_name;                           LAN_address := scb^.LAN_address;                          LAN_lu := scb^.LAN_lu;                           session_type := addressing;                          father := scb; 
                       END; 
                      scb^.continue_state := scb^.state_vector;                      scb^.state_vector := address_session_st;                       scb^.suspended := true;  $                     addr_session(message,length,new_scb,rtn1,rtn2,rtn3, $!                                                         get_flag); !                    END     
                 ELSE 
                        BEGIN      $                   { not enough memory to start a session, report it and $ "                     send a direct address acquisition reply anyway, ""                     without retry capability and hope for the best } "    $                   report_no_session(scb^.user_lu,scb^.user_class,false); $                    send_address_acq_reply(message,                                           scb^.LAN_address,                                            scb^.LAN_lu,                                           scb^.session_number);     "                  { expect some kind of reply from VCP so set timeout "                     and don't post a user_read }                        set_timeout(scb,net_read_timeout);     
                 END; 
    	               END; 	         
           11: BEGIN 
    "               { protocol error message, tell the user how to get the " #                 remote system's attention (not with a two by four)  } #                          write_user(scb,  %                 'RMVCP> Use "/BREAK" to enter VCP mode with remote node', %                             15,false,false);                           { if we are not waiting on a user read, send the                     prompt and post a user read  }                      IF (scb^.state_vector <> user_read_abort) OR                      (scb^.state_vector <> session_failed) THEN                         BEGIN                       scb^.state_vector := user_read;                       write_user(scb,VCPMT_prompt,0,true,true);  %                     IF scb^.state_vector = user_read THEN read_user(scb); %                   END;     	               END; 	     
           OTHERWISE 
     !            { we received some kind of VCP message we should never !"              receive in an interactive session, tell the world about "              the error }      	             BEGIN 	#               strwrite(trace_str,1,trace_pos,message.data.VCP_type:1); #
               trace_write; 
               IF NOT trace_post(-17) THEN trace_error;                msg_str := '';                strwrite(msg_str,1,pos,'RMVCP> Message type ',                          message.data.VCP_type:1,                         ' received in error.');                write_user(scb,msg_str,-17,false,false);     !             { if we are not still waiting on a user read, send the !                prompt and post a user read }                    IF (scb^.state_vector <> user_read_abort) OR                    (scb^.state_vector <> session_failed) THEN                       BEGIN                     scb^.state_vector := user_read;                     write_user(scb,VCPMT_prompt,0,true,true);  $                   IF scb^.state_vector = user_read THEN read_user(scb); $
                 END; 
                  END;  { otherwise }               END; { CASE }             END;    { All not type 1 vcp messages }          END;  { process_network_read }      { Start of interactive_session }       BEGIN     !    IF trace_level > 0 THEN trace_session_entry(scb,rtn1,get_flag); !         WITH scb^ DO       BEGIN      
        IF NOT active THEN 
           BEGIN               { initialization } 
            active := true; 
             state_vector := user_read;              write_user(scb,' ',0,false,false); '            write_user(scb,' Virtual Control Panel Monitor Interactive Session' '                           ,0,false,false); 
            user_msg := ''; 
                  strwrite(user_msg,1,pos,'   with ',pc_logical_name);              write_user(scb,user_msg,0,false,false); 
            user_msg := ''; 
             strwrite(user_msg,1,pos,'   at   LAN   lu ',LAN_lu:1,                        ' address ',LAN_address);             write_user(scb,user_msg,0,false,false);              write_user(scb,' ',0,false,false);             write_user(scb,VCPMT_prompt,0,true,true);              IF state_vector = user_read THEN read_user(scb);           END          ELSE  { active, pickup where we left off }     
          IF suspended THEN 
            BEGIN                   break_toggle := true;      "          { Log the fact that a pending user read completed while we "             were suspended }                    IF (get_flag.comp_type = terminal_read) OR                  (get_flag.comp_type = program_read) THEN     
                BEGIN 
                  IF continue_state = break_read_pending THEN                       { allow one command }                         BEGIN                        break_toggle := false;                       continue_state := state_vector;                       IF state_vector <> user_read_abort THEN                          state_vector := user_read;                        process_command;                        timeout_seq := (timeout_seq + 1) mod 32768;                         IF (state_vector <> ended) AND                         (state_vector <> session_failed) THEN                         state_vector := continue_state;                        continue_state := user_read_abort_complete;                      END                        ELSE                       { log the fact that a pending user read                         completed while suspended }                         continue_state := user_read_abort_complete;                      END; { user read completed }                    IF get_flag.comp_type = remote_read THEN                    { bump the timeout sequence counter and ignore }                     timeout_seq := (timeout_seq + 1) mod 32768;         !          { treat any program_read during suspension as a break and !"            ignore the data passed from the program                 } "                      IF ((get_flag.comp_type = ENTVC_break) OR                  (get_flag.comp_type = program_read)) AND                   break_toggle THEN                     { warn the user and allow one command }     
                BEGIN 
                  user_msg := ''; $                  strwrite(user_msg,1,pos,'RMVCP> session suspended in ', $                             state_vector);                   write_user(scb,user_msg,0,false,false);                   write_user(scb, #                      '       use /BREAK to abort, return to continue', #                              0,false,false);                   write_user(scb,VCPMT_prompt,0,true,true);                    IF state_vector <> session_failed THEN                     BEGIN                       read_user(scb);                       continue_state := break_read_pending;                      END;  
                END; 
                 END    { suspended }                ELSE                  BEGIN  { NOT suspended }                   { sort out what to do from received data and state }                     CASE state_vector OF                     address_session_st,                 RPL_session_st,                  dump_session_st:      &                 { This must be a return from suspend, check, print failure, & "                   set timeout and go to net_read state for possible "                    further message from VCP.  %                   If no failure, restore state and process message passed %                   back from suspending session }                       BEGIN  $                    IF rtn1 <> 0 THEN { suspension ended in some kind of $#                                        error, recover based on what we # $                                        were doing prior to suspension } $
                      BEGIN 
                                IF state_vector = RPL_session_st THEN &                          write_user(scb,'RMVCP> Boot failed',0,false,false); &                             IF state_vector = dump_session_st THEN                           write_user(scb,                              'RMVCP> Memory dump failed',                                         0,false,false);                                  IF state_vector = address_session_st THEN                            write_user(scb,                               'RMVCP> Address acquisition failed',                                          0,false,false);                              IF state_vector <> session_failed THEN                           BEGIN                             state_vector := net_read;                              set_timeout(scb,net_read_timeout);                            END;      $                        get_flag.comp_type := terminal_write; { force do $'                                                                nothing later } '                           END  { suspending session failed }      $                    ELSE { suspend ended successfully, restore state and $ #                           let the normal processes handle the message # "                           passed back from the suspending session } "    
                      BEGIN 
                            IF state_vector = RPL_session_st THEN  '                          write_user(scb,'RMVCP> Boot completed successfully', '                                        0,false,false);                              IF state_vector = dump_session_st THEN                           write_user(scb,  $                            'RMVCP> Memory dump completed successfully', $                                        0,false,false);                              IF state_vector = address_session_st THEN                             state_vector := continue_state                          ELSE     #                      { set state to net_read and set timeout to expect #"                        more information to follow from vcp, then set "%                        the get_flag to console_write to take the otherwise % %                        path in the following case statement to just leave % &                        the interactive session with a remote read pending } &                              BEGIN  !                            IF state_vector <> session_failed THEN !                              BEGIN                                 state_vector := net_read;  !                                set_timeout(scb,net_read_timeout); !                               END;                               get_flag.comp_type := console_write;                             END;                           END; { successful suspend }                        END; { return from suspend }     %                session_failed,  { somewhere a problem occured, just exit } %    %                ended:     { we received a /EXIT command after a break from %                              entvc so just end }                   BEGIN                      active := false;                     get_flag.comp_type := terminal_write;  '                                                    { force do nothing later } '                   END;          %                OTHERWISE; { not a return from suspend or ended, procede } %                  END; { return from suspend CASE }                    CASE get_flag.comp_type OF     '                remote_write,  { network error only, already reported to user } '                 ENTVC_break:                       IF (state_vector = net_read) OR                       (state_vector = net_read_wait) OR                       (state_vector = net_read_continue) THEN                         BEGIN                        timeout_seq := (timeout_seq + 1) mod 32768;                         state_vector := user_read;                       write_user(scb,VCPMT_prompt,0,true,true);  #                      IF state_vector = user_read THEN read_user(scb); #                     END;                         program_read,                 terminal_read: process_command;     #                remote_read:  { data from remote, send to user or start #                                  RPL or dump sessions or }                       process_net_read;      $                timeout_occured:   { figure out what we were waiting for $ !                                     and take appropriate action } !                        IF timeout_seq = rtn1 THEN  { handle timeout }                      BEGIN                       IF rtn2 <> 0 THEN      $                      { unable to set timeout due to insufficient memory $ #                        in VTIMR, go into a net_read_wait and tell the #                         user to use BR to end the read }                             BEGIN                           IF state_vector = net_read THEN                              state_vector := net_read_wait;  (  write_user(scb,'RMVCP> Unable to set timeout, use BR ENTVC to terminate read', (                             11,false,false); 
                        END 
 
                      ELSE 
                            { this is a real timeout, handle it }                             BEGIN      !                          IF state_vector = net_read_continue THEN !                                { dummy up a VCP message type and tell  !                            display_message to print the trailer to ! "                            close the message on the users terminal, " !                            then downgrade the state to net_read } !                                BEGIN                               message.data.VCP_type := 3;                               state_vector := net_read;  !                              display_message(message,0,scb,' ',0, !                                               true,false);                              END;                               IF state_vector = net_read THEN                             BEGIN  %                              write_user(scb,'RMVCP> Timeout occurred',16, %                                          false,false);  %                              IF (continue_state = break_read_pending) AND % #                                 (state_vector <> session_failed) THEN #                                state_vector := user_read_abort                                ELSE                                 BEGIN                                    state_vector := user_read; %                                  write_user(scb,VCPMT_prompt,0,true,true); % !                                  IF state_vector = user_read THEN !                                    read_user(scb);                                  END;                              END;                             END; { handle timeout }                          END; { sequence number matches }                     { ELSE ignore timeout }     #                otherwise ;{ an error that should never occur, ignore } #                  END; { CASE get_flag.comp_type OF }                END; { NOT suspended }              IF state_vector = session_failed THEN active := false;            END; { with scb^ }          IF trace_level > 0 THEN trace_session_exit(scb);        END; { interactive_session }     PROCEDURE init_interactive_session;     ! { On entry assume that a class read saving buffer has been done to ! $   return the get_flag, the next class get returns the same information. $"   Don't allow an interactive session if a session is already active. "$   Pickup buffer, allocate an scb, fill it in with proper values based on $ %   buffer contents and flag to determine if it is programmatic or terminal %#   (ENTVC) initiatied. Then launch an interactive session to handle the #   VCP session. }        VAR in_buffer: interactive_init;       new_scb: VCP_session_control_block_ptr;       lu_class: shortint;       ENTVC_class_numb: shortint;       get_flag: completion_data_type;       ENTVC_flag: completion_data_type;       temp_string: string[4];       net_lu: shortint;        dummy_buffer: LAN_buffer_type;        term_buffer: term_buff_type; 
      rtn3: shortint; 
      session_table_ptr: VCP_session_control_block_ptr;  
      busy: boolean; 
      BEGIN      exec_error := false;  {} {   class_get_init(class_get_code + no_abort,VCPMT_get_class,  {                  in_buffer,interactive_init_record_length,  {                  lu_class,ENTVC_class_numb,rtn3,get_flag); {   BEGIN  {     error_return(error_a_reg,error_b_reg);  {     exec_error := test_exec_error;  {   END;  {}  get_flag := global_class_get_flag;  in_buffer.c := global_remote_data.d;  lu_class := global_rtn1;  ENTVC_class_numb := global_rtn2; 
 rtn3 := global_rtn3; 
        IF exec_error THEN { rte error on exec call }       get_error     ELSE  { class get ok, get scb }       BEGIN         get_error_count := 0;  
        temp_string := ''; 
        strwrite(temp_string,1,dummy,in_buffer.network_lu);          strread(temp_string,1,dummy,net_lu);              busy := false;          session_table_ptr := VCP_session_table_head;          REPEAT            WITH session_table_ptr^ DO             BEGIN                IF active THEN 
                BEGIN 
                  IF net_lu = LAN_lu THEN                     BEGIN                        IF in_buffer.LAN_address = LAN_address THEN                          busy := true;                      END;  
                END; 
              IF NOT busy THEN session_table_ptr := next_scb;              END;          UNTIL busy OR (session_table_ptr = NIL);              IF NOT busy THEN           new_scb := allocate_scb          ELSE           new_scb := NIL;              IF new_scb <> NIL THEN           BEGIN              WITH new_scb^ DO 	              BEGIN 	                pc_logical_name := in_buffer.pc_logical_name;                 LAN_address := in_buffer.LAN_address;                 LAN_lu := net_lu;                  session_type := interactive;                 IF get_flag.comp_type = ENTVC_init THEN                   BEGIN                      user_lu := lu_class;                      user_class := 0;                      ENTVC_class := ENTVC_class_numb;                     ENTVC_flag.word := 0;                      ENTVC_flag.comp_type := ENTVC_break;                     ENTVC_flag.session := session_number;                      exec_error := false;      %                    { send ENTVC the flag to use to break a network read } %     #                    class_io_no_buff(class_write_read_code + no_abort, # %                                     0,rtn3,0,0,0,ENTVC_class,ENTVC_flag); %                    BEGIN                        error_return(error_a_reg,error_b_reg);                        exec_error := test_exec_error;                      END;                     IF exec_error THEN class_error ELSE                       class_error_count := 0;     
                  END 
 
                ELSE 
                  BEGIN                     user_lu := 0;                     user_class := lu_class;                     ENTVC_class := 0;                    END;  	              END; 	                interactive_session(dummy_buffer,0,new_scb, $                                lu_class,ENTVC_class_numb,rtn3,get_flag); $          END          ELSE { no memory to initiate session now }           BEGIN             IF get_flag.comp_type = program_init THEN                report_no_session(0,lu_class,busy)              ELSE 	              BEGIN 	                report_no_session(lu_class,0,busy);      "             { send two messages to ENTVC to cause it to terminate } "                     exec_error := false;  !                class_io_no_buff(class_write_read_code + no_abort, !%                                 0,net_lu,0,0,0,ENTVC_class_numb,get_flag); %
                BEGIN 
                   error_return(error_a_reg,error_b_reg);                    exec_error := test_exec_error;  
                END; 
     !                class_io_no_buff(class_write_read_code + no_abort, ! &                                  0,net_lu,0,0,0,ENTVC_class_numb,get_flag); &
                BEGIN 
                   error_return(error_a_reg,error_b_reg);                    exec_error := test_exec_error;  
                END; 
     &               { don't test exec error we don't want to die if ENTVC gone  } & &               {IF exec_error THEN class_error ELSE class_error_count := 0;} &                  END; { ENTVC_init }            END; 
      END; { class get ok } 
  END; { init_interactive_session }     %PROCEDURE return_to_session(VAR message: LAN_buffer_type; length: shortint; %!                                scb: VCP_session_control_block_ptr; !                                rtn1,rtn2,rtn3: shortint;                                   get_flag: completion_data_type);      ! { Used by RPL, dump and addressing sessions to return to suspended !!   sessions. Provides tracing of the return_from_suspend completion !    type as if it were received by a class get. }           BEGIN     
    IF trace_level > 2 THEN 
      BEGIN          strwrite(trace_str,1,trace_pos,get_flag.comp_type,                                    ' return from suspend');  
        trace_write; 
        IF NOT trace_post(13) THEN trace_error;        END;         IF scb^.active THEN  { return to the father }           CASE scb^.session_type OF              interactive: interactive_session(message,length,                                           scb,rtn1,rtn2,rtn3,                                            get_flag);              RPL        : RPL_session(message,length,                                           scb,rtn1,rtn2,rtn3,                                            get_flag);             dump       : dump_session(message,length,                                           scb,rtn1,rtn2,rtn3,                                            get_flag);             addressing : addr_session(message,length,                                           scb,rtn1,rtn2,rtn3,                                            get_flag);              unexpected : ; { should never happen but may satisfy some                                       compiler quirk } 	      END; { case } 	          { ELSE  father not active, just leave }        END; { return_to_session }      
PROCEDURE pass_to_session; 
    ! { On entry assume that a class read saving buffer has been done to !    return the session number, the next class get returns the same  "   information. Find the session control block indexed by the session " "   number and transfer to that session, passing the class get buffer " 
   and transmission log. } 
      VAR   remote_data: LAN_buffer_type;          trans_log: shortint;          driver_stat: shortint;         session_ptr: VCP_session_control_block_ptr;  %        rtn1,rtn2,rtn3: shortint;                   { class get return   } % %        get_flag: completion_data_type;             { parameters         } %      BEGIN      exec_error := false;          if class_get_flag.comp_type = timeout_occured then       begin                   get_flag := class_get_flag;                   rtn1     := timeout_rtn1;                  rtn2     := 0;                  exec_error := false;       end      else       begin  {}  {     class_get_LAN(class_get_code + no_abort,VCPMT_get_class, {               remote_data,LAN_message_max_length, {               rtn1,rtn2,rtn3,get_flag);  {  {     BEGIN  {       error_return(error_a_reg,error_b_reg);  {       exec_error := test_exec_error;  {     END;  {     a_b_register(driver_stat,trans_log);  {}  get_flag := global_class_get_flag;   remote_data := global_remote_data ; 
 rtn1 := global_rtn1; 

 rtn2 := global_rtn2; 

 rtn3 := global_rtn3; 
   driver_stat := global_status; { from the a_b_register in main }  ! trans_log   := global_trans_log; { form the a_b_register in main } !         end;         IF exec_error THEN { rte error on exec call }       get_error     ELSE  { get call ok }       BEGIN         get_error_count := 0;             session_ptr := get_scb(get_flag);      $        IF session_ptr <> NIL THEN { found active session ok, continue } $              BEGIN             CASE session_ptr^.session_type OF     "              interactive: interactive_session(remote_data,trans_log, "%                                                session_ptr,rtn1,rtn2,rtn3, %                                                 get_flag);                   RPL        : RPL_session(remote_data,trans_log, %                                                session_ptr,rtn1,rtn2,rtn3, %                                                 get_flag);                    dump       : dump_session(remote_data,trans_log, %                                                session_ptr,rtn1,rtn2,rtn3, %                                                 get_flag);                    addressing : addr_session(remote_data,trans_log, %                                                session_ptr,rtn1,rtn2,rtn3, %                                                 get_flag);     #              unexpected : ; { should never happen but may satisfy some #                                   compiler quirk }             END; { case }     &          END; { found active session, not found tracing handled by get_scb } &      END; { exec get call ok }      END; { pass_to_session }     PROCEDURE check_network_error(get_flag: completion_data_type;                               driver_status: shortint);      # { This procedure is entered after a class get for a network write. It # %   is passed get_flag (session number) and driver status. If driver status %!   indicates no error it simply returns, bur if an error occurs the ! !   session (ultimate father session) is tracked down and the error ! "   reported to the proper place, then it returns to the session that " $   produced the write. All sessions know that writes don't return except $ %   on error. If no error, or no session found, the class get is re-done to %   flush the completed request. }       VAR   session: VCP_session_control_block_ptr;          error_buff: octal_numb_buffer;       BEGIN     IF binand(driver_status,error_bit_mask) <> 0 THEN       BEGIN         session := get_scb(get_flag);          IF session <> NIL THEN           BEGIN  $            report_network_error(driver_status,session^.LAN_lu,session); $             pass_to_session;           END         ELSE { no session just flush completion }           BEGIN !            driver_status := binand(driver_status,error_code_mask); !             driver_status := driver_status div 16;              octal_cnvrt(driver_status,error_buff);             IF error_buff[5] = ' ' THEN error_buff[5] := '0'; $            strwrite(trace_str,1,trace_pos,'Driver error ',error_buff[5], $                    error_buff[6],'B on network write,');              trace_write; "            trace_str := 'session and LU number could not be found.'; "             trace_write;              IF NOT trace_post(-13) THEN trace_error;            END;        END { if error occured }    END; { check_network_error }            PROCEDURE complete_remote_read(nlu: shortint); ! { On entry assume that a class read saving buffer has been done to !!   determine that the get is for a remote read completion. The next !    class get returns the same information.  Try to find an active  "   session for the network lu and source address and transfer to that " "   session, passing the class get buffer and transmission log. If no "!   active session found, pass the buffer and transmission log to an !    unexpected session. }           VAR   remote_data: LAN_buffer_type;          trans_log: shortint;          driver_stat: shortint;         found: boolean;         session_table_ptr: VCP_session_control_block_ptr;         LAN_address_temp: LAN_address_type; !        rtn1,rtn2,rtn3: shortint;             { class get return  } !!        get_flag: completion_data_type;       { parameters        } !          BEGIN  {}  {   exec_error := false;  {   {   class_get_LAN(class_get_code + no_abort,VCPMT_get_class, {                 remote_data,LAN_message_max_length, {                 rtn1,rtn2,rtn3,get_flag);  {  {   BEGIN  {     error_return(error_a_reg,error_b_reg);  {     exec_error := test_exec_error;  {   END;  {   a_b_register(driver_stat,trans_log);  {}  get_flag := global_class_get_flag;   remote_data := global_remote_data ; 
 rtn1 := global_rtn1; 

 rtn2 := global_rtn2; 

 rtn3 := global_rtn3; 
   driver_stat := global_status; { from the a_b_register in main }  ! trans_log   := global_trans_log; { from the a_b_register in main } !    IF exec_error THEN { rte error on exec call abort }       get_error      ELSE       BEGIN         get_error_count := 0;             IF binand(driver_stat,error_bit_mask) <> 0 THEN           report_network_error(driver_stat,nlu,NIL)             ELSE { figure out who this read data belongs to }           BEGIN      $          { Search active sessions for this LAN address and network lu } $    
            found := false; 
             session_table_ptr := VCP_session_table_head; "            LAN_address_temp := extract_LAN_source_addr(remote_data); "    "                {!!!!!!!!!!!!!!!!!!!!!! 802.3 !!!!!!!!!!!!!!!!!!!!!!} " "            remote_data.data.VCP_type := -remote_data.data.VCP_type; ""                {!!!!!!!!!!!!!!!!!!!!!! 802.3 OFF !!!!!!!!!!!!!!!!!!} "            { trace the message arrival }                 IF trace_level > 1 THEN 	              BEGIN 	                 strwrite(trace_str,1,trace_pos,nlu:1);                  trace_write;                  strwrite(trace_str,1,trace_pos,'and address ', &                LAN_address_temp,' of VCP type ',remote_data.data.VCP_type:1, &                ' and length ', "                (trans_log - LAN_header_length - VCP_type_length):1); "                 trace_write;                 IF NOT trace_post(18) THEN trace_error;  	              END; 	     	            REPEAT 	               WITH session_table_ptr^ DO 
                BEGIN 
                   IF active AND (state_vector <> ended) THEN                     BEGIN                        IF LAN_lu = nlu THEN                         BEGIN                             IF LAN_address_temp = LAN_address THEN                               found := true;                          END;                       IF found THEN                         BEGIN                           IF suspended THEN found := false;  %                            { found the father, keep looking for the son } %                         END;                      END;  !                  IF NOT found THEN session_table_ptr := next_scb; !                END;  { with session_table_ptr^ }             UNTIL found OR (session_table_ptr = nil);                 IF found THEN { pass to session } 	              BEGIN 	 !                remove_timeout(session_table_ptr^.session_number); !                CASE session_table_ptr^.session_type OF     $                  interactive: interactive_session(remote_data,trans_log, $ #                                                    session_table_ptr, #!                                                    rtn1,rtn2,rtn3, !                                                     get_flag);                        RPL        : RPL_session(remote_data,trans_log,   #                                                    session_table_ptr, #!                                                    rtn1,rtn2,rtn3, !                                                     get_flag);      !                  dump       : dump_session(remote_data,trans_log, ! #                                                    session_table_ptr, #!                                                    rtn1,rtn2,rtn3, !                                                     get_flag);      !                  addressing : addr_session(remote_data,trans_log, ! #                                                    session_table_ptr, #!                                                    rtn1,rtn2,rtn3, !                                                     get_flag);     %                  unexpected : ; { should never happen but may satisfy some %                                       compiler quirk }                 END; { case }                END {if found}                  ELSE unexpected_session(remote_data,trans_log,nlu,  '                                    LAN_address_temp,rtn1,rtn2,rtn3,get_flag); '               END; { no driver error }       END; { no class get error }     END; { complete_remote_read }     BEGIN { VCPMT }       { setup testing if required }       test_parms;        { Get lu number for standard I/O and initilaze        ( this is required if all numbers in the         run string are to be interpreted as network          lu numbers )                                 }          	  in_string := ''; 	 
  dummy := loglu(user_lu); 
   strwrite(in_string,1,dummy,user_lu);    rewrite(output,in_string);   reset(input,in_string);       get_error_count := 0;   class_error_count := 0;        trace_control(0,'',0,true,user_lu,exec_error);        { redo input and output files if testing }       io_testing;       { Recover run string, parse to get lu numbers }      	  in_string := ''; 	  trans_log := get_run_string(1,in_string);       IF trans_log <= 0 THEN { no lus, print no lus error message }     BEGIN        writeln(output); $      writeln(output,'RMVCP> Error, no   LAN   lu numbers in runstring'); $       writeln(output);  #      writeln(output,'       usage: CI [RUn] VCPMT lu [lu] [lu] ...'); #       writeln(output); 
      writeln(output, 
      '          where "lu" is a valid LAN interface');       writeln(output,'          read (lower) lu number');        writeln(output);  	      escape(NIL); 	     END;          
  { get own class number } 
    	  VCPMT_class := 0; 	  code := 1 + no_wait_clrq + no_abort_clrq;    exec_error := false;    class_request(code,VCPMT_class);   BEGIN      error_return(error_a_reg,error_b_reg);      exec_error := test_exec_error;    END;    a_b_register(a_reg,b_reg);     "  IF exec_error OR (a_reg <> 0) THEN { something went wrong with this "                                                class request }     BEGIN        writeln(output); 
      writeln(output, 
              'RMVCP> Error, unable to allocate a class number ');             IF exec_error THEN         writeln(output,             '       an RTE error ',error_a_reg,error_b_reg,                                  ' has occurred')        ELSE         writeln(output,             '       no class numbers available');            writeln(output);  	      escape(NIL); 	     END;      &  VCPMT_get_class := VCPMT_class + save_class_number; { set save class bit } &       { start up VTIMR and die if it fails }       init_vtimr;    VTIMR_active := true ;  { initialize is true so errors get                                         printed on 'output' }       IF NOT VTIMR_active THEN escape(NIL); { die }        { initialize VCP session table }     	  set_max_sessions; 	    "  IF session_numb_max < max_session_nesting THEN { can't run, abort } "    BEGIN        writeln(output); 
      writeln(output, 
"      'RMVCP> Error, insufficient memory to create minimum number (', "               max_session_nesting:1,') of sessions,'); &      writeln(output,'       Increase partition size requirements of VCPMT'); &       writeln(output);  	      escape(NIL); 	    END    ELSE     BEGIN        writeln(output);        writeln(output,'RMVCP> Maximum concurrent VCP sessions = ',                       session_numb_max:1);        writeln(output);      END;        new(VCP_session_table_head);   WITH VCP_session_table_head^ DO     BEGIN        active := false;  
      session_number := 1; 
      timeout_seq := 0;        next_scb := NIL;      END;      { extract lu numbers from run string and             send class number to driver for each network lu }        strwrite(in_string,1,pos,term_buff);   in_string := strrtrim(in_string);   pos := 1;  	  number_lus := 0; 	   my_lsap := VCPMT_lsap;   trans_log := get_run_string(pos,in_string);   WHILE trans_log >= 0 DO     BEGIN           IF trans_log > 0 THEN { parameter is not null }         BEGIN                TRY;             strread(in_string,1,trans_log,control_word[0]);           IF RECOVER THEN             BEGIN               IF (recover_block^.error_type <> io) OR                   (recover_block^.error_number <> 9) THEN                   { unexpected error, abort }                     BEGIN { unknown error type, abort }                    clear_LAN_class_entries;                    escape(recover_block); $                END; { else simply a non-numeric parameter, just ignore } $    
            END { recover } 
               ELSE { successful parameter read for lu number }                  { check out lu, set lsap table, add to lu list }                 BEGIN                    IF number_lus = max_LAN_lus THEN 
                BEGIN 
                   writeln(output);                   writeln(output,                   'RMVCP> Error, too many LAN lus specified,');                   writeln(output, "               '       maximum number of LAN lus is ',max_LAN_lus:1); "                  writeln(output,'       VCPMT aborted');                    writeln(output);                    clear_LAN_class_entries;                    escape(NIL);  
                END; 
                  control_word[1] := 0;               code := device_status + no_abort;                exec_error := false;                device_status_check(code,control_word,status); 	              BEGIN 	                 error_return(error_a_reg,error_b_reg);                  exec_error := test_exec_error;  	              END; 	                   IF exec_error THEN 
                BEGIN 
                   writeln(output);                   writeln(output, !                  'RMVCP> Error, while checking the status of lu ', !&                                                          control_word[0]:1); &                  writeln(output,                    '       an RTE error ',error_a_reg,error_b_reg,                                              ' has occurred');                   writeln(output,  &              '       Only valid CDS-NIU interface lu numbers are allowed'); &                  writeln(output,                    '       VCPMT aborted');                    writeln(output);                    clear_LAN_class_entries;                    escape(NIL);  
                END; 
                   IF binand(status,type_mask) <> CDS_NIU_type THEN 
                BEGIN 
                   writeln(output); #                  writeln(output,'RMVCP> Error, lu ',control_word[0]:1, #                                  ' is not LAN interface lu,');                    writeln(output,'       lu is ignored.');                    writeln(output); 	                END 	 	              ELSE 	 &                BEGIN { lu checks out ok, set class number and add to list } &                  code := io_control_code + no_abort;                   control_word[1] := set_class_entry;                   dummy := 0;                    exec_error := false;  %                   { mod for the changes for the 802.3 driver 8/2/85 JWHS} %                    io_control(code,control_word,vcp_program_code,                                        VCPMT_class,dummy,dummy);                   BEGIN                      error_return(error_a_reg,error_b_reg);                      exec_error := test_exec_error;                    END;                   a_b_register(status,dummy); "                  status_error := binand(status,error_bit_mask) <> 0; "     &                BEGIN { and now check if a dispatcher is already running   } & &                      { first look at sap F8 if somebody is using it       } &                  code := io_control_code + no_abort;                    control_word[1] := get_class_number;                   dummy := 0;                    exec_error := false;  %                   { mod for the changes for the 802.3 driver 8/2/85 JWHS} % #                  io_control(code,control_word,my_lsap,0,20465,20465); #                  BEGIN                      error_return(error_a_reg,error_b_reg);                      exec_error := test_exec_error;                    END;                   a_b_register(status,dummy); "                  status_error := binand(status,error_bit_mask) <> 0; "                   return_parms(rmp_array);                   sap_f8_class:=rmp_array[3];                    sap_1_class:=-1;                   if (sap_f8_class <> 0 )                    then begin                       code := io_control_code + no_abort;                      control_word[1] := get_class_number;                       dummy := 0;                      exec_error := false; &                      { mod for the changes for the 802.3 driver 8/2/85 JWHS} &!                     io_control(code,control_word,1,0,20465,20465); ! 
                     BEGIN 
                       error_return(error_a_reg,error_b_reg);                        exec_error := test_exec_error;                      END;                       a_b_register(status,dummy);  $                     status_error := binand(status,error_bit_mask) <> 0; $                     return_parms(rmp_array);                      sap_1_class:=rmp_array[3];                      end;                    end;                   if(sap_f8_class <> sap_1_class)                    then begin                      IF NOT (exec_error OR status_error) THEN                       {no reason to do the error processing twice}   
                     BEGIN 
                        control_word[1] := set_class_entry;                         dummy := 0;                        exec_error := false;                             io_control(code,control_word,my_lsap,                                          VCPMT_class,dummy,dummy);                          BEGIN                          error_return(error_a_reg,error_b_reg);                          exec_error := test_exec_error; 
                       END; 
                            a_b_register(status,dummy);  %                       status_error := binand(status,error_bit_mask) <> 0; %                      END                       ELSE                 {process for the error}  
                      BEGIN 
                         writeln(output);                         writeln(output, %                       'RMVCP> Error, while setting a class number on lu ', % &                                                         control_word[0]:1); &                             IF exec_error THEN                           writeln(output, $                          '       an RTE error ',error_a_reg,error_b_reg, $                                         ' has occurred')                          ELSE                           BEGIN  &                            status := binand(status,error_code_mask) div 16; &                            octal_cnvrt(status,err_buff); $                            IF err_buff[5] = ' ' THEN err_buff[5] := '0'; $                            writeln(output,  &                            '       a driver error ',err_buff[5],err_buff[6] &                            ,'B has occurred');                            END;                         writeln(output,                          '       VCPMT aborted');                          writeln(output);                          clear_LAN_class_entries;                          escape(NIL);  
                      END; 
                    end                    else begin                      rmp_array[1]:=vcpmt_class;                       rmp_array[2]:=15;                      rmp_array[3]:=7;                      rmp_array[4]:=control_word[0];                       msg:=0;                      msgl:=1; "                     exec20(20,0+binary('0001000000000000'),msg,msgl, "                                  rmp_array,4,sap_1_class,0);                        end;                   number_lus := number_lus + 1;                    lu_array[number_lus] := control_word[0];                  END; { adding lu to list }                  END; { parameter read ok }             END; { trans_log > 0 , not a null parameter }     
      pos := pos + 1; 
      trans_log := get_run_string(pos,in_string);          END; { while loop to setup lus }     #  IF number_lus <= 0 THEN { there were no valid lus in the run string } #    BEGIN        writeln(output); 
      writeln(output, 
       'RMVCP> Error, no LAN lu numbers in runstring');        writeln(output); 
      writeln(output, 
      '       usage: CI [RUn] VCPMT lu [lu] [lu] ...');        writeln(output); 
      writeln(output, 
      '          where "lu" is a valid LAN interface'); 
      writeln(output, 
       '          read (lower) lu number');        writeln(output);  	      escape(NIL); 	     END;        detach_from_session;        REPEAT { always loop to here }     !  { setup class get, save buffer and just check optional parameters !    to decide who gets to do the get to pickup the buffer }        exec_error := false;        { sleep on class get waiting for something to happen }    timeout_value := time_to_wait;  {}  {  class_get_no_buff_to(class_get_code + no_abort,VCPMT_get_class  #{                                                  + save_class_buffer, # {                                       dummy,0,parameter_1,  {                                       dummy,dummy,  #{                                       class_get_flag,timeout_value); # {}      class_get_LAN(class_get_code + no_abort,VCPMT_get_class,  $                  global_remote_data,LAN_message_max_length,global_rtn1, $'                  global_rtn2,global_rtn3,global_class_get_flag,timeout_value); '  BEGIN      error_return(error_a_reg,error_b_reg);      exec_error := test_exec_error;    END;   a_b_register(global_status,global_trans_log);      
  status := global_status; 
  parameter_1 := global_rtn1;    class_get_flag := global_class_get_flag;         
  IF exec_error  THEN 
    BEGIN        get_error;  !      class_get_flag.comp_type := unknown_15; { cause do nothing } !    END    ELSE     BEGIN       if status = -32768 then         BEGIN            class_get_flag.comp_type := timeout_occured;            service_timeouts(class_get_flag,timeout_rtn1);           remove_timeout(session_numb);         END       else service_timeouts(class_get_flag,timeout_rtn1); 
      get_error_count := 0; 
           { if tracing log the occurance }           session_numb := class_get_flag.session;           IF trace_level > 2 THEN         BEGIN           strwrite(trace_str,1,trace_pos,                                      class_get_flag.comp_type);            trace_write;           IF NOT trace_post(13) THEN trace_error;          END;      END;      $  { return from class get, examin class get flag and decide what to do } $       CASE class_get_flag.comp_type OF      
    remote_read    : begin 
                     { is this data realy for us must be}                       { DSAP = F8h and  610h < DXSAP < 614h } !                     IF (( global_remote_data.dsap = VCP_lsap ) and !                           ( global_remote_data.dxsap >  1551) and   !                         ( global_remote_data.dxsap < 1557))  THEN !                          { thats  for us }  '                        complete_remote_read(session_numb);{ session_numb is } '&                      end;                                  {  network lu for &&                                                               remote reads } &          remote_write   : check_network_error(class_get_flag,status);           console_write  : flush_completion;          terminal_write : flush_completion;         terminal_read  : pass_to_session;          ENTVC_init     : init_interactive_session;          program_init   : init_interactive_session;         program_read   : pass_to_session;      
    timeout_occured: BEGIN 
                       IF session_numb > 0 THEN pass_to_session                             ELSE { VTIMR trace/error info }                           BEGIN                            VTIMR_error_trace;                          END;  
                      END; 
        trace_command  : trace_level_set;         ENTVC_break: pass_to_session;         otherwise ; flush_completion;        END;        UNTIL false;      END. 