"$cds on $ $range off$ $DEBUG ON $ $HEAP_DISPOSE OFF$ $TRACE_BACK ON $ " $HEAP 1$ $HEAPPARMS OFF$ $tables on$  $TITLE 'VCPMT GM Marion VCP IPL '$ $SUBTITLE 'tables Access Routines'$  $AUTOPAGE$  $PASCAL ',4,80 92078-16115 REV.5020 <900501.1530>'  {    NAME:   vcpmt_ipl_table       SOURCE: 92078-18115       RELOC:  92078-16115      PGMR:   mh      !  **************************************************************** ! !  * (C) COPYRIGHT HEWLETT-PACKARD COMPANY 1989.  ALL RIGHTS      * ! !  * RESERVED.  NO PART OF THIS PROGRAM MAY BE PHOTOCOPIED,       * ! !  * REPRODUCED OR TRANSLATED TO ANOTHER PROGRAM LANGUAGE WITHOUT * ! !  * THE PRIOR WRITTEN CONSENT OF HEWLETT-PACKARD COMPANY.        * ! !  **************************************************************** ! }   {   VCP Monitor IPL tables Access Routines       }     MODULE vcpmt_ipl_table;      { These routines handle IPL Table access    Virtual Control Panel Monitor programs       }      IMPORT $SEARCH 'TRY_RECOVER.REL'$ try_recover,         $SEARCH 'vcp_DECLS.REL'$ vcp_decls,         $SEARCH 'TEST_PROCS.REL'$ test_procs,         $SEARCH 'VCPMT_TRACE.REL'$ vcpmt_trace;              EXPORT         PROCEDURE open_ipl_file_table(VAR table: ipl_file_table_type;                               VAR error: boolean;                               VAR busy: boolean);          FUNCTION read_ipl_file_table(VAR table: ipl_file_table_type;                         VAR error: boolean; %                        VAR eof_flag: boolean): ipl_file_table_record_type; %    FUNCTION get_ipl_file_name(pc_name: pc_logical_name_type;                             VAR error: boolean; !                           VAR busy: boolean): file_path_name_type; !     !FUNCTION get_pc_name(net_lu: shortint; LAN_addr: LAN_address_type; !                      VAR error: boolean;                       VAR busy: boolean): pc_logical_name_type;     &FUNCTION get_LAN_address(pc_name: pc_logical_name_type; VAR net_lu: shortint; &                          VAR error: boolean;                           VAR busy: boolean): LAN_address_type;      FUNCTION get_no_LAN_address(pc_name: pc_logical_name_type;                              pc_no: pc_logical_no_type;                           VAR net_lu: shortint;                           VAR error: boolean;                           VAR busy: boolean): LAN_address_type;     IMPLEMENT          $INCLUDE 'vcp_EXTERNALS.pasi'$         PROCEDURE open_ipl_file_table(VAR table: ipl_file_table_type;                               VAR error: boolean;                               VAR busy: boolean);       { Opens the file whose name is in the global constant     ipl_file_table_name which should be an ipl file table file.     Returns the passed file variable opened. If an open  &    error is because the file is already open, returns busy true. If another &!    error occurs, error is set and the error message is returned in !    trace_str }       BEGIN 	    error := false; 	 	    busy := false; 	     TRY;        reset(table,ipl_file_table_name,'SHARED');     IF recover THEN { file open error }       BEGIN          IF (recover_block^.error_type = fmp) AND             (recover_block^.error_number = -8) THEN                {file is in use, may want to try later }              busy := true              ELSE               BEGIN { other error }             strwrite(trace_str,1,trace_pos,              'unable to open IPL table file "',             ipl_file_table_name,'"');              trace_write;             strwrite(trace_str,1,trace_pos,             'a Pascal error type ',recover_block^.error_type, #            ' number ',recover_block^.error_number:1,' has occurred.'); #             trace_write;  
            error := true; 
           END;           END; { error processing }        END; { open_ipl_file_table }      FUNCTION read_ipl_file_table(VAR table: ipl_file_table_type;                         VAR error: boolean; %                        VAR eof_flag: boolean): ipl_file_table_record_type; %       { serialy reads one record from an open ipl file table file and   %  handles the appropriate errors, error messages are returned in the trace %   string }       VAR   table_record: ipl_file_table_record_type;       BEGIN 	    error := false; 	     eof_flag := false;      REPEAT        IF NOT eof(table) THEN         BEGIN            TRY;             read(table,table_record);           IF recover THEN  { read error }             BEGIN               strwrite(trace_str,1,trace_pos,               'while reading the IPL table file "',               ipl_file_table_name,'"');  
              trace_write; 
              strwrite(trace_str,1,trace_pos,               'a Pascal error type ',recover_block^.error_type, $              ' number ',recover_block^.error_number:1,' has occurred.'); $ 
              trace_write; 
               error := true;                table_record.c := ' ';               END; { read error }          END; { not eof }        IF eof(table) THEN eof_flag := true; { eof after read? } 
    UNTIL eof_flag OR 
 #            (table_record.c[1] <> '*'); { comment lines start w/ "*" } #         read_ipl_file_table := table_record;        END; { read_ipl_file_table }         FUNCTION get_ipl_file_name(pc_name: pc_logical_name_type;                             VAR error: boolean; !                           VAR busy: boolean): file_path_name_type; !     $  { gets the ipl_file_name for a node from the ipl file table file given $    the the pc_logical_name }       VAR   table: ipl_file_table_type;          hold_record: ipl_file_table_record_type;          test_record: ipl_file_table_record_type;  
        eof_flag: boolean; 
        match: boolean;          pos: shortint;         BEGIN  
     error := false; 
     open_ipl_file_table(table,error,busy);       IF NOT (busy OR error) THEN         BEGIN           match := false;           hold_record.default_use := '0';              REPEAT  "           test_record := read_ipl_file_table(table,error,eof_flag); "            IF NOT error THEN WITH test_record DO  	             BEGIN 	                IF pc_name = pc_logical_name THEN                   BEGIN                    match := true;                    IF hold_record.default_use <> '1' THEN                      hold_record := test_record                    ELSE  
                     BEGIN 
                        IF default_use = '1' THEN                           hold_record := test_record;                      END; 
                 END; 
             END;          UNTIL eof_flag OR error;               IF NOT (error OR busy) THEN             IF NOT match THEN  	             BEGIN 	               error := true;                 trace_str := 'no IPL file entry for name:'; 
               trace_write; 
                strwrite(trace_str,1,trace_pos,' "',pc_name);                 trace_str := strrtrim(trace_str) + '"'; 
               trace_write; 
             END;        END;       get_ipl_file_name := hold_record.IPL_file_name;  	     close(table); 	   END; { get_ipl_file_name }      !FUNCTION get_pc_name(net_lu: shortint; LAN_addr: LAN_address_type; !                      VAR error: boolean;                       VAR busy: boolean): pc_logical_name_type;     $  { gets the pc_logical_name of a node from the ipl file table file given $     the network lu and LAN address }       VAR   table: ipl_file_table_type;          hold_record: ipl_file_table_record_type;          test_record: ipl_file_table_record_type;  
        eof_flag: boolean; 
        match: boolean;          nlu: shortint;          pos: shortint;  
        lu_str: string[3]; 
        BEGIN      open_ipl_file_table(table,error,busy);       IF NOT (busy OR error) THEN         BEGIN           match := false;           hold_record.default_use := '0';           hold_record.pc_logical_name := ' ';              REPEAT  "           test_record := read_ipl_file_table(table,error,eof_flag); "            IF NOT error THEN WITH test_record DO  	             BEGIN 	                lu_str := '';                 strmove(3,network_lu,1,lu_str,1);                strread(lu_str,1,pos,nlu);                IF net_lu = nlu THEN                   BEGIN                    IF LAN_address = LAN_addr THEN  
                     BEGIN 
                       match := true;                        IF hold_record.default_use <> '1' THEN                          hold_record := test_record 
                       ELSE 
                          BEGIN                             IF default_use = '1' THEN                               hold_record := test_record;                          END;                      END; 
                 END; 
             END;          UNTIL eof_flag OR error;               IF NOT (busy OR error) THEN             IF NOT match THEN  	             BEGIN 	               error := true;                 strwrite(trace_str,1,trace_pos,                  'no IPL file entry for LU ',net_lu:3,' address ',                 LAN_addr); 
               trace_write; 
             END;        END;       get_pc_name := hold_record.pc_logical_name;  	     close(table); 	    END;  { get_pc_name }     &FUNCTION get_LAN_address(pc_name: pc_logical_name_type; VAR net_lu: shortint; &                          VAR error: boolean;                           VAR busy: boolean): LAN_address_type;     $  { gets the LAN address and network lu of a node from the ipl file table $     file given the pc_logical_name }       VAR   table: ipl_file_table_type;          hold_record: ipl_file_table_record_type;          test_record: ipl_file_table_record_type;  
        eof_flag: boolean; 
        match: boolean;          pos: shortint;  
        lu_str: string[3]; 
        name_str: string[32];         BEGIN       hold_record.LAN_address := ' ';      { cover error exit }      open_ipl_file_table(table,error,busy);       IF NOT (busy OR error) THEN         BEGIN           match := false;           hold_record.default_use := '0';          hold_record.network_lu := '  0';               name_str := '';  %         strmove(17,pc_name,1,name_str,1);          { for error printing } %          name_str := strrtrim(strltrim(name_str));              REPEAT  "           test_record := read_ipl_file_table(table,error,eof_flag); "            IF NOT error THEN WITH test_record DO  	             BEGIN 	                IF pc_logical_name = pc_name THEN                   BEGIN                    match := true;                    IF hold_record.default_use <> '1' THEN                      hold_record := test_record                    ELSE  
                     BEGIN 
                        IF default_use = '1' THEN                           hold_record := test_record;                      END; 
                 END; 
             END;          UNTIL eof_flag OR error;               IF NOT (busy OR error) THEN             IF NOT match THEN  	             BEGIN 	               error := true;                 strwrite(trace_str,1,trace_pos,                'no IPL file entry for pc_logical_name '); 
               trace_write; 
               trace_str := name_str; 
               trace_write; 
              END            ELSE  	             BEGIN 	                lu_str := '';                 strmove(3,hold_record.network_lu,1,lu_str,1); 	               TRY; 	                  strread(lu_str,1,pos,net_lu);                 IF recover THEN                   BEGIN                    error := true;                    net_lu := 0;                     strwrite(trace_str,1,trace_pos,name_str);                    trace_write;                    trace_str := $                    'IPL file entry does not contain a valid network lu'; $                   trace_write; 
                 END; 
             END;        END;       get_LAN_address := hold_record.LAN_address;  	     close(table); 	
   END; { get_LAN_address } 
     FUNCTION get_no_LAN_address(pc_name: pc_logical_name_type;                              pc_no: pc_logical_no_type;                           VAR net_lu: shortint;                           VAR error: boolean;                           VAR busy: boolean): LAN_address_type;     $  { gets the LAN address and network lu of a node from the ipl file table $     file given the pc_logical_name }       VAR   table: ipl_file_table_type;          hold_record: ipl_file_table_record_type;          test_record: ipl_file_table_record_type;  
        eof_flag: boolean; 
        match: boolean;          pos: shortint;  
        lu_str: string[3]; 
        name_str: string[32];         BEGIN       hold_record.LAN_address := ' ';      { cover error exit }      open_ipl_file_table(table,error,busy);       IF NOT (busy OR error) THEN         BEGIN           match := false;           hold_record.default_use := '0';          hold_record.network_lu := '  0';               name_str := '';  %         strmove(17,pc_name,1,name_str,1);          { for error printing } %          name_str := strrtrim(strltrim(name_str));              REPEAT  "           test_record := read_ipl_file_table(table,error,eof_flag); "            IF NOT error THEN WITH test_record DO  	             BEGIN 	&               IF (pc_logical_name = pc_name) or (pc_logical_no = pc_no) THEN &                  BEGIN                     pc_name := pc_logical_name;                     pc_no := pc_logical_no;                    match := true;                    IF hold_record.default_use <> '1' THEN                      hold_record := test_record                    ELSE  
                     BEGIN 
                        IF default_use = '1' THEN                           hold_record := test_record;                      END; 
                 END; 
             END;          UNTIL eof_flag OR error;               IF NOT (busy OR error) THEN             IF NOT match THEN  	             BEGIN 	               error := true;                 strwrite(trace_str,1,trace_pos,                'no IPL file entry for pc_logical_name '); 
               trace_write; 
               trace_str := name_str; 
               trace_write; 
              END            ELSE  	             BEGIN 	                lu_str := '';                 strmove(3,hold_record.network_lu,1,lu_str,1); 	               TRY; 	                  strread(lu_str,1,pos,net_lu);                 IF recover THEN                   BEGIN                    error := true;                    net_lu := 0;                     strwrite(trace_str,1,trace_pos,name_str);                    trace_write;                    trace_str := $                    'IPL file entry does not contain a valid network lu'; $                   trace_write; 
                 END; 
             END;        END;      get_no_LAN_address := hold_record.LAN_address;  	     close(table); 	
   END; { get_LAN_address } 
     END.     