"$cds on $ $range off$ $DEBUG ON $ $HEAP_DISPOSE OFF$ $TRACE_BACK OFF$ " $HEAP 1$ $HEAPPARMS OFF$ $WIDTH 150$ $tables on$  $TITLE 'RMVCP VCP Intereactive  '$  $SUBTITLE 'Session Initiation   '$      $PASCAL ',4,80 92078-16110 REV.5020 <900501.1529>'  {}  	{    NAME:   RMVCP 	{    SOURCE: 92078-18110   {    RELOC:  92078-16110 {    PGMR:   mh  {   !{ **************************************************************** ! !{ * (C) COPYRIGHT HEWLETT-PACKARD COMPANY 1989.  ALL RIGHTS      * ! !{ * RESERVED.  NO PART OF THIS PROGRAM MAY BE PHOTOCOPIED,       * ! !{ * REPRODUCED OR TRANSLATED TO ANOTHER PROGRAM LANGUAGE WITHOUT * ! !{ * THE PRIOR WRITTEN CONSENT OF HEWLETT-PACKARD COMPANY.        * ! !{ **************************************************************** ! {}  PROGRAM RMVCP;      #{ This program initiates interactive VCP sessions with the VCP monitor #  program a   }     $SUBTITLE 'tables Access Routines'$  $AUTOPAGE$     MODULE vcpmt_ipl_table;      { These routines handle IPL Table access for    Virtual Control Panel Monitor programs        These routines access the IPL Table File       }      IMPORT $SEARCH 'TRY_RECOVER.REL'$ try_recover,         $SEARCH 'vcp_DECLS.REL'$ vcp_decls,         $SEARCH 'TEST_PROCS.REL'$ test_procs,         $SEARCH 'VCPMT_TRACE.REL'$ vcpmt_trace;              EXPORT         PROCEDURE open_ipl_file_table(VAR table: ipl_file_table_type;                               VAR error: boolean;                               VAR busy: boolean);          FUNCTION read_ipl_file_table(VAR table: ipl_file_table_type;                         VAR error: boolean; %                        VAR eof_flag: boolean): ipl_file_table_record_type; %    FUNCTION get_ipl_file_name(pc_name: pc_logical_name_type;                             VAR error: boolean; !                           VAR busy: boolean): file_path_name_type; !    $FUNCTION get_pc_name(var net_lu: shortint;var LAN_addr: LAN_address_type; $                      VAR error: boolean;                       VAR busy: boolean): pc_logical_name_type;     FUNCTION get_LAN_address(var pc_name: pc_logical_name_type;                           VAR net_lu: shortint;                           VAR error: boolean;                           VAR busy: boolean): LAN_address_type;      FUNCTION get_no_LAN_address(var pc_name: pc_logical_name_type;                          var pc_no: pc_logical_no_type;                           VAR net_lu: shortint;                           VAR error: boolean;                           VAR busy: boolean): LAN_address_type;     IMPLEMENT          $INCLUDE 'vcp_EXTERNALS.pasi'$         PROCEDURE open_ipl_file_table(VAR table: ipl_file_table_type;                               VAR error: boolean;                               VAR busy: boolean);       { Opens the file whose name is in the global constant     ipl_file_table_name which should be an ipl file table file.     Returns the passed file variable opened. If an open  &    error is because the file is already open, returns busy true. If another &!    error occurs, error is set and the error message is returned in !    trace_str }       BEGIN 	    error := false; 	 	    busy := false; 	     TRY;        reset(table,ipl_file_table_name,'SHARED');     IF recover THEN { file open error }       BEGIN          IF (recover_block^.error_type = fmp) AND             (recover_block^.error_number = -8) THEN                {file is in use, may want to try later }              busy := true              ELSE               BEGIN { other error }             strwrite(trace_str,1,trace_pos,              'unable to open IPL table file "',             ipl_file_table_name,'"');              trace_write;             strwrite(trace_str,1,trace_pos,             'a Pascal error type ',recover_block^.error_type, #            ' number ',recover_block^.error_number:1,' has occurred.'); #             trace_write;  
            error := true; 
           END;           END; { error processing }        END; { open_ipl_file_table }      FUNCTION read_ipl_file_table(VAR table: ipl_file_table_type;                         VAR error: boolean; %                        VAR eof_flag: boolean): ipl_file_table_record_type; %       { serialy reads one record from an open ipl file table file and   %  handles the appropriate errors, error messages are returned in the trace %   string }       VAR   table_record: ipl_file_table_record_type;       BEGIN 	    error := false; 	     eof_flag := false;      REPEAT        IF NOT eof(table) THEN         BEGIN            TRY;             read(table,table_record);           IF recover THEN  { read error }             BEGIN               strwrite(trace_str,1,trace_pos,               'while reading the IPL table file "',               ipl_file_table_name,'"');  
              trace_write; 
              strwrite(trace_str,1,trace_pos,               'a Pascal error type ',recover_block^.error_type, $              ' number ',recover_block^.error_number:1,' has occurred.'); $ 
              trace_write; 
               error := true;                table_record.c := ' ';               END; { read error }          END; { not eof }        IF eof(table) THEN eof_flag := true; { eof after read? } 
    UNTIL eof_flag OR 
 #            (table_record.c[1] <> '*'); { comment lines start w/ "*" } #         read_ipl_file_table := table_record;        END; { read_ipl_file_table }         FUNCTION get_ipl_file_name(pc_name: pc_logical_name_type;                             VAR error: boolean; !                           VAR busy: boolean): file_path_name_type; !     $  { gets the ipl_file_name for a node from the ipl file table file given $    the the pc_logical_name }       VAR   table: ipl_file_table_type;          hold_record: ipl_file_table_record_type;          test_record: ipl_file_table_record_type;  
        eof_flag: boolean; 
        match: boolean;          pos: shortint;         BEGIN  
     error := false; 
     open_ipl_file_table(table,error,busy);       IF NOT (busy OR error) THEN         BEGIN           match := false;           hold_record.default_use := '0';              REPEAT  "           test_record := read_ipl_file_table(table,error,eof_flag); "            IF NOT error THEN WITH test_record DO  	             BEGIN 	                IF pc_name = pc_logical_name THEN                   BEGIN                    match := true;                    IF hold_record.default_use <> '1' THEN                      hold_record := test_record                    ELSE  
                     BEGIN 
                        IF default_use = '1' THEN                           hold_record := test_record;                      END; 
                 END; 
             END;          UNTIL eof_flag OR error;               IF NOT (error OR busy) THEN             IF NOT match THEN  	             BEGIN 	               error := true;                 trace_str := 'no IPL file entry for name:'; 
               trace_write; 
                strwrite(trace_str,1,trace_pos,' "',pc_name);                 trace_str := strrtrim(trace_str) + '"'; 
               trace_write; 
             END;        END;       get_ipl_file_name := hold_record.IPL_file_name;  	     close(table); 	   END; { get_ipl_file_name }      FUNCTION get_pc_name(var net_lu: shortint;                       VAR LAN_addr: LAN_address_type;                       VAR error: boolean;                       VAR busy: boolean): pc_logical_name_type;     $  { gets the pc_logical_name of a node from the ipl file table file given $     the network lu and LAN address }       VAR   table: ipl_file_table_type;          hold_record: ipl_file_table_record_type;          test_record: ipl_file_table_record_type;  
        eof_flag: boolean; 
        match: boolean;          nlu: shortint;          pos: shortint;  
        lu_str: string[3]; 
        BEGIN      open_ipl_file_table(table,error,busy);       IF NOT (busy OR error) THEN         BEGIN           match := false;           hold_record.default_use := '0';           hold_record.pc_logical_name := ' ';              REPEAT  "           test_record := read_ipl_file_table(table,error,eof_flag); "            IF NOT error THEN WITH test_record DO  	             BEGIN 	                lu_str := '';                 strmove(3,network_lu,1,lu_str,1);                strread(lu_str,1,pos,nlu);                IF net_lu = nlu THEN                   BEGIN                    IF LAN_address = LAN_addr THEN  
                     BEGIN 
                       match := true;                        IF hold_record.default_use <> '1' THEN                          hold_record := test_record 
                       ELSE 
                          BEGIN                             IF default_use = '1' THEN                               hold_record := test_record;                          END;                      END; 
                 END; 
             END;          UNTIL eof_flag OR error;               IF NOT (busy OR error) THEN             IF NOT match THEN  	             BEGIN 	               error := true;                 strwrite(trace_str,1,trace_pos,                  'no IPL file entry for LU ',net_lu:3,' address ',                 LAN_addr); 
               trace_write; 
             END;        END;       get_pc_name := hold_record.pc_logical_name;  	     close(table); 	    END;  { get_pc_name }     FUNCTION get_LAN_address(var pc_name: pc_logical_name_type;                           VAR net_lu: shortint;                           VAR error: boolean;                           VAR busy: boolean): LAN_address_type;     $  { gets the LAN address and network lu of a node from the ipl file table $     file given the pc_logical_name }       VAR   table: ipl_file_table_type;          hold_record: ipl_file_table_record_type;          test_record: ipl_file_table_record_type;  
        eof_flag: boolean; 
        match: boolean;          pos: shortint;  
        lu_str: string[3]; 
        name_str: string[32];         BEGIN       hold_record.LAN_address := ' ';      { cover error exit }      open_ipl_file_table(table,error,busy);       IF NOT (busy OR error) THEN         BEGIN           match := false;           hold_record.default_use := '0';          hold_record.network_lu := '  0';               name_str := '';  %         strmove(17,pc_name,1,name_str,1);          { for error printing } %          name_str := strrtrim(strltrim(name_str));              REPEAT  "           test_record := read_ipl_file_table(table,error,eof_flag); "            IF NOT error THEN WITH test_record DO  	             BEGIN 	                IF pc_logical_name = pc_name THEN                   BEGIN                    match := true;                    IF hold_record.default_use <> '1' THEN                      hold_record := test_record                    ELSE  
                     BEGIN 
                        IF default_use = '1' THEN                           hold_record := test_record;                      END; 
                 END; 
             END;          UNTIL eof_flag OR error;               IF NOT (busy OR error) THEN             IF NOT match THEN  	             BEGIN 	               error := true;                 strwrite(trace_str,1,trace_pos,                'no IPL file entry for pc_logical_name '); 
               trace_write; 
               trace_str := name_str; 
               trace_write; 
              END            ELSE  	             BEGIN 	                lu_str := '';                 strmove(3,hold_record.network_lu,1,lu_str,1); 	               TRY; 	                  strread(lu_str,1,pos,net_lu);                 IF recover THEN                   BEGIN                    error := true;                    net_lu := 0;                     strwrite(trace_str,1,trace_pos,name_str);                    trace_write;                    trace_str := $                    'IPL file entry does not contain a valid network lu'; $                   trace_write; 
                 END; 
             END;        END;       get_LAN_address := hold_record.LAN_address;  	     close(table); 	
   END; { get_LAN_address } 
     FUNCTION get_no_LAN_address(var pc_name: pc_logical_name_type;                          var pc_no: pc_logical_no_type;                           VAR net_lu: shortint;                           VAR error: boolean;                           VAR busy: boolean): LAN_address_type;     $  { gets the LAN address and network lu of a node from the ipl file table $     file given the pc_logical_name }       VAR   table: ipl_file_table_type;          hold_record: ipl_file_table_record_type;          test_record: ipl_file_table_record_type;  
        eof_flag: boolean; 
        match: boolean;          pos: shortint;  
        lu_str: string[3]; 
        name_str: string[32];         BEGIN       hold_record.LAN_address := ' ';      { cover error exit }      open_ipl_file_table(table,error,busy);       IF NOT (busy OR error) THEN         BEGIN           match := false;           hold_record.default_use := '0';          hold_record.network_lu := '  0';               name_str := '';  %         strmove(17,pc_name,1,name_str,1);          { for error printing } %          name_str := strrtrim(strltrim(name_str));              REPEAT  "           test_record := read_ipl_file_table(table,error,eof_flag); "            IF NOT error THEN WITH test_record DO  	             BEGIN 	&               IF (pc_logical_name = pc_name) or (pc_logical_no = pc_no) THEN &                  BEGIN                     if not match then  
                     begin 
                       match := true;                         hold_record := test_record;                      end;                     IF hold_record.default_use = '1' THEN  
                     BEGIN 
                        IF default_use = '1' THEN                           hold_record := test_record;                      END; 
                 END; 
             END;          UNTIL eof_flag ;               IF NOT (busy OR error) THEN             IF NOT match THEN  	             BEGIN 	               error := true;                 strwrite(trace_str,1,trace_pos,                'no IPL file entry for pc_logical_name '); 
               trace_write; 
               trace_str := name_str; 
               trace_write; 
              END            ELSE  	             BEGIN 	                lu_str := '';                 strmove(3,hold_record.network_lu,1,lu_str,1); 	               TRY; 	                  strread(lu_str,1,pos,net_lu);                 IF recover THEN                   BEGIN                    error := true;                    net_lu := 0;                     strwrite(trace_str,1,trace_pos,name_str);                    trace_write;                    trace_str := $                    'IPL file entry does not contain a valid network lu'; $                   trace_write;  
                 END 
	               else 	                  begin                     pc_name := hold_record.pc_logical_name;                     pc_no := hold_record.pc_logical_no;  
                 end 
             END;        END;      get_no_LAN_address := hold_record.LAN_address;  	     close(table); 	
   END; { get_LAN_address } 
     END;     IMPORT VCPMT_ipl_table;  IMPORT $SEARCH 'TRY_RECOVER.REL'$ try_recover;  IMPORT $SEARCH 'VCP_DECLS.REL'$ vcp_decls;  IMPORT $SEARCH 'TEST_PROCS.REL'$ test_procs;  IMPORT $SEARCH 'VCPMT_TRACE.REL'$ VCPMT_trace;  {IMPORT $SEARCH 'VCPMT_IPL_T.REL'$ VCPMT_ipl_table;}          VAR   dummy: shortint;        dummyuv: completion_data_type;  
      trans_log: shortint; 
 
      byte_pos : shortint; 
     
    { standard I/O } 
           user_lu: shortint;       io_str: string[80];        xstat: parm_array;       status: shortint;        stat_buf: octal_numb_buffer;        status_error: boolean; 
      code: shortint; 
     &    { variables to recover the LAN address and lu from the pc_logical_name } &           pc_name: pc_logical_name_type;        pc_no: pc_logical_no_type;       LAN_addr: LAN_address_type;       LAN_lu: shortint;       ipl_error: boolean;        ipl_busy: boolean;       name_done: boolean;       ipl_busy_retry: shortint;          { commmunications with VCPMT }            VCPMT_class: shortint;       flag: completion_data_type;        cntwd: cntwd_type;       buffer: interactive_init;       RMVCP_break_flag: completion_data_type;        RMVCP_class: shortint;      $PAGE$  $INCLUDE 'vcp_EXTERNALS.pasi'$ $AUTOPAGE ON$  $PAGE$          BEGIN  { RMVCP }        { Get user lu number of error messages }       io_str := '';  
  dummy := loglu(user_lu); 
  strwrite(io_str,1,dummy,user_lu);   rewrite(output,io_str);         { initialize trace/error reporting for errors to the user lu }         trace_control(0,'',0,true,user_lu,exec_error);       { recover run string and print usage if no run string }       io_str := '';    trans_log := get_run_string(1,io_str);       IF trans_log <= 0 THEN  { no run string }     BEGIN        writeln(output);        writeln(output);       writeln(output,' Usage: RMVCP <client>');        writeln(output); #      writeln(output,'    where client is the node name or number of'); #%      writeln(output,'    the remote host with which you wish to conduct'); %&      writeln(output,'    an interactive Virtual Control Panel session, as'); &"      writeln(output,'    given in file "/files802/ipl_table.txt".'); "       writeln(output);  	      escape(nil); 	     END;       { using the pc_name, get the LAN_address and LAN_lu }        pc_name := ' ';    { blank fills the PAC }    pc_no   := ' ';    { blank fills the PAC }   IF trans_log > pc_logical_name_max THEN     trans_log := pc_logical_name_max;    setstrlen(io_str,trans_log); 
  name_done := false; 
  for byte_pos:=1 to trans_log do !   if (not (io_str[byte_pos] in ['0'..'9'])) or (byte_pos > 7) then !    begin      strmove(trans_log,io_str,1,pc_name,1);      name_done := true;      end;    if not name_done then strread(io_str,1,trans_log,pc_no);  %  LAN_addr := get_no_LAN_address(pc_name,pc_no,LAN_lu,ipl_error,ipl_busy); %    	  IF ipl_error THEN 	    BEGIN       ipl_error := trace_post(-12);  	      escape(NIL); 	     END;      	  IF ipl_busy THEN 	    BEGIN        writeln(output);        writeln(output,'  RMVCP> ',ipl_file_table_name); "      writeln(output,'          is currently open, try again later'); "       writeln(output);  	      escape(NIL); 	     END;        { Using the LAN_lu, get the class number for VCPMT }          exec_error := false;     cntwd[0] := LAN_lu;     cntwd[1] := get_class_number;  #      {changed to VCP program code because of changes to 802.3 driver} #	      {8/2/85 JWHS} 	 $    io_control(io_control_code + no_abort,cntwd,vcp_program_code,0,0,0); $    BEGIN        error_return(error_a_reg,error_b_reg);        exec_error := test_exec_error;      END;     a_b_register(status,dummy);      return_parms(xstat);      VCPMT_class := xstat[3];      	  { check errors } 	        status_error := binand(status,error_bit_mask) <> 0;         IF exec_error OR status_error or ( VCPMT_class = 0 ) THEN       BEGIN          writeln(output);         writeln(output,  &        ' RMVCP> Error while attempting to retrieve VCPMT''s class number'); &        writeln(output,         '        from network lu ',LAN_lu:1);      
        IF exec_error THEN 
          writeln(output,  $        '        an RTE error ',error_a_reg,error_b_reg,' has occurred') $             ELSE           BEGIN              status := binand(status,error_code_mask) div 16;              IF (status = octal('10')) or ( VCPMT_class = 0 ) THEN                writeln(output,          '        VCPMT class not initialized on network lu')              ELSE 	              BEGIN 	                octal_cnvrt(status,stat_buf);                 writeln(output, %        '        a driver error ',stat_buf[5],stat_buf[6],'B has occured'); % 	              END; 	           END;  
        escape(NIL); 
       END;      ! { get own class number to receive termination notice from VCPMT } !    
    RMVCP_class := 0; 
    code := 1 + no_wait_clrq + no_abort_clrq;      exec_error := false;      class_request(code,RMVCP_class);     BEGIN        error_return(error_a_reg,error_b_reg);        exec_error := test_exec_error;      END;     a_b_register(status,dummy);          IF exec_error OR (status <> 0) THEN  { clrq failed }           BEGIN          writeln(output); $        writeln(output,' RMVCP> Error, unable to allocate class number'); $     
        IF exec_error THEN 
          writeln(output,              '        an RTE error ',error_a_reg,error_b_reg, 
            ' has occured') 
             ELSE           writeln(output,              '        no class numbers available');          writeln(output);  
        escape(NIL); 
       END;      !  { If we survived to here, package up the information and pass it !     to VCPMT }          buffer.pc_logical_name := pc_name;     buffer.LAN_address := LAN_addr;     io_str := '';      strwrite(io_str,1,dummy,LAN_lu:4);      strread(io_str,1,dummy,buffer.network_lu); 	    flag.word := 0; 	    flag.comp_type := entvc_init;          exec_error := false;     class_io_init(class_write_read_code + no_abort,                   0,buffer,-interactive_init_record_length,                    user_lu,RMVCP_class,VCPMT_class,flag);     BEGIN        error_return(error_a_reg,error_b_reg);        exec_error := test_exec_error;      END;          IF exec_error THEN           BEGIN          writeln(output);         writeln(output,  '      ' RMVCP> Error while attempting to send session init request to VCPMT'); '        writeln(output, #      '        an RTE error ',error_a_reg,error_b_reg,' has occurred'); # 
        escape(NIL); 
       END;        { get session number and break code from VCPMT }          exec_error := false;      class_get_no_buff(class_get_code + no_abort,                        RMVCP_class + save_class_number,  !                      dummy,0,dummy,dummy,dummy,RMVCP_break_flag); !    BEGIN        error_return(error_a_reg,error_b_reg);        exec_error := test_exec_error;      END;          IF exec_error THEN           BEGIN          writeln(output);         writeln(output,  $      ' RMVCP> Error getting session number and break flag from VCPMT'); $        writeln(output, #      '        an RTE error ',error_a_reg,error_b_reg,' has occurred'); # 
        escape(NIL); 
       END;         { loop here testing for break and a final message from VCPMT }           REPEAT          { time schedule self for two seconds }           time_schedule(12,0,2,0,-2);         { check break and send break to VCPMT }           IF ifbrk < 0 THEN         BEGIN                exec_error := false;            class_io_no_buff(class_write_read_code + no_abort,  "                        0,dummy,0,0,0,VCPMT_class,RMVCP_break_flag); "          BEGIN              error_return(error_a_reg,error_b_reg);              exec_error := test_exec_error;            END;                IF exec_error THEN                 BEGIN                writeln(output);               writeln(output,        ' RMVCP> Error while attempting to send a break to VCPMT');                writeln(output, #      '        an RTE error ',error_a_reg,error_b_reg,' has occurred'); # 
              escape(NIL); 
             END;             END; { IF ifbrk }     #      { check for shut down message from VCPMT ( ANY class request will #         be interpreted as the shut down message) }      
      exec_error := false; 
       class_get_no_buff(class_get_code + no_abort,  $                        RMVCP_class + save_class_number + no_wait_class, $                        dummy,0,dummy,dummy,dummy,dummyuv);       BEGIN          error_return(error_a_reg,error_b_reg);          exec_error := test_exec_error;        END;       a_b_register(status,dummy);            IF exec_error THEN             BEGIN  
          writeln(output); 
          writeln(output,  %        ' RMVCP> Error attempting to receive the termination from VCPMT'); %          writeln(output, $        '        an RTE error ',error_a_reg,error_b_reg,' has occurred'); $           escape(NIL);          END;          UNTIL status >= 0;        { Let RTE clean up the class buffer and number }      END.     