 $PASCAL '24398-16062 REV.5020 <900302.0902>'      !(***************************************************************** ! !*                                                                * ! !*   (C) COPYRIGHT HEWLETT-PACKARD COMPANY 1984 - 1990 ALL RIGHTS * ! !*   RESERVED.  NO PART OF THIS PROGRAM MAY BE PHOTOCOPIED,       * ! !*   REPRODUCED, OR TRANSLATED TO ANOTHER PROGRAMMING LANGUAGE    * ! !*   WITHOUT THE PRIOR WRITTEN CONSENT OF THE HEWLETT-PACKARD     * ! !*   COMPANY.                                                     * ! !*                                                                * ! !****************************************************************** ! *  *     NAME:  EXER  *   SOURCE:  24398-18062 replacing rte-6 version 91711-18285  *    RELOC:  24398-16062 replacing rte-6 version 91711-16285 *     PGMR:  J.R.C.(794x)  *  #* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * #	*  Revision History 	 *   *   DATE       PROGRAMER                   PURPOSE %* --------    -------------    -------------------------------------------- % *  !* 10/06/84    Jeff Conrad      Modified to allow user interface, so !"*                              that this can be used on line (but not "#*                              done at this time).  Modified to support # "*                              794x line of disc drives.  Compressed "#*                              diagnostics to allow code to fit in 32K. # *   * 02/15/85     JC              Minor repairs  *  !* 12/05/85     Blaine Lang     Modified to support 7907 disc drive. !%*                              Modified listlu procedure to list hpib addr. %*                              Added change lu command. *                              and a few other small changes.  *   $*  07/15/85    Dave Groves     Major changes.  Enhanced support of 7907. $ %*              DMD             Restructured output format for all logs and % %*                              tables.  Added external function FIND_LU to %%*                              return bus lu if passed the device lu.  This %!*                              is used for the AMIGO CLEAR routine. !&*                              Fixed bugs in REV command and other minor bugs & *  &*  07/30/85    Rich            Made minor changes so that one version of EXER & !*                Van Gaasbeck  would work on both RTE-6 and RTE-A. ! *   %*  02/07/86    Dave Groves     Created a son process (EXER1) to handle the %!*              DMD             routines that would not fit in EXER. ! *   %*                              Added support for EAGLE and BFD Disc Cache. % *  %*                              Added routines to release the ID segment for % %*                              the son process, to RP the son, and to pass %*                              parms and a buffer to the son.  *  &*                              Added capability to print the physical address & *                              for the 793X/791X fault logs.  *  $*  04/14/86    Dave Groves     Moved ERROR_LOG and FAULT LOG from EXER to $#*              DMD             EXER1 to allow RTE-V version to compile. ##*                              EXER had grown to big.  Also removed the # %*                              INPUT/OUTPUT specification from the PROGRAM % $*                              statement in EXER1.  Pascal was trying to $%*                              open invalid input/output files depending on % #*                              what data was passed in the run string. #$*                              I then had to add the output file variable $ *                              to all of the WRITE statements.  *   $*  06/03/86    Frank Root      Completed modifications for 795X devices. $ %*  08/01/86    DMD             Added CE MODE command to protect users from %&*                              destructive commands.  Changed command prompt. & !*                              Added partial command capabilities. !#*                              Modified zfltlog to send buffer multiple # '*                              times if necessary.  Changed multiple character '#*                              prompts to single where possible.  Added # %*                              getcode and more_lines to help break up the % $*                              output in various places.  Added ifbrk to $%*                              ro ert.  Does not seem to be working.  Added % &*                              procedure main to shield long procedure names &&*                              from linker.  Older versions recognize no more &&*                              than 5 characters causing non-unique problems. & %*                              Deleted PRINTER command.  Expanded function %$*                              of TERM.  Added INPUT and OUTPUT commands. $ %*                              Program now allows redirection of input and %#*                              output both in the run string and during #*                              execution.  #*  01/16/87    Frank Root      Removed main procedure and changed some #$*                              procedure names to ensure uniqueness.  The $ $*                              main procedure approach did not work with $ *                              the 4B loader at DSD.  *   %*  02-27-87    Leslee Doner    Changed all string functions to characters. %	*               DMD 	 *  03-03-87    Leslee Doner    Moved putility in ZSERVO. 	*               DMD 	 $*  03-04-87    Leslee Doner    The screen message 'UTILITY' and 'UTILITY $ $*               DMD            COMPLETED' were not in the right place on $#*                              the screen. Modified Putility, Good_end, #*                              Bad_end, and User_end.  *  "*  03-05-87    Leslee Doner    Found infinite loop in ZSEEK and added " $*               DMD            Time_msg to it. Added Time_msg to ZXXERT. $ *  #*  03-06-87    Leslee Doner    Removed procedure Writelog and procedure #!*               DMD            Zwrite_cache_control. Added commands ! "*                              Readcacheon and Readcacheoff. Rewrote "%*                              procedure Zcache_control. Zcache_control now %&*                              performs the following utilities, Readcacheon, &$*                              Readcacheoff, Writecacheon, Writecacheoff, $#*                              Cacheon and Cacheoff and error checking. # *   #*  03-24-87    Leslee Doner    Transfered Cachetablearea to EXER1 from # !*               DMD            Cache_stats instead of extablearea. ! *  #*  04-21-87    Leslee Doner    Added read revision to Change Lu to keep # %*               DMD            for utilities to check revision of firmware % %*                              if necessary. RFSECT now checks 791X drives % $*                              firmware. See ZRFSECT, ZCHANGE_LU & ZREV. $ *  *  05-22-87    Leslee Doner    Removed Zwritelog.  *  %*  06-12-87    Leslee Doner    Fixed bug in ZXXERT. Made some modifications %%*                              to it. See ZXXERT. Changed ZFRMAT to default % %*                              to interleave of 1 for Eagle. Added warning % $*                              message about interleaving. Added code to $$*                              Zdatalog to improve error count reporting. $ *   &*  06-17-87    Leslee Doner    Removed 795X's from ZAMCLEAR and added 795X's &*                              to SELECTDC (SDClear command).  *   "*  06-18-87    Leslee Doner    Checking for Fbus LU = 0 in ZAMCLEAR. " *  &*  07-08-87    Leslee Doner    Removed parity error bit from error rate tests &%*                              on Eagles. Eagles now have a diag of 0 or 1. % *  %*  09-02-87    Leslee Doner    Made enhancements to ZSPAR for new 795XB and % %*                              796XB drives such as forced sparing, sector %#*                              or track spare reporting, improved error #  *                              testing and informative messages.   *   %*  10-27-87    Leslee Doner    Added option to ZRDTBLS for 795XB and 796XB % %*                              drives to read all sector headers to report %*                              any spare sectors.  *   &*  11-16-87    Leslee Doner    Added function WRONG to check for block sizes & &*                              as valid CS80 devices. Modified ZCHANGE_LU to & *                              make the call to WRONG.  *   "*  11-30-87    Leslee Doner    Added messages to ZINPUT and ZOUTPUT. " *  $*  01-27-88    Leslee Doner    Moved ZCACHE_CONTROL to EXER1. Made mod to $ *                              PRNTSTATUS.  *   *  10-19-88    Leslee Doner    Added maximum offset. 7911/12 = 7.  *                              7914 = 4. 793X = 63.  *  #*  08-19-89    Leslee Doner    Condensed Good_end, Bad_end and User_end # %*                              into Ender. Removed some code from Zcache_. % *  $*  08-20-89    Leslee Doner    Removed Zeventlog code and Addr_print code $ $*                              totally. Moved Zservo code to son, Exer1. $ *   %*  08-23-89    Leslee Doner    Reduced amount of output during the ERT log % #*                              and the Run log if there are no errors. # "*                              See Zdatalog. Removed compiler option " *                              Run_string 364.  *   $*  09-01-89    Leslee Doner    Moved Zlogcache code to Exer1. Added Pas. $ %*                              parameter function. Made mods to Zcache_lu, % #*                              Readnum and the main to catch the third # %*                              parameter in the run string and to check it %%*                              for a valid LU #. See Zcache_lu and Readnum. % *   *  09-11-89    Leslee Doner    Moved Zdatalog to son, Exer1.  *  $*  10-05-89    Leslee Doner    Added support for new Blitz drives, C220X. $%*                              Renamed Zxxert to Ert, Zsldvclr to Selectdc. %*                              See individual commands.  *  "*  10-12-89    Leslee Doner    Added break fix to Zchange_lu. See it. " *   #*   2-05-90    Leslee Doner    Removed Unlocklu from describe that was #*                              causing an ABE Abort on rte-6.  *   &*   2-07-90    Leslee Doner    Added third parameter to Locklu. Made changes &&*                              to locklu in Zspar. Diag is no longer ce mode. &&***************************************************************************** & *   *        LINK   :  link exer.lod  *   '* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *) '     $cds off  $HEAPPARMS OFF,PARTIAL_EVAL OFF,RECURSIVE OFF$  $HEAP 0,IDSIZE 24,RANGE OFF$  	$HEAP_DISPOSE OFF$ 	    
PROGRAM EXER(INPUT,OUTPUT); 
     label 0;     	$ include '[TYPE' $ 	    const   rev_code = 'Rev. 5020  2-7-90';  
  noabort  = -32768; 
    VAR    f              : text;   IOBUF          : IOBUFTYPE;    INBUF          : packed array [1..MAXICHAR] OF CHAR;  
  OUTBUF         : char64; 
   lubuf          : packed array [1..63] OF LUDATATYPE;   prodnum        : packed array [1..6] OF QUADTYPE;    FIRSTCHAR      : CHAR;    LU             : wordtype;    DA             : wordtype;    MAXNUMLU       : doubletype;    MAXSECTOR      : doubletype;    MAXHEAD        : wordtype;    MAXCYL         : doubletype;    MAXBLOCK       : doubletype;    INTERLEAVE     : doubletype; 
  TAPE           : boolean; 

  DISC           : boolean; 

  CONTROLLER     : boolean; 
   ADDRMODE       : wordtype;   lu_num         : lu_num_type;    COMP           : COMPTYPE; 
  NOERROR        : boolean; 
   UNITNUM        : wordtype;    I              : wordtype;   info           : packed array[0..10] of bytetype;    rrev           : REAL;   parms          : parm_type;   exitflag,   spareblock,   eagle_rfsector,    M794X,    M7907,    M791X,    M793X,    M9140,    M9144,    EAGLE,    M795X,   M795XA,   M795XB,    C220X,    C2202,    breakflag, #  RTEA           : boolean;                                  (* RTE6 *) #   track          : track_type;    device_type    : wordtype;   prog_name      : prog_type;    buffer         : bufrtype;   file_name      : char8;   rtn_file_name  : char8;   options        : char2;   position,    len,    parm3,   line_cnt,    error,    cmd_len        : wordtype;  	  release_segment, 	   print_paddr,    describe_ok,    isp,rsp, 
  ce_mode        : boolean; 
   ce_mode_cmds   : set of cmds_type;    buf64,   infile,  
  outfile        : char64; 
    PROCEDURE do_it $alias 'exec'$ (ecode:wordtype; !  prog_name:prog_int_type; parm1,parm2,parm3,parm4,parm5 :wordtype; !  bufr:bufrtype; bufln:wordtype); external;     PROCEDURE rmpar(var parm:parm_type);external;     #FUNCTION which_os $ alias 'opsys' $ : wordtype; external;    (* RTE6 *) #    #PROCEDURE get_trackmap $ alias 'exec' $                      (* RTE6 *) # 
  (     icode  : wordtype; 
 
        lu     : wordtype; 
     var buf    : track_type;  
        len    : wordtype; 
 
        dum1   : wordtype; 
        dum2   : wordtype  ); external;      PROCEDURE GETSCODE  $ alias 'EXEC' $ !   (ecode, lu: wordtype; stat1, stat2: selcotype ; stat3: wordtype; !                         stat4: tapeunittype ); external;      PROCEDURE getcode $ alias 'exec' $            (e,lu:wordtype;b:char2;l:wordtype);external;     PROCEDURE locklu $ alias 'LURQ' $            (option,luary,num : wordtype); external;     FUNCTION ifbrk:wordtype;external;     FUNCTION  LUTRU (lu: wordtype): wordtype; external;      FUNCTION  LDTYP (lu: lutype; var numtype: wordtype):                 wordtype; external;      PROCEDURE XUTIL (Var lu, da : wordtype; Var comp : comptype;                 Var iobuf : iobuftype); external;      PROCEDURE XDIAG (Var lu, da : wordtype; Var comp : comptype;                 Var iobuf : iobuftype); external;      PROCEDURE XINMD (Var lu, da : wordtype; Var comp : comptype;                 Var iobuf : iobuftype); external;      PROCEDURE XCOMP (Var lu, da : wordtype; Var comp : comptype;                 Var iobuf : iobuftype); external;      PROCEDURE XSPRE (Var lu, da : wordtype; Var comp : comptype;                 Var iobuf : iobuftype); external;      PROCEDURE XLCRD (Var lu, da : wordtype; Var comp : comptype;                 Var iobuf : iobuftype); external;      PROCEDURE XDESC (Var lu, da : wordtype; Var comp : comptype;                 Var iobuf : iobuftype); external;      PROCEDURE XRQST (Var lu, da : wordtype; Var comp : comptype;                 Var iobuf : iobuftype); external;      PROCEDURE XCNCL (Var lu, da : wordtype; Var comp : comptype;                 Var iobuf : iobuftype); external;      PROCEDURE XCICL (Var lu, da : wordtype; Var comp : comptype;                 Var iobuf : iobuftype); external;      PROCEDURE XSDCL (Var lu, da : wordtype; Var comp : comptype;                 Var iobuf : iobuftype); external;      PROCEDURE XAMCL (Var lu, da : wordtype; Var comp : comptype;                 Var iobuf : iobuftype); external;     FUNCTION FBUS (VAR lu : wordtype) : wordtype; external;     FUNCTION GETFILENAME $alias 'PAS.FILENAMR'$                (VAR f : text) : char64; external;      FUNCTION GETPARMS $alias 'PAS.PARAMETERS'$               (VAR position : wordtype; VAR buf64 : char64;                 VAR len : wordtype) : wordtype; external;          PROCEDURE START_CHILD (ecode:wordtype;pname:prog_int_type;                         p1,p2,p3,p4,p5 :wordtype;                         var bufr:bufrtype; bufln:wordtype); var   i : wordtype;     begin    if not (outfile[1] in ['1'..'9']) then     close(f);    bufr[299]:=ord(infile[1]); 	  for i:=1 to 64 do 	    bufr[i+299]:=ord(outfile[i]);   do_it(ecode,pname,p1,p2,p3,p4,p5,bufr,bufln);   rmpar(parms);    breakflag:=parms[1]<0;    if not (outfile[1] in ['1'..'9']) then     append(f,outfile,'exclus');  end;      PROCEDURE CLEAR_OUTBUF $direct$; VAR   count: integer; BEGIN   for count:=1 to 30 do     outbuf[count]:=' ';  END;     PROCEDURE invalid_command $direct$;   begin      writeln;      writeln('Command not supported for this device.');     goto 0;    end;      PROCEDURE INPUTERROR $direct$;  (*OUTPUT ERROR MESSAGE*)   begin      writeln;      prompt('Invalid input, please try again: ');    end;     PROCEDURE print_binary $direct$ (data_byte:bytetype);   var  	    K : erraptype; 	    J : wordtype;   begin 
    k.allbits := data_byte; 
     for J := 0 to 7 do  
      if k.b[J] then 
 
        write(f,'1') 
       else 
        write(f,'0'); 
   end;      (**************************************)  (* Write byte in two digit hex format *)  (**************************************) PROCEDURE WRITEHEX $direct$(HEXNUM:bytetype);   begin     write(F,' ',HEXCHAR[HEXNUM DIV 16],HEXCHAR[HEXNUM MOD 16]);    end;         PROCEDURE SPACE $direct$(I:bytetype);   VAR J:bytetype;   BEGIN      FOR J:=I DOWNTO 1 DO write(f,' ');    END;          PROCEDURE time_msg $direct$;   begin      writeln;  !    writeln('This utility may take several minutes to complete.'); !   end;          PROCEDURE DEV_PRINT $direct$ (printout : boolean);  #{********************************************************************} # #{*  9-1-87  L. Doner :  Print out an A or B following the model type.} # #{*                      M795XA or M795XB. Also 796X models.          } # #{********************************************************************} #      var      I :bytetype;      J :bytetype;   begin     I := 1; 
    while prodnum[I] = 0 do 
      I := I + 1;      for J := I to 5 do  
      if not printout then 

        write(prodnum[J]:1) 
       else          write(f,prodnum[J]:1);      if M795XA or M795XB then  
      if not printout then 
        begin            if M795XA then             write('A');            if M795XB then              case prodnum[5] of                7: write('B / 7961B');                8: write('B / 7962B');                9: write('B / 7963B');               otherwise              end;         end        else         begin            if M795XA then             write(f,'A');            if M795XB then              case prodnum[5] of                7: write(f,'B / 7961B');                8: write(f,'B / 7962B');                9: write(f,'B / 7963B');               otherwise              end;          end;      if not printout then       writeln      else       writeln(f);  
  end;  (* of dev_print *) 
        PROCEDURE PRNTADDR $direct$(addr : addrtype);       begin      if ADDRMODE = 0 then        writeln(F,'Block Address = ',ADDR.BLOCK:1)      else       begin         write(F,'Cylinder = ',ADDR.CYLINDER:1);         SPACE(5);         write(F,'Head = ',ADDR.HEAD:1);          if (spareblock) and (M7907) then           begin             writeln(F);           end          else           begin 
            SPACE(5); 
            writeln(F,'Sector = ',ADDR.SECTOR:1);            end;        end;    end;  (* prntaddr *)          PROCEDURE prntstatus $direct$(VAR STATUSMSG:STATUSTYPE);  $(**********************************************************************) $#(*  1-27-88  L. Doner  :  Added 99 in buffer to tell son, request comes # (*                        from father.  $(**********************************************************************) $  var 
    X      :bytetype; 

    parm4  :wordtype; 

    parm5  :wordtype; 
      begin      if spareblock then        parm4 := 0      else       parm4 := 1;          if disc then parm5 := 0 else      if tape then parm5 := 1 else      if controller then parm5 := 2 else     parm5 := 3;         for X := 0 to 19 do        buffer[X] := statusmsg.unformatted_status.status[X];      buffer[20] := 99;    {from father}      $    start_child(9,prog_name.prog_int,6,device_type,addrmode,parm4,parm5, $                  buffer,-bufrlen); 
  end;  (* of prntstatus *) 
    FUNCTION CHECKQSTAT $direct$ (print_status:boolean) :boolean;   begin     if IOBUF.QSTAT=0 then        checkqstat := true      else       begin          if (IOBUF.QSTAT = 1) or (IOBUF.QSTAT = 2) then            if IOBUF.FQSTAT = 0 then             begin                if print_status then                  prntstatus(IOBUF.FSTATUS);             end            else             writeln('Error during Request Status');          checkqstat := false;        end; 
  end;  (* of checkqstat *) 
         PROCEDURE dash_write $direct$;  var I :bytetype;   begin     for i := 0 to 60 do write(F,'-');     writeln(F);    end;          PROCEDURE PUTILITY $direct$;  (*Prints test header*) &{***************************************************************************} &&{*  Update 2-26-87 L. Doner  : Removed clear_outbuf prior to write Utility. } &&{*  3-3-1987  L. Doner : Put 'UTILITY' in outbuf for correct placement.     } &&{***************************************************************************} &const    utility = 'UTILITY'; var    toprinter : boolean; "  foundit : boolean;          {Used when found the end of the string} "   i,position : wordtype;     BEGIN   writeln(F);   dash_write; 	  foundit := false; 	  position:= 65;                 {Outbuf is a char64}  '  REPEAT     {Start at the end of the string and look for the first non-blank} '    position:=position-1;      if(outbuf[position]<>blank) then  
      foundit:=true; 
   UNTIL (foundit OR (position=1));    position:= position+1;  &  if (position<=58) then               {There is enough room to add UTILITY} &    begin        FOR i:=1 to 7 do                    {Add UTILITY to outbuf}         outbuf[position+i]:= utility[i];    end;  
  writeln(f,outbuf); 
  write(F,'LU ',LU:1,' is a ');  
  toprinter := true; 
  dev_print(toprinter);   writeln(f);   write(F,'Current unit = ',unitnum:2);       if M7907 then     begin       if unitnum = 0 then          write(F,' (fixed)');       if unitnum = 1 then          write(F,' (removable)');      end;        if unitnum = 15 then       write(F,' (controller)');   writeln(F);  END;          PROCEDURE ENDER $direct$(option : wordtype); &{***************************************************************************} &&{*  3-3-1987  L. Doner : Put 'COMPLETED' in outbuf for correct placement.   } & &{**************************************************************************} &    const  
  completed = 'COMPLETED'; 
 
  failed = 'FAILED'; 
   term = 'TERMINATED BY USER';     var  "  foundit : boolean;         {Used when found the end of the string} "   i,position : wordtype;     BEGIN   writeln(F); 	  foundit := false; 	   position := 65;                 {Outbuf is a char64}  '  repeat     {Start at the end of the string and look for the first non-blank} '    position := position - 1;      if(outbuf[position] <> blank) then        foundit := true;    until (foundit OR (position = 1)); 
  position := position + 1; 
   case option of %    1 : if (position <= 56) then           {There is room to add COMPLETED} %          begin %            FOR i := 1 to 9 do                    {Add COMPLETED to outbuf} %            outbuf[position + i] := completed[i];            end;  %    2 : if (position<=59) then        {There is room for FAILED in outbuf} %            begin #             FOR i:=1 to 6 do                    {Add FAILED to outbuf} #              outbuf[position+i]:= failed[i];            end;  %    3 : if (position<=47) then              {There is room to add message} %          begin  $            FOR i:=1 to 18 do                    {Add message to outbuf} $            outbuf[position+i]:= term[i];            end;    end;  {case}  
  writeln(F,outbuf); 
  clear_outbuf;   dash_write;    if (option = 2) or (option = 3) then     goto 0;  END;         PROCEDURE DISPLAY_LOOP $direct$ (count:bytetype); begin    writeln;   writeln(f,'Loop count = ',count:1);  end;         FUNCTION UPCASE $direct$ (c:char):char; begin   if c in ['a'..'z'] then  
    upcase:=chr(ord(c)-32) 
   else      upcase:=c;  end;          FUNCTION MORE_LINES $direct$ :boolean; var    c:char2; begin   if ((line_cnt > 20) and (infile = '1 ')) then     begin        writeln; %      prompt('More...(''s'' to stop listing)',chr(27),'A',chr(13)); {go up} %      getcode(1,octal('101'),c,-1);  #      prompt(chr(27),'J',chr(13));                      {clear screen} # 	      line_cnt:=0; 	       more_lines:=upcase(c[0]) <> 'S';     end    else 
    more_lines:=true; 
 end;     (*******************************************************) (* Input a line, convert to upper case, check for exit *) (*******************************************************)   PROCEDURE READ $direct$;  {Read command entered by user or file}    var     I:wordtype;        begin (*read*)     if eof then       begin 
        close(input); 
        reset(input,'1');        end;     inbuf:='                     ';  	    readln(inbuf); 	     cmd_len:=maxichar;     while (inbuf[cmd_len]=' ') and (cmd_len > 0) do       cmd_len:=pred(cmd_len);  "    for i:=1 to cmd_len do           {Convert command to upper case} "      inbuf[i]:=upcase(inbuf[i]);  
    firstchar := INBUF[1]; 
    if (inbuf = 'EXIT') or (inbuf = 'EX') or (inbuf = 'E') then        if exitflag then         begin  	          writeln; 	          writeln('Program halted by user request!');  	          writeln; 	 	          halt(0); 	        end        else         ender(3);    end;   (* of Read *)         %FUNCTION READNUM $direct$(minnum, maxnum : doubletype; run_parm : wordtype) %                          : doubletype;  &(**************************************************************************) & &(* Read input number.  Allows +/-, all, or inf.  Converts                 *) & &(* - to +.  Checks for number in range minnum to maxnum.                  *) & &(* If minnum is -99, checks for a valid lu number.                        *) & &(**************************************************************************) & &(*  9-1-89   L. Doner  :  Added parameter run_parm. If run_parm = -99,    *) & &(*                        then a third parameter was in the run string.   *) & &(*                        Use the value in the run string for the LU      *) & &(*                        instead of prompting. Changed error message and *) & &(*                        will halt on error from input file (not CRT).   *) & &(**************************************************************************) &      VAR     infflag, minus : boolean;      digitnum, i, numdigits : wordtype; 
    mult, num : doubletype; 
     
  begin        { READNUM } 
     repeat 
      numdigits := 0; 
 
      digitnum := 1; 

      minus := false; 
       noerror := true;        mult := 1;       num := 0;       if (run_parm <> -99) then         read;        if (inbuf='ALL') or (inbuf='INF') then         infflag := true        else         infflag := false;           if not infflag then          begin  (* inf not input *)           INBUF[MAXICHAR] := ' ';           if firstchar = '-' then             begin  
              MINUS:=TRUE; 
 
              DIGITNUM:=2; 
             end;                  (*Verify input as digits*)           while (INBUF[DIGITNUM]<>' ') and noerror do             if INBUF[DIGITNUM] IN ['0'..'9'] then 	              begin 	                DIGITNUM:=DIGITNUM+1;                 NUMDIGITS:=NUMDIGITS+1;               end              else               noerror := false;                IF NOT NOERROR THEN writeln('Input was not a number.');             IF (NUMDIGITS>10) OR (NUMDIGITS=0) THEN NOERROR:=FALSE;            if noerror then              FOR I:=NUMDIGITS DOWNTO 1 DO 	              begin 	                DIGITNUM:=DIGITNUM-1;                  NUM:=NUM+(ORD(INBUF[DIGITNUM])-ORD('0'))*MULT;                  MULT:=MULT*10;  	              end; 	          IF MINUS THEN NUM:=-NUM;            (*Convert to +.*)            if (MINNUM = -99) and noerror then               begin                             (* Checking lu. *)                NOERROR := FALSE; 
              I := 1; 
               while (I <= MAXNUM) and not noerror do 
                begin 
                   IF lubuf[I].LUNUM = NUM THEN                      NOERROR := TRUE; 
                  I := I+1; 
 
                end; 
              if not noerror then  
               begin 
                 writeln;                   writeln('Input was not a valid CS/80 LU #.'); 	               end; 	            end            else &            begin                             (* Check if number in range. *) &               if (NUM>MAXNUM) or (NUM<MINNUM) then 
                begin 
                  noerror := false;  %                  writeln('Number is out of bounds, it should be in the'); %$                  writeln('range of ',MINNUM:1,' <= # <= ',MAXNUM:1,'.'); $ 
                end; 
             end;            if not noerror then   {if there is an error}             begin               inputerror;               run_parm := 0;   {allow user to input new LU}                if (infile <> '1') then  {if infile is a file}                  halt(0);              end;         end  (* of inf not input *)        else 	        num := 255; 	     until noerror;  (* end of repeat loop *) 	    readnum := num; 	
  end;  (* READNUM *) 
            FUNCTION READPATTERN $direct$:doubletype;   VAR     I:wordtype;     J:wordtype;     K:wordtype;      PATTERN:PATTERNTYPE;   BEGIN      REPEAT  
      NOERROR:=TRUE; 

      PATTERN.ALL:=0; 
       writeln;  #      prompt('Input the hexadecimal pattern of up to 8 hex digits: '); #      READ;       I:=1; 
      INBUF[16]:=' '; 
       WHILE (INBUF[I]<>' ') DO BEGIN         J:=ORD(INBUF[I]);          K:=-1;          IF (J>47) and (J<58) THEN K:=J-48;          IF (J>64) and (J<71) THEN K:=J-55;          IF K=-1 THEN NOERROR:=FALSE;         I:=I+1;        END;       I:=I-1;        IF (I=0) OR (I>8) THEN NOERROR:=FALSE; 
      IF NOERROR THEN BEGIN 
        J:=7; 
        WHILE I<>0 DO BEGIN 

          K:=ORD(INBUF[I]); 
 #          IF K<58 THEN PATTERN.HEX[J]:=K-48 ELSE PATTERN.HEX[J]:=K-55; #          I:=I-1;           J:=J-1;          END;  
      END ELSE INPUTERROR; 
 	    UNTIL NOERROR; 	    READPATTERN:=PATTERN.ALL;    END;              #(********************************************************************) # #(* Get address in either block or three vector mode, while checking *) # #(* for valid numbers.                                               *) # #(********************************************************************) #
PROCEDURE GETADDR $direct$; 
  VAR      mxsector:doubletype;     I:wordtype; 
  begin       (* getaddr *) 
         if not eagle_rfsector then       begin  (* ask for block/three vector *)          writeln; $        prompt('Do you want block (B) or three vector (V) addressing? '); $         I := 99;          repeat           read; 
          case FIRSTCHAR of 
             'B': I := 0;              'V': I := 1;             OTHERWISE INPUTERROR;           end;  (* of case *)          until I <> 99;          writeln;          mxsector:=maxsector;       end (* of ask for block/three vector *)      else       begin #        I := 1;  (* eagle rf sector always uses three vector address *) #         mxsector:=maxsector + 1;        end;  
    COMP.ADDRRETMODE := I; 
     XCOMP(LU,DA,COMP,IOBUF);  	    ADDRMODE := I; 	
    COMP := NULLCOMP; 
         with COMP.ADDRESS do        begin  (* input address *)          if ADDRMODE = 0 then           begin (* block address *)              prompt('Input block address (0 - ',MAXBLOCK:1,')? ');              BLOCK := READNUM(0,MAXBLOCK,0);             FILLER1 := 0;              if (spareblock and M7907) then                block := block - block mod 64;            end   (* of block address *)          else            begin (* three vector *)              prompt('Input cylinder (0 - ',maxcyl:1,')? ');              CYLINDER := READNUM(0,MAXCYL,0);             prompt('Input head (0 - ',maxhead:1,')? ');             HEAD := READNUM(0,MAXHEAD,0);             if (SPAREBLOCK and (M794X or M7907)) then               sector := 0            else  	             begin 	               write('Input ');                if eagle_rfsector then                   write('physical ');                prompt('sector (0 - ',mxsector:1,')? ');                sector := readnum(0,MXSECTOR,0);              end;           end;  (* of three vector *)       end; (* of input address *)    end;  (* of GETADDR *)             FUNCTION DESCRIBE:boolean $direct$;      	VAR   I: wordtype; 	  begin      DESCRIBE := FALSE;      COMP.UNITNUM := UNITNUM;     IF UNITNUM <> 15 THEN       begin  
        COMP.VOLUMENUM:=0; 
        COMP.ADDRRETMODE := ADDRMODE;        end;      XCOMP(LU,DA,COMP,IOBUF);      if checkqstat(true) then 
      if UNITNUM <> 15 then 
        begin  (* unit <> 15 *)           COMP:=NULLCOMP;            XDESC(LU,DA,COMP,IOBUF);            if checkqstat(true) then with IOBUF.DESCRIP do              begin   (* no error *)                MAXCYL     := DESMAXCYL;               MAXHEAD    := DESMAXHEAD;                MAXSECTOR  :=DESMAXSECTOR;               MAXBLOCK   :=DESMAXBLOCK;               INTERLEAVE :=DESINTLEAVE;               TAPE       :=DESTYPE=2;               DISC       :=DESTYPE<2;  
              IF DISC THEN 
                 FOR I:=1 TO 6 DO                    prodnum[I]:=DESprodnum[I];                CONTROLLER:=FALSE;               DESCRIBE:=TRUE;              end;  (* no error *)         end  (* unit <> 15 *)        else          begin  (* unit = 15 *)  
          MAXCYL:=0; 

          MAXHEAD:=0; 
          MAXSECTOR:=0;            MAXBLOCK:=0;            INTERLEAVE:=0;            TAPE:=FALSE;            DISC:=FALSE; 
          CONTROLLER:=TRUE; 
          DESCRIBE:=TRUE;          end;  (* of unit = 15 *)   end;  (* of DESCRIBE *)          PROCEDURE LOG_HEADER $direct$;   begin     start_child(9,prog_name.prog_int,3,device_type,0,0,0,                 buffer,-bufrlen); 
  end;  (* of log_header *) 
         PROCEDURE PHYS_PRINT $direct$;   begin     writeln(f);     write(f,'Print physical address ');     if print_paddr then       begin         print_paddr := false;          writeln(f,'disabled');       end      else       begin          print_paddr := true;         writeln(f,'enabled');        end; 
  end;  (* of phys_print *) 
     PROCEDURE ZREQUESTSTAT $direct$;       begin     outbuf := 'REQUEST STATUS';     putility;          XRQST(lu,da,comp,iobuf);      if checkqstat(true) then     {Qstat = 0}       begin         prntstatus(iobuf.exreqstatrarea);         ender(1);       end     else    {Qstat = 1}       ender(2);   end;  (* of ZREQUESTSTAT *)          PROCEDURE PRNT_FAULT_ERROR $direct$;   begin     start_child(9,prog_name.prog_int,4,device_type,0,0,0,                 buffer,-bufrlen);   end;  (* of prnt_fault_error *)         PROCEDURE PRT_ERROR_INFO $direct$ (logtype:wordtype);   begin     start_child(9,prog_name.prog_int,5,device_type,logtype,0,0,                 buffer,-bufrlen);   end;  (* of prt_error_info *)          &FUNCTION DOUTIL $direct$(UNUM,UTYPE,ULGN:wordtype;UPARM1:bytetype) :boolean; &  begin     with IOBUF.EXMISCTAREA do       begin         UTILNUM  := UNUM;  
        UTILTYPE := UTYPE; 
        PARMLGN  := ULGN; 
        PARM1    := UPARM1; 
        EXLGN    := 1024;        end;      XUTIL(LU,DA,COMP,IOBUF);     doutil := checkqstat(true);    END;         PROCEDURE SET_DEVICE_FLAGS (lu_print:boolean) $direct$;  %(************************************************************************) % %(*  THIS PROCEDURE COMPARES THE SELECTED DEVICE TO A LIST OF PREDEFINED *) % %(*  DEVICES and SETS THE FLAG OF THE TYPE OF DEVICE THAT HAS BEEN       *) % %(*  SELECTED, WHICH CAN THEN BE USED FOR IMPLEMENTING DEVICE-SPECIFIC   *) % %(*  FUNCTIONS.  IT ALSO TELLS WHAT DEVICE WAS SELECTED.                 *) % %(************************************************************************) % %(*  9-1-87  L. Doner : 795X drives now include 796X drives. 795X device *) % %(*                     type is set in Describe.                         *) % %(*  9-2-87  L. Doner : Added a boolean variable, lu_print, to indicate  *) % %(*                     whether 'LU is ...' is printed to screen or not. *) % %(*                     True = print, False = do not print               *) % %(*  9-12-89 L. Doner : Added C220X for 2200, 2202 and 2203,             *) % %(*                     and C2202 for the cache version.                 *) % %(************************************************************************) %    var   J         : bytetype;    toprinter : boolean;     begin  	  M791X  := false; 	 	  M793X  := false; 	 	  M794X  := false; 	 	  M7907  := false; 	 	  EAGLE  := false; 	 	  M795X  := false; 		  M795XA  := false; 		  M795XB  := false; 	 	  C220X  := false; 	 	  C2202  := false; 	     $  IF ((prodnum[2] = 2) and (prodnum[3] = 2) and (prodnum[5] in [0,2,3])) $   then     begin               {2200, 2202 and 2203}  
      C220X := true; 
      device_type := 9;        if (prodnum[5] = 2) then         begin            C2202 := true;            device_type := 10;          end;      end;        IF ((prodnum[2] = 7 ) and (prodnum[3] = 9)) THEN     begin       IF (prodnum[4] = 4)  then         begin          M794X := true;  
         device_type := 0; 
       end;       IF ((prodnum[4] = 0) and (prodnum[5] = 7)) then         begin          M7907 := true;  
         device_type := 1; 
       end;      IF ((prodnum[4] = 1) and (prodnum[5] IN [1,2,4]    )) then         begin          M791X := true;  
         device_type := 2; 
       end;      IF ((prodnum[4] = 3) and (prodnum[5] IN [3,5]      )) then         begin          M793X := true;  
         device_type := 3; 
       end;      IF ((prodnum[4] = 3) and (prodnum[5] IN [6,7]      )) then         begin          EAGLE := true;  
         device_type := 6; 
       end;       if (prodnum[4] in [5,6] ) then       {795X}         begin          M795X := true;          if (prodnum[6] = 0) then             begin               M795XA := true;               device_type := 7;            end;          if (prodnum[6] = 1) then             begin               M795XB := true;               device_type := 8;            end; 	       end;  {795X} 	   end;         isp := M794X or M7907 or M795X;     rsp := M791X or M793X or EAGLE;     	   if lu_print then 	      begin         write('LU ',LU:1,' is a ');  
       toprinter := false; 
        dev_print(toprinter);        writeln;      end;  end;          (****************************************)  (* Read input until "Y", "N" or "EXIT"  *)  (****************************************) FUNCTION YESNOINPUT:boolean $direct$;       begin      repeat        noerror := true;       read;       case firstchar of          'Y': yesnoinput := true;           'N': yesnoinput := false;       otherwise 	        inputerror; 	        noerror := false;        end;  	    until noerror; 	
  end;  (* of yesnoinput *) 
         PROCEDURE RUIN $direct$;   begin     writeln('This routine will destroy current data.');     prompt('  Should it continue? ');      if not yesnoinput then ender(3); 
  end;  (* of ruin *) 
         FUNCTION PRESET_DRIVE $direct$ :boolean;   begin      writeln;     writeln('Preset in progress...');         if not DOUTIL(206,0,0,0) then 
      preset_drive := false 
     else 
      preset_drive := true; 
  end;  (* of preset_drive *)          PROCEDURE ZAMCLEAR $direct$;  $(**********************************************************************) $ $(*  This PROCEDURE implements the AMIGO CLEAR needed for 794X and     *) $ $(*  7907 devices.  The BUS LU is passed to the AMCLEAR external.      *) $ $(*  The fortran external FBUS is used to get the BUS LU from the      *) $ $(*  system tables.                                                    *) $ $(**********************************************************************) $ $(* 6-17-87  L. Doner : Removed the 795X drives from this command.     *) $ $(* 6-18-87  L. Doner : Added check for Fbus(Lu) = 0, fbuslu and message. $ $(* 9-29-89  L. Doner : Changed ISP and not M795X to M794X and M7907.  *) $ $(**********************************************************************) $ var  fbuslu : boolean;     begin 
  if (M794X and M7907) then 
    begin        outbuf := 'AMIGO CLEAR';       putility; 
      fbuslu := true; 
 	      if RTEA then 	        begin            iobuf.extablerarea.tbl[1]:=fbus(lu);            if (fbus(lu) = 0) then             begin                fbuslu := false;                writeln; "              writeln('No HPIB Bus Controller LU has been assigned ', "               'to the interface'); %              writeln('card during system generation. On an RTE-A system,', %              ' this LU is'); !              writeln('required to run the Amigo Clear command to', !               ' a CS80 drive.');              end;          end;        XAMCL(lu,da,comp,iobuf);       if (checkqstat(true) and fbuslu) then          ender(1)        else         ender(2);     end    else  
    invalid_command; 
 end;     
PROCEDURE ZCANCEL $direct$; 
  BEGIN     outbuf := 'CANCEL';     putility;          XCNCL(LU,DA,COMP,IOBUF);          if checkqstat(true) then        ender(1)      else       ender(2);    end;      PROCEDURE ZCHINCLR $direct$;   begin      outbuf := 'CHANNEL INDEPENDENT CLEAR';     putility;          XCICL(LU,DA,COMP,IOBUF);      if checkqstat(true) then        ender(1)      else       ender(2);    end;  (* of channel independent clear *)         PROCEDURE ZCLEARLOG $direct$; #(*********************************************************************) ##(*  9-23-89  L. Doner  : Added C2202 for cache error log.            *) ##(* 10-05-89  L. Doner  : Added exit.                                 *) ##(*********************************************************************) #  var     logcode : bytetype;   begin 
    outbuf := 'CLEAR LOGS'; 
    putility;          writeln; 
    writeln('Clear logs:'); 
     writeln('  0 - all logs');     writeln('  1 - ERT log');     if ISP then        writeln('  2 - run-time log and fault log');     if C2202 or EAGLE or M793X then       writeln('  3 - cache error log');  
    writeln('  4 - exit'); 
     writeln;  
    prompt('Which log? '); 
     repeat       logcode := readnum (0,4,0); 
      if (logcode = 4) then 
        ender(2);              {exit}        if not preset_drive then         begin  	          writeln; 	           writeln('Warning: preset failed');          end; 
      case logcode of 
         0 : write(f,'All ');          1 : write(f,'ERT ');         2 : write(f,'Run-time and fault ');          3 : write(f,'Cache error ');  !      255 : inputerror;                {if 'all' or 'inf' entered} !       end;     until logcode <> 255;     if DOUTIL(205,0,1,LOGCODE) then       begin          writeln(f,'logs cleared');         ender(1);       end      else       begin          writeln(f,'logs not cleared');         ender(2);        end;  
  end;  (* of zclearlog *) 
         PROCEDURE ERROR_LOG $direct$ (logtype:wordtype);   var      x :bytetype;   begin     for x := 0 to 10 do 
      buffer[x] := info[x]; 
      start_child(9,prog_name.prog_int,13,device_type,logtype,0,0,                    buffer,-bufrlen);  
  end;  (* of error_log *) 
        PROCEDURE ZDATALOG $direct$ (logtype : wordtype); #(*********************************************************************) ##(* 6-12-87  L. Doner : Sent a code to Log_header to let it know to   *) ##(*                     print 'Error' above 'Count'.                  *) ##(* 8-23-89  L. Doner : Added errors and a check if no errors on all  *) ##(*                     heads, just print out 'no error' message.     *) ##(*                     This is for Northern Telecom, shortens output.*) ##(* 9-11-89  L. Doner : Moved code to Exer1, the son.                 *) ##(*********************************************************************) #      VAR     start_head, 
    end_head    : wordtype; 
      begin 
    if (logtype = 197) then 
       outbuf := 'READ RUN LOG'      else                         {logtype = 198}       outbuf := 'READ ERT LOG';     putility;      
    noerror := true; 
     writeln;      prompt('Input the head (0 - ',maxhead:1,') or ALL? ');     start_head := readnum(0,maxhead,0);     if (start_head = 255) then  {255 = 'all'}       begin          start_head := 0;          end_head := maxhead;       end      else       end_head := start_head;      
    buffer[0] := LU; 
 
    buffer[1] := DA; 
    #    start_child(9,prog_name.prog_int,17,device_type,logtype,start_head, #                 end_head,buffer,-bufrlen);     
    if (parms[4] = 99) then 
      ender(1)   { good end }      else        ender(2);  { bad end }        end;   (* datalog *)         PROCEDURE ZDESCRIBE $ direct $;  #{********************************************************************} # #{*  9-2-87  L. Doner  :  Added boolean variable lu_print to send as *} # #{*                       parameter to set_device_flags.             *} # #{********************************************************************} #    var   I,J       : wordtype;   lu_print,    toprinter : boolean;      begin    (* ZDESCRIBE *)  	  if describe then 	    begin 
      outbuf := 'DESCRIBE'; 
      putility;           writeln(F);  
      write(F,'MODEL:  '); 
       toprinter := true;  	      if tape then 	         write(F,'(CTD)')        else         dev_print(toprinter);           writeln(F,'UNIT:',UNITNUM:4);  
      write(F,'TYPE:   '); 
      IF TAPE THEN writeln(F,'TAPE');       IF CONTROLLER THEN writeln(F,'CONTROLLER');      	      if DISC then 	        begin  (* disc *)            writeln(F,'DISK');           writeln(F,'Maximum cylinder address =  ',MAXCYL);            writeln(F,'Maximum head address =      ',MAXHEAD);            writeln(F,'Maximum sector address =    ',MAXSECTOR); 
          writeln(F); 
          writeln(F,'Maximum block address =     ',MAXBLOCK);            writeln(F,'Current interleave factor = ',INTERLEAVE:1);  
        end;  (* of disc *) 
       lu_print := false;       set_device_flags(lu_print);       ender(1);      end   (* of if describe *)    else     ender(2);  end;     (* ZDESCRIBE *)         
PROCEDURE ZFLTLOG $direct$; 
 $(**********************************************************************) $ $(*  9-22-89  L. Doner  :  Added C220X to display HFR values.          *) $ $(**********************************************************************) $      CONST       max_errors = 18;   {18 * 11 = 198 and maximum buffer is 298}     VAR                  {helps break up output to screen}     tot_errors,      errors_left,      start_buf,      end_buf,     header,      x,      printflag :wordtype;       BEGIN  
    outbuf := 'FAULT LOG'; 
    putility;     writeln(f);     if DOUTIL(199,2,0,0) then       begin          tot_errors:= iobuf.exfltlograrea.flt[0];          if tot_errors = 0 then            writeln(f,'No drive faults')          else           begin              printflag:=ord(print_paddr);              errors_left:=tot_errors;              header:=1;              line_cnt:=0;             while (errors_left > 0) and more_lines do 	              begin 	                start_buf:=(tot_errors - errors_left) * 11 + 1;                  if errors_left > max_errors then                   begin                      buffer[0]:=max_errors;                       end_buf:= start_buf + (max_errors * 11) - 1;                        line_cnt:=30;   {force a more_lines message}  
                  end 

                 else 
                  begin                     buffer[0]:=errors_left;                      end_buf:= start_buf + (errors_left * 11) - 1;                     end;                  for x := start_buf to end_buf do  %                  buffer[x - start_buf + 1] := iobuf.exfltlograrea.flt[x]; % %                start_child(9,prog_name.prog_int,14,device_type,printflag, %                            header,tot_errors,buffer,-bufrlen);  
                header:=0; 
                 errors_left:=errors_left - max_errors;  	              end; 	             if RSP or C220X then 	              begin 	
                writeln(f); 
                 prompt('Display HFR values ? ');                  if yesnoinput then                   prnt_fault_error;  	              end; 	           end; 
      end   (* of DOUTIL *) 
     else       ender(2);     ender(1);    END;  (* of zfltlog *)          
PROCEDURE ZFRMAT $direct$; 
 #(********************************************************************) # #(* 6-12-87  L. Doner : Changed Eagle to default to an interleave of *) # #(*                     1. Added warning message on interleave.      *) # #(* 9-24-89  L. Doner : Added C220X.                                 *) # #(********************************************************************) #      begin 
    outbuf := 'INIT MEDIA'; 
    putility;      writeln;     ruin;     with IOBUF.EXFORMATTAREA do       begin          writeln;         writeln('Do you want to:'); 
        option := 99; 
         repeat           if M7907 then              writeln(' N = retain no spares')            else              if M794X or M795X then               writeln(' R = read/write header (destructive)')              else                writeln(' M = initialize maintenance tracks');           writeln(' P = retain only primary spares');            writeln(' A = retain all spares');  	          writeln; 	          prompt('Option? ');           read; 
          writeln(f); 

          CASE FIRSTCHAR OF 
             'N': if M7907 then                     begin                      option:=2;                       writeln(f,'Retaining no spares');                     end 
                 else 
                    inputerror;              'M': if not (M7907 or M794X or M795X) then                     begin                      option:=2;  !                     writeln(f,'Initializing maintenance tracks'); !                    end 
                 else 
                    inputerror;             'R': if (M794X or M795X) then                     begin                      option:=2;  !                     writeln(f,'Read/write header (destructive)'); !                    end 
                 else 
                    inputerror;              'P': begin                    option:=1;                     writeln(f,'Retaining only primary spares'); 
                 end; 
             'A': begin                    option:=0; #                   writeln(f,'Retaining primary and secondary spares'); #
                 end; 
 
           otherwise 
            inputerror; 
          end;(* of case *) 
        until OPTION <> 99;(* end of repeat loop *)         if C220X or EAGLE or M795X or M794X or M7907 then           interleave := 1          else           begin  
            writeln; 
%            writeln('Warning: Interleave other than 1 on HP1000 systems,'); % $            writeln('could result in serious performance degradation.'); $ 
            writeln; 
%            prompt('Input interleave value (1 <= value <= 32)? '); (*2525*) %            interleave := readnum(1,32,0); (*2525*)             writeln(f);             writeln(f,'Interleave value = ', interleave:1);            end;         time_msg;          XINMD(LU,DA,COMP,IOBUF);        end;          if checkqstat(true) then        ender(1)      else       ender(2);    end;   (* of format *)         PROCEDURE ZHELP $direct$;              (* Located in EXER1 *)   begin     start_child(9,prog_name.prog_int,1,                     device_type,ord(ce_mode),0,0,buffer,-bufrlen);     end;          
PROCEDURE ZIDIAG $direct$; 
"(*******************************************************************) ""(* 07-08-87  L. Doner  : Changed Eagle max_diag to 1.              *) ""(*  9-02-87  L. Doner  : Changed max_diag of M795XA and M795XB.    *) ""(*  9-21-89  L. Doner  : Added C220X and C2202.                    *) ""(*******************************************************************) "      VAR      temp_unit :wordtype;  
    I         :doubletype; 
    status    :boolean;      max_diag  :bytetype;   BEGIN      outbuf := 'INTERNAL DIAGNOSTIC';     putility;          writeln;     with IOBUF.EXDIAGTAREA do       begin         prompt('Input the loop count (1 <= count <= 65535)? ');          I := READNUM(1,65535,0);         display_loop( I);  #        IF I > 32767 THEN LOOPS := (-32768)+(I-32768) ELSE LOOPS := I; #    
        case device_type of 
          1 : max_diag := 6;         {7907}           2 : max_diag := 13;        {791X}           3 : max_diag := 40;        {793X}           0 : max_diag := 3;         {794X}            6 : max_diag := 1;         {EAGLE}            7 : max_diag := 4;         {795XA}            8 : max_diag := 1;         {795XB}            9 : max_diag := 0;         {C220X}            10 : max_diag := 1;        {C2202}         otherwise  
        end;  {case} 
             writeln; $        prompt('Input the diagnostic # (0 <= diag <= ',max_diag:1,')? '); $        diagnum := readnum(0,max_diag,0); 	        writeln(f); 	        writeln(f,'Diagnostic # = ',diagnum:1); 
        parmlgn := 3; 
       end;         temp_unit := unitnum;     if M794X then        begin (* 794X *)          writeln;          prompt('Input unit number? (0 - 15)? ');          comp.unitnum := readnum(0,15,0); 	        writeln(f); 	        writeln(f,'Unit number = ',comp.unitnum:1);       end   (* of 794X *)     else                   { for all other drives }  "      comp.unitnum := 15;  { diag has to be directed to controller } "         XDIAG(LU,DA,COMP,IOBUF);     status := checkqstat(true);         with iobuf.exdiagtarea do       begin          if M793X and (diagnum <> 0) then           begin             comp.unitnum := 15;             diagnum := 0;             loops := 1;              XDIAG(lu,da,comp,iobuf);             status := checkqstat(true); 
          end;  (* of IF *) 
      end;  (* of with *)         unitnum := temp_unit;  
    if describe then 
       begin  (* describe ok *)          if status then  	          ender(1) 	         else 	          ender(2); 	      end    (* of describe ok *)      else       ender(2);   (* describe failed *) 
  end;  (* of diag *) 
        
PROCEDURE ZPRESET $direct$; 
  begin     outbuf := 'PRESET DRIVE';     putility;          if preset_drive then        ender(1)      else       ender(2);   end;  (* of preset *)         PROCEDURE CACHE_STATS $direct$;  %{************************************************************************} %#{* 03-24-1987  L. Doner  :  Transfered cachetablearea to son instead of #{*                          extablearea. (Now 26 bytes) ${* 03-25-1987  L. Doner  :  Initialized Nchwrihits to 0 for old firmware. $ (* 10-03-1989  L. Doner  :  Added C2202.  %{************************************************************************} %  VAR 
    X      :bytetype; 
      BEGIN     if C2202 or EAGLE or M793X then       begin 
        clear_outbuf; 
         outbuf := 'CACHE STATISTIC TABLE';         putility;         iobuf.cachetablearea.nchwrihits := 0;         if doutil(196,2,1,7) then            begin                       (* Call EXER1 *)             for x := 0 to 25 do               buffer[x] := iobuf.cachetablearea.cachebyte[x]; $            start_child(9,prog_name.prog_int,7,device_type,LU,0,0,buffer, $                         -bufrlen);                          {7 = Disp_cache_stat_tble} 
            ender(1); 
          end          else 	          ender(2); 	      end      else        invalid_command;    end;  (* of cache_stats *)         PROCEDURE ZRDTBLS $direct$ (lu:wordtype); $(***********************************************************************) $ #(* 10-27-87  L. Doner : Added an option for the 795XB and 796XB drives # #(*                      to read all sector headers to report any spare # (*                      sectors.   (*  9-29-89  L. Doner : Moved the Spare Sector routine to Exer1.   (*                      Added C220X.  (* 10-03-89  L. Doner : Added didsparesec. $(* 10-04-89  L. Doner : Added maxtable and C2202 only reads cache table*) $$(***********************************************************************) $  VAR      x,     rte6,     maxtable, 
    tablenum    : wordtype; 
 
    didsparesec : boolean; 
      BEGIN      outbuf := 'READ DRIVE TABLES';     putility;          didsparesec := false;   {haven't read spare sectors}  	    maxtable := 1; 	     writeln;      if M794X or M791X or M7907 or M795X then 	      tablenum := 1 	     else       begin  (* C220X or EAGLE or 793X *)          writeln;         writeln('Drive tables are:');          writeln(' 1 = Spare track'); 
        if M793X then 
          begin             writeln(' 2 = Head value');              writeln(' 3 = Configuration');             writeln(' 6 = Runout');            end;         if C2202 or EAGLE or M793X then           begin              writeln(' 7 = Cache table');  
            maxtable := 7; 
           end;          writeln;          prompt('Input table #? ');          tablenum := readnum(1,maxtable,0); 	        writeln(f); 	        writeln(f,'Table # = ',tablenum:1); 	        writeln(f); 	       end;  (* of EAGLE or 793X *)          if doutil(196,2,1,tablenum) then       begin          for x := 0 to 298 do           buffer[x] := iobuf.extablerarea.tbl[x];  #          start_child(9,prog_name.prog_int,11,device_type,lu,tablenum, #                        maxhead,buffer,-bufrlen);       end     else   { failed read tables }       ender(2);         if (C220X or M795XB or EAGLE) and (tablenum = 1) then       begin          writeln;         writeln('Do you want to see the spare sectors?');          writeln;  &       writeln('(This takes approximately 16 minutes on an A-series 1000)'); &         prompt('("y" or "n") ');  
        if yesnoinput then 
        begin            didsparesec := true;  
          buffer[0] := LU; 
 
          buffer[1] := DA; 
           if rtea then 
            rte6 := 0 
           else              rte6 := 1;  #          start_child(9,prog_name.prog_int,19,device_type,rte6,maxcyl, #                      maxhead,buffer,-bufrlen);             end; {'Do you want to see spare sectors'}        end; { if C220X or M795XB or EAGLE }   if NOT didsparesec then     ender(1);      END;         PROCEDURE ZSEEK $direct$;  '(****************************************************************************) ' '(* This routine issues the Butterfly seek utility to an EAGLE disc drive.   *) ' '(* Routine is called from servo test.                                       *) ' '(****************************************************************************) ' '(* 3-3-1987  L. Doner  : Changed loop from 0-255 to 1-255 [infinite loop]   *) ' '(*                     : added time_msg                                     *) ' '(****************************************************************************) '    
  var loop :bytetype; 

      head :bytetype; 
  begin      writeln;      prompt('Input head (0 - ',maxhead:1,') or ALL? ');     head := readnum(0,maxhead,0);     if head = 255 then head := maxhead + 1;      writeln;     prompt('Input loop (1 - 255)? ');     loop := readnum(1,255,0);     time_msg;      repeat        if not doutil(177,0,1,head) then         ender(2);       loop := loop - 1; 	    until loop = 0; 	    ender(1);    end;      
PROCEDURE ZSERVO $direct$; 
 &(**************************************************************************) & &(* Implements Servo command                                               *) & &(**************************************************************************) & &(* 3-3-1987  L. Doner  :  Moved putility                                  *) & &(* 8-20-89   L. Doner  :  Moved code to son to make father smaller.       *) & (* 9-27-89   L. Doner  :  Added C220X.  &(**************************************************************************) &    var 
  numseeks : integer; 

  numloop : bytetype; 
    BEGIN  (*ZSERVO*)    outbuf:= 'SERVO TEST';   putility;    if C220X or EAGLE then     zseek    else 	    if NOT isp then 	
      invalid_command 
     else       begin          writeln;         prompt('Input the loop count (1 <= count <= 255)? ');          numloop := readnum(1,255,0);          display_loop(numloop);         time_msg;          buffer[0] := LU;          buffer[1] := DA;  "        start_child(9,prog_name.prog_int,15,device_type,numloop,0,0, "                    buffer,-bufrlen);       end;  {isp}      END;  (*ZSERVO*)     PROCEDURE ZSPAR $direct$; #(*********************************************************************) # "(* 9-02-87  L. Doner  : Added code for enhancements of the 795XB and " "(*                      the 796XB drives such as force sparing, more " !(*                      descriptive messages and error testing. It ! (*                      reports sector or track sparing.  (* 9-20-89  L. Doner  : Added locklu and unlocklu.  #(* 2-07-90  L. Doner  : Added icon and third parameter to locklu calls #  (*                      to accomodate RTE-6 locklu restrictions.  #(*********************************************************************) #   label 2;   var     spareq,      error_flg,     done,     savedata,     spare_maint :boolean;     icon,     i : wordtype;      
  begin  (* spare *) 
     outbuf := 'SPARE BLOCK';     putility;      writeln;  	    if M795XB then 	 &      writeln('795XB drives attempt to save the data of the target sector.') &     else       begin  &        writeln('WARNING: a spare retaining data does not retain the data'); &         writeln('         of the target sector.');        end;          spareblock := true;    {P1 - P10 returned after sparing}     repeat  (* repeat loop *) 
      spare_maint := false; 
	      if M7907 then 	        begin           repeat (* 7907 maint *)  
            writeln; 
             prompt('Spare maintenance track? ');              if YESNOINPUT then                begin  (* spare maint track *)                  spare_maint := true;                 iobuf.exsparetarea.option := 0;                  writeln;                 prompt('Logging or Scratch (LOG,SCR)? '); 
                read; 
 %                if inbuf = 'LOG' then IOBUF.EXSPARETAREA.OPTION := 10 else % %                if inbuf = 'SCR' then IOBUF.EXSPARETAREA.OPTION := 11 else %
                inputerror; 
               end   (* of spare maint track *)              else 
              goto 2; 
 
            writeln; 
          until iobuf.exsparetarea.option <> 0;          end  (* of 7907 maint *) 
      else   { NOT a 7907 } 
        begin  	        2:writeln; 	           if M795XB then  %            prompt('Do you want to retain the data on the target track? ') %           else  '          prompt('Do you want to retain the data on the rest of the track? '); '           if yesnoinput then             begin               savedata := true;               IOBUF.exsparetarea.option := 0;             end            else             begin                savedata := false;               IOBUF.exsparetarea.option := 1;              end;  	          getaddr; 	          COMP.addressmode:=addrmode;          end;      "    repeat                 { Loop is for force bit on 795XB drives } "      error_flg := false; 	      done := true; 	 	      if rtea then 	        icon := 1 
      else         { rte6 } 
 !        icon := 2048 + 1;    { set bit 12 for disk lock on RTE-6 } !      locklu(icon,LU,1);              { lock LU }        XSPRE(lu,da,comp,iobuf);       if IOBUF.qstat = 0 then          spareq := true        else          spareq := false;        XRQST(lu,da,comp,iobuf);  	      if rtea then 	        icon := 0        else          { rte6 }         icon := 2048 + 0;        locklu(icon,LU,1);               { unlock LU }       if checkqstat(true) then    {if Request Status worked ok}         begin            if not spareq then          {Qstat = 1 during spare} "            with IOBUF.exreqstatrarea.formatted_status.errorstatus do "	              begin 	                for i := 3 to 50 do                   if statusbits[i] then                      error_flg := true;                  for i := 52 to 63 do                   if statusbits[i] then                      error_flg := true;                  if statusbits[51] then                   begin                      writeln;  '                  writeln('Possible media wear. One or fewer spares remain.'); '                   end;                 if error_flg then                   begin                     prntstatus(IOBUF.exreqstatrarea);                     ender(2);                    end;  
              end;  {with} 
        end        else   {checkqstat is false}         ender(2);     %      if spareq or NOT error_flg then         { Qstat was good, no errors } %        with IOBUF.exreqstatrarea.formatted_status do           begin  
            writeln; 
 !            if (derrorn[0] = 1) and M795XB then   { P7 - 795XB's } !               writeln('Data at target sector was saved.');             if savedata and NOT M795XB then "              writeln('Data on the rest of the track was retained.'); "             if NOT savedata then                 writeln('Data at target track was not retained.');              if M795XB and (derrorn[3] = 0) then 	              begin 	                 writeln;  'writeln('The drive has determined that the sector does not need to be spared.' ' );                  writeln;                 prompt('Do you want to force sparing? ');                  if yesnoinput then                   begin                      done := false;                      if savedata then                        IOBUF.exsparetarea.option := 8                      else                       IOBUF.exsparetarea.option := 9; 
                  end 
 
                else 
                  done := true;               end              else               if NOT spare_maint then 
                begin 
                  writeln(F);                   writeln(F,'Spared address was:');                   prntaddr(comp.address);                   writeln(F);                    if M795XB then                     begin                        if (derrorn[3] = 1) then !                        writeln(F,'Sector sparing has completed.'); !                      if (derrorn[3] = 63) then  !                        writeln(F,'Track sparing has completed.'); !                     end;  
                end; 
          end;   {with}  	       until done; 	           writeln;       prompt('Would you like to spare another location? ');     until not yesnoinput;  (* end of REPEAT loop *)         ender(1);    end;  (* of zspar *)          PROCEDURE SELECTDC $direct$; #(*********************************************************************) #  (* 6-17-87  L. Doner : Added 795X drives to Select Device Clear.   (* 9-15-89  L. Doner : Added C220X drives to Select Device Clear.  #(*********************************************************************) #      begin     if (C220X or RSP or M795X) then       begin          outbuf := 'SELECTED DEVICE CLEAR';         putility;  $        if not preset_drive then   (* preset to store RAM log entries *) $          begin  
            writeln; 
             writeln('Warning: preset failed');            end;          XSDCL(LU,DA,COMP,IOBUF);          if checkqstat(true) then  	          ender(1) 	         else 	          ender(2); 	      end      else        invalid_command;    end;              
PROCEDURE ZSENSE $direct$; 
  var      X :bytetype;   begin     if M793X then       begin         outbuf := 'READ SENSORS';         putility;         if DOUTIL(194,2,0,0) then           begin                       (* Calls EXER1 *)              for x := 0 to 6 do               buffer[x] := iobuf.extablerarea.tbl[x];              start_child(9,prog_name.prog_int,8,device_type,0,0,0,                    buffer,-bufrlen); 
            ender(1); 
          end          else 	          ender(2); 	      end      else        invalid_command;    end;          PROCEDURE ZREV $direct$;  $(**********************************************************************) $"(* 04-21-87   L. Doner  :  Added code that checks to see if the upper " !(*                         nibble is used in location 0 (number of !"(*                         revisions to follow). If it is, 15 must be "!(*                         added to get decimal result by addition. ! (*                         Simplified For loops.  $(**********************************************************************) $      var     I:wordtype;   begin  
    if M7907 or M794X then 
      invalid_command 
     else       begin         outbuf := 'READ REVISION NUMBER';         putility; 	        writeln(F); 	         if DOUTIL(195,2,0,0) then with IOBUF.EXREVRAREA do           begin              writeln(F,' Part   Revision');             writeln(F,'number   number');              writeln(F,'------  --------');             if (REV[0].A <> 0) then               for I := 1 to ((REV[0].A + 15) + REV[0].B) do                  writeln(F,I:4,'    ',REV[I].A:2,' - ',REV[I].B:2)               else               for i := 1 to REV[0].B do  !                writeln(F,i:4,'    ',REV[i].A:2,' - ',REV[i].B:2); !
            ender(1); 
          end          else 	          ender(2); 	       end;    end;     
PROCEDURE ZRFSECT $direct$; 
$(***********************************************************************) $!(* 04-21-87  L. Doner  :  Added check for firmware revision on 791X ! $(*                        drives. Prior to 5.0 RFSECT was not supported. $(* 09-19-89  L. Doner  :  Added C220X. Pass phy_sec to Exer1. $(***********************************************************************) $      var      x, 
    phy_sec     : wordtype; 
 
    good_rfsect : boolean; 
      begin     if ISP then 
      invalid_command 
     else       begin         outbuf := 'READ FULL SECTOR';         putility;          if C220X or EAGLE then           eagle_rfsector := true; 	        writeln(F); 	 $        if C220X or EAGLE then  {getting on track for Read Full command} $          begin              comp.unitnum := 0;             comp.setlength := 1; {yes, I am setting the length}               comp.length := 0; {0 length read for C220X & Eagle }              XLCRD(lu, da, comp, iobuf);              if NOT checkqstat(true) then               ender(2);            end;          getaddr;         comp.addressmode := addrmode;          if C220X or EAGLE then           begin             with iobuf.eaglerfarea do 	              begin 	                utilnum := 163;                  utiltype := 2;                 parmlgn := 6;                  address.cylinder := comp.address.cylinder;                  address.head     := comp.address.head; %                address.sector   := comp.address.sector;  {physical sector} %                 phy_sec          := comp.address.sector;                  msg_len          := 300;                 comp.address.sector := 0;                  XUTIL(lu,da,comp,iobuf);                 good_rfsect:= checkqstat(true);  	              end; 	          end          else            if (M791X and (rrev < 5.0)) then  	             begin 	               writeln;  '  writeln(f,'Read Full Sector was not implemented on firmware prior to 5.0 '); '"               writeln(f,'on 791X drives. Check firmware revision.'); "                ender(2);               end            else              good_rfsect:= DOUTIL(192,2,0,0); 
        if good_rfsect then 
          begin              (***************************************************)               (* store data in transfer buffer for child program *)               (***************************************************)               for X := 0 to 279 do               buffer[X] := iobuf.extablerarea.tbl[X];              for X := 280 to 285 do               buffer[X] := comp.address.full_addr[X-280];             (***************************************)             (*   Parms:                            *)             (*     (1) command number(12)          *)             (*     (2) device type                 *)             (*     (3) addrmode                    *)             (*     (4) physical sector             *)             (*     (5) unused                      *)             (***************************************)             { 9 = Immediate schedule with wait}  
            {12 = zrfsect} 
"            start_child(9,prog_name.prog_int,12,device_type,addrmode, "                        phy_sec,0,buffer,-bufrlen); 
            ender(1); 
          end          else 	          ender(2); 	       end;  
end;       {zrfsect} 
        PROCEDURE ZUNIT $direct$;  
 var temp: wordtype; 
  begin      outbuf := 'SET UNIT NUMBER';     putility;          writeln;  
    temp := UNITNUM; 
    prompt('Input the unit # (0 <= unit <= 15)? ');     UNITNUM := READNUM(0,15,0);      writeln(F);  (* cr/lf *)  
    if describe then 
      writeln(F,'Unit Selected = ',UNITNUM:1)      else       begin 	        writeln(F); 	         writeln(F,'Unit ',UNITNUM:1,' was NOT selected.');          unitnum := temp;         ender(2);        end;     ender(1); 
  end;  (* of UNIT *) 
        PROCEDURE ERT $direct$(readonly:boolean);      $(**********************************************************************) $ $(* 03-05-87  L. Doner : Added Time_msg prior to inputting loop count. *) $ $(* 06-12-87  L. Doner : Added Print Option and Log Option messages to *) $ $(*                      outfile. Fixed bug in code; comparison of     *) $ $(*                      offset to parm2 failed because one was in the *) $ $(*                      2's complement and the other the unsigned byte*) $ $(*                      version. Compare on Outfrm instead. Made minor*) $ $(*                      changes to the screen format. Sent a code to  *) $ $(*                      Log_header to print 'Loop' above 'Count'.     *) $ $(* 07-08-87  L. Doner : No longer a choice on parity error bit = 0.   *) $ $(* 10-19-88  L. Doner : Added max_offset. 7911, 7912 = 7; 7914 = 4;   *) $ $(*                      793X's = 63;                                  *) $ $(* 09-25-89  L. Doner : Added C220X.                                  *) $ $(**********************************************************************) $      VAR      i,     inum,     code,     area,      pattern,     outfrm,     loop_cnt,      count,     utltype        :bytetype;     offset         :wordtype;     max_offset     : integer;      data_displayed :boolean;        PROCEDURE init_iobuf $direct$;   begin     with iobuf.exmisctarea do       begin          utilnum := code;          utiltype := utltype;          exlgn := 1024;   (* check into this value *) 
        parmlgn := 3; 

        if count = 255 then 
          parm1:=count      {inf chosen for loop count}          else  %          parm1 := 1;       {this is for Breaking at the end of each loop} % $        parm2 := offset;    { or parity error or frame error detect bit} $         parmx[0] := outfrm;  {report type (no message = log) }         if code < 202 then   { not random }           begin             parmx[1] := area;             parmlgn := 4;            end;          if not((code=201) or (code=204)) then   { not read only }            begin             if parmlgn=4 then               parmx[2]:=pattern              else                parmx[1]:=pattern;             parmlgn := parmlgn + 1;            end;        end;    end;       begin   {ert}  
    if readonly then 
       outbuf := 'RO ERT'      else  
      outbuf := 'WTR ERT'; 
    putility;          if not readonly then       begin          writeln;         ruin;        end;         (*********************************)     (* preset drive to store off ram *)     (*********************************)      if not preset_drive then       begin          writeln;          writeln('Warning: preset failed');        end;          writeln;      (**********************)      (* Clear the ERT logs *)      (**********************)     prompt('Clear the ERT logs? ');      if yesnoinput then       begin  '        if not doutil(205,0,1,1) then   (* 205 Utility to Clear the ERT logs*) '	          ender(2); 	       end;     time_msg;      writeln;       prompt('Input the loop count (1 <= count <= 254 or INF)? ');       count := readnum(1,254,0);      display_loop(count);  
    if readonly then 
      begin  (* RO ERT *)          writeln;          writeln('Types of Read Only ERTs:');         writeln('  P = selected area Pattern');         writeln('  R = Random area');              repeat  	          writeln; 	          prompt('Enter the type of test? ');  
          code := 0; 
          read; 
          writeln(f); 
          write(f,'RO test type = '); 
          case firstchar of 
            'P': begin code := 201;                     writeln(f,'P') end;             'R': begin code := 204;                     writeln(f,'R') end;             otherwise inputerror;            end;          until code <> 0;   (* end of repeat *)       end      else       begin (* WTR ERT *)          writeln;          writeln('Types of Write Then Read ERTs:');         writeln('  P = Pattern test WTR ERT.');         writeln('  R = Random address WTR ERT.');          IF (M791X or M793X) then           writeln('  S = Short WTR ERT');              repeat  	          writeln; 	          prompt('Enter the type of test? ');  
          code := 0; 
          read; 
          writeln(f); 
 	          writeln; 	           write(f,'WTR test type = '); 
          case firstchar of 
            'P': begin code := 200;                     writeln(f,'P') end;             'R': begin code := 203;                     writeln(f,'R') end;              'S': begin                     writeln(f,'S');  "                   if C220X or EAGLE or M795X or M794X or M7907 then "                     inputerror                    else                      code := 202; 
                 end; 
            otherwise inputerror;            end; (* of case *)         until code <> 0;  (* end of repeat *)        end;  (* of WTR ERT *)          IF (code=201) or (code=200) THEN       begin  (* non-random ERT *)          getaddr;          writeln;          writeln('Do you want to test the:');          writeln('  V = volume');         if C220X or RSP or M795X then           begin              writeln('  H = head');              writeln('  C = cylinder');            end;         writeln('  T = track');          writeln('  S = sector');  
        area := 255; 
         repeat  	          writeln; 	           prompt('Test area? ');           read; 
          writeln(f); 
           write(f,'Test area = '); 
          case firstchar of 
             'V': begin                    area := 4;                     writeln(f,'V'); 
                 end; 
             'H': if M794X or M7907 then inputerror 
                 else begin 
                         area := 3;                         writeln(f,'H');  
                      end; 
             'C': if M794X or M7907 then inputerror  
                else begin 
                       area := 2;                         writeln(f,'C');                      end;              'T': begin                    area := 1;                     writeln(f,'T'); 
                 end; 
             'S': begin                    area := 0;                     writeln(f,'S'); 
                 end; 
            otherwise inputerror;            end; (* of case *)         until area <> 255;  (* end of repeat *)       end;  (* of non-random ERT *)      &    if C220X or EAGLE or ISP then           { Eagle = Parity error bit - 0 } & &      offset := 0;                    { C220X = Frame error detect bit - 0 } &!                                      { Second parameter to ERT's } ! 
    if M791X or M793X then 
      begin          writeln;         prompt('Do you want to use head offset? ');  
        if yesnoinput then 
          begin               if ((prodnum[4] = 1) and (prodnum[5] IN [1,2])) then                 max_offset := 7;             if ((prodnum[4] = 1) and (prodnum[5] = 4)) then                max_offset := 4;             if M793X then               max_offset := 63;  
            writeln; 
 '            prompt('Input offset (-',max_offset:1,' <= offset <= ',max_offset: ' 
                   1,')'); 
             offset := readnum(-(max_offset),max_offset,0);           end          else            offset := 0;        end;         if not((code=201) or (code=204)) then       begin (* WTR ERT *)          writeln;         writeln('Sources of the bit pattern are:');          writeln('  I = Internal pattern table');          writeln('  R = Random pattern');         writeln('  U = User selected pattern');              repeat  	          writeln; 	          prompt('Enter the pattern source? ');           pattern := 255;           read; 
          writeln(f); 
          write(f,'Pattern source = '); 
          case firstchar of 
            'I' : begin #                    pattern := 0;   { C220X's will start with Table A } #                    writeln(f,'I');                    end;             'R' : begin                     if ISP then                        pattern := 8                      else                       pattern := 2;                     writeln(f,'R');                    end;             'U' : begin                     pattern := 1;                     writeln(f,'U');                    end;             otherwise inputerror;           end;  (* of case *)         until pattern <> 255;  (* end of repeat loop *)              if pattern = 1 then         { User defined pattern }            if C220X or RSP then             begin               with IOBUF.EXMISCTAREA do 
                begin 
                  upattern[1] := readpattern;                   for i := 2 to 16 do                     upattern[i] := upattern[1];                    exlgn := 64;                   parmlgn := 0;                    utiltype := 1;                   utilnum := 209;  
                end; 
                   XUTIL(lu,da,comp,iobuf);                if not checkqstat(true) then 
                begin 
"                  writeln('Device did not accept the user pattern.'); "
                  ender(2); 
 
                end; 
             end  (* of 793X or 791X or EAGLE or C220X *)            else             begin  (* 794X, 795X or 7907 pattern *)                writeln;               writeln('Available patterns are:'); 
              if M794X then 
                begin 
                  writeln('  1 = DB6');                   writeln('  2 = 924');                    writeln('  3 = DA');                    writeln('  4 = 17');                    writeln('  5 = AA');                    writeln('  6 = FF');                    writeln('  7 = 00');  
                end; 

              if M795X then 
                begin 
                  writeln('  1 = 39CE7');                   writeln('  2 = C30');                   writeln('  3 = 30E61CC3987');                   writeln('  4 = B8F32E3CC');                    writeln('  5 = CC');                   writeln('  6 = DB6');                   writeln('  7 = 33F94CFE5');  
                end; 

              if M7907 then 
                begin 
                   writeln('  1 = CD');                    writeln('  2 = E739');                    writeln('  3 = 33');                    writeln('  4 = DB6DB6');                    writeln('  5 = 4933');                    writeln('  6 = FF');                    writeln('  7 = 00');  
                end; 
                   writeln;               prompt('Input pattern number: ');                pattern := readnum(1,7,0);               writeln(f);               writeln(f,'Pattern number = ',pattern:1);             end;  (* of 7907 or 794X pattern *) 
      end; (* of WTR ERT *) 
         writeln;     writeln('Output formats are:');     writeln('  P = print error information');     writeln('  L = log in error rate log');      repeat        writeln;       prompt('Enter the format? ');  
      outfrm := 255; 
      read;       writeln(f);       case firstchar of 	         'L': begin 	                 outfrm := 0;    (* Short error report *)                  utltype := 0;   (* 0 = no execution message *)                  writeln(f,'L option : Log in error rate log');  	              end; 		         'P': begin 	                outfrm := 1;    (* Long error report *)                  utltype := 2;   (* 2 = device send text *)                   writeln(f,'P option : Print error information');   	              end; 	          otherwise inputerror;       end;  (* of case *)         until outfrm <> 255;   (* end of repeat loop *)         if M7907 then with IOBUF.EXMISCTAREA do       begin  (* 7907 *)         utilnum  := 201; (* RO ERT *)         utiltype := 0;   (* no execution msg *)          parmlgn  := 4;   (* four parms sent *)          parm1    := 1;   (* count *)         parm2    := 0;   (* offset *)          parmx[0] := 0;   (* report type *)         parmx[1] := 0;   (* test area - sector *)         exlgn    := 0;   (* execution msg length *)     $        xutil(lu,da,comp,iobuf);   (* send RO ERT ck for write protect *) $        if not checkqstat(false) then            with iobuf.fstatus.formatted_status.errorstatus do              begin  (* check for write protect *)                if statusbits[36] then                 begin (* write protected *)                   writeln;  (* cr/lf *)                    if (code = 201) or (code = 204) then                      begin (* RO ERT's *)                       if utltype = 0 then  (* log errors *)                         begin $                          writeln('Write protected - cannot log errors'); $                          ender(2); 
                        end 
 
                      else 
                        begin  %                          writeln('Write protected - cannot update logs'); %                         end;                     end (* of RO ERT's *)                    else                     begin (* WTR ERT's *)                        writeln('Disc write protected');                       ender(2);                     end;  (* WTR ERT's *)                  end   (* of write protected *)  	              else 	
                begin 
                   prntstatus(iobuf.fstatus); 
                  ender(2); 
 
                end; 
             end;  (* of check for write protect *)       end;  (* of 7907 *)         if code < 202 then     { not random }       comp.addressmode := addrmode;      data_displayed := false;  	    line_cnt := 5; 	 	    loop_cnt := 0; 	     repeat       loop_cnt := succ(loop_cnt);       init_iobuf;        xutil(lu,da,comp,iobuf);        { do the ERT }        if not checkqstat(true) then         ender(2);       with iobuf.exmisctarea do #        if (utiltype<>utltype) or (parm1<>1) or (parmx[0]<>outfrm) then #           begin   (* error detected *)              if not data_displayed then 	              begin 	
                writeln(F); 
                buffer[1] := 99;  {99 = print 'LOOP'} 
                log_header; 
                data_displayed := true;  	              end; 	            for inum := 0 to 8 do                info[inum] := iobuf.exertrarea.data[inum];              info[9] := loop_cnt;             line_cnt := succ(line_cnt);              if more_lines then                error_log(198)              else                loop_cnt := count;            end;           if breakflag then  
        loop_cnt := count; 
     until loop_cnt >= count;      
    if data_displayed then 
      begin 	        writeln(F); 	        prt_error_info(198);   (* print ERT error info *)        end;      if checkqstat(true) then       ender(1);    end;  (* of ERT's *)     "(*******************************************************************) ""(* THIS PROCEDURE WILL CHECK THE LU THAT WAS READ IN  AGAINST THE  *) ""(* LIST OF VALID CS80 LU'S ON YOUR SYSTEM. WHEN THE LU IS VERIFIED *) ""(* THE ASSOCIATED HPIB ADDRESS IS ASSIGNED TO THAT LU FOR FURTHER  *) ""(* CALLS REGUIRING LU # and HPIB ADDRESS.                          *) ""(*******************************************************************) " FUNCTION LUVERIFY :boolean $direct$;      	var  i : wordtype; 	       begin (* LUVERIFY *)     i := 1;     luverify := false ;     for I := 1 to 63 do       begin         if lubuf[I].lunum = LU then           begin                luverify := true ;                DA := lubuf[I].hpib;            end;        end;    end;  (* LUVERIFY *)          &(**************************************************************************) & &(* THIS PROCEDURE PERFORMS A BUBBLE SORT ON THE VECTOR OF                 *) & &(* CS/80 LUS, SORTING ON SELECT CODE.  BY CONSTRUCTION, THE LUS ARE       *) & &(* ALREADY ARRANGED IN ASCENDING ORDER.                                   *) & &(**************************************************************************) &PROCEDURE SORTLU $ direct $ (maxlu : wordtype);  #var    temp: ludatatype;           (* holding variable for swapping *) #        i,j: wordtype;              (* iteration variables *)     	begin  (* SORTLU *) 	   for i := 1 to maxlu do        for j := 1 to (maxlu-i) do begin  !           if (lubuf[J].scode[1] > lubuf[J+1].scode[1]) then begin !                temp := lubuf[J];                 lubuf[J] := lubuf[J+1];                 lubuf[J+1] := temp;            end else begin                if (lubuf[J].scode[1] = lubuf[J+1].scode[1]) #               and (lubuf[J].scode[2] > lubuf[J+1].scode[2]) then begin #                    temp := lubuf[J];                     lubuf[J] := lubuf[J+1];                     lubuf[J+1] := temp; 	               end; 	           end;        end; 	end;   (* SORTLU *) 	        %(*************************************************************************) %%(*     THIS PROCEDURE LISTS TO OUTPUT DEVICE ALL CS/80 LUS GROUPED       *) %%(*     IS ASCENDING ORDER BY SELECT CODES                                *) %%(*************************************************************************) % PROCEDURE LISTLU $direct$ (maxlu :wordtype);     
  var    I,k    : wordtype; 

         cur_sc :scodetype; 
     
 begin  (* LISTLU *) 
    I := 1;  	   cur_sc[1] := 0; 	 	   cur_sc[2] := 0; 	   writeln;    writeln('*********  CS80 LU s  ************');    writeln('Sel Code   LU #   HPIB Addr   Unit');    writeln('========   ====   =========   ====');    line_cnt:=8;    while (I <= maxlu) and more_lines do       begin        with lubuf[I] do           begin "           if (cur_sc[1] <> scode[1]) or (cur_sc[2] <> scode[2]) then " 	             begin 	               writeln;                for k := 3 downto 1 do write(' ');                 write(scode[1]:1,scode[2]:1);                cur_sc[1] := scode[1];                cur_sc[2] := scode[2];               end            else              for k := 5 downto 1 do write(' ');            for k := 7 downto 1 do write(' ');  
           write(lunum:2); 
           for k := 7 downto 1 do write(' ');            write(hpib:2);            for k := 8 downto 1 do write(' ');             line_cnt:=succ(line_cnt); 
           writeln(unit:2); 
          end;  (* of with *)         i := i+1;       end; (* of while *)  end;   (* of listlu *)         &(***************************************************************************) &&(*   THIS PROCEDURE ACCUMULATES THE LU NUMBERS and SELECT CODES OF ALL     *) &&(*   CS/80 DEVICES AVAILABLE TO THE USER and THEN CALLS THE PROCEDURES     *) &&(*   "SORTLU" and "LISTLU" TO SORT THE DATA and LIST THE DATA TO THE       *) &&(*   LIST DEVICE IN A USEFUL FORMAT.                                       *) &&(***************************************************************************) &PROCEDURE CS80LUS(var maxlu: integer) $direct$; &(***************************************************************************) &&(*                                                                         *) &&(***************************************************************************) &    #TYPE WORD_BYTE_TYPE = RECORD                                 (* RTE6 *) #                        CASE INTEGER OF "                        1 : (BYTE : packed array [1..2] OF bytetype); "                        2 : (WORD : wordtype ); "                        3 : (QUAD : packed array [1..4] OF QUADTYPE); "                         END;      !VAR    LU     : LUTYPE;          (* LU NUMBER WITH SIGN BIT SET *) !        CTYPE,                    (* CHARACTER CODE FOR LU TYPE *)          NTYPE,                    (* NUMBER CODE FOR LU TYPE *)         I,J    : wordtype;        (* ITERATION VARIABLES *) "       STAT1,                    (* STATUS VARIABLES FOR EXEC CALL *) "$       STAT2  : SELCOTYPE;       (* STATUS VAR. TO CONTAIN SELECT CODE *) $$       STAT3  : wordtype;        (* STATUS VAR. TO CONTAIN HPIB ADDR   *) $ &       STAT4  : TAPEUNITTYPE;    (* STATUS VAR. TO DETERMINE IF TAPE UNIT *) &       os     : wordtype;        (* RTE6 *)        dum1   : wordtype;        (* RTE6 *)        dum2   : wordtype;        (* RTE6 *)        newlu  : wordtype;        (* RTE6 *)        table  : track_type;      (* RTE6 *)         convert_hpib : word_byte_type;     (* RTE6 *)      
BEGIN  (* CS80LUS *) 
    I := 1;     FOR J := 1 TO 63 DO       BEGIN        IF (LUTRU(J) <> -1) THEN           BEGIN 
           LU.SIGNBIT := 1; 
 
           LU.NUMBER := J; 
           CTYPE := LDTYP(LU, NTYPE);            IF (NTYPE = 240) OR (NTYPE = 640) THEN  	             BEGIN 	               lubuf[I].LUNUM := J;                 os := which_os;                if (os <= -1) and (os >= -17) then                   begin                    RTEA := false;                     getscode(13,J,stat1,stat2,stat3,stat4);                    lubuf[I].scode := stat2.selcode;  #                   newlu := J + 1152;  (* subFUNCTION 22, get table *) #                   get_trackmap(1,newlu,table,8,dum1,dum2);                     convert_hpib.word := 0;                    convert_hpib.byte[2] := table.hpib[2];                     lubuf[I].hpib := convert_hpib.word;                     convert_hpib.word := 0;                    convert_hpib.byte[1] := table.unit[1];                    lubuf[I].unit := convert_hpib.quad[2];                     I := I + 1;  
                 end 
 
                else 
                 if (os <= -33) and (os >= -128) then                     begin                       RTEA := true;  "                     GETscode(13, J, STAT1, STAT2 , STAT3 , STAT4 ); "                     lubuf[I].scode := STAT2.SELCODE;                      lubuf[I].HPIB  := STAT3;                       lubuf[I].UNIT  := STAT4.UNIT;                       I := I+1;                     end                    else  !                   writeln('Illegal OP system - contact support'); !             end;          end;      end;     MAXLU := I-1;    SORTLU(MAXLU);    LISTLU(MAXLU);  
end;   (* CS80LUS *) 
         PROCEDURE ZCACHE_CONTROL $direct$ (option:wordtype);  '(****************************************************************************) '&(* 3-6-1987  L. Doner    Original version                                  *) & '(* 1-26-1988  L. Doner   Moved code to son because father was too large.    *) ' '(****************************************************************************) ' '(* OPTION : Parameter passed to this PROCEDURE to indicate utility required.*) '(* ------ (*      1 : Read Cache On  
(*      2 : Read Cache Off 
 
(*      3 : Write Cache On 

(*      4 : Write Cache Off 
(*      5 : Read and Write Cache On   (CACHEON)  (*      6 : Read and Write Cache Off  (CACHEOFF)  '(****************************************************************************) '    BEGIN       if C2202 or EAGLE or M793X then     begin        buffer[0] := LU;        buffer[1] := DA;             start_child(9,prog_name.prog_int,9,option,addrmode,0,0,                     buffer,-bufrlen);     end    else  
    invalid_command; 
    
END;       {zcache_control} 
        PROCEDURE ZRESET_STATS  $direct$; %(*************************************************************************) %%(*  9-23-89   L. Doner  : Added C2202.                                   *) %%(*************************************************************************) %      begin     if C2202 or EAGLE or M793X then       begin         outbuf := 'CLEAR CACHE STATISTICS';         putility; 	        writeln(F); 	         prompt('Clear Cache Statistic Table? ');  
        if YESNOINPUT then 
          begin             if DOUTIL (208, 0, 0, 0) then                ender(1)              else               ender(2);           end          else 	          ender(3); 	      end      else        invalid_command;    end;     PROCEDURE ZLOGCACHE $direct$; #(*********************************************************************) ##(*  9-1-89   L. Doner  :  Moved code to son, EXER1.                  *) ##(*********************************************************************) #    BEGIN   outbuf := 'READ CACHE ERROR LOG';   putility;      	  buffer[0] := LU; 	 	  buffer[1] := DA; 	   start_child(9,prog_name.prog_int,16,device_type,0,0,0,               buffer,-bufrlen);      END;      
PROCEDURE ZINPUT $direct$; 
$(***********************************************************************) $(* 11-30-1987  L. Doner : Added file name messages. $(***********************************************************************) $var   i:wordtype;     begin    writeln;    writeln('The Input File or LU is ', infile);    writeln; $  writeln('CI allows file names up to 16 characters plus a 4 character ', $           'extension.'); "  writeln('FMGR allows 6 character file names. (It will truncate.)'); "   writeln;    prompt ('Enter new Input File or LU: ');   read;   for i:=1 to 64 do      { clear infile } 	    infile[i]:=' '; 	   infile:=inbuf;   close(input);    reset(input,infile);  end;     
PROCEDURE ZOUTPUT $direct$; 
 $(**********************************************************************) $(* 11-30-1987  L. Doner  :  Added file name messages.  $(**********************************************************************) $var   i:wordtype;     begin    writeln;    writeln('The Output File or LU is ', outfile);    writeln; $  writeln('CI allows file names up to 16 characters plus a 4 character ', $           'extension.'); "  writeln('FMGR allows 6 character file names. (It will truncate.)'); "   writeln;   prompt ('Enter new Output File or LU: ');   read;    for i:=1 to 64 do    { clear outfile }  
    outfile[i]:=' '; 
  outfile:=inbuf;    rewrite(f,outfile,'shared');  end;     PROCEDURE ZTERM $direct$; var   i:wordtype; begin 	  for i:=1 to 64 do 		    infile[i]:=' '; 	  infile[1]:='1';  	  outfile:=infile; 	  close(f);   close(input);    close(output);  
  rewrite(f,infile); 
   reset(input,infile);  
  rewrite(output,outfile); 
   writeln;    writeln('Input/Output is Terminal');  end;         PROCEDURE SET_CE_MODE $direct$; begin   if ce_mode then  	    ce_mode:=false 	   else  	    ce_mode:=true; 	 end;           FUNCTION WRONG (VAR describe_ok : boolean) : boolean   $direct$;   $(**********************************************************************) $!(* 11-16-87  L. Doner :  This FUNCTION checks the block size of the !(*                       selected LU. It returns the following:  (*                       true : Not a valid CS80 device. (*                       false : A valid CS80 device. (* 10-03-89  L. Doner :  Added C220X.  $(**********************************************************************) $    var     lu_print : boolean;     begin   wrong := false;  
  lu_print := false; 
   if describe then        {if describe is true, it worked ok }     begin  
      describe_ok := true; 
      set_device_flags(lu_print); 	      if C220X then 	        if (maxblock <> 2619791) and (maxblock <> 1309895) then            wrong := true; 	      if EAGLE then 	        if (MAXBLOCK <> 2232203) and (MAXBLOCK <> 1201955) then            wrong := true; 	      if M793X then 	        if (MAXBLOCK <> 1579915) then            wrong := true; 	      if M791X then 	$        if (MAXBLOCK <> 109823) and (MAXBLOCK <> 256255) and (MAXBLOCK <> $           516095) and (MAXBLOCK <> 64749) then            wrong := true; 	      if M794X then 	         if (MAXBLOCK <> 92927) and (MAXBLOCK <> 216831) then            wrong := true; 	      if M795X then 	$        if (MAXBLOCK <> 319094) and (MAXBLOCK <> 510551) and (MAXBLOCK <> $ %           319787) and (MAXBLOCK <> 594215) and (MAXBLOCK <> 1188431) then %           wrong := true;      end  { if describe }    else     describe_ok := false; end;  { Wrong }          FUNCTION GET_COMMAND $direct$ : cmds_type; var    workcmd:packed array[1..maxichar] of char;  	  c,cmd:cmds_type; 	  i:wordtype;    match,   unique:boolean;     begin   match:=false;   unique:=true;  
  c:=non_unique_cmd; 
   repeat      c:=succ(c);     {each successive command from cmd_array}      workcmd:='                ';  
    for i:=1 to cmd_len do 
      workcmd[i]:=cmd_array[c,i];  %    if inbuf = workcmd then  {if this is the command the user chose, then} %	      if match then 	
        unique:=false 
       else         begin            match:=true;           cmd:=c;          end;    until (c = wtr_ert) or not unique;  #  if unique and match then              {User entered a valid command} #    begin       if not ce_mode and (cmd in ce_mode_cmds) then          get_command:=needs_ce_mode  !       else                  {It is a proper command for the mode} !        begin           if (cmd = ce_mode_cmd) then             begin               if inbuf = 'CE MODE' then                  get_command:=cmd 	               else 	                 get_command:=bad_cmd;       {Not a valid command}              end            else             get_command:=cmd;          end;     end    else  	    if unique then 	       get_command:=bad_cmd     {Not a valid command}      else        get_command:=non_unique_cmd;  end;      PROCEDURE ZCHANGE_LU $direct$; $(***********************************************************************) $ !(* 04-21-87  L. Doner  :  Added code that reads the smallest drive ! #(*                        revision and stores it in global parm, rrev. # #(*                        This will be used by utilities that are only ##(*                        implemented for certain revisions of firmware #(*                        such as RFSECT.  #(*  9-2-87   L. Doner  :  Added boolean variable lu_print to send as a #(*                        parameter to set_device_flag.  #(* 11-11-87  L. Doner  :  Added call to Wrong to check block sizes for #!(*                        valid CS80 devices. Added boolean 'pass'. !#(*  9-1-89   L. Doner  :  Added parm3flag. Will check for a third para- # $(*                        meter in the run string and will set parm3flag $ $(*                        to -99 during call to readnum. Also, check for $ %(*                        bad describe or wrong to halt if infile is used. % %(* 10-12-89  L. Doner  :  Added break. Had to reboot every time device was %(8                        hung. %(*************************************************************************) %    var   lu_print,   pass,    break,    describe_ok : boolean;   i : wordtype;  	  tempreal : real; 	   parm3flag,    revcount : wordtype;     begin  
  cs80lus(MAXNUMLU); 

  describe_ok:=false; 
  pass := true;   break := false;    repeat      writeln;     prompt('Input DRIVE LU? '); 	    exitflag:=true; 	 $    if (parm3 = -1) or (parm3 = 0) then   {no parameter 3 in run string} $ 
      parm3flag := 0 
#    else                    {there was a third parameter in run string} #      begin         inbuf := '                     ';  
        for i := 1 to 3 do 
&          inbuf[i] := buf64[i]; {put the value of parm3 in inbuf for readnum} &        parm3flag := -99;        end;      lu := readnum(-99,maxnumlu,parm3flag);      writeln;      if not luverify then       writeln('LU is not a valid CS80 device.')      else       begin         comp:=nullcomp;          spareblock := false;         print_paddr := false;          xcncl(lu,da,comp,iobuf);          unitnum  := 0;          addrmode := 0;          if wrong(describe_ok) then           begin              writeln('LU is not a valid CS80 device.');  
            pass := false; 
           end;         if not describe_ok then  "          writeln('Error on initial describe, please check drive.'); "       end;     if ((NOT describe_ok OR NOT pass) and (infile<>'1')) then        halt(0);     if (ifbrk < 0) then  
      break := true; 
   until ((describe_ok and pass) or break);        if break then halt(0);     	  lu_print := true; 	  set_device_flags(lu_print); &                 (* Copy drive revision into global parm for utility calls *) &  if (not M7907 and not M794X) then     if (doutil(195,2,0,0)) then  with IOBUF.EXREVRAREA do       begin         rrev := (REV[1].A + (REV[1].B / 10));         if (REV[0].A <> 0) then            revcount := ((REV[0].A + 15) + REV[0].B)          else           revcount := REV[0].B;         for i := 1 to revcount do           begin             tempreal := (REV[i].A + (REV[i].B / 10));             if (tempreal < rrev) then               rrev := tempreal;            end;       end      else         writeln(f,'Error occured while checking drive revision.');     (**********************************************)    (* insure removable cartridge is default unit *)    (**********************************************)   if M7907 then     unitnum := 1;   write('Current unit = ',unitnum:1);    if M7907 then write(' (removable)');    writeln;  end;      PROCEDURE CACHE_SIZE $direct$; %(*************************************************************************) %(*  9-27-89  L. Doner  :  Creation. %(*************************************************************************) %    VAR 	  csize : wordtype; 	    BEGIN   if C2202 then     begin        outbuf := 'SET READ CACHE SIZE';       putility;      "      writeln('**************************************************'); " "      writeln('*                  CAUTION                       *'); " "      writeln('*  This command may affect system performance.   *'); " "      writeln('**************************************************'); "       writeln;        prompt('Do you wish to continue? (Y/N) ');        if yesnoinput then         begin  	          writeln; 	          writeln('Read Cache Page Sizes :');            writeln('  2 - 4096 bytes');            writeln('  3 - 8192 bytes');           writeln('  4 - 16384 bytes');           writeln('  5 - 32768 bytes');           prompt('Input cache size (2 <= size <= 5) : ');            csize := readnum(2,5,0);      
          buffer[0] := LU; 
 
          buffer[1] := DA; 
 "          start_child(9,prog_name.prog_int,18,device_type,csize,0,0, "
          buffer,-bufrlen); 
 	        end; {yes} 	 	    end    {C2202} 	   else  
    invalid_command; 
 END;      &(**********************************MAIN************************************) &    BEGIN  {EXER}    position := 3;    len := 64;  $  parm3 := getparms(position, buf64, len);  {get third parameter in the} $                                            {run string.}   infile := getfilename(input);   outfile := getfilename(output);    rewrite(output,'1');    rewrite(f,outfile,'shared'); 	  ce_mode := false; 	  clear_outbuf;  $  ce_mode_cmds := [amclear,clear_logs,init_media,sdclear,spare,wtr_ert]; $   write('HP1000 CS/80 EXERCISER -- ');  
  writeln(rev_code); 
   prog_name.prog_char := 'EXER1';  {child program}   zchange_lu; 
  breakflag := false; 
   repeat     0:comp := nullcomp;      if (ifbrk < 0) or breakflag then       begin 
        infile:='1 '; 
         reset(input,infile);         breakflag:=false;        end;      comp.unitnum := unitnum;      eagle_rfsector := false;      spareblock := false;      writeln; 	    if ce_mode then 	       prompt('CE EXER>')      else        prompt('EXER>'); 
    exitflag := true; 
     read;                {Get command from user}      exitflag := false; $    parm3 := -1;         { let them change the LU if there was originally $                            a third parameter }      case get_command of   {all commands}  "      needs_ce_mode   : writeln('Command requires CE Capabilities'); "      bad_cmd         : writeln('Unknown Command');        non_unique_cmd  : writeln('Partial Command is not Unique');        change_lu       : zchange_lu;       amclear         : zamclear;        cache_log       : zlogcache;        cacheon         : zcache_control(5);        cacheoff        : zcache_control(6);       cachesize       : cache_size;        cache_stat      : cache_stats;        cancel          : zcancel;        ce_mode_cmd     : set_ce_mode;       ciclear         : zchinclr;        clear_logs      : zclearlog;        descri          : zdescribe;       diag            : zidiag;        ert_log         : zdatalog(198); {     event_log       : zeventlog;}        fault_log       : zfltlog;        help            : zhelp;       init_media      : zfrmat;       input_it        : zinput;        output_it       : zoutput;        preset          : zpreset;       print_physica   : phys_print;        readcacheon     : zcache_control(1);        readcacheoff    : zcache_control(2);       reqstat         : zrequeststat;       reset_stats     : zreset_stats;       rev             : zrev;        rf_sector       : zrfsect;        ro_ert          : ert(true);        run_log         : zdatalog(197);       sdclear         : selectdc;       sense           : zsense;       servo           : zservo;        spare           : zspar;        term            : zterm;        tables          : zrdtbls(lu);        unit            : zunit;        writecacheon    : zcache_control(3);        writecacheoff   : zcache_control(4);       wtr_ert         : ert(false);     end; {case}    until false;  end. 