 $PASCAL '92084-1X804 REV.5020 <890925.1501>'  !{****************************************************************  ! !*                                                               *  ! !*  (C) COPYRIGHT HEWLETT-PACKARD COMPANY 1981. ALL RIGHTS       *  ! !*  RESERVED. NO PART OF THIS PROGRAM MAY BE PHOTOCOPIED,        *  ! !*  REPRODUCED OR TRANSLATED TO ANOTHER PROGRAMMING LANGUAGE     *  ! !*  WITHOUT THE PRIOR WRITTEN CONSENT OF THE HEWLETT-PACKARD     *  ! !*  COMPANY.                                                     *  ! !*                                                               *  ! !*****************************************************************  ! *   	*    NAME:  CHKLC  	 *  SOURCE:  92084-18804   *   RELOC:  part of 92084-12050   *    PGMR:  J.L.M., D.N., W.J.A., hpf   *   *  Changes marked with 5020 by hpf  *   }   
{$PRIVATE_TYPES$}  {5020}  
 $RECURSIVE OFF$   $AUTOPAGE ON$   $SUBPROGRAM$  { modified next line to work with new pascal }  PROGRAM CHKLC_P;  {Checks linus checksum block with the block read in memory.}       {Include type definitions and external procedure declarations.}    $LIST OFF$    CONST        max_number_subchannels=32;  {For SAVE,LSAVE,USAVE restores.}   %{                                 change [@ to @.pasi for testing 5020   } % $INCLUDE 'SMTPS.pasi'$  $INCLUDE 'TMTPS.pasi'$  $include 'cotps.pasi'$           {add for 5020}   $INCLUDE 'DBTPS.pasi'$  $LIST ON$   $PAGE$  #{These next procedures are written in FORTRAN, PASCAL or ASMB for the  # 
 backup utilities.}  
     %PROCEDURE calculate_linus_checksum $ALIAS 'CALCK'$ (VAR checksum:integer;  % $            always_1:integer; VAR linus_block:general_linus_block_type;  $             always_linus_block_size:integer);external;       PROCEDURE output_string $ALIAS 'DIALG'$ (VAR output:string_type;             output_length:integer);external;      "PROCEDURE logit(VAR list_lu,log_lu:integer; VAR string:string_type;  "                 string_length:integer);external;          PROCEDURE read_tape $ALIAS 'RTAPE'$ (VAR tape_lu:integer;   !            VAR buffer:general_buffer_type; buffer_length:integer; !             VAR words_read,status:integer);external;      {I handle my own pascal errors in the &PCLER module.}       PROCEDURE pcler $ALIAS 'PAS.ERRORCATCHER'$              (VAR err_code,err_numb,err_line:integer;  $             VAR file_name:string_type; VAR file_len:integer);external;  $     !FUNCTION ldtyp (VAR lu,lu_code:integer):ascii_word_type;external;  !     !PROCEDURE cnumd(number:integer; VAR dec_string:name_string_type);  ! !                                                         external; ! PROCEDURE double_int_to_ascii $ALIAS '.D2AD'$   $    (VAR number:double_int; VAR string:double_int_string_type);external; $     $PAGE$   {chklc checks the linus checksums contained linus_checksums    with the linus checksum blocks on tape.  The linus tape     must be positioned to the first checksum block, and the     two blocks are read into io_buffer.  Hence io_buffer must     be at least 1 k word long.  The track attributes must be    passed so the routine can calculate the disc region that    corresponds to any bad linus blocks.       return_status is 0 if no errors occurred,  !                  1 if both checksum blocks had a checksum error,  !                   5 if end of tape       ***5020***   "                  2 if the tape read of the checksum blocks failed.} "     PROCEDURE chklc(VAR current_linus_block:double_int;      VAR linus_checksums:general_linus_block_type;     VAR io_buffer:general_buffer_type;      VAR list_lu,log_lu,tape_lu,ckacc,     current_track,current_sector,number_tracks,     sectors_per_track,disc_lu,iprog,return_status:integer);    LABEL 99;         TYPE      special_string_type=RECORD        CASE integer OF           0:(all:string_type);  	        1:(track,  	            ascii_track:name_string_type;             sector:PACKED ARRAY [1..8] OF char;             ascii_sector:name_string_type;              blocks:PACKED ARRAY [1..8] OF char;             ascii_blocks:name_string_type);          2:(linus_block:PACKED ARRAY [1..26] OF char;             block_number:double_int_string_type);          3:(subchannel:PACKED ARRAY [1..10] OF char;              number:name_string_type);            END;        VAR           
    status:integer;  
     special_string:special_string_type;           bad_sector,       bad_track,  	    block_adjust,  	     current_tape_words_to_read,   	    temp_variable, 	     transmission_log: integer;          "  {ts_to_block converts a track and sector address into an absolute  " %   block number.  The current disc paramaters must be contained in common  % $   (tmap). Track 0, sector 0 maps to block 0, and a block is 128 words.} $     { FUNCTION ts_to_block(VAR track,sector:integer):integer;       BEGIN         ts_to_block:=((track*sectors_per_track + sector) DIV 2);      END;}{ts_to_block}    {block_to_ts is the inverse of ts_to_block.}     PROCEDURE block_to_ts(block:integer;VAR track,sector:integer);       BEGIN         sector:=(block*2) MOD sectors_per_track;        track:=block DIV (sectors_per_track * 2);       END; {block_to_ts}            {check_linus_checksums validates a tape checksum for linus     tape reads saved using psave.  It is also used for linus      tape verifies. It prints the block numbers which are in     error, as well as their corresponding disc locations.}             {checksum_mismatch:boolean;}          {check_lchecks compares the linus checksum buffer in       memory with the verified block read off tape.}           PROCEDURE check_lchecks; $direct$         VAR           bad_block:double_int;           current_disc_block,   
        linus_blocks_read, 
 	        i:integer; 	       BEGIN   !        special_string.linus_block:='DATA ERROR AT TAPE  BLOCK=';  !         special_string.block_number:='            ';              linus_blocks_read:=ckacc;               FOR i:=1 TO linus_blocks_read DO            IF linus_checksums.linus_checksum_buffer[i]<>                io_buffer.linus_block.linus_checksum_buffer[i]               THEN  
              BEGIN  
 !                {Calculate the absolute block number that is bad.} !     #                bad_block:=(current_linus_block-linus_blocks_read + i) #                           - block_adjust;                       double_int_to_ascii(bad_block,                          special_string.block_number);                       logit(list_lu,log_lu,                         special_string.all,-38);                      {Calculate the track and sector where the bad                    data went to, and report this to the user.}      '{               current_disc_block:=ts_to_block(current_track,current_sector); ' $}               current_disc_block:= ((current_track*sectors_per_track + $                                        current_sector) DIV 2);  "                block_to_ts(current_disc_block-linus_blocks_read+i,  "                             bad_track,bad_sector);                      IF bad_track<number_tracks                        {Log the general error, and report where the                     bad information is on the disc.}                           THEN BEGIN                            IF iprog < 0 {Is this thing off-line?}    &                         THEN special_string.subchannel:='SUBCHANNEL' {yes}  & &                         ELSE special_string.subchannel:='DISC  LU  ';{no }  &                          cnumd(disc_lu,special_string.number);  #                         logit(list_lu,log_lu,special_string.all,-16); #                              special_string.track:='TRACK=';                           special_string.sector:='SECTOR= ';                            special_string.blocks:='BLOCKS= ';   #                         cnumd(bad_track,special_string.ascii_track);  # $                         cnumd(bad_sector,special_string.ascii_sector);  $                          cnumd(4,special_string.ascii_blocks);  #                         logit(list_lu,log_lu,special_string.all,-40); #                         END;  	              END; 	         END; {check_lchecks}          BEGIN       
      return_status := 0;  
           block_adjust:=1; {Account for first checksum record.}             {Calculate the checksum of the checksum block built   	       in memory.} 	           calculate_linus_checksum(temp_variable,             1,linus_checksums,ckacc);             {Read the 2 checksum blocks.}             current_tape_words_to_read:=linus_block_size*2;         read_tape(tape_lu,io_buffer,current_tape_words_to_read,                   transmission_log,status);         IF (transmission_log<>current_tape_words_to_read) OR           ((status <> 0) AND (status <> 5)) THEN           BEGIN             return_status:=2;   	          goto 99; 	         END;            IF temp_variable <> io_buffer.linus_array[0]             .linus_checksum_buffer[linus_block_size]           THEN {See if second block works better.}            BEGIN               block_adjust:=2;              IF temp_variable <> io_buffer.linus_array[1].   $                                 linus_checksum_buffer[linus_block_size] $                   THEN return_status:=1                 ELSE check_lchecks;             END             ELSE check_lchecks; {addition AWJ 9/23/81}            if status = 5 then return_status := 5;   { 5020 }      99:        ckacc:=0;       $LIST_CODE ON$      END;.  