 $PASCAL '91790-16230 REV.4010 <860314.0916>'  
$Title 'ADS Cleanup Code'  
 $Standard_Level 'HP1000'  $Private_Types  $Run_String 0   $Recursive Off  $Range Off  $Debug  $Heap 0           MODULE UPLN2;       {}  {------------------------------------------------------------   {   { (C) COPYRIGHT HEWLETT-PACKARD COMPANY 1986. ALL RIGHTS  { RESERVED. NO PART OF THIS PROGRAM MAY BE PHOTOCOPIED,   { REPRODUCED OR TRANSLATED TO ANOTHER PROGRAM LANGUAGE WITHOUT  { THE PRIOR WRITTEN CONSENT OF THE HEWLETT-PACKARD COMPANY.   {   {------------------------------------------------------------   {}      {}  {    NAME: UPLN2  {  SOURCE: 91790-18230  {   RELOC: 91790-16230  {    PGMR: TDS  {}      {}  {------------------------------------------------------------   { MODIFICATIONS:  {   {  Date     PCO  Prgmr  Description   { 09/30/85       EW    REVERSE ORDER OF SIGMOD/TRCMOD IMPORTS   { 11/01/85       EW    Don't clear 802 class # if INPRO is not  {                      scheduled.   { 11/23/85       EW    Schedule QCLM here rather than in UPLIN   {                      since it may be required even if no 91750   {                      services are required.   { 11/15/85       EW    CCP out trigger references.  { 11/23/85       EW    Added reschedule of INPRO and OUTPRO.  { 11/23/85       EW    Log reschedule of INPRO and OUTPRO.   { 11/25/85       EW    Modified logging routine to allow logging   {                      when the caller isn't critical.  { 11/25/85       EW    Deleted unused EXTERNAL declarations.  { 01/30/86       jar   REV.2608   !{ 03/14/86       lms   Do not release ID segment on EXEC 6 (n373). ! {------------------------------------------------------------   {}      {}  { MODULE DESCRIPTION:   {   {  This module contains the NS/1000 cleanup routines. These    {  routines are appended to UPLIN and are called by UPLIN every    {  five seconds.  {}      $Page   #{-------------------------------------------------------------------}  # #{                          IMPORT SECTION                           }  # #{-------------------------------------------------------------------}  #     IMPORT         $SEARCH 'phtm/BODEC.REL'$     BODEC,          $SEARCH 'phtm/MMDEC.REL'$     MMDEC,          $SEARCH 'phtm/MMEXT.REL'$     DS_MM,          $SEARCH 'phtm/SODEC.REL'$     SODEC,          $SEARCH 'phtm/TRCMOD.REL'$      TRCMOD,         $SEARCH 'phtm/SIGMOD.REL'$      SIGMOD,         $SEARCH 'phtm/INIT_DEC.REL'$      INIT_DEC,         $SEARCH 'phtm/DRES.XPT'$      DRES,         $SEARCH 'phtm/ENVOK.XPT'$     ENVOK,          $SEARCH 'phtm/LKLB.REL'$      LK,         $SEARCH 'phtm/TMRDEC.REL,phtm/IPDEC.REL'$     IPDEC,       $WIDTH 150$   -   $SEARCH 'phtm/SIGMOD.REL,phtm/TMRDEC.REL,phtm/IPLIB.REL,phtm/TUSER.REL,phtm/IPDB.REL'$  - $WIDTH 80      IPLIB;       $Page   #{-------------------------------------------------------------------}  # #{                          EXPORT SECTION                           }  # #{-------------------------------------------------------------------}  #     EXPORT         Procedure $DIRECT$ UpNs  $ALIAS 'UpNs'$;           #{-------------------------------------------------------------------}  # #{                         IMPLEMENT SECTION                         }  # #{-------------------------------------------------------------------}  #     IMPLEMENT       CONST          CRITICAL             = TRUE;     { for logging routine }      DS                   = Ord ('D')*256 + Ord ('S');     EVMON_NAME           = 'EVMON ';      SAVE_ID_SEGMENT      =  2;       { Exec 6 request code }      GRPM_NAME            = 'GRPM  ';      IFPM_NAME            = 'IFPM  ';      IMMEDIATE_NO_WAIT    = 10;       { Exec schedule request }      INPRO_NAME           = 'INPRO ';      MATIC_NAME           = 'MATIC ';      NSTRC_NAME           = 'NSTRC ';       NO_ABORT_EXEC        = -32768;   { Don't let exec abort us }        NO_ABORT_RNRQ        = 16384;    { Don't let Rnrq abort us }       NOT_CRITICAL         = FALSE;    { for logging routine }      OF_PROGRAM_ID        = 'OF,#####,ID';     OUTPRO_NAME          = 'OUTPR ';      QCLM_NAME            = 'QCLM  ';      TERMINATE            =  6;       { Exec request code }      THIS_PROGRAM         =  0;       { Exec 6 request code }      TIME_SCHEDULE        = 12;       { Exec request code }      TIMER_NAME           = 'TIMER ';      UPLIN_NAME           = 'UPLIN ';          { these are the errors logged by UPLIN }   "   UPLIN_ERROR_BASE     = 17000;    { error base for error logging } "    RESCHEDULE_INPRO     = UPLIN_ERROR_BASE + 1;      RESCHEDULE_OUTPRO    = UPLIN_ERROR_BASE + 2;       TYPE         MesssCommandType = PACKED ARRAY [1..72] OF CHAR;          ProgramNameType = PACKED ARRAY [1..6] OF CHAR;       $Page   #{-------------------------------------------------------------------}  # #{                        EXTERNAL DECLARATIONS                      }  # #{-------------------------------------------------------------------}  #     { This routine resides in the old UPLIN }   PROCEDURE $DIRECT$  ClearPlogEntryPts  $ALIAS 'CLPLG'$;      EXTERNAL;      FUNCTION Ds_Rsm_Logoff     (VAR wkmp         : Int16;       VAR key          : SessionKeyType)     : Int16;      EXTERNAL;      "{ These routines only call LIBR and LIBX. LIBR and LIBX cannot be }  " "{ called directly from PASCAL.                                    }  " 
PROCEDURE DS_GoLibr; 
    EXTERNAL;      
PROCEDURE DS_GoLibx; 
    EXTERNAL;      PROCEDURE DS_StoreUrec     (    urec_id      : Int16;       VAR urec         : Int16);     EXTERNAL;      PROCEDURE ExecSchedule  $ALIAS 'EXEC', NOABORT$      (    exec_code    : Int16;           prog_name    : ProgramNameType;           param1       : Int16);     EXTERNAL;      PROCEDURE ExecTerminate  $ALIAS 'EXEC'$      (    exec_code    : Int16;           prog         : Int16;           type_num     : Int16);     EXTERNAL;      FUNCTION Messs     (VAR command      : MesssCommandType;          length_chars : Int16)      : Int16;      EXTERNAL;      PROCEDURE Pgmad      (    prog_name    : ProgramNameType;       VAR id_addr      : Int16;       VAR status       : Int16);     EXTERNAL;      PROCEDURE RnRq    $NOABORT$      (    icon         : Int16;       VAR irn          : Int16;       VAR istat        : Int16);     EXTERNAL;              $Page   #{-------------------------------------------------------------------}  # #{                             LOG ERROR                             }  # #{-------------------------------------------------------------------}  # "{ Log an error to the log file. This procedure must be called while  " { critical.   {   { Parameters:   {   {     location (Input)   {        A number giving the location where the error occurred.    !{        The location will be different for each point of call in  ! {        this module.   {   {     error_code (Input)  "{        The error that occurred. See the global consts for a list.  " {   {     critical_flag (input)   "{        A BOOLEAN flag to indicate that the caller is (TRUE) or is  " {        not (FALSE) critical when they make the call.  {}  	PROCEDURE LogError 	    (    location     : Int16;           error_code   : Int16;           critical     : BOOLEAN);  VAR      dummy    : ContextWords;   
   info     : Int16; 
 
   result   : Int16; 
 
   wkmp     : Int16; 
     BEGIN      dummy.longint := 0;     info          := error_code;       
   IF (NOT critical) THEN  
       DS_EnterCritical (wkmp, result);         IF RESULT <> 0 THEN { error on enter critical ! }         ExecTerminate (TERMINATE, THIS_PROGRAM, SAVE_ID_SEGMENT);        $   Log_Event (EL_ERROR, ENTITY_UPLIN, location, dummy, 1, info, result); $     
   IF (NOT critical) THEN  
       DS_LeaveCritical (wkmp);      	END;  { LogError } 	         $Page   #{-------------------------------------------------------------------}  # #{                       RELEASE UREC RESOURCES                      }  # #{-------------------------------------------------------------------}  # !{ Release all resources in a user record, and move the user record ! 
{ to the free list.  
 {   { Parameters:   {   {     urec_id (Input)   {        Gives the user record id of the user record for which  {        resources should be released. This must always be the  {        user record at the head of the cleanup list.   {   
{     wkmp (Input/Output)  
 "{        The current working map. This procedure assumes the caller  " "{        is critical. If error returns <> 0 then this is undefined,  " {        and we will be non-critical.   {   
{     error (Output) 
 "{        Since this procedure may have to log a session off, we must "  {        leave critical temporarily (in DS_Rsm_Logoff). If error    {        returns a non-zero value, DS_Rsm_Logoff could not enter   
{        crtitical again.  
 {}  PROCEDURE  ReleaseUrecResources   
   (VAR urec_id   : Int16; 
 
    VAR wkmp      : Int16; 
     VAR error     : Int16);       VAR      command        : MesssCommandType;   
   gsd            : Int16; 
 
   ierr           : Int16; 
 
   index          : Int16; 
    mmflags        : MMFlagsType;     preamble       : PathPreambleRecord;   
   return_chars   : Int16; 
    session_key    : SessionKeyType;      socket         : SocketRecord;      temp_urec      : UserRecord;      urec           : UserRecord;       BEGIN      DS_UrFetchElement (urec_id, urec.int);       "   { If the user record we are cleaning up after has a son user    } " "   { record linked off of it then a monitor must have been in the  } " "   { process of scheduling a server when the Monitor was OFfed or  } " "   { aborted. Release the server's resources by OFfing the server. } " "   { The abort processor will move the user record to the end of   } " "   { the cleanup list where we will find it later.                 } "    IF urec.ur_ptrs.ur_sonurecptr <> NULL THEN         BEGIN   "      DS_UrFetchElement (urec.ur_ptrs.ur_sonurecptr, temp_urec.int); "       temp_urec.ur_ptrs.ur_parenturecptr := NULL;          DS_StoreUrec (urec.ur_ptrs.ur_sonurecptr, temp_urec.int);          command := OF_PROGRAM_ID;         FOR index := 1 TO 5 DO  "         command [index + 3] := temp_urec.ur_progname.chars [index]; "       return_chars := Messs (command, 11);  	      END;  { IF } 	     "   { If the user record we are cleaning up after has a parent user } " "   { record linked off of it then a monitor must have been in the  } " "   { process of scheduling a server when the server was OFfed.     } " "   { Clear the Monitor's link to the son's user record.            } "    IF urec.ur_ptrs.ur_parenturecptr <> NULL THEN        BEGIN   $      DS_UrFetchElement (urec.ur_ptrs.ur_parenturecptr, temp_urec.int);  $       temp_urec.ur_ptrs.ur_sonurecptr := NULL;  !      DS_StoreUrec (urec.ur_ptrs.ur_parenturecptr, temp_urec.int); ! 	      END;  { IF } 	        { Finally begin releasing resources in the user record }      FOR index := 0 TO MAX_SOCKETS_PER_USER DO        BEGIN         gsd := urec.ur_smap[index];         urec.ur_smap[index] := -(index + 1);        IF (gsd > DST_BOUNDARY) THEN           BEGIN  "         { We've got a path report to clean up. It is important not  "          { to destroy a path report until any and all of the           { CONNECT_REQUEST emsgs which reference it have been   #         { processed. Our reference counting scheme protects us here.  #          {}            SoPathRelease(gsd - DST_BOUNDARY, ierr);            END        ELSE IF (gsd > 0) THEN           BEGIN           { We've got a socket to clean up.           {}            DS_SoFetchElement (gsd, socket.int);            SoTrash (gsd, socket);            END; {IF gsd}  	      END; {FOR i} 	        WITH urec DO         BEGIN   !      { Initialize the fields of the released user record so that  ! !      { the record will be clean for the next user to acquire it.  !       {}        ur_progname.chars := 'NOBODY';  
      ur_procidaddr := 0;  
       ur_ptrs.ur_parenturecptr := NULL;         ur_ptrs.ur_sonurecptr := NULL;        ur_reschedule := FALSE;         session_key := ur_sessionkey;         ur_sessionkey [1] := 0;         ur_sessionkey [2] := 0;         ur_sessionkey [3] := 0;   
      ur_sfree := 1; 
 
      ur_smap[0] := NULL;  
       ur_smap[MAX_SOCKETS_PER_USER] := NULL;        ur_give_cnt := 0;         WHILE (ur_so_giveptr <> NULL) DO           BEGIN           gsd := ur_so_giveptr;           DS_SoFetchElement (gsd, socket.int);            ur_so_giveptr := socket.so_giveptr;           socket.so_giveptr := NULL;            SoTrash (gsd, socket);            END; {WHILE ur_so_giveptr}       #      { Clean up any path reports that the user might have given away  # !      { but which might not have been claimed yet by anybody else. !       {   $      { Note that we must be careful about disturbing the path report's  $ "      { preamble as there might still be some CONNECT_REQUEST emsgs  " #      { in the system that reference the path report. The path report  # "      { should not be destroyed until the all CONNECT_REQUESTs that  " %      { reference it have been processed. A reference count is maintained  % #      { in a path report's preamble so it can be determined when it is #       { safe to destroy a path report.        {}        WHILE (ur_pa_giveptr <> NULL) DO           BEGIN           gsd := gsd - DST_BOUNDARY;   
         mmflags.int := 0; 
          mmflags.bits[0] := TRUE;   &         DS_MRead (preamble.int, PATH_PREAMBLE_SIZE, gsd, 0, mmflags, ierr); &          IF (ierr <> SUCCESSFUL) THEN               LogError (0, ierr, CRITICAL);                ur_pa_giveptr := preamble.pa_giveptr;           SoPathRelease (gsd, ierr);            IF (ierr <> SUCCESSFUL) THEN               LogError (0, ierr, CRITICAL);            END; { WHILE }       
      gsd := ur_rn;  
       Rnrq (RN_DEALLOCATE + NO_ABORT_RNRQ, gsd, ierr);           BEGIN           END;  { Error return }       "      { Deallocate the user's Resource Number Descriptor (RND). Link "       { the newly freed RND into the free list.         {}  
      gsd := ur_rnd; 
       DS_RNFetchElement (RND_FREE, index);        DS_RNStoreElement (gsd, index);         DS_RNStoreElement (RND_FREE, gsd);      	      ur_rn := 0;  	 	      ur_rnd := 0; 	 
      END;  { WITH urec }  
     #   { Move the user record from the head of the cleanup list to the   } # #   { head of the free list. Don't let users OF a program on a single } # #   { user system. This may cause the cleanup list pointers to change } # #   { since the abort processor may be called.                        } #    DS_GoLibr;          DS_UrFetchElement (urec_id, temp_urec.int);     DS_StoreGlobal (DS_UrCleanupPtr, 1, temp_urec.ur_urecptr);   !   DS_FetchElement (DS_TrackTD, TL_USER_FREEPTR, urec.ur_urecptr); !    DS_StoreElement (DS_TrackTD, TL_USER_FREEPTR, urec_id);     DS_UrStoreElement (urec_id, urec.int);          DS_GoLibx;       "   { If the user record contained a valid session key then log the } " "   { session off. We want to return an error only if we could not  } " "   { return to critical within the DS_Rsm_Logoff call.             } "    IF (session_key [1] <> 0) OR         (session_key [2] <> 0) OR         (session_key [3] <> 0) THEN         BEGIN         error := DS_Rsm_Logoff (wkmp, session_key);       #      { Ignore all but error indicating we could not enter critical }  #       IF error <> MMDSAMCORRUPT THEN  
         error := 0; 
 	      END;  { IF } 	     END;  { ReleaseUrecResources }      $Page   #{-------------------------------------------------------------------}  # #{                               UP NS                               }  # #{-------------------------------------------------------------------}  # !{ Perform cleanup for NS programs. Reschedule several monitors if  ! !{ necessary. For each user record in the cleanup list, release all ! { resources recorded in it and move it to the free list.  {   { Algorithm:  {    {     Schedule GRPM, QCLM, IFPM, MATIC and TIMER if appropriate    {     Also reschedule INPRO and OUTPRO if they are dormant.   {   {     Cleanup after NSTRC and EVMON if appropriate  {   {     FOR each user record in the cleanup list DO   {        BEGIN  {        Release all resources in the user record and move the  {           user record to the free list  {        END FOR  {   !{ NOTE: In several cases, no check is performed for for a programs ! !{       status prior to performing an EXEC 10 schedule call. It is ! !{       assumed that if the program is not dormant, the call will  ! {       have no effect.   {}  PROCEDURE  UpNs;      VAR      id_addr     : Int16;      error       : Int16;      globals     : EventGlobal;      res_value   : Int16;      status      : Int16;      temp        : Int16;      urec_id     : Int16;      urec        : UserRecord;     wkmp        : Int16;       BEGIN   #   { If we were scheduled by DSINIT then we want to wait until NS is } # #   { up. If we are being scheduled from the time list then this call } # #   { will just return. Also make sure we are the real and only UPLIN } # #   { not an impostor. The 5 is the time schedule interval for us in  } # #   { seconds. This routine may terminate us if all does not go well. } #    DS_TimeListWake (UPLIN_NAME, 5);          { If #GRPM in RES is non-zero then schedule GRPM }      DS_GetResElement (NSINIT_AdrOf( Lb_grpm ), 0, res_value);  
   IF res_value <> 0 THEN  
       BEGIN { schedule GRPM }   #      ExecSchedule (IMMEDIATE_NO_WAIT + NO_ABORT_EXEC, GRPM_NAME, 0);  #          BEGIN           { This is the error return }            END;         END;  { Scheudle GRPM }          { If #QCLM in RES is non-zero then schedule QCLM }      DS_GetResElement (NSINIT_AdrOf( Lb_qclm ), 0, res_value);  
   IF res_value <> 0 THEN  
       BEGIN { schedule QCLM }   #      ExecSchedule (IMMEDIATE_NO_WAIT + NO_ABORT_EXEC, QCLM_NAME, 0);  #          BEGIN           { This is the error return }            END;         END;  { schedule QCLM }          { IF #IFPM in RES is non-zero then schedule IFPM }      DS_GetResElement (NSINIT_AdrOf( Lb_ifpm ), 0, res_value);  
   IF res_value <> 0 THEN  
       BEGIN   #      ExecSchedule (IMMEDIATE_NO_WAIT + NO_ABORT_EXEC, IFPM_NAME, 0);  #          BEGIN           { This is the error return }            END;         END;  { IF Xla }      #   { If #MCTR in RES is non-zero and MATIC is not in time list then }  # #   { schedule MATIC. We do not have to place MATIC in the time list }  # #   { since he does that himself.                                    }  #    DS_GetResElement (NSINIT_AdrOf( Lb_mctr ), 0, res_value);  
   IF res_value <> 0 THEN  
       BEGIN         { Get the status of MATIC }         Pgmad (MATIC_NAME, id_addr, status);            { If status < 0 then MATIC is in the time list }  
      IF status >= 0 THEN  
          BEGIN  %         ExecSchedule (IMMEDIATE_NO_WAIT + NO_ABORT_EXEC, MATIC_NAME, DS); % 	            BEGIN  	             { This is the error return }              END;           END;  { IF status }        END;  { IF Xla }         { If the TIMER is dormant then schedule it }      Pgmad (TIMER_NAME, id_addr, status);      IF status = 0 THEN         BEGIN   #      ExecSchedule (IMMEDIATE_NO_WAIT + NO_ABORT_EXEC, TIMER_NAME, 0); #          BEGIN           { This is the error return }            END;   
      END;  { IF status }  
     "   { If the tracing program is not around or is dormant then clear } " "   { #PLOG and clear some globals in DSAM.                         } "    Pgmad (NSTRC_NAME, id_addr, status);      IF status = 0 THEN         BEGIN         ClearPlogEntryPts;            DS_EnterCritical (wkmp, error);         IF error <> 0 THEN  !         ExecTerminate (TERMINATE, THIS_PROGRAM, SAVE_ID_SEGMENT); !       temp := 0;        DS_StoreGlobal (DS_HltClass, 1, temp);        DS_StoreGlobal (DS_NetClass, 1, temp);        DS_StoreGlobal (DS_LltClass, 1, temp);        DS_LeaveCritical (wkmp);  
      END;  { IF status }  
     $   { We originally cleared INPRO's class number from the LU table of  }  $ $   { the LAN driver if INPRO was not around. We will now attempt to   }  $ $   { reschedule INPRO.                                                }  $    Pgmad (INPRO_NAME, id_addr, status);      IF status = 0 THEN         BEGIN { reschedule INPRO }        LogError (0, RESCHEDULE_INPRO, NOT_CRITICAL);   #      ExecSchedule (IMMEDIATE_NO_WAIT + NO_ABORT_EXEC, INPRO_NAME, 0); #          BEGIN           { This is the error return }            END;         END;  { reschedule INPRO }          { We will also attempt to re-schedule OUTPRO if it dormant. }      Pgmad (OUTPRO_NAME, id_addr, status);     IF status = 0 THEN         BEGIN { reschedule OUTPRO }         LogError (0, RESCHEDULE_OUTPRO, NOT_CRITICAL);  $      ExecSchedule (IMMEDIATE_NO_WAIT + NO_ABORT_EXEC, OUTPRO_NAME, 0);  $          BEGIN           { This is the error return }            END;         END;  { reschedule OUTPRO }       $   { If EVMON is not around or is dormant then clear the socket id in }  $ $   { the globals area. This is the socket id that Log_Event uses to   }  $ $   { send log messages to. Note that if EVMON gets aborted then we    }  $ $   { will be clearing the socket identifier here, and the socket will }  $ $   { be released when EVMON's user record is cleaned up after below.  }  $    Pgmad (EVMON_NAME, id_addr, status);      IF status = 0 THEN         BEGIN         DS_EnterCritical (wkmp, error);         IF error <> 0 THEN  !         ExecTerminate (TERMINATE, THIS_PROGRAM, SAVE_ID_SEGMENT); !       DS_FetchElement (DS_EventGlobalsTD, 1, globals.bufr);   
      globals.sbufid := 0; 
       DS_StoreElement (DS_EventGlobalsTD, 1, globals.bufr);         DS_LeaveCritical (wkmp);  	      END;  { IF } 	        DS_EnterCritical (wkmp, error);     IF error <> 0 THEN          ExecTerminate (TERMINATE, THIS_PROGRAM, SAVE_ID_SEGMENT);           { Fetch the pointer to the head of the cleanup list }     DS_FetchGlobal (DS_UrCleanupPtr, 1, urec_id);         { Loop for each user record in the cleanup list }     WHILE urec_id <> NULL DO         BEGIN         ReleaseUrecResources (urec_id, wkmp, error);             { If error is non-zero then we could not enter critical }          IF error <> 0 THEN  !         ExecTerminate (TERMINATE, THIS_PROGRAM, SAVE_ID_SEGMENT); !     "      { Fetch the pointer to the next user record to be cleaned up } "       DS_FetchGlobal (DS_UrCleanupPtr, 1, urec_id);         END;  { WHILE }          DS_LeaveCritical (wkmp);       END;  { UpNs }      END.  { Module UPLN2 } 