 $PASCAL ',7 91790-1X227 REV.4010 <860319.1553>'   
$RECURSIVE OFF, RANGE OFF$ 
 
$STANDARD_LEVEL 'HP1000' $ 
 $HEAP 0 $   $DEBUG$       MODULE TUSER;   
   $ALIAS 'N$Tuser'$ 
     #{--------------------------------------------------------------------  #      (c) COPYRIGHT HEWLETT PACKARD COMPANY 1986.  ALL RIGHTS   RESERVED.  NO PART OF THIS PROGRAM MAY BE PHOTOCOPIED,    REPRODUCED OR TRANSLATED TO ANOTHER PROGRAM LANGUAGE WITHOUT    THE PRIOR WRITTEN CONSENT OF THE HEWLETT-PACKARD COMPANY.      #--------------------------------------------------------------------}  #     {}  
{       NAME : Tuser 
 
{     SOURCE : 91790-18227 
 
{      RELOC : none  
 
{       PGMR : LBJ and SLL 
 {}  {}  #{--------------------------------------------------------------------  # { MODIFICATIONS   {  3/84 ash to minimize DSAM accesses.  {  3/7/84 ash   {     Added ResetTimer call.  {  3/12/84 ash  #{     Added free list to improve performance.  Now there is a list of  # !{  free entries so that Activation always takes the same amount of ! {  time.  {  3/20/84 ash   {     Added WakeUp procedure to integrate with IPC and sockets.    {  Also added a temporary data structure to the timer process:  {  a linked list of timer entries which have to be notified.  "{  Therefore notification happens only once-- at the end of all the  " {  processing in Timer.   {   {  7/2/84 ash    {     Changed IMPORT declaration to search BODEC.REL instead of    {  ADVANCEDS.LIB for bodec.   {   {  9/20/84 ash   {     Commented out all message related calls.  The problems of    #{  accounting and ensuring that memory will always be available looked # #{  too shakey.  They are all tested, however, and remain in the code.  # {   {  10/9/84 ash   {     Changed the structure of the TimerHash table so that it is   !{  one entry which is an array of buckets, instead of each bucket  ! "{  being its own entry.  Now SystemSoonest inhales the entire table  " {  and does its search locally.   {   {  10/11/84 ash   #{     Changed to heap 0, and so removed AddToNotifyList, Process, and  # {  WakeUp and put them into the Timer program, and exported   {  DeleteFromchain, AddToFreeList, and SystemSoonest.   {   {  10/16/84 ash   ${     Changed Reschedule procedure.  If the time to reschedule is + or - $ ${  5 minutes from the current time, the schedule is relative; otherwise  $ "{  absolute.  The time could have gone by if the scheduling process  " {  got blocked along the way.   {   {  11/14/84 ash   &{     Changed Activate, Cancel, and reset so that they look for the soonest  & %{  in the chain or in the system from a time which is half a second before % "{  the current time.  Race conditions occur when the real soonest is " &{  being overlooked because a process is waiting to run, and so the current  & "{  time is just past the real soonest-- it therefore is overlooked.  " {  1/30/85 ash  ${     Changed Activate to be sure the timer index and key will never be  $ #{  the same.  Changed addtofreelist to be sure the key is invalid (-1) # !{  Changed send_event calls to include the socket of the offending ! {  caller.  {   {  3/11/85 ash  #{     Fixed rollaround count problem in ActivateTimer.  (nactiv = -2)  # {              ------------ POST -----------------------  {  5/21/85  {     Convert send_event to log_event calls   {              ------------ POST -----------------------  {  8/12/85  {     Add timer_entity to log_event messages  {     Change location code to be procname + loc.  {  9/22/85  "{     Change window time in Insert and Remove Entry to be 5 minutes  " !{     before the current time.  Too many race conditions with very ! 
{     heavy systems. 
 {  9/30/85  {     Import trcmod before sigmod.  {              ----------- POST ----------------------  {  12/27/85   {     Reschedule for no less than 10 cs from current time.  "{     Clean up documentation reference to nonexistenent error codes. " {              ----------- POST ----------------------  {  3/17/86  ash   ${     Be sure to increment stat.nactv in Activate in all cases.  #35162  $ %{     Add timemsg.signal as second context word in escape within Activate  % !{     Remove uncalled procedures (Cleanup, examinetimer) and code  ! {     pertaining to the message based timer.  #{-------------------------------------------------------------------}  # { PROGRAM DESCRIPTION :   {   !{ This module contains all the procedures which maintain the timer ! ${  data structures.  It is imported by anyone wishing to request service $  {  from the timer, as well as by the timer program itself.  ash.   {}  $ PAGE $      {}  
{  Data Structures:  
 {   {   {                         DSAM  Storage  Area   {   {    {                   1 1 1 1 1 1                       HashTable     {                   5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0   +-------+    {                  +-------------------------------+  !{                  |      bucket tos               |  tos: top of  !  {                  +-------------------------------+       stack   {                  |                               |  {                  |      bucket timeout           |  {                  |                               |  {                  +-------------------------------+  {                  |      next hash                |  {                  |                               |  {   {   {  tos               - top of stack   "{                      A pointer to the first entry in this bucket.  "  {                      An insert into the list is effectively a    {                      stack push.  {   !{  buckettimeout     - The time of the next to be processed entry  ! {                      in this bucket.  {   {}  $PAGE$                      {    {                   1 1 1 1 1 1                       EntryTable    {                   5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0   +--------+   {                  +-------------------------------+  {                  |            left               |  {                  +-------------------------------+  {                  |            right              |  {                  +-------------------------------+  {                  |            time               |  {                  |                               |  {                  +-------------------------------+  {                  |            socket_value       |  {                  +-------------------------------+  {                  |            signalkind         |  {                  +-------------------------------+  {                  |            key                |  {                  +-------------------------------+  {   {   {   left              - The left pointer.  -1 = nil.  {   right             - The right pointer. -1 = nil.  {   time              - The time at which the message should  {                       be sent   {   socket_value      - The queue by which the timer will   {                       communicate with the user   {   signalkind        - Type of Timer signal: 1..3  {   key               - This value helps identify a user  {                       to provide some security when a   {                       timer is canceled.  {   {}  $PAGE$       {                  +-------------------------------+   StatTable    {                  |            soonest            |   +-------+   {                  +-------------------------------+  {                  |            activ              |  {                  +-------------------------------+  {                  |            nactv              |  {                  +-------------------------------+  {                  |            ncanc              |  {                  +-------------------------------+  {                  |            nrset              |  {                  +-------------------------------+  {                  |            npops              |  {                  +-------------------------------+  {                  |            FreeNotHd          |  {                  +-------------------------------+  {                  |            FreeLstHd          |  {                  +-------------------------------+  {   {   #{   soonest           - time of next soonest timeout (32 bit integer)  # {   "{   activ             - tells how many requests are currently active " {   {   nactv             - tells total number of requests  {   {   ncanc             - tells total number of cancellations   {   {   nrset             - tells total number of reset requests  {   {   npops             - tells total number of timer "pops"  {   #{   FreeNotHd         - points to the head of a free list of elements  # !{                       used to notify users of timer expirations  ! {   FreeLstHd         - list of free timer entries  {}      $PAGE$                          {    Data structure linkage:  {   !{ HASH 0   1   2   3   4   5        24  25  26  27  28  29  30  31 ! "{   +-------------------------   ---------------------------------+  " "{   |tos|tos|tos|tos|tos|tos| ... |tos|tos|tos|tos|tos|tos|tos|tos|  " "{   +-------------------------   ---------------------------------+  " 
{                 |  
 {                 |   +-------+   {                 +-->| L | R |   {                     +-------+   {                      |  ^  |   +-------+  {             nil <----+  |  +-->| L | R |  {                         |      +-------+  {                         |       |  ^  |   +-------+   {                         +-------+  |  +-->| L | R |   {                                    |      +-------+   {                                    |       |     |  {                                    +-------+     +----> nil   {   {   {}  $PAGE$  {   {    Result conventions   {    {       Result < 0 - An error condition exists that resulted in    {                    the failure of the request.  !{       Result = 0 - No errors and no additional action necessary. ! {       Result > 0 - No errors, but reschedule the timer.   {    {       a. The user can expect delivery within 10ms of the time    {          requested.  The request time should be in the range  {          0 to 23 hrs 59 min 59 sec 99 csec.  A request for  {          delivery in 0 seconds will be satisfied in the time  {          necessary to process the request.  {   {}  $PAGE$      IMPORT                       $SEARCH 'phtm/BODEC.rel'$      bodec,   {  General-purpose declarations                    }                        $SEARCH 'phtm/SODEC.rel'$      sodec,   {  Declarations for sockets                        }                        $SEARCH 'phtm/MMdec.rel'$      mmdec,   {  Memory-Manager declarations                     }                        $search 'phtm/mmext.rel'       ds_mm,   {  The Memory Manager                              }                        $SEARCH 'phtm/TMRDEC.REL'$      tmrdec,  { Declarations specific to the timer }                       $SEARCH 'phtm/TRCMOD.rel'$      trcmod,  { code and declarations for send_event }                       $SEARCH 'phtm/SIGMOD.rel'$       sigmod;  {  The library of signal routines                  }       $PAGE$      EXPORT      #{ Creates an active timer entry and returns a descriptor to the user } # PROCEDURE ActivateTimer   
   (    rqsttime : Int32;  
     VAR timemsg  : TimerMsgType;      VAR TimerId : TimerIdType;  
    VAR result   : Int16); 
     { Adds an entry which is no longer in use to the free list }  PROCEDURE AddToFreeList       (   entry : TimerEntryType;           index : Int16;      VAR head  : Int16);       !{ Cancels an active timer entry and restores it to the free list } ! PROCEDURE CancelTimer      (    cancelId   : TimerIdType;       VAR can_result : Int16);          { Converts a double integer time into a 4 word array }  FUNCTION ConvertTime( Integertime : Int32) : TimeArrayType;       { Delete an entry from a hash bucket chain }  
PROCEDURE DeleteFromChain  
    (VAR entry : TimerEntryType;           index : Int16;      VAR hb    : Bucket);      FUNCTION HashFunction ( hashtime : Int32) : Int16;      FUNCTION HashSoonest(          hb : Bucket;                         currenttime : Int32) : Int32;       PROCEDURE Reschedule    { Schedules the timer program }      (   rescheduletime : Int32;      VAR tname         : TimerName;      VAR result        : Int16);       #PROCEDURE ResetTimer    { Changes the time in an active timer entry }  #    (    ofset : Int32;      VAR TimerId : TimerIdType;      VAR rst_result : Int16);      FUNCTION SystemSoonest (currenttime : Int32) : Int32;       FUNCTION TimeOfDay : Int32;       { Determines whether a time is between two other times }  FUNCTION WithinWindow   
   (mintime : Int32; 
 
    maxtime : Int32; 
     testtime : Int32) : BOOLEAN;      $ SUBTITLE 'IMPLEMENT SECTION', PAGE $      IMPLEMENT       VAR   $   msg : AscType;       { global to save space; needed for send_event }  $ 
   context : contextwords; 
 
   location : Int16; 
 #{-------------------------------------------------------------------}  # #{                                                                   }  # #{                 AdrOf                                             }  # #{                                                                   }  # #{   This routine returns the byte address of a buffer.              }  # #{                                                                   }  # #{-------------------------------------------------------------------}  # Procedure AdrOf      (VAR FirstWord : Int16;    { pointer to the variable }           offset : Int16;       VAR ByteAddress : Int16);      EXTERNAL;          #{-------------------------------------------------------------------}  # #{                                                                   }  # #{                 DollarTime                                        }  # #{                                                                   }  # #{ This routine reads the value ot $TIME.                            }  # #{                                                                   }  # #{-------------------------------------------------------------------}  #     #FUNCTION DollarTime : Int32;                          $ALIAS 'DTIME'$  # 	         $DIRECT$  	 	         EXTERNAL; 	     #{-------------------------------------------------------------------}  # #{                                                                   }  # #{                 DoubleIntegerAnd                                  }  # #{                                                                   }  # #{ This routine takes two 2 word integers and returns the logical    }  # #{ AND of the two.                                                   }  # #{                                                                   }  # #{-------------------------------------------------------------------}  #     #FUNCTION DoubleIntegerAnd                             $ALIAS 'DIAND'$  # 
   (    int1     :  Int32; 
         int2     :  Int32) : Int32;      EXTERNAL;      $PAGE$  #{-------------------------------------------------------------------}  # #{                                                                   }  # #{                 Schedule                                          }  # #{                                                                   }  # #{ This is the exec time list call.  It will place the timer in the  }  # #{ time list for the time of the next timer event.  If this routine  }  # #{ is called when the timer is already in the time list, the existing}  # #{ entry will be removed and replaced by the one requested in the    }  # #{ current request.                                                  }  # #{                                                                   }  # #{-------------------------------------------------------------------}  #     #PROCEDURE SchedAbsolute ( code  : Int16;      $ALIAS 'EXEC', NOABORT$  #                      progname   : TimerName;                       resolution : Int16;                       multiple   : Int16;                       ihrs       : Int16;                       imin       : Int16;                       isec       : Int16;                       imsec      : Int16);   
           EXTERNAL; 
             PROCEDURE SchedRelative         $ALIAS 'EXEC', NOABORT$      (    code       : Int16;           progname   : TimerName;           resolution : Int16;           multiple   : Int16;           delay      : Int16);     EXTERNAL;          "{------------------------------------------------------------------} " "{                                                                  } " "{                 UnSchedule                                       } " "{                                                                  } " "{------------------------------------------------------------------} "     { Procedure to remove Timer from the time list }      $PROCEDURE UnSchedule (code        : Int16;      $ALIAS 'EXEC', NOABORT$  $                       progname    : TimerName;                        resolution  : Int16);   
           EXTERNAL; 
     $PAGE$              PROCEDURE InsertEntry(    tmrindex    : Int16;                        VAR tmrentry    : TimerEntryType;                             windowtime  : Int32;                        VAR SystemTimeout : Int32;                        VAR result      : Int16);   	          FORWARD; 	         PROCEDURE RemoveEntry      (VAR entry        : TimerEntryType;          entry_index  : Int16;           WindowTime   : Int32;       VAR NewSoonest   : Int32;       VAR result       : Int16);     FORWARD;       FUNCTION SetWindow   (currenttime : Int32)     : Int32;      FORWARD;           FUNCTION Soonest (time1,                    time2,                    currenttime : Int32) : Int32;   	         FORWARD;  	         $PAGE$  #{-------------------------------------------------------------------}  # #{                                                                   }  # #{                   ActivateTimer                                   }  # #{                                                                   }  # #{                                                                   }  # #{ This call may be used to request service from the timer.  A       }  # #{  unique identifier is returned to the caller which must be used   }  # #{  to either cancel or reset this timer request.  If the timer is   }  # #{  allowed to expire, the caller will be notified by a signal or    }  # #{  a message, depending on his original request.                    }  # #{                                                                   }  # #{ Parameters :                                                      }  # #{                                                                   }  # #{ rqstime (input)                                                   }  # #{    The relative time (in centisecond resolution) at which the     }  # #{    timer should expire.                                           }  # #{                                                                   }  # #{ timesmg (input)                                                   }  # #{    The record which contains the information needed to notify     }  # #{    the caller in the event of expiration.  Contains the socket    }  # #{    on which the caller wishes to be notified, and information     }  # #{    to create an event message if that is requested.               }  # #{                                                                   }  # #{ TimerId (output)                                                  }  # #{    A structure returned to the ActivateTimer caller containing    }  # #{    the value used to cancel the timer request if necessary and    }  # #{    a key to verify the validity of the cancel request. The key    }  # #{    is used to detect the race condition between a cancel request  }  # #{    and timer expiration.                                          }  # #{                                                                   }  # #{ result (output)                                                   }  # #{    Returns zero if the request can be accomodated and an          }  # #{    appropriate error value otherwise.                             }  # #{                                                                   }  # #{-------------------------------------------------------------------}  #     $PAGE $   PROCEDURE ActivateTimer(     rqsttime : Int32;                           VAR timemsg  : TimerMsgType;                            VAR TimerId  : TimerIdType;                           VAR result   : Int16);       LABEL      99;      VAR      currenttime : Int32;    { Current time of day }     windowtime  : Int32;      inserttime  : Int32;    { Time to pop this timer }   $   timer_entry : TimerEntryType;    { The entry record into the table }  $ "   stat        : StatTableType; { The table of statistics in DSAM }  " "   progname    : TimerName;   { name of the program to reschedule }  "         {-------------------------------------------------}   {           Escape ( internal )                   }   {-------------------------------------------------}   PROCEDURE Escape (loc : Int16;  value : Int16);       VAR      eventtype : Int16;      le_result : Int16;      pid       : Int16;       BEGIN      location := ACTIVATE + loc;     pid := ENTITY_TIMER;      context.ints[1] := timemsg.socket;      context.ints[2] := timemsg.signal;      IF value = LISTCORRUPT THEN        eventtype := EL_DISASTER     ELSE eventtype := EL_ERROR;      #   Log_Event (eventtype, pid, location, context, 1, value, le_result); #    goto 99;   END;      $page      BEGIN {ActivateTimer}     currenttime := TimeOfDay;   { Read $TIME and $TIME+1 }      result := 0;                { Initialize }      DS_FetchElement (DS_TimerStatTD, FIRST, stat.mmbuf);      WITH stat DO   
      BEGIN { with stat }  
       nactv := nactv + 1;  { increment request counter }        IF nactv = EMPTYENTRY THEN           BEGIN           nactv := 1; { rollaround }            END;   
      END;  { with stat }  
        IF stat.freelsthd <> EMPTYENTRY THEN         BEGIN {If we have an available entry}   &      inserttime := (currenttime + rqsttime) MOD CSPD; {between 0 and CSPD}  & 	      WITH stat DO 	          BEGIN  %         DS_FetchElement (DS_TimerEntryTD, freelsthd, timer_entry.mmbuf);  %          IF timer_entry.key <> EMPTYENTRY THEN  	            BEGIN  	             result := LISTCORRUPT;              escape (1, result);               END;           TimerId.index := freelsthd;           TimerId.key := nactv;           freelsthd := timer_entry.right_ptr;           END;  { with }       
      WITH timer_entry DO  
          BEGIN { initialize entry }            time := inserttime;           key := TimerId.key;           socket := timemsg.socket;           signalkind := timemsg.signal;           direction := timemsg.direction;           END;  { initialize entry }             windowtime := SetWindow (currenttime);        InsertEntry(TimerId.index, timer_entry, windowtime,                           stat.soonest, result);        stat.activ := stat.activ + 1;             IF result = RESCHDTIMER THEN           BEGIN {If insert results in a new system timeout}           progname.name := 'TIMER';           Reschedule(stat.soonest, progname, result);           END;  {If insert results in a new system timeout}        END {If we have an available entry}       ELSE        BEGIN {There is no available entry}         Result := NOAVAILABLEENTRY;   
      escape (2, result);  
       END;  {There is no available entry}          99:     DS_StoreElement (DS_TimerStatTD, FIRST, stat.mmbuf);      END;  {ActivateTimer}  $PAGE$      #{-------------------------------------------------------------------}  # #{                                                                   }  # #{                AddToFreeList                                      }  # #{                                                                   }  # #{                                                                   }  # #{  This procedure takes an entry which has been deleted from        }  # #{  the Active timer hash data structure and pushes it on to the     }  # #{  list of free entries.                                            }  # #{                                                                   }  # #{-------------------------------------------------------------------}  # PROCEDURE AddToFreeList       (   entry : TimerEntryType;           index : Int16;       VAR head : Int16);           BEGIN { AddToFreeList }      entry.key := EMPTYENTRY;      entry.right_ptr := head;      DS_StoreElement (DS_TimerEntryTD, index, entry.mmbuf);   	   head := index;  	 END;  { AddToFreeList }           $page       #{-------------------------------------------------------------------}  # #{                                                                   }  # #{                 CancelTimer                                       }  # #{                                                                   }  # #{ This call may be used to cancel previously issued timer requests. }  # #{                                                                   }  # #{ Parameters :                                                      }  # #{                                                                   }  # #{ cancelid (input)                                                  }  # #{    The structure's values are returned from the ActivateTimer     }  # #{    call.  The structure contains the value used by the timer to   }  # #{    identify the particular request the user wants to cancel and   }  # #{    a key to verify the validity of the cancel request.            }  # #{                                                                   }  # #{ result (output)                                                   }  # #{    Returns zero if the call was successful,  INVALIDTIMERID if    }  # #{    the key provided does not match the one stored in the entry    }  # #{                                                                   }  # #{ Modified 3/2/84 by ash to                                         }  # #{     1. take advantage of the index-key combination                }  # #{     2. Clean up the result parameter                              }  # #{                                                                   }  # #{                                                                   }  # #{-------------------------------------------------------------------}  #     PROCEDURE CancelTimer(     cancelid : TimerIdType;                         VAR can_result   : Int16);       VAR      currenttime : Int32;      result : Int16;      { result from the remove entry call }      centry : TimerEntryType;   { the entry to be cancelled }      stat : StatTableType;  	   error : Int16;  	    progname : TimerName;     windowtime : Int32;      $ PAGE $  {-----------------------------------------}   
{     LogError (internal)  
 {-----------------------------------------}   PROCEDURE LogError (loc : Int16;  value : Int16);       VAR      ecode : Int16;    { error severity }   	   pid   : Int16;  	     BEGIN      location := CANCEL + loc;     pid      := ENTITY_TIMER;     context.ints[1] := cancelid.index;      context.ints[2] := cancelid.key;          IF value = INVALIDTIMERID THEN         BEGIN { a common occurrence }   
      ecode := EL_WARNING; 
       END      ELSE         BEGIN         ecode := EL_ERROR;        END;          Log_Event (ecode, pid, location, context, 1, value, result);        END;      $page$     BEGIN {CancelTimer}  !   currenttime := TimeOfDay;               {note the current time} !    result := 0;   $   IF (cancelId.index >= 0) AND (cancelId.index < NUMBEROFENTRIES) THEN  $       BEGIN {valid cancelid}        { read in the entry from DSAM }         DS_FetchElement (DS_TimerStatTD, FIRST, stat.mmbuf);         stat.ncanc := stat.ncanc + 1;   { increment cancel count }   #      DS_FetchElement (DS_TimerEntryTD, cancelid.index, centry.mmbuf); #       IF centry.key = cancelid.key THEN            BEGIN { keys match }   $         stat.activ := stat.activ - 1;  { decrement total active count } $              windowtime := SetWindow (currenttime);            RemoveEntry (centry, cancelid.index, windowtime,                           stat.soonest, result);            AddToFreeList (centry, cancelid.index, stat.freelsthd);            IF result = RESCHDTIMER THEN   	            BEGIN  	             progname.name := 'TIMER ';              reschedule (stat.soonest, progname, result);              can_result := result;               END   
         ELSE BEGIN  
             can_result := result;               END;           END   { keys match }         ELSE BEGIN           can_result := INVALIDTIMERID;           logerror (1, can_result);           END;         DS_StoreElement (DS_TimerStatTD, FIRST, stat.mmbuf);        END   { valid cancelid }     ELSE BEGIN         can_result := INVALIDTIMERID;         logerror (2, can_result);         END;     END; {CancelTimer }      $PAGE$  #{-------------------------------------------------------------------}  # #{                                                                   }  # #{                 ConvertTime                                       }  # #{                                                                   }  # #{ This function takes a 2 word integer time value and converts      }  # #{ it into a four word array value of hours, minutes, seconds        }  # #{ and centiseconds.                                                 }  # #{-------------------------------------------------------------------}  #     FUNCTION ConvertTime( Integertime : Int32) : TimeArrayType;       VAR   	   tempIT : Int32; 	 
   tempTA : TimeArrayType; 
        BEGIN {ConvertTime}     tempTA[3] := Integertime MOD 100;     tempIT := IntegerTime DIV 100;      tempTA[2] := tempIT MOD 60;     tempIT := tempIT DIV 60;      tempTA[1] := tempIT MOD 60;     tempTA[0] := tempIT DIV 60;  
   ConvertTime := tempTA;  
    END;  {ConvertTime}      $PAGE$      #{-------------------------------------------------------------------}  # #{                                                                   }  # #{                 DeleteFromChain                                   }  # #{                                                                   }  # #{  Unlinks a single entry from a hash bucket chain and fixes the    }  # #{     other links.                                                  }  # #{                                                                   }  # #{-------------------------------------------------------------------}  # PROCEDURE DeleteFromChain (VAR entry : TimerEntryType;                                 index : Int16;                              VAR hb    : Bucket);   LABEL      99;      VAR      leftentry : Int16;      rightentry : Int16;     result : Int16;   { return from send_event call }      PROCEDURE BailOut (loc : Int16; value : Int16);   VAR      ierr : Int16;         BEGIN     context.ints[1] := entry.socket;      context.ints[2] := entry.key;     location := DELETE + loc;         Log_Event (EL_DISASTER, ENTITY_TIMER, location,                context, 1, value, ierr);      goto 99;      END;       
BEGIN { DeleteFromChain }  
        IF entry.key = EMPTYENTRY THEN  { List is corrupt }        BEGIN         BailOut (1, LISTCORRUPT);         END;     leftentry := entry.left_ptr;      rightentry := entry.right_ptr;      IF rightentry <> EMPTYENTRY THEN         DS_StoreFields (DS_TimerEntryTD, rightentry, leftentry,                           LPTR_OFSET, PTR_LEN);      IF leftentry <> EMPTYENTRY THEN        BEGIN             DS_StoreFields (DS_TimerEntryTD, leftentry, rightentry,                           RPTR_OFSET, PTR_LEN);         END   #   ELSE { If it was, then it should also be the HB.tos.  Check first } #       BEGIN         IF hb.bucket_tos = index THEN            BEGIN  { pop from stack }           hb.bucket_tos := rightentry;            END    { pop from stack }        ELSE BEGIN  { diaster! }           BailOut (2, LISTCORRUPT);           END;  { diaster! }   %      END; { If it was, then it should also be the HB.tos.  Check first }  %     99:   
END;  { DeleteFromChain }  
         $PAGE$  #{-------------------------------------------------------------------}  # #{                                                                   }  # #{                 HashFunction                                      }  # #{                                                                   }  # #{                                                                   }  # #{ This function takes a time and returns a hash key calculated using}  # #{ the following algorithm :                                         }  # #{                                                                   }  # #{  key = (hashtime AND ((NUMBEROFBUCKETS shifted N bits left)-1)    }  # #{           shifted N bits to the right                             }  # #{                                                                   }  # #{ N is the 'granularity' of the hash.  If the granularity is 2,     }  # #{  then 0 and 1 will fall in the same bucket.   (fix this comment)  }  # #{                                                                   }  # #{ The hash function has the following results :                     }  # #{                                                                   }  # #{     All events within a single bucket will come due within :      }  # #{                                                                   }  # #{         (X * NUMBEROFBUCKETS + 1) * 2**(N-1) - 1, X >= 0          }  # #{         time incriments of each other.                            }  # #{                                                                   }  # #{     In other words, one can be assured that if the event is not   }  # #{     due in the next 2**(N-1)-1 incriments, it is not due for at   }  # #{     least NUMBEROFBUCKETS * 2**(N-1) incriments.                  }  # #{                                                                   }  # #{          NUMBEROFBUCKETS = 4                                      }  # #{                                                                   }  # #{         N\time  0  1  2  3  4  5  6  7  8  9 10 11 12             }  # #{                ______________________________________             }  # #{           1   | 0  1  2  3  0  1  2  3  0  1  2  3  0             }  # #{           2   | 0  0  1  1  2  2  3  3  0  0  1  1  2             }  # #{           3   | 0  0  0  0  1  1  1  1  2  2  2  2  3             }  # #{           4   | 0  0  0  0  0  0  0  0  1  1  1  1  1             }  # #{           5   | 0  0  0  0  0  0  0  0  0  0  0  0  0             }  # #{                                                                   }  # #{     N = 2                                                         }  # #{     Bucket 0 has times 0,1,8,9                                    }  # #{                                                                   }  # #{     If the event is not due in the next 1 incriments, it is not   }  # #{     due for at least 8 incriments                                 }  # #{                                                                   }  # #{-------------------------------------------------------------------}  # $page   FUNCTION HashFunction  ( hashtime : Int32) : Int16;           VAR      mask : Int32;     temp : Int32;         BEGIN {HashFunction}       { If hashdelta is not a power of 2, this will waste buckets }   &   { hashfunction(time) = hashfunction(time + (NumberOfBuckets*Hashdelta))}  &        mask := (NUMBEROFBUCKETS * HASHDELTA) -1;     temp := DoubleIntegerAnd(mask,hashtime);      HashFunction := temp DIV HASHDELTA;     END;  {HashFunction}   $PAGE$  #{-------------------------------------------------------------------}  # #{                                                                   }  # #{                 HashSoonest                                       }  # #{                                                                   }  # #{ This function finds the time within a hash bucket that is soonest }  # #{ with respect the the current time.                                }  # #{-------------------------------------------------------------------}  #     FUNCTION HashSoonest (          hb : Bucket;                         currenttime : Int32) : Int32;  !{ Modified 3/2/84 by ash to minimize the number of DSAM accesses } !     VAR      hashtime    : Int32;      nextentry   : TimerEntryType;     nxtptr      : Int16;      soonesttime : Int32;          BEGIN {HashSoonest}     nxtptr := hb.bucket_tos;      IF nxtptr = EMPTYENTRY THEN        BEGIN         hashsoonest := EMPTYTIME;         END      ELSE BEGIN  { There are entries to look at }         hashtime := hb.bucket_timeout;  !      DS_FetchElement (DS_TimerEntryTD, nxtptr, nextentry.mmbuf);  !       soonesttime := nextentry.time;        {}  %      { If we find one equal to the previous soonest, it will do just fine %       {}        WHILE (nextentry.time <> hashtime)        {}        { Search the entire list        {}        AND (nextentry.right_ptr <> EMPTYENTRY) DO           BEGIN            DS_FetchElement (DS_TimerEntryTD, nextentry.right_ptr,                                  nextentry.mmbuf);   $         { Find the soonest of two that is greater than the current time $          {}   $         soonesttime := Soonest(nextentry.time,soonesttime,currenttime); $          {}            { Go look at the next one           {}            END;         HashSoonest := soonesttime;         END;  { If there are entries to look at }      END;  {HashSoonest}  $PAGE$  #{-------------------------------------------------------------------}  # #{                                                                   }  # #{                     InsertEntry                                   }  # #{                                                                   }  # #{  InsertEntry takes an entry in the entry list and links it onto   }  # #{  a hash bucket for eventual processing by the timer.              }  # #{                                                                   }  # #{ Parameters :                                                      }  # #{                                                                   }  # #{  TmrIndex (input)                                                 }  # #{     The index of the entry that is to be inserted.                }  # #{                                                                   }  # #{  TmrEntry (input)                                                 }  # #{     The actual entry to be inserted into the list.                }  # #{                                                                   }  # #{  Move this to the section called Discussion                       }  # #{     The timeout time of the entry;  an absolute time based on     }  # #{     the user specified offset time.  This parameter is used to    }  # #{     decide if the new timeout time being inserted into a bucket   }  # #{     chain is sooner than the previous 'soonest timeout' for that  }  # #{     bucket.   Also the 'system soonest' timeout stored in         }  # #{     the stat table is compared with the new timeout time to see   }  # #{     if it is also the soonest system timeout which will occur.    }  # #{                                                                   }  # #{  currenttime (input)                                              }  # #{     The time at which the activate timer request was made         }  # #{                                                                   }  # #{  PdTout (INPUT/OUTPUT)                                            }  # #{     The current soonest time in the system.  May be reset as a    }  # #{     result of this insertion.                                     }  # #{                                                                   }  # #{   result (output)                                                 }  # #{     If the result is zero, the insert had no effect on the timer  }  # #{     environment.  If the nearest timeout has been changed, it     }  # #{     will require rescheduling the timer, and result will be       }  # #{     RESCHDTIMER.                                                  }  # #{-------------------------------------------------------------------}  #     PROCEDURE InsertEntry (      tmrindex    : Int16;                            VAR tmrentry    : TimerEntryType;                               WindowTime  : Int32;                            VAR SystemTimeout : Int32;                            VAR result      : Int16);  VAR   	   hash   : Int16; 	    hb : Bucket;   !   schedtime : Int32;   { The current value of soonest in system } !        BEGIN {InsertEntry}      hash := HashFunction (tmrentry.time); { Get the hash bucket }   %   DS_FetchFields (DS_TimerHashTD, 1, HB.bucket_tos, hash*BKTLEN, BKTLEN); %            { Set left pointer to the current TOS }     IF hb.bucket_tos <> EMPTYENTRY THEN        BEGIN          DS_StoreFields (DS_TimerEntryTD, hb.bucket_tos, tmrindex,                            LPTR_OFSET, PTR_LEN);         END;         tmrentry.right_ptr := hb.bucket_tos;      tmrentry.left_ptr := EMPTYENTRY;      hb.bucket_tos := tmrindex;  { set the new top of stack }          { Now see if we have to update the system times }         result := NOERROR;   
   WITH tmrentry DO  
 	      BEGIN {with} 	       {}        { If this is the first entry        {}        IF (hb.bucket_timeout = EMPTYTIME)        {}        { Or if this time is sooner than the soonest in the hash        {}  "      OR (Soonest(hb.bucket_timeout, time, WindowTime) = time) THEN  "       {}           BEGIN {If my timeout is the soonest in this hash}           hb.bucket_timeout := time;         {}  $      { Now that we know that the hash timeout has changed, it could be  $ #        that the requested timeout is actually sooner than anything in # 	        the system 	       {}  !         schedtime := SystemTimeout;  { read next schedule time }  !          {}            { If this is the first entry in the system            {}            IF (schedtime = EMPTYTIME)            {}   "         { Or if the insert is sooner than the soonest in the system "          {}            OR (Soonest(schedtime, time, WindowTime) = time) THEN              BEGIN {If my timeout is the soonest in the system}  $            SystemTimeout := time;       {Then reset the system timeout} $          {}            { And indicate that we need to reschedule the timer           {}               result := RESCHDTIMER;              END;  {If my timeout is the soonest in the system}           END;  {If my timeout is the soonest in the hash}   	      END;  {with} 	           { Now store the new values back in the tables }   "      DS_StoreFields (DS_TimerHashTD, 1, hb.bucket_tos, hash*BKTLEN, "                          BKTLEN);   !      DS_StoreElement (DS_TimerEntryTD, tmrindex, tmrentry.mmbuf); !        END;  {InsertEntry}      $Subtitle 'Remove Entry', PAGE$   #{-------------------------------------------------------------------}  # #{                                                                   }  # #{                 RemoveEntry                                       }  # #{                                                                   }  # #{  RemoveEntry takes as input an entry location in the entry list   }  # #{  and unlinks it from a hash bucket chain.                         }  # #{                                                                   }  # #{ Parameters :                                                      }  # #{  entry (INPUT)                                                    }  # #{     The entry which is to be removed from the hash bucket list.   }  # #{                                                                   }  # #{  entry_index (input)                                              }  # #{     Its index in the TimerEntry table.                            }  # #{                                                                   }  # #{  currenttime (INPUT)                                              }  # #{     The time of day at the time of removal request.               }  # #{                                                                   }  # #{  NewSoonest(OUTPUT)                                               }  # #{     The value of timeout in the stat table.  Passed               }  # #{     back to the stat table entry which is being stored in         }  # #{     the calling procedure.  The value is changed only if the      }  # #{     entry being removed is the soonest in the system.             }  # #{                                                                   }  # #{  result (output)                                                  }  # #{     If the result is zero, the removal had no effect on the timer }  # #{     environment.  If the nearest timeout has been changed, it will}  # #{     require rescheduling the timer, and result will be one.       }  # #{                                                                   }  # #{-------------------------------------------------------------------}  #     #{ The parameter entry is NOT a VAR parameter because its current value # { must be retained.  We could do an assignment later.   {}  PROCEDURE RemoveEntry(VAR entry       : TimerEntryType;                             entry_index : Int16;                            WindowTime  : Int32;                        VAR NewSoonest  : Int32;                        VAR result      : Int16);       LABEL      99;      VAR      hash        : Int16;      leftentry   : Int16;      rightentry  : Int16;      hb          : Bucket;     se_result   : Int16; { results from send event call }     tname       : TimerName;       $page$     BEGIN {RemoveEntry}     result := 0;      hash := HashFunction(entry.time);  %   DS_FetchFields (DS_TimerHashTD, 1, hb.bucket_tos, hash*BKTLEN, BKTLEN); %        DeleteFromChain (entry, entry_index, hb);         IF hb.bucket_timeout = entry.time THEN   "      BEGIN {If I'm the soonest in the hash, find the next soonest}  "       hb.bucket_timeout := HashSoonest(hb, WindowTime);   "      DS_StoreFields (DS_TimerHashTD, 1, hb.bucket_tos, hash*BKTLEN, "                         BKTLEN);            IF (NewSoonest = entry.time) THEN   $         BEGIN {If I'm the soonest in the system, find the next soonest} $          NewSoonest := SystemSoonest (WindowTime);           IF NewSoonest <> EMPTYTIME THEN              BEGIN {If there are more events, reschedule timer}              result := RESCHDTIMER;              END   {If there are more events, reschedule timer}           ELSE BEGIN { remove timer from the time list }               tname.name := 'TIMER ';               UnSchedule (EXEC12, tname, 0);                 BEGIN { error processing }   "               msg.chars := 'Error removing Timer from time list.';  "                location := REMOVE;                 context.longint := 0;  "               Log_Event (EL_ERROR, ENTITY_TIMER, location, context, "                            -36, msg.emsg.int, se_result);                  result := EXEC12ERROR;                  goto 99;                  END;  { error processing }               result := NOERROR;              END     { remove timer from the time list }   $         END;  {If I'm the soonest in the system, find the next soonest} $ "      END   {If I'm the soonest in the hash, find the next soonest}  "    ELSE         BEGIN { not soonest; store it back }  "      DS_StoreFields (DS_TimerHashTD, 1, hb.bucket_tos, hash*BKTLEN, "                        BKTLEN);         END;     99:     END;  {RemoveEntry}  $PAGE$  #{-------------------------------------------------------------------}  # #{                                                                   }  # #{                 ReSchedule                                        }  # #{                                                                   }  # #{ This routine takes a long integer time value, converts it into    }  # #{ the form required by exec and issues the exec request.            }  # #{                                                                   }  # #{  If the time to pop is within a five minute window or has just    }  # #{  elapsed, then a relative time schedule call is used.  If longer  }  # #{  then an absolute time schedule call.  At no time is the schedule }  # #{  request shorter than 10 cs from the current time; busy systems   }  # #{  cannot handle that fine a window.                                }  # #{                                                                   }  # #{-------------------------------------------------------------------}  #     PROCEDURE ReSchedule(    rescheduletime : Int32;                       VAR tname          : TimerName;                       VAR result         : Int16);       LABEL      99;      CONST      PROCESSTIME = 10; { 10 centiseconds for now }      VAR   
   iresl   : Int16;  
 
   imult   : Int16;  
    tarray  : TimeArrayType;      se_rslt : Int16;     { result from send_event call }   
   newtime : Int16;  
    currenttime : Int32;   
   mintime : Int32;  
 
   maxtime : Int32;  
     {------------------------------------------}  {        LogError                          }  {------------------------------------------}  PROCEDURE LogError (loc : Int16);       VAR      ierr : Int16;      BEGIN          msg.chars := 'Error rescheduling Timer.';     location := RESCHED + loc;      context.longint := 0;     Log_Event (EL_ERROR, ENTITY_TIMER, location, context,                -25, msg.emsg.int, ierr);   
   result := EXEC12ERROR;  
    goto 99;   END;      $ page $         BEGIN {ReSchedule}      iresl := 1;     imult := 0;     result := 0;   $   IF rescheduletime <> EMPTYTIME THEN { Make sure it is a valid time }  $       BEGIN         currenttime := TimeOfDay;             maxtime := (currenttime + MAXINT16) MOD CSPD;         mintime := currenttime - MAXINT16;        IF mintime < 0 THEN mintime := mintime + CSPD;      #      { If we are within a five minute window then do a relative time  #       { schedule.  MAXINT16 csecs is about 5 minutes }        IF WithinWindow (mintime, maxtime, rescheduletime) THEN            BEGIN { relative time schedule }   "         IF WithinWindow (mintime, currenttime, rescheduletime) THEN "             BEGIN { time has just elapsed }   #            newtime := -1*PROCESSTIME; { we need a 10 cs window here } #             END   { time has just elapsed }            ELSE BEGIN { time is just around the corner }              IF currenttime > rescheduletime THEN                 BEGIN { diff side of midnight }  "               newtime := -1 * (rescheduletime + (CSPD-currenttime)) "                END   { diff side of midnight }              ELSE newtime := currenttime - rescheduletime;                   { now make sure we have at least 10 cs slack }              IF ABS (newtime) < PROCESSTIME THEN                  BEGIN { adjust for scheduling problems }                  newtime := -1*PROCESSTIME;                  END;  { adjust for scheduling problems }               END;    { time is just around the corner }            { relative schedule is with a negative time offset }           SchedRelative (EXEC12, tname, iresl, imult, newtime);              BEGIN { error processing }  
            LogError (1);  
             END;  { error processing }           result := NOERROR;   { normal return }            END   { relative time schedule }                 ELSE BEGIN           tarray := Converttime(rescheduletime);   #         SchedAbsolute (EXEC12,tname,iresl,imult,tarray[0],tarray[1],  #                                         tarray[2],tarray[3]);               BEGIN { error processing }  
            LogError (2);  
             END;  { error processing }               result := NOERROR;            END { absolute schedule }        END { valid request }       ELSE        BEGIN         result := INVALIDTIME;        END;     99:     END;  {ReSchedule}       $PAGE$  #{-------------------------------------------------------------------}  # #{                                                                   }  # #{                 ResetTimer                                        }  # #{                                                                   }  # #{ This call may be used to reset a previously issued timer          }  # #{  request to a later time.                                         }  # #{                                                                   }  # #{ Parameters :                                                      }  # #{                                                                   }  # #{  ofset (input)                                                    }  # #{     The ofset from the current time for the reset request.        }  # #{                                                                   }  # #{  TimerId (input/output)                                           }  # #{    The structure's values are returned from the ActivateTimer     }  # #{    call.  The structure is used  the same way it is used          }  # #{    for a cancel request.  A new TimerId is returned to the        }  # #{    caller since the entry will be inserted into a different       }  # #{    place in the timer data structure.                             }  # #{                                                                   }  # #{ result (output)                                                   }  # #{    Returns zero if the call was successful,  INVALISDTIMERID if   }  # #{    the key provided does not match the one stored in the entry    }  # #{                                                                   }  # #{                                                                   }  # #{-------------------------------------------------------------------}  #     PROCEDURE ResetTimer(    ofset      : Int32;                       VAR TimerId    : TimerIdType;                       VAR rst_result : Int16);       VAR      currenttime : Int32;      soonesttime : Int32;      windowtime : Int32;     insresult : Int16;      result : Int16;      { result from the remove entry call }      se_result : Int16;   { result from send_event call }      canresult : Int16;      centry : TimerEntryType;   { the entry to be cancelled }      stat : StatTableType;     hb : Bucket;      hash : Int16;     progname : TimerName;      $page$  {-----------------------------------------}   
{     LogError (internal)  
 {-----------------------------------------}   PROCEDURE LogError (loc : Int16;  value : Int16);       VAR   	   ecode : Int16;  	     BEGIN      location := RESETT + loc;     context.ints[1] := timerid.index;     context.ints[2] := timerid.key;     IF value = INVALIDTIMERID THEN         BEGIN   
      ecode := EL_WARNING  
       END      ELSE         BEGIN         ecode := EL_ERROR;        END;         Log_Event (ecode, ENTITY_TIMER, location,                 context, 1, value, result);  END;      $page$     BEGIN {ResetTimer}   !   currenttime := TimeOfDay;               {note the current time} !    result := 0;   	   canresult := 0; 	     #   IF (TimerId.index >= 0) AND (TimerId.index < NUMBEROFENTRIES) THEN  #       BEGIN {valid TimerId}         { read in the entry from DSAM }         DS_FetchElement (DS_TimerStatTD, FIRST, stat.mmbuf);        stat.nrset := stat.nrset + 1;       #      DS_FetchElement (DS_TimerEntryTD, TimerId.Index, centry.mmbuf);  #       IF centry.key = TimerId.key THEN           BEGIN { keys match }            hash := HashFunction(centry.time);   $         DS_FetchFields (DS_TimerHashTD, 1, hb.bucket_tos, hash*BKTLEN,  $                           BKTLEN);           DeleteFromChain (centry, TimerId.index, hb);            IF hb.bucket_timeout = centry.time THEN              BEGIN { change the bucket time }              windowtime := SetWindow (currenttime);              hb.bucket_timeout := HashSoonest (hb, windowtime);              { If this is the soonest in the system }              IF centry.time = Stat.soonest THEN                 BEGIN    { change the system time  }                  stat.soonest := SystemSoonest (windowtime);                 canresult := RESCHDTIMER;                 END;     { change the system time  }               END;  { change the bucket time }  $         DS_StoreFields (DS_TimerHashTD, 1, hb.bucket_tos, hash*BKTLEN,  $                           BKTLEN);              { Now change the time value for the entry }           centry.time := (currenttime + ofset) MOD CSPD;          { and insert it in the right bucket }           InsertEntry (TimerId.index, centry, windowtime,                        stat.soonest, insresult);  #        IF (insresult = RESCHDTIMER) OR (canresult = RESCHDTIMER) THEN # 	            BEGIN  	             progname.name := 'TIMER';               reschedule (stat.soonest, progname, result);              rst_result := result;               END            ELSE BEGIN  { no need to reschedule }                 rst_result := Insresult;                  END      { no need to reschedule }            END   { keys match }         ELSE BEGIN           rst_result := INVALIDTIMERID;           LogError (1, rst_result);           END;         DS_StoreElement (DS_TimerStatTD, FIRST, stat.mmbuf);        END   { valid cancelid }     ELSE BEGIN         rst_result := INVALIDTIMERID;         LogError (2, rst_result);         END;  	END; {ResetTimer } 	         $ SUBTITLE 'SetWindow', PAGE $  #{-------------------------------------------------------------------}  # {                 SetWindow   #{-------------------------------------------------------------------}  # 	FUNCTION SetWindow 	    (currenttime   : Int32)  : Int32;      ${  Because RTE may take a few cs to schedule a program, or it may take } $ ${     a few cs to go critical, there could be a race condition any     } $ ${     time we ant to find the next soonest time in the hash chain or   } $ ${     in the system.  Therefore all searches for a 'next soonest'      } $ ${     are done with relative to a time five minutes ago, instead of    } $ ${     the currenttime.  This function determines that time.            } $     VAR      windowtime : Int32;      
BEGIN { setwindow }  
 WindowTime := currenttime - FIVEMINS;   IF WindowTime < 0 THEN     BEGIN { we are within five minutes of midnight }      windowtime := windowtime + CSPD;      END;  { we are within five minutes of midnight }       SetWindow := windowtime;  
END;  { setwindow }  
     $ PAGE      #{-------------------------------------------------------------------}  # #{                                                                   }  # #{                 Soonest                                           }  # #{                                                                   }  # #{ This routine will take as input two long integer time values and  }  # #{ return that time that is soonest after the current time.          }  # #{                                                                   }  # #{-------------------------------------------------------------------}  #     FUNCTION Soonest( time1,                    time2,                    currenttime : Int32) : Int32;       VAR   	   delta1 : Int32; 	 	   delta2 : Int32; 	     	   BEGIN {Soonest} 	        { Take care of the case where either time is -1 first }     IF time1 = EMPTYTIME THEN        Soonest := time2     ELSE if time2 = EMPTYTIME THEN         Soonest := time1     ELSE BEGIN { both times exist }  %      { Take care of the cases where some of the times are the next day }  %       IF time1 - currenttime < 0        THEN delta1 := time1 + CSPD         ELSE delta1 := time1;             IF time2 - currenttime < 0        THEN delta2 := time2 + CSPD         ELSE delta2 := time2;             IF delta1 <= delta2 THEN           BEGIN  
         Soonest := time1; 
          END        ELSE           BEGIN  
         Soonest := time2; 
          END;         END { both times exist }  	   END;  {Soonest} 	 $PAGE$      #{-------------------------------------------------------------------}  # #{                                                                   }  # #{                 SystemSoonest                                     }  # #{                                                                   }  # #{ This function does a linear search of all the hash buckets to     }  # #{  find the one with the soonest time (with respect to the current  }  # #{  time.  It gets the whole table and does the search in local      }  # #{  space.                                                           }  # #{-------------------------------------------------------------------}  #     FUNCTION SystemSoonest(currenttime : Int32) : Int32;      VAR      nexthash    : Int16;      nexttime    : Int32;      soonesttime : Int32;      count       : Int16;      HTable : HashEntry;      BEGIN {SystemSoonest }     DS_FetchElement ( DS_TimerHashTD, 1, HTable.mmbuf);     count := 1;     soonesttime := HTable.tbl[0].bucket_timeout;       	   WITH HTable DO  	       BEGIN         WHILE count < NUMBEROFBUCKETS DO           BEGIN           nexttime := tbl[count].bucket_timeout;            IF nexttime <> EMPTYTIME THEN  $            soonesttime := Soonest (nexttime, soonesttime, currenttime); $          count := count + 1;           END;         END;         SystemSoonest := soonesttime;     END;  {SystemSoonest}  $PAGE$      #{-------------------------------------------------------------------}  # #{                                                                   }  # #{                 TimeOfDay                                         }  # #{                                                                   }  # #{ This routine calculates the time of day using $TIME.              }  # #{                                                                   }  # #{-------------------------------------------------------------------}  #     FUNCTION TimeOfDay : Int32;       
   BEGIN {TimeOfDay} 
    TimeOfDay := DollarTime + CSPD;  
   END;  {TimeOfDay} 
     $page$  #{-------------------------------------------------------------------}  # #{                                                                   }  # #{                 WithinWindow                                      }  # #{                                                                   }  # #{ This function determines whether a given time is within a         }  # #{ specified time window.  If the test time is within the window     }  # #{ (mintime < testtime < maxtime) then the return value is true,     }  # #{ otherwise the return value is false.                              }  # #{                                                                   }  # #{ If either of the two is negative, then that means the window      }  # #{  is invalid to begin with.  (ash)                                 }  # #{-------------------------------------------------------------------}  #     FUNCTION WithinWindow (mintime  : Int32;                         maxtime  : Int32;                         testtime : Int32) : BOOLEAN;          BEGIN {WithinWindow}       IF ((mintime >= 0) AND (maxtime >= 0)) AND (testtime>=0) THEN         BEGIN   { valid window }  #      IF mintime <= maxtime THEN  { both on the same side of midnight} #          BEGIN {mintime<=maxtime}             IF (testtime >= mintime) AND (testtime <= maxtime) THEN   	            BEGIN  	             WithinWindow := TRUE;               END             ELSE  	            BEGIN  	             WithinWindow := FALSE;              END;           END   {mintime<=maxtime}         {}  !      { The less obvious is when mintime is greater than maxtime,  ! $      { which says that mintime is before midnight and maxtime is after. $       {}         ELSE            BEGIN {mintime>maxtime}            IF (testtime >= mintime) OR (testtime <= maxtime) THEN    	            BEGIN  	             WithinWindow := TRUE;               END             ELSE  	            BEGIN  	             WithinWindow := FALSE;              END;           END;  {mintime>maxtime}  
      END { valid window } 
     ELSE        BEGIN         WithinWindow := FALSE;        END;     END;  {WithinWindow}   END. 