 $PASCAL '91790-1X222 REV.4010 <860319.1609> '   $STANDARD_LEVEL 'HP1000'  $debug$   $ HEAPPARMS OFF, RECURSIVE OFF, HEAP 0, HEAP_DISPOSE OFF $      MODULE TMRinit;   	$ALIAS 'N$TMRinit' 	     {------------------------------------------------------------    (c) COPYRIGHT HEWLETT PACKARD COMPANY 1986. ALL RIGHTS    RESERVED. NO PART OF THIS PROGRAM MAY BE PHOTOCOPIED,   REPRODUCED OR TRANSLATED TO ANOTHER PROGRAM LANGUAGE WITHOUT    THE PRIOR WRITTEN CONSENT OF THE HEWLETT-PACKARD COMPANY.   ------------------------------------------------------------}  {}  {     NAME:   TMRINIT   
{     SOURCE: 91790-18222  
 	{     RELOC:  NONE 	 	{     PGMR:   ASH  	 {}      { MODULE DESCRIPTION:   {  Initializes the timer tables.  !{  For now uses the magic number concept to allocate space for the ! !{  tables in DSAM.  In the future, these values should be modified ! {  to reflect the relative size of the NS subsystem.  Notes   "{  appear in the code to serve as hints for the calculation of those " {  values.  {}  {  NOTE:   {  Lines of code with (**) comments would have been used with a    "{  message based timer, which was in the original design.  However,  " !{  because of memory accounting problems (specifically, how could  ! "{  we guarantee the memory to send a message), the timer was changed " #{  to be exclusively a signal based timer.  If in the future the need  # !{  arises for a message based timer, the code is still here and in ! {  all related timer modules.   {}      IMPORT     $SEARCH 'phtm/BODEC.rel'      bodec,      $search 'phtm/sodec.rel'      sodec,      $search 'phtm/mmdec.rel'      mmdec,      $search 'phtm/mmext.rel'      ds_mm,      $SEARCH 'phtm/init_dec.rel'     init_dec,     $SEARCH 'phtm/initmulti.xpt'      initmulti,      $SEARCH 'phtm/parsdd.xpt'     parser,     $SEARCH 'phtm/filemad.xpt'      fileman,   
   $search 'phtm/dres.xpt' 
    dres,     $search 'phtm/init_rte_if.xpt'      init_rte_if,      $search 'phtm/tmrdec.rel'     tmrdec;  { timer specific declarations }               $SUBTITLE ' Export procedures ', PAGE$      EXPORT      {--------------------------------------------------------}  {                                                        }  {          EXPORT   PROCEDURES                           }  {                                                        }  {--------------------------------------------------------}          PROCEDURE SynTMR     (VAR smbsize     : Int16;      VAR dsamtbsize  : Int16;      VAR socketcnt   : Int16;      VAR classcnt    : Int16;      VAR rsncnt      : Int16;      VAR result      : Int16);           	PROCEDURE ShutTMR  	    (    trustvar    : TrustType;      VAR result      : Int16);           	PROCEDURE InitTMR  	    (VAR result : Int16);          {----------------------------------------------------}  {               Implement Section                    }  {----------------------------------------------------}      IMPLEMENT       $SUBTITLE 'TMR Syntax Check routine',PAGE$  {-------------------------------------------}   {                SynTMR                     }   {-------------------------------------------}       PROCEDURE SynTMR     (VAR smbsize     : Int16;      VAR dsamtbsize  : Int16;      VAR socketcnt   : Int16;      VAR classcnt    : Int16;      VAR rsncnt      : Int16;      VAR result      : Int16);       {}  { DESCRIPTION :    {  Here are the hints for ht eeventual calculation of the table    {  sizes:   {   ${  entrytbsize = 4*(initglobals.IG_tot_nodal_sockets) [tot sys sockets]  $ ${              + 2*(initglobals.IG_tot_nodal_progs)   [tot sys programs] $ {   {  hashtbsize  = 2^N such that   {                (2^N) >= SQRRT (avg # active timers in system)    {   "{  NOTE: the equation for the optimum value for hashtbsize has been  " {     calculated theoretically but has yet to be substantiated  "{     experimentally.  Through calculations, we found that the best  " "{     performance came when the size of the hash table was equal to  " !{     the average depth of a chain linked to a hash table bucket.  ! "{     Because of the hash function, the size of the hash table must  " {     be a power of 2.  {   #{     Clearly, we are a long way from determining how to calculate the # "{     average number of timers in the system at initialization time. " {}              VAR      entrytbsize : Int16;  { timer entry table size }      hashtbsize  : Int16;  { hash table size }     stattbsize  : Int16;  { timer stat table size }      BEGIN {SynTMR}      entrytbsize := NUMBEROFENTRIES * WORDSPERENTRY;   hashtbsize  := NUMBEROFBUCKETS * BKTLEN;  stattbsize  := NUMBEROFSTATS   * WORDSPERSTAT;      { Return the total DSAM required }  dsamtbsize  := entrytbsize + hashtbsize + stattbsize;   END;  {SynTMR}      $SUBTITLE 'TMR Shutdown module', PAGE$  {-------------------------------------------}   {                ShutTMR                    }   {-------------------------------------------}       	PROCEDURE ShutTMR  	    (    trustvar    : TrustType;      VAR result      : Int16);       VAR      progname : PNameType;      BEGIN {shutdown}  progname := 'TIMER ';   DS_StopMonitor (progname, result);      result := GOOD;   END;  {shutdown}      $SUBTITLE 'Initialize TMR ', PAGE$  {------------------------------------------------------------}  {               TMR Initialization                           }  {------------------------------------------------------------}      	PROCEDURE InitTMR  	    (VAR result      : Int16);       #{--------------------------------------------------------------------  # { MODIFICATIONS   {  3/84 ash   #{     Changed to reserve a timer socket.  Added DS_Enter/LeaveCritical # {     calls.  Removed the special treatment for timer entry 0.  {  10/84 ash  ${     Added the ability to run the timer as a dummy (not notify anyone). $ ${     The user would schedule TmInit with any single character parameter $ #{     in the runstring.  It set NotifyAll in the stat table to False,  # "{     signifying to the timer it should clean up its tables but not  " 
{     notify anyone. 
 {  4/16/85  {     Removed above ability   {  2/18/86 ash  #{     Changed names of unused EvmonGlobal block field to be "reserved" # #--------------------------------------------------------------------}  # {}  $PAGE$      LABEL      999;       CONST      ABORTIFNOTPRESENT = TRUE;     TIMERNAME = 'TIMER ';      VAR          error            : Int16;     TmrEntry         : TimerEntryType;      HTable           : HashEntry;     i                : Int16;     statentry        : StatTableType;     wkmp             : Int16;      { for critical calls }  !(* gsd              : SBufIdType; { global socket descriptor }  *) ! !(* mc               : Int16;      { for sbinit call }           *) ! !(* mmflags          : MmFlagsType;                              *) !         	PROCEDURE ExitInit 	    (VAR ecode : Int16);              BEGIN { exitinit }      DS_InitLeaveCritical (wkmp);   
   result := ecode;  
    goto 999;     END;  { exitinit }               $PAGE$      BEGIN { Init }     result := 0;   { initialize }         { see if Timer is in the system.  If not, there's no need     to do anything else.                                      }     DS_CheckIDSeg( TIMERNAME, ABORTIFNOTPRESENT, result );   
   IF result <> GOOD THEN  
       BEGIN    { no timer program }             result := ERR_ALREADY_PRINTED;        GOTO 999;         END;     { no timer program }       #   { allocate table space for all three timer tables: hash table,    } # #   { entry table and statistics table                                } #        DS_InitEnterCritical (wkmp, error);     IF error <> 0 THEN         BEGIN         result := error;        goto 999;         END;         DS_GetTableSpace(DS_TimerHashtd,1, 1,                      NUMBEROFBUCKETS*BKTLEN,error);     IF error <> 0 THEN ExitInit (error);           DS_GetTableSpace(DS_TimerEntryTd,ENTRYMINELE,NUMBEROFENTRIES,                       WORDSPERENTRY,error);      IF error <> 0 THEN ExitInit (error);          DS_GetTableSpace(DS_TimerStattd,STATMINELE,NUMBEROFSTATS,                      WORDSPERSTAT,error);     IF error <> 0 THEN ExitInit (error);       $(*   SoInitCreate (1, 0, 20, 22, ROOTSOCKET, gsd, error );           *)  $     	   WITH HTable DO  	       BEGIN { initialize hash entry }         FOR i := 0 TO NUMBEROFBUCKETS-1 DO           BEGIN           tbl[i].bucket_tos := EMPTYENTRY;            tbl[i].bucket_timeout := -1;            END;  { write out each entry }   
      END;  { with } 
        DS_StoreElement (DS_TimerHashTD, 1, HTable.mmbuf);       
   WITH TmrEntry DO  
       BEGIN { initialize timer entry }        left_ptr := EMPTYENTRY;         time := EMPTYTIME;        key := EMPTYENTRY;   (*    signal := TRUE;                                        *)          signalkind := 1;  
      socket := -1;  
  (*    port := -1;                                            *)     (*    downref := -1;                                         *)     (*    message := EMPTYMESSAGE;                               *)          END;  { initialize timer entry }      
{ Store them all in DSAM } 
    FOR i := 0 TO NUMBEROFENTRIES-2 DO         BEGIN { write out each timer entry }  #      TmrEntry.right_ptr := i+1; { Link into a list of free entries }  #       DS_StoreElement(DS_TimerEntryTd,i,TmrEntry.mmbuf);        END;  { write out each timer entry }         { store the last in the chain }     TmrEntry.right_ptr := EMPTYENTRY;  #   DS_StoreElement(DS_TimerEntryTd,NUMBEROFENTRIES-1,TmrEntry.mmbuf);  #     
   WITH statentry DO 
       BEGIN { initialize stat table }   
      soonest := -1; 
 	      activ  := 0; 	 	      nactv  := 0; 	 	      ncanc  := 0; 	 	      nrset  := 0; 	 	      npops  := 0; 	 
      ntoofull := 0; 
       FreeLstHd := 0;    (*       sbuf   := gsd + gsd;  { timer outbound sbuf }        *)         END;  { initialize stat table }          DS_StoreElement(DS_TimerStatTD,FIRST,statentry.mmbuf);      DS_InitLeaveCritical (wkmp);       999:      END; { init }           END   .  