 $PASCAL '91790-18213 REV.4010 <860813.1410>'$   
$TITLE 'Inbound handler'$  
 $STANDARD_LEVEL 'HP1000'  $DEBUG$   $WIDTH 90   $HEAPPARMS OFF  
$RECURSIVE OFF, RANGE OFF$ 
 $HEAP 0   	$HEAP_DISPOSE OFF  	         MODULE TI;  $ALIAS 'N$TI'$      {------------------------------------------------------------    (c) COPYRIGHT HEWLETT PACKARD COMPANY 1986. ALL RIGHTS    RESERVED. NO PART OF THIS PROGRAM MAY BE PHOTOCOPIED,   REPRODUCED OR TRANSLATED TO ANOTHER PROGRAM LANGUAGE WITHOUT    THE PRIOR WRITTEN CONSENT OF THE HEWLETT-PACKARD COMPANY.   ------------------------------------------------------------}          {}  {       NAME: TCPIN.PAS                              }  {     SOURCE: 91790-18213                            }  {      RELOC: NONE                                   }  {       PGMR: MCL                                    }  {}      {}  {  Modification Histroy   {  --------------------   {   !{ Feb 24th 1986: Delete the error logging code when zero checksum  !  {     packet is received. It is part of code left from previous    {     debugging effort.   {   #{ Mar 15th 1986: Import INVALIDTIMERID from tmrdec instead of the TCP  # "{     constant -3. This bug may cause TCP to activate the same timer " {     twice and hence create 'orphan timer' symtom.   {   "{ Apr 2nd 1986 (REV 2626): TCP processing of packet with partial old " #{     data can cause user data to corrupted; it adjusted the mbuf with # !{     the protocol headers instead of the data only. The change is ! #{     not to do the adjustment and let the reassembly take care of it. # {     Add comment to clarify the processing logic. SR# 35626.   {   #{ Jul 24th 1986 (REV 4010): TCP does not calculate checksum correctly  # "{     when TCP options is present in the incoming packet. The change " !{     is to a) make sure the DS_Mread() is non-destructive and b)  ! !{     store the option adjustment (optlen) to the IP psuedo header ! {     after TCP checksumming. SR# 2200037259.   {   %{ Aug 13th 1986 (REV 4010): TCP may deliver partial message (MESSAGE MODE) % !{     to NFT when there are multiple complete messages and partial !  {     message on the reassembly queue. The problem stems from a    !{     uninitialized variabe within the REPAET loop. The fix is to  ! "{     move the 'mflag' initialization from outside of the loop into  " {     the loop.  SR# 2200-037853  {}      IMPORT     $SEARCH 'phtm/BODEC.REL'      bodec,      $SEARCH 'phtm/SODEC.REL'      sodec,      $SEARCH 'phtm/MMDEC.REL'  {memory manager declaration}      mmdec,      $SEARCH 'phtm/MMEXT.REL'      ds_mm,      $SEARCH 'phtm/Trcmod.REL'     trcmod,     $SEARCH 'phtm/SIGMOD.REL'     sigmod,     $SEARCH 'phtm/TMRDEC.REL'     tmrdec,     $SEARCH 'phtm/TCPGB.REL'  {tcp global declarations}     tg,     $SEARCH 'phtm/TUSER.REL'      tuser,      $SEARCH 'phtm/TCPLB.REL'      tl;      $SUBTITLE 'Export Section', PAGE$       EXPORT      
PROCEDURE TCPInbound 
    (VAR e_msg  : EventMessageType;      VAR result : Int16         );           $SUBTITLE 'Implement Section', PAGE$      IMPLEMENT           VAR   "   updategbl: Boolean;       {Global Update flag                  }  "             {----------------------------------------------}  {             ProSw                            }  {----------------------------------------------}      PROCEDURE ProSw      (VAR e_msg     : EventMessageType;       VAR result    : Int16             );     EXTERNAL;          $SUBTITLE 'TCP Reassembly routines', PAGE$  {--------------------------------------------------}  {                InsertQueue                       }  {--------------------------------------------------}      PROCEDURE InsertQueue      (    segptr  : Int16;          listptr : Int16;      VAR tcp_error   : Int16);   {}  {   { Description:  {  Insert a incoming segment (segptr) into the  {  reassembly queue before the element (listptr).   {   { Parameters:   {  segptr    INPUT  Pointer to the incoming data segment.   {  listptr   INPUT  Pointer to the element in the reassembly  
{                   queue. 
 {   {}      VAR   "   in_ptr   : ReassPtrType;  {local copy of incoming segment links}  " "   nxt_ptr  : ReassPtrType;  {local copy of working segment links }  " "   mm_flags : MMFlagsType;   {flags word for memory manager calls }  "     
BEGIN {insertqueue)  
 {set mm_flags}  mm_flags.int     := 0;  
mm_flags.bits[0] := true;  
 WITH in_ptr DO     BEGIN {with}      {get pointers into local space}     DS_Mread(nxt_ptr.int, 4, listptr, 0, mm_flags, tcp_error);      DS_Mread(in_ptr.int, 4, segptr, 0, mm_flags, tcp_error);          {fill in incomig segment links}     previous:= nxt_ptr.previous;   	   next:= listptr; 	    nxt_ptr.previous:= segptr;      DS_MBOverWrite(nxt_ptr.int, 4, listptr, 0, tcp_error);      DS_MBOverWrite(in_ptr.int, 4, segptr, 0, tcp_error);          {Get previous segment links}      DS_Mread(nxt_ptr.int, 4, previous, 0, mm_flags, tcp_error);  
   nxt_ptr.next:= segptr;  
    DS_MBOverWrite(nxt_ptr.int, 4, previous, 0, tcp_error);     END;  {with}   	END; {insertqueue) 	             {----------------------------------------------------}  {                  RemFrmQueue                       }  {----------------------------------------------------}      PROCEDURE RemFrmQueue      (    target: Int16;      VAR tcp_error : Int16 );      {}  { Description:  {  The procedure is called to remove target data  {  segment from the reassembly queue; the target  {  is addressed by a pointer to the mbuf which  {  contain the data segment.  {   { Parameters:   {  target   INPUT  Pointer to the data segment in the   {                  reassembly queue.  {   {}      VAR   !   in_ptr  : ReassPtrType;   {local copy of target segment links}  ! !   nxt_ptr : ReassPtrType;   {local copy of working segment link}  ! !   mm_flags: MMFlagsType;    {flags for memory manager calls    }  !     
BEGIN {remfrmqueue}  
 {Set mm_flags to non-destructive read}  mm_flags.int     := 0;  
mm_flags.bits[0] := true;  
     WITH in_ptr DO     BEGIN {with}      {get a local copies of links}     DS_Mread(in_ptr.int, 4, target, 0, mm_flags, tcp_error);      DS_Mread(nxt_ptr.int, 4, next, 0, mm_flags, tcp_error);         {update the forward link}     nxt_ptr.previous:= previous;      DS_MBOverWrite(nxt_ptr.int, 4, next, 0, tcp_error);         {update the backward link}      DS_Mread(nxt_ptr.int, 4, previous, 0, mm_flags, tcp_error);     nxt_ptr.next:= next;      DS_MBOverWrite(nxt_ptr.int, 4, previous, 0, tcp_error);     END;  {with}   	END; {remfrmqueue} 	                     $ SUBTITLE 'TCP Input Routine', PAGE$   "{-----------------------------------------------------------------}  " "{                                                                 }  " "{                     TCPInput                                    }  " "{                                                                 }  " "{-----------------------------------------------------------------}  " 	PROCEDURE TCPInput 	    (VAR e_msg       : EventMessageType);      {}  { Description:  {  This routine is called by the TCPInbound routine, to   {  process an incoming data segment delivered by IP. The  {  segment is first ckecked for validity and then handled   {  according to the state context of the addressed connection.  {   { Parameters:   {  e_msg    INPUT  Event message from IP.   {   
{ Global Variables:  
 {  sv        Connection control block (local copy).   {  tcp_port  path structure local copy.   {  sb_ptr    socket reference (write half).   {  sv_ptr    pointer to the pcb in dssm area.   {   {}      LABEL      888,      666;       VAR     tempvar   : Int16;          {temporary variable            }    data_in_q : Int16;          {Data in message queue         }    insegptr  : Int16;          {pointer to incoming segment   }    offset    : Int32;          {header offset                 }    datalen   : Int32;          {user data                     }    length    : Int32;          {tcp length + ip header        }    optlen    : Int16;          {tcp option length             }    tcpoption : Int16;          {tcp option flag               }    option_buf: OptionBufType;  {tcp option buffer (local)     }    rsp_flags,                  {remote response flags         }    tcpflags  : OneOrBitType;   {tcp control flags from seg.   }    todrop    : Int16;          {number of byte to discard     }    incksum   : Int16;          {incoming segment checksum     }    cksumword : Int16;          {calculated checksum           }    acked     : Int16;          {number of bytes acked         }    moffset   : Int16;          {mbuf offset for checksumming  }    cksum_ok  : BOOLEAN;        {flag indicate cksum valid     }    trimed    : BOOLEAN;        {flag indicate seg. trimed     }    mm_flags  : MMFlagsType;    {flags for memory manager calls}          CONST       
   INITBUFF = IPTCPHdrType 
       [Hdr1: OvlyHdrType            [ih_prev : 0,              ih_next : 0,              ih_x1   : 0,              ih_pr   : TCP_PTCL,             ih_adj  : 0,              ih_len  : TCPHEADERSIZE,              ih_pad  : 0,              ih_src  : 0,              ih_dst  : 0],         Hdr2: TCPHdrType             [th_sport : 0,             th_dport : 0,             th_seq   : 0,             th_ack   : 0,             th_x2    : 0,             th_off   : 5,             th_flags : OneOrBitType [w : 0],              th_win   : 0,             th_sum   : 0,  
           th_urp   : 0]]; 
             $SUBTITLE 'Routine to handle urgent data', PAGE$  {-----------------------------------------------------}   {                   DoUrgentData                      }   {-----------------------------------------------------}   PROCEDURE DoUrgentData;   {}  { Description:  {  To be implemented in the future.   {   {}  
BEGIN {dourgentdata} 
 
END;  {dourgentdata} 
         $SUBTITLE ' Routine to drop the segment', PAGE$   {----------------------------------------------}  {                 JustDrop                     }  {----------------------------------------------}      	PROCEDURE JustDrop 	    (kill_req :  Int16);           {}  {   { Description:  {  This routine is called by TCPInput, DropWithReset and  {  DropAfterAck to discard the segment and exit TCPInput.   {  A kill request with message count 1 is sent to IP if   {  kill_req is non-zero.  {   { Parameters:   {  kill_req   INPUT   null means no KILL request is needed.   {                     non-zero means need to abort path.  {}      BEGIN {justdrop}      #{If debug then not releasing the incoming segment and log its mbuf id} # IF (tcpgbls.tcp_debug > 0) AND (tcp_error = BADCHECKSUM) THEN      BEGIN     TCPLogError(insegptr, TI_TCPINBOUND);     END  ELSE     DS_MDispose(insegptr, tcp_error);      IF kill_req <> 0 THEN      BEGIN {abort}  	   WITH rp_msg DO  	 	      BEGIN {with} 	       ehport            := IPOUTBOUNDIDX;         em_event          := KILL_REQUEST;        emkr_down_ref     := e_msg.emdi_down_ref;         emkr_msg_rcv_cnt  := 1;         emkr_msg_snd_cnt  := 1;             {Save context...}   
      IF sv_ptr <> 0 THEN  
 
         BEGIN {valid PCB} 
          DS_StoreFields(DS_TCP_TCBTD, sv_ptr, sv.startofdata,               DATAOFFSET, SVDATASIZE);           END;             IF port_ptr <> 0 THEN            BEGIN  #         DS_StoreFields(DS_TCP_PATHTD, port_ptr, tcp_port.startofdata, #          DATAOFFSET, PATHDATASIZE);            END;             {}        DS_LeaveCritical ( tcp_wkmap );         ProSw(rp_msg, tcp_ierr);        DS_EnterCritical ( tcp_wkmap, tcp_ierr );         {}            {Get context...}        IF port_ptr <> 0 THEN             DS_FetchElement(DS_tcp_pathtd, port_ptr, tcp_port.int);       
      IF sv_ptr <> 0 THEN  
          DS_FetchElement(DS_TCP_TCBTD, sv_ptr, sv.int);   	      END;  {with} 	    END;  {abort}      GOTO 888;   END; {justdrop}               $SUBTITLE 'Routine to drop segment & sent ACK', PAGE$   {--------------------------------------------------------}  {                  DropAfterAck                          }  {--------------------------------------------------------}      PROCEDURE DropAfterAck     (kill_req:  Int16);  {}  { Description:  {  This internal routine is called by TCPInput to   {  drop the incoming segment, send an acknowledgement   {  to our remote peer and exit the TCPInput.  {   { Parameters:   {  kill_req  INPUT  If non-zero then abort path.  {   {}      
BEGIN {dropafterack} 
 {Just drop if no response is necessary}   WITH sv DO     BEGIN {with}   
   IF tcpflags.b.rst THEN  
       BEGIN   
      JustDrop(kill_req);  
       END;         rsp_flags.w:= TH_ACK;         {send ack and discard segment}      TCPRespond(ip_path_refr, port_ptr, insegptr,         sv_rcv_nxt, sv_snd_nxt, rsp_flags);          {We don't have to increment the count because}      {we did a send with kill option.             }          JustDrop(kill_req);     END; {with}  
END; {dropafterack}  
         $SUBTITLE ' Routine to drop segment & send RST', PAGE$  {-------------------------------------------------------}   {                 DropWithReset                         }   {-------------------------------------------------------}       PROCEDURE DropWithReset      (kill_req:  Int16);      {}  {   { Description:  {  This routine is called by TCPInput to generate a RST to  {  remote, to drop the incoming segment and exit TCPInput.  {  If the RST is on, no response is needed.   {   { Parameters:   "{  kill_req  INPUT  If not zero then abort down path (msg_cnt = 1).  " {   {}      BEGIN {dropwithreset}   WITH inseghdr DO     BEGIN {with}   
   IF tcpflags.b.rst THEN  
       BEGIN   
      JustDrop(kill_req);  
       END;         {IF peer acked sent RST with th_ack}   
   IF tcpflags.b.ack THEN  
       BEGIN         rsp_flags.w:= TH_RST;         TCPRespond(ip_path_refr, port_ptr, insegptr, 0,                     hdr2.th_ack, rsp_flags);        END      ELSE   
      BEGIN {no ack} 
       {Sent RST with zero ack seq #}        IF tcpflags.b.syn THEN           BEGIN           datalen := datalen + 1;           END;             rsp_flags.w:= TH_RST + TH_ACK;            TCPRespond(ip_path_refr, port_ptr, insegptr,                    hdr2.th_seq + datalen, 0,                      rsp_flags);            {IF kill_req = 0 THEN            tcp_port.p_snd_cnt := tcp_port.p_snd_cnt + 1;}       
      END; {no ack}  
        JustDrop(kill_req);     END; {with}  
END; {dropwithreset} 
             $SUBTITLE 'Drop data from send queue', PAGE$  {----------------------------------------------------}  {               DropFromSend                         }  {----------------------------------------------------}      PROCEDURE DropFromSend     (VAR sv       : StateVectorType;           acked    : Int16           );   {}  {   { Description:  {  This routine drops acked data from tcp's transmit queue.    {  snd_cnt is created for testing; should call sb_cc for total.    {   { Parameters:   {  sv      INPUT  Local copy of the connection control block.   {  acked   INPUT  Number of bytes acknowledged by our peer.   {   {}      
BEGIN {dropfromsend} 
 WITH sv DO  	   BEGIN {with sv} 	    IF acked > sv_snd_cnt THEN         BEGIN         {DS_SBDrop(sb_ptr, sv_snd_cnt, 3, tcp_error);}        {sv_snd_wnd:= sv_snd_wnd - sv_snd_cnt;}         {sv_snd_cnt:= 0; } {for testing purpose}        END      ELSE         BEGIN {*}         DS_SBDrop(sb_ptr, acked, 3, tcp_error);         sv_snd_wnd:= sv_snd_wnd - acked;        sv_snd_cnt:= sv_snd_cnt - acked;  
      {sv_retry_cnt := 1;} 
       END;  {*}   	   END; {with sv}  	 
END;  {dropfromsend} 
             $SUBTITLE 'TCP Option routine', PAGE$   {----------------------------------------------------}  {                  CopyOptions                       }  {----------------------------------------------------}  {}  {PROCEDURE CopyOptions  {   (    mbuf       : AddrType;   {    VAR option_buf : OptionBufType;  {        length     : Int16            );   {}  {}  {   { Description:  {  This routine copy the tcp options from the incoming  {  segment in dssm into our local space.  {   { Parameters:   {  mbuf       INPUT   Pointer to the mbuf which contains the  {                     option data.  {  option_buf OUTPUT  Local copy of the option data copied.   {  length     INPUT   Length of the option data in bytes.   {   {   {TYPE   {   SwitchType = RECORD   {      CASE BOOLEAN OF  {         true  : (x: TCPOptType);  {         false : (y: PACKED ARRAY[1..4] OF Byte);  {      END;   {   {VAR  {   i          : Int16;   {   switchbuf  : SwitchType;  {   {   
{BEGIN {copyoptions} 
 {}  {For time being we do it this way}  {switchbuf.x:= dssm[mbuf].header.opt;   {length:= 4;  {   {FOR i:= 1 TO length DO   {   BEGIN   {   option_buf[i]:= switchbuf.y[i];   {   END;  
{END;  {copyoptions} 
 {}          {----------------------------------------------------}  {                   TCPDoOptions                     }  {----------------------------------------------------}      PROCEDURE TCPDoOptions     (VAR sv      : StateVectorType;      VAR ob      : OptionBufType;          count   : Int16            );       {}  { Description:  {  This routine process tcp options.  {   { Parameters:   {  sv       INPUT  Local copy of the PCB.   {  ob       INPUT  Option data buffer.  {  count    INPUT  Option data byte count.  {}      VAR      i:        Int16;        {loop control}      option:   Int16;        {tcp option type}     optlen:   Int16;        {Option length in bytes}       
BEGIN {tcpdooption}  
 i:= 1;  REPEAT     option:= ob.byt[i];     IF option = TCPOPT_EOL THEN        BEGIN {end of option list}        optlen:= count;         END   {end of option list}     ELSE         BEGIN {option present}        IF option = TCPOPT_NOP THEN {null option}            BEGIN {null}            optlen:= 1; {it takes 1 byte}           END        ELSE           BEGIN {others}            IF option = TCPOPT_MAXSEG THEN               BEGIN {max. seg opt}              optlen:= ob.byt[i+1];               sv.sv_maxseg.bite[1]:= ob.byt[i+2];               sv.sv_maxseg.bite[2]:= ob.byt[i+3];               END {max.seg opt}            ELSE {other option we don't know about}              BEGIN {unknown}               optlen:= count;   
            END;  {unkown} 
          END; {others}        END; {option present}   	   i:= i + optlen; 	 
   count:= count - optlen; 
 UNTIL count = 0;  	END; {tcpdooption} 	         $ SUBTITLE 'TCP Reassembly procedure', PAGE $   {-----------------------------------------------------}   {                TCPReass                             }   {-----------------------------------------------------}       	FUNCTION TCPReass  	    (VAR sv       : StateVectorType;   
    VAR sv_ptr   : Int16;  
     VAR inseghdr : IPTCPHdrType;      VAR ptr      : Int16           ): SixBitType;   {}  {   { Description:  {  This function reassembles incoming TCP segment. It    {  inserts segment (ptr) into reassembly queue of tcp with state   {  vector sv. It also try to present as much queued user   {  data to user's receive queue as possible. It's possible that    !{  the user has aborted the connection and tcp doesn't know about  ! !{  it yet; the mbuf in the queue will be disposed by TCP when the  ! "{  connection has been abort either by the user or the remote peer.  "  {  It returns FIN flag if reassembly now includes a segment with   {  FIN flag.  {   { Parameter:  {  sv       INPUT : state vector (global copy)  !{  sv_ptr   INPUT : pointer to connection control bloack in DSAM.  ! {  inseghdr INPUT : local copy of incoming segment header   {  ptr      INPUT : address of incoming segment (ptr to dssm)   {   
{ Global Variables:  
 {  reasshdr       : local copy of reassembly header; used for   {                   local buffering of data queue headers.  {}      LABEL      55;      VAR      i         : Int16;      workptr   : Int16;      quit      : Boolean;      newptr    : ReassPtrType;     mflags    : MMFlagsType;      mm_flags  : MMFlagsType;      flags     : OneOrBitType;          
{-----------------------}  
 
{ DropAndQuit           }  
 
{-----------------------}  
 {}  { This routine is called to drop the incoming segment   { and quit in case of error or presence of old data.  {}      PROCEDURE DropAndQuit;      VAR   	   error : Int16;  	     BEGIN   DS_MDispose(ptr, error);  GOTO 55;  {don't linger}  END;      {--------------}  {Main Procedure}  {--------------}      	BEGIN {tcp_reass}  	       {}  "  {Call with ptr = 0 after the connection has established to force}  " "  {any pre-established data upto user socket. This option is not  }  " "  {used currently because we do not support pre-established data. }  "   {}        {Initialize flags for MM calls }  
   i                 := 0; 
 
   workptr           := 0; 
 
   flags.w           := 0; 
 
   mm_flags.int      := 0; 
    mm_flags.bits[0]  := true;      mm_flags.bits[-1] := true;          {-----------------------------------------------}     { Here we start processing the incoming segment }     {-----------------------------------------------}         WITH reasshdr.hdr1, reasshdr.hdr2, sv DO   	      BEGIN {with} 	       IF ptr <> 0 THEN           BEGIN {find a place}                {---------------------------------------------------}           {Step1: Look for a segment in the queue, which has a}           {       sequence number greater than the incoming   }           {       segment. (FIND A SUCCEDING SEGMENT).        }           {       At the end workptr has the pointer to the   }           {       located segment. If we do not find one then }           {       workptr is either null or points to the     }           {       anchor.                                     }           {---------------------------------------------------}               {Get the reassembly anchor blcok}           DS_MRead(reasshdr.int, IPTCPHDRSIZE, sv_template, 0,                         mm_flags, tcp_error);                IF tcp_error <> 0 THEN               DropAndQuit;               IF ih_next <> sv_template THEN   	            BEGIN  	 	            REPEAT 	             workptr := ih_next;               DS_MRead(reasshdr.int, IPTCPHDRSIZE, workptr, 0,                        mm_flags, tcp_error);               UNTIL (tcp_error <> 0) OR                      (workptr = sv_template) OR                        (Seq_Gt(th_seq, inseghdr.hdr2.th_seq));                  {IF error bail out}               IF tcp_error <> 0 THEN  
               BEGIN 
                TCPLogError(tcp_error, TI_TCPREASS);                  DropAndQuit;   
               END;  
             END;      !         {-------------------------------------------------------} ! !         {STEP2: Look for a preceding segment.                   } ! !         {If there is a preceding segment, it may provide some of} ! !         {our data already. If so, drop the duplicate. If it     } ! !         {provides all of our data, drop the segment.            } ! !         {-------------------------------------------------------} !              {Initialize the reasshdr to the expected sequence  }            {and set the length to be zero (a dummy segment)   }            {in case we do not have a preceding segment.       }                    th_seq := sv_rcv_nxt;           ih_len := 0;                IF workptr <> 0 THEN               {may has a preceeding segment}              BEGIN {check it}              IF ih_prev <> sv_template THEN  
               BEGIN 
                {Has a preceding segment}                  DS_MRead(reasshdr.int, IPTCPHDRSIZE, ih_prev, 0,                              mm_flags, tcp_error);   
               END;  
             END   {check it}           ELSE   	            BEGIN  	             {workptr is null means we have a empty queue}               {so set workptr pointing to the anchor.     }               workptr := sv_template;               END;                {-----------------------------------------------------}             {STEP3: If we have a preceding segment; it may provide}             {       some or all of the data. If so adjust or drop }             {       the incoming segment.                         }             {-----------------------------------------------------}                i:= th_seq + ih_len - inseghdr.hdr2.th_seq;               IF i > 0 THEN              BEGIN {overlaps}              IF i >= inseghdr.hdr1.ih_len THEN                  BEGIN {drop msg}                  flags.b.fin:= false;                  DropAndQuit;                  END  {drop msg}              ELSE {shave off overlap}                 BEGIN {adjust}                  WITH inseghdr DO                     BEGIN   !                  {Modify the incoming byte length and the length} ! !                  {to be adjusted later.                         } !                   hdr1.ih_adj := hdr1.ih_adj + i;                     hdr1.ih_len := hdr1.ih_len - i;                     hdr2.th_seq := hdr2.th_seq + i;                     END;                 END; {adjust}              END; {overlaps}           $         {-------------------------------------------------------------} $ $         {STEP4: Look for succeding segments.                          } $ $         {While we have not dropped the message and overlap succeeding } $ $         {segments, trim them or if they are completely covered dequeue} $ $         {them.                                                        } $ $         {-------------------------------------------------------------} $              IF workptr <> sv_template THEN               BEGIN {test for overlap}  	            REPEAT 	             DS_MRead(reasshdr.int, IPTCPHDRSIZE, workptr, 0,                 mm_flags, tcp_error);  $            i:= (inseghdr.hdr2.th_seq + inseghdr.hdr1.ih_len) - th_seq;  $ 
            IF i > 0 THEN  
                BEGIN {covered}                 IF i < ih_len THEN                     BEGIN {covered partially}                     th_seq:= th_seq + i;                    ih_len:= ih_len - i;                    ih_adj:= ih_adj + i;                        {*}                     {IF workptr = sv_template THEN                       TCPAbort(sv_ptr);}                     {*}                         DS_MBOverWrite(reasshdr.int, IPTCPHDRSIZE,                       workptr, 0, tcp_error);                    END {covered partially}   
               ELSE  
                   BEGIN {totally covered}                     RemFrmQueue(workptr, tcp_error);                    {*}                     {IF workptr = sv_template THEN                       TCPAbort(sv_ptr);}                     {*}                     DS_MDispose(workptr, tcp_error);                    workptr := ih_next;                     END; {totally covered}                 END; {covered}                  UNTIL (workptr = sv_template) OR (i <= 0);               END; {test for overlap}                    {-------------------------------------------}           {STEP5: Update segment in DSAM and put it in}           {       reassembly queue.                   }           {-------------------------------------------}               DS_MBOverWrite(inseghdr.int, IPTCPHDRSIZE, ptr, 0,               tcp_error);            InsertQueue(ptr, workptr, tcp_error);      
      END; {find a place}  
               {-----------------------------------------------------}         {Present data to user including pre-established data. }         {No data is delivered if the connection has not been  }         {fully established.                                   }         {-----------------------------------------------------}             IF sv_state < SYN_RECEIVED THEN   	         BEGIN {*} 	 
         {no data deliver} 
          END {*}        ELSE           BEGIN {try to deliver}            DS_Mread(newptr.int, 4, sv_template, 0,              mm_flags, tcp_error);            workptr:= newptr.next;            IF workptr = sv_template THEN              BEGIN {**}              {queue is empty}              END   {**}           ELSE               BEGIN {check sequence}              DS_Mread(reasshdr.int, IPTCPHDRSIZE, workptr, 0,                 mm_flags, tcp_error);              IF th_seq <> sv_rcv_nxt THEN {not deliverable}                 BEGIN {}                  {data not deliverable}                  END {}               ELSE {this check is questionable}                  BEGIN {check state}  !               IF (sv_state = SYN_RECEIVED) AND (ih_len <> 0) THEN !                   BEGIN {*}                     {not deliverable}   
                  END {*}  
                ELSE {deliver data}                    REPEAT                           {Initialize the flags for MMGR calls}                       mflags.int        := 0;                           {If this is the last segment then say so}                       IF th_flags.b.fin THEN                           BEGIN {set flag}                          flags.b.fin:= true;                           END;  {set flag}                           {Unlink the mbuf from the queue}                        RemFrmQueue(workptr, tcp_error);                            {Adjust the mbuf to reflect user data}                        {Check user's credit; if ok append   }                        {data; if not, drop all data segment.}                            ih_adj := ih_adj + IPTCPHDRSIZE;                        DS_Madj(workptr, ih_adj, tcp_error);                            {Try to charge user for the memory}                       mm_flags.int := 1;                        DS_MBTransfer(workptr, sb_ptr2,                          mm_flags, tcp_error);                            IF tcp_error <> 0 THEN                           BEGIN {**** !!!! ****}      "                        {we ought to signify that the flow control}  " "                        {is not working properly.                 }  "     
                       {*} 
                         TCPLogError(tcp_error, TI_TCPREASS);  
                       {*} 
                             DS_MDispose(workptr, tcp_error);                          END   {**** !!!! ****}  
                     ELSE  
                         BEGIN {append data}   #                        {Check if we are in message mode; if we are }  # #                        {set end of msg bit and message flow control}  # #                        {and write select parameters.               }  #                         IF sv_t_flags.msg_mode THEN                              BEGIN                             IF ih_len > 0 THEN                                 BEGIN   #                              RecordFmSize(sv_rcv_qhead, sv_rcv_qtail, # $                                 sv_rcv_msg_ary, sv_rcv_frames, ih_len,  $                                     th_flags.b.push);                                 END;                                 IF th_flags.b.push THEN                                BEGIN                                 mflags.bits[0]:= true;  "                              sv_rcv_frm_nxt := sv_rcv_frm_nxt + 1;  "                               END;                             END                          ELSE                             BEGIN  "                           {tcp SUPPRESSES push when in stream mode} "                            END;       !                        DS_SBAppend(sb_ptr2, workptr, 3, MAXINT16, !                            MAXINT16, mflags, tcp_error);      $                        {Check if the append call is ok; it should have} $ $                        {no problem at all. If it does, we drop the    } $ %                        {segment and do not update the receive variables}  %                         IF tcp_error <> 0 THEN                             BEGIN  !                           TCPLogError(FLOW_PROBLEM,TI_TCPREASS);  !                            DS_MDispose(workptr, tcp_error);                              END                          ELSE                             BEGIN {update}                               {Update the receive variable and the}                               {receive window...                  }                              sv_rcv_nxt:= sv_rcv_nxt + ih_len;                             sv_rcv_wnd:= sv_rcv_wnd - ih_len;                             END;  {update}                           END;  {append data}       "                     {Set the working segment to next one the queue} " "                     {and retrieve the reassembly header.          } "                      workptr := ih_next;                       DS_MRead(reasshdr.int, IPTCPHDRSIZE,                           workptr, 0, mm_flags, tcp_error);                         UNTIL                       (tcp_error <> 0) OR                        (workptr = sv_template)                          OR (th_seq <> sv_rcv_nxt);                 END; {check state}               END; {check seqence}           END; {try to deliver}     55:        TCPReass:= flags.w; {six bit integer return}     END; {with}  END; {tcp_reass}              $SUBTITLE 'Routine to trim the incoming segment', PAGE$   {-------------------------------------------------------}   {                         TCPTrim                       }   {-------------------------------------------------------}       	PROCEDURE TCPTrim; 	 {}  {   { Description:   {  This routine advance th_seq to correspond to first data byte.   {  If data, trim to stay within window, drop fin if necessary.  {}      BEGIN {tcptrim}   
WITH inseghdr, sv DO 
    BEGIN {with}      hdr2.th_seq:= hdr2.th_seq + 1;      IF hdr1.ih_len > sv_rcv_wnd THEN         BEGIN {trim trailing data}        todrop:= hdr1.ih_len - sv_rcv_wnd;        DS_MAdj(insegptr, -todrop, tcp_error);        hdr1.ih_len:= sv_rcv_wnd;         hdr2.th_flags.b.fin:= false;        END; {trim trailing data}      sv_snd_wd1:= hdr2.th_seq - 1;  	   trimed := true; 	    END; {with}  END; {tcptrim}              $SUBTITLE ' Main body of TCPInput routine', PAGE$       !{---------------------------------------------------------------}  ! !{                                                               }  ! !{                  Main Body Of TCPInput                        }  ! !{                                                               }  ! !{---------------------------------------------------------------}  !     BEGIN {tcpinput}      WITH inseghdr.hdr1, inseghdr.hdr2, e_msg DO   
   BEGIN {validity check}  
    {Readjust the first mbuf to get the IP header so that we }      {can use it for linking and checksum purpose. Both IP and}      {TCP headers are copied into our area.                   }       
   mm_flags.int     := 0;  
    mm_flags.bits[0] := true;     trimed           := false;   
   optlen           := 0;  
    insegptr         := e_msg.emdi_mbufid;      inseghdr         := INITBUFF;             {Preparation for checksum in case we have to}     ih_src := emdi_dst_addr.longint;      ih_dst := emdi_src_addr.longint;      ih_len := emdi_dlen;          {IF we encounter any memory manager error, just drop the}     {segment. Remember to abort the path with msg_cnt = 1.  }  "   DS_MAppendHead(inseghdr.int, IPHEADERSIZE, insegptr, tcp_error);  "        IF tcp_error = 0 THEN        BEGIN         DS_MRead(inseghdr.int, IPTCPHDRSIZE, insegptr, 0,                     mm_flags, tcp_error);         END      ELSE         BEGIN         {Fail to append IP header; complain}        TCPLogError(tcp_error, TI_TCPINPUT);  
      JustDrop(tcp_error); 
       END;                 {Here we verify the incoming segment is oky doky...    }      {Check that TCP offset make sense. Pull out TCP options}      {and adjust length.                                    }          {Save the incoming checksum word.}      incksum := th_sum;      th_sum  := 0;         offset:= th_off * 4;          IF (offset < TCPHEADERSIZE) OR (offset > emdi_dlen) THEN         BEGIN {bad offset}        {Bad offset, just drop the segment}         tcpgbls.stats.badoff:= tcpgbls.stats.badoff + 1;        tcp_error:= BADOFFSET;  
      JustDrop(tcp_error); 
       END; {bad offset}          {Get the user data length in bytes}     datalen := emdi_dlen - offset;          IF offset > TCPHEADERSIZE THEN   
      BEGIN {get options}  
       optlen    := offset - TCPHEADERSIZE;        {should be stored after chechsum calculation}         {ih_adj    := optlen;                       }         tcpoption := 1;  {option presents}        {Do a non-destuctive read of the options.}        mm_flags.bits[0] := true;         DS_MRead(option_buf.int, optlen, insegptr,           offset+IPHEADERSIZE-optlen, mm_flags, tcp_error);        END  {get options}     ELSE         BEGIN {no options}  
      tcpoption:= 0; 
       END;  {no options}         {Get control flags and adjust offset}     offset     := offset + IPHEADERSIZE;      tcpflags.w := th_flags.w;     END; {validity ckeck}      WITH sv,inseghdr.hdr2,inseghdr.hdr1,e_msg DO         BEGIN {start processing}       {So far the packet looks good and we have not tossed it.   }        {Locate port control block and state vector for the segment}        {or setup resources if it is a new arrived CALL packet.    }           WITH search_key DO         BEGIN {setup key}         c_s_port     := th_dport;         c_d_port     := th_sport;         c_si_addr    := ih_dst;         c_di_addr    := ih_src;         END;  {setup key}          {Remember the incomig path reference from ip}     ip_path_refr := emdi_down_ref;          {locate the connection context blocks, path record and  }     {the protocol control block, if the connection is closed}     {the local copy of the pcb (sv) is set to its initial   }     {state and the path's pcb pointer is null.              }         PortLookUp(search_key, tcp_error);          IF tcp_error = 0 THEN            BEGIN {found it}        {If the connection has been closed (in limbo list 2msl)}        {then we will drop the segment with reset. Also we     }        {increment the incoming message reference count here.  }        WITH tcp_port DO           BEGIN           IF p_tcp_pcb = 0 THEN  	            BEGIN  	             DropWithReset(0);               END;           END;             {IF we are waiting for user to receive the connection,}         {we discrad this one for now.                         }         IF NOT sv_t_flags.ipcwait THEN           BEGIN  
         sv_idle_cnt:= 0;  
 
         sv_keep_cnt:= 0;  
          END        ELSE           BEGIN           JustDrop(0);            END;              {Here we look at checksum optioning. The algorithm is:   }          {If the connection is not fully established (ie state <  }          {ESTABLISHED), always do checksum; otherwise if the state}          {is established or beyond then we will do checksum if the}          {connection is in 'checksum mode'. Checksum mode is      }          {indicated by the fact that sv.sv_t_flags.cksum = false. }          {The flag is set by the user or default to checksum mode.}          {If checksum option is on (ie, the flag is set to true)  }          {then the final value of the flag is determined when the }          {connection enters the established state.                }                  {Calculate the total number of bytes to be checksumed.   }          {Clear checksum word and set the checksum length.        }         cksumword := 0;         length    := datalen + optlen;            IF sv_state < ESTABLISHED THEN           BEGIN {must cksum}   "         {TCP checksum is done in two areas; headers are checksumed} " "         {in the programs storage area and the data, if any, is    } " "         {checksumed in the DSAM area.                             } "              moffset := IPTCPHDRSIZE;   $         GetChecksum(inseghdr, 0, insegptr, moffset, length, cksumword); $     !         {Make adjustment for options which are not for the user}  !          inseghdr.hdr1.ih_adj := optlen;               {Reject packets with invalid checksum}            IF (incksum <> 0) AND (incksum <> -1) THEN   	            BEGIN  	             {This is the case where the remote wants checksum}              cksum_ok := cksumword = incksum;              IF cksum_ok THEN                 sv_t_flags.rmcksum := true;              END            ELSE   	            BEGIN  	             {Remote may opt for no checksum; do a last check}               IF incksum = cksumword THEN   
               BEGIN 
 !               {The checksum is ok and the remote wants checksum}  ! !               {if the state is not in sync yet.                }  !                cksum_ok := true;                 IF sv_state < SYN_RECEIVED THEN                    BEGIN                     sv_t_flags.rmcksum := true;                     END   
               ELSE  
                   BEGIN                     END;  	               END 	             ELSE                 BEGIN {check option}                  sv_t_flags.rmcksum := false;                  IF (incksum = -1) AND (cksumword <> 0) THEN                     BEGIN                     cksum_ok := false;                      END  
               ELSE  
                    cksum_ok := true;                 END;  {check option}               END;           END   {must cksum}         ELSE           BEGIN {check flag}            IF sv.sv_t_flags.cksumopt THEN   
            BEGIN {verify} 
             GetChecksum(inseghdr, 0, insegptr,                            IPTCPHDRSIZE, length, cksumword);               cksum_ok := cksumword = incksum;  
            END  {verify}  
          ELSE   	            BEGIN  	             {In this case, we always accept the packet}               cksum_ok := true;               END;           END;  {check flag}           
      IF NOT cksum_ok THEN 
 
         BEGIN {bad cksum} 
 $         {Bad segment, just drop the segment. If the state = CLOSED the} $ $         {we need to clean up the path because we just allocated them.}  $              IF sv_state = CLOSED THEN  	            BEGIN  	             tcpgbls.stats.badsum := tcpgbls.stats.badsum + 1;               FreeSVector;  !            DeleteList(DS_TCP_PathTD, d_path_list_head, port_ptr); ! !            InsertList(DS_TCP_PathTD, f_path_list_head, port_ptr); !             END            ELSE   	            BEGIN  	             {update the connection stats}               sv.sv_tcpstat.badsum:= sv.sv_tcpstat.badsum + 1;              END;               tcp_error := BADCHECKSUM;           JustDrop(0);   
         END; {bad cksum}  
               {Segment arrives at connection. Need to reset}        {the idle timer and the keep-alive timer if  }        {the connection state > LISTEN.              }        {If in waiting state, leave the timer alone  }        {and drop this message. Now can can modify   }        {the local copy of the IP header without     }        {worrying about checksum anymore.            }            ih_len := datalen;            IF sv_state > LISTEN THEN            BEGIN  
         sv_keep_cnt := 0; 
          TcpCancelTimer(KEEPTYPE, tmr_err);            IF tmr_err = INVALIDTIMERID THEN   	            BEGIN  	             tcp_port.p_syn_bits[-KEEPTYPE] := true;               END;           TcpSetTimer(KEEPTYPE, TCPTV_KEEP);            END;             {Process options if there is any}         IF tcpoption <> 0 THEN            BEGIN {doit}            TCPDoOptions(sv, option_buf, optlen);             END;  {doit}  
      END {found it} 
    ELSE         BEGIN {not found}         IF tcp_error = NOCONNRESRC THEN            BEGIN {no resource}           {drop it, allow retry}            tcpgbls.stats.hdrop:= tcpgbls.stats.hdrop + 1;            JustDrop(tcp_error);   
         END {no resource} 
       ELSE           BEGIN {no service}            {Must addressing someone who we do not know}            tcpgbls.stats.badsegs:= tcpgbls.stats.badsegs + 1;            DropWithReset(tcp_error);           END;  {no service}         END; {not found}         {Calculate amoumt of space in receive window and then do}     {TCP input processing if state <> CLOSED or not in the  }     {waiting for connection accept.                         }         IF sv_state <> CLOSED THEN   
      BEGIN {get rcv_wnd}  
       IF NOT sv_t_flags.ipcwait THEN  
         BEGIN {not wait}  
          DS_SBSpace(sb_ptr2, sv_av_wnd, dataread, tcp_error);            sv_rcv_wnd := sv_rcv_wnd + dataread;            IF sv_t_flags.msg_mode THEN  	            BEGIN  	             {Update the receive message frame counts}               UpdateFmCnt(sv_rcv_qhead, sv_rcv_qtail,   "               sv_rcv_msg_ary, sv_rcv_frames, dataread, data_in_q);  "             END;           END  {not wait}        ELSE           BEGIN           sv_rcv_wnd:= 0;           END;   
      END   {get rcv_wnd}  
    ELSE         {If state = CLOSED, then we have to inform ipc of the }         {the connect request; the connection will not be fully}         {established until the user accepts it and the remote }         {acknowledges our syn packet. This is the case that we}         {receive a valid remote call packet.                  }             BEGIN {offer connect}         {We have to be careful and make sure this is not for}         {a connection which is just aborting by the outbound}         {protocol process.                                  }          IF tcp_port.p_syn_bits[0] OR (tcp_port.p_tcp_pcb = 0) THEN            BEGIN           tcp_error := CONNDROPPED;           tcpgbls.stats.badsegs:= tcpgbls.stats.badsegs + 1;            JustDrop(0);            END;             {Mark the path as offer path pending and}         {make the offer to ipc on our way out.  }         {Meanwhile we keep on trucking...       }   
      sv_state := LISTEN;  
       END;  {offer connect}       
   CASE sv_state OF  
     !      {If the state is LISTEN then ignore segment if it contains } ! !      {an RST. If the segment contains an ACK then it is bad and } ! !      {send a RST. If it does not contains a SYN it is not inter-} ! !      {esting; drop it. Otherwise initialize rcv_nxt, irs, select} ! !      {an initial iss and send a segment:                        } ! !      {   <SEQ=ISS><ACK=RCV_NXT><CTL=SYN,ACK>                    } ! !      {Also initialize snd_nxt to iss+1 and snd_una to iss. Fill } ! !      {in remote addresses if not specified before. Enter        } ! !      {SYN_RECEIVED state, and process other fields of this      } ! !      {segment in this state.                                    } !           LISTEN:            BEGIN {state=listen}                {Timer starts here, if for any reason we drop}            {the request, when the timer expired we will }            {clean up all the resources...               }            {     * Cannot Activate Timer Here *         }            {TcpCancelTimer(KEEPTYPE);                   }            {TcpSetTimer(KEEPTYPE, TCPTV_KEEP);          }                {See if all the flags are ok}           IF tcpflags.b.rst OR (NOT tcpflags.b.syn) THEN               BEGIN {rst true}              TcpCancelTimer(KEEPTYPE, tmr_err);              IF tmr_err = INVALIDTIMERID THEN  
               BEGIN 
                tcp_port.p_syn_bits[-KEEPTYPE] := true;  
               END;  
             {}              { Release Path and TCB; Send Kill to IP               {}              FreeSVector;              TCPClosePath(tcp_port, port_ptr);                   {}  "            {DeleteList(DS_TCP_PathTD, d_path_list_head, port_ptr);  " "            {InsertList(DS_TCP_PathTD, f_path_list_head, port_ptr);  "             {}                  JustDrop(0);              END;  {rst true}               IF tcpflags.b.ack THEN               BEGIN {ack true}              TcpCancelTimer(KEEPTYPE, tmr_err);              IF tmr_err = INVALIDTIMERID THEN  
               BEGIN 
                tcp_port.p_syn_bits[-KEEPTYPE] := true;  
               END;  
                 {}              { Release Path and TCB; Send Kill to IP               {}              FreeSVector;              TCPClosePath(tcp_port, port_ptr);                   {}  "            {DeleteList(DS_TCP_PathTD, d_path_list_head, port_ptr);  " "            {InsertList(DS_TCP_PathTD, f_path_list_head, port_ptr);  "             {}              DropWithReset(0);               END;                   {All control flags are in good shape.   }           {Initialize variables. If the connection}           {can be optional in checksum and the peer}            {wants no checksum, give it to him.      }                {}            {IF NOT sv_t_flags.cksumopt THEN   	         {   BEGIN 	          {   IF incksum <> cksumword THEN            {      BEGIN            {      sv_t_flags.cksumopt := false;   
         {      END; 
 	         {   END;  	          {}                sv_iss:= 32000;  
         sv_irs:= th_seq;  
 
         SendSeqInit(sv);  
          RcvSeqInit(sv);           sv_t_flags.ipcwait := true;           sv_state           := SYN_RECEIVED;  	         TCPTrim;  	          END; {state=listen}            SYN_SENT:                 {In SYN_SENT state:                                   }             {                                                     }             {If seg contains an ACK, but not for our SYN, drop it.}             {If seg contains a RST, then drop connection.         }             {If seg does not contain a SYN, then drop it;         }             {otherwise this is a acceptable SYN segment.          }             {initialize rcv_nxt and irs.                          }             {If seg contains ack then advance snd_una.            }             {If SYN has been acked change to ESTABLISHED else     }             {to SYN_RCVD state.                                   }             {Arrange for segment to be acked.                     }             {Continue to process rest of data/controls beginning  }             {with URG.                                            }                BEGIN {state=synsent}           IF tcpflags.b.ack AND (Seq_Lt(th_ack,sv_iss) OR                 Seq_Gt(th_ack,sv_snd_max)) THEN              BEGIN {bad ack}               {drop with reset}               DropWithReset(0);               END;  {bad ack}                IF tcpflags.b.rst THEN   
            BEGIN {dropit} 
             IF tcpflags.b.ack THEN                 BEGIN {rst & ack}                 {we tell ipc the connect attempt has been   }                 {refused; drop all data if any; release the }                 {pcb and set pcb pointer in the path record }                 {to null; we will release the path when ipc }                 {tell us to abort (note: ipc must abort!!!).}                     tcp_port.p_syn_bits[-1] := true;                  TCPConnDrop(tcp_port, port_ptr, CONNREFUSED);                 END;  {rst & ack}              JustDrop(0);  
            END; {dropit}  
              IF NOT tcpflags.b.syn THEN               BEGIN {no syn flag}               JustDrop(0);              END;  {no syn flag}                {Syn flag is present; more work! Hurray}                 {First let's find out whether we have to change our  }              {connection checksum mode or not; the only case      }              {in which we have to change is that our peer opts    }              {for a different mode and we are optional (flexible).}                 {}            {IF NOT sv_t_flags.cksumopt THEN   	         {   BEGIN 	          {   IF incksum = cksumword THEN           {      BEGIN            {      sv_t_flags.cksumopt := false;   
         {      END; 
 	         {   END;  	          {}                sv_snd_una:= th_ack;                IF Seq_Lt(sv_snd_nxt, sv_snd_una) THEN               BEGIN {update snd_nxt}              sv_snd_nxt:= sv_snd_una;              END;  {update snd_nxt}               TcpCancelTimer(REXMTTYPE, tmr_err);           IF tmr_err = INVALIDTIMERID THEN   	            BEGIN  	             tcp_port.p_syn_bits[-REXMTTYPE] := true;              END;           sv_irs     := th_seq;           sv_old_wnd := th_win;           RcvSeqInit(sv);           sv_t_flags.acknow:= true;               IF Seq_Gt(sv_snd_una, sv_iss) THEN               BEGIN {acked our syn}                   {sent confirmation to user}   
            SSendConfirm;  
                {}   
           {WITH rp_msg DO 
 
           {   BEGIN 
            {   ehport        := IPCINBOUNDIDX;             {   em_event      := CONNECT_CONFIRM;             {   emcc_up_ref   := tcp_port.p_up_refr;              {   emcc_down_ref := port_ptr;              {             {   tcp_port.p_up_cnt := tcp_port.p_up_cnt + 1;             {   DS_LeaveCritical ( tcp_wkmap );             {   ProSw(rp_msg, tcp_ierr);              {   DS_EnterCritical ( tcp_wkmap, tcp_ierr );  
           {   END;  
            {}                        {Update round trip time and enter established state}                {Note: Seq_GEq is used because t_rtseq includes the}                {      SYN flag sequence space.                    }       #            IF (sv_rt_time <> 0) AND Seq_GEq(th_ack, sv_t_rtseq) THEN  # 
               BEGIN 
                UpdateRTTime(sv);  
               END;  
                 {Change state and finalize the checksum option}   '            sv_t_flags.cksumopt := sv_t_flags.cksumopt OR sv_t_flags.rmcksum;  '             sv_state:= ESTABLISHED;       %            {Call reassembly routine here to deliver any pre-established}  % %            {data.                                                      }  % !            tcpflags.w:= TCPReass(sv, sv_ptr, inseghdr, null_ptr); !             IF tcp_error <> 0 THEN  
               BEGIN 
                GOTO 888;  
               END;  
             END {acked our syn}            ELSE               BEGIN {received syn}              sv_state:= SYN_RECEIVED;              END;  {received syn}               {adjust and trim data}   	         TCPTrim;  	          END; {state=synsent}          OTHERWISE  !      {States other than LISTEN or SYN_SENT.                     } ! !      {First check that at least some bytes of segment are within} ! !      {receive window.                                           } !     
      BEGIN {other states} 
           IF sv_rcv_wnd = 0 THEN            {If window is closed, can only take segments at window}             {edge,; and have to drop data and push from incoming  }             {segments.                                            }                BEGIN {window closed}           IF sv_rcv_nxt <> th_seq THEN               BEGIN {can't accept}              DropAfterAck(0);              END;  {can't accept}           IF ih_len > 0 THEN               BEGIN {drop data & flags}               DS_MAdj(insegptr, -ih_len, tcp_error);              ih_len:= 0;               th_flags.b.push:= false;    {***}               th_flags.b.fin:= false;     {problem}               END; {drop data & flags}           END {window closed}        ELSE           {If segment begins before rcv_nxt, drop the SYN if  }           {present because it occupies one byte. If we have   }           {old data as part of the packet, let the reassembly }           {routine shave it off; we cannot adjust from the    }           {top of the mbuf chain now because of the protocol  }           {headers...                                         }               BEGIN {window open}               todrop := sv_rcv_nxt - th_seq;                IF todrop > 0 THEN               BEGIN {have to drop some}               IF tcpflags.b.syn THEN                 BEGIN {drop syn}                  tcpflags.b.syn:= false;                 th_flags.b.syn:= false;                 th_seq:= th_seq + 1;                  IF th_urp > 1 THEN                     BEGIN {back off urgent count}                     th_urp:= th_urp - 1;                    END   {back off urgent count}   
               ELSE  
                   BEGIN {drop urg}                    th_flags.b.urg:= false;                     END;  {drop urg}                  todrop:= todrop - 1; {update to reflect the drop}                  END; {drop syn}      "            {Here we need to trap the connection assurance packet }  " "            {response from a dead remote peer so that we do not   }  " "            {hang on to this half of the connection.              }  "                 IF (todrop > ih_len) OR ((todrop = ih_len) AND                 (NOT th_flags.b.fin)) THEN                  BEGIN {}                  IF (ih_len = 0) AND tcpflags.b.rst THEN                    BEGIN                     GOTO 666;                     END;                 DropAfterAck(0);                  END;  {}                   {}              {DS_MAdj(insegptr, todrop, tcp_error);              {th_seq:= th_seq + todrop;              {ih_len:= ih_len - todrop;              {}                  {Even though we want to do the adjustment later,}               {we update the urgent pointer now.              }                   IF th_urp > todrop THEN                  BEGIN {*}                 th_urp:= th_urp - todrop                  END   {*}              ELSE                 BEGIN {update URG pointer}                  tcpflags.b.urg:= false;                 th_flags.b.urg:= false;  
               th_urp:= 0; 
                END; {update URG pointer}              END; {have to drop some}                {If segment ends after window, drop trailing data (and}             {PUSH and FIN); if nothing left, just ack.            }                todrop:= th_seq + ih_len - sv_rcv_nxt - sv_rcv_wnd;               IF todrop > 0 THEN               BEGIN {drop trailing}               IF todrop >= ih_len THEN                 BEGIN {}                  DropAfterAck(0);                  END;  {}               DS_MAdj(insegptr, -todrop, tcp_error);              ih_len:= ih_len - todrop;               th_flags.b.push:= false;              th_flags.b.fin:= false;               END; {drop trailing}            END; {window open}            666:      
      END; {other states}  
    END; {***case state of***}          IF NOT (trimed) THEN             BEGIN {process cntl flags}      !      {Segment received. Process the segment according the the  }  ! !      {connection state and the control flags in its header.    }  ! !      {If the RST bit is set examine the state:                 }  ! !      {   SYN_RECEIVED:                                         }  ! !      {      Inform user connection refused and clean up.       }  ! !      {   ESTABLISHED, FIN_WAIT_1, FIN_WAIT_2, CLOSE_WAIT:      }  ! !      {      Inform user that connection was reset and clean up.}  ! !      {   CLOSING, LAST_ACK, TIME_WAIT:                         }  ! !      {      Clean up.                                          }  ! !      {   NOTE: In Advds/1000 there will never be a time_wait   }  ! !      {         state because we had already dispose the path.  }  !               {}        { RST processing }        {}            IF tcpflags.b.rst THEN  {process RST}   
         CASE sv_state OF  
     
            SYN_RECEIVED:  
                BEGIN {refused}                 {tell ipc; clean_up and wait for abort path}                  tcp_port.p_syn_bits[-1] := true;                  TCPConnDrop(tcp_port, port_ptr, CONNREFUSED);                 JustDrop(0);                  END; {refused}                   ESTABLISHED, FIN_WAIT_1, FIN_WAIT_2,              CLOSE_WAIT:                  BEGIN {reset}                 {tell ipc; clean-up and wiat for abort path}                  tcp_port.p_syn_bits[-1] := true;                  TCPConnDrop(tcp_port, port_ptr, CONNRESET);                 JustDrop(0);                  END; {reset}                   CLOSING, LAST_ACK, TIME_WAIT:                  BEGIN {closed}                  in_path := port_ptr;                  tcp_port.p_syn_bits[-1] := true;                  TCPConnDrop(tcp_port, port_ptr, 0);                 port_ptr := in_path;                  TCPClosePath(tcp_port, port_ptr);                 JustDrop(0);                  END; {closed}           END; {case state of RST}                 {}        { SYN Processing }        {}            {If a SYN is in the window, then this is an error and}        {we send an RST and drop the connection.             }            IF tcpflags.b.syn THEN           BEGIN {dropwithreset}            {notify ipc, relesase pcb, send RST and wait for abort}            tcp_port.p_syn_bits[-1] := true;            TCPConnDrop(tcp_port, port_ptr, CONNRESET);  
         DropWithReset(0); 
          END; {dropwithreset}             {If the ACK bit is off we drop the segment.}        IF NOT tcpflags.b.ack THEN           BEGIN{}           JustDrop(0);            END; {}                {}        {Start ACK processing}        {}        IF sv_state = SYN_RECEIVED THEN             {In SYN_RECEIVED state if the ack ACKs our SYN then }         {enter ESTABLISHED state and continue processing,   }         {otherwise send a RST. Here we will not send confirm}         {to ipc.                                            }             BEGIN {syn_received state}        IF Seq_Gt(sv_snd_una, th_ack)            OR Seq_Gt(th_ack, sv_snd_max) THEN            BEGIN {bad ack}  
         DropWithReset(0); 
          END;  {bad ack}      
      {Our syn is accked}  
       sv_snd_una:= sv_snd_una + 1;            IF Seq_Lt(sv_snd_nxt, sv_snd_una) THEN  	         BEGIN {}  	          sv_snd_nxt:= sv_snd_una;   	         END;  {}  	           {Update round trip time and enter established state}        {Note: Seq_GEq is used because t_rtseq includes the}        {      SYN flag sequence space.                    }             IF (sv_rt_time <> 0) AND Seq_GEq(th_ack, sv_t_rtseq) THEN              BEGIN             UpdateRTTime(sv);             END;            TcpCancelTimer(REXMTTYPE, tmr_err);         IF tmr_err = INVALIDTIMERID THEN           BEGIN           tcp_port.p_syn_bits[-REXMTTYPE] := true;            END;       !      {need to confirm user request ... we don't do it any more.}  ! !      {SSendConfirm;                                            }  !          {}   
     {WITH rp_msg DO 
      {   BEGIN       {   ehport       := IPCINBOUNDIDX;        {   em_event     := CONNECT_CONFIRM;        {   emcc_up_ref  := tcp_port.p_up_refr;       {   emcc_down_ref:= port_ptr;       {       {   tcp_port.p_up_cnt := tcp_port.p_up_cnt + 1;       {   DS_LeaveCritical ( tcp_wkmap );       {   ProSw(rp_msg, tcp_ierr);        {   DS_EnterCritical ( tcp_wkmap, tcp_ierr );       {   END;        {}       $      sv_t_flags.cksumopt := sv_t_flags.cksumopt OR sv_t_flags.rmcksum;  $       sv_state:= ESTABLISHED;             {need to change TCPReass call with void return}         {Try to deliver any pre-established data. Even we do }        {not send pre-established data, the code will work   }        {for next release if we will send such data.         }            tcpflags.w:= TCPReass(sv, sv_ptr, inseghdr, null_ptr);        IF tcp_error <> 0 THEN           BEGIN  	         GOTO 888; 	          END;             sv_snd_wd1:= th_seq - 1;            END; {syn_received state}       #      {In ESTABLISHED state: drop duplicate ACKs; ack out of range  }  # #      {ACKs. If the acks is in range then                           }  # #      {   snd_una < th_ack <= snd_max is true.                      }  # #      {If in range then advance snd_una to th_ack and drop data from}  # #      {the retransmission queue. If the this ACK reflects more up to}  # #      {date window info we update our window info.                  }  #           CASE sv_state OF           ESTABLISHED,   
         FIN_WAIT_1, 
 
         FIN_WAIT_2, 
 
         CLOSE_WAIT, 
 	         CLOSING,  	 	         LAST_ACK, 	 
         TIME_WAIT:  
             BEGIN {established-time_wait}               IF Seq_LEq(th_ack, sv_snd_una) THEN                  BEGIN {old ack}                 {do nothing}                  END   {old ack}              ELSE                 BEGIN {good ack}                  IF Seq_Gt(th_ack, sv_snd_max) THEN                     BEGIN                     DropAfterAck(0);                    END   
               ELSE  
                   BEGIN {ack in range}                    acked:= th_ack - sv_snd_una;      "                  {If transmit timer is running and timed sequence } " "                  {number was acked, update smooth round trip time.} "                       IF (sv_rt_time <> 0) AND                        Seq_Gt(th_ack, sv_t_rtseq) THEN                        BEGIN {*}                       UpdateRTTime(sv);                       END;  {*}                    IF th_ack = sv_snd_max THEN                        {no rtx timer needed}                       BEGIN {*}                       TcpCancelTimer(REXMTTYPE, tmr_err);                       IF tmr_err = INVALIDTIMERID THEN                           BEGIN                            tcp_port.p_syn_bits[-REXMTTYPE] := true;                           END;                       END {*}                    ELSE                       BEGIN {set timer}                       timer_value:=  &                        GetTimerValue(Round(tcpgbls.tcp_beta * sv_srt_time), &                                       TCPTV_MIN, TCPTV_MAX);                       IF sv_t_rexmt.index < 0 THEN                           TcpSetTimer(REXMTTYPE, timer_value)   
                     ELSE  
 $                        TCPResettimer(timer_value, sv_t_rexmt,tmr_err);  $                      sv_retry_cnt:= 0;                       END;  {set timer}                        {Drop acked data from retransmission queue.}                    {sv.snd_cnt has the number of data bytes in}                    {the send queue since last send.           }                        DropFromSend(sv,acked);                         sv_snd_una:= th_ack;                    IF Seq_Lt(sv_snd_nxt, sv_snd_una) THEN                       BEGIN {}                        sv_snd_nxt:= sv_snd_una;                        END;  {}       #                  {In FIN_WAIT_1 STATE in addition to the processing}  # #                  {for the ESTABLISHED state if our FIN is now acked}  # #                  {then enter FIN_WAIT_2 state.                     }  #                       CASE sv_state OF                           FIN_WAIT_1:                          IF acked > 0 THEN                              BEGIN {our fin acked}                              {User has closed; ipc has released  }                               {socket;remote has acked our FIN;   }                               {ah, wait, wait, wait for peer's FIN}                               {SSDisconnectInd(sb_ptr);           }                              sv_state:= FIN_WAIT_2;                              END;  {our fin acked}      #                  {In CLOSING state in addition to the processing for} # #                  {the ESTABLISHED state if the ACK acks our FIN then} # #                  {enter the TIME_WAIT state, otherwise ignore.      } # #                  {Note: in AdvDS/1000 the time_wait state does not  } # #                  {      involve saving the path; only the source tcp} # #                  {      port number is entered into the limbo list. } #                          CLOSING:                           IF acked > 0 THEN                              BEGIN {closing ack fin}                             sv_state:= TIME_WAIT;                             in_path := port_ptr;                              tcp_port.p_syn_bits[-1] := true;                              TCPConnDrop(tcp_port, port_ptr, 0);                             port_ptr := in_path;                              TCPClosepath(tcp_port, port_ptr);                             END; {closing ack fin}       $                     {The only thing that can arrive in LAST_ACK state}  $ $                     {is an ack of our fin. If our FIn is now acked,  }  $ $                     {then delete the context structures. enter close }  $ $                     {state.                                          }  $                          LAST_ACK:                          IF acked > 0 THEN                              BEGIN {lastack}  "                           {notify ipc; release pcb; wait for abort} "                            tcp_port.p_syn_bits[-1] := true;                              TCPConnDrop(tcp_port, port_ptr, 0);                             JustDrop(0);                              END; {lastack}       "                     {In TIME_WAIT state the only thing that should} " "                     {arrive is a retransmission of the remote FIN.} " "                     {Ack it and restart the 2msl timer.           } "                          TIME_WAIT:                           BEGIN {timerwait}                           TcpCancelTimer(MSLTYPE, tmr_err);                           TcpSetTimer(MSLTYPE, TCPTV_MSL);                          DropAfterAck(0);                          END; {timerwait}                    OTHERWISE                         BEGIN                         {do nothing}  
                      END; 
                   END; {case state of}                    END; {ack in range}                  END; {good ack}              END;  {established-time_wait}   	         OTHERWISE 	 	            BEGIN  	             {we don't care about other states here}               END;           END; {case state of}         {clear the trimed flag}         END  {process cntl flags}      ELSE         BEGIN         trimed:= false;         END;         {}      {All legal segment will further be processed here.}     {}          {Update window information --- If in msg mode, need to }      {check for acked frame and beware of zero msg. frame.  }          IF Seq_Lt(sv_snd_wd1, th_seq) OR ((sv_snd_wd1 = th_seq) AND         Seq_Lt(sv_snd_wd2, th_ack)) OR ((sv_snd_wd2 = th_ack) AND          (th_win > sv_snd_wnd)) THEN             BEGIN {update window}         IF sv_t_flags.msg_mode THEN            BEGIN      #         tempvar := (th_win - sv_old_wnd) - (sv_snd_nxt - sv_snd_una); #              IF tempvar > 0 THEN  	            BEGIN  	 "            UpdateFmCnt(sv_snd_qhead, sv_snd_qtail, sv_snd_msg_ary,  "                          sv_frame_cnt, tempvar, data_in_q);               sv_old_wnd := sv_old_wnd + tempvar;                   IF sv_frame_cnt > 0 THEN  
               BEGIN 
                TcpCancelTimer(PERSISTTYPE, tmr_err);                 IF tmr_err = INVALIDTIMERID THEN                     BEGIN                     tcp_port.p_syn_bits[-PERSISTTYPE] := true;                    END;  
               END;  
             END;           END;             acked     := 0;   
      sv_snd_wnd:= th_win; 
       {sv_old_wnd:= sv_snd_wnd;}  
      sv_snd_wd1:= th_seq; 
 
      sv_snd_wd2:= th_ack; 
           {Leave persist state if window opens up}            IF sv_snd_wnd > 0 THEN           BEGIN {cancel}            TcpCancelTimer(PERSISTTYPE, tmr_err);           IF tmr_err = INVALIDTIMERID THEN   	            BEGIN  	             tcp_port.p_syn_bits[-PERSISTTYPE] := true;              END;           END; {cancel}  
      END; {update window} 
          {Process segment with URG flag set}       IF tcpflags.b.urg AND (th_urp <> 0)             AND (sv_state < TIME_WAIT) THEN          BEGIN {process urg}           IF Seq_Gt(th_seq + th_urp, sv_rcv_up) THEN             BEGIN             sv_rcv_up:= th_seq + th_urp;              END;           IF th_urp <= ih_len THEN             BEGIN             DoUrgentData;             END;   
        END; {process urg} 
            {}   !   {Process the segment text, merging it into the TCP sequencing } ! !   {queue, and arranging for acknowledgement of receipt if needed} ! !   {This process logically involves adjusting rcv_wnd as data is } ! !   {presented to the the user (this happens when ICP gives us the} ! !   {updated report on memory). If a FIN has already received on  } ! !   {this connection then we just ignore the text.                } !    {}      IF ((ih_len > 0) OR tcpflags.b.fin)              AND (sv_state < TIME_WAIT) THEN   
      BEGIN {accept} 
       tcpflags.w:= TCPREASS(sv, sv_ptr, inseghdr, insegptr);        IF tcp_error <> 0 THEN           BEGIN  	         goto 888; 	          END;             IF tcpgbls.no_delay = 0 THEN            BEGIN {delay}             sv_t_flags.delack:= true;             TcpSetTimer(DELACKTYPE, TCPTV_DELAY);             END   {delay}         ELSE  
          BEGIN {ack now}  
           sv_t_flags.acknow:= true;   
          END;  {ack now}  
 	      END {accept} 	    ELSE   
      BEGIN {release text} 
       DS_MDispose(insegptr, tcp_error);         tcpflags.b.fin:= false;   
      END; {release text}  
            {}      {Process segment with FIN}      {}      {If FIN is received ack the FIN and let the user know that}     {the connection is closing.                               }      
   IF tcpflags.b.fin THEN  
 
      BEGIN {process fin}  
       IF sv_state < TIME_WAIT THEN  	         BEGIN {*} 	          sv_t_flags.acknow:= true;           sv_rcv_nxt:= sv_rcv_nxt + 1;                {Need to let IPC know that its peer }           {want to disconnect; But we will not}           {any more because we assume the user}           {will do a graceful release himself.}           {SSDisconnectInd(sb_ptr);           }  	         END; {*}  	           CASE sv_state OF               {In SYN_RECEIVED and ESTABLISHED states enter the           CLOSE_WAIT state.}                SYN_RECEIVED,           ESTABLISHED:   	            BEGIN  	             sv_state:= CLOSE_WAIT;              END;               {If still in FIN_WAIT_1 state FIN has not been acked}           {so enter the closing state.                        }      
         FIN_WAIT_1: 
 	            BEGIN  	             sv_state:= CLOSING;               END;               {In FIN_WAIT_2 state enter TIME_WAIT state. starting}           {the timer and turning off the other timers. Drop   }            {all connect resources and send a comfirmation to ipc}        
         FIN_WAIT_2: 
             BEGIN {finwait2}              sv_state:= TIME_WAIT;               in_path := port_ptr;              TCPConnDrop(tcp_port, port_ptr, 0);               port_ptr := in_path;              TCPClosePath(tcp_port, port_ptr);               END; {finwait2}               {In TIME_WAIT state restart timer.}       
         TIME_WAIT:  
 	            BEGIN  	             TcpCancelTimer(MSLTYPE, tmr_err);               TcpSetTimer(MSLTYPE, TCPTV_MSL);              END;           END; {case state of & fin}         END; {process fin}      #      {Write PCB and path back to DSAM if they are still valid. also}  # #      {invoke the outbound if a possible response is require....    }  #       IF (sv_ptr <> 0) AND (port_ptr <> 0) THEN   
         BEGIN {valid PCB} 
          DS_StoreFields(DS_TCP_TCBTD, sv_ptr, sv.startofdata,               DATAOFFSET, SVDATASIZE);               tcp_port.p_syn_bits[-1] := true;   #         DS_StoreFields(DS_TCP_PATHTD, port_ptr, tcp_port.startofdata, #             DATAOFFSET, PATHDATASIZE);               IF sv_t_flags.ipcwait THEN               BEGIN {in embryo state}   !            {Bump the To_ULP_CNT and Write it back to DSAM before} ! !            {sending the connect indication to the ULP.          } !             tcp_port.p_up_cnt := tcp_port.p_up_cnt + 1;       %            DS_StoreFields(DS_TCP_PATHTD, port_ptr, tcp_port.startofdata,  %                               DATAOFFSET, PATHDATASIZE);  
            SSendConnInd;  
             END   {in embryo state}            ELSE               BEGIN {non embryotic state}               {Return any desired output by signaling our     }               {outbound buddy. We will not signal the outbound}               {process if we are still in the embryotic state }                    DS_SatBeamSignal(tcp_port.p_up_refr, OUTBOUND_SIG);                END; {Non embryoyci state}               {Say that we have already updated the path and PCB}           port_ptr := 0;            sv_ptr   := 0;   
         END;  {valid PCB} 
 
   END; {start processing} 
     888:     {Need to update both PCB and PATH in DSAM table area}         IF port_ptr <> null_ptr THEN         BEGIN         {Say that the path has beeb touch by us.}         tcp_port.p_syn_bits[-1] := true;  "      DS_StoreFields(DS_TCP_PATHTD, Port_ptr, tcp_port.startofdata,  "          DATAOFFSET, PATHDATASIZE);         END;         IF sv_ptr <> null_ptr THEN         BEGIN         DS_StoreFields(DS_TCP_TCBTD, sv_ptr, sv.startofdata,           DATAOFFSET, SVDATASIZE);         END;      
   IF updategbl THEN 
       BEGIN         DS_StoreElement(DS_TCP_LISTHDTD, 1, tcpgbls.int);         END;  END; {tcpinput}               $SUBTITLE ' TCP Inbound', PAGE$   "{------------------------------------------------------------------} " "{                                                                  } " "{                         TCPInbound                               } " "{                                                                  } " "{------------------------------------------------------------------} "     
PROCEDURE TCPInbound 
    {VAR e_msg  : EventMessageType;      VAR result : Int16         };       {}  { Description:   {  TCP event handler. Identify event and call appropriate action   {  routine.   {   { Parameters:   {  e_msg   INPUT  Event message from IP.  {   {}      VAR      temp_ptr  : Int16;       	BEGIN {tcpinbound} 	     {}  DS_EnterCritical ( tcp_wkmap, tcp_ierr );   {}      {Log the Event message if tracing is on}  Log_Event(EL_EVENT, TCP, 0, dummyrefr,               EMSG_WORD_LEN, e_msg.int, tcp_error);      {Get the tcp global parameters ie, list heed and etc}   GetTCPGlobals;  sv        := INITSTATEVECTOR;   sv_ptr    := 0;   port_ptr  := 0;   tcp_error := 0;   
updategbl := false;  
     CASE e_msg.em_event OF      
   KILL_INDICATION:  
       BEGIN         {we will probably marked the pcb's that the dn_refr}        {is in trouble and should take action when outbound}        {is activated.                                     }  #      DS_FetchElement(DS_TCP_PATHTD, d_path_list_head, temp_path.int); #       WITH temp_path DO   
         BEGIN {with path} 
          WHILE p_nxt_ptr <> d_path_list_head DO               BEGIN {loop}              temp_ptr := p_nxt_ptr;              DS_FetchElement(DS_TCP_PATHTD,                                temp_ptr, temp_path.int);               IF p_dn_refr = e_msg.emki_down_ref THEN   
               BEGIN 
                p_syn_bits[-1]  := true;                  p_syn_bits[-15] := true;   '               DS_StoreFields(DS_TCP_PATHTD, temp_ptr, temp_path.startofdata,  '                                  DATAOFFSET, PATHDATASIZE);   
               END;  
             END;  {loop}  
         END;  {with path} 
       END;      
   DATA_INDICATION:  
       BEGIN         TCPInput(e_msg);        END;              STATUS_INDICATION:        BEGIN   !      {Ip tell us the optimal segment size; chase down the Dpath } ! !      {list and update the max_seg_size on all connection control} ! !      {blocks.                                                   } !           DS_FetchElement(DS_TCP_PATHTD, d_path_list_head,                           temp_path.int);        WITH temp_path, sv DO            BEGIN {with}            WHILE p_nxt_ptr <> d_path_list_head DO   
            BEGIN {while}  
             temp_ptr := p_nxt_ptr;              DS_FetchElement(DS_TCP_PATHTD,                                temp_ptr, temp_path.int);               IF p_dn_refr = e_msg.emsi_dn_ref THEN   
               BEGIN {fi}  
                {Could use a DS_StoreField () here instaed}                 DS_FetchElement(DS_TCP_TCBTD,                                  p_tcp_pcb, sv.int);       &               {Ignore the indication if the size is some ridiculous value}  &                IF e_msg.emsi_segsize > TCPHEADERSIZE THEN   
                  BEGIN {} 
 %                  {The segment size is what IP tells us minus our header}  % $                  sv_maxseg.word := e_msg.emsi_segsize - TCPHEADERSIZE;  $ %                  DS_StoreFields(DS_TCP_TCBTD, p_tcp_pcb, sv.startofdata,  %                                     DATAOFFSET, SVDATASIZE);  
                  END;  {} 
 
               END;  {fi}  
 
            END;  {while}  
          END;  {with}         END;         OTHERWISE        BEGIN         {unknown event message}         TCPLogError(UNKNOWNEVENT, TI_TCPINBOUND);         END;      
   END;    {case of} 
 {}  DS_LeaveCritical ( tcp_wkmap );   {}  	END; {tcpinbound}  	     
END  {end of module} 
 .  