 $PASCAL '91790-1X212 REV.4010 <860327.1300>' $  $STANDARD_LEVEL 'HP1000'  $DEBUG  $TITLE 'TCP Declarations Constant & Variables'  $PAGE   $WIDTH 90   $HEAPPARMS OFF  
$RECURSIVE OFF, RANGE OFF$ 
 $HEAP 0   	$HEAP_DISPOSE OFF  	         MODULE tg;  $ALIAS 'N$TG'$      {------------------------------------------------------------    (c) COPYRIGHT HEWLETT PACKARD COMPANY 1986. ALL RIGHTS    RESERVED. NO PART OF THIS PROGRAM MAY BE PHOTOCOPIED,   REPRODUCED OR TRANSLATED TO ANOTHER PROGRAM LANGUAGE WITHOUT    THE PRIOR WRITTEN CONSENT OF THE HEWLETT-PACKARD COMPANY.   ------------------------------------------------------------}      {}  {       NAME: TCPGB.PAS                              }  {     SOURCE: 91790-18212                            }  {      RELOC: NONE                                   }  {       PGMR: MCL                                    }  {}      {}  {  Modification:  {   !{    Mar. 11th 1986 - Incorrect length specified for TCP's global  ! {    buffer element. It should be 29 words long instead of 24.  {    {    Mar. 27th 1986 [PCO 2626] - Adjust the TCP retransmit value   {    to accommodate gateway with slow link (96kb) and catenet.  "{    Raised the maximum allowable ceiling (TCPTV_MAX) to 60 seconds. " {    SR# (not available yet).   {   {}      IMPORT     $SEARCH 'phtm/BODEC.REL'      bodec,      $SEARCH 'phtm/SODEC.REL'      sodec,      $SEARCH 'phtm/MMDEC.REL'      mmdec,      $SEARCH 'phtm/MMEXT.REL'      ds_mm,      $SEARCH 'phtm/trcmod.REL'     trcmod,     $SEARCH 'phtm/TMRDEC.REL'     tmrdec;      EXPORT      $SUBTITLE ' Type Declaration Section', PAGE$      TYPE      { Simulate strings with packed characters }      LineType   = PACKED ARRAY [1..22] OF CHAR;       {}  "{ TCP connection and state variables: This data structure maintains  " !{ TCP information on single connection. It is partly based on the  ! { protocol specification and Berkeley's implementation.   {}         HalfByteType = 0..15;         SixBitType   = 0..63;         AddrType     = Int32;         TCPSeqType   = Int32;         TCPStateType = Int16;         EventMessageType = EventMsgType;          {}      { TCPMsgAryType : Used for keeping track of message frames      {    in our our message flow control implementation.      {}          TCPMsgAryType   = ARRAY[0 .. 7] OF Int16;         {}      {SynFlagType      {     {   Bit 15: if true then path is down.      {   Bit 14: if true then path has been aborted.     {   Bit 13: if true then need to make connect offer to ipc.     {   Bit 04  if true then Timer 3 has popped.      {   Bit 03  if true then Timer 2 has popped.      {   Bit 02  if true then Timer 1 has popped.      {   Bit 01: if true then pcb context has been touched.      {   Bit 00: if true then outbound path is busy.     {}          SynFlagType = PACKED ARRAY [-15..0] OF BOOLEAN;      
   TCPPathRecType = RECORD 
 
      CASE Int16 OF  
       1: (int:  Int16;            int1: Int16;            startofdata: Int16);      #      2: (p_pre_ptr      : Int16;        {backward pointer          }  # #          p_nxt_ptr      : Int16;        {forward  pointer          }  # #          p_port_type    : Int16;        {type of tcp ports         }  # #          p_s_port       : Int16;        {source tcp address        }  # #          p_d_port       : Int16;        {destination tcp address   }  # #          p_si_addr      : AddrType;     {source internet address   }  # #          p_di_addr      : AddrType;     {dest. internet address    }  # #          p_s_flags      : Int16;        {service flags             }  # #          p_ref_cnt      : Int32;        {msg count from llp        }  # #          p_msg_cnt      : Int32;        {event msg cnt from ulp    }  # #          p_up_cnt       : Int32;        {event msg cnt to   ulp    }  # #          p_snd_cnt      : Int32;        {event msg cnt to llp      }  # #          p_syn_bits     : SynFlagType;  {synchronization flags     }  # #          p_root_pid     : Int16;        {Root PID not used         }  # #          p_up_pid       : Int16;        {Up PID - IPC always       }  # #          p_dn_pid       : Int16;        {Down PID - IP             }  # #          p_root_ref     : Int16;        {Not used                  }  # #          p_up_refr      : Int16;        {ulp reference - Path      }  # #          p_dn_refr      : Int16;        {llp reference - Path      }  # #          p_tcp_pcb      : Int16);       {connection control block  }  #       END;             {Key to uniquely identify a connection}     ConnIdType = RECORD        Case boolean of         false: (int       : Int16);         true :  !        (c_s_port       : Int16;      {Source port address      }  ! !         c_d_port       : Int16;      {Destination port address }  ! !         c_si_addr      : AddrType;   {Source IP address        }  ! !         c_di_addr      : AddrType);  {Destination IP address   }  !       END;         {Possible control flags for TCP outbound message}     TCPOutFlagType = PACKED ARRAY [0..10] OF SixBitType;       
   {Connection attributes} 
    OurFlagsType = PACKED RECORD         acknow  : BOOLEAN;    {ack our peer now flag     }        delack  : BOOLEAN;    {delay ack to peer         }        noopt   : BOOLEAN;    {indicate no tcp optins    }        nokeep  : BOOLEAN;    {don't use keep alive      }        nourg   : BOOLEAN;    {don't process urgent data }        push    : BOOLEAN;    {need to handle push       }        cksumopt: BOOLEAN;    {cksum all data            }        ipcwait : BOOLEAN;    {wait for accept connection}        msg_mode: BOOLEAN;    {true if in message mode   }        graceful: BOOLEAN;    {true received graceful req}        debug   : BOOLEAN;    {true if in debug mode     }        rselect : BOOLEAN;    {true if read select is on }        rmcksum : BOOLEAN;    {true if remote opt for checksum}         p1,p2,        p3      : BOOLEAN;        END;             ReassPtrType = RECORD  
      CASE Int16 OF  
       1: (int:  Int16);   
      2: (previous: Int16; 
           next:     Int16);         END;      
   OptionBufType = RECORD  
       CASE Boolean OF   
      false: (int: Int16); 
       true:  (byt: PACKED ARRAY [1 .. 4] OF BYTE);        END;         IPCFlagsType = RECORD        CASE Boolean OF   
      false: (int: Int16); 
       true:  (bts: PACKED ARRAY [-15 .. 0] OF BOOLEAN);         END;         TCPStatType = RECORD         badsum:  Int32;     {bad checksum        }        badoff:  Int32;     {bad offsets         }        hdrop :  Int32;     {others, ie no memory}        badsegs: Int32;     {bad segments        }        unack:   Int32;     {unacknowledged      }        END;      {}  	{  TCPListBufType  	 {     i_phead   : Pointer to the ipath list head  {     d_phead   : Pointer to the dpath list head  {     f_phead   : Pointer to the free list of path records  ${     i_thead   : Pointer to the in-use protocol control block list head $ #{     f_thead   : Pointer to the free protocol control block list head # {     tcpsocket : Socket ID of the TCP root socket  {     segsize   : Default TCP segment size in bytes   !{     expbkof   : 0 = use geometric backoff values for retransmit; ! {                 non-zero = use exponential backoff valuse   {     max_pcbs  : maximum of of active connections supported  !{     max_paths : maximum of of tcp paths structures in the system ! "{     no_delay  : 1 -> acknowlege packet immediately; 0 -> wait for  " {                 more packet or one 'delay-time-out'.   {     wnd_ps    : a percent of the total window (range 0 to 100)   %{                 if wnd_ps = 25, then min_wnd = 25% of the total window.  % {     tcp_alpha : retransmit smoothing parameters   {     tcp_beta  : " "   ${     init_to   : initial retransmit timeout value in seconds (1 to 30). $ {     port_addr : The next available TCP port address.  ${     tcp_debug : TCP debug flag; positive non-zero then trigger routine $ #{                 is activated; if it is -ve then timers are turn off. # {     stats     : TCP global exceptional statistics.  {}          
   TCPListBufType = RECORD 
 
      CASE Int16 OF  
       1: (int       : Int16);         2: (i_phead   : Int16;            d_phead   : Int16;            f_phead   : Int16;            i_thead   : Int16;            f_thead   : Int16;            tcpsocket : Int16;            expbkof   : Int16;            port_addr : Int16;            segsize   : Int16;            max_pcbs  : Int16;            max_paths : Int16;            no_delay  : Int16;            wnd_ps    : Int16;            tcp_alpha : Real;             tcp_beta  : Real;             init_to   : Int16; {in seconds}             tcp_debug : Int16;            stats     : TCPStatType);         END;      
   ByteOrWordType = RECORD 
 
      CASE Int16 OF  
       1: (bite: PACKED ARRAY[1..2] OF Byte);        2: (word: Int16);         END;      {}  	{  StateVectorType 	  {    This is the structure of TCP's control block; it is used by    {    TCP to keep track of the connection state and variables, to   {    maintain flow control information and to tie various list  {    together. It is also used to maintain previously used TCP  {    port numbers as defined in case 2 below.   {}         StateVectorType = RECORD   
      CASE Int16 OF  
       1: (int         : Int16;            int1        : Int16;            startofdata : Int16);             2: (b_ptr     : Int16;            f_ptr     : Int16;  !          limboptr  : Int16;      {ptr to the next available slot} ! !          msltimer  : TimerIDType;{timer ID                      } !           limbolist : Array [0 .. 88] OF Int16);            3: (         sv_pre_ptr : Int16;              {list - back pointer    }          sv_nxt_ptr : Int16;              {list - forward pointerr}                 {use template as the anchor for reassemby queue}  !      sv_template  : Int16;            {ptr to assembly seninel }  ! !      sv_state: TCPStateType;          {state of this connection}  !           {*** tcp timer stuff ***}          sv_t_rexmt   : TimerIdType;      {retransmit timer      }           sv_t_persist : TimerIdType;      {persist timer         }           sv_t_keep    : TimerIdType;      {keep alive timer      }           sv_t_2msl    : TimerIdType;      {2*msl quiet time timer}           sv_t_idle    : TimerIdType;      {idle timer            }           sv_t_delack  : TimerIdtype;      {delay ack timer..400ms}              {*** Segment size and flags ***}  !      sv_snd_cnt: Int16;               {# of bytes in send queue } ! !      sv_t_flags: OurFlagsType;        {see ourflagstype         } ! !      sv_forced:  Int16;               {1 if need to force a byte} ! !      sv_maxseg: ByteOrWordType;       {max. tcp segment size    } !           {*** per protocol spec ***}         {*** send sequence variables ***}   !      sv_snd_una: TCPSeqType;          {send unacknowledged     }  ! !      sv_snd_nxt: TCPSeqType;          {send next               }  ! !      sv_snd_up:  TCPseqType;          {send urgent pointer     }  ! !      sv_snd_wd1: TCPSeqType;          {window update seq number}  ! !      sv_snd_wd2: TCPSeqType;          {window update ack number}  ! !      sv_iss:     TCPSeqType;          {initial send seq number }  ! !      sv_snd_wnd: Int16;               {send window             }  !           {* message mode stuff *}  !      sv_rcv_frm_adv: Int32;          {advertized frame seq.     } ! !      sv_rcv_frm_nxt: Int32;          {next receive message frame} !     !      sv_old_wnd :  Int16;             {last adv window from peer} ! !      sv_max_snds:  Int16;             {Max. allowable # of sends} ! !      sv_frame_cnt: Int16;             {# of message frames avail} !     !      sv_max_rcvs:  Int16;             {Max. # allowable receives} ! !      sv_min_frames: Int16;            {Min. window in frames    } ! !      sv_max_msgsize: Int16;           {Max. msg size            } !        sv_rcv_frames: Int16;            {# of available receiving   !                                        frames for messages      } !           {*** receive sequence variables ***}  "      sv_rcv_wnd: Int16;               {receive window            }  " "      sv_rcv_nxt: TCPSeqType;          {receive next              }  " "      sv_rcv_up:  TCPSeqType;          {receive urgent pointer    }  " "      sv_irs:     TCPSeqType;          {initial receive seq number}  "           {*** additional variable ***}   "      sv_min_wnd: Int16;               {Min. write select window in  " #                                        percentage of the Max window}  # "      sv_rcv_adv: TCPSeqType;          {advertised receive window  } " "      sv_snd_max: TCPSeqType;          {highest seq # sent, used   } " "                                       {to recognize retransmission} " "      sv_rcv_max: Int16;               {max. possible receive space} " "      sv_av_wnd : Int16;               {current available window   } "           {*** transmit timing stuff ***}   "      sv_idle_cnt:  Int16;             {inactivity timeout count  }  " "      sv_retry_cnt: Int16;             {retransmit timeout count  }  " "      sv_keep_cnt : Int16;             {keepalive timeout count   }  " "      sv_rt_time:   Int32;             {round trip starting time  }  " "      sv_srt_time:  Int32;             {smoothed round-trip time  }  " "      sv_t_rtt   :  Int32;             {round trip time           }  " "      sv_t_rtseq: TCPSeqType;          {seqence number being timed}  "           {tcp message mode...}   "      sv_snd_qhead  : Int16;            { Send message queue       } " "      sv_snd_qtail  : Int16;            {  pointers and            } " "      sv_snd_msg_ary: TCPMsgAryType;    {   queue elements         } "     "      sv_rcv_qhead  : Int16;            { Receive message queue    } " "      sv_rcv_qtail  : Int16;            {  pointers and            } " "      sv_rcv_msg_ary: TCPMsgAryType;    {   queue elements         } "           {*** TCP statistics ***}  "      sv_tcpstat: TCPStatType          {see tcpstattype           }  " 
      ); {end of variant}  
       END;          {Variable types for input and output processing}         OvlyHdrType = PACKED RECORD        ih_prev: Int16;     {Segment sequencing links    }        ih_next: Int16;         ih_adj : Int16;     {byte count adjustment       }        ih_x1  : Byte;      {Unused                      }        ih_pr  : Byte;      {Protocol                    }        ih_len : Int16;     {protocol length             }        ih_pad : Int16;     {temporary variable          }        ih_src : AddrType;  {Source internet address     }        ih_dst : AddrType;  {Destination internet address}        END;         TCPFlagType = PACKED RECORD        urg:  BOOLEAN;      {urg flag }         ack:  BOOLEAN;      {ack flag }         push: BOOLEAN;      {push flag}         rst:  BOOLEAN;      {rst flag }         syn:  BOOLEAN;      {syn flag }         fin:  BOOLEAN;      {fin flag }         END;         OneOrBitType = PACKED RECORD   
      CASE Int16 OF  
 
      1: (w: SixBitType);  
 
      2: (b: TCPFlagType); 
       END;         TCPHdrType = PACKED RECORD         CASE Boolean OF         false : (int: Int16);         true  : (th_sport: Int16;        {source port      }                 th_dport: Int16;        {destination port }                 th_seq  : TCPSeqType;   {sequence number  }                 th_ack  : TCPSeqType;   {acknowledgement #}                 th_off  : HalfByteType; {offset 0..15     }                 th_x2   : SixBitType;   {reserved 0..63   }                 th_flags: OneOrBitType; {tcp flags        }                 th_win  : Int16;        {window           }                 th_sum  : Int16;        {checksum         }                 th_urp  : Int16);       {urgent pointer   }        END;         ExpBackoffType = ARRAY [1..8] OF Int16;         RegBackoffType = ARRAY [1..8] OF REAL;          TCPOptType = PACKED RECORD         kind    : Byte;         length  : Byte;         max_size: Int16;        END;         IPTCPHdrType = RECORD  
      CASE Int16 OF  
       1: (int:  Int16);         2: (int2: ARRAY [1..20] OF Int16);        3: (hdr1: OvlyHdrType;    {Ip overlay header}             hdr2: TCPHdrType);    {TCP header       }         END;      
  IntOrTCPHdrType = RECORD 
 	     CASE Int16 OF 	      1: (int:  Int16);       2: (rec:  TCPHdrType);        END;             ReasHdrType   = IPTCPHdrType;             TCPEvInfoType = Record  
     CASE boolean OF 
         false: (int         :  Int16);          true : (err_code    :  Int16;                   dummy       :  Int16;                   pathrec     :  TCPPathRecType);         END;          $SUBTITLE 'Global constants declaration ', PAGE$      CONST       { *** TCP SPECIFIC CONSTANTS *** }       {TCP states}     CLOSED =       0;    {closed                              }     LISTEN =       1;    {listening for connection            }     SYN_SENT =     2;    {active, have sent syn               }     SYN_RECEIVED = 3;    {have sent and received syn          }         {states < established = connection not establihed}    ESTABLISHED =  4;    {established                         }     CLOSE_WAIT =   5;    {received fin, waiting for close     }         {state > close_wait = user have closed}     FIN_WAIT_1 =   6;    {have closed, sent fin               }     CLOSING  =     7;    {closed, exchanged fin, await fin ack}     LAST_ACK =     8;    {had fin and close; await ack of fin }             {state > close_wait < fin_wait_2 = awaiting ack of fin}     FIN_WAIT_2 =   9;    {have closed, fin is acked           }     TIME_WAIT =   10;    {in 2*msl quiet time wait after close}       	 {TCP Timer types} 	  REXMTTYPE      = 2;    {retransmit timer         }    PERSISTTYPE    = 3;    {persist timer            }    KEEPTYPE       = 4;    {keep alive timer         }    MSLTYPE        = 5;    {time wait (2 * msl) timer}    IDLETYPE       = 6;    {idle timer * not implemented}   DELACKTYPE     = 7;    {delay ack timer type     }        {Timer signal types... these timers are defined by ipc; tcp}     {uses timer1 for its delay ack timer, timer2 for the keepalive}    {timer and the timer3 for either the retransmit or the      }   {persist timer. When the retransmit timer is on the persist }   {timer has to be off. Timer1 on the TCP root socket is used }   {for 2msl (limbo list) timer.                               }      " TIMER1         = TIMERABLE_1;    {for enabling delayack timer only} " " TIMER2         = TIMERABLE_2;    {for keepalive timer only        } " " TIMER3         = TIMERABLE_3;    {for retransmit or persist timers} "         {DEBUG SMOOTH CONSTANT}   
 DB             = 1; 
      {TCP Timer constants}  " TCPTV_DELAY      = DB * 20;   {delay ack timer value - .2 second }  " " TCPTV_MIN        = DB * 500;  {min. allowable value - 5.0 seconds } " " TCPTV_MAX        = DB * 6000; {max. allowable value - xxx seconds } " " TCPTV_MSL        = DB * 12000;{maximum segment lifetime - 120 sec}  " " TCPTV_KEEP       = DB * 6000; {keep alive - 60 seconds           }  " " TCPTV_PERSMIN    = DB * 1500; {retransmit persistance- 15 sec    }  " " TCPTV_MAXKEEP    = 7;         {max. keepalive retry count        }  " " TCPTV_MAXIDLE    = 7;         {max. allowable idle time - Not used} " " TCPTV_SRTTBASE   = 500;       {Not used - use user's conf. value }  " " TCPTV_LINGERTIME = 120;       {linger at most 2 min - Not used   }  " " TCPTV_MAXRXT     = 8;         {max. allowable retransmit counter }  "     {TCP Error Constants}   ! TCPEB          = 14000;        {TCP Error Base                  } ! ! NOCONNRESRC    = TCPEB + 1;    {no connection resource          } ! ! CONNREFUSED    = TCPEB + 2;    {remote reject connection attempt} ! ! CONNRESET      = TCPEB + 3;    {connection was reset by remote  } ! ! NOTALIVE       = TCPEB + 4;    {keep alive timer expire         } ! ! IDLE2LONG      = TCPEB + 5;    {idle timer expire               } ! ! NODSSMBUF      = TCPEB + 6;    {cannot get dssm buffers         } ! ! NOENDPOINT     = TCPEB + 7;    {no listener                     } ! ! TIMEOUT        = TCPEB + 8;    {retransmit retry exceeded       } ! ! FLOW_PROBLEM   = TCPEB + 9;    {memory accounting problem       } ! ! BADOFFSET      = TCPEB + 10;   {incoming segment has bad offset } ! ! BADCHECKSUM    = TCPEB + 11;   {bad checksum                    } ! ! PATHABORTED    = TCPEB + 12;   {tcp path has beeb aborted       } ! ! CONNDROPPED    = TCPEB + 13;   {tcp connection has been dropped } ! ! BADREFERENCE   = TCPEB + 14;   {bad tcp path reference          } ! ! BADULPREFERENCE= TCPEB + 15;   {bad upper level protocol refr   } ! ! BADSENDQUEUE   = TCPEB + 16;   {bad tcp send queue              } ! ! SEVEREDSERROR  = TCPEB + 17;   {irrecoverable error             } ! ! PATHEXISTED    = TCPEB + 18;   {ipath already existed           } ! ! ABORTRACE      = TCPEB + 19;   {Race betw in/out abort request  } ! ! PEEREXPWND     = TCPEB + 20;   {Remote peer expand rcv window   } ! ! UNKNOWNEVENT   = TCPEB + 21;   {Unknown Event Message received  } !     { Debug internal error location }       TL_RECORDFMSIZE   = 1;   {at routine recodfmsize/tcplb }  TL_UPDATEFMCNT    = 2;   {at routine updatefmcnt/tcplb }  TL_SETTIMER       = 3;   {at routine settimer/tcplb    }  TL_SETCONTEXTOK   = 4;   {at routine setcontextok/tcplb}  TL_TCPRESPOND     = 5;   {at routine tcprespond/tcplb  }  TL_TCPCONNDROP    = 6;   {at routine tcpconndrop/tcplb }  TL_TCPCLOSEPATH   = 7;   {at routine tcpclosepath/tcplb}  TL_FREESVECTOR    = 8;   {at routine freesvector/tcplb }  TL_USDELAY        = 9;   {at routine usdelay/tcplb     }  TL_OUTSTBEVENT    = 10;  {at routine outstbevent/tcplb }  TL_INSTBEVENT     = 11;  {at routine instbevent/tcplb  }      TOB_DISCONNECTREQ = 12;  {at routine disconnecreq/tcpout}   TOB_CONNECTREQ    = 13;  {at routine connectreq/tcpout  }   TOB_RCVRESPONSE   = 14;  {at routine RCVRESPONSE/TCPOUT }   TOB_USERRCVREQ    = 15;  {at routine USERRCVREQ/TCPOUT  }   TOB_SENDREQ       = 16;  {at routine SENDREQ/TCPOUT     }   TOB_ABORTREQ      = 17;  {at routine ABORTREQ/TCPOUT    }   TOB_RTXMTDBG      = 18;  {at routine TIMERIND/TCPOUT    }   TOB_TIMERIND      = 19;  {at routine TIMERIND/TCPOUT    }   TOB_TCPSEND1      = 20;  {at routine TCPSEND/TCPOUT     }   TOB_TCPSEND2      = 21;  {at routine TCPSEND/TCPOUT     }   TOB_TCPSEND3      = 22;  {at routine TCPSEND/TCPOUT     }   TOB_TCPOUTMAIN    = 23;  {at routine TCPOUTPUT/TCPOUT   }   TOB_TCPOUTMAIN1   = 24;  {at routine TCPOUTPUT/TCPOUT   }   TOB_TCPOUTMAIN2   = 25;  {at routine TCPOUTPUT/TCPOUT   }   TOB_TCPOUTBOUND   = 26;  {at routine TCPOUTBOUND/TCPOUT }       TI_TCPREASS       = 27;  {at routine TCPREASS/TCPOUT    }   TI_TCPINPUT       = 28;  {at routine TCPINPUT/TCPOUT    }   TI_TCPINBOUND     = 29;  {at routine TCPINBOUND/TCPOUT  }           
{TCP control flags}  
  TH_FIN =  1;         {can send no more     }    TH_SYN =  2;         {connect initiation   }    TH_RST =  4;         {reset connection     }    TH_PUSH = 8;         {push - end of message}    TH_ACK = 16;         {ack sequence is valid}    TH_URG = 32;         {urgent pointer valid }       {TCP port type}     CALL_PORT     =  0;         {ports in permenant listen mode   }     CIRCUIT_PORT  =  1;         {ports associated with connections}   
 UNDEFINEDTYPE = -1; 
     {TCP, IP header size in bytes}  
 TCPHEADERSIZE      = 20;  
 
 IPHEADERSIZE       = 20;  
  IPTCPHDRSIZE       = TCPHEADERSIZE + IPHEADERSIZE;        {tcp structure sizes in words}    SIZEOFTCPLISTHD         = 29;   SIZEOFTCPSV             = 99;   SIZEOFTCPPATH           = 26;   LIMBOLSTSIZE            = SIZEOFTCPSV - 5;    SIZEOFPOINTERS          = 2;    DATAOFFSET              = SIZEOFPOINTERS;   SVDATASIZE              = SIZEOFTCPSV - SIZEOFPOINTERS;   PATHDATASIZE            = SIZEOFTCPPATH- SIZEOFPOINTERS;           {TCP option definition}    DPATHOPTION   = 0;     {use dpath list option}    IPATHOPTION   = 1;     {use ipath list option}    TCPOPT_EOL    = 0;     {end of option list   }    TCPOPT_NOP    = 1;     {no operation         }    TCPOPT_MAXSEG = 2;     {maximum segment size }       
{TCP portocol class} 
  TCP_PTCL = 6;      {tcp max. send segment size}   MAXSEGMENTSIZE = 500; {bytes ...for testing only}      {tcp port address range}  	 IPWILDCARD  = 0;  	 	 TCPWILDCARD = 0;  	  MIN_DYNAMIC = 16384;    MAX_DYNAMIC = 32767;       {Flags used when sending segments in tcp_output. Basic   flags (RST,ACK,SYN,FIN) are totally determined by state.    With the proviso that FIN is sent only if all data queued   for output is included in the segment.}      
 OUTFLAGS = TCPOutFlagType 
     [TH_RST+TH_ACK, 0, TH_SYN,       TH_SYN+TH_ACK, TH_ACK, TH_ACK,        TH_FIN+TH_ACK, TH_FIN+TH_ACK,       TH_FIN+TH_ACK, TH_ACK, TH_ACK];      
 TCP_INITOPT = TCPOptType  
      [kind: 2, length: 4, max_size: 256];       
 TCPDEFAULTTOS = 0;  
      EXP_VALUE = ExpBackoffType       [1, 2, 4, 8, 16, 32, 64, 128];       BACKOFF_VALUE = RegbackoffType       {use this for the test bed memory mmgr}       [1.0 , 1.5, 1.7, 2.5, 3.0, 3.5, 5.0, 8.0];     {[1.0 , 1.2, 1.4, 1.7, 2.0, 3.0, 5.0, 8.0];}        INITTCPPATH = TCPPathRecType       [p_pre_ptr   : 0,        p_nxt_ptr   : 0,        p_port_type : UNDEFINEDTYPE,        p_s_port    : 0,        p_d_port    : 0,        p_s_flags   : 0,        p_ref_cnt   : 0,        p_msg_cnt   : 0,        p_up_cnt    : 0,        p_snd_cnt   : 0,        p_syn_bits  : SynFlagType          [false, false, false, false,           false, false, false, false,           false, false, false, false,           false, false, false, false],        p_root_pid  : 0,        p_up_pid    : 0,        p_dn_pid    : 0,        p_root_ref  : 0,        p_up_refr   : 0,        p_dn_refr   : 0,        p_si_addr   : 0,        p_di_addr   : 0,        p_tcp_pcb   : 0];       INITSTATEVECTOR = StateVectorType       [sv_pre_ptr   : 0,         sv_nxt_ptr   : 0,         sv_template  : 0,         sv_state     : 0,             sv_t_rexmt   : TimerIdType           [index : -1, key : -1],        sv_t_persist : TimerIdType           [index : -1, key : -1],        sv_t_keep    : TimerIdType           [index : -1, key : -1],        sv_t_2msl    : TimerIdType           [index : -1, key : -1],        sv_t_idle    : TimerIdType           [index : -1, key : -1],        sv_t_delack  : TimerIdType           [index : -1, key : -1],            sv_snd_cnt   : 0,         sv_t_flags   : OurFlagsType            [acknow: false, delack: false, noopt: true,            nokeep: false, nourg: true, push: false,            cksumopt: false, ipcwait: false, msg_mode: false,             graceful: false, debug: true, rselect: false,   
          rmcksum : false, 
           p1: false, p2: false, p3: false],         sv_forced    : 0,         sv_maxseg    : ByteOrWordType[ word : 0],         sv_snd_una   : 0,         sv_snd_nxt   : 0,         sv_snd_up    : 0,         sv_snd_wd1   : 0,         sv_snd_wd2   : 0,         sv_iss       : 0,         sv_snd_wnd   : 0,   
      sv_rcv_frm_adv : 0,  
 
      sv_rcv_frm_nxt : 0,  
 
      sv_old_wnd     : 0,  
 
      sv_max_snds    : 0,  
 
      sv_frame_cnt   : 0,  
 
      sv_max_rcvs    : 0,  
 
      sv_min_frames  : 0,  
 
      sv_max_msgsize : 0,  
 
      sv_rcv_frames  : 0,  
       sv_rcv_wnd   : 0,         sv_rcv_nxt   : 0,         sv_rcv_up    : 0,         sv_irs       : 0,         sv_min_wnd   : 0,         sv_rcv_adv   : 0,         sv_snd_max   : 0,         sv_rcv_max   : 0,         sv_av_wnd    : 0,         sv_idle_cnt  : 0,         sv_keep_cnt  : 0,         sv_retry_cnt : 0,         sv_rt_time   : 0,         sv_srt_time  : 0,         sv_t_rtt     : 0,         sv_t_rtseq   : 0,         sv_snd_qhead     : 1,         sv_snd_qtail     : 0,         sv_snd_msg_ary   : TCPMsgAryType           [0, 0, 0, 0, 0, 0, 0, 0],        sv_rcv_qhead     : 1,         sv_rcv_qtail     : 0,         sv_rcv_msg_ary   : TCPMsgAryType           [0, 0, 0, 0, 0, 0, 0, 0],        sv_tcpstat   : TCPStatType           [badsum: 0, badoff: 0, hdrop: 0,             badsegs: 0, unack: 0]];       {*** CONSTANTS FOR TESTING PURPOSE ***}        TCPNODELACK = 1;       {Ack immediately; no delay}            {These constants will be change to accomodate path stuffs}    OPEN_REQUEST             = REQUEST_IPATH;   GRACEFUL_RELEASE_REQUEST = GRACEFUL_REQUEST;    TIMER_INDICATION         = TIMER_RESPONSE;    U_RCV_REQUEST            = WSELECT_NOTIFICATION;    U_ACCEPT_CONNECT         = CONNECT_RESPONSE;    U_DELAY_ACCEPT           = CONNECT_TEMPRESPONSE;    RCV_RESPONSE             = SAT_BEAM;    ADJUST_PATHFLOW          = 13; {Not Implemented}        IPCINBOUNDIDX   = IPC * EHS_PER + EHIB_OFFSET;    IPOUTBOUNDIDX   = IP  * EHS_PER + EHOB_OFFSET;    TCPOUTBOUNDIDX  = TCP * EHS_PER + EHOB_OFFSET;           $SUBTITLE 'Global Variable Declaration', PAGE$      VAR          { *** TCP specific & global variables *** }     f_path_list_head: Int16;         {ptr to the free list   }      i_path_list_head: Int16;         {ptr to the i_path list }      d_path_list_head: Int16;         {ptr to the d_path list }      i_tcb_list_head : Int16;         {ptr to in_use tcb list }      f_tcb_list_head : Int16;         {ptr to free tcb list   }      ip_path_refr    : Int16;         {ptr to ip_path_ref     }      dst_ptr         : Int16;         {ptr to dst path rec tcp}          {Global variables}      tcp_done:       BOOLEAN;       {global control flag       }     tcpcksum:       BOOLEAN;       {tcp need chceksum flag    }     debug:          BOOLEAN;       {debug flag                }     expretxbackoff: BOOLEAN;       {use exp. backoff if true  }     timer_value: Int32;            {value for timer calls     }     panic_num:   Int16;            {Panic munber              }     tcp_error:   Int16;            {global error              }     tmr_err  :   Int16;            {global timer error word   }     portnumber:  Int16;            {port number               }     dataread:    Int16;            {number of bytes read user }     port_seed:   Int16;            {seed for port addr. alloc.}     tcpgbls:     TCPListBufType;   {Global configurations     }     sv:          StateVectorType;  {pcb local copy            }     dummyrefr:   ContextWords;     {Dummy Var for Event Log   }     tcp_port:    TCPPathRecType;   {port structure local copy }     temp_path:   TCPPathRecType;   {scratch pad for tcp path  }     opt_buf:     OptionBufType;    {TCP option buffer area    }     vdbuf:       VectoredDataType; {used for acquiring mbuf   }     rp_msg:      EventMessageType; {reply message buffer      }     search_key:  ConnIdType;       {key to search a PCB       }     inseghdr:    IPTCPHdrType;     {incoming seg header       }     reasshdr:    ReasHdrType;      {queued reassembly seg hdr }     null_ptr:    Int16;            {null address pointer      }      in_ptr:      Int16;            {ptr to incoming seg in dssm}        sb_ptr:      Int16;            {ptr to write socket buf    }        sb_ptr2:     Int16;            {ptr to read socket buf     }        sv_ptr:      Int16;            {ptr to sv in dssm          }        port_ptr:    Int16;            {ptr to active port struct  }        out_path:    Int16;            {Current active outbound path}       in_path :    Int16;            {Current active inbound path}        c_port_ptr:  Int16;            {ptr to call port struct    }        tcp_sb:      Int16;            {tcp's special sbuf id      }        tcp_wkmap:   Int16;            {working map var for mm     }        tcp_ierr:    Int16;            {parameter for critial call }           {Global parameter passed by caller}     inseg_len:   Int16;            {incoming segment length}       IMPLEMENT   END   .  