 $PASCAL '91790-1X204 REV.4010 <860403.1417>'  
$STANDARD_LEVEL 'HP1000'$  
 $HEAP 0   $HEAPPARMS OFF  $RECURSIVE OFF  $DEBUG  $PRIVATE_TYPES$   $RANGE OFF      { -----------------------------------------------------------         (c) COPYRIGHT HEWLETT PACKARD COMPANY 1986. ALL RIGHTS    RESERVED. NO PART OF THIS PROGRAM MAY BE PHOTOCOPIED,     REPRODUCED OR TRANSLATED TO ANOTHER PROGRAM LANGUAGE WITHOUT    THE PRIOR WRITTEN CONSENT OF THE HEWLETT-PACKARD COMPANY.          ----------------------------------------------------------- }        {}  	{     NAME : SOLIB 	 {   SOURCE : 91790-18204  	{    RELOC : NONE  	 {     PGMR : CWW  {    OWNER : CLC  {}          MODULE SOLIB;       !{                                                                } ! !{  SOLIB.PAS (IPC Socket Library & IPC Utilities)   <860403.1417>} ! !{                                                                } ! !{----------------------------------------------------------------} ! {  MODIFICATION HISTORY:  {  840208 jar Implement "import from .rels"   !{  860218 clc Make IpcSend and IpcRecv check to see if users have  ! {             set both vectored flags and offset option   {             (n339) SR# 033308   {             Include $RANGE OFF compiler directive (n339)  {             SR# 033789. Rev 2626.   !{  860225 lms Enhance error reporting/recovery from Enter Critical ! {              errors (n360). Rev 2626.   !{  860319 clc IPC opt array evaluation: don't flag zero opt array  ! {             value as error (n381) SR# 034074 Rev 2626.  #{  860324 clc Changed ENTITY_SIGMOD to ENTITY_SOLIB in SoAttemptToLog  # {             and added location constants.   {             (n381) SR# 34637 Rev 2626.  !{  860401 clc Added OTHERWISE clause to IpcCreate (n394) Rev 2626. ! {  860403 clc Delete SoAttemptToLog call (n400) Rev. 2626.  {}      !{----------------------------------------------------------------} ! !{                                                                } ! !{   IMPORTS                                                      } ! !{                                                                } ! !{----------------------------------------------------------------} !     IMPORT     $search 'phtm/BODEC.REL'$    bodec,     $search 'phtm/MMDEC.REL'$    mmdec,     $search 'phtm/SODEC.REL'$    sodec,     $search 'phtm/MMEXT.REL'$    ds_mm,     $search 'phtm/TRCMOD.REL'$   trcmod,      $search 'phtm/SIGMOD.REL'$   sigmod,      $search 'phtm/TMRDEC.REL'$   tmrdec,      $search 'phtm/TUSER.REL'$    tuser;      $PAGE   !{----------------------------------------------------------------} ! !{                                                                } ! !{   EXPORTS                                                      } ! !{                                                                } ! !{----------------------------------------------------------------} !     EXPORT      PROCEDURE IPCConnect $ALIAS 'IPCCONNECT'$          (       srcsd   : INTEGER;              dstsd   : INTEGER;          VAR flags   : FlagsType;          VAR opt     : OptType;          VAR vcsd    : INTEGER;          VAR result  : INTEGER     );       PROCEDURE IPCControl $ALIAS 'IPCCONTROL'$          (       anysd       : INTEGER;              request     : INTEGER;          VAR wrtdata     : DataType;             wlen        : INTEGER;          VAR readdata    : DataType;         VAR rlen        : INTEGER;          VAR flags       : FlagsType;          VAR result      : INTEGER    );      PROCEDURE IPCCreate $ALIAS 'IPCCREATE'$          (    socket_kind : INTEGER;          protocol    : INTEGER;      VAR flags       : FlagsType;      VAR opt         : OptType;      VAR sd          : INTEGER;      VAR result      : INTEGER  );       PROCEDURE IpcDest $ALIAS 'IPCDEST'$       (     socket_kind : INTEGER;    VAR location    : EnvironStringType;        loclen      : INTEGER;        protocol    : INTEGER;    VAR address     : EnvironStringType;        addrlen     : INTEGER;    VAR flags       : FlagsType;    VAR opt         : OptType;    VAR dstsd       : INTEGER;    VAR result      : INTEGER );      PROCEDURE IPCGet $ALIAS 'IPCGET'$      ( VAR give_name    : SocketNameType;            give_nlen    : INTEGER;       VAR flags        : FlagsType;       VAR sd           : INTEGER;       VAR result       : INTEGER     );      PROCEDURE IPCGive $ALIAS 'IPCGIVE'$          (     sd          : INTEGER;        VAR give_name   : SocketNameType;           give_nlen   : INTEGER;        VAR flags       : FlagsType;        VAR result      : INTEGER      );      PROCEDURE IPCLookUp $ALIAS 'IPCLookUp'$          ( VAR socket_name       : SocketNameType;           socket_nlen       : INTEGER;        VAR env_name          : EnvironStringType;            env_nlen          : INTEGER;        VAR flags             : FlagsType;        VAR destination_sd    : INTEGER;        VAR ret_protocol      : INTEGER;        VAR ret_socket_kind   : INTEGER;        VAR result            : INTEGER );       PROCEDURE IPCName $ALIAS 'IPCName'$          (     sd          : INTEGER;        VAR socket_name : SocketNameType;           socket_nlen : INTEGER;        VAR result      : INTEGER         );       PROCEDURE IPCNamErase  $ALIAS 'IpcNamErase'$     ( VAR name       : SocketNameType;            big_nlen   : INTEGER;       VAR result     : INTEGER  );       PROCEDURE IpcNodeName $ALIAS 'IpcNodeName'$      ( VAR nodename    : EnvironStringType;        VAR nodenamelen : INTEGER;        VAR result      : INTEGER );       PROCEDURE IPCRecv $ALIAS 'IpcRecv'$      (       vcsd     : INTEGER;         VAR data     : VectoredDataType;          VAR dlen     : INTEGER;         VAR flags    : FlagsType;         VAR opt      : OptType;         VAR result   : INTEGER    );           PROCEDURE IPCRecvCn $ALIAS 'IpcRecvCn'$          (        callsd   : INTEGER;           VAR vcsd     : INTEGER;           VAR flags    : FlagsType;           VAR opt      : OptType;           VAR result   : INTEGER      );      PROCEDURE IPCSelect $ALIAS 'IpcSelect'$          ( VAR soboundary : INTEGER;       VAR readmap    : BitMapType;        VAR writemap   : BitMapType;        VAR exceptmap  : BitMapType;            timeout    : INTEGER;       VAR result     : INTEGER   );      PROCEDURE IPCSend $ALIAS 'IpcSend'$      (       vcsd        : INTEGER;          VAR data        : VectoredDataType;             dlen        : INTEGER;          VAR flags       : FlagsType;          VAR opt         : OptType;          VAR result      : INTEGER    );      PROCEDURE IPCShutDown $ALIAS 'IpcShutDown'$          (        sd      : INTEGER;          VAR flags   : FlagsType;          VAR opt     : OptType;          VAR result  : INTEGER     );          $PAGE   !{----------------------------------------------------------------} ! !{                                                                } ! !{   IMPLEMENT PART                                               } ! !{                                                                } ! !{----------------------------------------------------------------} !     IMPLEMENT       VAR      callsocket           : SocketRecord;      emsg                 : EventMsgType;      mmflags              : MMFlagsType;     namerec              : NameRecord;      preamble             : PathPreambleRecord;      protorec             : ProtocolRecord;      rtsocket             : SocketRecord;      sbuf                 : SBufRecord;      socket               : SocketRecord;      urec                 : UserRecord;      vcsocket             : SocketRecord;      vdbuf                : VectoredDataType;       !{----------------------------------------------------------------} ! !{   FORWARD AND EXTERNAL DECLARATIONS                            } ! !{----------------------------------------------------------------} !     PROCEDURE AdrOf   
   ( VAR object  : Int16;  
 
         offset  : Int16;  
      VAR byteadr : Int16 ); EXTERNAL;       FUNCTION $DIRECT$ DS_Rsm_NextKey : Int16; EXTERNAL;       PROCEDURE DS_StoreUrec     ( VAR urecid : Int16;       VAR urec   : Int16); EXTERNAL;       FUNCTION $DIRECT$ Ior   
   ( VAR i : Int16;  
      VAR j : Int16 ): Int16; EXTERNAL;      FUNCTION MyIdAdd : Int16; EXTERNAL;       PROCEDURE RNRQ  $ALIAS 'RNRQ', NOABORT$      (     icon  : Int16;        VAR irn   : Int16;        VAR istat : Int16 ); EXTERNAL;       PROCEDURE Seek     (    bitmask   : SelBitMapType;          bitmap    : SelBitMapType;      VAR gsd       : Int16           );EXTERNAL;           $PAGE$  !{----------------------------------------------------------------} ! !{                                                                } ! !{   CUSTOMER CALLABLE SOCKET ROUTINES                            } ! !{                                                                } ! !{----------------------------------------------------------------} !         !{----------------------------------------------------------------} ! !{   IPC CONNECT                                  000             } ! !{----------------------------------------------------------------} !     
PROCEDURE IPCConnect 
        {       srcsd   : INTEGER;              dstsd   : INTEGER;          VAR flags   : FlagsType;          VAR opt     : OptType;          VAR vcsd    : INTEGER;          VAR result  : INTEGER     };       {}  { Abstract:   {  Memory allocation policy: The user can specify maximum   {  and/or minimum send and receive sizes in the opt array.  {  If the user defaults these values then we use 64 bytes   {  as a maximum value for each. We try to reserve enough  {  space to buffer three maximally-sized inbound and outbound   {  messages. The value three is somewhat arbitrary although   {  CNO says it accords well with performance data recorded  {  for LANs. High delay connections might perform better  {  with more buffer space reserved.   {   
{ Output parameters: 
 {   {  result: The following return values have been defined:   {   {     SUCCESSFUL            U_SOCKET_LIMIT_EXCEEDED   {     U_ILLEGAL_DESCRIPTOR  U_NO_MEMORY   {     U_ILLEGAL_FLAGS       U_ILLEGAL_OPTS  {     U_DOMAIN_MISMATCH     U_SOCKET_TYPE_MISMATCH  {     U_PROTOCOL_MISMATCH   U_NOT_A_CALL_SOCKET   {     U_NETWORK_IS_DOWN     U_NO_PATH_RECORDS   {     U_ADDRESS_VIOLATION   U_SYS_NO_SOCKETS  {}      LABEL 99, 100;      CONST          INFINITY   =  32767;       VAR      burstin     : AnyWordType;      burstout    : AnyWordType;      i           : Int16;      ierr        : Int16;      incc        : AnyWordType;      gsrcsd      : Int16;      gdstsd      : Int16;      gvcsd       : Int16;      lvcsd       : Int16;      m           : Int16;      mc          : Int16;      outcc       : AnyWordType;      sbufid      : Int16;      tempflags   : FlagsType;      urecid      : Int16;      wkmp        : Int16;       PROCEDURE Escape (     error_code : Int16 );     BEGIN     result := error_code;     GOTO 99;   
   END; {PROCEDURE Escape} 
     BEGIN   DS_EnterCritical ( wkmp, ierr );  IF (ierr <> SUCCESSFUL) THEN     BEGIN     result := U_NETWORK_IS_DOWN;      GOTO 100;  	   END; {IF ierr}  	     FindUserRecord (MyIdAdd,  urecid, urec, ierr );   IF (ierr <> SUCCESSFUL) THEN Escape ( ierr );       IF ((srcsd < 0) OR (srcsd > MAX_SOCKETS_PER_USER) OR      (dstsd < 0) OR (dstsd > MAX_SOCKETS_PER_USER)) THEN       Escape ( U_ILLEGAL_DESCRIPTOR );      gsrcsd := urec.ur_smap[srcsd];  %gdstsd := urec.ur_smap[dstsd] - DST_BOUNDARY; {map to mbufid immediately}  %     IF (gsrcsd < 1) THEN Escape (U_NOT_A_CALL_SOCKET);  IF (gdstsd < 1) THEN Escape (U_NOT_A_DST_SOCKET);       "IF ( urec.ur_sfree = NULL ) THEN Escape ( U_SOCKET_LIMIT_EXCEEDED ); "     
tempflags := flags;  
 tempflags.bits[MESSAGE_BIT] := FALSE;   tempflags.bits[CHECKSUM_BIT] := FALSE;  IF ( tempflags.int <> 0 ) THEN Escape ( U_ILLEGAL_FLAGS );      DS_SoFetchElement (gsrcsd, callsocket.int);   IF ( callsocket.so_b.kind <> CALL ) THEN      { Note that the following error is returned because the user    "   { is guaranteed to know about the socket because he/she owns it.  "    {}      Escape ( U_NOT_A_CALL_SOCKET );      IF ( callsocket.so_b.state = CALL_CLOSING_IN ) THEN      BEGIN     { The call socket was aborted by the lower level protocol.      { We inform our user of this with the expectation that the      { user will consequently shut down this call socket.      {}      Escape ( U_ABORTED_LOCALLY );     END; {IF callsocket}        { Dig out the protocol record for the protocol that will support   { this connection. We use the information in this record to   { see if all of the user-specified options are reasonable.  {}  DS_FetchElement ( DS_ProtosTD,                    callsocket.so_down_pid,                     protorec.int );       { Evaluate the opt array to see if the user passed in some  { requests for burst rates or maximum message sizes.  { Before looking at the opt array we set our burst rate   { and maximum message size parameters to default values.  { These may be overwritten.   {}  burstin.int := 1; {default max inbound messages}  burstout.int := 1; {default max outbound messages}  incc.int := protorec.pr_default_incc;   outcc.int := protorec.pr_default_outcc;   IF ((opt.opt_length <> 0) AND (opt.opt_num_entries <> 0)) THEN     BEGIN     EvaluateOpts ( opt, ierr );     IF (ierr <> SUCCESSFUL) THEN Escape ( ierr );         FOR i := 0 TO (opt.opt_num_entries - 1) DO         BEGIN         WITH opt.opt_entry[i] DO           BEGIN  
         CASE ent_code OF  
                 OPT_DUMMY: ; { ignore zero opt entries }                  OPT_MAXSNDSIZE:   
               BEGIN 
 #               IF (ent_length <> 2) THEN Escape (U_MSG_SIZE_OPT_ERR);  #                outcc.bytes[1] := opt.opt_byte[ent_offset];                 outcc.bytes[2] := opt.opt_byte[ent_offset+1];                 IF ((outcc.int > protorec.pr_maxmsglen) OR   #                   (outcc.int < 0)) THEN Escape (U_MSG_SIZE_OPT_ERR);  #                END; {OPT_MAXSNDSIZE case}                   OPT_MAXRCVSIZE:   
               BEGIN 
 #               IF (ent_length <> 2) THEN Escape (U_MSG_SIZE_OPT_ERR);  #                incc.bytes[1] := opt.opt_byte[ent_offset];                  incc.bytes[2] := opt.opt_byte[ent_offset+1];                  IF ((incc.int > protorec.pr_maxmsglen) OR  "                   (incc.int < 0)) THEN Escape (U_MSG_SIZE_OPT_ERR); " 
               END;  
                 OPT_MIN_BURSTIN:  
               BEGIN 
 $               IF (ent_length <> 2) THEN Escape (U_MSGS_QUEUED_OPT_ERR); $                burstin.bytes[1] := opt.opt_byte[ent_offset];                 burstin.bytes[2] := opt.opt_byte[ent_offset+1];  $               IF (burstin.int < 0) THEN Escape (U_MSGS_QUEUED_OPT_ERR); $                END; {OPT_MIN_BURSTIN opt}                   OPT_MIN_BURSTOUT:   
               BEGIN 
 $               IF (ent_length <> 2) THEN Escape (U_MSGS_QUEUED_OPT_ERR); $                burstout.bytes[1] := opt.opt_byte[ent_offset];                   burstout.bytes[2] := opt.opt_byte[ent_offset+1];    %               IF (burstout.int < 0) THEN Escape (U_MSGS_QUEUED_OPT_ERR);  %                END; {OPT_MIN_BURSTOUT case}                   OTHERWISE Escape ( U_ILLEGAL_OPTS);                   END; {CASE code}           END; {WITH opt_entry}  	      END; {FOR i} 	    END; {IF opt}      GetNewSocket ( VC, gvcsd, vcsocket, ierr );   IF ( ierr <> SUCCESSFUL ) THEN Escape ( ierr );   AttachSoToUser ( urec, gvcsd, lvcsd );  vcsocket.so_urecid := urecid;       InitSbufs ( gvcsd, VC, vcsocket,              burstin.int, incc.int,              burstout.int, outcc.int,  
            ierr );  
     IF ( ierr <> SUCCESSFUL ) THEN     BEGIN      { We couldn't get the memory that we needed. Our policy is to      { give up immediately, we don't wait for memory to become     { available. As an enhancement we might want to implement     { an option to allow waiting for memory.      {}      MakeSocketFree (gvcsd, vcsocket);  
   Escape ( U_NO_MEMORY ); 
 	   END; {IF ierr}  	     DS_StoreUrec (urecid, urec.int);  !InitSignals ( gvcsd, VC, protorec.pr_rnd, urec.ur_rnd, vcsocket);  !     vcsd := lvcsd;      { Initialize fields of the socket.  {}  WITH vcsocket DO     BEGIN  
   so_b.kind := VC;  
    so_k.max_burstout := burstout.int;      so_k.max_burstin  := burstin.int;     so_k.max_rcvcc := incc.int;     so_k.max_sndcc := outcc.int;      so_down_pid := callsocket.so_down_pid;      so_down_pathref := NULL;  {unknown for now}     so_namesptr := NULL;      so_giveptr := NULL;     so_b.state := VC_EMERGING;      so_timeout := protorec.pr_default_timeout;   
   so_down_cnt := 0; 
 	   so_up_cnt := 0; 	 
   so_final_up := 0; 
    so_f.int := 0;    {clear all flags}     so_f.msgmode := flags.bits[MESSAGE_BIT];      so_f.checksum := flags.bits[CHECKSUM_BIT];      END; { WITH }      DS_SoStoreElement ( gvcsd, vcsocket.int );      WITH emsg DO     BEGIN     em_event := CONNECT_REQUEST;      ehport := SREG * EHS_PER + EHOB_OFFSET;     emcr_up_pid := IPC;     emcr_up_ref := gvcsd;  
   emcr_dst_ref := gdstsd; 
    emcr_max_window := incc.int * burstin.int;      emcr_max_snds := burstin.int;     emcr_options.int := 0; {clear all bits}     emcr_options.bits[0] := vcsocket.so_f.msgmode;      emcr_options.bits[-1] := vcsocket.so_f.checksum;   
   END; {WITH emsg}  
     "{ In preparing our CONNECT_REQUEST event message we've manufactured  "  { a new reference to the path report to be used in building the     { d-path. We reference count path reports so that they won't be    !{ inadvertently destroyed before all references to them have been  ! #{ destroyed. Since our user could terminate or even shut down his/her  #  { destination descriptor before our CONNECT_REQUEST reaches the     { socket registry software in OUTPRO, we must increment our path   { report's reference count here.  {}  	mmflags.int := 0;  	 mmflags.bits[0] := TRUE;  #DS_MRead(preamble.int, PATH_PREAMBLE_SIZE, gdstsd, 0, mmflags, ierr);  # IF (ierr <> SUCCESSFUL) THEN Escape (U_INTERNALERR);      preamble.pa_ref_cnt := preamble.pa_ref_cnt + 1;   !DS_MBOverWrite(preamble.int, PATH_PREAMBLE_SIZE, gdstsd, 0, ierr); ! IF (ierr <> SUCCESSFUL) THEN Escape (U_INTERNALERR);      { Set up parameters for call to put the event message into  { DSAM. First we compute a data vector which describes our  { event message. Then we set up the options flags. We set    { flags to indicate that we only need to allocate enough memory    { to accomodate the event message and that we don't need to    { allocate an macct or any other overhead memory. We charge the    { emsg against the VC socket's outbound sbuf -- in this way we  !{ won't ever have to worry about not being able to get the memory  ! { we need for the event message.  {}  AdrOf ( emsg.int, 0, vdbuf[1] );  
vdbuf[2] := EMSG_BYTE_LEN; 
 sbufid := gvcsd + gvcsd;  	mmflags.int := 0;  	 
mmflags.bits[-1] := TRUE;  
 
mc := EMSG_BYTE_LEN; 
 DS_SBPut ( vdbuf, 4, sbufid, mmflags, m, mc, ierr);   IF (ierr <> SUCCESSFUL) THEN Escape ( U_INTERNALERR );      { Now that the message is in DSAM we are ready to append it to  { the outbound sbuf of the call socket. We set the memory    { manager option bits to indicate that we're queuing a complete    { message and not some message fragment.  {}  	mmflags.int := 0;  	 mmflags.bits[0] := TRUE;  
sbufid := gsrcsd + gsrcsd; 
 #DS_SBAppend ( sbufid, m, SBCTRLQ, INFINITY, INFINITY, mmflags, ierr ); # IF (ierr <> SUCCESSFUL) THEN Escape ( U_INTERNALERR );  result := SUCCESSFUL;       99:   BEGIN         DS_LeaveCritical (wkmp);        END; {99}       100:; {termination target for enter critical errors}  	END; {IpcConnect}  	     $PAGE   !{----------------------------------------------------------------} ! !{   IPC CONTROL                            100                   } ! !{----------------------------------------------------------------} !     
PROCEDURE IPCControl 
        {       anysd       : INTEGER;              request     : INTEGER;          VAR wrtdata     : VectoredDataType;             wlen        : INTEGER;          VAR readdata    : VectoredDataType;         VAR rlen        : INTEGER;          VAR flags       : FlagsType;          VAR result      : INTEGER    };      {}  { Abstract:   #{     The IPCControl intrinsic is used to perform special requests on  # %{     sockets. A request can include receiving information about a socket. % {     The currently defined control functions are as follows:   {   !{     ASYNCH_ENABLE: Enable unblocked ( asynchronous) I/O for the  ! {        specified socket or connection.  {   {     ASYNCH_DISABLE: Enable blocked (synchronous) I/O for the  {        specified socket or connection.  {   {     TIMEOUT_RESET: Change the default timeout for blocked   {        requests. The first two bytes of wrtdata will contain  {        the value in tenths of seconds.  {   
{ Input parameters:  
 {   %{     anysd: The socket descriptor for the socket upon which the specified % {        operation is to be performed.  {   {     request: Defines the operation that is to be performed.   {   ${     wrtdata: An array which is used to designate input data. The array $ {        may contain either literal data or a data vector.  {   {     wlen: Byte length of the input data.  {   &{     rlen: Maximum byte length of the amount of data the caller is willing  & 
{        to receive. 
 {   {     flags: Currently defined flags are as follows:  {   ${        flags[VECTORED]: Indicates that input and/or output data is to  $ {           be scattered/gathered.  {   
{ Output parameters: 
 {   #{     readdata: Either the array into which any returned data is to be # ${        placed or a data vector which describes where returned data is  $ 
{        to be scattered.  
 {   "{     result: The resultant error code. Currently defined values are " 
{        as follows: 
 {   {        SUCCESSFUL            U_NOT_A_VC_SOCKET  {        U_ILLEGAL_FLAGS       U_ILLEGAL_DESCRIPTOR   {        U_ILLEGAL_REQUEST     U_ILLEGAL_OPTS   {        U_ADDRESS_VIOLATION  {}      !{  NOTES: need to add read and write select options to modify the  !  {  values for read and write thresholds. Need to validate these    !{  values so that user can't specify one which is too large, i.e., !  {  before calling SBWaitMem with them in the actual IPCSelect()     {  call. Should call MBSAvail & compare output with maxmsg size    
{  & user specified value. 
 {}          LABEL 99, 100;      CONST   
   ASYNCH_ENABLE      = 1; 
 
   ASYNCH_DISABLE     = 2; 
 
   TIMEOUT_RESET      = 3; 
    SET_RDTHRESH       = 1000;      SET_WRTHRESH       = 1001;           VAR      flagscopy    : FlagsType;     gsd          : Int16;     i            : Int16;     ierr         : Int16;     sbufid       : Int16;     temp_flags   : FlagsType;     temp_dlen    : Int16;     urecid       : Int16;     wkmp         : Int16;         PROCEDURE Escape (     error_code : Int16 );         BEGIN         result := error_code;         GOTO 99;  
      END; {Escape}  
         BEGIN   result := SUCCESSFUL; {assume}  DS_EnterCritical ( wkmp, ierr );  IF (ierr <> SUCCESSFUL) THEN     BEGIN     result := U_NETWORK_IS_DOWN;      GOTO 100;  	   END; {IF ierr}  	     FindUserRecord (MyIdAdd,  urecid, urec, ierr );   IF (ierr <> SUCCESSFUL) THEN Escape ( ierr );       IF ((anysd < 0) OR (anysd > MAX_SOCKETS_PER_USER)) THEN      Escape ( U_ILLEGAL_DESCRIPTOR );       gsd := urec.ur_smap[anysd];   IF (gsd <= NULL) THEN Escape ( U_ILLEGAL_DESCRIPTOR );      IF (gsd > DST_BOUNDARY) THEN Escape ( U_ILLEGAL_DESCRIPTOR);      
flagscopy := flags;  
 flagscopy.bit[VECTORED_BIT] := FALSE;   IF ( flagscopy.int <> 0 ) THEN  Escape ( U_ILLEGAL_FLAGS );       DS_SoFetchElement ( gsd, socket.int);       CASE request OF       	   ASYNCH_ENABLE:  	       BEGIN         socket.so_f.asynchmode := TRUE;         DS_SoStoreElement ( gsd, socket.int );        END; { ASYNCH_ENABLE case }       	   ASYNCH_DISABLE: 	       BEGIN         socket.so_f.asynchmode := FALSE;        DS_SoStoreElement ( gsd, socket.int );        END;      	   TIMEOUT_RESET:  	       BEGIN         IF (wlen <> 2) THEN Escape (U_BAD_LENGTH);        IF ( wrtdata.int < 0 ) THEN            Escape ( U_ILLEGAL_TIMEOUT );        socket.so_timeout := wrtdata.int;         DS_SoStoreElement ( gsd, socket.int );        END; { TIMEOUT_RESET case }          SET_RDTHRESH:        BEGIN   !      { The caller has requested that we change the read threshold ! !      { on one of his sockets. After changing the threshold -- its ! !      { stored in the socket's outbound sbuf -- we must recompute  ! !      { the value of the DATA_READABLE bit in the socket's signal  ! "      { record. We do this so that the next time the socket's owner  " !      { invokes IpcSelect to read-select on the socket he/she will ! #      { be returned the proper results. We rely on the memory manager  # "      { routine DS_SBCheckRdAD() to recompute the DATA_READABLE bit  " "      { value. DS_SBCheckRdAD() will set the bit from TRUE to FALSE  "        { if its actual value should be FALSE. DS_SBCheckRdAD() is   "      { smart enough to consider whether a message is queued on the  "       { socket.         {}        IF (wlen <> 2) THEN Escape(U_BAD_LENGTH);         IF (wrtdata.int <= 0) THEN Escape (U_ILLEGAL_RDTHRESH);         sbufid := gsd + gsd - 1; {descriptor to inbound sbuf}         DS_SBFetchElement (sbufid, sbuf.int);   
      WITH socket, sbuf DO 
          BEGIN           sb_rdthresh := wrtdata.int;           sb_newcc := sb_cc;            so_usersig.er_flags[DATA_READABLE] := TRUE;           END; {WITH socket}         DS_SBStoreElement (sbufid, sbuf.int);         DS_SoStoreElement (gsd, socket.int);        DS_SBCheckRdAD (sbufid, SBDATAQ);         END; {SET_RDTHRESH case}         SET_WRTHRESH:        BEGIN         IF (wlen <> 2) THEN Escape(U_BAD_LENGTH);         IF (wrtdata.int <= 0) THEN Escape(U_ILLEGAL_WRTHRESH);        sbufid := gsd + gsd; {descriptor to outbound sbuf}        DS_SBMBufsNeeded (sbufid, wrtdata.int, temp_dlen, ierr);        DS_SBFetchElement (sbufid, sbuf.int);   
      WITH socket, sbuf DO 
          BEGIN           sb_wrthresh := temp_dlen;           sb_dropcc := sb_mbfree - RSVDMBUFS;  #         so_usersig.er_flags[WRITEABLE] := (sb_dropcc >= sb_wrthresh); #          END; {WITH socket}         DS_SBStoreElement (sbufid, sbuf.int);         DS_SoStoreElement (gsd, socket.int);  
      END; {SET_WRTHRESH}  
        OTHERWISE Escape (U_ILLEGAL_REQUEST);         END; { CASE request OF }       99:   BEGIN         DS_LeaveCritical ( wkmp );        END; {99}       100:; {target for enter critical errors}  	END; {IPCControl}  	     !{----------------------------------------------------------------} ! !{    IPC CREATE                                  200             } ! !{----------------------------------------------------------------} !     
PROCEDURE IPCCreate  
        {    socket_kind : INTEGER;          protocol    : INTEGER;      VAR flags       : FlagsType;      VAR opt         : OptType;      VAR sd          : INTEGER;      VAR result      : INTEGER  };       {}  { Abstract:    {     Tests are made to verify that the parameters specified by    {     the user are valid. If all the parameters check out the   {     IPCCreate() attempts to allocate a socket structure and   !{     resource limits for the socket. If no socket structures are  ! {     available or if insufficient resources are available for  !{     support of the socket then the call fails and an appropriate ! {     result value is returned.   {   
{ Output parameters: 
 {   {     result: The status of the call. Possible results are the  
{         following: 
 {   {         SUCCESSFUL                   U_ILLEGAL_FLAGS  {         U_ILLEGAL_DOMAIN             U_ILLEGAL_OPTS   {         U_ILLEGAL_SOCKET_TYPE        U_SOCKET_LIMIT_EXCEEDED  {         U_ILLEGAL_PROTOCOL           U_NO_PATH_RECORDS  {         U_ADDRESS_VIOLATION          U_NO_DEFAULT_PROTOCOL  {         U_PROTOCOL_SOCKET_MISMATCH   U_NETWORK_IS_DOWN  {         U_DOMAIN_PROTOCOL_MISMATCH   U_NO_MEMORY  {         U_INTERNALERR   {}      LABEL 99, 100;      CONST   "   MAX_BURST_IN     = 10; {max messages we permit a user to specify  "                            as inbound queue limit }   !   MAX_BURST_OUT    = 10; {max messages we permist user to specify !                            as outbound queue limit}       VAR      burstin     : AnyWordType;      burstout    : AnyWordType;      gsd         : Int16;      i           : Int16;      ierr        : Int16;      incc        : AnyWordType;      j           : Int16;      lsd         : Int16;      m           : Int16;   $   maxvcs      : AnyWordType; {max connect requests that can be queued}  $    mc          : Int16;      outcc       : AnyWordType;      pid         : Int16;      rootgsd     : Int16;      sbufid      : Int16;      sock_kind   : Int16;      tcpport     : AnyWordType;      temp        : Int16;      urecid      : Int16;      wkmp        : Int16;       PROCEDURE Escape (     error_code : Int16 );     BEGIN     result := error_code;     GOTO 99;   
   END; {PROCEDURE Escape} 
         BEGIN   DS_EnterCritical ( wkmp, ierr );  IF (ierr <> SUCCESSFUL) THEN     BEGIN     result := U_NETWORK_IS_DOWN;      GOTO 100;  	   END; {IF ierr}  	     FindUserRecord (MyIdAdd,  urecid, urec, ierr );   IF (ierr <> SUCCESSFUL) THEN Escape (ierr);       IF (flags.int <> 0) THEN Escape ( U_ILLEGAL_FLAGS );       IF (urec.ur_sfree = NULL) THEN Escape (U_SOCKET_LIMIT_EXCEEDED);       
sock_kind := socket_kind;  
 IF (sock_kind = DEFAULT) THEN sock_kind := CALL;  IF (sock_kind <> CALL) THEN      Escape ( U_ILLEGAL_SOCKET_TYPE );      pid := protocol;  
IF ( pid = DEFAULT ) THEN  
    BEGIN  
   CASE sock_kind OF 
       CALL:     pid := TCP; {might want NBS too}        OTHERWISE            Escape ( U_NO_DEFAULT_PROTOCOL );  	      END; {CASE}  	    END  ELSE     BEGIN     { Verify that the user specified a valid protocol -- so     { far only TCP is valid.      {}      IF ( pid <> TCP ) THEN Escape ( U_ILLEGAL_PROTOCOL );  
   END; {IF pid = DEFAULT} 
     DS_FetchElement ( DS_ProtosTD, pid, protorec.int );       IF ( NOT protorec.pr_services.bits[sock_kind] ) THEN     Escape ( U_PROTOCOL_SOCKET_MISMATCH );       {}  { Set default queue and message size limits. These values   { might be modified once we process the options that the  { user specified. Assume for now that the caller is not   { going to be providing a path report describing how the  { call socket should be bound to the lower level protocol.  {}  	burstin.int := 1;  	 	burstout.int := 1; 	 incc.int  := 64; {default max inbound message size}   outcc.int := 64;  maxvcs.int := 3; {default number of queued connect requests}  tcpport.int := MEANINGLESS;   emsg.emri_path_len := 0;      IF (opt.opt_length <> 0) THEN      BEGIN     EvaluateOpts ( opt, ierr );     IF (ierr <> SUCCESSFUL) THEN Escape (ierr);         FOR i := 0 TO (opt.opt_num_entries - 1) DO         BEGIN         WITH opt.opt_entry[i] DO           BEGIN  
         CASE ent_code OF  
                 OPT_DUMMY: ; { ignore zero opt entries }                  OPT_MAXDGMSGSIZE:   
               BEGIN 
 !               { This option won't be supported until IPC datagram !                { sockets are supported.   	               {}  	                Escape(U_ILLEGAL_OPTS);      "               { IF (ent_length <> 2) THEN Escape (U_ILLEGAL_OPTS);  "                { outcc.bytes[1] := opt.opt_byte[ent_offset];                 { outcc.bytes[2] := opt.opt_byte[ent_offset+1];                 { incc := outcc;                   { IF (incc.int < 0) THEN Escape (U_ILLEGAL_OPTS);                  { IF (incc.int > protorec.pr_maxmsglen) THEN                  {    Escape (U_MSG_SIZE_TOO_BIG);  	               {}  	                END; {OPT_MAXDGMSGSIZE case}                   OPT_MAXCONREQSQD:   
               BEGIN 
 #               IF (ent_length <> 2) THEN Escape(U_CONNECT_Q_OPT_ERR);  #                maxvcs.bytes[1] := opt.opt_byte[ent_offset];                  maxvcs.bytes[2] := opt.opt_byte[ent_offset +1];  #               IF ((maxvcs.int < 0) OR (maxvcs.int > MAX_VCS_QED))THEN #                   Escape (U_CONNECT_Q_OPT_ERR);                  END; {OPT_MAXCONREQSQD case}                   OPT_MAX_DGS_QED_IN:   
               BEGIN 
 #               { This option won't be supported until datagram sockets #                { are supported.   	               {}  	                Escape (U_ILLEGAL_OPTS);       "               { IF (ent_length <> 2) THEN Escape (U_ILLEGAL_OPTS);  "                { burstin.bytes[1] := opt.opt_byte[ent_offset];                  { burstin.bytes[2] := opt.opt_byte[ent_offset+1];   &               { IF ((burstin.int < 0) OR (burstin.int > MAX_BURST_IN))THEN  &                {    Escape (U_ILLEGAL_OPTS);  	               {}  	                END; {OPT_MAX_DGS_QED_IN}                      OPT_MAX_DGS_QED_OUT:  
               BEGIN 
 #               { This option won't be supported until datagram sockets #                { are supported.   	               {}  	                Escape (U_ILLEGAL_OPTS);       "               { IF (ent_length <> 2) THEN Escape (U_ILLEGAL_OPTS);  "                 { burstout.bytes[1] := opt.opt_byte[ent_offset];    !               { burstout.bytes[2] := opt.opt_byte[ent_offset+1];  !                { IF ((burstout.int < 0) OR                 {    (burstout.int > MAX_BURST_IN)) THEN                  {     Escape (U_ILLEGAL_OPTS);   	               {}  	                END; {OPT_MAX_DGS_QED_OUT}                   OPT_PATH_REPORT:  
               BEGIN 
                { This option not supported yet.   	               {}  	                Escape ( U_ILLEGAL_OPTS );                  END; {OPT_PATH_REPORT}       
            OPT_TCP_PORT:  
 
               BEGIN 
 %               { Option used by those desiring to be bound to a particular % 
               { TCP port. 
 	               {}  	                 IF (ent_length <> 2) THEN Escape(U_ILLEGAL_OPTS);                  tcpport.bytes[1] := opt.opt_byte[ent_offset];                 tcpport.bytes[2] := opt.opt_byte[ent_offset+1];                 END; {OPT_TCP_PORT}                  OTHERWISE                  Escape (U_ILLEGAL_OPTS);                   END; {CASE entry}   
         END; {WITH} 
 	      END; {FOR i} 	    END; {IF opt.opt_length}              { Now try to allocate a socket and attach it to the     { caller's user record. If no sockets are available     { we must fail the request. Note that up to this point      { we haven't allocated any resources.     {}      GetNewSocket ( sock_kind, gsd, socket, ierr );      IF ( ierr <> SUCCESSFUL ) THEN Escape ( ierr );     AttachSoToUser ( urec, gsd, lsd );      socket.so_urecid := urecid;          { Resources are now allocated. Should we find it necessary to   #   { fail the user's request hereafter we must return these resources. #    {  "   { NOTE: When initializing sbufs on IPCCreate() call we should be  " !   { willing to wait for some finite interval to get memory since  !     { the majority of the systems "general pool" memory could be        { taken up by temporary usages. Frank has good algorithm that   
   { he worked out.  
    {}          InitSbufs ( gsd, sock_kind, socket,                 burstin.int,  incc.int,                 burstout.int, outcc.int,                  ierr );         IF (ierr <> SUCCESSFUL) THEN         BEGIN         { We allocate enough memory to the socket to satisfy our        { caller's needs. Rather than attempting to wait for         { memory we return the socket record to the free pool and          { return an error to the caller.        {}        MakeSocketFree (gsd, socket);         Escape ( U_NO_MEMORY );   
      END; {IF ierr} 
 $   InitSignals ( gsd, sock_kind, protorec.pr_rnd, urec.ur_rnd, socket);  $     	   WITH socket DO  	       BEGIN   
      so_urecid := urecid; 
       so_b.kind := sock_kind;         so_down_pathref := NULL;  
      so_down_pid := pid;  
 
      so_namesptr := NULL; 
 
      so_giveptr := NULL;  
       CASE sock_kind OF            CALL:  	            BEGIN  	             so_b.state := CALL_BOUND;               so_k.max_vc_backlog := 3; {default}               so_k.vcs_queued := 0;               so_k.vcq := NULL;               END; {CALL case}  	         OTHERWISE 	 	            BEGIN  	 "            { This shouldn't be possible, as we already verified our " #              socket kind to be CALL before we entered this routine }  #             MakeSocketFree (gsd,socket);              Escape (U_INTERNALERR);               END;        END; {  CASE  }         so_timeout := protorec.pr_default_timeout;      "      { The so_down_cnt setting is done to reflect the REQUEST_IPATH "        { emsg that we'll be sending down on the root socket. The          { emsg will reference our call socket.        {}        so_down_cnt := 1;         so_up_cnt := 0;         so_final_up := 0;         so_f.asynchmode := FALSE;         so_f.deferred_give := FALSE;        END; {  WITH  }          DS_StoreUrec ( urecid, urec.int );      DS_SoStoreElement ( gsd, socket.int );      rootgsd := urec.ur_smap[0];     DS_SoFetchElement ( rootgsd, rtsocket.int );           { Prepare a REQUEST_IPATH event message and send it, via the       { user's root socket, to the serving protocol's     { event handler. Fields relating to the accompanying path     { report were initialized earlier.      {}      WITH emsg DO         BEGIN         {}        { Compute a zero-based event handler port number.         {}        ehport := pid * EHS_PER + EHOB_OFFSET;        em_event := REQUEST_IPATH;  
      emri_up_pid := IPC;  
 
      emri_up_ref := gsd;  
 
      emri_flags.int := 0; 
       emri_root_ref := rootgsd;         emri_root_pid := IPC;             { If our caller requested to be bound to a particular         { TCP port then we pass the necessary information along.        {}        IF (tcpport.int <> MEANINGLESS) THEN           BEGIN           emri_flags.bits[0] := TRUE;           emri_path_len := 2;           emri_path_report := tcpport.int;   
         END; {IF tcpport} 
       END; {WITH emsg}         SoQuery ( rootgsd, rtsocket, emsg, EMSG_BYTE_LEN,               wkmp, urec.ur_rn, ierr );     IF ierr <> SUCCESSFUL THEN         BEGIN    { SoQuery Error }         { Note we are no longer critical if SoQuery has an error }         result := ierr;         GOTO 100;         END;     { SoQuery Error }         DS_SoStoreElement ( rootgsd, rtsocket.int );          IF (emsg.em_event = CONFIRM_IPATH) THEN        BEGIN         sd := lsd;        result := SUCCESSFUL;         END      ELSE         BEGIN         IF (emsg.em_event = IPATH_ABORTED) THEN            BEGIN           result := emsg.emai_reason            END        ELSE           BEGIN           result := U_INTERNALERR;            END; {IF emsg.em_event = IPATH}        DS_SoFetchElement ( gsd, socket.int );  !      { We want to return the call socket to the free pool because ! "      { it can't be supported for some reason. We unlink the socket  "        { from the user's user record and then we return it to the   	      { free pool. 	       {}        DS_UrFetchElement (urecid, urec.int);         urec.ur_smap[lsd] := - urec.ur_sfree;         urec.ur_sfree := lsd;         DS_UrStoreElement (urecid, urec.int);         MakeSocketFree (gsd, socket);   
      END; {IF ierr} 
     99:   BEGIN         DS_LeaveCritical ( wkmp );        END; {99}       100:; {termination target for failed DS_EnterCritical calls}  END; {IPCCreate}      $PAGE    {--------------------------------------------------------------}    {   IPC DEST                                  300              }    {--------------------------------------------------------------}       	PROCEDURE IpcDest  	     {     socket_kind : INTEGER;    VAR location    : EnvironStringType;        loclen      : INTEGER;        protocol    : INTEGER;    VAR address     : EnvironStringType;        addrlen     : INTEGER;    VAR flags       : FlagsType;    VAR opt         : OptType;    VAR dstsd       : INTEGER;    VAR result      : INTEGER  };       {}  { Abstract:   {  Accepts information about a remote connect-site and  {  uses it in an attempt to build a path report. If successful  {  the path report is stored in DSAM, and a destination   {  descriptor is returned to the user.  {   
{ Input parameters:  
 {   {  flags: No flags are currently supported. It is doubtful  {     whether we will ever support the MULTICAST, DEST, and   {     DUP_DEST flags described in the HPDSN IPC specification.  {   {  opt: Users may supply a path report as an opt array option.  {     No attempt is made to evaluate the opt array as part of   {     the IpcDest() processing. The path report will only be  {     evaluated when/if the user tries to connect to the site   {     referenced by the path report, e.g., with an IpcConnect.  {}      LABEL 99, 100;      VAR      ierr        : Int16;      i           : Int16;      gsd         : Int16;      lookuprec   : LookUpRecord;     mbufid      : Int16;      mc          : Int16;      mmflags     : MMFlagsType;      pid         : Int16;      lsd         : Int16;      pathsb      : Int16;      rootgsd     : Int16;      rtsocket    : SocketRecord;     sbufid      : Int16;      temp        : Int16;      urecid      : Int16;      wkmp        : Int16;          PROCEDURE Escape ( ierr : Int16 );         BEGIN         result := ierr;         GOTO 99;  
      END; {Escape}  
     BEGIN   DS_EnterCritical ( wkmp, ierr );  IF (ierr <> SUCCESSFUL) THEN     BEGIN     result := U_NETWORK_IS_DOWN;      GOTO 100;  	   END; {IF ierr}  	     FindUserRecord (MyIdAdd,  urecid, urec, ierr );   IF (ierr <> SUCCESSFUL) THEN Escape ( ierr );       { If the user doesn't have any local socket descriptors then  { we must fail the request.   {}  "IF ( urec.ur_sfree = NULL ) THEN Escape ( U_SOCKET_LIMIT_EXCEEDED);  "     
IF (loclen < 0) THEN 
    BEGIN     Escape ( U_BAD_LENGTH );      END  
ELSE IF (loclen = 0) THEN  
    BEGIN     { The user should have provided a path report in the      { opt array. If no report was provided we return an error.      { If a report was provided we attempt to store it in      { DSAM, charging the required memory against the special      { system path report socket.      {}       IF ( opt.opt_length = 0 ) THEN Escape ( U_ILLEGAL_REQUEST );           EvaluateOpts ( opt, ierr );     IF ( ierr <> SUCCESSFUL ) THEN Escape ( ierr );         { Currently only the path report option is supported.     {}   !   IF ( opt.opt_num_entries <> 1 ) THEN Escape ( U_ILLEGAL_OPTS ); !        WITH opt.opt_entry[0] DO         BEGIN   #      IF ( ent_code <> OPT_PATH_REPORT ) THEN Escape (U_ILLEGAL_OPTS); #           { The user provided a path report which we must try to         { store into DSAM. First we make sure the length specified         { for the report is reasonable.         {}  #      IF ((ent_length <= 0) OR (ent_length > MAX_PATHREP_BYTES)) THEN  #          BEGIN           Escape ( U_ILLEGAL_OPTS );            END; {IF ent_length}       %      SoChargePath ( urecid, opt.opt_ints[ent_offset DIV 2], gsd, ierr );  %       IF (ierr <> SUCCESSFUL) THEN Escape (ierr);       !      { Put the returned descriptor into the caller's user record. !        { Notice that we'll be returning a local descriptor to the         { user.         {}        AttachSoToUser ( urec, gsd, lsd );        DS_StoreUrec ( urecid, urec.int );            dstsd := lsd; {type conversion}         result := SUCCESSFUL;             END; {WITH opt.opt_entry}      END  ELSE IF (loclen > MAX_ENVIRON_NAMELEN) THEN      BEGIN     Escape (U_ILLEGAL_NODE_NAME);     END  	ELSE {loclen > 0}  	    BEGIN     { The user should have provided an ASCII string naming the      { node he/she wishes to communicate with. In addition a     { protocol and protocol address should have been specified.     { All these parameters should be evaluated.     {}      pid := protocol; {convert to Int16}     CASE pid OF            TCP:           BEGIN           IF ( addrlen <> 2) THEN Escape ( U_ILLEGAL_ADDR );            END; {TCP case}            OTHERWISE Escape ( U_ILLEGAL_PROTOCOL );        END; {CASE pid}          { We now prepare a QUERY_REQUEST emsg to send down to the      { SocketRegistry's outbound protocol handler. This emsg will       { serve a function much like the one used by IpcLookUp().     { Both emsgs reference mbufs.  IpcLookUp()'s mbuf contains       { a LookUpRecord, a socket name, and a node name; IpcDest()'s   #   { emsg will contain a "protocol element" instead of a socket name.  # "   { The protocol element will be formatted just as the path report  "     { protocol elements are. We use the namerec scratch record to      { provide space for constructing the protocol element.      {}      WITH lookuprec, namerec DO         BEGIN         nr_name.bytes[1] := pid;  "      nr_name.bytes[2] := 4;  {assumes TCP element with service map} " #      nr_name.ints[2] := 0; {zero service map --  this may not be best #                              default}         nr_name.ints[3] :=  address.int;      
      lu_urecid := urecid; 
       { We send down the length of the PID and the address.         {}        lu_socket_nlen := 6; {length of TCP element in bytes}         lu_env_nlen := loclen;             { Put the LookUpRecord along with the protocol element and         { node name into DSAM. Charge the mbuf against         { the user's root socket. The reference to the root socket         { should be placed in the QUERY_REQUEST emsg.         {}        AdrOf (lookuprec.int, 0, vdbuf[1]);         vdbuf[2] := LOOKUPREC_SIZE;         AdrOf (nr_name.int, 0, vdbuf[3]);   
      vdbuf[4] := 6; 
       AdrOf (location.int, 0, vdbuf[5]);  
      vdbuf[6] := loclen;  
           rootgsd := urec.ur_smap[0];         sbufid := rootgsd + rootgsd;      !      { Now we try to put the lookup record into DSAM. We set the  ! "      { DS_SBPut() option flags to indicate that we only need enough " !      { memory to accomodate the event messsage and that we don't  !        { need to allocate an macct or any other overhead memory.          {}        mmflags.int := 0;         mmflags.bits[-1] := TRUE;         mc := LOOKUPREC_SIZE + lu_socket_nlen + lu_env_nlen;  	      temp := mc;  	       DS_SBPut (vdbuf, 16, sbufid, mmflags, mbufid, mc, ierr);        IF (ierr <> SUCCESSFUL) THEN Escape(U_INTERNALERR);         END; {WITH lookuprec}          WITH emsg DO         BEGIN         ehport := SREG * EHS_PER + EHOB_OFFSET;         em_event := QUERY_REQUEST;  
      emqrq_up_pid := IPC; 
       emqrq_up_ref := rootgsd;        emqrq_down_ref := MEANINGLESS;        emqrq_mbufid := mbufid;   
      emqrq_dlen := temp;  
       emqrq_seq_num := MEANINGLESS;         emqrq_options.int := 0;   #      emqrq_options.bits[0] := TRUE; {says this is IpcDest() request}  #       END; {WITH emsg}         DS_SoFetchElement (rootgsd, rtsocket.int);      SoQuery (rootgsd, rtsocket, emsg, EMSG_BYTE_LEN, wkmp,               urec.ur_rn, ierr );      IF (ierr <> SUCCESSFUL) THEN         BEGIN    { SoQuery Error }         { Note we are no longer critical if SoQuery has an error }         result := ierr;         GOTO 100;         END;     { SoQuery Error }         DS_SoStoreElement (rootgsd, rtsocket.int);          result := emsg.emqc_result;     dstsd := emsg.emqc_mbufid;       
   END; {IF loclen}  
     99:   BEGIN         DS_LeaveCritical ( wkmp );        END; {99}       100:; {termination target for failed DS_EnterCritical calls}      END; {IpcDest}      $PAGE    {--------------------------------------------------------------}    {   IPC GET                                  400               }    {--------------------------------------------------------------}       PROCEDURE IPCGet     { VAR give_name    : SocketNameType;            give_nlen    : INTEGER;       VAR flags        : FlagsType;       VAR sd           : INTEGER;       VAR result       : INTEGER     };      {}  { Abstract:   {   
{ Input parameters:  
 {   ${     give_name: The name of the socket that the user wishes to acquire. $ {   {     give_nlen: The number of characters in give_name.   {   
{ Output parameters: 
 {   #{  sd: The socket descriptor for the socket that the give_name names.  # {   {  result: Resultant error code. Currently defined values are:  {   {     SUCCESSFUL             U_ILLEGAL_FLAGS  {     U_ILLEGAL_NAME_LENGTH   {     U_NAME_NOT_FOUND  {}      LABEL 99, 100;      VAR      i          : Int16;     ierr       : Int16;     gsd        : Int16;  {global socket descriptor}     lsd        : Int16;  {local socket descriptor}      namerecid  : Int16;     nlen       : Int16;     urecid     : Int16;     wkmp       : Int16;      PROCEDURE Escape (  error_code : Int16 );      BEGIN     result := error_code;     GOTO 99;   
   END; {PROCEDURE Escape} 
         BEGIN {IPCGet}  DS_EnterCritical (wkmp, ierr);  IF (ierr <> SUCCESSFUL) THEN     BEGIN     result := U_NETWORK_IS_DOWN;      GOTO 100;  	   END; {IF ierr}  	         nlen := give_nlen; {type coercion from Int32 to Int16}  IF ((nlen < 1) OR (nlen > MAX_SOCKET_NAMELEN)) THEN      Escape (U_ILLEGAL_NAME_LENGTH);      IF (flags.int <> 0) THEN Escape(U_ILLEGAL_FLAGS);       FindUserRecord (MyIdAdd,  urecid, urec, ierr );   IF (ierr <> SUCCESSFUL) THEN Escape (ierr);       HashFind ( TRUE, give_name, nlen, namerecid, ierr);   IF (ierr <> SUCCESSFUL ) THEN Escape ( U_NAME_NOT_FOUND );      { Try to get local socket descriptor that user can use to   { refer to retrieved socket.  {}  !IF (urec.ur_sfree = NULL ) THEN Escape (U_SOCKET_LIMIT_EXCEEDED);  !     lsd := urec.ur_sfree;   urec.ur_sfree := - urec.ur_smap[lsd];   sd := lsd;      DS_FetchElement ( DS_NamesTD, namerecid, namerec.int );   
gsd := namerec.nr_socketd; 
 
urec.ur_smap[lsd] := gsd;  
 DS_StoreUrec ( urecid, urec.int );      { We must unlink the obtained object from the user record   { of the user that gave it away.  {}  IF (gsd < DST_BOUNDARY) THEN     BEGIN     { The user will be getting a socket and not a path report.      {}      DS_SoFetchElement ( gsd, socket.int );      { Update the socket to reflect the fact that it has a new     { owner.      {}      i := urecid;      urecid := socket.so_urecid;  
   socket.so_urecid := i;  
         { Must insert new Resource Number Descriptor (RND) so signals      { occurring on this socket will be sent to the proper user.     {}      socket.so_b.userrnd := urec.ur_rnd;     DS_UrFetchElement ( urecid, urec.int );     UnlinkSocketFromUser ( gsd, socket, urec );     NameFromSocket ( namerecid, namerec, socket );      DS_SoStoreElement ( gsd, socket.int );      END  ELSE     BEGIN     { Obtained object is a path report. Find out which user     { currently owns the path report. Unlink the report     { from that user. Also unlink the give name record from     { the path and return it to the free pool.      {}   
   mmflags.int := 0; 
    mmflags.bits[0] := TRUE;      gsd := gsd - DST_BOUNDARY;   #   DS_MRead (preamble.int, PATH_PREAMBLE_SIZE, gsd, 0, mmflags, ierr); #    IF (ierr <> SUCCESSFUL) THEN Escape ( U_INTERNALERR );          urecid := preamble.pa_urecid;     DS_UrFetchElement ( urecid, urec.int );     UnlinkPathFromUser ( gsd, preamble, urec );     NameFromPath ( namerecid, namerec, preamble );   "   DS_MBOverWrite (preamble.int, PATH_PREAMBLE_SIZE, gsd, 0, ierr);  "    IF (ierr <> SUCCESSFUL) THEN Escape (U_INTERNALERR);      END; {IF gsd}  DS_StoreUrec ( urecid, urec.int );  NameFromHashTable ( namerecid, namerec );   LinkNameToFreeList ( namerecid, namerec );  DS_StoreElement ( DS_NamesTD, namerecid, namerec.int );   result := SUCCESSFUL;       99:   BEGIN         DS_LeaveCritical (wkmp);        END; {99}       100:; {termination target for failed DS_EnterCritical calls}  END; {IPCGet}       $PAGE   !{----------------------------------------------------------------} ! !{   IPC GIVE                              500                    } ! !{----------------------------------------------------------------} !     	PROCEDURE IPCGive  	        {     sd          : INTEGER;        VAR give_name   : SocketNameType;           give_nlen   : INTEGER;        VAR flags       : FlagsType;        VAR result      : INTEGER      };      {}  { Abstract:   {   #{     give_name: Returns the name generated and bound to the socket by # {        IPC in case the user specified an nlen of zero:  {   %{     nlen: Returns a value of eight if the user specified zero on input.  % {   !{     result: Resultant error code. Currently defined values are:  ! {   {        SUCCESSFUL               U_NAME_TABLE_FULL   {        U_ILLEGAL_NAME_LENGTH    U_ILLEGAL_FLAGS   {        U_DUPLICATE_GIVE_NAME  {}      LABEL 99, 100;      VAR      i           : Int16;      ierr        : Int16;      gsd         : Int16;      lsd         : Int16;      namerecid   : Int16;      nlen        : Int16;      urecid      : Int16;      wkmp        : Int16;       PROCEDURE Escape ( error_code : Int16 );     BEGIN     result := error_code;     GOTO 99;   
   END; {PROCEDURE Escape} 
     BEGIN {IpcGive}       DS_EnterCritical ( wkmp, ierr );  IF (ierr <> SUCCESSFUL) THEN     BEGIN     result := U_NETWORK_IS_DOWN;      GOTO 100;  	   END; {IF ierr}  	     lsd := sd;  {type coercion}   IF ((lsd < 1) OR (lsd > MAX_SOCKETS_PER_USER)) THEN      Escape (U_ILLEGAL_DESCRIPTOR);       nlen := give_nlen; {type coercion}      FindUserRecord (MyIdAdd,  urecid, urec, ierr );   IF (ierr <> SUCCESSFUL) THEN Escape ( ierr );       IF (urec.ur_give_cnt = MAX_GIVE_LIMIT) THEN      Escape (U_CANT_GIVE);      
gsd := urec.ur_smap[lsd];  
     IF ( gsd <= 0 ) THEN Escape (U_ILLEGAL_DESCRIPTOR);       !{ Try to put the passed name into a newly allocated NameRecord and !  { then into the GiveAway Table. If we fail at this then we must    { reject the caller's request.  {}  !SoPutName (TRUE, gsd, nlen, give_name, namerecid, namerec, ierr);  ! IF (ierr <> SUCCESSFUL) THEN Escape(ierr);      { Take the descriptor out of the user's descriptor table.   { Then link the described object onto the user's give list.   {}  urec.ur_smap[lsd] := - ( urec.ur_sfree );   urec.ur_sfree := lsd;       IF (gsd < DST_BOUNDARY) THEN     BEGIN     { It's a socket record that the user has just given away.     {}      DS_SoFetchElement (gsd, socket.int);      namerec.nr_namesptr := socket.so_namesptr;      socket.so_namesptr := namerecid;      socket.so_giveptr := urec.ur_so_giveptr;      urec.ur_so_giveptr := gsd;      DS_SoStoreElement ( gsd, socket.int );      END  
ELSE {gsd > DST_BOUNDARY}  
    BEGIN     { The user is giving away a path record. We convert the gsd     { passed into the mbufid of the mbuf containing the path      { report. Then we fetch the path's preamble and update its      { linkage. Finally, we store the updated preamble back into     { the mbuf.     {}      gsd := gsd - DST_BOUNDARY;   
   mmflags.int := 0; 
    mmflags.bits[0] := TRUE; {preview flag}  #   DS_MRead (preamble.int, PATH_PREAMBLE_SIZE, gsd, 0, mmflags, ierr); #    IF (ierr <> SUCCESSFUL) THEN Escape(U_INTERNALERR);      
   WITH preamble DO  
       BEGIN   
      pa_urecid := urecid; 
       namerec.nr_namesptr := pa_namesptr;         pa_namesptr := namerecid;         pa_giveptr := urec.ur_pa_giveptr;   
      END; {WITH preamble} 
 "   DS_MBOverWrite ( preamble.int, PATH_PREAMBLE_SIZE, gsd, 0, ierr); "    IF (ierr <> SUCCESSFUL) THEN Escape(U_INTERNALERR);     urec.ur_pa_giveptr := gsd;   END; {IF gsd}   urec.ur_give_cnt := urec.ur_give_cnt + 1;   DS_StoreUrec ( urecid, urec.int );  DS_StoreElement ( DS_NamesTD, namerecid, namerec.int);      result := SUCCESSFUL;       99:   BEGIN         DS_LeaveCritical (wkmp);        END; {99}       100:; {termination target for failed DS_EnterCritical calls}  END; {IPCGive}      $PAGE   !{----------------------------------------------------------------} ! !{   IPC LOOKUP                        600                        } ! !{----------------------------------------------------------------} !     
PROCEDURE IPCLookUp  
        { VAR socket_name       : SocketNameType;           socket_nlen       : INTEGER;        VAR env_name          : EnvironStringType;            env_nlen          : INTEGER;        VAR flags             : FlagsType;        VAR destination_sd    : INTEGER;        VAR ret_protocol      : INTEGER;        VAR ret_socket_kind   : INTEGER;        VAR result            : INTEGER     };           {}  
{ Input parameters:  
 {   !{     name: Name of the socket and possibly the optional location  ! {        of the registry where the search is to take place.   {   {     nlen: Length of the name and optional location.   {   
{ Output parameters: 
 {   {     destination_sd: Destination socket descriptor.  {   #{     ret_protocol: Protocol which the destination socket rests upon.  # {   {     ret_kind: The kind of socket the destination socket is.   {   !{     result: Resultant error code. Currently defined values are:  ! {   {        SUCCESSFUL              U_SOCKET_LIMIT_EXCEEDED  {        U_ILLEGAL_FLAGS         U_ILLEGAL_NODE_NAME_LENGTH   {        U_ILLEGAL_NAME_LENGTH   U_NAME_NOT_FOUND   {        U_NO_REGISTRY_RESPONSE  U_SOCKET_LIMIT_EXCEEDED  {        U_NO_DSOCKETS_AVAILABLE U_INTERNALERR  
{        U_NETWORK_IS_DOWN 
 {}      LABEL 99, 100;      VAR      i               : Int16;      ierr            : Int16;      lookuprec       : LookUpRecord;     mbufid          : Int16;      mc              : Int16;      mmflags         : MMFlagsType;      rootgsd         : Int16;      sbufid          : Int16;      temp            : Int16;      wkmap           : Int16;          PROCEDURE Escape (error_code : Int16 );        BEGIN         result := error_code;         GOTO 99;  
      END; {Escape}  
         BEGIN   DS_EnterCritical (wkmap, ierr);   IF (ierr <> SUCCESSFUL) THEN     BEGIN     result := U_NETWORK_IS_DOWN;      GOTO 100;  	   END; {IF ierr}  	     FindUserRecord (MyIdAdd, lookuprec.lu_urecid, urec, ierr);  IF (ierr <> SUCCESSFUL) THEN Escape (ierr);        IF (urec.ur_sfree = NULL) THEN Escape(U_SOCKET_LIMIT_EXCEEDED);        IF (flags.int <> 0) THEN Escape ( U_ILLEGAL_FLAGS );      { Check the lengths of the names passed as two word integers  { before converting the lengths into single word integers.  { Performing the operations in this order will guarantee that   { no problems will be encountered regarding type conversion.  {}   IF ((socket_nlen < 1) OR (socket_nlen > MAX_SOCKET_NAMELEN)) OR       ((env_nlen < 0) OR (env_nlen > MAX_ENVIRON_NAMELEN)) THEN     Escape (U_ILLEGAL_NAME_LENGTH);          { Begin to prepare the QUERY_REQUEST event message that will  { be sent down to the Socket Registry's outbound protocol    { handler. If the socket registry is able to resolve the passed    { name into a path report then the mbufid of the path report  { will be placed into the user's local descriptor map. The  { local descriptor that the user should reference the path  { report with shall be returned in the QUERY_REPLY. If the  { user aborts before the QUERY_REPLY can be sent then the   { Socket Registry should not try to insert the mbufid into  { the deceased user's descriptor map.   {}  	WITH lookuprec DO  	    BEGIN     lu_socket_nlen := socket_nlen;      lu_env_nlen := env_nlen;           { Put the LookUp record along with the socket and environment       { names into an mbuf. Charge the mbuf against the user's root       { socket. The reference to this root socket should be placed       { into the QUERY_REQUEST emsg.      {}      AdrOf (lookuprec.int, 0, vdbuf[1]);     vdbuf[2] := LOOKUPREC_SIZE;     Adrof (socket_name.int, 0, vdbuf[3] );      vdbuf[4] := lu_socket_nlen;     AdrOf (env_name.int, 0, vdbuf[5]);      vdbuf[6] := lu_env_nlen;          rootgsd := urec.ur_smap[0];     sbufid := rootgsd + rootgsd;          { Set flags to indicate that we only need enough memory to      { accomodate the event message and that we don't need to      { allocate an macct or any other overhead memory.     {}   
   mmflags.int := 0; 
    mmflags.bits[-1] := TRUE;     mc := LOOKUPREC_SIZE + lu_socket_nlen + lu_env_nlen;      temp := mc;     DS_SBPut (vdbuf, 12, sbufid, mmflags, mbufid, mc, ierr);      IF (ierr <> SUCCESSFUL) THEN Escape(U_INTERNALERR);     END; {WITH lookuprec}      WITH emsg DO     BEGIN     ehport := SREG * EHS_PER + EHOB_OFFSET;     em_event := QUERY_REQUEST;      emqrq_up_pid := IPC;      emqrq_up_ref := rootgsd;      emqrq_down_ref := MEANINGLESS;   
   emqrq_mbufid := mbufid; 
    emqrq_dlen := temp;     emqrq_seq_num := MEANINGLESS;  
   emqrq_options.int := 0; 
 
   END; {WITH emsg}  
     DS_SoFetchElement (rootgsd, rtsocket.int);  SoQuery (rootgsd, rtsocket, emsg, EMSG_BYTE_LEN, wkmap,            urec.ur_rn, ierr);   IF (ierr <> SUCCESSFUL) THEN     BEGIN    { SoQuery Error }      { Note we are no longer critical if SoQuery has an error }   	   result := ierr; 	    GOTO 100;     END;     { SoQuery Error }       DS_SoStoreElement (rootgsd, rtsocket.int);      result := emsg.emqc_result;   destination_sd := emsg.emqc_mbufid;   ret_protocol := 0; {default value}  ret_socket_kind := emsg.emqc_dlen;      99:   BEGIN         DS_LeaveCritical (wkmap);         END; {99}       100:; {termination target for failed DS_EnterCritical calls}  END; {IPCLookUp}      $PAGE   !{----------------------------------------------------------------} ! !{   IPC NAME                               700                   } ! !{----------------------------------------------------------------} !     	PROCEDURE IPCName  	        {     sd          : INTEGER;        VAR socket_name : SocketNameType;           socket_nlen : INTEGER;        VAR result      : INTEGER         };       {}  
{ Input parameters:  
 {     sd: The socket descriptor for the socket to be named.   {   {     socket_name: The name to be given to the socket.  {   {     namelen: The length of the socket name.   {   
{ Output parameters: 
 {    {     result: Resultant error code. Possible values include the    
{        following:  
 {   {        SUCCESSFUL              U_NETWORK_IS_DOWN  {        U_ILLEGAL_DESCRIPTOR    U_NAME_TABLE_FULL  {        U_CANT_NAME_VC_SOCKET   U_CANT_NAME_REQ_SOCKET   {        U_ILLEGAL_NAME_LENGTH   U_ILLEGAL_NAME   
{        U_DUPLICATE_NAME  
 {}      LABEL 99, 100;      VAR      gsd         : Int16;      i           : Int16;      ierr        : Int16;      lsd         : Int16;      namerecid   : Int16;      nlen        : Int16;      temp        : Int16;      urecid      : Int16;      wkmap       : Int16;              PROCEDURE Escape (error_code : Int16 );        BEGIN         result := error_code;         GOTO 99;        END; {PROCEDURE Escape}       BEGIN   DS_EnterCritical (wkmap, ierr);   IF (ierr <> SUCCESSFUL) THEN     BEGIN     result := U_NETWORK_IS_DOWN;      GOTO 100;  	   END; {IF ierr}  	     lsd := sd; {type coercion to Int16}   IF ((lsd < 1) OR (lsd > MAX_SOCKETS_PER_USER)) THEN      Escape (U_ILLEGAL_DESCRIPTOR);       nlen := socket_nlen; {type coercion to Int16}       FindUserRecord (MyIdAdd,  urecid, urec, ierr );   IF (ierr <> SUCCESSFUL) THEN Escape ( ierr );       
gsd := urec.ur_smap[lsd];  
 IF (gsd <= 0) THEN Escape ( U_ILLEGAL_DESCRIPTOR);      { For the time being we don't allow users to name destination   { descriptors. Later, as a useful, and relatively easy to   { implement, enhancement we probably will.  {}  IF (gsd >= DST_BOUNDARY) THEN      Escape (U_ILLEGAL_DESCRIPTOR);       DS_SoFetchElement (gsd, socket.int );    IF (socket.so_b.kind = VC) THEN Escape (U_CANT_NAME_VC_SOCKET);        !{ Try to put the passed name into a newly-allocated NameRecord and ! { then try to link that NameRecord into the SocketRegistry's  { LookUp Table.   {}   SoPutName (NAME_TABLE_ENTRY, gsd, nlen, socket_name, namerecid,    
           namerec, ierr); 
 IF (ierr <> SUCCESSFUL) THEN Escape (ierr);       !{ Link the name onto the socket. This linkage will permit purging  ! "{ of the name record from the name table if the user program either  " { aborts or else shuts the socket down.   {}  namerec.nr_namesptr := socket.so_namesptr;  socket.so_namesptr := namerecid;      DS_StoreElement ( DS_NamesTD, namerecid, namerec.int );   DS_SoStoreElement (gsd, socket.int );   result := SUCCESSFUL;       99:   BEGIN         DS_LeaveCritical (wkmap);         END; {99}       100:; {termination target for failed DS_EnterCritical calls}  END; {IpcName}      $PAGE   !{----------------------------------------------------------------} ! !{   IPC NAME ERASE                         800                   } ! !{----------------------------------------------------------------} !     PROCEDURE IPCNamErase      { VAR name       : SocketNameType;            big_nlen   : INTEGER;       VAR result     : INTEGER  };       {}  
{ Output parameters: 
 {}      LABEL 99, 100;      CONST      GIVE_TABLE_ACCESS = TRUE;      VAR      i           : Int16;      ierr        : Int16;      namerecid   : Int16;      nlen        : Int16;      urecid      : Int16;      wkmp        : Int16;       PROCEDURE Escape (     error_code : Int16 );     BEGIN     result := error_code;     GOTO 99;      END; {Escape}          BEGIN   DS_EnterCritical ( wkmp, ierr );  IF (ierr <> SUCCESSFUL) THEN     BEGIN     result := U_NETWORK_IS_DOWN;      GOTO 100;  	   END; {IF ierr}  	     	nlen := big_nlen;  	 IF ((nlen > MAX_SOCKET_NAMELEN) OR (nlen < 1)) THEN      Escape(U_ILLEGAL_NAME_LENGTH);       FindUserRecord (MyIdAdd, urecid, urec, ierr);       !HashFind ( (NOT GIVE_TABLE_ACCESS), name, nlen, namerecid, ierr);  !     IF (ierr = SUCCESSFUL) THEN      BEGIN     { The name is currently entered into our SReg database, but     { before purging it from the database's hash table we must       { verify that the caller is the owner of the socket that the       { name names.     {}      DS_FetchElement ( DS_NamesTD, namerecid, namerec.int );     DS_SoFetchElement (namerec.nr_socketd, socket.int);         IF (socket.so_urecid = urecid) THEN        BEGIN         NameFromHashTable ( namerecid, namerec );         NameFromSocket ( namerecid, namerec, socket );        DS_SoStoreElement ( namerec.nr_socketd, socket.int );         LinkNameToFreeList ( namerecid, namerec );        DS_StoreElement ( DS_NamesTD, namerecid, namerec.int );         result := SUCCESSFUL;         END      ELSE         BEGIN         result := U_NO_OWNERSHIP;   
      END; {  IF namerec } 
 	   END; {IF ierr}  	     99:   BEGIN         DS_LeaveCritical (wkmp);        END; {99}       100:; {termination target for failed DS_EnterCritical calls}  	END; {IPCNamErase} 	     $PAGE   !{----------------------------------------------------------------} ! !{   IPC NODE NAME                        900                     } ! !{----------------------------------------------------------------} !     PROCEDURE IpcNodeName      { VAR nodename    : EnvironStringType;        VAR nodenamelen : INTEGER;        VAR result      : INTEGER };       LABEL 100;  VAR   	   temp  : Int16;  	 	   wkmp  : Int16;  	     BEGIN   DS_EnterCritical (wkmp, temp);  IF (temp <> SUCCESSFUL) THEN     BEGIN     result := U_NETWORK_IS_DOWN;      GOTO 100;     END;       'DS_FetchFields (DS_NodesTD, 1, nodename.int, 0, (MAX_ENVIRON_NAMELEN DIV 2));  ' #DS_FetchFields (DS_NodesTD, 1, temp, (MAX_ENVIRON_NAMELEN DIV 2), 1);  # DS_LeaveCritical (wkmp);  nodenamelen := temp; {type coercion to INTEGER}   result := SUCCESSFUL;   100:; { termination target for failed DS_EnterCritical calls }  	END; {IpcNodeName} 	     $PAGE   !{----------------------------------------------------------------} ! !{   IPC RECV                                1000                 } ! !{----------------------------------------------------------------} !     	PROCEDURE IPCRecv  	    {       vcsd     : INTEGER;         VAR data     : VectoredDataType;          VAR dlen     : INTEGER;         VAR flags    : FlagsType;         VAR opt      : OptType;         VAR result   : INTEGER    };       {}  
{ Output parameters: 
 {   "{     result: The resultant error code. Currently defined values are " 
{        as follows. 
 {   {        SUCCESSFUL              U_IPCControl_EXPECTED  {        U_ILLEGAL_OPTS          U_TIMEOUT  {        U_ILLEGAL_DESCRIPTOR    U_WOULD_BLOCK  {        U_ILLEGAL_FLAGS         U_ILLEGAL_DLEN   {        U_NOT_A_VC_SOCKET       U_RECEIVES_EXHAUSTED   {        U_NETWORK_IS_DOWN       U_ADDRESS_VIOLATION  {}      LABEL 99, 100;      VAR   
   cancelid       : Int16; 
    dirty          : BOOLEAN;     finished       : BOOLEAN;     flagscopy      : FlagsType;  
   i              : Int16; 
 
   ierr           : Int16; 
 
   gsd            : Int16; 
 
   lsd            : Int16; 
    newly_readable : BOOLEAN;     offset         : AnyWordType;  
   readcc         : Int16; 
    rqsttime       : INTEGER;  
   sb             : Int16; 
 
   small_dlen     : Int16; 
 
   temp           : Int16; 
    timerid        : TimerIdType;     timermsg       : TimerMsgType;   
   urecid         : Int16; 
 
   wkmp           : Int16; 
     PROCEDURE Escape (     error_code : Int16 );     BEGIN     result := error_code;     GOTO 99;   
   END; {PROCEDURE Escape} 
     
PROCEDURE SetTimer;  
    {}      { Abstract: Used like a MACRO. This routine's only purpose      { is to set a timer and possiblely Escape() if the attempt       { was unsuccessful. I've checked with AH to verify that this       { is a reasonable way to code this routine.     {}      BEGIN  
   timermsg.socket := gsd; 
    timermsg.direction := INBOUND_SIG;      timermsg.signal := TIMERABLE_1;  !   rqsttime := vcsocket.so_timeout * 10; {convert to centiseconds} !    ActivateTimer (rqsttime, timermsg, timerid, ierr);      IF (ierr <> SUCCESSFUL) THEN Escape (U_INTERNALERR);   	   END; {SetTimer} 	     BEGIN   dirty := FALSE;   DS_EnterCritical (wkmp, ierr);  IF (ierr <> SUCCESSFUL) THEN     BEGIN     result := U_NETWORK_IS_DOWN;      GOTO 100;  	   END; {IF ierr}  	         small_dlen := dlen; {type coercion}   IF (small_dlen < 0) THEN Escape (U_BAD_LENGTH);   dlen := 0; {in case we must later Escape with error}      lsd := vcsd; {type coercion}  IF ((lsd <= 0) OR (lsd > MAX_SOCKETS_PER_USER)) THEN     Escape (U_ILLEGAL_DESCRIPTOR);       FindUserRecord (MyIdAdd,  urecid, urec, ierr );   IF (ierr <> SUCCESSFUL) THEN Escape (ierr);       
gsd := urec.ur_smap[lsd];  
 IF (gsd <= 0) THEN Escape ( U_NOT_A_VC_SOCKET);       DS_SoFetchElement ( gsd, vcsocket.int );  IF (vcsocket.so_b.kind <> VC) THEN Escape (U_NOT_A_VC_SOCKET);      { Test for illegal flags and options. }   
flagscopy := flags;  
 flagscopy.bit[MORE_DATA_BIT] := FALSE;  flagscopy.bit[PREVIEW_BIT] := FALSE;  flagscopy.bit[VECTORED_BIT] := FALSE;   IF ( flagscopy.int <> 0 ) THEN Escape ( U_ILLEGAL_FLAGS );          { Evaluate the options specified.   {}  "offset.int := 0; {default data offset in case user doesn't opt one}  "     IF ((opt.opt_length <> 0) AND (opt.opt_num_entries <> 0)) THEN     BEGIN     EvaluateOpts ( opt, ierr );     IF ( ierr <> SUCCESSFUL ) THEN Escape ( ierr );         FOR i := 0 TO (opt.opt_num_entries - 1) DO         BEGIN         WITH opt.opt_entry[i] DO           BEGIN  
         CASE ent_code OF  
                 OPT_DATAOFFSET:   
               BEGIN 
 #               IF flags.bit[VECTORED_BIT] THEN Escape(U_ILLEGAL_OPTS); # "               IF (ent_length <> 2) THEN Escape(U_DATA_OFFSET_ERR);  "                offset.bytes[1] := opt.opt_byte[ent_offset];                   offset.bytes[2] := opt.opt_byte[ent_offset + 1];                   END; {OPT_DATA_OFFSET}                   OTHERWISE                  Escape ( U_ILLEGAL_OPTS );                   END; {CASE ent_code}           END; {WITH opt.opt_entry}  	      END; {FOR i} 	    END; {IF opt.opt_length}       sb := gsd + gsd - 1; {inbound sbuf it}  	finished := FALSE; 	 newly_readable := FALSE;      REPEAT  
   WITH vcsocket DO  
       BEGIN         CASE so_b.state OF               VC_EMERGING,            VC_ESTAB_CONFIRM_PENDING:  	            BEGIN  	             { The socket isn't completely connected yet to              { the remote socket. The user is calling IpcRecv()  "            { to see if the socket can be used to send and receive.  "             {}              IF so_f.asynchmode THEN Escape ( U_WOULD_BLOCK );                    { User is willing to wait to find out if the socket                 { can be connected or not. We set the timer and wait               { for a state change or a time out.               {}              so_UserSig.er_flags[XSELENABLE] := TRUE;              so_UserSig.er_flags[TIMER_1_SELENABLE] := TRUE;       "            { Now activate a timer request. The SetTimer() call acts " !            { like a MACRO and can result in our Escape()ing from  ! !            { IpcRecv() if the timer doesn't like something about  ! 
            { our request. 
             {}              IF (so_timeout <> 0) THEN SetTimer;       '            DS_SigAwait (gsd, INBOUND_SIG, vcsocket, urec.ur_rn ,wkmp, ierr);  '             IF (ierr <> SUCCESSFUL) THEN  
               BEGIN 
 #               { Either we're shutting down or we ran into an internal #                { error.   	               {}  	                result := ierr;                 GOTO 100;                 END; {IF ierr}                    { Clear all the inbound X-selenable bits so we don't                { get crossed up later on. Check the X-able bits to                { see if we timed out, changed state, or did both.              { If we changed state then we assume our next pass              { through the REPEAT loop will get us out. Cancel   !            { the timer if it didn't pop. Return a time out error  !             { if the timer popped but the state didn't change.              {}              so_UserSig.er_ints[2] := 0;   
            dirty := TRUE; 
             IF so_UserSig.er_flags[TIMERABLE_1] THEN  
               BEGIN 
                so_UserSig.er_flags[TIMERABLE_1] := FALSE;                  IF so_UserSig.er_flags[EXCEPTIONAL] THEN                     BEGIN                     so_UserSig.er_flags[EXCEPTIONAL] := FALSE;                    END   
               ELSE  
                   BEGIN                     finished := TRUE;                     result := U_TIMED_OUT;                    END; {IF so_UserSig.er_flags[EXCEPTIONAL]}  	               END 	             ELSE  {timer didn't pop}  
               BEGIN 
 #               IF (so_timeout <> 0) THEN CancelTimer (timerid, ierr);  #                IF (NOT so_UserSig.er_flags[EXCEPTIONAL]) THEN                     Escape ( U_INTERNALERR );                  END; {IF so_UserSig.er_flags[TIMERABLE_1]}                   END; {VC_ESTAB_CONFIRM_PENDING case}                   VC_OPEN_CONFIRMING:  	            BEGIN  	             { The connect has come up. We need to report the              { results to our user and set the socket's state              { to VC_OPEN. At present we don't handle call                { user data, but if we did here's where we'd do it.                 { Note that we hand shake here using state changes.                { We disable the state change signal to avoid               { possible confusion later on.              {}              so_b.state := VC_OPEN;              so_UserSig.er_flags[EXCEPTIONAL] := FALSE;  
            dirty := TRUE; 
             result := SUCCESSFUL;               finished := TRUE;               END; {VC_OPEN_CONFIRMING case}               VC_GRELEASING,            VC_ESTAB_RESPONSE_PENDING:   	            BEGIN  	              { The user shouldn't know about the socket when it's               { in this state. It might be possible that this                { code never gets executed since while in this state               { the socket might not be in the user's descriptor              { space. Should revisit this code later. <<<>>>               {}              Escape ( U_ILLEGAL_DESCRIPTOR );              END; {VC_GRELEASING ... case}                VC_ACCEPT_REJECT_PENDING:  	            BEGIN  	             { This state not supported for first release.               {}              Escape ( U_INTERNALERR );               END; {VC_ACCEPT_REJECT_PENDING case}      	         VC_OPEN,  	          VC_OPEN_ACCEPTING:   	            BEGIN  	             readcc := so_k.max_rcvcc;               mmflags.int := 0;               mmflags.bits[0] := flags.bit[PREVIEW_BIT];              mmflags.bits[-1] := so_f.msgmode;                   { Before blocking, testing bits, etc., we try               { to satisfy the user's request outright. At this               { point we don't know if the user is trying to              { receive too much data, i.e., more than the               { max send size he/she committed to. DS_SBGet checks                { this for us -- we pass in the max send size limit.   !            { If the request can't be satisfied the SBGet returns  !              { the number of characters the user requested. This                { number can be used to set up a read select.               {   !            { WARNING: It is important to note that the DS_SBGet() ! "            { call may modify the socket's signal records. Therefore "             { care must be taken not to overlay any changes               { inadvertently.              {}  
            IF dirty THEN  
 
               BEGIN 
                DS_SoStoreElement (gsd, vcsocket.int);                  dirty := FALSE;                 END; {IF dirty}                  IF ( NOT flags.bit[VECTORED_BIT] ) THEN   
               BEGIN 
                AdrOf ( data[1], offset.int, vdbuf[1] );                  vdbuf[2] := small_dlen;  %               DS_SBGet ( vdbuf, 4, sb, SBDATAQ, mmflags, readcc, ierr );  % 	               END 	             ELSE  
               BEGIN 
                DS_SBGet ( data, small_dlen, sb, SBDATAQ,                            mmflags, readcc, ierr );                 END; {IF NOT flags}                  IF ( ierr = SUCCESSFUL ) THEN   
               BEGIN 
                dlen := readcc;                 result := SUCCESSFUL;                 finished := TRUE;  	               END 	             ELSE IF (ierr = MMDATALEFTOVER) THEN  
               BEGIN 
                dlen := readcc;                 result := SUCCESSFUL;                 finished := TRUE;                 flags.bits[MORE_DATA_BIT] := TRUE;   	               END 	             ELSE IF ( ierr = MMOVERLIMIT ) THEN   
               BEGIN 
                Escape(U_BAD_LENGTH);  	               END 	             ELSE IF (ierr = MMBADVALUE) THEN  
               BEGIN 
                Escape ( U_BAD_VECTOR_DLEN );  	               END 	 %            ELSE IF ((ierr = MMTOOFEWBYTES) OR (ierr = MMWOULDBLOCK)) THEN % 
               BEGIN 
                IF so_f.asynchmode THEN Escape(U_WOULD_BLOCK);                       { NOTE: The error check below helps tests to make                   { sure that we don't enter into an infinite loop.   !               { If we've already blocked, read selected, and then !                { been told that our socket is readable and yet  !               { our attempt to read from it fails then we've got  ! 
               { problems. 
 	               {}  	 !               IF (newly_readable) THEN Escape ( U_INTERNALERR );  !     #               { We need to set timer, set up read select & then await # #               { any or all of timer expiration, data arrival or state # #               { change. We save and restore the sbuf's read threshold # $               { in case the user decides to do his/her own read select  $                { later.   	               {}  	                DS_SBFetchElement ( sb, sbuf.int );                 WITH sbuf DO                     BEGIN                     temp := sb_rdthresh;                     sb_rdthresh := readcc;  {total chars we want}    !                  sb_newcc := sb_cc;      {total chars we've got}  !                   END;                 DS_SBStoreElement ( sb, sbuf.int );      #               { Now activate a timer request. The SetTimer() routine  # !               { acts like a MACRO and can result in our Escaping  !                { from  IpcRecv() if the timer doesn't like our  
               { request.  
 	               {}  	                IF (so_timeout <> 0) THEN SetTimer;                     { We must read the socket in again in case the                  { DS_SBGet() call modified any of the socket's                  { signal records.  	               {}  	                DS_SoFetchElement (gsd, vcsocket.int);                  so_UserSig.er_flags[TIMER_1_SELENABLE] := TRUE;                 so_UserSig.er_flags[XSELENABLE] := TRUE;                  so_UserSig.er_flags[DATA_RSELENABLE] := TRUE;                 so_UserSig.er_flags[DATA_READABLE] := FALSE;                      DS_SigAwait (gsd, INBOUND_SIG, vcsocket,                                urec.ur_rn, wkmp, ierr);                  IF (ierr <> SUCCESSFUL) THEN                     BEGIN                      { Either we're shutting down or we've run into                     { an internal error.  
                  {} 
                   result := ierr;                     GOTO 100;                     END; {IF ierr}      "               newly_readable := so_usersig.er_flags[DATA_READABLE]; "     !               { Now we restore the read threshold to the socket's !                { inbound sbuf. Toward the end of this case                 { clause we'll invoke DS_MMCheckRdAd() to make                  { sure our socket's DATA_READABLE signal flag                  { gets restored properly. Since DS_MMCheckRdAD()                   { can only turn the DATA_READABLE flag off we                 { make sure we the flag is on before calling.  	               {}  	                DS_SBFetchElement ( sb, sbuf.int );                 sbuf.sb_rdthresh := temp;                 DS_SBStoreElement ( sb, sbuf.int );                     so_usersig.er_flags[DATA_READABLE] := TRUE;  "               so_UserSig.er_ints[2] := 0; {clear X-selenable bits}  "                dirty := TRUE;                      IF so_UserSig.er_flags[TIMERABLE_1] THEN                     BEGIN                     so_UserSig.er_flags[TIMERABLE_1] := FALSE;                    IF (NOT (newly_readable OR  !                           so_UserSig.er_flags[EXCEPTIONAL])) THEN ! 
                     BEGIN 
                      finished := TRUE;                       result := U_TIMED_OUT;                        END; {IF NOT newly_readable}                     END                  ELSE {timer didn't expire}                     BEGIN                     IF (so_timeout <> 0) THEN   
                     BEGIN 
 #                     { We should have no trouble cancelling our timer  # "                     { request because we know we set one, and since " #                     { going critical we've looked at our signal bits  # #                     { to make sure that our timer hadn'e expired yet. #                      {}                        CancelTimer (timerid, ierr);   $                     IF (ierr <> SUCCESSFUL) THEN Escape(U_INTERNALERR); $ 
                     END;  
                       IF (NOT (newly_readable   %                               OR so_UserSig.er_flags[EXCEPTIONAL])) THEN  % 
                     BEGIN 
 "                     { None of the things we might have been waiting " "                     { for (time out, data arriving, or socket state "                       { change) occurred. We shouldn't have woken                        { up from our signal sleep.                       {}                        Escape ( U_INTERNALERR )                        END; {IF NOT newly_readable}                     END; {IF so_UserSig.er_flags[TIMERABLE_1]}      "               { Here we restore so_usersig.er_flags[DATA_READABLE]  " "               { to its accurate value relative to the sb_rdthresh.  " 	               {}  	                DS_SoStoreElement (gsd, vcsocket.int);                  dirty := FALSE;                 DS_SBCheckRdAd (sb, SBDATAQ);                     END; {IF ierr = SUCCESSFUL}              END; {VC_OPEN case}                VC_SERVER_ABORTED:   	            BEGIN  	             { The server aborted the socket so there won't be               { any more data to be read. We leave the socket               { in this state until the user decides to shut it               { down. We determine the reason for the socket's               { being aborted from a well-known socket field which               { OUTPRO knows not to look at any more.               {}              finished := TRUE;               result := so_down_pathref;              END; {VC_SERVER_ABORTED}               OTHERWISE Escape (U_INTERNALERR);               END; {CASE so_b.state}      END; {WITH vc_socket}  UNTIL finished;       99:   BEGIN         IF dirty THEN DS_SoStoreElement (gsd, vcsocket.int);        DS_LeaveCritical ( wkmp );        END; {99}       100:; {termination target for failed DS_EnterCritical call}   END; { IPCRecv }      $PAGE   !{----------------------------------------------------------------} ! !{   IPC RECV CN                            1100                  } ! !{----------------------------------------------------------------} !     
PROCEDURE IPCRecvCn  
        {        callsd   : INTEGER;           VAR vcsd     : INTEGER;           VAR flags    : FlagsType;           VAR opt      : OptType;           VAR result   : INTEGER      };      {}  
{ Input parameters:  
 {   %{     flags: Option flags: Currently defined flags include the following:  % {   {        flags[DEFER_ACCEPT]:   {   
{ Output parameters: 
 {   "{     result: The following are the currently defined result values: " {   {        SUCCESSFUL         U_SOCKET_LIMIT_EXCEEDED   {        U_TIMEOUT          U_NOT_A_CALL_SOCKET   {        U_ILLEGAL_FLAGS    U_ILLEGAL_DESCRIPTOR  {        U_WOULD_BLOCK      U_ADDRESS_VIOLATION   {        U_ILLEGAL_OPTS   {   {}      LABEL 99, 100;      VAR      burstin         : AnyWordType;      burstout        : AnyWordType;      callsb          : Int16;      calldirty       : BOOLEAN;      cancelid        : Int16;      gcsd            : Int16;      gvcsd           : Int16;      i               : Int16;      ierr            : Int16;      incc            : AnyWordType;      lsd             : Int16;      mc              : Int16;      outcc           : AnyWordType;      rqsttime        : INTEGER;      sb              : Int16;      temp            : Int16;      tempflags       : FlagsType;      timerid         : TimerIdType;      timermsg        : TimerMsgType;     urecid          : Int16;      wkmp            : Int16;              PROCEDURE Escape (     error_code : Int16 );         BEGIN         result := error_code;         GOTO 99;  
      END; {Escape}  
        PROCEDURE SetTimer;        {}         { Abstract: Used like a MACRO. This routine's only purpose          { is to set a timer and possiblely Escape() if the attempt   !      { was unsuccessful. I've checked with AH to verify that this !       { is a reasonable way to code this routine.         {}        BEGIN          timermsg.socket := gcsd;  {wait for signal on call socket}         timermsg.direction := INBOUND_SIG;        timermsg.signal := TIMERABLE_1;         rqsttime := callsocket.so_timeout * 10;         ActivateTimer (rqsttime, timermsg, timerid, ierr);        IF (ierr <> SUCCESSFUL) THEN Escape (U_INTERNALERR);        END; {SetTimer}          PROCEDURE GetConnection;          {}       { Abstract: Produces many side effects -- acts like a macro.        {  Invoked when it's known that a VC connection is queued on       {  the call socket. Its job is to allocate memory and do       {  whatever else is necessary to bring the connection up for       {  the user.      {}          BEGIN  
   WITH vcsocket DO  
       BEGIN         { First we unlink the VC socket from the CALL socket and        { then since we have no further need for the CALL socket         { we store it back into DSAM. Note how we adjust the call          { socket's EXCEPTIONAL signal so that it remains set        { whenever a VC socket is queued.         {}        gvcsd := callsocket.so_k.vcq;         DS_SoFetchElement ( gvcsd, vcsocket.int );        callsocket.so_k.vcq := so_giveptr;        calldirty := TRUE;        callsocket.so_usersig.er_flags[EXCEPTIONAL] :=                   (callsocket.so_k.vcq <> NULL);   "      callsocket.so_k.vcs_queued := callsocket.so_k.vcs_queued - 1;  "           IF (so_b.state = VC_ESTAB_RESPONSE_PENDING) THEN           BEGIN  !         { We must try to allocate memory for use with the socket. !          { If there is no memory available then we abort the            { offered connection and return an error to our caller.             { Note that we do not wait around for memory to become             { available if we can not get it right away. Perhaps   !         { we'll want to reconsider this strategy for synchronous  !          { mode callers.           {}   '         InitSbufs ( gvcsd, VC, vcsocket, burstin.int, incc.int, burstout.int, '                         outcc.int, ierr );               IF (ierr <> SUCCESSFUL) THEN   	            BEGIN  	             { We must abort the VC socket for lack of memory.                { First we unlink the VC socket from the call socket                { and then we signal the IPC server telling it that                { we've had to abort the socket.              {}              so_giveptr := NULL;               so_b.state := VC_USER_ABORTED;              so_timeout := U_NO_MEMORY;              so_ProtoSig.er_flags[EXCEPTIONAL] := TRUE;              DS_Signal ( gvcsd, OUTBOUND_SIG, vcsocket );              Escape ( U_NO_MEMORY);              END            ELSE { we got the memory that we needed}   	            BEGIN  	             so_b.state := VC_OPEN_ACCEPTING;              so_ProtoSig.er_flags[EXCEPTIONAL] := TRUE;              END; {IF vcsocket}           END        ELSE IF (so_b.state <> VC_SERVER_ABORTED) THEN           BEGIN           { We've encountered an unknown state.           {  "         { Note: If the socket is in the VC_WAS_SERVER_ABORTED state " !         { then we accept the socket and let the user discover the !          { error. This situation should arise rarely if the   !         { call socket listener isn't too slow. If it is slow then ! "         { we rationalize then it's reasonable to let it know about  " 
         { such failures.  
          {}            Escape ( U_INTERNALERR );           END; {IF vcsocket.so_b}      !      { We use fields within the socket to communicate information ! "      { about flow control windows to the outbound protocol process. "       {}        so_k.max_burstout := burstout.int;        so_k.max_burstin  := burstin.int;         so_k.max_rcvcc := incc.int;         so_k.max_sndcc := outcc.int;  
      so_urecid := urecid; 
       so_b.UserRnd := urec.ur_rnd;  
      so_f.int := 0; 
       so_f.msgmode := flags.bits[MESSAGE_BIT];        so_f.checksum := flags.bits[CHECKSUM_BIT];            AttachSoToUser ( urec, gvcsd, lsd );        DS_StoreUrec ( urecid, urec.int );            { Note that the DS_Signal call below both saves the         { vcsocket's socket record in DSAM and it clears        { the socket's Pmap bit.        {}        DS_Signal ( gvcsd, OUTBOUND_SIG, vcsocket );            vcsd := lsd; {return descriptor to user}        result := SUCCESSFUL;   
      END; {WITH vcsocket} 
    END; {GetConnection}       BEGIN       DS_EnterCritical (wkmp, ierr);  IF (ierr <> SUCCESSFUL) THEN     BEGIN     result := U_NETWORK_IS_DOWN;      GOTO 100;     END;       
calldirty := FALSE;  
     { Evaluate the call socket. Make sure the provided descriptor   { is valid and that socket is, in fact, a call socket.  {}  gcsd := callsd; {coerce to single word integer}   IF ((gcsd < 0) OR (gcsd > MAX_SOCKETS_PER_USER)) THEN      Escape ( U_ILLEGAL_DESCRIPTOR );       FindUserRecord (MyIdAdd,  urecid, urec, ierr );   IF ( ierr <> SUCCESSFUL) THEN Escape (ierr);      { Verify that the user has some local descriptors at  { his/her disposal. We assume that the user can't acquire   { any more sockets (i.e., lose any local descriptors)   { until after IPCRecvCn() has completed. This assumption  { is important in avoiding race conditions since this   { call may block while IPC inbound remains/becomes active.  {}  "IF ( urec.ur_sfree = NULL ) THEN Escape ( U_SOCKET_LIMIT_EXCEEDED);  "     { Make sure the socket is a CALL socket.  {}  gcsd := urec.ur_smap[gcsd]; {get global descriptor}   IF ((gcsd <= 0) OR (gcsd >= DST_BOUNDARY)) THEN      Escape (U_NOT_A_CALL_SOCKET);      DS_SoFetchElement ( gcsd, callsocket.int );   IF ( callsocket.so_b.kind <> CALL ) THEN     Escape ( U_NOT_A_CALL_SOCKET );      IF (callsocket.so_b.state = CALL_CLOSING_IN) THEN      BEGIN     { The call socket was aborted by the lower level protocol.      { We must inform our user of this. Having done so we'll     { be expecting our user to shut the call socket down.     {}      Escape ( U_ABORTED_LOCALLY );     END; {IF callsocket}       { Evaluate the flags.   {}  
tempflags := flags;  
 tempflags.bits[MESSAGE_BIT] := FALSE;   tempflags.bits[CHECKSUM_BIT] := FALSE;  IF (tempflags.int <> 0) THEN Escape ( U_ILLEGAL_FLAGS );      { Evaluate the options. Be careful that defaults are provided   { where necessary. We depend on some default lengths to be  { obtained from the protocol record.  {}  	burstin.int := 1;  	 	burstout.int := 1; 	     #DS_FetchElement ( DS_ProtosTD, callsocket.so_down_pid, protorec.int ); # outcc.int := protorec.pr_default_outcc;   incc.int := protorec.pr_default_incc;   IF ((opt.opt_length <> 0) AND (opt.opt_num_entries <>0)) THEN      BEGIN     EvaluateOpts ( opt, ierr );     IF ( ierr <> SUCCESSFUL ) THEN Escape ( ierr );         FOR i := 0 TO (opt.opt_num_entries - 1) DO         BEGIN         WITH opt.opt_entry[i] DO           BEGIN  
         CASE ent_code OF  
                 OPT_MAXSNDSIZE:   
               BEGIN 
 !               IF (ent_length <> 2) THEN Escape (U_ILLEGAL_OPTS);  !                outcc.bytes[1] := opt.opt_byte[ent_offset];                 outcc.bytes[2] := opt.opt_byte[ent_offset+1];                 IF ((outcc.int > protorec.pr_maxmsglen) OR   "                   (outcc.int < 0)) THEN Escape ( U_ILLEGAL_OPTS );  "                END; {OPT_MAXSNDSIZE case}                   OPT_MAXRCVSIZE:   
               BEGIN 
 !               IF (ent_length <> 2) THEN Escape (U_ILLEGAL_OPTS);  !                incc.bytes[1] := opt.opt_byte[ent_offset];                  incc.bytes[2] := opt.opt_byte[ent_offset+1];                  IF ((incc.int > protorec.pr_maxmsglen) OR  !                   (incc.int < 0)) THEN Escape ( U_ILLEGAL_OPTS ); ! 
               END;  
                 OPT_MIN_BURSTIN:  
               BEGIN 
 $               IF (ent_length <> 2) THEN Escape (U_MSGS_QUEUED_OPT_ERR); $                burstin.bytes[1] := opt.opt_byte[ent_offset];                 burstin.bytes[2] := opt.opt_byte[ent_offset+1];  $               IF (burstin.int < 0) THEN Escape (U_MSGS_QUEUED_OPT_ERR); $                END; {OPT_MIN_BURSTIN opt}                   OPT_MIN_BURSTOUT:   
               BEGIN 
 $               IF (ent_length <> 2) THEN Escape (U_MSGS_QUEUED_OPT_ERR); $                burstout.bytes[1] := opt.opt_byte[ent_offset];                   burstout.bytes[2] := opt.opt_byte[ent_offset+1];    %               IF (burstout.int < 0) THEN Escape (U_MSGS_QUEUED_OPT_ERR);  % 
               END;  
                 { OPT_CALLUSERDATA: }               OTHERWISE   
               BEGIN 
                Escape ( U_ILLEGAL_OPTS);                 END; {OPT_CALLUSERDATA case}                   END; {CASE ent_code}  
         END; {WITH} 
 	      END; {FOR i} 	    END; {IF opt}      	WITH callsocket DO 	    BEGIN     IF (so_k.vcq <> NULL) THEN         BEGIN   
      GetConnection; 
       END      ELSE         BEGIN   !      { There aren't any connections queued on the CALL socket at  ! !      { this time. We must, therefore, decide whether to wait for  !       { one or to return an error to the caller.        {}        IF so_f.asynchmode THEN Escape ( U_WOULD_BLOCK );              { User is willing to wait for a VC to be offered. We set a         { timer, enable both the TIMER and CONNECT signals, and         { sleep waiting for a signal.         {}        so_UserSig.er_flags[TIMER_1_SELENABLE] := TRUE;         so_UserSig.er_flags[XSELENABLE] := TRUE;      $      { Here we call SetTimer() to activate a timer request. SetTimer()  $       { can cause us to Escape() from IpcRecvCn() if there is          { something about our request that the timer doesn't like.         {}        IF (so_timeout <> 0) THEN SetTimer;       %      DS_SigAwait (gcsd, INBOUND_SIG, callsocket, urec.ur_rn, wkmp, ierr); %       IF (ierr <> SUCCESSFUL) THEN           BEGIN           result := ierr;  	         GOTO 100; 	          END; {IF ierr}       !      { Disable the signals that we enabled before going to sleep. !        { We must disable these signals so that they can't wake us         { up unexpectedly later on.         {}        so_usersig.er_ints[2] := 0; {clear all X-SELENABLE bits}        calldirty := TRUE;            DS_UrFetchElement ( urecid, urec.int );             IF so_UserSig.er_flags[TIMERABLE_1] THEN           BEGIN  "         { The timer we set expired. If no connections have arrived  "          { then we must return a time-out error to the caller.           {}            so_UserSig.er_flags[TIMERABLE_1] := FALSE;            IF so_UserSig.er_flags[EXCEPTIONAL] THEN   	            BEGIN  	             { A connection did arrive and so we attempt to              { accept it instead of returning a time-out error.              {}              so_UserSig.er_flags[EXCEPTIONAL] := FALSE;  
            GetConnection; 
             END            ELSE   	            BEGIN  	             result := U_TIMED_OUT;              END; {IF so_UserSig}           END        ELSE IF so_UserSig.er_flags[EXCEPTIONAL] THEN            BEGIN           IF (so_timeout <> 0) THEN  	            BEGIN  	             { We should have no trouble canelling the timer we              { set because since going critical we've verified               { that we haven't received a timer signal.              {}              CancelTimer (timerid, ierr);               IF (ierr <> SUCCESSFUL) THEN Escape (U_INTERNALERR);               END; {IF so_timeout}               so_UserSig.er_flags[EXCEPTIONAL] := FALSE;            IF (so_b.state = CALL_CLOSING_IN) THEN               Escape (U_ABORTED_LOCALLY);            GetConnection;            END        ELSE           BEGIN           { Our signal arrived for some unanticipated reason.           { This should never happen.           {}            result := U_INTERNALERR;            END; {IF so_UserSig}   
      END; {IF so_k} 
 
   END; {WITH callsocket}  
      99: IF calldirty THEN DS_SoStoreElement (gcsd, callsocket.int);        DS_LeaveCritical ( wkmp );      100:;   	END;  {IPCRecvCn}  	     $PAGE   !{----------------------------------------------------------------} ! !{   IPC SELECT                           1200                    } ! !{----------------------------------------------------------------} !     
PROCEDURE IPCSelect  
        { VAR soboundary : INTEGER;       VAR readmap    : BitMapType;        VAR writemap   : BitMapType;        VAR exceptmap  : BitMapType;            timeout    : INTEGER;       VAR result     : INTEGER   };      {}  { Abstract:   {   
{ Input parameters:  
 {   
{ Output parameters: 
 {}      LABEL 99, 100;      VAR   
   cleanup_bound  : Int16; 
 
   ierr           : Int16; 
 
   gsd            : Int16; 
 
   lasthit        : Int16; 
 
   lsd            : Int16; 
 
   mc             : Int16; 
    rqsttime       : INTEGER;     satisfied      : BOOLEAN;  
   sbufid         : Int16; 
    sbvector       : SB_Vector_Type;      scanmap        : BitMapType;      should_store   : BOOLEAN;  
   sdbound        : Int16; 
    timerid        : TimerIdType;     timermsg       : TimerMsgType;   
   urecid         : Int16; 
 
   wkmp           : Int16; 
            {-------------------------------------------}     {   Escape/IpcSelect                        }     {-------------------------------------------}     PROCEDURE Escape (     error_code : Int16 );         BEGIN         result := error_code;         GOTO 99;  
      END; {Escape}  
        {--------------------------------------}      {   SET TIMER / IPC SELECT             }      {--------------------------------------}      PROCEDURE SetTimer         (     rootgsd     : Int16;              timeinterval: INTEGER;          VAR timerident  : TimerIDType );            {}  !      { Abstract: Used to set a timer on the IpcSelect() caller's  !       { root socket. Takes an Escape() if the attempt   !      { was unsuccessful. I've checked with AH to verify that this !       { is a reasonable way to code this routine.         {}        BEGIN         timermsg.socket := rootgsd;         timermsg.direction := INBOUND_SIG;        timermsg.signal := TIMERABLE_1;         rqsttime := timeinterval * 10;        ActivateTimer (rqsttime, timermsg, timerident, ierr);         IF (ierr <> SUCCESSFUL) THEN Escape (U_INTERNALERR);        END; {SetTimer}          {--------------------------------------}      {   Back Out/IpcSelect                 }      {--------------------------------------}      PROCEDURE BackOut;          VAR  
      i    : Int16;  
 
      gsd  : Int16;  
           BEGIN   !      { This procedure is used like a MACRO would be. It disables  ! !      { any signals that were enabled on sockets referenced by the ! #      { scanmap. While doing this it records which of the IpcSelect()  #       { criteria were met and which were not met.         {}        FOR i := 1 to cleanup_bound DO           BEGIN           IF scanmap.bits[i] THEN  	            BEGIN  	             gsd := urec.ur_smap[i];               DS_SoFetchElement (gsd, socket.int);  
            WITH socket DO 
 
               BEGIN 
                 { First we check to see if our socket has become                   { EXCEPTIONAL. If it has we conclude that it                  { can't be either READABLE or WRITEABLE. A VC                  { socket becomes EXCEPTIONAL only if it has been                    { aborted. In case we had a write-select pending                    { against an aborted VC socket, we don't want to    "               { call DS_SBCancelMem() as this would cause problems. " 	               {}  	                IF so_usersig.er_flags[EXCEPTIONAL] THEN                     BEGIN   !                  { Changing exceptmap.bits[i] would be redundant. ! 
                  {} 
                   readmap.bits[i] := FALSE;                     writemap.bits[i] := FALSE;                    END   
               ELSE  
                   BEGIN                     exceptmap.bits[i] := FALSE;                     END; {IF so_usersig.er_flags[EXCEPTIONAL]}                     IF readmap.bits[i] THEN                    BEGIN   $                  readmap.bits[i] := so_usersig.er_flags[DATA_READABLE]; $                   END; {IF readmap.bits}                     IF writemap.bits[i] THEN                     BEGIN   "                  { Here determine whether the socket we're backing  " "                  { out became writeable. If it didn't then we must  "                   { cancel our request for memory.  
                  {} 
 #                  writemap.bits[i] := so_usersig.er_flags[WRITEABLE];  #                   IF (NOT writemap.bits[i]) THEN  
                     BEGIN 
                       sbvector[1] := gsd + gsd; {outbound sbufid}                        DS_SBCancelMem (sbvector, 1, ierr);  $                     IF (ierr <> SUCCESSFUL) THEN Escape(U_INTERNALERR); $                      END; {IF NOT}                    END; {IF writemap}                     IF (readmap.bits[i] OR writemap.bits[i]                       OR exceptmap.bits[i]) THEN                     BEGIN                     satisfied := TRUE;                    IF (lasthit < i) THEN lasthit := i;                     END; {IF readmap ..}                     { Clear all of the socket's X-selenable bits.  	               {}  	                so_usersig.er_ints[2] := 0;                 END; {WITH socket}               DS_Signal (gsd, INBOUND_SIG, socket);               END; {IF scanmap.bits[i]}            END; {FOR i}   
      END; {BackOut} 
        {--------------------------------------}      {   Handle First Hit/IpcSelect         }      {--------------------------------------}      PROCEDURE HandleFirstHit;        {}  	      { Abstract:  	 "      {  Acts like a macro. Should be called upon first discovering  "       {  that one of the select criterion have been satisfied.        {}        BEGIN         satisfied := TRUE;        should_store := FALSE;        cleanup_bound := lsd - 1;         WITH socket.so_usersig DO            BEGIN  '         readmap.bits[lsd] := (er_flags[DATA_READABLE] AND readmap.bits[lsd]); ' &         writemap.bits[lsd] :=(er_flags[WRITEABLE] AND writemap.bits[lsd]);  &          exceptmap.bits[lsd] := (er_flags[EXCEPTIONAL]                                   AND exceptmap.bits[lsd]);           END; {WITH socket}         END; {HandleFirstHit}       {-----------------------------------------}   {   BEGIN/IpcSelect                       }   {-----------------------------------------}   	BEGIN {IPCSelect}  	 
cleanup_bound := 0;  
 lasthit := 0;   result := SUCCESSFUL;       sdbound := soboundary; {type coercion to 16 bits}   IF ((sdbound < 1) OR (sdbound > MAX_SOCKETS_PER_USER)) THEN      { Escape (U_BAD_SDBOUND); -- get error code from Brian.     {}      BEGIN     result := U_ILLEGAL_DESCRIPTOR;     GOTO 100;  
   END; {IF sdbound} 
     IF ((timeout < 0) AND (timeout <> -1)) THEN      BEGIN     readmap.longint := 0;  
   writemap.longint := 0;  
 
   exceptmap.longint := 0; 
    result := U_ILLEGAL_TIMEOUT;      GOTO 100;  
   END; {IF timeout} 
     { We assume the caller will be satisfied just to find out the   { current state of the selected sockets if he/she refuses to  { suspend.  {}  satisfied := (timeout = 0);       { We do a little data reduction to form a "scan bitmap." This   { bitmap will be used to determine which sockets we'll  { stop to examine. As the logical OR of the three select  { maps the scan map should only have bits set for those   { sockets that the user issued selects against.   {}  scanmap.ints[1] := Ior(readmap.ints[1], writemap.ints[1]);  scanmap.ints[2] := Ior(readmap.ints[2], writemap.ints[2]);  scanmap.ints[1] := Ior(scanmap.ints[1], exceptmap.ints[1]);   scanmap.ints[2] := Ior(scanmap.ints[2], exceptmap.ints[2]);       DS_EnterCritical (wkmp, ierr);  IF (ierr <> SUCCESSFUL) THEN     BEGIN     result := U_NETWORK_IS_DOWN;      GOTO 100;  	   END; {IF ierr}  	     FindUserRecord (MyIdAdd, urecid, urec, ierr);   IF (ierr <> SUCCESSFUL) THEN Escape(ierr);          { Process the scan map to see what kind of selections the   	{ caller has made. 	 {}  
FOR lsd := 1 TO sdbound DO 
    BEGIN     IF scanmap.bits[lsd] THEN        BEGIN   !      { We first verify that the local descriptor selected by the  !        { user corresponds to an active socket. If it doesn't then         { we "back out" the users request. This means we disable        { any sockets that we'd previously select-enabled.        {}        gsd := urec.ur_smap[lsd];         IF ((gsd < 0) OR (gsd >= DST_BOUNDARY)) THEN           BEGIN           cleanup_bound := lsd - 1;           BackOut; {acts like a macro}            readmap.longint := 0; {clears all bits}           writemap.longint := 0;            exceptmap.longint := 0;           exceptmap.bits[lsd] := TRUE;            lasthit := lsd;           Escape (U_ILLEGAL_DESCRIPTOR);            END; {IF gsd}            { Knowing that the user has selected on an active socket        { we now fetch that socket and examine its X-ABLE bits.         { We won't bother writing the socket back out to DSAM         { unless we "dirty" it by enabling one or more of its         { signals.        {}        DS_SoFetchElement (gsd, socket.int);        should_store := FALSE;      
      WITH socket DO 
          BEGIN  "         { We don't want to issue read- or write-selects against any "           { socket that's been aborted. An aborted socket should    !         { be EXCEPTIONAL and our policy, as reflected by the next !           { few lines, is that we consider any EXCEPTIONAL socket            { to be neither READABLE nor WRITEABLE.           {}            IF so_usersig.er_flags[EXCEPTIONAL] THEN   	            BEGIN  	             readmap.bits[lsd] := FALSE;               writemap.bits[lsd] := FALSE;              END; {IF so_usersig.er_flags}                    IF readmap.bits[lsd] THEN  	            BEGIN  	             IF (so_b.kind = CALL) THEN  
               BEGIN 
                { Call sockets are never readable.   	               {}  	                readmap.bits[lsd] := FALSE;  	               END 	             ELSE IF satisfied THEN  
               BEGIN 
 $               { Some of the caller's IpcSelect() criteria have already  $ "               { been met. We'll therefore report the current state  " "               { of this socket but won't set up to await a signal.  " 	               {}  	 $               readmap.bits[lsd] := so_usersig.er_flags[DATA_READABLE];  $ 	               END 	             ELSE IF so_usersig.er_flags[DATA_READABLE] THEN   
               BEGIN 
 "               { For the first time one of the caller's IpcSelect()  " "               { criterion have been met. We report the results and  " "               { record that we're satisfied so that we don't bother "                { enabling any signals later.  	               {}  	                HandleFirstHit;  	               END 	             ELSE  
               BEGIN 
                so_usersig.er_flags[DATA_RSELENABLE] := TRUE;                 should_store := TRUE;                 END; {IF satisfied}              END; {IF readmap}       "         { The logic we employ for evaluating write selects is very  "           { similar to the logic employed for read selects. Later             { we'll change the logic somewhat so that write selects   !         { select not only on the memory in the caller's socket's  ! !         { individual account but also on the memory in the pools. !          {}            IF writemap.bits[lsd] THEN   	            BEGIN  	             IF (so_b.kind = CALL) THEN  
               BEGIN 
                { Call sockets are never writeable.  	               {}  	                writemap.bits[lsd] := FALSE;   	               END 	             ELSE  
               BEGIN 
 #               { We can't trust the WRITEABLE bit in the signal record # $               { at this point. Instead we must recalculate it and then  $ 
               { proceed.  
 	               {}  	                sbufid := gsd + gsd;                  DS_SBFetchElement (sbufid, sbuf.int);                 sbuf.sb_dropcc := sbuf.sb_mbfree - RSVDMBUFS;                 DS_SBStoreElement (sbufid, sbuf.int);  "               so_usersig.er_flags[WRITEABLE] := (sbuf.sb_dropcc >=  " #                                                   sbuf.sb_wrthresh);  #                IF satisfied THEN                    BEGIN   %                  { Some of the caller's IpcSelect() criteria have already % #                  { been met. We'll therefore report the current state # #                  { of this socket but won't set up to await a signal. # 
                  {} 
 $                  writemap.bits[lsd] := so_usersig.er_flags[WRITEABLE];  $                   END                  ELSE IF so_usersig.er_flags[WRITEABLE] THEN                    BEGIN   #                  { For the first time one of the caller's IpcSelect() # #                  { criterion have been met. We report the results and # $                  { record that we're satisfied so that we don't bother  $                   { enabling any signals later.   
                  {} 
                   HandleFirstHit;                     END   
               ELSE  
                   BEGIN   #                  { Now we must tell memory manager that we're waiting #                   { for memory.   
                  {  
 #                  { TESTBED: We don't wait for memory from the general # $                  { pools, we only wait for it from the callers outbound $                   { sbuf. Later we'll change.   
                  {} 
                   mmflags.int := 0;   %                  DS_SBWaitMem (sbufid, sbuf.sb_wrthresh, mmflags, ierr);  % #                  IF (ierr <> SUCCESSFUL) THEN Escape (U_INTERNALERR); #                   so_usersig.er_flags[WSELENABLE] := TRUE;                    should_store := TRUE;                     END; {IF satisfied}                  END; {IF so_b.kind}              END; {IF writemap}               IF exceptmap.bits[lsd] THEN  	            BEGIN  	             IF satisfied THEN   
               BEGIN 
 $               { Some of the caller's IpcSelect() criteria have already  $ "               { been met. We'll therefore report the current state  " "               { of this socket but won't set up to await a signal.  " 	               {}  	 $               exceptmap.bits[lsd] := so_usersig.er_flags[EXCEPTIONAL];  $ 	               END 	             ELSE IF so_usersig.er_flags[EXCEPTIONAL] THEN   
               BEGIN 
 "               { For the first time one of the caller's IpcSelect()  " "               { criterion have been met. We report the results and  " "               { record that we're satisfied so that we don't bother "                { enabling any signals later.  	               {}  	                HandleFirstHit;  	               END 	             ELSE  
               BEGIN 
                so_usersig.er_flags[XSELENABLE] := TRUE;                  should_store := TRUE;                 END; {IF satisfied}              END; {IF exceptmap}                IF ((satisfied   	              AND  	               (writemap.bits[lsd] OR readmap.bits[lsd]                 OR exceptmap.bits[lsd]))) THEN   	            BEGIN  	             lasthit := lsd;               END            ELSE IF should_store THEN  	            BEGIN  	             DS_SoStoreElement (gsd, socket.int);              END; {IF}                END; {WITH socket}         END; {IF scanmap}   	   END; {FOR lsd}  	         	IF satisfied THEN  	    BEGIN  !   BackOut; {to disable any sockets we might have select enabled}  !    END  ELSE     BEGIN     { We're going to have to back out of the select-enabling      { that we've already initiated and we're going to have to     { do it over all the sockets that we selected on.     {}      cleanup_bound := sdbound;         { We haven't found anything that satisfies the caller yet,      { therefore we need to wait for something to happen. If the     { caller didn't specify a willingness to wait forever then      { we set a timer on the caller's root socket to place a     { limit on our waiting interval.      {}      IF (timeout <> - 1) THEN         BEGIN         { Caller doesn't want to wait forever.        {}        gsd := urec.ur_smap[0];         DS_SoFetchElement (gsd, socket.int);        socket.so_usersig.er_flags[TIMER_1_SELENABLE] := TRUE;            { Now we try to activate a timer request. Our SetTimer()        { routine acts like a MACRO and could throw us out of         { of IpcSelect() if there is something about our request        { that the timer doesn't like.        {}        SetTimer (gsd, timeout, timerid);       #      DS_SigAwait (gsd, INBOUND_SIG, socket, urec.ur_rn, wkmp, ierr);  #       IF (ierr <> SUCCESSFUL) THEN           BEGIN            { Either our nodal manager is shutting down our node or            { we've run into an internal software error.            {}            result := ierr;  	         GOTO 100; 	          END; {IF ierr}             IF (NOT socket.so_usersig.er_flags[TIMERABLE_1]) THEN            BEGIN  "         { The timer hasn't expired yet so we must cancel our timer  " 
         { request.  
          {}            CancelTimer (timerid, ierr);            END        ELSE           BEGIN           ierr := SUCCESSFUL;           END; {IF NOT socket}              { We want to clear our root socket's signal bits to avoid    !      { problems with spurious signal's. If our request to cancel  !       { the timer failed then we also bail out.         {}        socket.so_usersig.longint := 0;         DS_SoStoreElement (gsd, socket.int);        IF (ierr <> SUCCESSFUL) THEN Escape (U_INTERNALERR);        END      ELSE         BEGIN   "      { The caller is willing to block forever. We block only on the "       { sockets that the caller has selected on.        {}        DS_RNStoreElement (urec.ur_rnd, urec.ur_rn);        DS_LeaveCritical (wkmp);        Rnrq (RN_AWAIT+RN_NO_ABORT_BIT, urec.ur_rn, ierr);              BEGIN {abort return -- serious problems}              IpcWeAborted (ierr);              result := ierr;   
            lasthit := 0;  
             GOTO 100;               END; {Rnrq}             { Verify the RNRQ status return is "locked" }         IF ierr = 3 THEN           BEGIN    { unlocked rn }            DS_EnterCritical(wkmp, ierr );            IF ierr <> SUCCESSFUL THEN               BEGIN    { can't enter critical }   
            lasthit := 0;  
             GOTO 100;               END      { can't enter critical }            END      { unlocked rn }           ELSE           BEGIN    { rn error }           ierr := U_INTERNALERR;   	         GOTO 100; 	          END;     { rn error }        END; {IF timeout <> -1}          { Now we "back out" the signals that we previously enabled.      { As we do so we'll record which of our select criteria have       { been met.     {}      BackOut;   
   IF (NOT satisfied) THEN 
       BEGIN         Escape (U_TIMED_OUT);         END;         END; {IF satisfied}      99:   BEGIN         DS_LeaveCritical (wkmp);        END; {99}       100: soboundary := lasthit;   END; {IPCSelect}      $PAGE   !{---------------------------------------------------------------}  ! !{   IPC SEND                                1300                }  ! !{---------------------------------------------------------------}  !     	PROCEDURE IPCSend  	    {       vcsd        : INTEGER;          VAR data        : VectoredDataType;             dlen        : INTEGER;          VAR flags       : FlagsType;          VAR opt         : OptType;          VAR result      : INTEGER    };      LABEL 99, 100;      CONST   
   INFINITY       = 32767; 
     VAR   
   cancelid       : Int16; 
    finished       : BOOLEAN;     flagscopy      : FlagsType;  
   gsd            : Int16; 
 
   i              : Int16; 
 
   ierr           : Int16; 
 
   lsd            : Int16; 
 
   m              : Int16; 
 
   mc             : Int16; 
    offset         : AnyWordType;     rqsttime       : INTEGER;  
   sb             : Int16; 
    sbvector       : SB_Vector_Type;   
   small_dlen     : Int16; 
 
   temp           : Int16; 
    timerid        : TimerIdType;     timermsg       : TimerMsgType;   
   urecid         : Int16; 
 
   wkmp           : Int16; 
    write_selected : BOOLEAN;         PROCEDURE Escape ( error_code : Int16 );      BEGIN        result := error_code;         GOTO 99;  
   END; {PROCEDURE Escape} 
     
PROCEDURE SetTimer;  
    {}      { Abstract: Used like a MACRO. This routine's only purpose      { is to set a timer and possiblely Escape() if the attempt       { was unsuccessful. I've checked with AH to verify that this       { is a reasonable way to code this routine.     {}      BEGIN  
   timermsg.socket := gsd; 
    timermsg.direction := INBOUND_SIG;      timermsg.signal := TIMERABLE_1;     rqsttime := vcsocket.so_timeout * 10;     ActivateTimer (rqsttime, timermsg, timerid, ierr);      IF (ierr <> SUCCESSFUL) THEN Escape (U_INTERNALERR);   	   END; {SetTimer} 	     	BEGIN { IPCSend }  	 result := SUCCESSFUL;   DS_EnterCritical ( wkmp, ierr );  IF (ierr <> SUCCESSFUL) THEN     BEGIN     result := U_NETWORK_IS_DOWN;      GOTO 100;  	   END; {IF ierr}  	     FindUserRecord (MyIdAdd,  urecid, urec, ierr );   IF ( ierr <> SUCCESSFUL ) THEN Escape ( ierr );       { test for illegal flags and options }  
flagscopy := flags;  
 flagscopy.bit[MORE_DATA_BIT] := FALSE;  flagscopy.bit[VECTORED_BIT] := FALSE;   IF ( flagscopy.int <> 0 ) THEN Escape ( U_ILLEGAL_FLAGS );      { Test for illegal options. Currently only one option is  { defined. This section is coded, though, assuming that   { other options will be added.  {}  offset.int := 0;  IF ( opt.opt_length <> 0 ) THEN      BEGIN     EvaluateOpts ( opt, ierr );     IF ( ierr <> SUCCESSFUL ) THEN Escape ( ierr );         FOR i := 0 TO (opt.opt_num_entries - 1) DO         BEGIN         WITH opt.opt_entry[i] DO           BEGIN  
         CASE ent_code OF  
                 OPT_DATAOFFSET:   
               BEGIN 
 #               IF flags.bit[VECTORED_BIT] THEN Escape(U_ILLEGAL_OPTS); # "               IF (ent_length <> 2) THEN Escape(U_DATA_OFFSET_ERR);  "                offset.bytes[1] := opt.opt_byte[ent_offset];                   offset.bytes[2] := opt.opt_byte[ent_offset + 1];                   END; {OPT_DATAOFFSET}                  OTHERWISE                  Escape ( U_ILLEGAL_OPTS );                   END; {CASE ent_code}           END; {WITH opt.opt_entry}  	      END; {FOR i} 	    END; {IF opt.opt_length}       { Now evaluate the socket itself. Make sure the descriptor  { is valid and is bound to the VC socket.   {}  lsd := vcsd; {type coercion}  IF ((lsd < 1) OR (lsd > MAX_SOCKETS_PER_USER)) THEN      Escape ( U_ILLEGAL_DESCRIPTOR);      
gsd := urec.ur_smap[lsd];  
 IF ( gsd <= 0 ) THEN Escape (U_NOT_A_VC_SOCKET);      DS_SoFetchElement ( gsd, vcsocket.int );   IF ( vcsocket.so_b.kind <> VC ) THEN Escape (U_NOT_A_VC_SOCKET);           	finished := FALSE; 	 write_selected := FALSE; {we haven't had to wait for memory}      REPEAT     CASE vcsocket.so_b.state OF         VC_SERVER_ABORTED:         BEGIN         { Return an error to the user but don't release the         { socket until the user requests that it be shut down.  !      { NOTE: Perhaps it would make sense to release the socket's  ! 
      { memory now.  
       {}        Escape ( vcsocket.so_down_pathref );        END; {VC_SERVER_ABORTED case}          VC_OPEN,      VC_OPEN_ACCEPTING:         BEGIN         sb := gsd + gsd; {outbound sbufid}            { Try to put the user's data into mbufs. For now we         { don't permit buffer space to be drawn from the general        { pools. This policy should test our ability to estimate        { overhead requirements.        {}        mmflags.int := 0;         mc := vcsocket.so_k.max_sndcc;            { First check to see the data length specified by the         { caller was reasonable. If it was then try to write the        { caller's data into DSAM.        {}        small_dlen := dlen; {type coercion}   &      IF ((small_dlen <= 0) OR (small_dlen > vcsocket.so_k.max_sndcc)) THEN  &          Escape(U_BAD_LENGTH);            IF flags.bit[VECTORED_BIT] THEN            BEGIN           DS_SBPut ( data, small_dlen, sb, mmflags, m,                       mc, ierr );   !         IF ((ierr = MMOVERLIMIT) OR (ierr = MMTOOFEWBYTES)) THEN  !             Escape (U_BAD_LENGTH);           END        ELSE {user didn't pass a data vector so we make one}           BEGIN           Adrof ( data[1], offset.int, vdbuf[1] );            vdbuf[2] := small_dlen;           DS_SBPut ( vdbuf, 4, sb, mmflags, m, mc, ierr );            END; {IF flags.bit}            IF (ierr = SUCCESSFUL) THEN            BEGIN  "         { Try to append the data to the appropriate sbuf. We don't  " !         { worry about queuing limits now and so specify "limits"  !           { of infinity. We worry about where "push" flags end up             { if we're in stream mode. We never want more than one             { push flag in an outbound stream-mode data queue.            {}            mmflags.bits[0] := NOT flags.bits[MORE_DATA_BIT];           mmflags.bits[-1] := NOT vcsocket.so_f.msgmode;            DS_SBAppend ( sb, m, SBDATAQ, INFINITY, INFINITY,                         mmflags, ierr );   !         IF ( ierr <> SUCCESSFUL ) THEN Escape ( U_INTERNALERR );  ! 
         finished := TRUE; 
          END        ELSE IF (ierr = MMBADVALUE) THEN           BEGIN           Escape ( U_BAD_VECTOR_DLEN );           END  $      ELSE IF ((ierr <> MMWOULDBLOCK) AND (ierr <> MMGENERALBLOCK)) THEN $          BEGIN           Escape ( U_INTERNALERR );           END        ELSE IF vcsocket.so_f.asynchmode THEN            BEGIN           { We couldn't get the space & this user won't wait.           {}            Escape ( U_WOULD_BLOCK );           END        ELSE IF write_selected THEN            BEGIN           { We tried waiting for memory once & were told that           { we could get it -- turns out we can't & therefore           { something must be wrong.            {}            Escape ( U_INTERNALERR );           END        ELSE           BEGIN           { The needed buffer space isn't available now and our           { user doesn't mind waiting. We need to enable the            { appropriate signals and then block. Before we do,           { however, we save a copy of the inbound sbuf's write           { threshold so that we can restore it after blocking.           {}            DS_SBFetchElement ( sb, sbuf.int );           temp := sbuf.sb_wrthresh;      !         { TESTBED: We need to reset the value of sb_dropcc in the ! "         { outbound sbuf if we're not going to be waiting for memory "          { from the general pools.           {}            sbuf.sb_dropcc := sbuf.sb_mbfree;           DS_SBStoreElement (sb, sbuf.int);               { Here we tell memory manager that we're waiting for   	         { memory. 	          {  
         { TESTBED:  
          { We don't attempt to draw any memory from the shared           { pools yet -- we plan on more testing first. Later           { after we've verified that a highly stressed system            { works we can relax our restrictions.            {}   
         mmflags.int := 0; 
          DS_SbWaitMem ( sb, mc, mmflags, ierr );            IF (ierr <> SUCCESSFUL) THEN Escape ( U_INTERNALERR );        "         { Our previous calls to DS_SBPut() and DS_SBAppend() might  "           { have modified our socket's signal records. So that we             { don't destroy the accuracy of the signal bits we must            { now read in a fresh copy of the signal record.            {}            DS_SoFetchElement (gsd, vcsocket.int);       "         { Enable all the signal types that we're going to sleep on. " !         { Also record that the socket currently isn't writeable.  !          {}   
         WITH vcsocket DO  
 	            BEGIN  	             so_usersig.er_flags[WSELENABLE] := TRUE;              so_UserSig.er_flags[XSELENABLE] := TRUE;              so_UserSig.er_flags[TIMER_1_SELENABLE] := TRUE;               so_usersig.er_flags[WRITEABLE] := FALSE;              END; {WITH vcsocket}      #         { Now try to activate a timer request. The SetTimer() routine #           { acts like a MACRO and could cause us to Escape() from             { IpcSend() if there is something wrong with our timer    
         { request.  
          {}            IF (vcsocket.so_timeout <> 0) THEN SetTimer;       !         { Sleep until one or more of the following happen: memory !           { manager tells us we've got memory, our timer expires,   "         { or our socket's state changes. DS_SigAwait() both writes  "           { out our socket record and then reads it back in after   
         { resuming. 
          {}   &         DS_SigAwait ( gsd, INBOUND_SIG, vcsocket, urec.ur_rn, wkmp, ierr);  &          IF (ierr <> SUCCESSFUL) THEN   	            BEGIN  	 %            { Either our nodal manager is shutting our node down or we've  %             { run into an internal software error.              {}              result := ierr;               GOTO 100;   
            END; {IF ierr} 
               { Before doing anything else we restore the vc socket's             { outbound sbuf's write threshold back to its original    "         { value. This action will allow the caller to write-select  " "         { against the via socket using IpcSelect() without getting  " 
         { any surprises.  
          {}            DS_SBFetchElement (sb, sbuf.int);           sbuf.sb_wrthresh := temp;           DS_SBStoreElement (sb, sbuf.int);               { We determine what happened by looking at the bits           { of the signal record. We'll turn off all these            { bits before we're done.           {}   
         WITH vcsocket DO  
 	            BEGIN  	             { Disable all signals that we've enabled.               {}  #            so_usersig.er_ints[2] := 0; {clears all X-selenable bits}  #                 IF so_usersig.er_flags[TIMERABLE_1] THEN  
               BEGIN 
                so_UserSig.er_flags[TIMERABLE_1] := FALSE;                  IF (NOT (so_UserSig.er_flags[EXCEPTIONAL] OR                           so_UserSig.er_flags[WRITEABLE])) THEN                     BEGIN                     finished := TRUE;                     result := U_TIMED_OUT;                    END; {IF NOT}   	               END 	             ELSE  
               BEGIN 
                IF (so_timeout <> 0) THEN                    BEGIN   !                  { We should have no trouble cancelling our timer !                    { because since going critical we've verified                      { that a timer signal wasn't sent to us.  
                  {} 
                   CancelTimer (timerid, ierr);  #                  IF (ierr <> SUCCESSFUL) THEN Escape (U_INTERNALERR); #                   END; {IF so_timeout}                     END; {IF vcsocket}                   IF so_UserSig.er_flags[WRITEABLE] THEN  
               BEGIN 
                write_selected := TRUE;  	               END 	             ELSE  
               BEGIN 
                { We must cancel our request for memory.   	               {}  	                sbvector[1] := sb;                  DS_SBCancelMem (sbvector, 1, ierr);  "               IF (ierr <> SUCCESSFUL) THEN Escape (U_INTERNALERR);  "                END; {IF vcsocket ... WRITEABLE}                   END; {WITH vcsocket}           DS_SoStoreElement ( gsd, vcsocket.int );            END; {IF ierr = SUCCESSFUL}        END; {VC_OPEN ... case}          VC_OPEN_CONFIRMING,     VC_ESTAB_RESPONSE_PENDING,      VC_ACCEPT_REJECT_PENDING:        BEGIN         { The user shouldn't be trying to send after having         { issued a graceful release request or until the socket         { has been brought up successfully.         {}        Escape ( U_ILLEGAL_REQUEST );         END; {VC_ESTAB_RESPONSE_PENDING ... case}          VC_ESTAB_CONFIRM_PENDING:        BEGIN   "      { Before sending any data, the user needs to invoke IpcRecv()  "       { to verify that the connection came up.        {}        Escape (U_IPCRECEIVE_EXPECTED);         END; {VC_ESTAB_CONFIRM_PENDING case}         OTHERWISE        BEGIN         { We've encountered an unexpected socket state.         {}        Escape ( U_INTERNALERR );   
      END; {IF OTHERWISE}  
        END; {CASE vcsocket.so_b.state}      UNTIL finished;       99:   BEGIN         DS_LeaveCritical (wkmp);        END; {99}       100:; {termination target for failed DS_EnterCritical calls}  END; { IPCSend }      $PAGE   !{----------------------------------------------------------------} ! !{   IPC SHUT DOWN                            1400                } ! !{----------------------------------------------------------------} !     PROCEDURE IPCShutDown              {    sd      : INTEGER;          VAR flags   : FlagsType;          VAR opt     : OptType;          VAR result  : INTEGER     };      {}  
{ Input parameters:  
 {   {     flags: The following flags bits have been assigned the  {        following meanings. All other flags bits should be   {        set to zero.   {    {        flags[GRACEFUL_BIT]: Valid only for VC sockets. If the    {           graceful bit is set then the connection will be   {           gracefully released. This means that the user may   {           continue receiving data on the connection but may   {           no longer send data.  {   
{ Output parameters: 
 {   "{     result: The resultant error code. Currently defined values are " 
{        as follows. 
 {   {        SUCCESSFUL                U_ILLEGAL_DESCRIPTOR   {        U_ILLEGAL_DESCRIPTOR      U_ILLEGAL_FLAGS  {        U_ILLEGAL_OPTS   {        U_SOCKETRECEIVE_EXPECTED  U_IPCControl_EXPECTED  {}      LABEL 99, 100;      VAR      flagscopy    : FlagsType;     gsd          : Int16;     i            : Int16;     ierr         : Int16;     lsd          : Int16;     sbufid       : Int16;     urecid       : Int16;     wkmp         : Int16;      PROCEDURE Escape (     error_code : Int16 );     BEGIN     result := error_code;     GOTO 99;   
   END; {PROCEDURE Escape} 
     	PROCEDURE Unlink;  	    BEGIN     urec.ur_smap[lsd] := - urec.ur_sfree;     urec.ur_sfree := lsd;     DS_StoreUrec ( urecid, urec.int );      END; {Unlink}          
BEGIN  {IpcShutDown} 
 result := SUCCESSFUL;   DS_EnterCritical ( wkmp, ierr );  IF (ierr <> SUCCESSFUL) THEN     BEGIN     result := U_NETWORK_IS_DOWN;      GOTO 100;  	   END; {IF ierr}  	     FindUserRecord (MyIdAdd,  urecid, urec, ierr );       { Make sure the descriptor is valid.  {}  
lsd := sd; {type coercion} 
 IF ((lsd < 1) OR (lsd > MAX_SOCKETS_PER_USER)) THEN      Escape ( U_ILLEGAL_DESCRIPTOR );       
gsd := urec.ur_smap[lsd];  
 IF (gsd <= 0) THEN Escape ( U_ILLEGAL_DESCRIPTOR );       { Test for illegal flags and options.   {}  
flagscopy := flags;  
 flagscopy.bit[GRACEFUL_BIT] := FALSE;   IF ( flagscopy.int <> 0) THEN Escape ( U_ILLEGAL_FLAGS );       { No options are currently defined for this call.   {}  IF ( opt.opt_length <> 0 ) THEN Escape ( U_ILLEGAL_OPTS );      "{ Unlink the local socket descriptor from the user's descriptor map. " {}  Unlink;       #{ Check to see what kind of descriptor the user is attempting to shut  # { down.   {}  IF (gsd > DST_BOUNDARY) THEN     BEGIN  !   { The user is attempting to shutdown a destination descriptor.  !    {}      SoPathRelease (gsd - DST_BOUNDARY, ierr);     Escape(ierr);     END  ELSE     BEGIN     { The user is attempting to shut down a socket.     {}      DS_SoFetchElement ( gsd, socket.int );   
   SoTrash (gsd, socket);  
    END; {IF gsd}      99:   BEGIN         DS_LeaveCritical (wkmp);        END; {99}       100:; {termination target for failed DS_EnterCritical calls}  	END; {IPCShutDown} 	     
END. {OF SOLIB IMPLEMENT}  
