 $PASCAL '91790-1X202 REV.4010 <860325.1449>'  $TITLE 'IPC Signal & Utility Library'$  $HEAP 0   $HEAPPARMS OFF  $RECURSIVE OFF  $RANGE OFF  
$STANDARD_LEVEL 'HP1000'$  
 $DEBUG  $PRIVATE_TYPES$           MODULE SIGMOD;      { ------------------------------------------------------------       (c) COPYRIGHT HEWLETT PACKARD COMPANY 1986. ALL RIGHTS    RESERVED. NO PART OF THIS PROGRAM MAY BE PHOTOCOPIED,   REPRODUCED OR TRANSLATED TO ANOTHER PROGRAM LANGUAGE WITHOUT    THE PRIOR WRITTEN CONSENT OF THE HEWLETT-PACKARD COMPANY.      ! -------------------------------------------------------------- }  !     {}  {   
{   NAME   : SIGMOD  
 {   SOURCE : 91790-18202  	{   RELOC  : NONE  	 {   PGMR   : CWW  {   OWNER  : CLC  {}  {   !{----------------------------------------------------------------  ! 
{   MODIFICATION HISTORY:  
 {   jar 840208 Implement "import from .rels"  {   {   ------------  
{   After Release I: 
 "{   clc 860218 SR Abort bugs in Ds_SigAwait and IpcWeAborted (n338)  " {              SR# 033225,033233  "{   lms 860221 Fix up Error handling for Enter/LeaveCritical Errors. " {              (n360).  !{   clc 860325 Don't clear bits in signal record in CleanAndNotify ! {              (n382) SR# 034041  !{----------------------------------------------------------------  ! {}      !{----------------------------------------------------------------} ! !{                                                                } ! !{  IMPORT DECLARATIONS                                           } ! !{                                                                } ! !{----------------------------------------------------------------} !     IMPORT     $search 'phtm/BODEC.REL'$      BODEC,     $search 'phtm/SODEC.REL'$      SODEC,     $search 'phtm/MMDEC.REL'$      MMDEC,     $search 'phtm/MMEXT.REL'$      DS_MM,     $search 'phtm/TRCMOD.REL'$     TRCMOD;           $PAGE   !{----------------------------------------------------------------} ! !{                                                                } ! !{   EXPORT DECLARATIONS                                          } ! !{                                                                } ! !{----------------------------------------------------------------} !     EXPORT      PROCEDURE AttachSoToUser     ( VAR urec   : UserRecord;            gsd    : Int16;       VAR lsd    : Int16    );       
PROCEDURE DS_SatBeamSignal 
    ( gsd       : Int16;   
     direction : Int16 );  
     PROCEDURE DS_SigAwait      (     gsd       : Int16;            direction : Int16;        VAR socket    : SocketRecord;           rn        : Int16;        VAR wkmp      : Int16;        VAR ierr      : Int16 );       
PROCEDURE DS_Signal  
    (     gsd       : Int16;            direction : Int16;        VAR socket    : SocketRecord );      PROCEDURE DS_TimerSignal     (     gsd       : Int16;            direction : Int16;            sigval    : Int16 );       PROCEDURE EnterHashTable     (   enter_give_table   : BOOLEAN;         namerecid          : Int16;     VAR namerec            : NameRecord;      VAR ierr               : Int16   );      PROCEDURE EvaluateOpts  
   ( VAR opt   : OptType;  
      VAR ierr  : Int16     );       PROCEDURE FindUserRecord  
   (     idaddr  : Int16;  
 
     VAR urecid  : Int16;  
      VAR urec    : UserRecord;       VAR ierr    : Int16        );          PROCEDURE FlushCallVcq     ( VAR callsocket  : SocketRecord;       VAR ierr        : Int16        );      FUNCTION GetNewNameRecord : Int16;      PROCEDURE GetNewSocket  
   (     sokind   : Int16; 
 
     VAR gsd      : Int16; 
      VAR socket   : SocketRecord;        VAR ierr     : Int16       );      PROCEDURE GetSignalRn   
   (VAR rnd : Int16; 
     VAR rn  : Int16  );       	PROCEDURE HashFind 	    (    give_table_access : BOOLEAN;      VAR socket_name       : SocketNameType;           socket_nlen       : Int16;      VAR name_id           : Int16;      VAR ierr              : Int16   );      
PROCEDURE InitSbufs  
 
   (     gsd      : Int16; 
 
         sokind   : Int16; 
      VAR socket   : SocketRecord;   
         burstin  : Int16; 
 
         incc     : Int16; 
 
         burstout : Int16; 
 
         outcc    : Int16; 
      VAR ierr     : Int16 );      PROCEDURE InitSignals   
   (    gsd       : Int16; 
 
        sokind    : Int16; 
 
        protornd  : Int16; 
 
        userrnd   : Int16; 
     VAR socket    : SocketRecord );           
PROCEDURE IpcAbtConf 
    ( VAR emsg   : EventMsgType;        VAR wkmp   : Int16;  
     VAR ierr   : Int16 ); 
     
PROCEDURE IpcAbtInd  
    ( VAR emsg   : EventMsgType;        VAR wkmp   : Int16;       VAR ierr   : Int16  );       PROCEDURE IpcConfIPath     ( VAR emsg  : EventMsgType;       VAR wkmp  : Int16;   
     VAR ierr  : Int16  ); 
     PROCEDURE IpcIpathAbt      ( VAR emsg  : EventMsgType;       VAR wkmp  : Int16;        VAR ierr  : Int16     );       PROCEDURE IpcIBOutpro      ( VAR emsg : EventMsgType;        VAR ierr : Int16           );      PROCEDURE IpcIB      ( VAR emsg : EventMsgType;        VAR ierr : Int16           );      PROCEDURE IpcWeAborted     ( VAR ierr     : Int16 );      PROCEDURE LinkNameToFreeList     (     name_rec_id : Int16;        VAR namerec     : NameRecord );      
PROCEDURE LocateHashBucket 
    (     give_table : BOOLEAN;       VAR name       : SocketNameType;            nlen       : Int16;       VAR headptr    : Int16 );      PROCEDURE MakeSocketFree     (     gsd    : Int16;       VAR socket : SocketRecord );       
PROCEDURE PurgeSocketNames 
    ( VAR socket : SocketRecord );       
PROCEDURE ReleaseSignalRn  
 	   ( rnd : Int16;  	 
     rn  : Int16  ); 
     PROCEDURE SoAttemptToLog  (    caller_entity   :  Int16;       caller_location :  Int16;       caller_context  :  Int16;       caller_ierr     :  Int16 );      
PROCEDURE SoAwaitSig 
    (     gsd        : Int16;           direction  : Int16;       VAR signalrec  : SignalRecord;        VAR ierr       : Int16      );       PROCEDURE SoChargePath  
   (     urecid  : Int16;  
 
     VAR preport : Int16;  
 
     VAR gsd     : Int16;  
      VAR ierr    : Int16  );      PROCEDURE SoCleanName      (     socketnlen     : Int16;       VAR socketname     : SocketNameType );       	PROCEDURE SoCreate 	 
   (     burstin  : Int16; 
 
         incc     : Int16; 
 
         burstout : Int16; 
 
         outcc    : Int16; 
 
         sokind   : Int16; 
 
    VAR  gsd      : Int16; 
     VAR  ierr     : Int16  );       PROCEDURE SoFullStatus  
   ( VAR systotal : Int16; 
 
     VAR sysactive: Int16; 
      VAR stati    : SoStatusArrayType;       VAR ierr     : Int16 );      PROCEDURE SoInitCreate  
   (     burstin  : Int16; 
 
         incc     : Int16; 
 
         burstout : Int16; 
 
         outcc    : Int16; 
 
         sokind   : Int16; 
 
    VAR  gsd      : Int16; 
     VAR  ierr     : Int16  );       PROCEDURE SoPathRelease      (     mbufid : Int16;       VAR ierr   : Int16  );       
PROCEDURE SoPutName  
    (     tablesw        : BOOLEAN;           gsd            : Int16;       VAR nlen           : Int16;       VAR soname         : SocketNameType;        VAR namerecid      : Int16;       VAR namerec        : NameRecord;        VAR ierr           : Int16 );      	PROCEDURE SoQuery  	    ( VAR rootgsd    : Int16;       VAR rootsocket : SocketRecord;        VAR emsg       : EventMsgType;            emsglen    : Int16;       VAR wkmp       : Int16;       VAR rn         : Int16;       VAR ierr       : Int16      );       PROCEDURE SoReadSelect     (     gsd        : Int16;           rdthreshcc : Int16;       VAR ierr       : Int16  );       
PROCEDURE SoResponse 
    (    rootgsd    : Int16;       VAR emsg       : EventMsgType;      VAR ierr       : Int16   );       	PROCEDURE SoTrash  	    (    gsd     : Int16;      VAR socket  : SocketRecord );       PROCEDURE SoUpshiftName      (     socketnlen     : Int16;       VAR socketname     : SocketNameType );       PROCEDURE SoWriteSelect      (     gsd        : Int16;           wrthreshcc : Int16;       VAR ierr       : Int16 );          PROCEDURE NameFromHashTable      (     namerecid : Int16;        VAR namerec   : NameRecord );      PROCEDURE NameFromPath     (     namerecid : Int16;        VAR namerec   : NameRecord;       VAR preamble  : PathPreambleRecord);       PROCEDURE NameFromSocket     (     namerecid   : Int16;        VAR namerec     : NameRecord;       VAR socketrec   : SocketRecord );      PROCEDURE UnlinkPathFromUser     (     mbufid    : Int16;        VAR preamble  : PathPreambleRecord;       VAR urec      : UserRecord );      PROCEDURE UnlinkSocketFromUser     (     gsd       : Int16;        VAR socket    : SocketRecord;       VAR urec      : UserRecord );          $PAGE   !{----------------------------------------------------------------} ! !{                                                                } ! !{   IMPLEMENT DECLARATIONS                                       } ! !{                                                                } ! !{----------------------------------------------------------------} !     IMPLEMENT       !   {------------------------------------------------------------}  ! !   {   LOCATION CONSTANTS (FOR EVENT LOGGING)                   }  ! !   {------------------------------------------------------------}  !            CONST        LOC_300_RNRQ_ERR                    =  300;         LOC_800_NO_URECS                    =  800;         LOC_1000_NO_NAMERECS                = 1000;         LOC_1100_NO_SOCKETRECS              = 1100;         LOC_1500_NO_SBUF_MEM                = 1500;         LOC_1600_BAD_SOKIND                 = 1600;         LOC_1700_BAD_CALL_STATE             = 1700;         LOC_1701_BAD_VC_UP_CNT              = 1701;         LOC_1702_BAD_VC_STATE               = 1702;         LOC_1703_BAD_SOKIND                 = 1703;         LOC_1800_CALL_ABTIND                = 1800;         LOC_2200_IPC_INBOUND                = 2200;         LOC_2202_BAD_EMSG_KIND              = 2202;         LOC_2300_BAD_EVENT                  = 2300;         LOC_2400_CANT_SBPUT                 = 2400;         LOC_2401_CANT_SBAPPEND              = 2401;         LOC_2700_STATE_ERR                  = 2700;         LOC_3200_NAME_LINK                  = 3200;         LOC_3700_NO_PATH_MEMORY             = 3700;         LOC_4000_CANT_MREAD                 = 4000;         LOC_4001_MMGR_PROBLEMS              = 4001;         LOC_4200_CANT_SBPUT                 = 4200;         LOC_4201_CANT_SBAPPEND              = 4201;         LOC_4202_CANT_SBGET                 = 4202;         LOC_4400_CANT_SBPUT                 = 4401;         LOC_4401_CANT_SBAPPEND              = 4402;         LOC_4402_BAD_ROOT_STATE             = 4403;         LOC_4500_ROOT_STATE                 = 4500;         LOC_4501_CALL_STATE                 = 4501;         LOC_4502_SO_KIND                    = 4502;         LOC_4800_CANT_MREAD1                = 4800;         LOC_4801_CANT_MREAD2                = 4801;         LOC_4802_CANT_OVERWRITE             = 4802;       VAR      context        : ContextWords;  {for event logging}     logerr         : Int16;         {for event logging}     scratchsocket  : SocketRecord;  {scratch record that any                                       routine may use -- should                                        not be used by routines that   !                                    call other routines that also  !                                     use it}       $PAGE   !{----------------------------------------------------------------} ! !{   FORWARD AND EXTERNAL DECLARATIONS                            } ! !{----------------------------------------------------------------} !     PROCEDURE ABReg   
   ( VAR areg    : Int16;  
      VAR breg    : Int16 ); EXTERNAL;       PROCEDURE AdrOf   
   (     object  : Int16;  
 
         offset  : Int16;  
      VAR byteadr : Int16 ); EXTERNAL;       FUNCTION $DIRECT$ DS_Rsm_NextKey : Int16; EXTERNAL;       PROCEDURE DS_GoLibr; EXTERNAL;      PROCEDURE DS_GoLibx; EXTERNAL;      PROCEDURE DS_StoreUrec  
   ( VAR urec_id  : Int16; 
      VAR urec     : int16);   EXTERNAL;       FUNCTION $DIRECT$ Iand  
   ( VAR i : Int16;  
      VAR j : Int16 ): Int16; EXTERNAL;      
PROCEDURE InitGetNewSocket 
    (     sokind    : Int16;        VAR gsd       : Int16;        VAR socket    : SocketRecord;       VAR ierr      : Int16  ); FORWARD;       PROCEDURE InitSUSbufs   
   (     gsd      : Int16; 
 
         sokind   : Int16; 
      VAR socket   : SocketRecord;   
         burstin  : Int16; 
 
         incc     : Int16; 
 
         burstout : Int16; 
 
         outcc    : Int16; 
      VAR ierr     : Int16   ); FORWARD;       FUNCTION $DIRECT$ Ior      ( VAR i   : Int16;            j   : Int16  ) : Int16; EXTERNAL;      PROCEDURE IdAddToName   
   (     idaddr  : Int16;  
      VAR pname    : ProgNameType;        VAR lu       : Int16);   EXTERNAL;       
PROCEDURE IpcConnInd 
    ( VAR emsg    : EventMsgType;  
     VAR wkmp    : Int16;  
      VAR ierr    : Int16  );FORWARD;      PROCEDURE IpcSendAbortRequest      (     dnpid      : Int16;           dnpathid   : Int16;           reason     : Int16;       VAR ierr       : Int16  );FORWARD;       PROCEDURE IpcSendConnIgnored  
   (     dnpid    : Int16; 
 
         dnpathid : Int16; 
      VAR ierr     : Int16  ); FORWARD;      FUNCTION Ixget     ( address   : Int16) : Int16; EXTERNAL;      PROCEDURE Ixput      ( address  : Int16;       value    : Int16); EXTERNAL;       FUNCTION Ixor   
   ( VAR i  : Int16; 
      VAR j  : Int16  ) : Int16; EXTERNAL;       FUNCTION MyIdAdd : Int16;  EXTERNAL;      PROCEDURE ProSw      ( VAR emsg  : EventMsgType;       VAR ierr  : Int16       ); EXTERNAL;       PROCEDURE RNRQ  $ALIAS 'RNRQ', NOABORT$      (     icon  : Int16;        VAR irn   : Int16;        VAR istat : Int16 ); EXTERNAL;       $PAGE   !{----------------------------------------------------------------} ! !{   ATTACH SO TO USER                                      (100) } ! !{----------------------------------------------------------------} !     PROCEDURE AttachSoToUser { VAR urec   : UserRecord;                                  gsd    : Int16;                             VAR lsd    : Int16   };      BEGIN   lsd := urec.ur_sfree;   urec.ur_sfree := -urec.ur_smap[lsd];  
urec.ur_smap[lsd] := gsd;  
 END; {AttachSoToUser}       $PAGE   !{----------------------------------------------------------------} ! !{   DS Sat Beam Signal                                     (200) } ! !{----------------------------------------------------------------} !     PROCEDURE DS_SatBeamSignal;       {}  { Abstract:   {  Sends a "satellite beam" signal to the socket whose global    {  descriptor was passed. The signal will be sent either to the    {  socket's owner process or to its server (protocol) process   {  depending upon the direction specified.  {   
{ Input parameters:  
 {   !{  gsd: Global socket descriptor for the socket through which the  ! {     signal is to be sent.   {   {  direction: Either INBOUND_SIG (=-1) or OUTBOUND_SIG (=0)   {     depending upon whether the timer is to be sent to the   {     socket's owner or server process.   {}      VAR   
   temp     : Int16; 
     BEGIN   DS_SoFetchElement ( gsd, scratchsocket.int );   WITH scratchsocket DO      BEGIN     IF (direction = INBOUND_SIG) THEN        BEGIN         so_UserSig.er_flags[SAT_BEAMABLE] := TRUE;        END      ELSE         BEGIN         so_ProtoSig.er_flags[SAT_BEAMABLE] := TRUE;   
      END; {IF direction}  
    END; {WITH scratchsocket}  DS_Signal ( gsd, direction, scratchsocket );      END;  {DS_SatBeamSignal}      $PAGE   !{----------------------------------------------------------------} ! !{   DS_SigAwait                                            (300) } ! !{----------------------------------------------------------------} !     PROCEDURE DS_SigAwait {     gsd       : Int16;                              direction : Int16;                          VAR socket    : SocketRecord;                               rn        : Int16;                          VAR wkmp      : Int16;                          VAR ierr      : Int16  };       {}  { Abstract:   {  Blocks the caller until a signal arrives via the socket  {  specified. IPC users will choose to block awaiting inbound   {  signals and IPC servers to block awaiting outbound signals.  {  The signals upon which the caller wishes to wait must be   {  described in the X-selenable bits of the appropriate signal  {  record in the socket. If no X-selenable bits are set the   {  user will block forever.   {   
{ Input parameters:  
 {   {  gsd: Global socket descriptor of the socket upon which the   {     caller wishes to receive the signal.  {   {  direction: Either INBOUND_SIG (=-1) or OUTBOUND_SIG (=0)   {     according to the user's role as an IPC user or server.  {   {  socket: Socket record. This record will be written over the  {     previously stored copy.   {   {  rn: Resource number upon which the caller's signals are  {     generated.  {   { wkmp: Reference to the working map obtained when the caller   
{     went critical. 
 {   { Outbound parameters:  {   {  socket: Complete socket record with X-able bit(s) of the   {     signal producing event(s) set.  {    {  ierr: Returns an error if the Rnrq call used to wait for the     {     signal failed. The error will be a standard IPC error and    {     will be meaningful to IPC users.  {   { Note:   !{  Dispatch locks must be on when DS_SigAwait is called. Dispatch  ! {  locks will be on when the call completes, UNLESS ierr <> 0.  {  In this case the caller will no longer be dispatch locked.   {   {}      LABEL 99;       VAR   
   rnd      : Int16; 
     
BEGIN {DS_SigAwait}  
 IF (direction = INBOUND_SIG) THEN rnd := socket.so_b.UserRnd  ELSE rnd := socket.so_b.ProtoRnd;       DS_RNStoreElement ( rnd, rn );  DS_SoStoreElement ( gsd, socket.int );      
DS_LeaveCritical (wkmp );  
 Rnrq ( RN_AWAIT+RN_NO_ABORT_BIT, rn, ierr );     BEGIN {abort exit}   "   { Find out if NS went down, log error we have problem. Bail out } "    IpcWeAborted (ierr);      GOTO 99;   
   END; {Rnrq abort exit}  
     !{ verify we successfully locked the rn, check RNRQ status return } ! IF ierr = 3 THEN     BEGIN    { continue processing }      DS_EnterCritical( wkmp, ierr );     IF ierr = SUCCESSFUL THEN        BEGIN    { get socket record }            DS_SoFetchElement( gsd, socket.int );         END      { get socket record }       ELSE         BEGIN    { can't go critical }        ierr := U_NETWORK_IS_DOWN;        END;     { can't go critical }     END      { continue processing }     ELSE  
   BEGIN    { RNRQ error } 
    SoAttemptToLog( ENTITY_SIGMOD, LOC_300_RNRQ_ERR, 0, ierr );  
   ierr := U_INTERNALERR;  
 
   END;     { RNRQ error } 
     99:;  	END; {DS_SigAwait} 	     $PAGE   !{----------------------------------------------------------------} ! !{   DS SIGNAL                                              (400) } ! !{----------------------------------------------------------------} !     
PROCEDURE DS_Signal  
    {     gsd         : Int16;            direction   : Int16;        VAR socket      : SocketRecord };      {}  { Abstract:   {  Stores the passed socket record into the DSAM socket table.  !{  Depending upon the 'direction' specified checks the appropriate ! {  signal record and sends a signal if a signalable condition   !{  is satisfied, i.e., if any corresponding X-able and X-selenable ! "{  bits are set. No harm is done if no signalable conditions exist.  " {  Caller is expected to be in critical region.   {   
{ Input parameters:  
 {   {  gsd: Global socket descriptor of the socket record passed.   {    {  direction: Either INBOUND_SIG or OUTBOUND_SIG depending upon    {     whether the caller is awaiting an inbound or an outbound  {     signal.   {   {  socket: Socket record to be written out to DSAM.   {   { Side Effects:   {   ${  May set or clear the protocol bit map (pmap) bit corresponding to the $ !{  gsd if the signal is sent in the outbound direction. Also if a  ! {  signal is sent then then RNTable entry used will be zeroed.  {}      VAR      map            : SelBitMapType;  
   rn             : Int16; 
 
   rnd            : Int16; 
 
   signal_rnd     : Int16; 
    signalrec      : SignalRecord;   
   temp           : Int16; 
 
   ierr           : Int16; 
     BEGIN   DS_SoStoreElement ( gsd, socket.int );  IF (direction = INBOUND_SIG) THEN DS_SBCheckSel (gsd, user)   ELSE DS_SBCheckSel (gsd, proto);  END; {DS_Signal}      $PAGE   !{----------------------------------------------------------------} ! !{   DS Timer Signal                                        (500) } ! !{----------------------------------------------------------------} !     
PROCEDURE DS_TimerSignal;  
     {}  { Abstract:   {  Sends a timer signal to the socket whose global descriptor   {  was passed. The signal will be sent either to the socket's   {  owner process or to its server (protocol) process depending  {  upon the direction specified.  {   
{ Input parameters:  
 {   !{  gsd: Global socket descriptor for the socket through which the  ! {     signal is to be sent.   {   {  direction: Either INBOUND_SIG (=-1) or OUTBOUND_SIG (=0)   {     depending upon whether the timer is to be sent to the   {     socket's owner or server process.   {   !{  sigval: The kind of timer signal that should be sent. Possible  ! {     kinds include TIMERABLE_1, TIMERABLE_2, and TIMERABLE_3.   {     The constants to be used to reference the various kinds of   {     timer signals are declared in module BODEC.   {}      VAR   
   temp     : Int16; 
     BEGIN   DS_SoFetchElement ( gsd, scratchsocket.int );   WITH scratchsocket DO      BEGIN     IF (direction = INBOUND_SIG) THEN        BEGIN         so_UserSig.er_flags[sigval] := TRUE;        END      ELSE         BEGIN         so_ProtoSig.er_flags[sigval] := TRUE;   
      END; {IF direction}  
    END; {WITH socket}   DS_Signal ( gsd, direction, scratchsocket );      END;  {DS_TimerSignal}      $PAGE   !{----------------------------------------------------------------} ! !{    ENTER HASH TABLE                                      (600) } ! !{----------------------------------------------------------------} !     PROCEDURE EnterHashTable {    enter_give_table : BOOLEAN;                                 namerecid        : Int16;                             VAR namerec          : NameRecord;                             VAR ierr             : Int16       };        {}  { Abstract:   {  This procedure links the name record passed into either the  "{  GiveAway or the LookUp hash tables. The caller must have already  " !{  verified via HashFind() that the name passed in the NameRecord  ! {  isn't already entered in the table.  {    {  This call does NOT write the passed name record out to DSAM.    {  The caller must do that.   {   
{ Input Parameters:  
 {    {  namerec: The characters comprising the name in the NameRecord    {     MUST be upshifted or else later hash table searches might    {     not succeed when they should.   {   { Side Effects:    {  The hashing table will get a new entry and name_rec will have   {  its front and back pointer fields initialized when the call  	{  is successful.  	 {}      VAR      tempid      : Int16;      tempnamerec : NameRecord;      BEGIN   !{ First we must find the identity of the appropriate hash bucket's ! { header record.  {}  #LocateHashBucket ( enter_give_table, namerec.nr_name, namerec.nr_nlen, #                       tempid);       { Fetch the header record and then fill in the new NameRecord's    { linkage. Also fill in the header record's front pointer.  {}  DS_FetchElement (DS_NamesTD, tempid, tempnamerec.int);  namerec.nr_hash_fptr := tempnamerec.nr_hash_fptr;   namerec.nr_hash_bptr := tempid;   tempnamerec.nr_hash_fptr := namerecid;      { Now we fill in the back pointer of the NameRecord that the  { header record used to point to. If the header record pointed  { to itself (i.e., if the hash bucket was empty) then we try  { to minimize our DSAM fetchs.  {}  IF (tempid <> namerec.nr_hash_fptr) THEN     BEGIN      { We must store out the header record and fetch in the record       { that it previously pointed to. Note that as an optimization      { we could just do a DS_StoreFields into the new target  	   { name record.  	    {}      DS_StoreElement (DS_NamesTD, tempid, tempnamerec.int);      tempid := namerec.nr_hash_fptr;     DS_FetchElement (DS_NamesTD, tempid, tempnamerec.int);   
   END; {IF tempid}  
     tempnamerec.nr_hash_bptr := namerecid;  DS_StoreElement (DS_NamesTD, tempid, tempnamerec.int);  
ierr := SUCCESSFUL;  
 END; {EnterHashTable}       $PAGE   !{----------------------------------------------------------------} ! !{   EVALUATE OPTS                                          (700) } ! !{----------------------------------------------------------------} !     PROCEDURE EvaluateOpts ( VAR opt : OptType;                            VAR ierr: Int16   );       {}  { Abstract:   {  Used to evaluate the general format requirements of opt  {  array. Each IPC routine is responsible for evaluating  {  whether (1) the entry codes are valid for the routine,   {  (2) whether the amount of data supplied is acceptable  {  relative to the entry code.  {}      LABEL 99;       CONST      BYTES_PER_OPT_ENTRY = 8; {byte length}       VAR   
   endopt   : Int16; 
 
   i        : Int16; 
     
   PROCEDURE Escape; 
    BEGIN        ierr := U_ILLEGAL_OPTS;         GOTO 99;     END; {Escape}      BEGIN      WITH opt DO     BEGIN  
      IF ((opt_length < 0) 
 !          OR (opt_length < opt_num_entries * BYTES_PER_OPT_ENTRY)  !           OR (opt_num_entries < 0)            OR (opt_num_entries > MAX_OPT_ENTRIES)) THEN Escape;            endopt := opt_length + 5;             FOR i := 0 TO (opt_num_entries - 1) DO        BEGIN            WITH opt_entry[i] DO            BEGIN              IF (  (ent_length < 0)                    OR (ent_offset < 0)   #                  OR (ent_length + ent_offset > endopt)) THEN Escape;  #          END; {WITH opt_entry}        END; {FOR}  	   END; {WITH opt} 	    ierr := SUCCESSFUL;      99:;  
END; {EvaluateOpts}  
     $PAGE   !{----------------------------------------------------------------} ! !{   FIND USER RECORD                                       (800) } ! !{----------------------------------------------------------------} !     PROCEDURE FindUserRecord {     idaddr  : Int16;                              VAR urecid  : Int16;                              VAR urec    : UserRecord;                             VAR ierr    : Int16       };       LABEL 99;       {}  { Abstract:   {  Tries to find the user record belonging to the process   {  at id segment address idaddr. If a previously initialized  {  record is found it will be returned, if not then an attempt  {  will be made to allocate a new user record, a new resource    {  number and a new root socket for that user to synchronize on;   {  if either allocation fails then an error is returned.  {}      CONST      DS_BIT               = 512;   { DS bit in the id segment }      STATUS_WORD_OFFSET   = 15;    { Offset into id segment }       VAR   
   burstin        : Int16; 
 
   burstout       : Int16; 
    found          : BOOLEAN;  
   gsd            : Int16; 
 
   i              : Int16; 
 
   incc           : Int16; 
 
   outcc          : Int16; 
    socket         : SocketRecord;   
   temp           : Int16; 
 
   ufreeptr       : Int16; 
    urec_bucket    : UserRecord;   
   urec_bucket_id : Int16; 
     BEGIN   "   { First determine if a user record already exists for the user. } "    urec_bucket_id := ((idaddr DIV UREC_HASH_DIVISOR)                        MOD NUM_UR_BUCKETS) + 1;     urecid := urec_bucket_id;      $   { Don't let users OF a program on a single user system. This could }  $ $   { cause the urec pointers to change if abort processor is called.  }  $    DS_GoLibr;       	   found := FALSE; 	    WHILE (NOT found) AND (urecid <> NULL) DO        BEGIN         DS_UrFetchElement (urecid, urec.int);         found := urec.ur_procidaddr = idaddr;         IF NOT found THEN            urecid := urec.ur_urecptr;         END;  { WHILE }          DS_GoLibx;          IF (NOT found) THEN     BEGIN        { Try to find a free user record. If one is found then        { initialize it if possible.        {}         DS_FetchElement ( DS_TrackTD, TL_USER_FREEPTR, ufreeptr );         IF (ufreeptr = NULL) THEN            BEGIN           ierr := U_TOO_MANY_USERS;           context.longint := 0;  "         Log_Event (EL_RESOURCELIM, ENTITY_SIGMOD, LOC_800_NO_URECS, "                     context, 0, ierr, logerr);  	         GOTO 99;  	          END        ELSE {have a potential user record}            BEGIN           urecid := ufreeptr;           DS_UrFetchElement ( urecid, urec.int );           GetSignalRn ( urec.ur_rnd, urec.ur_rn );            IF (urec.ur_rnd = MEANINGLESS ) THEN   	            BEGIN  	             ierr := U_NO_RNS;   
            GOTO 99; 
 	         END; {IF} 	               { Try to allocate a root socket for the user. The root             { socket should be provided with two reserved inbound           { and outbound mbufs.           {}            burstin := 2;           burstout := 2;            incc := MMMLEN;  
         outcc := MMMLEN;  
 &         SoCreate ( burstin, incc, burstout, outcc, ROOTSOCKET, gsd, ierr);  &          IF (ierr <> SUCCESSFUL) THEN   	            BEGIN  	             ReleaseSignalRn (urec.ur_rnd, urec.ur_rn);  
            GOTO 99; 
 
            END; {IF ierr} 
               { Patch the user's resource number descriptor into the             { root socket that was just created for the user.           {}            DS_SoFetchElement ( gsd, socket.int );            socket.so_b.UserRnd := urec.ur_rnd;           socket.so_urecid := urecid;           DS_SoStoreElement ( gsd, socket.int );                urec.ur_smap[0] := gsd;           urec.ur_procidaddr := idaddr;           IdAddToName (idaddr, urec.ur_progname, temp);      #         { Move the user record from the free list to the hash table } # $         DS_StoreElement (DS_TrackTD, TL_USER_FREEPTR, urec.ur_urecptr); $     
         DS_GoLibr;  
              DS_UrFetchElement (urec_bucket_id, urec_bucket.int);            urec.ur_urecptr := urec_bucket.ur_urecptr;            urec_bucket.ur_urecptr := urecid;           DS_UrStoreElement (urec_bucket_id, urec_bucket.int);            DS_UrStoreElement (urecid, urec.int);      
         DS_GoLibx;  
              { Finally set the DS bit in the user's id segment }           temp := Ixget (idaddr + STATUS_WORD_OFFSET);            temp := Ior (temp, DS_BIT);           Ixput (idaddr + STATUS_WORD_OFFSET, temp);             END; {IF urecid}  
   END; {IF urecid = NULL} 
    ierr := SUCCESSFUL;      99:;  END; {FindUserRecord}       $PAGE   !{----------------------------------------------------------------} ! !{   FLUSH CALL VCQ                                         (900) } ! !{----------------------------------------------------------------} !     PROCEDURE FlushCallVcq   { VAR callsocket  : SocketRecord;     VAR ierr        : Int16        };      {}  { Abstract:    {  This routine should be used when performing abort processing    {  on call sockets. The routine will dequeue any VC sockets   {  which might be queued on the call socket. The state of   {  each VC socket will be examined and changed. An outbound   {  signal will be sent down through each of the VC sockets.   {  The intention is to stimulate Outpro.run into cleaning   {  up after the VC sockets.   {}      VAR      vcsd        : Int16;      vcsocket    : SocketRecord;      BEGIN   vcsd := callsocket.so_k.vcq;  WHILE (vcsd <> NULL) DO      BEGIN     DS_SoFetchElement ( vcsd, vcsocket.int );     IF (vcsocket.so_b.state = VC_ESTAB_RESPONSE_PENDING) THEN        BEGIN         vcsocket.so_b.state := VC_USER_ABORTED;         END      ELSE         BEGIN         vcsocket.so_b.state := VC_AWAITING_CLEANUP;         END;     vcsocket.so_ProtoSig.er_flags[EXCEPTIONAL] := TRUE;     DS_Signal (vcsd, OUTBOUND_SIG, vcsocket );      vcsd := vcsocket.so_giveptr;      END; {WHILE}   callsocket.so_k.vcq := NULL; {for debugging clarity}  
END; {FlushCallVcq}  
     $PAGE   !{----------------------------------------------------------------} ! !{    GET NEW NAME RECORD                                  (1000) } ! !{----------------------------------------------------------------} !     FUNCTION GetNewNameRecord { Int16};       {}  { Abstract:   {  Allocates space for a name record and returns an identifier  {  which uniquely identifies that space. If space for a name  !{  record is not available then GetNewNameRecord() returns a value ! "{  MEANINGLESS and the fact that there are no NameRecords available  " {  is logged.   {}      VAR   
   namerec  : NameRecord;  
 
   nfreeptr : Int16; 
     BEGIN   DS_FetchElement ( DS_TrackTD, TL_NAME_FREEPTR, nfreeptr );      
IF (nfreeptr = NULL) THEN  
    BEGIN     GetNewNameRecord := MEANINGLESS;      context.longint := 0;  !   Log_Event (EL_RESOURCELIM, ENTITY_SIGMOD, LOC_1000_NO_NAMERECS, !               context, 0, logerr, logerr);     END  ELSE     BEGIN     GetNewNameRecord := nfreeptr;     DS_FetchElement ( DS_NamesTD, nfreeptr, namerec.int );      nfreeptr := namerec.nr_hash_fptr;     DS_StoreElement ( DS_TrackTD, TL_NAME_FREEPTR, nfreeptr );      END; {  IF  }  END; {GetNewNameRecord}       $PAGE   !{----------------------------------------------------------------} ! !{    GET NEW SOCKET                                       (1100) } ! !{----------------------------------------------------------------} !     PROCEDURE GetNewSocket     {     sokind    : Int16;        VAR gsd       : Int16;        VAR socket    : SocketRecord;       VAR ierr      : Int16  };      {}  { Abstract:   {  Allocates local socket descriptor and indirectly a global  {  socket. Does not allocate any memory. If the socket is not    {  to be a destination socket then GetNewSocket() verifies that    {  the socket's associated sbufs aren't still in dispose mode,  {  sbufs associated with the socket aren't still in dispose   {  i.e., aren't awaiting the deallocation of previously   
{  allocated memory. 
 {   
{ Input parameters:  
 {   {  sokind: The kind of socket to be allocated.  {   "{  socket: Provided to save space. Not initialized by GetNewSocket.  " {   
{ Output parameters: 
 {   {  ierr: Possible values are:   {   {     SUCCESSFUL        U_SYS_NO_SOCKETS  	{     U_NO_MEMORY  	 {}      LABEL 99;       VAR      i                : Int16;     first_gsd        : Int16;     sb               : Int16;     sbuf             : SbufRecord;      mmflags          : MMFlagsType;     sfreeptr         : Int16;     tempsocket       : SocketRecord;       BEGIN   DS_FetchElement ( DS_TrackTD, TL_SOCKET_FREEPTR, sfreeptr );  
IF (sfreeptr = NULL) THEN  
    BEGIN     { We have no free SocketRecords at this point. We log this      { fact so that the system manager can find out and possibly     { configure more into the system.     {}      context.longint := 0;  "   Log_Event (EL_RESOURCELIM, ENTITY_SIGMOD, LOC_1100_NO_SOCKETRECS, "               context, 0, logerr, logerr);     ierr := U_SYS_NO_SOCKETS;     GOTO 99;      END; {IF sfreeptr}       gsd := sfreeptr;  	first_gsd := gsd;  	 	mmflags.int := 0;  	     { Before grabbing a socket that might be used to send and/or  { receive data we need to make sure that any buffer space   { that might have been allocated under a previous usage has   
{ all been returned. 
 {}      REPEAT     ierr := SUCCESSFUL;  
   sb := gsd + gsd;  
    DS_SBFetchElement ( sb, sbuf.int );      "   { First we check the status of the outbound sbuf. Our assumption  " !   { is that the sbuf is still in use (i.e., auto-disposing memory !     { from a previous socket incarnation) if its sb_flags.sb_init       { bit is set. If the outbound sbuf is available then we check      { the status of the inbound sbuf.     {}      IF ( sbuf.sb_flags.sb_init) THEN         BEGIN   
      ierr := U_NO_MEMORY; 
       END      ELSE         BEGIN   
      sb := sb - 1;  
       DS_SBFetchElement ( sb, sbuf.int );         IF sbuf.sb_flags.sb_init THEN ierr := U_NO_MEMORY;        END; {IF sbuf.sb_flags.sb_dispose}         DS_SoFetchElement ( gsd, socket.int );      IF ( ierr <> SUCCESSFUL ) THEN         BEGIN         gsd := socket.so_fptr;  
      END; {IF ierr} 
 UNTIL ((ierr = SUCCESSFUL) OR (gsd = first_gsd));       IF ( ierr = SUCCESSFUL) THEN     BEGIN     { We must unlink the socket from the free list.     {}      IF (socket.so_fptr = gsd) THEN         BEGIN         sfreeptr := NULL;   !      DS_StoreElement ( DS_TrackTD, TL_SOCKET_FREEPTR, sfreeptr ); !       END      ELSE         BEGIN         sfreeptr := socket.so_fptr;   !      DS_StoreElement ( DS_TrackTD, TL_SOCKET_FREEPTR, sfreeptr ); !       DS_SoFetchElement ( socket.so_fptr, tempsocket.int);        tempsocket.so_bptr := socket.so_bptr;         DS_SoStoreElement (socket.so_fptr, tempsocket.int );        DS_SoFetchElement ( socket.so_bptr, tempsocket.int );         tempsocket.so_fptr := socket.so_fptr;         DS_SoStoreElement ( socket.so_bptr, tempsocket.int );         END; {IF socket.so_fptr}  	   END; {IF ierr}  	     99:;  
END; {GetNewSocket}  
     $PAGE   !{----------------------------------------------------------------} ! !{   GET SIGNAL RN                                         (1200) } ! !{----------------------------------------------------------------} !     PROCEDURE GetSignalRn      { VAR rnd  : Int16;       VAR rn   : Int16 };      {}  { Abstract:   {  Attempts to allocate a resource number for the purpose of  {  sending and receiving signals. If allocation is successful   !{  the rn obtained is placed in the Resource number table located  ! !{  in DSAM. Rn-based signals are obtained by locking and clearing  ! {  resource numbers. This routine globally locks the resource   !{  numbers it allocates. A routine which wishes to await a signal  !  {  should attempt to lock it. Since the rn is already locked the   {  lock requester will block until a signal is sent, i.e., the  	{  rn is cleared.  	 {   
{ Output parameters: 
 {   {  rn: Allocated resource number.   {   {  rnd: Resource number descriptor -- an index into the Rn  {     Table. Returns MEANINGLESS if table full or no rns  {     available.  {}      VAR   
   ierr     : Int16; 
 
   temprnd  : Int16; 
     BEGIN   DS_RNFetchElement ( RND_FREE, rnd );  IF (rnd <> NULL ) THEN     BEGIN     Rnrq ( RN_ALLOCATE + RN_AWAIT, rn, ierr );      IF (ierr = 4) THEN         BEGIN   
      rnd := MEANINGLESS;  
       END      ELSE         BEGIN         DS_RNFetchElement ( rnd, temprnd );         DS_RNStoreElement ( RND_FREE, temprnd );        DS_RNStoreElement ( rnd, rn );  
      END; {IF ierr} 
    END  ELSE     BEGIN     rnd := MEANINGLESS;     rn := MEANINGLESS;      END; {IF rnd}  	END; {GetSignalRn} 	     $PAGE   !{----------------------------------------------------------------} ! !{    HASH FIND                                            (1300) } ! !{----------------------------------------------------------------} !     	PROCEDURE HashFind 	    {     give_table_access : BOOLEAN;        VAR socket_name       : SocketNameType;           socket_nlen       : Int16;        VAR name_id           : Int16;        VAR ierr              : Int16         };       {}  { Abstract:   {  Searches either the GiveTable or the LookUpTable to try   {  to find a NameRecord entry corresponding to the passed name.    !{  If such a record is found then a descriptor for it is returned. ! {   
{ Input parameters:  
 {   !{  give_table_access: Should be set to TRUE if the name should be  !  {     sought out in the GiveTable. Should be set to FALSE if the   {     name should be sought out in the LookUpTable.   {   "{  socket_name: Name of the socket (or path report) that the caller  " {     is interested in.   {   {  socket_nlen: Length of the passed name in characters.  {   
{ Output parameters: 
 {   !{  namerecid: Descriptor to the name record containing the passed  !  {     name. This value is only meaningful if a SUCCESSFUL result   	{     is returned. 	 {   {  result: Returns SUCCESSFUL if the record was found and   {     returns U_NAME_NOT_FOUND otherwise.   {}      VAR      found   : BOOLEAN;   
   headptr : Int16;  
 
   i       : Int16;  
    namerec : NameRecord;  
   nextptr : Int16;  
 
   temp    : Int16;  
 	   tempchr : CHAR; 	     BEGIN   %LocateHashBucket ( give_table_access, socket_name, socket_nlen, headptr);  %     DS_FetchElement ( DS_NamesTD, headptr, namerec.int );   nextptr := namerec.nr_hash_fptr;      found := FALSE;   WHILE ((NOT found) AND (nextptr <> headptr)) DO   BEGIN      DS_FetchElement ( DS_NamesTD, nextptr, namerec.int );     IF (namerec.nr_nlen = socket_nlen) THEN        BEGIN   
      found := TRUE; 
       FOR i := 1 TO socket_nlen DO           BEGIN           { In this FOR loop we compare names. The name stored            { in our hash record has long ago been shifted to           { upper case, but the name we're using as a key might  !         { have some lower case characters so we must be careful.  !          {}            tempchr := socket_name.chars[i];            temp := Ord(tempchr);           IF ((temp >= Ord('a')) AND (temp <= Ord('z'))) THEN              tempchr := Chr(temp - 32);           IF (namerec.nr_name.chars[i] <> tempchr) THEN              found := FALSE;            END; {FOR i}         END; {IF namerec}          IF found THEN name_id := nextptr      ELSE nextptr := namerec.nr_hash_fptr;  END; {WHILE}      IF found THEN ierr := SUCCESSFUL  ELSE ierr := U_NAME_NOT_FOUND;      END; {HashFind}           $PAGE   !{----------------------------------------------------------------} ! !{    INIT GET NEW SOCKET                                         } ! !{----------------------------------------------------------------} !     
PROCEDURE InitGetNewSocket 
    {     sokind    : Int16;        VAR gsd       : Int16;        VAR socket    : SocketRecord;       VAR ierr      : Int16  };      {}  { Abstract:   {  Allocates local socket descriptor and indirectly a global  {  socket. Does not allocate any memory. If the socket is not    {  to be a destination socket then GetNewSocket() verifies that    {  the socket's associated sbufs aren't still in dispose mode,  {  sbufs associated with the socket aren't still in dispose   {  i.e., aren't awaiting the deallocation of previously   
{  allocated memory. 
 {   
{ Input parameters:  
 {   {  sokind: The kind of socket to be allocated.  {   "{  socket: Provided to save space. Not initialized by GetNewSocket.  " {   
{ Output parameters: 
 {   {  ierr: Possible values are:   {   {     SUCCESSFUL        U_SYS_NO_SOCKETS  	{     U_NO_MEMORY  	 {}      LABEL 99;       VAR      i                : Int16;     first_gsd        : Int16;     sb               : Int16;     sbuf             : SbufRecord;      mmflags          : MMFlagsType;     sfreeptr         : Int16;     tempsocket       : SocketRecord;       BEGIN   DS_FetchElement ( DS_TrackTD, TL_SOCKET_FREEPTR, sfreeptr );  
IF (sfreeptr = NULL) THEN  
    BEGIN     { We have no free SocketRecords at this point. We log this      { fact so that the system manager can find out and possibly     { configure more into the system.     {}      ierr := U_SYS_NO_SOCKETS;     GOTO 99;      END; {IF sfreeptr}       gsd := sfreeptr;  	first_gsd := gsd;  	 	mmflags.int := 0;  	     { Before grabbing a socket that might be used to send and/or  { receive data we need to make sure that any buffer space   { that might have been allocated under a previous usage has   
{ all been returned. 
 {}      REPEAT     ierr := SUCCESSFUL;  
   sb := gsd + gsd;  
    DS_SBFetchElement ( sb, sbuf.int );      "   { First we check the status of the outbound sbuf. Our assumption  " !   { is that the sbuf is still in use (i.e., auto-disposing memory !     { from a previous socket incarnation) if its sb_flags.sb_init       { bit is set. If the outbound sbuf is available then we check      { the status of the inbound sbuf.     {}      IF ( sbuf.sb_flags.sb_init) THEN         BEGIN   
      ierr := U_NO_MEMORY; 
       END      ELSE         BEGIN   
      sb := sb - 1;  
       DS_SBFetchElement ( sb, sbuf.int );         IF sbuf.sb_flags.sb_init THEN ierr := U_NO_MEMORY;        END; {IF sbuf.sb_flags.sb_dispose}         DS_SoFetchElement ( gsd, socket.int );      IF ( ierr <> SUCCESSFUL ) THEN         BEGIN         gsd := socket.so_fptr;  
      END; {IF ierr} 
 UNTIL ((ierr = SUCCESSFUL) OR (gsd = first_gsd));       IF ( ierr = SUCCESSFUL) THEN     BEGIN     { We must unlink the socket from the free list.     {}      IF (socket.so_fptr = gsd) THEN         BEGIN         sfreeptr := NULL;   !      DS_StoreElement ( DS_TrackTD, TL_SOCKET_FREEPTR, sfreeptr ); !       END      ELSE         BEGIN         sfreeptr := socket.so_fptr;   !      DS_StoreElement ( DS_TrackTD, TL_SOCKET_FREEPTR, sfreeptr ); !       DS_SoFetchElement ( socket.so_fptr, tempsocket.int);        tempsocket.so_bptr := socket.so_bptr;         DS_SoStoreElement (socket.so_fptr, tempsocket.int );        DS_SoFetchElement ( socket.so_bptr, tempsocket.int );         tempsocket.so_fptr := socket.so_fptr;         DS_SoStoreElement ( socket.so_bptr, tempsocket.int );         END; {IF socket.so_fptr}  	   END; {IF ierr}  	     99:;  END; {InitGetNewSocket}       $PAGE   !{----------------------------------------------------------------} ! !{   INIT INIT SBUFS                                              } ! !{----------------------------------------------------------------} !     PROCEDURE InitSUSbufs   
   {     gsd      : Int16; 
 
         sokind   : Int16; 
      VAR socket   : SocketRecord;   
         burstin  : Int16; 
 
         incc     : Int16; 
 
         burstout : Int16; 
 
         outcc    : Int16; 
      VAR ierr     : Int16   };      {}  { Abstract:   !{  Initializes the sbufs associated with a socket. If we can't get ! !{  the amount of memory that the caller requested then we log that ! {  fact so that the nodal manager can configure more memory in  ${  next time. This routine will only be called at system initialization  $ !{  time. It doesn't log errors but otherwise does everything that  ! {  the InitSbufs() routine does.  {   
{ Input parameters:  
 {   {  burstin: The maximum number of inbound messages the user   {     ever plans to have queued on the socket.  {   {  incc: Size, in bytes, of the largest message the user  {     thinks will ever be queued inbound on the socket.   {   {  burstout: The maximum number of outbound messages the user   {     ever plans to have queued on the socket.  {   {  outcc: Size, in bytes, of the largest message the user   {     thinks will ever be queued outbound on the socket.  {}      VAR   
   ierr2    : Int16; 
 
   mc       : Int16; 
 
   mmflags  : MMFlagsType; 
 
   protosb  : Int16; 
 
   usersb   : Int16; 
     BEGIN   { Allocate memory if the socket requires it. Deallocate   { memory if we can get it for one sbuf but not the other.   {}  	mmflags.int := 0;  	 IF (sokind = VC) THEN      BEGIN     { Set option bit indicating that we're allocating     { memory for a connection.      {}      mmflags.bits[0] := TRUE;      END  ELSE IF (sokind = PATHREP_MEM) THEN      BEGIN     { Set option bit indicating that we're allocating memory      { for a special system socket.      {}      mmflags.bits[-1] := TRUE;  
   END; {IF sokind}  
     protosb := gsd + gsd;   usersb := protosb - 1;  DS_SBInit ( protosb, outcc, burstout, mmflags, mc, ierr);   DS_SBInit ( usersb, incc, burstin, mmflags, mc, ierr2 );      IF ((ierr <> SUCCESSFUL) OR (ierr2 <> SUCCESSFUL)) THEN      BEGIN     { We couldn't get the memory that we wanted. Our current      { policy is that we won't wait for memory when we're      { denied it initially. If we get more ambitious later     { we can reconsider.      {}      DS_SBRelease ( usersb,  ierr);      DS_SBRelease ( protosb, ierr2);     context.ints[1] := ierr;      context.ints[2] := ierr2;     ierr := MEANINGLESS;      END  ELSE     BEGIN     ierr := SUCCESSFUL;  	   END; {IF ierr}  	     	END; {InitSUSbufs} 	     $PAGE   !{----------------------------------------------------------------} ! !{   INIT SBUFS                                            (1500) } ! !{----------------------------------------------------------------} !     
PROCEDURE InitSbufs  
 
   {     gsd      : Int16; 
 
         sokind   : Int16; 
      VAR socket   : SocketRecord;   
         burstin  : Int16; 
 
         incc     : Int16; 
 
         burstout : Int16; 
 
         outcc    : Int16; 
      VAR ierr     : Int16   };      {}  { Abstract:   !{  Initializes the sbufs associated with a socket. If we can't get ! !{  the amount of memory that the caller requested then we log that ! {  fact so that the nodal manager can configure more memory in  {  next time.   {   
{ Input parameters:  
 {   {  burstin: The maximum number of inbound messages the user   {     ever plans to have queued on the socket.  {   {  incc: Size, in bytes, of the largest message the user  {     thinks will ever be queued inbound on the socket.   {   {  burstout: The maximum number of outbound messages the user   {     ever plans to have queued on the socket.  {   {  outcc: Size, in bytes, of the largest message the user   {     thinks will ever be queued outbound on the socket.  {}      VAR   
   ierr2    : Int16; 
 
   mc       : Int16; 
 
   mmflags  : MMFlagsType; 
 
   protosb  : Int16; 
 
   usersb   : Int16; 
     BEGIN   { Allocate memory if the socket requires it. Deallocate   { memory if we can get it for one sbuf but not the other.   {}  	mmflags.int := 0;  	 IF (sokind = VC) THEN      BEGIN     { Set option bit indicating that we're allocating     { memory for a connection.      {}      mmflags.bits[0] := TRUE;      END  ELSE IF (sokind = PATHREP_MEM) THEN      BEGIN     { Set option bit indicating that we're allocating memory      { for a special system socket.      {}      mmflags.bits[-1] := TRUE;  
   END; {IF sokind}  
     protosb := gsd + gsd;   usersb := protosb - 1;  DS_SBInit ( protosb, outcc, burstout, mmflags, mc, ierr);   DS_SBInit ( usersb, incc, burstin, mmflags, mc, ierr2 );      IF ((ierr <> SUCCESSFUL) OR (ierr2 <> SUCCESSFUL)) THEN      BEGIN     { We couldn't get the memory that we wanted. Our current      { policy is that we won't wait for memory when we're      { denied it initially. If we get more ambitious later     { we can reconsider.      {}      DS_SBRelease ( usersb,  ierr);      DS_SBRelease ( protosb, ierr2);     context.ints[1] := ierr;      context.ints[2] := ierr2;  !   Log_Event (EL_RESOURCELIM, ENTITY_SIGMOD, LOC_1500_NO_SBUF_MEM, !                context, 0, logerr, logerr);      ierr := MEANINGLESS;      END  ELSE     BEGIN     ierr := SUCCESSFUL;  	   END; {IF ierr}  	     END; {InitSbufs}      $PAGE    {--------------------------------------------------------------}    {   INIT INIT SIGNALS                                          }    {--------------------------------------------------------------}       
PROCEDURE InitInitSignals  
    (     gsd       : Int16;            sokind    : Int16;            protornd  : Int16;            userrnd   : Int16;        VAR socket    : SocketRecord;       VAR ierr      : Int16 );       {}  { Abstract:   {  Called to initialize a socket's signal records and resource  {  number descriptor fields.  {}      BEGIN   
ierr := SUCCESSFUL;  
 WITH socket DO     BEGIN     so_b.UserRnd := userrnd;      so_b.ProtoRnd := protornd;       so_UserSig.longint := 0;   {don't enable any signals to user}          { Initialize the protocol's signal record.      {}      so_ProtoSig.longint := 0;  	   CASE sokind OF  	           CALL:            BEGIN           so_protosig.er_flags[CTRL_RSELENABLE] := TRUE;            so_protosig.er_flags[XSELENABLE] := TRUE;  
         END; {CALL case}  
           IFPM:            BEGIN           so_protosig.er_flags[DATA_RSELENABLE] := TRUE;   
         END; {IFPM case}  
           VC:            BEGIN           so_ProtoSig.er_flags[CTRL_RSELENABLE] := TRUE;            so_ProtoSig.er_flags[SAT_BEAM_SELENABLE] := TRUE;           so_ProtoSig.er_flags[XSELENABLE] := TRUE;           so_ProtoSig.er_flags[TIMER_1_SELENABLE] := TRUE;            so_ProtoSig.er_flags[TIMER_2_SELENABLE] := TRUE;            so_ProtoSig.er_flags[TIMER_3_SELENABLE] := TRUE;            END;  {VC case}      	      ROOTSOCKET:  	          BEGIN           so_ProtoSig.er_flags[CTRL_RSELENABLE] := TRUE;            so_ProtoSig.er_flags[SAT_BEAM_SELENABLE] := TRUE;           so_ProtoSig.er_flags[XSELENABLE] := TRUE;           so_ProtoSig.er_flags[TIMER_1_SELENABLE] := TRUE;            so_ProtoSig.er_flags[TIMER_2_SELENABLE] := TRUE;            so_ProtoSig.er_flags[TIMER_3_SELENABLE] := TRUE;            END; {IF so_b.kind = ROOTSOCKET}       	      PATHREP_MEM: 	          BEGIN           { We don't send signals on this kind of socket.           {}            END;             OTHERWISE            BEGIN            { We were asked to initialize the signal records for an   !         { unknown socket kind. We log this as an internal error.  !          {}            ierr := U_INTERNALERR;   
         END; {OTHERWISE}  
 	      END; {CASE}  	        END; {WITH socket}       	END; {InitSignals} 	     $PAGE    {--------------------------------------------------------------}    {   INIT SIGNALS                                        (1600) }    {--------------------------------------------------------------}       PROCEDURE InitSignals      {     gsd       : Int16;            sokind    : Int16;            protornd  : Int16;            userrnd   : Int16;        VAR socket    : SocketRecord };          {}  { Abstract:   {  Called to initialize a socket's signal records and resource  {  number descriptor fields.  {}      BEGIN   WITH socket DO     BEGIN     so_b.UserRnd := userrnd;      so_b.ProtoRnd := protornd;       so_UserSig.longint := 0;   {don't enable any signals to user}          { Initialize the protocol's signal record.      {}      so_ProtoSig.longint := 0;  	   CASE sokind OF  	           CALL:            BEGIN           so_protosig.er_flags[CTRL_RSELENABLE] := TRUE;            so_protosig.er_flags[XSELENABLE] := TRUE;  
         END; {CALL case}  
           IFPM:            BEGIN           so_protosig.er_flags[DATA_RSELENABLE] := TRUE;   
         END; {IFPM case}  
           VC:            BEGIN           so_ProtoSig.er_flags[CTRL_RSELENABLE] := TRUE;            so_ProtoSig.er_flags[SAT_BEAM_SELENABLE] := TRUE;           so_ProtoSig.er_flags[XSELENABLE] := TRUE;           so_ProtoSig.er_flags[TIMER_1_SELENABLE] := TRUE;            so_ProtoSig.er_flags[TIMER_2_SELENABLE] := TRUE;            so_ProtoSig.er_flags[TIMER_3_SELENABLE] := TRUE;            END;  {VC case}      	      ROOTSOCKET:  	          BEGIN           so_ProtoSig.er_flags[CTRL_RSELENABLE] := TRUE;            so_ProtoSig.er_flags[SAT_BEAM_SELENABLE] := TRUE;           so_ProtoSig.er_flags[XSELENABLE] := TRUE;           so_ProtoSig.er_flags[TIMER_1_SELENABLE] := TRUE;            so_ProtoSig.er_flags[TIMER_2_SELENABLE] := TRUE;            so_ProtoSig.er_flags[TIMER_3_SELENABLE] := TRUE;            END; {IF so_b.kind = ROOTSOCKET}       	      PATHREP_MEM: 	          BEGIN           { We don't send signals on this kind of socket.           {}            END;             OTHERWISE            BEGIN            { We were asked to initialize the signal records for an   !         { unknown socket kind. We log this as an internal error.  !          {}            context.longint := so_b.kind;  !         Log_Event (EL_ERROR, ENTITY_SIGMOD, LOC_1600_BAD_SOKIND,  !                     context, 0, logerr, logerr);  
         END; {OTHERWISE}  
 	      END; {CASE}  	        END; {WITH socket}       	END; {InitSignals} 	     $PAGE   !{----------------------------------------------------------------} ! !{   IPC ABT CONF                                          (1700) } ! !{----------------------------------------------------------------} !     
PROCEDURE IpcAbtConf 
    { VAR emsg    : EventMsgType;  
     VAR wkmp    : Int16;  
      VAR ierr    : In16  };       {}  { Abstract:   {  This routine should be called to handle the arrival of   !{  ABORT_CONFIRM event messages at IPC's inbound protocol handler. ! {  The caller should be critical. IpcAbtConf() leaves critical  {  regardless of what happens.  {}      VAR   	   gsd    : Int16; 	 
   socket : SocketRecord;  
        PROCEDURE LogError         ( location     : Int16 );          BEGIN  
   context.longint := gsd; 
 '   Log_Event (EL_ERROR, ENTITY_SIGMOD, location, context, 0, logerr, logerr);  ' 	   END; {LogError} 	         BEGIN   ierr := SUCCESSFUL;  {assume for now}   gsd := emsg.emac_up_ref;  DS_SoFetchElement ( gsd, socket.int );  WITH socket DO     BEGIN     so_up_cnt := so_up_cnt + 1;     so_final_up := emsg.emac_msg_cnt;     ierr := SUCCESSFUL;      
   CASE so_b.kind OF 
           CALL:            BEGIN           IF (so_b.state = CALL_AWAITING_ABCONF) THEN  	            BEGIN  	             IF (so_up_cnt = so_final_up) THEN   
               BEGIN 
 !               { We've received all the emsgs we're ever going to  ! "               { receive from the LLP, therefore we can release the  "                { call socket.   	               {}  	                MakeSocketFree ( gsd, socket );  	               END 	             ELSE  
               BEGIN 
                so_b.state := CALL_COUNTING_DOWN;                 DS_SoStoreElement (gsd, socket.int);                  END; {IF so_up_cnt}              END            ELSE   	            BEGIN  	             ierr := U_INTERNALERR;              LogError (LOC_1700_BAD_CALL_STATE);               END;  
         END; {CALL case}  
           VC:            BEGIN           IF (so_b.state = VC_AWAITING_ABCONF) THEN  	            BEGIN  	             IF (so_up_cnt = so_final_up) THEN   
               BEGIN 
                MakeSocketFree (gsd, socket);  	               END 	             ELSE  
               BEGIN 
                ierr := U_INTERNALERR;                  LogError (LOC_1701_BAD_VC_UP_CNT);                  END; {IF so_up_cnt}              END            ELSE   	            BEGIN  	             ierr := U_INTERNALERR;              LogError (LOC_1702_BAD_VC_STATE);               END; {IF so_b.state}           END; {VC case}             OTHERWISE            BEGIN           ierr := U_INTERNALERR;            LogError (LOC_1703_BAD_SOKIND);  
         END; {OTHERWISE}  
 	      END; {CASE}  	    END; {WITH socket}   DS_LeaveCritical (wkmp);  	END; {IpcAbtConf}  	     $PAGE    {-------------------------------------------------------------}     {   IPC ABT IND                                        (1800) }     {-------------------------------------------------------------}        
PROCEDURE IpcAbtInd  
    { VAR emsg   : EventMsgType;        VAR wkmp  : Int16;        VAR ierr   : Int16         };      {}  { Abstract:   #{  This routine should be called by IPC's inbound protocol handler to  # "{  process ABORT_INDICATION emsgs sent up by lower level protocols.  " "{  For now the code assumes that only ABORT_INDICATIONs referencing  "  {  VC sockets will be sent up. There is some code included here    "{  that deals with CALL sockets but it is included mainly to provide "  {  hooks for system shutdown. The call socket code should not be   #{  considered correct until it has been more thouroughly investigated. # {}      LABEL 99;       VAR      abtreason       : Int16;      gsd             : Int16;      mmflags         : MMFlagsType;      response_needed : BOOLEAN;      sbufid          : Int16;      socket          : SocketRecord;      !   {-------------------------------------------------------------} ! !   {   PREPARE ABT RESP / IPC ABT IND                            } ! !   {-------------------------------------------------------------} !        PROCEDURE PrepareAbtResp;        BEGIN   
      WITH socket, emsg DO 
          BEGIN           em_event := ABORT_RESPONSE;           ehport := so_down_pid * EHS_PER + EHOB_OFFSET;            emarep_down_ref := so_down_pathref;           so_down_cnt := so_down_cnt + 1;           emarep_msg_cnt := so_down_cnt;            END; {WITH socket}         END; {PrepareAbtResp}       !   {-------------------------------------------------------------} ! !   {   CHECK REF COUNT / IPC ABT IND                             } ! !   {-------------------------------------------------------------} !        PROCEDURE CheckRefCount;         {}  	      { Abstract:  	       {  This procedure should be called to compare a socket's  "      {  current reference count against its final reference count.  " #      {  If the two are equal then the socket will be returned to the  # %      {  free list, otherwise it will be placed into the VC_COUNTING_DOWN  % $      {  state to await the arrival of all the remaining emsgs that are  $ 
      {  addressed to it.  
       {}        BEGIN   
      WITH socket DO 
          BEGIN           IF (so_up_cnt = so_final_up) THEN  	            BEGIN  	             { We've received all the event messages we're ever               { going to receive on this path. Therefore we simply               { return the socket to the free pool.               {}              MakeSocketFree (gsd, socket);               END            ELSE   	            BEGIN  	 $            { The system still contains some emsgs that are addressed to $ $            { this socket. We can't destroy the socket until all of the  $ #            { emsgs have arrived. To be save we clear and disable all  # %            { outbound signals on the socket -- we can't process outbound  % $            { events on a socket that no longer is bound to a down path. $             {}              so_b.state := VC_COUNTING_DOWN;               so_ProtoSig.longint := 0;               DS_Signal (gsd, OUTBOUND_SIG, socket);              END; {IF so_up_cnt}            END; {WITH socket}   
      END; {CheckRefCount} 
     !   {-------------------------------------------------------------} ! !   {   CLEAN AND NOTIFY / IPC ABT IND                            } ! !   {-------------------------------------------------------------} !        PROCEDURE CleanAndNotify;        BEGIN   
      WITH socket DO 
          BEGIN      !         { First we change the socket's state. This is our way of  ! "         { informing the socket's owner that the connection has been " 
         { aborted.  
          {}            so_b.state := VC_SERVER_ABORTED;       "         { We save the reason for the path's abortion in the path's  " !         { down path reference field. Note that saving the reason  !           { in this field assumes that we won't ever try to send             { another emsg down to the LLP from this socket.            {}            so_down_pathref := abtreason;           so_UserSig.er_flags[EXCEPTIONAL] := TRUE;           DS_Signal (gsd, INBOUND_SIG, socket);                { The only outbound signals that should be processed on   !         { this socket now are state change (EXCEPTIONAL) signals. !           { All other types of signals should be disabled because             { we'll no longer have a down path along which to send             { emsgs related to other kinds of signals.            {}            so_ProtoSig.longint := 0;           so_ProtoSig.er_flags[XSELENABLE] := TRUE;           DS_Signal (gsd, OUTBOUND_SIG, socket);                { We release the sbufs associated with the socket.   !         { Now that the serving protocol has informed us that the  !           { connection can't be supported we won't be needing the   !         { memory anymore. Note that any messages queued up to the ! #         { user will be destroyed at this point. We aren't supporting  #          { any type of "graceful" release at this time.            {}            sbufid := gsd + gsd;            DS_SBRelease ( sbufid, ierr );            DS_SBRelease ( sbufid - 1, ierr );       
         END; {WITH} 
       END; {CleanAndNotify}       "{-----------------------------------------------------------------}  " "{   BEGIN / IPC ABT IND                                           }  " "{-----------------------------------------------------------------}  "     BEGIN   "{ We start off by assuming that an ABORT_RESPONSE emsg will need to  " { be sent down to the supporting protocol.  {}  response_needed := TRUE;      { Extract any information that we might need to use from the  { ABORT_INDICATION emsg just recieved.  {}  gsd := emsg.emai_up_ref;  abtreason := emsg.emai_reason;      DS_SoFetchElement ( gsd, socket.int );  WITH socket DO     BEGIN     so_up_cnt := so_up_cnt + 1;     so_final_up := emsg.emai_msg_cnt;     IF (so_b.kind = CALL) THEN         BEGIN       #      { The ABORT_INDICATION references a CALL socket. This shouldn't  #       { ever happen so we return an INTERNAL ERROR code.        {   #      { Note that when we do begin to handle such cases we'll want to  # !      { remove any LookUpTable references to the call socket here. !       { This is because we don't the SocketRegistry to attempt  "      { to construct a path report from a socket whose path linkage  " "      { has been disrupted -- doing so would produce SERIOUS errors. "       {}            ierr := U_INTERNALERR;        context.longint := gsd;          Log_Event (EL_ERROR, ENTITY_SIGMOD, LOC_1800_CALL_ABTIND,                     context, 0, logerr, logerr);             {  PurgeSocketNames ( socket );         {  IF (so_up_cnt = so_final_up) THEN  	      {     BEGIN  	       {     MakeSocketFree (gsd, socket);         {     END         {  ELSE   	      {     BEGIN  	       {     DS_SoStoreElement (gsd, socket.int);        {     END; {IF so_up_cnt}         {}        DS_LeaveCritical (wkmp);        END      ELSE IF (so_b.kind = VC) THEN        BEGIN         CASE so_b.state OF               VC_ESTAB_CONFIRM_PENDING,  	         VC_OPEN:  	 	            BEGIN  	             PrepareAbtResp;               CleanAndNotify;               END; {VC_ESTAB_CONFIRM_PENDING case}      
         VC_USER_ABORTED:  
 	            BEGIN  	 #            { Finding the socket in this state is interesting because  # #            { it means that socket has just been aborted from the user # "            { side but OUTPRO hasn't yet had a chance to process the " "            { user's request. We prepare an ABORT_RESPONSE emsg and  " #            { also check to see if we've received all the emsg traffic #             { on this socket that we're ever going to recieve.              {}              PrepareAbtResp;   
            CheckRefcount; 
             END; {VC_USER_ABORTED case}                VC_AWAITING_ABCONF:  	            BEGIN  	 "            { An ABORT_INDICATION has been received in "response" to " $            { our previously issued ABORT_REQUEST. The ABORT_INDICATION  $ #            { fulfills our needs to handshake socket aborts with lower # !            { level protocols but its possible that we haven't yet ! $            { received all the emsgs that have previously been addressed $             { to our socket.              {}              response_needed := FALSE;   
            CheckRefCount; 
             END; {VC_AWAITING_ABCONF case}      	         OTHERWISE 	 	            BEGIN  	             PrepareAbtResp;               CleanAndNotify;               END; {OTHERWISE}      
         END; {CASE} 
       DS_LeaveCritical (wkmp);        IF response_needed THEN ProSw(emsg, ierr);  
      END; {IF so_b.kind}  
    END; {WITH socket}       99:;  END; {IpcAbtInd}      $PAGE   !{----------------------------------------------------------------} ! !{   IPC CON CONF                                          (1900) } ! !{----------------------------------------------------------------} !     
PROCEDURE IpcConConf 
    (     emsg   : EventMsgType;        VAR wkmp   : Int16;  
     VAR ierr   : Int16 ); 
     VAR   
   gsd     : Int16;  
 
   socket  : SocketRecord; 
     BEGIN   
ierr := SUCCESSFUL;  
 
WITH emsg, socket DO 
    BEGIN     gsd := emcc_up_ref;     DS_SoFetchElement ( gsd, socket.int );      so_up_cnt := so_up_cnt + 1;         CASE so_b.state OF             VC_ESTAB_CONFIRM_PENDING:            BEGIN           so_b.state := VC_OPEN_CONFIRMING;           so_UserSig.er_flags[EXCEPTIONAL] := TRUE;           DS_Signal ( gsd, INBOUND_SIG, socket );           END; {VC_ESTAB_CONFIRM_PENDING case}             VC_COUNTING_DOWN:            BEGIN           IF (so_up_cnt = so_final_up) THEN  	            BEGIN  	             MakeSocketFree (gsd, socket);               END            ELSE   	            BEGIN  	             DS_SoStoreElement (gsd, socket.int);              END; {IF so_up_cnt}            END; {VC_COUNTING_DOWN case}             OTHERWISE            BEGIN           { Ignore the event message -- the user must have            { either terminated or else aborted the VC socket.            {}            DS_SoStoreElement (gsd, socket.int);   
         END; {OTHERWISE}  
     	      END; {CASE}  	    DS_LeaveCritical (wkmp);      END; {WITH}  	END; {IpcConConf}  	     $PAGE   !{----------------------------------------------------------------} ! !{   IPC CONF I PATH                                       (2000) } ! !{----------------------------------------------------------------} !     PROCEDURE IpcConfIPath     { VAR emsg   : EventMsgType;        VAR wkmp   : Int16;       VAR ierr   : Int16  };       VAR      gsd       : Int16;      socket    : SocketRecord;      BEGIN   {}  { Determine the call socket that's being confirmed.   { Complete its downward path linkage. Then send the   { confirmation event message up to the using IPC level.   { Note that at this point there really isn't any need   { to waste time sending a confirmation message since  { merely changing the state of the socket and sending   { a signal would be sufficient -- might be a good   { optimization to make later on.  {}  gsd := emsg.emcip_up_ref; {call socket's gsd}   DS_SoFetchElement ( gsd, socket.int );  socket.so_up_cnt := 1;      !{ Note that our setting of the down count to one at this point is  ! "{ a little unorthodox but we do it to account for the REQUEST_IPATH  "  { that was originally sent down via a root socket. Effectively,     { we're pretending that the REQUEST_IPATH was sent down via our     { call socket -- this is the way lower level protocols perceive    { the course of events anyway.  {}  socket.so_down_cnt := 1;  socket.so_down_pathref := emsg.emcip_down_ref;  DS_SoStoreElement ( gsd, socket.int );      gsd := emsg.emcip_root_ref;   SoResponse (gsd, emsg, ierr);   
DS_LeaveCritical ( wkmp ); 
 
END; {CONFIRM_IPATH case}  
     $PAGE   !{----------------------------------------------------------------} ! !{   IPC CONN IND                                          (2100) } ! !{----------------------------------------------------------------} !     
PROCEDURE IpcConnInd 
    { VAR emsg    : EventMsgType;  
     VAR wkmp    : Int16;  
      VAR ierr    : Int16  };      {}  { Abstract:   {  Handles CONNECT_INDICATION event messages that are arrive  {  from a lower level protocol. This routine tries to allocate  {  a socket record for the new connection and initialize it.  {}  LABEL 99;       VAR   
   callsd         : Int16; 
    callsocket     : SocketRecord;      protorec       : ProtocolRecord;      replyemsg      : EventMsgType;   
   tempsd         : Int16; 
 
   vcsd           : Int16; 
    vcsocket       : SocketRecord;          PROCEDURE Escape ( reason  : Int16 );     BEGIN  	   ierr := reason; 	    GOTO 99;      END;       BEGIN   !{ Fetch the call socket that the CONNECT_INDICATION event message  ! { references. If the call socket's state is CALL_CLOSING_OUT  { then we must reject the request because the call socket's   { owner has either terminated or shut down the call socket.   {}  callsd := emsg.emci_call_ref;   DS_SoFetchElement ( callsd, callsocket.int );       	WITH callsocket DO 	    BEGIN     IF (so_b.state <> CALL_BOUND) THEN         BEGIN   !      { The call socket isn't able to accept new connect requests. ! "      { We must abort the connect request we just got. In addition,  "       { we might be able to return our call socket to the free        { pool.         {}        IF ((so_b.state = CALL_COUNTING_DOWN)              AND (so_up_cnt =so_final_up))THEN           BEGIN           { We've received all the event messages that we're            { ever going to receive from the LLP on this i-path.            {}            MakeSocketFree (callsd, callsocket);            END; {IF so_b.state}             { We must abort the offered connection because no user        { will be able to use it.         {}        DS_LeaveCritical ( wkmp );        IpcSendAbortRequest ( callsocket.so_down_pid,                               emsg.emci_down_ref,                               0, {temporary reason}                               ierr );         Escape ( SUCCESSFUL );  
      END; {IF callsocket} 
 
   END; {WITH callsocket}  
     { Check the call socket's backlog. If it is large then  { we must tell the supporting protocol to ignore it. The  { rationale here is that the connection's initiator will  { try again later when the backlog situation should be  { improved.   {}  #IF (callsocket.so_k.vcs_queued = callsocket.so_k.max_vc_backlog) THEN  #    BEGIN     DS_LeaveCritical ( wkmp );   %   IpcSendConnIgnored ( callsocket.so_down_pid, emsg.emci_down_ref,ierr);  % 
   Escape ( SUCCESSFUL );  
    END; {IF callsocket}        { Try to allocate a socket record. If none are available we must   { ignore the connection.  {}  GetNewSocket ( VC, vcsd, vcsocket, ierr );  IF (ierr <> SUCCESSFUL) THEN     BEGIN     DS_LeaveCritical ( wkmp );   %   IpcSendConnIgnored ( callsocket.so_down_pid, emsg.emci_down_ref,ierr);  % 
   Escape ( SUCCESSFUL );  
 	   END; {IF ierr}  	     { Having obtained a VC socket, we must initialize it and then   { queue it onto the call socket. Some of the values needed  { to intialize the socket must be obtained from the protocol  { record for the underlying protocol.   {}  #DS_FetchElement ( DS_ProtosTD, callsocket.so_down_pid, protorec.int);  # InitSignals ( vcsd, VC, protorec.pr_rnd, 0, vcsocket );       WITH vcsocket DO     BEGIN  
   so_b.kind := VC;  
    so_b.state := VC_ESTAB_RESPONSE_PENDING;   
   so_k.max_burstout := 0; 
 
   so_k.max_burstin := 0;  
    so_k.max_sndcc := 0;      so_k.max_rcvcc := 0;      so_urecid := MEANINGLESS;     so_giveptr := NULL;     so_namesptr := NULL;      so_down_pathref := emsg.emci_down_ref;      so_down_pid := callsocket.so_down_pid;      so_timeout := protorec.pr_default_timeout;   $   so_down_cnt := 1;  {counts the CONNECT_TEMPRESPONSE we'll send down}  $    so_up_cnt := 1;    {counts the CONNECT_INDICATION}   
   so_final_up := 0; 
    so_f.asynchmode := FALSE;     so_f.deferred_give := FALSE;      so_f.call_data := FALSE;      END; {WITH vcsocket}       { Now queue the vcsocket onto the call socket's VC queue. Then  { send an exceptional signal to the call socket's user (note   { that if the call socket has been given away then no user will    { be registered as selecting on it). Finally, prepare a   { CONNECT_TEMP_RESPONSE event message and send it down to the   { supporting protocol.  {}  DS_SoStoreElement ( vcsd, vcsocket.int );   	WITH callsocket DO 	    BEGIN     IF (so_k.vcq = NULL) THEN        BEGIN         so_k.vcq := vcsd;         END      ELSE         BEGIN   
      tempsd := so_k.vcq;  
       DS_SoFetchElement ( tempsd, vcsocket.int );         WHILE ( vcsocket.so_giveptr <> NULL ) DO           BEGIN           tempsd := vcsocket.so_giveptr;            DS_SoFetchElement ( tempsd, vcsocket.int );           END; {WHILE vcsocket}        vcsocket.so_giveptr := vcsd;        DS_SoStoreElement ( tempsd, vcsocket.int );         END; {IF so_k.vcq}     so_k.vcs_queued := so_k.vcs_queued + 1;     END; {WITH}      { The VC socket has been linked onto the call socket. Next  { we signal that the call socket is exceptional -- this will  { awaken the call socket's owner if he/she/it is suspended  !{ either in IpcRecvCn() or on an EXCEPTION select in IpcSelect().  ! {}  callsocket.so_UserSig.er_flags[EXCEPTIONAL] := TRUE;  DS_Signal ( callsd, INBOUND_SIG, callsocket );      { Finally we prepare a CONNECT_TEMPRESPONSE event message and   { send it down to the supporting protocol.  {}  	WITH replyemsg DO  	    BEGIN     em_event := CONNECT_TEMPRESPONSE;     ehport := callsocket.so_down_pid * EHS_PER + EHOB_OFFSET;     emctr_up_ref := vcsd;     emctr_down_ref := emsg.emci_down_ref;     END; {WITH replyemsg}      
DS_LeaveCritical ( wkmp ); 
 
ProSw ( replyemsg, ierr ); 
     99:;  	END; {IpcConnInd}  	     $PAGE   !{----------------------------------------------------------------} ! !{   IPC IB                                                (2200) } ! !{----------------------------------------------------------------} !     PROCEDURE IpcIB;      {}  { Abstract:   !{  This is IPC's inbound protocol handler. It receives all inbound !  {  event messages addressed to IPC. The routine doesn't do much     {  except to decide which routine should be called to handle the   
{  event message received. 
 {}      LABEL 99;       VAR   
   wkmp          : Int16;  
        PROCEDURE Escape ( result : Int16 );      BEGIN  	   ierr := result; 	    GOTO 99;      END; {Escape}      BEGIN   DS_EnterCritical ( wkmp, ierr );  context.longint := 0;   Log_Event (EL_EVENT, ENTITY_SIGMOD, LOC_2200_IPC_INBOUND,              context, 0, logerr, logerr);       CASE emsg.em_event OF          CONFIRM_IPATH:     IpcConfIpath ( emsg, wkmp, ierr );         IPATH_ABORTED:      IpcIPathAbt ( emsg, wkmp, ierr );         CONNECT_INDICATION: IpcConnInd ( emsg, wkmp, ierr );          CONNECT_CONFIRM:    IpcConConf ( emsg, wkmp, ierr );          ABORT_INDICATION:   IpcAbtInd  ( emsg, wkmp, ierr );          ABORT_CONFIRM:      IpcAbtConf ( emsg, wkmp, ierr );          OTHERWISE        BEGIN          { We didn't bargain for the kind of event message we just          { received. This is a real problem.         {}        ierr := U_INTERNALERR;        context.longint := emsg.em_event;   !      Log_Event (EL_ERROR, ENTITY_SIGMOD, LOC_2202_BAD_EMSG_KIND,  !                  context, 0, logerr, logerr);         DS_LeaveCritical (wkmp);        END; {OTHERWISE}         END; {CASE emsg.em_event}      99:;  END; {IpcIB}      $PAGE   !{----------------------------------------------------------------} ! !{   IPC IB OUTPRO                                         (2300) } ! !{----------------------------------------------------------------} !     PROCEDURE IpcIBOutpro      { VAR emsg  : EventMsgType;       VAR ierr  : Int16};      {}   { Abstract: The IPC inbound protocol handler that should be run    {  in OUTPRO. This routine pulls in little less software than   {  INPRO's IPC inbound handler does.  {}      LABEL 99;       VAR   
   wkmp          : Int16;  
     BEGIN   DS_EnterCritical ( wkmp, ierr );  CASE emsg.em_event OF          CONFIRM_IPATH:     IpcConfIpath ( emsg, wkmp, ierr );         IPATH_ABORTED:      IpcIPathAbt ( emsg, wkmp, ierr );         ABORT_INDICATION:   IpcAbtInd  ( emsg, wkmp, ierr );          ABORT_CONFIRM:      IpcAbtConf ( emsg, wkmp, ierr );          OTHERWISE        BEGIN         { We received a kind of event message that we weren't         { expecting. All we can do here is log an error.        {}        context.longint := emsg.em_event;         Log_Event (EL_ERROR, ENTITY_SIGMOD, LOC_2300_BAD_EVENT,                    context, 0, logerr, logerr);         DS_LeaveCritical (wkmp);        END; {OTHERWISE}     END; {CASE emsg.em_event}      99:;  	END; {IpcIBOutpro} 	     $PAGE   !{----------------------------------------------------------------} ! !{   IPC I PATH ABT                                        (2400) } ! !{----------------------------------------------------------------} !     PROCEDURE IpcIPathAbt      { VAR emsg   : EventMsgType;        VAR wkmp  : Int16;        VAR ierr   : Int16      };       LABEL 99;       VAR   
   mbufid   : Int16; 
 
   mc       : Int16; 
 
   mmflags  : MMFlagsType; 
 
   sbufid   : Int16; 
    vdbuf    : VectoredDataType;          PROCEDURE PanicEscape (location  : Int16 );        BEGIN         context.longint := 0;         Log_Event (EL_ERROR, ENTITY_SIGMOD, location, context,                   2, ierr, logerr);        ierr := U_INTERNALERR;        GOTO 99;        END; {PanicEscape}      BEGIN   sbufid := emsg.emia_root_ref * 2 - 1; {inbound sbuf}  AdrOf ( emsg.int, 0, vdbuf[1] );  
vdbuf[2] := EMSG_BYTE_LEN; 
 
{ mmflags.int := 0;  
 { mmflags.bits[-1] := TRUE; {don't allocate macct}   { mmflags.bits[-2] := TRUE; {don't worry abount reserved mbufs}    {}  	mmflags.int := 6;  	 mc := EMSG_BYTE_LEN; {ok to send this much}   DS_SBPut ( vdbuf, 4, sbufid, mmflags, mbufid, mc, ierr );    IF (ierr <> SUCCESSFUL) THEN PanicEscape (LOC_2400_CANT_SBPUT);        
{ mmflags.int := 0;  
 { mmflags.bits[0] := TRUE; {eom}  {}  	mmflags.int := 1;  	 DS_SBAppend ( sbufid, mbufid, SBCTRLQ, 32767, 32767,                mmflags, ierr );  !IF (ierr <> SUCCESSFUL) THEN PanicEscape (LOC_2401_CANT_SBAPPEND); !     
DS_LeaveCritical ( wkmp ); 
 99:;  	END; {IpcIpathAbt} 	     $PAGE   !{----------------------------------------------------------------} ! !{   IPC SEND ABORT REQUEST                                (2500) } ! !{----------------------------------------------------------------} !     PROCEDURE IpcSendAbortRequest      {     dnpid      : Int16;           dnpathid   : Int16;           reason     : Int16;       VAR ierr       : Int16  };       VAR      replyemsg  : EventMsgType;       BEGIN   	WITH replyemsg DO  	    BEGIN     em_event := ABORT_REQUEST;      ehport := dnpid * EHS_PER + EHOB_OFFSET;      emareq_down_ref := dnpathid;      emareq_msg_cnt := 1;      END; {WITH replyemsg}      
ProSw ( replyemsg, ierr ); 
 
END; {IpcSendAbortRequest} 
     $PAGE   !{----------------------------------------------------------------} ! !{   IPC SEND CONN IGNORED                                 (2600) } ! !{----------------------------------------------------------------} !     PROCEDURE IpcSendConnIgnored  
   {     dnpid    : Int16; 
 
         dnpathid : Int16; 
      VAR ierr     : Int16  };       VAR      replyemsg  : EventMsgType;       BEGIN   	WITH replyemsg DO  	    BEGIN     em_event := CONNECT_IGNORED;      ehport := dnpid * EHS_PER + EHOB_OFFSET;      emcig_down_ref := dnpathid;     END; {WITH replyemsg}  
ProSw ( replyemsg, ierr ); 
 
END; {IpcSendConnIgnored}  
     $PAGE   !{----------------------------------------------------------------} ! !{   IPC WE ABORTED                                        (2700) } ! !{----------------------------------------------------------------} !     PROCEDURE IPCWeAborted  ( VAR ierr:    Int16 );       {}  { The caller invokes this routine if it gets an error returned   { from an RNRQ.  IPCWeAborted finds out the current state of NS,    { and sets ierr to the proper value to be reported to the user.    {   { The routine expects NS to be in the intermediate state of   "{ shutting down.  If it is ADSINITIALIZING or ADSUNINIT this routine "  { returns U_NETWORK_IS_DOWN.  Otherwise it returns U_INTERNALERR   !{ because the routine assumes the caller got an abort return from  ! !{ RNRQ.  If the caller hit the abort return and the network is up, ! { then the caller has some kind of problem.   {   {  INPUT:  none   {  OUTPUT: ierr- IPC error number to be reported to the user.   {   {   {}      VAR      dsamstate   :     Int16;       
   BEGIN { IPCWeAborted }  
        { first get the state of DSAM from the OS space }     dsamstate := DS_StateOfDSAM;          {}      { Thes state word is designed to be read as follows:   "   {  < 0 no error: In this case we assume the caller has some other "    {              RNRQ error- and we report U_INTERNALERR.      {  >=0 NS is not init, is coming up, going down, or there's a   #   {      problem in DSAM with parity errors:  Report NETWORK_IS_DOWN. #    {     {}          IF dsamstate < 0 THEN        BEGIN    { internal_error }             ierr := U_INTERNALERR;  $      SoAttemptToLog( ENTITY_SIGMOD, LOC_2700_STATE_ERR, 0, dsamstate);  $       END      { internal_error }        ELSE         BEGIN    { net is down }            ierr := U_NETWORK_IS_DOWN;        END;     { net is down }      
   END;  { IPCWeAborted }  
     $PAGE   !{----------------------------------------------------------------} ! !{    LINK NAME TO FREE LIST                               (2750) } ! !{----------------------------------------------------------------} !     PROCEDURE LinkNameToFreeList     {     name_rec_id : Int16;        VAR namerec     : NameRecord  };       {}  { Abstract:    {  Returns space that was allocated for the NameRecord uniquely    {  identifiable by the NameRecord id passed. Note that this   !{  routine only modifies some of the linkage fields of the passed  ! {  NameRecord, it does not write the NameRecord out to DSAM.  {}      VAR      nfreeptr    : Int16;      tempnamerec : NameRecord;      BEGIN   WITH namerec DO      BEGIN      { TESTBED: To ease debugging we fill in the NameRecord's name   "   { field with a value of "BLANK". This step isn't really necessary "    { but helps when visually inspecting NameRecords.     {}      nr_name.chars := 'BLANK   ';   !   DS_FetchElement ( DS_TrackTD, TL_NAME_FREEPTR, nr_hash_fptr );  !    nr_namesptr := NULL;      nr_hash_bptr := NULL;     nr_socketd := NULL;     END; {WITH}  DS_StoreElement ( DS_TrackTD, TL_NAME_FREEPTR, name_rec_id );   
END; {LinkNameToFreeList}  
     $PAGE   !{----------------------------------------------------------------} ! !{    LOCATE HASH BUCKET                                   (2800) } ! !{----------------------------------------------------------------} !     
PROCEDURE LocateHashBucket 
    {     give_table  : BOOLEAN;        VAR name        :SocketNameType;            nlen        : Int16;        VAR headptr     : Int16  };      {}  { Abstract:    {  Both the LookUpTable and GiveTable are hash tables whose hash    {  buckets have 'header name records.' This routine returns the     {  name record identifier of the header name record of the only    {  bucket in which the passed name might be found.  {   
{ Input parameters:  
 {    {  give_table: Set to TRUE if the caller wants to search for the    {     name in the GiveTable. Set to FALSE if the caller wants to   {     search for the name in the LookUpTable.   {   {  name: The name the caller wants to search for.   {   {  nlen: The length of the name in characters.  {   
{ Output parameter:  
 {   !{  headptr: Name record id of the header record of the hash bucket ! {     in which the passed name might be found.  {}      VAR      hashbucket : Int16;     i          : Int16;      BEGIN   hashbucket := 1;   FOR i := 1 TO nlen DO hashbucket := name.bytes[i] + hashbucket;        	IF give_table THEN 	    BEGIN     hashbucket := (hashbucket MOD LAST_GIVE_BUCKET) + 1;      DS_FetchElement ( DS_GiveBsTD, hashbucket, headptr );     END  ELSE {search name binding table}     BEGIN      hashbucket := (hashbucket MOD LAST_NAME_BINDING_BUCKET) + 1;       DS_FetchElement ( DS_NameBsTD, hashbucket, headptr );     END; {  IF  }      END; {LocateHashBucket}       $PAGE   !{---------------------------------------------------------------}  ! !{   MAKE SOCKET FREE                                     (2900) }  ! !{---------------------------------------------------------------}  !     PROCEDURE MakeSocketFree  
   {     gsd      : Int16; 
      VAR socket   : SocketRecord };       {}  { Abstract:   !{  Releases all memory allocated to the socket. Unbinds any names  !  {  that are bound to the socket. Links the socket on to the free    {  socket list. This routine assumes that all references to this   !{  socket have been expunged from the socket owner's user record.  ! {   { WARNING: Even though releasing a socket involves also   {     releasing that socket's sbufs, this doesn't mean that   {     the memory manager won't continue trying to send signals  {     related to those sbufs. This is a real problem when   {     the socket's sbufs are auto-disposed. For this reason   {     it is important that a socket's X-SELENABLE bits be   {     cleared before the socket's sbufs are released and for   {     the entire time that the sbufs are in the disposing state.   {}      VAR      ierr       : Int16;     sb         : Int16;     listhead   : Int16;     tempsocket : SocketRecord;       BEGIN   PurgeSocketNames ( socket );      WITH socket DO     BEGIN         { Doubly link socket onto the free list.      {}       DS_FetchElement ( DS_TrackTD, TL_SOCKET_FREEPTR, listhead );       IF (listhead = NULL) THEN        BEGIN         so_fptr := gsd;         so_bptr := gsd;         DS_StoreElement ( DS_TrackTD, TL_SOCKET_FREEPTR, gsd );         END      ELSE         BEGIN   
      so_fptr := listhead; 
       DS_SoFetchElement ( listhead, tempsocket.int );         so_bptr := tempsocket.so_bptr;        tempsocket.so_bptr := gsd;        DS_SoStoreElement ( listhead, tempsocket.int );         DS_SoFetchElement ( so_bptr, tempsocket.int );        tempsocket.so_fptr := gsd;        DS_SoStoreElement ( so_bptr, tempsocket.int );        END; {IF listhead}             {}      { Zero out parts of the socket record to ease debugging.      {}   	   so_urecid := 0; 	 	   so_b.kind := 0; 	    so_down_pathref := 0;     so_b.state := SOCKET_FREE;          { Clear out the socket's signal records. Make sure that     { the protocol bit map -- the pmap -- via which OUTPRO      { detects reportable events gets cleared.     {}      so_UserSig.longint := 0;      so_protosig.longint := 0;     DS_Signal (gsd, OUTBOUND_SIG, socket );         { Return any memory that was allocated to the socket.     { We assume that no harm is done if the socket's sbufs      { are released when they aren't initialized. This     { simplifies exception handling for routines like     { IpcCreate.      {}       
   sb := gsd + gsd;  
    DS_SBRelease ( sb,  ierr );     DS_SBRelease ( sb-1,  ierr);      END; {WITH socket}       END; {MakeSocketFree}       $PAGE   !{----------------------------------------------------------------} ! !{   NAME FROM HASH TABLE                                  (3000) } ! !{----------------------------------------------------------------} !     PROCEDURE NameFromHashTable   
   {    namerecid : Int16; 
     VAR namerec   : NameRecord};      VAR      tempnamerec : NameRecord;      BEGIN   WITH namerec DO      BEGIN  !   DS_FetchElement ( DS_NamesTD, nr_hash_bptr, tempnamerec.int );  !    tempnamerec.nr_hash_fptr := nr_hash_fptr;  !   DS_StoreElement ( DS_NamesTD, nr_hash_bptr, tempnamerec.int );  ! !   DS_FetchElement ( DS_NamesTD, nr_hash_fptr, tempnamerec.int );  !    tempnamerec.nr_hash_bptr := nr_hash_bptr;  !   DS_StoreElement ( DS_NamesTD, nr_hash_fptr, tempnamerec.int );  ! 	   END; {  WITH  } 	 END; {NameFromHashTable}      $PAGE   !{----------------------------------------------------------------} ! !{   NAME FROM PATH                                        (3100) } ! !{----------------------------------------------------------------} !     PROCEDURE NameFromPath     {     namerecid : Int16;        VAR namerec   : NameRecord;       VAR preamble  : PathPreambleRecord};       VAR      tempnamerec : NameRecord;     tempnameid  : Int16;       BEGIN   
WITH preamble, namerec DO  
    BEGIN     IF ( pa_namesptr = namerecid ) THEN        BEGIN         pa_namesptr := nr_namesptr;         END      ELSE {name is linked farther down}         BEGIN         tempnameid := pa_namesptr;        REPEAT  #         DS_FetchElement ( DS_NamesTD, tempnameid, tempnamerec.int );  #       UNTIL (tempnamerec.nr_namesptr = namerecid);        tempnamerec.nr_namesptr := nr_namesptr;   !      DS_StoreElement ( DS_NamesTD, tempnameid, tempnamerec.int ); !       END; {IF pa_namesptr}      END; {WITH preamble}   
END; {NameFromPath}  
     $PAGE   !{----------------------------------------------------------------} ! !{   NAME FROM SOCKET                                      (3200) } ! !{----------------------------------------------------------------} !     PROCEDURE NameFromSocket     {     namerecid   : Int16;        VAR namerec     : NameRecord;       VAR socketrec   : SocketRecord };      {}  { Abstract:   {  This routine may be called to unlink name records that are   {  known to be linked onto a socket's name list.  {   
{ Input parameters:  
 {    {  namerecid: The name record descriptor for the name record to    {     be unlinked from the socket's name list.  {   {  namerec: The name record to be unlinked from the list.   {    {  socketrec: The socket record from which the name record is to   	{     be unlinked. 	 {}      VAR   
   done        : BOOLEAN;  
    ierr        : Int16;      td          : TableDescriptorType;      tempnamerec : NameRecord;     tempnameid  : Int16;           BEGIN   
WITH socketrec, namerec DO 
    BEGIN     IF ( so_namesptr = namerecid ) THEN        BEGIN         so_namesptr := nr_namesptr;         END      ELSE {name is linked farther down}         BEGIN         tempnameid := so_namesptr;      #      { TESTBED: The search loop below should probably be replaced by  #       { one of the memory manager's search routines.        {}        DS_FetchTableDescriptor (DS_NamesTD, td, ierr);         ierr := ( - td.td_maxelement);  
      done := FALSE; 
       REPEAT  #         DS_FetchElement ( DS_NamesTD, tempnameid, tempnamerec.int );  #          IF (tempnamerec.nr_namesptr = namerecid) THEN  	            BEGIN  	             { We've found in the socket's name record list the  !            { record that precedes the one that we want to unlink. !             {}              tempnamerec.nr_namesptr := nr_namesptr;   #            DS_StoreElement (DS_NamesTD, tempnameid, tempnamerec.int); # 
            done := TRUE;  
             END            ELSE   	            BEGIN  	             tempnameid := tempnamerec.nr_namesptr;              ierr := ierr + 1;               END; {IF tempnamerec}         UNTIL (done) OR (ierr = 0);         IF (ierr = 0) THEN           BEGIN           context.longint := namerecid;            Log_Event (EL_ERROR, ENTITY_SIGMOD, LOC_3200_NAME_LINK,                       context, 0, logerr, logerr);           ierr := U_INTERNALERR;            END; {IF ierr}             END; {IF so_namesptr}          END; {WITH}  END; {NameFromSocket}       $PAGE   !{----------------------------------------------------------------} ! !{   PURGE SOCKET NAMES                                    (3300) } ! !{----------------------------------------------------------------} !     PROCEDURE PurgeSocketNames { VAR socket : SocketRecord };       {}  { Abstract:    {  Removes any name records that exist in either the LookUpTable   {  or the GiveTable that reference the passed socket. These   {  name records can be easily found by following the socket's   {  so_namesptr NameRecord chain.  {   !{  Although this routine might modify the so_namesptr field of the ! !{  socket record, it will not write the socket record out to DSAM. !  {  Responsibility for writting the socket out is left up to the    {  caller.  {}      VAR   
   namerecid      : Int16; 
    namerec        : NameRecord;       BEGIN   WITH socket DO     BEGIN     WHILE ( so_namesptr <> NULL ) DO         BEGIN         namerecid := so_namesptr;         DS_FetchElement ( DS_NamesTD, namerecid, namerec.int );         NameFromHashTable (namerecid, namerec );        NameFromSocket (namerecid, namerec, socket);        LinkNameToFreeList (namerecid, namerec );         DS_StoreElement (DS_NamesTD, namerecid, namerec.int);   	      END; {WHILE} 	    END; {WITH socket}   END; {PurgeSocketNames}       $PAGE   !{----------------------------------------------------------------} ! !{   RELEASE SIGNAL RN                                     (3400) } ! !{----------------------------------------------------------------} !     
PROCEDURE ReleaseSignalRn  
 
   {  rnd  : Int16;  
       rn   : Int16  };      VAR   
   temprnd  : Int16; 
 
   ierr     : Int16; 
     BEGIN   Rnrq ( RN_DEALLOCATE, rn, ierr );   DS_RNFetchElement ( RND_FREE, temprnd );  DS_RNStoreElement ( rnd, temprnd );   DS_RNStoreElement ( RND_FREE, rnd );  END; {ReleaseSignalRn}      $ PAGE $  PROCEDURE SoAttemptToLog  (    caller_entity   :  Int16;       caller_location :  Int16;       caller_context  :  Int16;       caller_ierr     :  Int16 );      {}  {  ABSTRACT:  {    Attempt to go critical and call Log_Event to report error  {    information to the user.   {   {    If cannot enter critical, do nothing.  {}  VAR      context     :  ContextWords;      ret_value   :  Int16;     wkmap       :  Int16;         BEGIN    {SoAttemptToLog}         DS_EnterCritical( wkmap, ret_value );     IF ret_value = SUCCESSFUL THEN         BEGIN    { report the error }             context.longint := caller_context;        Log_Event( EL_ERROR, caller_entity, caller_location,                         context, 2, caller_ierr, ret_value );            DS_LeaveCritical( wkmap );        END;     { report the error }          END;     {SoAttemptToLog}      $PAGE   !{----------------------------------------------------------------} ! !{   SO AWAIT SIG                                          (3600) } ! !{----------------------------------------------------------------} !     
PROCEDURE SoAwaitSig 
    {     gsd        : Int16;           direction  : Int16;       VAR signalrec  : SignalRecord;        VAR ierr       : Int16      };       {}  { Abstract:   {  May be used to wait for any type of defined signal on  {  any of the system's sockets. This call saves a copy of   {  a signal record's "x_selenable" bits, assigns new  {  x_selenable bits as defined by the caller, blocks, resumes,  {  returns the socket record found at resumption, and then  {  restores the x_selenable bits as they originally appeared.   {   
{ Input parameters:  
 {    {  gsd: Global socket descriptor of the socket through which the   {     awaited signals will be sent.   {   !{  direction: Should be set to either INBOUND_SIG or OUTBOUND_SIG  ! {     depending upon whether the caller wishes to wait for  {     inbound or outbound signals.  {   {  signalrec: Signal record with x_seleable bits set for each   {     type of signal the caller is interested in.   {   
{ Output parameters: 
 {   !{  signalrec: The complete signal record as it appeared after the  ! {     caller's process resumed execution after blocking.  {   {  ierr: Returns SUCCESSFUL or else an IPC error.   {}      LABEL         89,         99;       VAR      tempsignalrec  : SignalRecord;      socket         : SocketRecord;      urec           : UserRecord;   
   urecid         : Int16; 
 
   wkmp           : Int16; 
     BEGIN   DS_EnterCritical ( wkmp, ierr );  
IF ierr <> SUCCESSFUL THEN 
    BEGIN    { can't go critical }      ierr := U_NETWORK_IS_DOWN;      GOTO 99;      END;     { can't go critical }       FindUserRecord ( MyIdAdd, urecid, urec, ierr );   IF (ierr <> SUCCESSFUL) THEN     BEGIN    { can't find urec }   
   ierr := U_INTERNALERR;  
    GOTO 89;      END;     { can't find urec }       DS_SoFetchElement ( gsd, socket.int );  IF (direction = INBOUND_SIG) THEN      BEGIN     tempsignalrec := socket.so_UserSig;     socket.so_UserSig.er_ints[2] := signalrec.er_ints[2];     END  ELSE     BEGIN     tempsignalrec := socket.so_ProtoSig;      socket.so_ProtoSig.er_ints[2] := signalrec.er_ints[2];      END; {IF direction}       DS_SigAwait (  gsd, direction, socket, urec.ur_rn, wkmp, ierr);    IF (ierr <> SUCCESSFUL) THEN GOTO 99;   { Note we are no longer critical if ierr <> SUCCESSFUL }      IF (direction = INBOUND_SIG) THEN      BEGIN     socket.so_UserSig.er_ints[2] := tempsignalrec.er_ints[2];     END  ELSE     BEGIN     socket.so_UserSig.er_ints[2] := tempsignalrec.er_ints[2];     END;   DS_SoStoreElement ( gsd, socket.int );      89:   
DS_LeaveCritical ( wkmp ); 
     99:;  	END; {SoAwaitSig}  	     $PAGE   !{----------------------------------------------------------------} ! !{   SO CHARGE PATH                                        (3900) } ! !{----------------------------------------------------------------} !     PROCEDURE SoChargePath  
   {     urecid  : Int16;  
 
     VAR preport : Int16;  
 
     VAR gsd     : Int16;  
      VAR ierr    : Int16  };      {}  { Abstract:   {  Tries to put the passed path report into DSAM storage area.   {  The full length of the path report can be computed using the     {  length word in the path report itself. Mbufs occupied by the     {  path report shall be charged against the special path memory    {  socket. The user record index of the path report's intended   {  owner is passed so that it can be stored in the path report's   {  preamble.  {   
{ Input Parameters:  
 {    {  preport: The first word of the path report. Must be passed by   !{     reference so the address of the path report can be obtained. ! {     Passing the first word makes possible the referencing of  {     path reports that are contained in opt arrays.  {}      LABEL 99;       VAR   
   i              : Int16; 
    mmflags        : MMFlagsType;  
   pathsb         : Int16; 
    preamble       : PathPreambleRecord;      vdbuf          : VectoredDataType;           BEGIN   { Prepare a new path preamble.  {}  WITH preamble DO     BEGIN     pa_urecid := urecid;      pa_namesptr := NULL;      pa_giveptr := NULL;  
   pa_ref_cnt := 1;  
    END; {WITH preamble}       { Determine the identity of the sbuf against which  { our preamble and path report should be charged when    { being placed into DSAM. We always charge path reports against    
{ the inbound sbuf.  
 {}  DS_FetchElement ( DS_TrackTD, TL_PATH_SOCKET, pathsb );   pathsb := pathsb + pathsb - 1;      { Compute a data vector which references both the preamble  { and the path report.  {}  AdrOf ( preamble.int, 0, vdbuf[1] );  vdbuf[2] := PATH_PREAMBLE_SIZE;   AdrOf ( preport, 0, vdbuf[3] );   vdbuf[4] := preport + 2;      { Try to put the path report and preamble into DSAM.  { Tell the memory manager that the required space   { may be drawn from the general pool, that no overhead  { memory should be allocated, and that the sbuf pool may  { be completely depleted. If memory is immediately  { unavailable then we don't wait around -- as an enhancement  { we could block to wait for a while but this would be much   	{ more difficult.  	 {}      { mmflags.int := 0;  {structured constant probably better}  
{ mmflags.bits[0] := TRUE; 
 { mmflags.bits[-1] := TRUE;   { mmflags.bits[-2] := TRUE;   {}  	mmflags.int := 6;  	 i := MAX_PATHREP_BYTES;   DS_SBPut ( vdbuf, 8, pathsb, mmflags, gsd, i, ierr );   IF (ierr <> SUCCESSFUL) THEN     BEGIN  
   context.longint := gsd; 
 #   Log_Event (EL_RESOURCELIM, ENTITY_SIGMOD, LOC_3700_NO_PATH_MEMORY,  #               context, 2, ierr, logerr);     ierr := U_NO_MEMORY;      GOTO 99;   	   END; {IF ierr}  	         { Generate the global descriptor that we'll use as the  { sbuf's handle. Put this descriptor into the user's  	{ descriptor map.  	 {}  
gsd := gsd + DST_BOUNDARY; 
     99:;  
END; {SoChargePath}  
     $PAGE   !{----------------------------------------------------------------} ! !{   SO CLEAN NAME                                         (3800) } ! !{----------------------------------------------------------------} !     PROCEDURE SoCleanName      {     socketnlen     : Int16;       VAR socketname     : SocketNameType };       {}  { Abstract:   {  Removes and blanks and/or commas from a randomly generated   {  socket name. These characters can produce problems when  {  trying to pass a randomly generated name in a run string.  {  The routine converts spaces to exclamation points and  {  commas to hyphens.   {}      VAR   	   i     : Int16;  	     BEGIN   FOR i := 1 TO socketnlen DO      BEGIN     { We want to replace all blanks, commas, and nulls from     { our name string so that users can successfully pass such      { names in program runstrings.      {}      IF (Ord(socketname.chars[i]) = 0) THEN         BEGIN         socketname.chars[i] := '$';         END      ELSE IF (   (socketname.chars[i] = ',')              OR (socketname.chars[i] = ' ')) THEN        BEGIN          socketname.chars[i] := Chr(Ord(socketname.chars[i]) + 1);    
      END; {IF Ord}  
    END; {FOR i}   	END; {SoCleanName} 	     $PAGE   !{----------------------------------------------------------------} ! !{   SO CREATE                                             (3900) } ! !{----------------------------------------------------------------} !     	PROCEDURE SoCreate 	 
   {     burstin  : Int16; 
 
         incc     : Int16; 
 
         burstout : Int16; 
 
         outcc    : Int16; 
 
         sokind   : Int16; 
 
    VAR  gsd      : Int16; 
     VAR  ierr     : Int16  };       {}  { Abstract:   {  This routine may be called to create special system sockets  {  like root and path-memory sockets. Such sockets have no  {  true owners and are not bound to a single user.  {   	{ Synchronization: 	 {  Caller should already be in a critical region.   {   
{ Input parameters:  
 {   {  burstin: The maximum number of messages the user will  {     ever need to have queued inbound on the socket.   {   {  incc: The maximum number of bytes that the largest   {     inbound message will contain.   {   {  burstout: The maximum number of messages the user will   {     want to have queued outbound on the socket.   {   {  outcc: The maximum number of bytes that the largest  {     outbound message will contain.  {}      LABEL 99;       VAR      socket   : SocketRecord;   
   wkmp    : Int16;  
     BEGIN   GetNewSocket ( sokind, gsd, socket, ierr );   IF ( ierr <> SUCCESSFUL ) THEN GOTO 99;       { Try to allocate as much memory as the caller claimed is   { needed. If we can't get what the caller requested then  !{ we return an error and expect the caller to handle the problem.  ! {}  InitSbufs ( gsd, sokind, socket,  
            burstin, incc, 
             burstout, outcc,  
            ierr );  
 IF ( ierr <> SUCCESSFUL ) THEN  BEGIN      { We couldn't get enough memory to satisfy our caller's      { needs so we release the socket to the free pool and return       { an error.     {}      MakeSocketFree (gsd, socket);     ierr := U_NO_MEMORY;      GOTO 99;   END; {IF ierr}      { If we got memory for the socket then we need to initialize  { the socket's signal records. Note that we pass in a value of  { zero as the user's rnd because in this case the socket won't  
{ have a true owner. 
 {}  InitSignals ( gsd, sokind, RND_OUTBOUND, 0, socket);      WITH socket DO     BEGIN     so_urecid := NULL;      so_b.kind := sokind;      IF (sokind = ROOTSOCKET) THEN so_b.state := ROOT_CLEAR;     so_down_pathref := NULL;      so_down_pid := NULL;      so_namesptr := NULL;      so_giveptr := NULL;     IF (sokind = ROOTSOCKET) THEN        BEGIN         so_b.state := ROOT_CLEAR;         END      ELSE IF (sokind = IFPM) THEN         BEGIN         so_b.state := 1;  !      so_down_pid := RASP; {IFPM is going to use the PID for CNO's ! !                            RASP protocol -- we should change this !                             if 1000's ever support RASP}        END; {IF sokind}     END; {WITH}      DS_SoStoreElement ( gsd, socket.int );      99:;  END; {SoCreate}       $PAGE   !{----------------------------------------------------------------} ! !{   SO FULL STATUS                                               } ! !{----------------------------------------------------------------} !     PROCEDURE SoFullStatus  
   { VAR systotal : Int16; 
 
     VAR sysactive: Int16; 
      VAR stati    : SoStatusArrayType;       VAR ierr     : Int16 };      {}  { Abstract:    {  This routine reports how many sockets are currently active in   {  the system.  {   
{ Output Parameters: 
 {   {  systotal: The total number of potentially active sockets in  {     the system, i.e., the number of SocketRecords the system  {     was originally configured with.   {   {  sysactive: The total number of sockets that are currently  {     active in the system. This total includes ROOT sockets   {     which in some cases are permanently configured for use by    {     the NS monitors and protocols.  {    {  stati: An array indexed by all possible socket kinds (socket    {     kind constants are declared in SODEC.PAS). The value of   {     stati[X] shows how many sockets of kind X are currently   {     active.   {   {  ierr: Returns either SUCCESSFUL or else the error that was   {     returned from the DS_EnterCritical() call needed before   {     the sockets could be accessed.  {}      LABEL 99, 100;      VAR   
   i        : Int16; 
 
   kind     : Int16; 
 
   kindword : AnyWordType; 
 
   wkmp     : Int16; 
     BEGIN   DS_EnterCritical (wkmp, ierr);  IF (ierr <> SUCCESSFUL) THEN GOTO 100;      DS_FetchGlobal (DS_SBTotal, 1, systotal);    FOR i := FIRST_SOCKET_KIND TO LAST_SOCKET_KIND DO stati[i] := 0;       FOR i := FIRST_GSD TO (systotal DIV 2) DO      BEGIN  !   DS_SoFetchFields (i, kindword.int, SOCKET_KIND_WORD_OFFSET, 1); !    kind := kindword.bytes[1];   $   IF ((kind >= FIRST_SOCKET_KIND) AND (kind <= LAST_SOCKET_KIND)) THEN  $       BEGIN         stati[kind] := stati[kind] + 1;         END      ELSE IF (kind <> 0) THEN         BEGIN   !      { The socket isn't a kind we know about and it doesn't seem  !       { to be free either.  This shouldn't happen.        {}        ierr := U_INTERNALERR;        GOTO 99;  
      END; {IF kind} 
    END; {FOR i}   99: DS_LeaveCritical (wkmp);      100:;   
END; {SoFullStatus}  
     $PAGE   !{----------------------------------------------------------------} ! !{   SO INIT CREATE                                               } ! !{----------------------------------------------------------------} !     PROCEDURE SoInitCreate  
   {     burstin  : Int16; 
 
         incc     : Int16; 
 
         burstout : Int16; 
 
         outcc    : Int16; 
 
         sokind   : Int16; 
 
    VAR  gsd      : Int16; 
     VAR  ierr     : Int16  };       {}  { Abstract:   {  This routine may be called at initialization time to create  {  special system sockets like root and path-memory sockets.  !{  Such sockets have no true owners and are not bound to a single  !  {  user. SoInitCreate() doesn't log errors and so should not be    {  used at any time other than initialization.  {   	{ Synchronization: 	 {  Caller should already be in a critical region.   {   
{ Input parameters:  
 {   {  burstin: The maximum number of messages the user will  {     ever need to have queued inbound on the socket.   {   {  incc: The maximum number of bytes that the largest   {     inbound message will contain.   {   {  burstout: The maximum number of messages the user will   {     want to have queued outbound on the socket.   {   {  outcc: The maximum number of bytes that the largest  {     outbound message will contain.  {}      LABEL 99;       VAR      socket   : SocketRecord;   
   wkmp    : Int16;  
     BEGIN   InitGetNewSocket ( sokind, gsd, socket, ierr );   IF ( ierr <> SUCCESSFUL ) THEN GOTO 99;       { Try to allocate as much memory as the caller claimed is   { needed. If we can't get what the caller requested then  !{ we return an error and expect the caller to handle the problem.  ! {}  InitSUSbufs ( gsd, sokind, socket,  
            burstin, incc, 
             burstout, outcc,  
            ierr );  
 IF ( ierr <> SUCCESSFUL ) THEN     BEGIN     { We couldn't get enough memory to satisfy our caller's     { needs so return an error. Note that because this error      { occurred during initialization we conclude that something     { is seriously wrong and therefore don't try to recover.      {}      ierr := U_NO_MEMORY;      GOTO 99;   	   END; {IF ierr}  	     { If we got memory for the socket then we need to initialize  { the socket's signal records. Note that we pass in a value of  { zero as the user's rnd because in this case the socket won't  
{ have a true owner. 
 {}  InitInitSignals ( gsd, sokind, RND_OUTBOUND, 0, socket, ierr);  IF (ierr <> SUCCESSFUL) THEN GOTO 99;       WITH socket DO     BEGIN     so_urecid := NULL;      so_b.kind := sokind;      IF (sokind = ROOTSOCKET) THEN so_b.state := ROOT_CLEAR;     so_down_pathref := NULL;      so_down_pid := NULL;      so_namesptr := NULL;      so_giveptr := NULL;     IF (sokind = ROOTSOCKET) THEN        BEGIN         so_b.state := ROOT_CLEAR;         END      ELSE IF (sokind = IFPM) THEN         BEGIN         so_b.state := 1;  !      so_down_pid := RASP; {IFPM is going to use the PID for CNO's ! !                            RASP protocol -- we should change this !                             if 1000's ever support RASP}        END; {IF sokind}     END; {WITH}      DS_SoStoreElement ( gsd, socket.int );      99:;  
END; {SoInitCreate}  
     $PAGE   !{----------------------------------------------------------------} ! !{   SO PATH RELEASE                                       (4000) } ! !{----------------------------------------------------------------} !     PROCEDURE SoPathRelease   
   {     mbufid  : Int16;  
      VAR ierr    : Int16 };       {}  { Abstract:   !{  This procedure may be called to decrement the reference counts  ! #{  on path reports. The DSAM copy of the path report will be destroyed # {  if its reference count goes to zero.   {}      LABEL 99;       VAR   
   mmflags  : MMFlagsType; 
    preamble : PathPreambleRecord;          PROCEDURE PanicEscape ( location : Int16 );        BEGIN         context.longint := mbufid;        Log_Event (EL_ERROR, ENTITY_SIGMOD, location,                    context, 2, ierr, logerr);         ierr := U_INTERNALERR;        GOTO 99;  
      END; {Escape}  
     BEGIN   
ierr := SUCCESSFUL;  
 	mmflags.int := 0;  	 mmflags.bits[0] := TRUE;  #DS_MRead (preamble.int, PATH_PREAMBLE_SIZE, mbufid, 0, mmflags, ierr); #  IF (ierr <> SUCCESSFUL) THEN PanicEscape (LOC_4000_CANT_MREAD);        preamble.pa_ref_cnt := preamble.pa_ref_cnt - 1;   IF (preamble.pa_ref_cnt = 0) THEN      BEGIN  #   { We can destroy the path report since nobody is using it anymore.  #    {}      DS_MDispose (mbufid, ierr);     END  ELSE     BEGIN  #   DS_MBOverWrite(preamble.int, PATH_PREAMBLE_SIZE, mbufid, 0, ierr);  #    END;   !IF (ierr <> SUCCESSFUL) THEN PanicEscape (LOC_4001_MMGR_PROBLEMS); !     99:;  
END; {SoPathRelease} 
     $PAGE   !{----------------------------------------------------------------} ! !{   SO PUT NAME                                           (4100) } ! !{----------------------------------------------------------------} !     
PROCEDURE SoPutName  
    {     tablesw     : BOOLEAN;            gsd         : Int16;        VAR nlen        : Int16;        VAR soname      : SocketNameType;       VAR namerecid   : Int16;        VAR namerec     : NameRecord;       VAR ierr        : Int16 };       LABEL 99;       VAR   	   i     : Int16;  	        PROCEDURE Escape (error : Int16 );         BEGIN   
      ierr := error; 
       GOTO 99;  
      END; {Escape}  
     BEGIN   IF ((nlen < 0) OR (nlen > MAX_SOCKET_NAMELEN)) THEN      Escape (U_ILLEGAL_NAME_LENGTH);      	IF (nlen = 0) THEN 	    BEGIN     nlen := 8;      REPEAT         FOR i := 1 TO 4 DO soname.ints[i] := DS_Rsm_NextKey;        SoCleanName (8, soname);        SoUpShiftName (8, soname);        HashFind (tablesw, soname, 8, namerecid, ierr);      UNTIL (ierr = U_NAME_NOT_FOUND);      END  ELSE     BEGIN     { We've been passed a name and we must make sure it isn't     { already entered into one of the hash tables.      {}      SoUpshiftName (nlen, soname);     HashFind (tablesw, soname, nlen, namerecid, ierr);       IF (ierr <> U_NAME_NOT_FOUND) THEN Escape (U_DUPLICATE_NAME);   	   END; {IF nlen}  	     namerecid := GetNewNameRecord;  IF (namerecid = MEANINGLESS) THEN Escape (U_NAME_TABLE_FULL);       WITH namerec DO      BEGIN     nr_name := soname;   
   nr_nlen := nlen;  
    nr_socketd := gsd;      END; {WITH namerec}      EnterHashTable (tablesw, namerecid, namerec, ierr);       99:;  END; {SoPutName}      $PAGE   !{----------------------------------------------------------------} ! !{   SO QUERY                                              (4200) } ! !{----------------------------------------------------------------} !     	PROCEDURE SoQuery  	    { VAR rootgsd    : Int16;       VAR rootsocket : SocketRecord;        VAR emsg       : EventMsgType;            emsglen    : Int16;       VAR wkmp       : Int16;       VAR rn         : Int16;       VAR ierr       : Int16        };       {}  { Abstract:   !{  Sends the emsg passed down through the referenced root socket.  ! 
{  Waits for a reply emsg. 
 {   	{ Synchronization: 	 {  Call MUST be in a critical region when calling.  {   
{ Input parameters:  
 {   {  wkmp: Working map value returned when caller went critical.  {   {  rn: Resource number upon which to await the reply signal.  {   
{ Output parameters: 
 {    {  ierr: If not SUCCESSFUL then an internal error has occurred.    {   { Side Effects:   {  This routine will leave the caller NO LONGER CRITICAL if   {  ierr <> SUCCESSFUL on return.  {}      LABEL 99;       CONST   
   INFINITY = 32767; 
     VAR   
   m        : Int16; 
 
   mc       : Int16; 
 
   mmflags  : MMFlagsType; 
 
   readcc   : Int16; 
 
   sbufid   : Int16; 
 
   temp     : Int16; 
    vdbuf    : VectoredDataType;          PROCEDURE PanicEscape (location : Int16);     BEGIN     context.longint := rootgsd;     Log_Event (EL_ERROR, ENTITY_SIGMOD, location, context,                 2, ierr, logerr);      {}      { Leave critical. we hit an error, caller will expect     { us not to be critical if ierr <> SUCCESSFUL.      {}      DS_LeaveCritical( wkmp );     GOTO 99;      END; {PanicEscape}           BEGIN   AdrOf ( emsg.int, 0, vdbuf[1] );  
vdbuf[2] := emsglen; 
     { Store the root socket in case it was written into by  { the caller.   {}  DS_SoStoreElement ( rootgsd, rootsocket.int );      { Charge the event message against the root socket's outbound   { sbuf. Set the mmflags bits for the call to DS_SBPut   { to reflect that we're merely sending an event message and   { not line data.  {}  sbufid := rootgsd + rootgsd;      
{ mmflags.int := 0;  
 { mmflags.bits[-1] := TRUE;   { mmflags.bits[-2] := TRUE;   {}  	mmflags.int := 6;  	 mc := emsglen; {max character length}   DS_SBPut ( vdbuf, 4, sbufid, mmflags, m, mc, ierr);    IF (ierr <> SUCCESSFUL) THEN PanicEscape (LOC_4200_CANT_SBPUT);        	mmflags.int := 0;  	 #DS_SBAppend ( sbufid, m, SBCTRLQ, INFINITY, INFINITY, mmflags, ierr ); # !IF (ierr <> SUCCESSFUL) THEN PanicEscape (LOC_4201_CANT_SBAPPEND); !     {}  { Enable signal on the inbound sbuf's control queue so that   { we can receive the reply from the serving protocol.   {}  DS_SoFetchElement ( rootgsd, rootsocket.int );  	WITH rootsocket DO 	    BEGIN     so_UserSig.longint := 0;      so_UserSig.er_flags[CTRL_RSELENABLE] := TRUE;     so_b.state := ROOT_TRANSACTING;     END; {WITH socket}        DS_SigAwait ( rootgsd, INBOUND_SIG, rootsocket, rn, wkmp, ierr);   IF (ierr <> SUCCESSFUL) THEN GOTO 99;   %{ DS_SigAwait has already called Log_Event if an error occurs. Bail Out }  %     { Retreive the reply from the inbound sbuf's queue.   {}  sbufid := sbufid - 1;   mmflags.bits[-1] := TRUE; {sets the "get message" bit}  
readcc := MAX_USER_BYTES;  
     {BEGIN WORKAROUND: until DS_SBPut stops wiping out vdbuf}   AdrOf ( emsg.int, 0, vdbuf[1] );  {END WORKAROUND:  2-12}       DS_SBGET ( vdbuf, 4, sbufid, SBCTRLQ, mmflags, readcc, ierr );   IF (ierr <> SUCCESSFUL) THEN PanicEscape (LOC_4202_CANT_SBGET);        DS_SoFetchElement ( rootgsd, rootsocket.int );  rootsocket.so_UserSig.er_flags[CTRL_RSELENABLE] := FALSE;   rootsocket.so_b.state := ROOT_CLEAR;      99:;  END; {SoQuery}      $PAGE   !{----------------------------------------------------------------} ! !{   SO READ SELECT                                        (4300) } ! !{----------------------------------------------------------------} !     PROCEDURE SoReadSelect     {     gsd        : Int16;           rdthreshcc : Int16;       VAR ierr       : Int16  };       {}  { Abstract:   {  This routine is provided for protocols that wish to issue   {  read selects directly against the sockets that they support.    {  The call may be used either to enable or to disable the  {  DATA_READABLE signal associated with a socket's outbound   {  sbuf. If the caller disables the signal then OUTPRO's  {  event dispatch software will not generate and send   {  SEND_REQUEST event messages down to the supporting protocol  {  regardless of the amount of data queued on the socket's  	{  outbound sbuf.  	 {    {  If the caller chooses to enable the DATA_READABLE signal then   {  the outbound sbuf's sb_newcc field will be set to zero and    {  its sb_rdthresh field set to rdthreshcc. These settings will    {  result in the memory manager sending a DATA_READABLE signal   {  either when rdthreshcc new characters or the end of a message   {  have been appended to the sbuf.  {   
{ Input parameters:  
 {   !{  gsd: The global socket descriptor of the socket whose outbound  ! !{     DATA_READBLE signal the caller wishes to enable or disable.  ! {    {  rdthreshcc: Set to MEANINGLESS (= -1) if the caller wishes to   "{     disable the signal. Set to a non-negative value if the caller  " {     wishes to read select for rdthreshcc new characters.  {   {  ierr: Returns SUCCESSFUL or else an error code.  {}      VAR   
   sbuf     : SbufRecord;  
 
   sbufid   : Int16; 
    socket   : SocketRecord;       BEGIN   DS_SoFetchElement ( gsd, socket.int );  
WITH socket, sbuf DO 
    BEGIN     IF ( rdthreshcc = MEANINGLESS ) THEN         BEGIN          { Caller wants to disable read selecting. We turn the read   !      { select enable bit off now and then later call DS_Signal()  !        { to write out the socket and possibly clear the Pmap that   !      { OUTPRO's event dispatcher scans to find reportable events. !       {}        so_ProtoSig.er_flags[DATA_RSELENABLE] := FALSE;         END      ELSE         BEGIN         { The caller wants to enable read selecting. We set the         { signal record's read select enable bit and then adjust        { the sbuf's read threshold. And finally we check to see        { if the socket might not already be readable under the         { new criteria.         {}        so_ProtoSig.er_flags[DATA_RSELENABLE] := TRUE;        so_ProtoSig.er_flags[DATA_READABLE] := FALSE;   
      sbufid := gsd + gsd; 
       DS_SBFetchElement ( sbufid, sbuf.int );         sb_rdthresh := rdthreshcc;  
      sb_newcc := 0; 
       DS_SBStoreElement ( sbufid, sbuf.int );   
      END; {IF rdthreshcc} 
        END; {WITH}  DS_Signal ( gsd, OUTBOUND_SIG, socket );  
ierr := SUCCESSFUL;  
 
END; {SoReadSelect}  
     $PAGE   !{----------------------------------------------------------------} ! !{   SO RESPONSE                                           (4400) } ! !{----------------------------------------------------------------} !     
PROCEDURE SoResponse 
 
   {     rootgsd : Int16;  
      VAR emsg    : EventMsgType;       VAR ierr    : Int16        };      {}  { Abstract:   !{  This routine should be called by server modules when they have  ! !{  an event message response ready to be queued inbound on a root  ! {  socket. The root socket's state is checked. Normally, the  !{  event message is queued onto its inbound sbuf, but if the root  ! "{  socket's owner terminated while the response was being generated  " {  then the root socket is destroyed.   {}      LABEL 99;       VAR   
   sbufid   : Int16; 
 
   mbufid   : Int16; 
 
   mc       : Int16; 
 
   mmflags  : MMFlagsType; 
    socket   : SocketRecord;      vdbuf    : VectoredDataType;          PROCEDURE PanicEscape ( location  : Int16 );             BEGIN         context.longint := rootgsd;         Log_Event (EL_ERROR, ENTITY_SIGMOD, location,                    context, 2, ierr, logerr);         ierr := U_INTERNALERR;        GOTO 99;        END; {PanicEscape}      BEGIN   DS_SoFetchElement (rootgsd, socket.int);  
ierr := SUCCESSFUL;  
 IF (socket.so_b.state = ROOT_DOWNED) THEN      BEGIN  !   { The root socket's owner has terminated. We should destroy the ! !   { socket now that the response event message that was due on it ! 	   { has arrived.  	    {}      MakeSocketFree (rootgsd, socket);     END  ELSE IF (socket.so_b.state = ROOT_TRANSACTING) THEN      BEGIN     socket.so_b.state := ROOT_RESPONDED;      DS_SoStoreElement (rootgsd, socket.int);      sbufid := rootgsd * 2 - 1; {inbound sbuf}     AdrOf ( emsg.int, 0, vdbuf[1] );      vdbuf[2] := EMSG_BYTE_LEN;          { mmflags.int := 0;     { mmflags.bits[-1] := TRUE; {don't allocate macct}   !   { mmflags.bits[-2] := TRUE; {don't worry about reserved mbufs}  !    {}   
   mmflags.int := 6; 
    mc := EMSG_BYTE_LEN; {ok to send this much}     DS_SBPut ( vdbuf, 4, sbufid, mmflags, mbufid, mc, ierr );  !   IF (ierr <> SUCCESSFUL) THEN PanicEscape (LOC_4400_CANT_SBPUT); !        { mmflags.int := 0; {clear all bits}      { mmflags.bits[0] := TRUE; {end of message}     {}   
   mmflags.int := 1; 
 #   DS_SBAppend (sbufid, mbufid, SBCTRLQ, 32767, 32767, mmflags, ierr); # #   IF (ierr <> SUCCESSFUL) THEN PanicEscape (LOC_4401_CANT_SBAPPEND);  #    END  ELSE     BEGIN     PanicEscape (LOC_4402_BAD_ROOT_STATE);      END; {IF socket.so_b.state}  99:;  	END; {SoResponse}  	     $PAGE   !{----------------------------------------------------------------} ! !{   SO TRASH                                              (4500) } ! !{----------------------------------------------------------------} !     	PROCEDURE SoTrash  	 
   {     gsd     : Int16;  
      VAR socket  : SocketRecord };      {}  { Abstract:   {  This routine handles the initial stages of aborting ROOT,  !{  CALL, and VC sockets. SoTrash() will be called by IpcShutDown() ! {  as well as the Abort Processor.  {}      VAR   
   ierr     : Int16; 
        PROCEDURE PanicError (location  : Int16 );         BEGIN         context.longint := gsd;         Log_Event (EL_ERROR, ENTITY_SIGMOD, location, context,                   0, gsd, logerr);         ierr := U_INTERNALERR;        END;          BEGIN   WITH socket DO     BEGIN  
   CASE so_b.kind OF 
     	      ROOTSOCKET:  	          BEGIN           IF ((so_b.state = ROOT_CLEAR) OR                (so_b.state = ROOT_RESPONDED)) THEN  	            BEGIN  	             MakeSocketFree (gsd, socket);               END            ELSE IF (so_b.state = ROOT_TRANSACTING) THEN   	            BEGIN  	             so_b.state := ROOT_DOWNED;              DS_SoStoreElement (gsd, socket.int);              END            ELSE   	            BEGIN  	             { Internal error.               {}              PanicError (LOC_4500_ROOT_STATE);               END; {IF so_b.state}  
         END; {ROOT case}  
           CALL:            BEGIN           PurgeSocketNames ( socket );            IF (so_b.state = CALL_BINDING) THEN  	            BEGIN  	             so_b.state := CALL_BUD_NIPPED;              DS_SoStoreElement (gsd, socket.int);              END            ELSE IF (so_b.state = CALL_BOUND) THEN   	            BEGIN  	             so_b.state := CALL_CLOSING_OUT;               so_ProtoSig.er_flags[EXCEPTIONAL] := TRUE;              DS_Signal (gsd, OUTBOUND_SIG, socket);              END            ELSE IF (so_b.state = CALL_CLOSING_IN) THEN  	            BEGIN  	             so_b.state := CALL_AWAITING_CLEANUP;              so_ProtoSig.er_flags[EXCEPTIONAL] := TRUE;              DS_Signal (gsd, OUTBOUND_SIG, socket);              END            ELSE   	            BEGIN  	             { Internal error.               {}              PanicError (LOC_4501_CALL_STATE);               END; {IF so_b.state}  
         END; {CALL case}  
           VC:            BEGIN           PurgeSocketNames (socket);   "         { Clear all the X-able bits. The only possible signal that  " !         { we might want the protocols to receive at this point is !          { an exceptional signal.            {}            so_protosig.er_ints[1] := 0;            IF (so_b.state = VC_SERVER_ABORTED ) THEN  	            BEGIN  	             { Looks like the IPC inbound stub beat us to the              { punch and has already aborted the socket.               {}              IF (so_final_up = so_up_cnt) THEN   
               BEGIN 
                { We'll let the server do the cleanup.   	               {}  	                so_b.state := VC_AWAITING_CLEANUP;                  so_protosig.er_flags[EXCEPTIONAL] := TRUE;   	               END 	             ELSE  
               BEGIN 
                { The IPC inbound stub hasn't yet received                  { all the event messages that will ever be                  { delivered to the socket.   	               {}  	                so_b.state := VC_COUNTING_DOWN;                 END; {IF so_final_up}              END            ELSE IF (so_b.state = VC_EMERGING) THEN  	            BEGIN  	             { Note that this case is somewhat involved. A                { CONNECT_REQUEST emsg referencing our VC socket is                 { still queued on a CALL socket somewhere. We can't                { release the VC socket until the CONNECT_REQUEST               { referencing it has been purged from the system.   "            { Note also that the overall system would be simplified  "             { if we made changes so that CONNECT_REQUESTs were  "            { sent down through the VCs that they referenced instead "             { of through CALL sockets.              {}              so_b.state := VC_BUD_NIPPED;              END            ELSE   	            BEGIN  	             { We must tell the server that we want to abort.              {}              so_protosig.er_flags[EXCEPTIONAL] := TRUE;              so_b.state := VC_USER_ABORTED;              END; {IF socket.so_b.state}            DS_Signal (gsd, OUTBOUND_SIG, socket);            END; {VC case}             OTHERWISE            BEGIN  
         { Internal error. 
          {}            PanicError (LOC_4502_SO_KIND);   
         END; {OTHERWISE}  
     	      END; {CASE}  	    END; {WITH}  END; {SoTrash}      $PAGE   !{----------------------------------------------------------------} ! !{   SO UPSHIFT NAME                                       (4600) } ! !{----------------------------------------------------------------} !     PROCEDURE SoUpshiftName      {     socketnlen     : Int16;       VAR socketname     : SocketNameType };       {}  { Abstract:    {  This routine upshifts any lower case characters appearing in    {  a socket name to upper case.   {}      VAR   	   i     : Int16;  	 	   temp  : Int16;  	     BEGIN   FOR i := 1 TO socketnlen DO      BEGIN     temp := Ord(socketname.chars[i]);     IF ((temp >= Ord('a')) AND (temp <= Ord('z'))) THEN        socketname.chars[i] := Chr(temp-32);     END; {FOR i}   
END; {SoUpshiftName} 
     $PAGE   !{----------------------------------------------------------------} ! !{   SO WRITE SELECT                                       (4700) } ! !{----------------------------------------------------------------} !     PROCEDURE SoWriteSelect      {     gsd        : Int16;           wrthreshcc : Int16;       VAR ierr       : Int16  };       {}  { Abstract:   "{  This call is mainly useful for protocols that support end-to-end  " {  flow control. SoWriteSelect() allows protocol handlers to  {  issue write selects directly against the sockets that they.  "{  support. The call may be used either to enable or to disable the  " {  WRITEABLE signal associated with a socket's inbound sbuf.  {   "{  If the caller chooses to enable the signal then an event message, " {  a WSELECT_NOTIFICATION, will be generated and sent down to   "{  the socket's supporting protocol when a certain "write threshold" "  {  number of characters have been read out or released from the     {  socket's inbound sbuf. If the caller disables the signal then   {  OUTPRO's event dispatch software will not generate and send  {  WSELECT_NOTIFICATION event messages down to the supporting   "{  protocol regardless of the amount of buffer space that has become " {  free on the socket's inbound sbuf.   {   {  If the caller chooses to enable the WRITEABLE signal then   {  the inbound sbuf's sb_wrthresh field will be set wrthreshcc.    {  These settings will result in the memory manager sending a   !{  WRITEABLE signal when the value of sb_dropcc is >= sb_wrthresh. ! !{  This condition should arise when the total number of characters !  {  read out of the inbound sbuf by the socket's owner reaches or   {  exceeds sb_dropcc characters.  {   
{ Input parameters:  
 {   !{  gsd: The global socket descriptor of the socket whose outbound  ! {     WRITEABLE signal the caller wishes to enable or disable.  {    {  wrthreshcc: Set to MEANINGLESS (= -1) if the caller wishes to   "{     disable the signal. Set to a non-negative value if the caller  " {     wishes to write select for wrthreshcc new characters.   {   {  ierr: Returns SUCCESSFUL or else an error code.  {}      VAR   
   sbuf     : SbufRecord;  
 
   sbufid   : Int16; 
    socket   : SocketRecord;       BEGIN   DS_SoFetchElement ( gsd, socket.int );  
WITH socket, sbuf DO 
    BEGIN     IF ( wrthreshcc = MEANINGLESS ) THEN         BEGIN   !      { Caller wants to disable write selecting. We turn the write ! !      { select enable bit off now and then later call DS_Signal()  !        { to write out the socket and possibly clear the Pmap that   !      { OUTPRO's event dispatcher scans to find reportable events. !       {}        so_ProtoSig.er_flags[WSELENABLE] := FALSE;        END      ELSE         BEGIN         { The caller wants to enable write selecting. We set the         { signal record's write select enable bit and then adjust           { the sbuf's write threshold. And finally we check to see          { if the socket might not already be writeable under the        { new criteria.         {}        so_ProtoSig.er_flags[WSELENABLE] := TRUE;         sbufid := gsd + gsd - 1; {inbound sbufid}         DS_SBFetchElement ( sbufid, sbuf.int );         sb_wrthresh := wrthreshcc;        DS_SBStoreElement ( sbufid, sbuf.int );   "      so_ProtoSig.er_flags[WRITEABLE] := (sb_dropcc >= sb_wrthresh); " 
      END; {IF wrthreshcc} 
        END; {WITH}  DS_Signal ( gsd, OUTBOUND_SIG, socket );  
ierr := SUCCESSFUL;  
 
END; {SoWriteSelect} 
     $PAGE   !{----------------------------------------------------------------} ! !{   UNLINK PATH FROM USER                                 (4800) } ! !{----------------------------------------------------------------} !     PROCEDURE UnlinkPathFromUser  
   {    mbufid   : Int16;  
     VAR preamble : PathPreambleRecord;      VAR urec     : UserRecord    };       {}  { Abstract:   {  Unlinks a path report from the user record of the user   {  that gave the path report away.  {   
{  Input parameters: 
 {   {     mbufid: Identifier of the mbuf which contains the path  {        report which was given away.   {   {     preamble: Path preamble that was extracted from the mbuf  {        referenced by mbufid.  {   {     urec: User record of the user that originally gave the  
{        path report away. 
 {}      LABEL 99;       VAR      ierr         : Int16;     mmflags      : MMFlagsType;     temppreamble : PathPreambleRecord;      tempmbufid   : Int16;         PROCEDURE PanicEscape ( location : Int16 );        BEGIN         context.longint := mbufid;        Log_Event (EL_ERROR, ENTITY_SIGMOD, location, context,                   2, ierr, logerr);        GOTO 99;        END; {PanicEscape}          BEGIN   IF ( urec.ur_pa_giveptr = mbufid ) THEN      BEGIN     urec.ur_pa_giveptr := preamble.pa_giveptr;      END  ELSE     BEGIN     tempmbufid := urec.ur_pa_giveptr;  
   mmflags.int := 0; 
    mmflags.bits[0] := TRUE; {preview bit}   !   DS_MRead ( temppreamble.int, PATH_PREAMBLE_SIZE, tempmbufid, 0, !               mmflags, ierr);   "   IF (ierr <> SUCCESSFUL) THEN PanicEscape (LOC_4800_CANT_MREAD1);  "        WHILE ( temppreamble.pa_giveptr <> mbufid ) DO         BEGIN         tempmbufid := temppreamble.pa_giveptr;  "      DS_MRead (temppreamble.int, PATH_PREAMBLE_SIZE, tempmbufid, 0, "                 mmflags, ierr );  #      IF (ierr <> SUCCESSFUL) THEN PanicEscape (LOC_4801_CANT_MREAD2); # 	      END; {WHILE} 	    temppreamble.pa_giveptr := preamble.pa_giveptr;  "   DS_MBOverWrite (temppreamble.int, PATH_PREAMBLE_SIZE, tempmbufid, "                    0, ierr );   #   IF (ierr <> SUCCESSFUL) THEN PanicEscape (LOC_4802_CANT_OVERWRITE); # END; {IF}   urec.ur_give_cnt := urec.ur_give_cnt - 1;   99:;  
END; {UnlinkPathFromUser } 
     $PAGE   !{----------------------------------------------------------------} ! !{   UNLINK SOCKET FROM USER                               (4800) } ! !{----------------------------------------------------------------} !     PROCEDURE UnlinkSocketFromUser     {    gsd    : Int16;       VAR socket : SocketRecord;      VAR urec   : UserRecord    };       {}  { Abstract:   {  The socket, sd, was previously given away by user, urec.   {  This routine unlinks socket from urec.   {}      VAR      tempsocket   : SocketRecord;      tempsd       : Int16;      BEGIN   IF ( urec.ur_so_giveptr = gsd ) THEN     BEGIN     urec.ur_so_giveptr := socket.so_giveptr;      END  ELSE     BEGIN     tempsd := urec.ur_so_giveptr;     DS_SoFetchElement (tempsd, tempsocket.int );      WHILE ( tempsocket.so_giveptr <> gsd ) DO        BEGIN         tempsd := tempsocket.so_giveptr;        DS_SoFetchElement ( tempsd, tempsocket.int );   	      END; {WHILE} 	    tempsocket.so_giveptr := socket.so_giveptr;     DS_SoStoreElement ( tempsd, tempsocket.int );     END; {IF}  urec.ur_give_cnt := urec.ur_give_cnt - 1;   
socket.so_giveptr := NULL; 
 END; { UnlinkSocketFromUser }           
END. {OF SIGMOD IMPLEMENT} 
