 $PASCAL '91790-16178 REV.4010 <851125.2000>'  
$Standard_Level 'HP1000'$  
 $Debug$   $Heap 0$  $Recursive Off$   $Range Off$       PROGRAM PRDC1;      {------------------------------------------------------------        (c) COPYRIGHT HEWLETT PACKARD COMPANY 1986. ALL RIGHTS    RESERVED. NO PART OF THIS PROGRAM MAY BE PHOTOCOPIED,   REPRODUCED OR TRANSLATED TO ANOTHER PROGRAM LANGUAGE WITHOUT    THE PRIOR WRITTEN CONSENT OF THE HEWLETT-PACKARD COMPANY.       ------------------------------------------------------------}      {}  
{       NAME: PRDC1  
 
{     SOURCE: 91790-18178  
 
{      RELOC: 91790-16178  
 	{       PGMR: TDS  	 {}      {}  {------------------------------------------------------------   { MODIFICATIONS:  {   {   Date    PCO   Prgmr    Description  {   {   {------------------------------------------------------------   {}      {}  { PROGRAM DESCRIPTION:  {    {   This is the Network File Transfer File Lister program. It is   {   called by the NFT Producer when the Producer notices that    {   the user given source file name is a mask. This program has    {   no segments.  {   !{   Given a file mask, generate a list of file and directory names ! "{   which match that mask and place them in a file. Return the name  " #{   of the file and the number of files and the number of directories  # "{   that were placed in the file. The main reason that this code was " !{   not incorporated in the producer program is that the Fmp calls ! #{   needed for this are huge (about 13 pages) and they would not fit.  # {   
{ INPUT PARAMETERS:  
 {    {     The only input parameter is a string following the program    {     name. This gives the user file mask that should be used to   {     generate a list of file and directory names. The string   {     must be a file mask and not a file name.  {   
{ OUTPUT PARAMETERS: 
 {   !{     There are three numeric parameters returned to the producer  ! {     using the PRTN system routine:  {       [1] NFT protocol error code.  {       [2] FMP error code.   "{       [3] The number of files that matched the mask and therefore  " {           whose names are in the list file.    {       [4] The number of directories that matched the mask and    {           therefore whose names are in the list file.   {   "{     Along with these numeric returns, a string is returned to the  " "{     producer (using the EXEC string return call), which gives the  " #{     name of the list file. The file is closed by us so the Producer  # 
{     must open it.  
 {   "{     If the NFT Protocol error code is non-zero, or if no files or  " !{     directories matched the mask then the scratch file will not  ! "{     be present, and the producer should not attempt to pick up the " {     name of the scratch file.   {}      $Page   #{-------------------------------------------------------------------}  # #{                          GLOBAL LABELS                            }  # #{-------------------------------------------------------------------}  #     LABEL      99;   { Labels end of program }          #{-------------------------------------------------------------------}  # #{                             IMPORT                                }  # #{-------------------------------------------------------------------}  #     IMPORT         $SEARCH 'phtm/BODEC.REL'$  BODEC,     $SEARCH 'phtm/SODEC.REL'$  SODEC,     $SEARCH 'phtm/MMDEC.REL'$  MMDEC,     $SEARCH 'phtm/MMEXT.REL'$  DS_MM,     $SEARCH 'phtm/TRCMOD.REL'$ TRCMOD;           #{-------------------------------------------------------------------}  # #{                         GLOBAL CONSTANTS                          }  # #{-------------------------------------------------------------------}  #     CONST      { Include the common NFT constant declarations }      $Include 'src/NFTCONSTS.PASI'         { Miscellaneous constants }  "   DIRECTORY_SIZE          =  32;   { 32 words per directory entry } "    EXEC_14                 =  14;   { String passage request }     FROM_FATHER             =   1;   { Exec 14 request code }     NUMBER_DIR_DCBS         =  32;   { For Fmp directory Dcb }      NUMBER_LIST_FILE_DCBS   =  16;   { For the list file Dcb }      NUMBER_DIR_DCB_WORDS    =  (NUMBER_DIR_DCBS * 128);  !   NUMBER_LIST_DCB_WORDS   =  (NUMBER_LIST_FILE_DCBS * 128) + 16;  !    TO_FATHER               =   2;   { Exec 14 request code }      $Page   #{-------------------------------------------------------------------}  # #{                           GLOBAL TYPES                            }  # #{-------------------------------------------------------------------}  #     TYPE     { This is used by the Pascal error catcher }      CatchErrorType = (RUN_TIME_ERROR, EMA_ERROR, I_O_ERROR,  "                     FILE_ERROR, SEGMENTATION_ERROR, WARNING_ERROR); "        { This Dcb type is used for the list file }     DcbType = ARRAY [0..NUMBER_LIST_DCB_WORDS-1] OF Int16;       "   { This Dcb type is used for the FmpMask calls. A Dcb is needed }  " "   { to hold directory information while scanning for matches     }  " !   DirectoryDcbType = ARRAY [0..NUMBER_DIR_DCB_WORDS-1] OF Int16;  !     !   { A variable of this type is needed for the mask calls. Each }  ! !   { file directory entry has this format                       }  !    DirectoryEntryType = ARRAY [0..DIRECTORY_SIZE-1] OF Int16;       !   FileNameType = PACKED ARRAY [0..MAX_1000_FILE_CHARS-1] OF CHAR; !        FiveWordsType = ARRAY [0..4] OF Int16;          { This is the string descriptor type for the Fmp calls }   
   FmpStringType = Int32;  
     $   FullPathnameString = PACKED ARRAY [0..MAX_1000_PATH_CHARS-1] OF CHAR; $     "   { This is the structure of each entry in the list file. The    }  " "   { fields are:                                                  }  " "   {  lfe_source_name         - The name of the source file or    }  " "   {                            directory which matched the mask. }  " "   {                            If this is a file this will be    }  " "   {                            used in the FmpOpen call.         }  " "   {  lfe_target_name         - This is not really a "target" file}  " "   {                            name. It is the name of the source}  " "   {                            file prepared to be sent to the   }  " "   {                            consumer in the SOURCE file string}  " "   {                            of an Offer or Directory message. }  " "   {                            It is different from the source   }  " "   {                            name in that preceeding, user-    }  " "   {                            specified directories are removed.}  " "   {                            See the Nft Protocol Spec. also.  }  " "   {  lfe_source_is_directory - True if lfe_source_name is a      }  " "   {                            directory, else is false for files}  " "   {  lfe_fmp_error           - Gives any Fmp error returned by   }  " "   {                            the FmpMask calls in accessing    }  " "   {                            the directory in lfe_source_name  }  " "   {                            (E.g., protection violation).     }  "    {}      ListFileEntryType = RECORD         lfe_source_name         : FullPathnameString;         lfe_target_name         : FullPathnameString;         lfe_source_is_directory : BOOLEAN;        lfe_fmp_error           : Int16;     END;           { Contains information about the list file. The fields are: }       {  lfi_dcb            - The Fmp Data Control Block          }       {  lfi_file_descr     - A descriptor to the lfi_file_name   }       {  lfi_file_name      - The name of the list file           }       {  lfi_file_is_open   - True if the file is open, else false}      {}      ListFileInfoType = RECORD        lfi_dcb            : DcbType;         lfi_file_descr     : FmpStringType;         lfi_file_name      : FullPathnameString;        lfi_file_is_open   : BOOLEAN;      END;          { This is used by the Pascal error catcher procedure }      LogicalFileNameType = PACKED ARRAY [1..150] OF CHAR;          SixCharsType = PACKED ARRAY [0..5] OF CHAR;         String2 = PACKED ARRAY [0..1] OF CHAR;      String3 = PACKED ARRAY [0..2] OF CHAR;      String4 = PACKED ARRAY [0..3] OF CHAR;      String6 = PACKED ARRAY [0..5] OF CHAR;       $Page   #{-------------------------------------------------------------------}  # #{                         GLOBAL VARIABLES                          }  # #{-------------------------------------------------------------------}  #     VAR      { This Dcb is used in the Mask calls }      dir_dcb              : DirectoryDcbType;          { Contains the directory path used in the mask calls }      direct_path          : FullPathnameString;      direct_path_descr    : FmpStringType;         { The file directory entry used in the mask calls }     directory_entry      : DirectoryEntryType;          { Used in the main routine }      fmp_error            : Int16;         { Contains information about the list file }      list_file_info       : ListFileInfoType;           { These count the number of files and directories that have }       { matched the file mask. These values are returned to the   }       { caller when the program completes.                        }      number_files         : Int16;     number_directories   : Int16;      !   { This is the name of the file or directory that has matched }  ! !   { the mask and will eventually be placed in the list file.   }  ! !   { Used in the main routine                                   }  !    source_name          : FullPathnameString;      source_file_descr    : FmpStringType;      "   { This is the name of the target file that has been calculated }  " "   { from the source file and will eventually be placed in the    }  " "   { list file. Used in the main routine                          }  "    target_name          : FullPathnameString;      target_file_descr    : FmpStringType;      "   { This is a descriptor to a file mask "@.@". This is needed in }  " "   { the procedure Calc_Dest_Name in order to extract a portion   }  " "   { of the source file name                                      }  "    target_mask_descr    : FmpStringType;      "   { True if source_name is a directory, that is, if it has a     }  " "   { ".DIR " type extention                                       }  "    source_is_directory  : BOOLEAN;      "   { The user mask holds the file mask that was passed to us in   }  " "   { the scheduling parameters. It is used in the mask calls to   }  " "   { generate a list of file and directory names                  }  "    user_mask_descr      : FmpStringType;     user_mask_name       : FullPathnameString;       $Page   #{-------------------------------------------------------------------}  # #{                    EXTERNAL ROUTINE DECLARATIONS                  }  # #{-------------------------------------------------------------------}  #     PROCEDURE Calc_Dest_Name     (VAR source_name        : FmpStringType;           match_level        : Int16;       VAR dest_mask          : FmpStringType;       VAR dest_name          : FmpStringType);     EXTERNAL;      	PROCEDURE FmpClose 	    (VAR dcb                : DcbType;           fmp_error          : Int16);     EXTERNAL;      
PROCEDURE FmpEndMask 
    (VAR dir_dcb            : DirectoryDcbType);      EXTERNAL;      PROCEDURE FmpInitMask      (VAR dir_dcb            : DirectoryDcbType;      VAR fmp_error          : Int16;       VAR mask_descr         : FmpStringType;       VAR direct_path        : FmpStringType;           dcb_length_words   : Int16);     EXTERNAL;      PROCEDURE FmpMaskName      (VAR dir_dcb            : DirectoryDcbType;      VAR full_pathname      : FmpStringType;       VAR directory_entry    : DirectoryEntryType;      VAR current_path       : FmpStringType);     EXTERNAL;      
FUNCTION FmpNextMask 
    (VAR dir_dcb            : DirectoryDcbType;      VAR fmp_error          : Int16;       VAR current_path       : FmpStringType;       VAR directory_entry    : DirectoryEntryType)     : Int16;      EXTERNAL;      PROCEDURE FmpOpenScratch     (VAR dcb                : DcbType;       VAR fmp_error          : Int16;       VAR file_name          : FmpStringType;       VAR opts_descr         : FmpStringType;           NUMBER_LIST_FILE_DCBS : Int16;      VAR name_used          : FmpStringType);     EXTERNAL;      PROCEDURE FmpParsePath     (VAR pathname_descr     : FmpStringType;       VAR dirpath_descr      : FmpStringType;       VAR file_name          : FmpStringType;       VAR typex_descr        : FmpStringType;       VAR qualifier_descr    : FmpStringType;       VAR sec_code           : Int16;       VAR file_type          : Int16;       VAR file_size          : Int16;       VAR rec_len            : Int16;       VAR ds_path_descr      : FmpStringType);     EXTERNAL;      	FUNCTION FmpPurge  	    (VAR pathname           : FmpStringType)      : Int16;      EXTERNAL;      	FUNCTION FmpWrite  	    (VAR dcb                : DcbType;       VAR fmp_error          : Int16;       VAR buffer             : ListFileEntryType;           byte_length        : Int16)      : Int16;      EXTERNAL;      FUNCTION MaskMatchLevel      (VAR dir_dcb            : DirectoryDcbType)     : Int16;      EXTERNAL;      FUNCTION PasParameters  $ALIAS 'Pas.Parameters'$     (    position           : Int16;       VAR string_param       : FullPathnameString;          max_chars          : Int16)      : Int16;      EXTERNAL;      PROCEDURE ReturnNumericParams  $ALIAS 'PRTN'$      (VAR five_words         : FiveWordsType);     EXTERNAL;      PROCEDURE ReturnParamString  $ALIAS 'EXEC', NOABORT$     (    exec_request_code  : Int16;           return_the_string  : Int16;       VAR string_buffer      : FullPathnameString;          string_length      : Int16);     EXTERNAL;      FUNCTION StringDescr1  $ALIAS 'STRDSC'$      (VAR string             : CHAR;          first_char         : Int16;           second_char        : Int16)      : Int16;      EXTERNAL;      FUNCTION StringDescr2  $ALIAS 'STRDSC'$      (    string             : String2;           first_char         : Int16;           second_char        : Int16)   
   : FmpStringType;  
    EXTERNAL;      FUNCTION StringDescr3  $ALIAS 'STRDSC'$      (    string             : String3;           first_char         : Int16;           second_char        : Int16)   
   : FmpStringType;  
    EXTERNAL;      FUNCTION StringDescr4  $ALIAS 'STRDSC'$      (VAR string             : String4;           first_char         : Int16;           char_length        : Int16)   
   : FmpStringType;  
    EXTERNAL;      FUNCTION StringDescr6  $ALIAS 'STRDSC'$      (VAR string             : String6;           first_char         : Int16;           char_length        : Int16)   
   : FmpStringType;  
    EXTERNAL;      FUNCTION StringDescr16  $ALIAS 'STRDSC'$     (VAR string             : FileNameType;          first_char         : Int16;           char_length        : Int16)   
   : FmpStringType;  
    EXTERNAL;      FUNCTION StringDescr64  $ALIAS 'STRDSC'$     (VAR string             : FullPathnameString;          first_char         : Int16;           char_length        : Int16)   
   : FmpStringType;  
    EXTERNAL;          $Page   #{-------------------------------------------------------------------}  # #{                   FORWARD ROUTINE DECLARATIONS                    }  # #{-------------------------------------------------------------------}  #     	PROCEDURE LogEvent 	    (    nft_log_error_code : Int16;           instance           : Int16;           parm1              : Int32;           parm2              : Int32;           parm3              : Int32);     FORWARD;       PROCEDURE ReturnResultAndTerminate     (    prdc1_nfterr       : Int16;           prdc1_fmperr       : Int16;           number_files       : Int16;           number_directories : Int16);     FORWARD;       $Page   $Range Off  #{-------------------------------------------------------------------}  # #{                          CATCH ERROR                              }  # #{-------------------------------------------------------------------}  # "{ This is the Pascal error catcher procedure. If we are called then  " { just log an error and bailout.  {}  PROCEDURE  CatchError  $ALIAS 'PAS.ErrorCatcher'$      (error_type    : CatchErrorType;   
    error_number  : Int16; 
 
    line_number   : Int16; 
     file_name     : LogicalFileNameType;      file_name_len : Int16);       BEGIN   #   LogEvent (P1_LOG_INTERNAL_ERROR, 1, Ord (error_type), error_number, # 
             line_number); 
        GOTO 99;       
END;  { CatchError } 
         $Page   #{-------------------------------------------------------------------}  # #{                         HAS DIR TYPE EXTEN                        }  # #{-------------------------------------------------------------------}  # "{ Returns true if the passed file name has a ".DIR " type extention, " #{ and false otherwise. Only directories can (and must) have this type  # { extention.  {   { Parameters:   {     pathname_descr (Input)  {        A descriptor to the file name in question  {}  
FUNCTION  HasDirTypeExten  
    (VAR pathname_descr : FmpStringType)      : BOOLEAN;       VAR      dirpath_descr   : FmpStringType;      ds_descr        : FmpStringType;      name_descr      : FmpStringType;      qual_descr      : FmpStringType;      typex_descr     : FmpStringType;          dirpath_buffer  : FullPathnameString;  
   dummy           : CHAR; 
    name_buffer     : FileNameType;     typex_buffer    : String4;       
   ds_buffer       : CHAR; 
    file_size       : Int16;      file_type       : Int16;      rec_len         : Int16;      sec_code        : Int16;       BEGIN      dirpath_descr   := StringDescr64 (dirpath_buffer, 1,                                        MAX_1000_PATH_CHARS);     name_descr      := StringDescr16 (name_buffer, 1,                                       MAX_1000_FILE_CHARS);     qual_descr      := StringDescr1  (dummy, 1, 1);     typex_descr     := StringDescr4  (typex_buffer, 1, 4);      ds_descr        := StringDescr1  (ds_buffer, 1, 1);         FmpParsePath (pathname_descr, dirpath_descr, name_descr,                    typex_descr, qual_descr, sec_code,                    file_type, file_size, rec_len, ds_descr);         HasDirTypeExten := typex_buffer = 'DIR ';      
END;  { HasDirTypeExten }  
         $Page   #{-------------------------------------------------------------------}  # #{                             INITIALIZE                            }  # #{-------------------------------------------------------------------}  # "{ Pickup the scheduling parameters and initialize the global string  " { descriptor variables.   {}  PROCEDURE  Initialize;      VAR      chars_read  : Int16;       BEGIN       { The parameter is the mask name that the user gave for the }       { source file. We will use this to generate a list of files }   
   user_mask_name := ' ';  
 $   chars_read := PasParameters (1, user_mask_name, MAX_1000_PATH_CHARS); $         { Clear the open flag so we don't attempt to close the file }       { later (in ReturnResultAndTerminate before it's opened)    }      list_file_info.lfi_file_is_open := FALSE;         { Initialize all of these global string descriptors }     list_file_info.lfi_file_descr :=         StringDescr64 (list_file_info.lfi_file_name, 1,                        MAX_1000_PATH_CHARS);         target_mask_descr := StringDescr3 ('@.@', 1, 3);          source_file_descr := StringDescr64 (source_name, 1,                                         MAX_1000_PATH_CHARS);     target_file_descr := StringDescr64 (target_name, 1,                                         MAX_1000_PATH_CHARS);     direct_path_descr := StringDescr64 (direct_path, 1,                                         MAX_1000_PATH_CHARS);     user_mask_descr   := StringDescr64 (user_mask_name, 1,                                          MAX_1000_PATH_CHARS);  
END;  { Initialize } 
         $Page   #{-------------------------------------------------------------------}  # #{                             LOG EVENT                             }  # #{-------------------------------------------------------------------}  #  { Log an event to the log file. Currently all of the events are    { errors (no warnings).   {   { Parameters  {   {     nft_log_error_code (Input)  !{        A log error code defined by NFT/1000 which indicates the  ! {        cause of the fatal error   {   {     instance (Input)  {        Gives the instance of the error code. This will be a   "{        different number for each location where LogEvent is called " {        with the given nft_log_error_code.   {   
{     parm1 (Input)  
 "{        A parameter whose usage depends on the nft_fatal_error code " {   
{     parm2 (Input)  
 "{        A parameter whose usage depends on the nft_fatal_error code " {   
{     parm3 (Input)  
 "{        A parameter whose usage depends on the nft_fatal_error code " {}  
PROCEDURE  LogEvent  
    (nft_log_error_code : Int16;       instance           : Int16;       parm1              : Int32;       parm2              : Int32;       parm3              : Int32);      VAR      dummy       : ContextWords;     info_msg    : ARRAY [1..4] OF Int16;      result      : Int16;      wkmp        : Int16;       BEGIN      dummy.longint := 0;     info_msg [1]  :=  nft_log_error_code;     info_msg [2]  :=  parm1;      info_msg [3]  :=  parm2;      info_msg [4]  :=  parm3;          DS_EnterCritical (wkmp, result);          IF result = 0 THEN         BEGIN   "      Log_Event (EL_ERROR, HP_NFT, instance, dummy, 4, info_msg [1], " 
                 result);  
       DS_LeaveCritical (wkmp);  	      END;  { IF } 	     	END;  { LogEvent } 	         $Page   #{-------------------------------------------------------------------}  # #{                    RETURN RESULT AND TERMINATE                    }  # #{-------------------------------------------------------------------}  # { Return the result parameters to the father and terminate the  { program.  {   { Parameters:   {   
{     prdc1_nfterr (Input) 
 "{        Gives any Nft protocol error code that occurred if non-zero " {   
{     prdc1_fmperr (Input) 
 {        Gives any Fmp error that occurred if non-zero  {   
{     number_files (Input) 
 {        Gives the number of files which matched the mask   {   {     number directories (Input)   {        Gives the number of directories which matched the mask    {}  PROCEDURE  ReturnResultAndTerminate      (prdc1_nfterr       : Int16;       prdc1_fmperr       : Int16;       number_files       : Int16;       number_directories : Int16);      VAR      five_words  : FiveWordsType;      fmp_error   : Int16;       BEGIN      { First take care of closing the list file if it is open. }     { The producer will re-open it if all went ok.            }  
   WITH list_file_info DO  
       BEGIN         IF lfi_file_is_open THEN           BEGIN           { Close the file no matter what }           FmpClose (lfi_dcb, fmp_error);       !         { If any error before then purge the file. The producer } ! !         { will not be interested in the file contents unless    } ! !         { everything went allright                              } !          IF prdc1_nfterr <> 0 THEN              fmp_error := FmpPurge (lfi_file_descr);            END;  { IF file_is_open }             { Only need to return the name of the list file if all   }          { went ok (else the file would have been purged above    }          { and the father will not attempt to pickup this string) }         IF prdc1_nfterr = 0 THEN           BEGIN           ReturnParamString (EXEC_14 + NO_ABORT, TO_FATHER,  !                            lfi_file_name, -MAX_1000_PATH_CHARS);  !          BEGIN  !         { This is the error return for the Exec call. There is }  ! !         { not much we can do on an error here so ignore it     }  !          END;  { BEGIN }               END;  { IF numeric_result }        END;  { WITH list_file_info }          { Set the parameters and return them }      five_words [PRDC1_NFTERR_INDEX] := prdc1_nfterr;      five_words [PRDC1_FMPERR_INDEX] := prdc1_fmperr;      five_words [PRDC1_FILES_INDEX]  := number_files;      five_words [PRDC1_DIRS_INDEX]   := number_directories;      ReturnNumericParams (five_words);         { Make sure no directories are still open }     FmpEndMask (dir_dcb);         { And jump to the end of the main routine }     GOTO 99;       END;  { ReturnResultAndTerminate }          $Page   #{-------------------------------------------------------------------}  # #{                     WRITE ENTRY TO LIST FILE                      }  # #{-------------------------------------------------------------------}  # !{ Write a single entry to the list file. If an error occurs during ! { the write then call the cleanup procedure.  {   { Parameters:   
{     source_name (Input)  
  {        The name of the file or directory which has matched the   {        user's mask.   {   
{     target_name (Input)  
  {        The target file name that will be sent to the consumer    {   {     source_is_directory (Input)   !{        True if the source name specifies a directory, else false ! {   {     entry_fmp_error (Input)   {        An Fmp error which occurred when accessing the source  {        directory if negative.   {}  PROCEDURE  WriteEntryToListFile      (VAR source_name         : FullPathnameString;       VAR target_name         : FullPathnameString;           source_is_directory : BOOLEAN;          entry_fmp_error     : Int16);       VAR   
   bytes_written : Int16;  
    file_entry    : ListFileEntryType;   
   fmp_error     : Int16;  
    file_buffer   : FullPathnameString;     file_name     : FmpStringType;   
   loop          : Int16;  
    opts_buffer   : String6;      opts          : FmpStringType;       BEGIN      { If the list file has not been created then create it }   
   WITH list_file_info DO  
       BEGIN         IF NOT lfi_file_is_open THEN           BEGIN  $         { Create the scratch file. Note that the size of the scratch  } $ $         { file is 66 blocks. This size is chosen such that if 32767   } $ $         { files or directories match the mask, then 255 extents will  } $ $         { be needed: ((256 * 66) blocks * 128 words/block) / 66 words } $ $         { per file entry. The size was made as small as possible so   } $ $         { that less disc space is consumed if few matches occur.      } $ $         { Recall that the maximum number of extents in a FMGR file is } $ $         { 255, and the scratch file may end up there after calling    } $ $         { FmpOpenScratch.                                             } $          opts_buffer := 'WCXTQZ';            file_buffer := 'DS:::2:66:66';            opts        := StringDescr6 (opts_buffer, 1, 6);            file_name   := StringDescr64 (file_buffer, 1,                                         MAX_1000_PATH_CHARS);      #         { Note the 'T' open option. The scratch file will be purged } # #         { by Fmp if we get aborted. If Fmp cannot generate a unique } # #         { name after 200 (arbitrarily chosen) tries then bailout.   } #          loop := -200;           REPEAT                FmpOpenScratch (lfi_dcb, fmp_error, file_name, opts,   "                            NUMBER_LIST_FILE_DCBS, lfi_file_descr);  "             loop := loop + 1;   "         UNTIL (fmp_error <> FMP_DUPLICATE_FILE_NAME) OR (loop = 0); "              IF fmp_error >= 0 THEN               lfi_file_is_open := TRUE           ELSE               ReturnResultAndTerminate (SCRATCH_FILE_ERROR,                                         fmp_error, 0, 0);   
         END;  { IF NOT }  
 
      END;  { WITH } 
        { Increment the proper counter for a file or directory }      IF source_is_directory THEN        number_directories := number_directories +1      ELSE         number_files := number_files +1;         { Stick all of the parameters into the file entry record }      file_entry.lfe_source_name         := source_name;      file_entry.lfe_target_name         := target_name;      file_entry.lfe_source_is_directory := source_is_directory;      file_entry.lfe_fmp_error           := entry_fmp_error;          { And write it to the list file }      bytes_written := FmpWrite (list_file_info.lfi_dcb, fmp_error,                                  file_entry, LIST_FILE_REC_BYTES);               IF fmp_error < 0 THEN  #      ReturnResultAndTerminate (SCRATCH_FILE_ERROR, fmp_error, 0, 0);  #     END;  { WriteEntryToListFile }          $Page   #{-------------------------------------------------------------------}  # #{                           MAIN PROGRAM                            }  # #{-------------------------------------------------------------------}  #     BEGIN      Initialize;         { Initialize everything for the FmpMask calls below }     FmpInitMask (dir_dcb, fmp_error, user_mask_descr,                  direct_path_descr, NUMBER_DIR_DCB_WORDS);              IF fmp_error < 0 THEN        ReturnResultAndTerminate (CANT_ACCESS_SOURCE_FILE,                                  fmp_error, 0, 0);          { Loop finding entries and entering them in the list file }     { until the search cannot continue. Note that FmpNextMask }     { returns a Fortran boolean value, not Pascal             }     WHILE FmpNextMask (dir_dcb, fmp_error,                          direct_path_descr, directory_entry) < 0 DO         BEGIN   !      { Errors returned by FmpNextMask must be in accessing the }  ! !      { directory path given by current_path. Return this path  }  ! !      { and the Fmp error that occurred. We don't care what the }  ! !      { target name is here                                     }  !       IF fmp_error < 0 THEN            BEGIN           source_name         := direct_path;           source_is_directory := TRUE;            WriteEntryToListFile (source_name, target_name,                                  source_is_directory, fmp_error);             END   { IF fmp_next_mask_error }         ELSE           BEGIN           FmpMaskName (dir_dcb, source_file_descr,                         directory_entry, direct_path_descr);      !         { This call will remove the undesired part of the file }  ! !         { pathname preceeding the file which matched. E.g., if }  ! !         { the source name is "/FOO/BAR/FILE" and the level is  }  ! !         { 1, then we will get "BAR/FILE".                      }  ! #         Calc_Dest_Name (source_file_descr, MaskMatchLevel (dir_dcb),  #                           target_mask_descr, target_file_descr);             WriteEntryToListFile                           (source_name, target_name,  !                         HasDirTypeExten (source_file_descr), 0);  !              END;  { ELSE of IF fmp_error }         END;  { WHILE FmpNextMask }       #   ReturnResultAndTerminate (0, 0, number_files, number_directories);  #     99:   END.  { PRDC1 }  