 $PASCAL '91790-1X175 REV.4010 <860321.1738> '           $ TITLE 'NS Parsing/Display Routines '$   $ STANDARD_LEVEL'HP1000', RECURSIVE OFF, RANGE OFF, HEAP 0  $   $ DEBUG $   $ CODE_INFO on $      MODULE parser;  	$ALIAS 'N$parser'  	         {------------------------------------------------------------        (c) COPYRIGHT HEWLETT PACKARD COMPANY 1986. ALL RIGHTS    RESERVED. NO PART OF THIS PROGRAM MAY BE PHOTOCOPIED,   REPRODUCED OR TRANSLATED TO ANOTHER PROGRAM LANGUAGE WITHOUT    THE PRIOR WRITTEN CONSENT OF THE HEWLETT-PACKARD COMPANY.       ------------------------------------------------------------}      {}  
{      NAME: parser  
 {    SOURCE: 91790-18175  	{     RELOC: NONE  	 
{      PGMR: <<EMS>> 
 {}      {}  {------------------------------------------------------------   { MODIFICATIONS:  {   {  Date  Prgmr  Description   {  840619 ems  temporarily removed IP code.   %{  860210 ems  Fix problem so YesNo prompts are put in output file (n314). % {------------------------------------------------------------   {}      {}  { PROGRAM DESCRIPTION:  {   {     This module contains the parsing routines for   {     NSINIT, the NS/1000 initialization program.   {   {     Most of the routines are EXPORTED by this module.   {     The exported routines routines are:   {     CharInput.  {     HandleError, IntInput, WordInput, & YesNoInput.   {   {     Note that there will be another routine: IntegerInput    {     for 32 bit integers, in addition to IntInput which is for    {     16 bit integers.  The 32bit routine is not coded yet.   {   {     The internal routines are:  {     CommentCheck- checks for * in 80-character string   {     InputError  - handles input errors (invalid input)  {     PascalPrintError  - Replaces pascal error PascalPrinter   {   {}              IMPORT         { basic memory manager declarations }  $ SEARCH 'phtm/bodec.rel' $      bodec,          { basic initialization declarations. }   $ SEARCH 'phtm/init_dec.rel' $     Init_Dec,         { general initialization subroutines }   $ SEARCH 'phtm/Init_General.rel' $     Init_General,         { file manipulation routines }   $ SEARCH 'phtm/FileMan.rel' $      FileMan,       $ SEARCH 'phtm/Strrout.xpt'$     strrout;       $ SUBTITLE 'Exported Routines ', PAGE $       EXPORT      
PROCEDURE CharInput  
   (    promptstring:       PromptType;         casefold:           Boolean;      VAR default:            Boolean;      VAR terminator:         Boolean;      VAR input_string:       String;     VAR passed_result:      Int16);  $   { Prompt user with promptstring; read a character string from user }  $     	PROCEDURE IntInput 	   (    promptstring:        PromptType;      VAR default:             Boolean;     VAR terminator:          Boolean;         hi_value:            Int16;         lo_value:            Int16;     VAR int16_value:         Int16;     VAR passed_result:       Int16);   #   { Prompt with promptstring; read a positive integer from the user } #     PROCEDURE MsgFilePrint  (     msgnumber:     Int16;         whichroutine:  PrintMsgType;        printinfo:     Int16;     VAR result:        Int16 );       PROCEDURE PrintPrompt     (    haveprompt:         Boolean;          promptstring:       PromptType;     VAR passed_result:      Int16);      
PROCEDURE WordInput  
   (    promptstring:       PromptType;     VAR default:            Boolean;      VAR string_of_tokens:   String;     VAR token_from_user:    String;     VAR passed_result:      Int16);     { Prompt user with promptstring; read input and make sure        it is one of the tokens in string_of_tokens            }      
PROCEDURE YesNoInput 
   (    promptstring:       PromptType;     VAR default:            Boolean;      VAR yesnovalue:         OneCharType;      VAR passed_result:      Int16);     { Prompt user with promptstring; read a Y/N from the user }      $ SUBTITLE 'Implement', PAGE $  IMPLEMENT            { Module parser }      VAR   $   { TRUE if message file is open, used between calls to msgfileprint }  $    msgfileopen: Boolean;     { File for messages }     msgfile:     TEXT;   ' { TRUE if error message file is missing from directory & error was printed }  '    toldusernofile: Boolean;          errorstring:      IStringType;      display_msg:      PromptType;     save_string:      IStringType;      user_string:      IStringType;       FUNCTION FmpOpen  
$ FIXED_STRING ON $  
 
( VAR dcb:        DcbType; 
   VAR error:      Int16;  
  VAR fname:      String;  
       fileoptns:  OptnType;         bufsize:    Int16 ):    Int16;  
$ FIXED_STRING OFF $ 
    EXTERNAL;      FUNCTION FmpReadString  
$ FIXED_STRING ON $  
 
( VAR dcb:        DcbType; 
   VAR error:      Int16;    VAR buffer:     String ):   Int16;  
$ FIXED_STRING OFF $ 
    EXTERNAL;      FUNCTION FmpSetPosition   
$ FIXED_STRING ON $  
 
( VAR dcb:        DcbType; 
   VAR error:      Int16;        recordpos:  Int32;        internalpos:Int32 ):    Int16;  
$ FIXED_STRING OFF $ 
    EXTERNAL;      PROCEDURE CommentCheck    (VAR input_string: String );     FORWARD;   #   { check for '*' and delete from there until end of line if found }  #     
PROCEDURE InputError 
   (    promptstring:          PromptType;      VAR responsestring:        String;      VAR errormessage:          String;      VAR passed_result:         Int16);      FORWARD;      { Error getting input.  Print an error message }           FUNCTION MinOf2Int16s     (    integer1:     Int16;          integer2:     Int16 ):  Int16;      { Find the minimum of integer1 and integer2 }     FORWARD;       PROCEDURE Prompt_ReadResponse     (    haveprompt:         Boolean;          promptstring:       PromptType;     VAR input_string:       String;     VAR passed_result:      Int16);     FORWARD;       { Print a prompt and read a response from the input device }        	$ FIXED_STRING ON  	 PROCEDURE PutInCommas      ( VAR stringa: String );      EXTERNAL;  	$ FIXED_STRING OFF 	 #   { RTE-A routine : changes token delimiters from spaces to commas }  #     $ SUBTITLE 'CharInput' , PAGE $   {------------------------------------------------------------}  {                                                            }  {                    CharInput                               }  {                                                            }  {------------------------------------------------------------}  
PROCEDURE CharInput  
   (    promptstring:       PromptType;         casefold:           Boolean;      VAR default:            Boolean;      VAR terminator:         Boolean;      VAR input_string:       String;     VAR passed_result:      Int16);  $   { Prompt user with promptstring; read a character string from user }  $ {}  {  Purpose: To prompt a user for input and to read and check a  {     character string.   {   {  Input:   {     promptstring   user prompt (character string) to be   {                       displayed on the interactive device &   {                       in answer file if applicable  {     casefold       TRUE if caller wishes to upshift input;  {                       FALSE if input is not to be upshifted.  ${     default        TRUE if caller wishes to accept "/D" as valid input $ ${     terminator     TRUE if caller wishes to accept "/E" as valid input $ {   {  Output:  {     input_string   actual string that was read  "{     default        TRUE if caller accepts "/D" and user entered it " "{     terminator     TRUE if caller accepts "/E" and user entered it " {     passed_result  0 if no error ocurred, <0 otherwise  {   {  Global Variables accessed: none  {  Side Effects: none   &{  Routines called: Display, Prompt_ReadResponse, StrUpshift, CommentCheck.  & {   {  Description:   {    {     CharInput will be called to read an ascii string from the    {     user.   {   {     CharInput calls Prompt_ReadResponse to prompt the user  "{     for a response and to read the response from the input device. " "{     This routine will check for comments "*" in column 1) and will " {     save the comment in the output file if save_in_out is   {     TRUE.   {   {     If result = IABORT CharInput returns to the caller.   {   !{     After reading the input, the character string is checked for ! !{     /D and /E if the default and terminator flags indicate that  ! {     the caller will accept these as valid input.  {   !{     If the string is "/D" or "/E", and this is acceptable input, ! {     the string will be upshifted if casefold is TRUE.   {   %{     The string will be checked for "*".  If these characters are found,  % #{     all characters following the "*" until the end of the line will  # {     be stripped from the string returned to the caller.   {   {     If result <> GOOD, input_string will be null, unless  {     result = IABORT; in which case input_string := 'AB'.  {   {}      $ PAGE $  LABEL   %   900;                       { used to exit out of CharInput for errors } %     VAR   &   enter_def:     Boolean;     { TRUE if caller accepts & user entered /D }  & &   enter_term:    Boolean;     { TRUE if caller accepts & user entered /E }  & 
   goodresponse:  Boolean; 
 #   internal_result:  Int16;    { internal value for result parameter } # 
   haveprompt:    Boolean; 
 $   testlen:       Int16;       { length of test string (either 1 or 2 }  $ $   test_string:   TwoCharType; { string to test input for "/D" & "/E" }  $     $ SUBTITLE 'CheckReturn (CharInput)', PAGE $  {------------------------------------------------------------}  {  ( LOCAL )         CheckReturn      ( LOCAL )              }  {------------------------------------------------------------}      
   PROCEDURE CheckReturn(  
       VAR input_string: String;         VAR internal_result: Int16);      {}  {  CheckReturn is used so there is only one GOTO in CharInput.   {  It is used to exit CharInput in the event of an irrecoverable   {  error.   {   
{  input parameters: 
 {     internal_result - used to check for abort   {  output parameters:   {     input_string - set to '' if internal_result <> IABORT,  {                    'AB' if internal_result = IABORT.  {   {  Global variables used:  none   
{  Side Effects:     none  
 
{  Routines called:  none  
 {   {   {}        BEGIN    { CheckReturn }            { Test for an error occurring.  Check if user entered           an abort sequence.  If he/she did, set input_string to          abort sequence.  Otherwise, set input_string to null.           Save the internal result for the caller in result }             IF (( internal_result <> GOOD ) OR ( hiterror )) THEN            BEGIN    { error }            IF internal_result = IABORT THEN               BEGIN    { user entered abort sequence }              input_string := 'AB';               END      { user entered abort sequence }             ELSE               BEGIN    { error getting user input }                   IF internal_result = GOOD THEN                 BEGIN    { need to print an error }                 internal_result := ERRPASCAL_ERRC;                  END;     { need to print an error }                  hiterror := FALSE;              pascal_error.ernumber := 0;               SetStrlen( input_string, 0 );               END;     { error getting user input }       	         GOTO 900; 	              END;     { error }             END;     { CheckReturn }      $ PAGE $         BEGIN   { CharInput }         internal_result := GOOD;       "   { Assume default and terminator did not occur, clear the flags. } "    enter_def := FALSE;     enter_term := FALSE;      haveprompt := FALSE;          REPEAT       
      enter_def := FALSE;  
 
      enter_term := FALSE; 
       SetStrlen( input_string, 0 );         goodresponse := FALSE;      $      { go prompt the user and read the response from the input device } $ !      Prompt_ReadResponse( haveprompt, promptstring, input_string, !                   internal_result );        CheckReturn( input_string, internal_result );       "      { Save input string in case we're building the output file. }  "       save_string := input_string;            StrUpshift( input_string );         test_string := '';            { get 2 char string to test for /D and /E }   !      testlen := MinOf2Int16s( Strlen( input_string ), TWOCHAR );  !       Strmove( testlen, input_string, 1, test_string, 1 );            IF (( default ) AND ( test_string = '/D' ))THEN            BEGIN    { handle default }           goodresponse := TRUE;           enter_def := TRUE;            END      { handle default }          ELSE           IF (( terminator ) AND ( test_string = '/E')) THEN               BEGIN    { handle terminator }              goodresponse := TRUE;               enter_term := TRUE;               END      { handle terminator }             ELSE   #            IF (( test_string = '/D' ) OR ( test_string = '/E' )) THEN #                BEGIN    { Input Error }   '               { user entered default or terminator when it was not allowed }  '                input_string := '';                 Strwrite( input_string, 1, internal_result,                      '** (9000) NS: Error: "',   $                  test_string, '" is not valid for this question.**' );  $                    internal_result := GOOD;       "               InputError( promptstring, save_string, input_string,  "                   internal_result );                     haveprompt := FALSE;                      END      { Input Error }   	              ELSE 	                BEGIN    { input ok }                     { upshift the input string if necessary }                 If casefold THEN   "                  BEGIN       { Upshift the string for the caller }  "                   StrUpshift( input_string );   "                  END;        { Upshift the string for the caller }  "                    { check for * comment delimiter in string }                 CommentCheck( input_string );                     goodresponse := TRUE;                     END;     { input ok }            UNTIL ( goodresponse OR ( internal_result <> GOOD ));          IF goodresponse THEN         BEGIN    { save input }             WriteOnOutput( save_string, internal_result );        CheckReturn( input_string, internal_result );             internal_result := GOOD;            END;     { save input }       900:         { set return parameters for caller. }     default := enter_def;     terminator := enter_term;     passed_result := internal_result;         END;    { CharInput }      $ SUBTITLE 'CommentCheck', PAGE $   {------------------------------------------------------------}  {                                                            }  {                    CommentCheck                            }  {                                                            }  {------------------------------------------------------------}      PROCEDURE CommentCheck    ( VAR input_string:   String );       {}  { Purpose:  {   #{  To check for "*" in an input string, and to delete from the "*" to  # {  the end of the line if the comment delimiter is present.   {   
{  input parameters: 
 {     input_string - string to be tested for '*'  {  output parameters:   !{     input_string - same string as input, but all chars from '*'  ! {                    to end-of-line are stripped  {  Global variables used:  none   
{  Side effects:     none  
 
{  Routines called:  none  
 {   {}      VAR   %   s_index:       Int16;       { index for repeat loop to access string }  %            BEGIN    { CommentCheck }         { check if '*' comment delimiter is in the string }         s_index := Strpos( input_string, '*' );         IF s_index <> 0 THEN         BEGIN    { delete comment }         { back up to last valid char before comment delim }         s_index := s_index -1;            { make new input string not have comment in it }        input_string := Str( input_string, 1, s_index );            END;     { delete comment }          { strip leading and trailing blanks from user input }     input_string := Strltrim( input_string );     input_string := Strrtrim( input_string );         END;     { CommentCheck }      $ SUBTITLE 'InputError', PAGE $       {------------------------------------------------------------}  {                                                            }  {                     InputError                             }  {                                                            }  {------------------------------------------------------------}      
PROCEDURE InputError 
   (    promptstring:          PromptType;      VAR responsestring:        String;      VAR errormessage:          String;      VAR passed_result:         Int16);       { Error getting input.  Handle the error- get good response }       {}  {  Purpose:    {     To report and handle errors from IntInput and YesNoInput.    {   {  Input:    {    These strings are used to print meaningful error messages:    {        promptstring- prompt displayed before  {        responsestring- response user entered before   {   {        errormessage- error message to be displayed  {   {  Output:  {     result- <0 if error, =0 if no error   {   {  SideEffects: The routine relies on the caller saving the   {              current interactive flag.  {  Routines called: PrintError.   {   {  Description:   {     InputError attempts to recover from user input errors.  {   {  If the input device is interactive, the routine prints an  !{  error message.  The user will be able to enter a new response.  ! {   {  If the input device is not interactive,  {  then an error message indicating what error has occurred is   {  printed, and a second message telling the user the program is   {  being terminated is printed.   {   {}      LABEL      300;       CONST      { various error messages }      helpabort = '( Note: Enter "ab" to abort. )';     erroris  = '** Error is: ';     responsewas =  $ '** (9001) NS INPUT ERROR.  Prompt and response from input file are:';  $     VAR       #   internal_result:      Int16;      { internal value for error parm } #     $ SUBTITLE 'CheckReturn (InputError)', PAGE $   {------------------------------------------------------------}  {  ( LOCAL )      CheckReturn         ( LOCAL )              }  {------------------------------------------------------------}  
   PROCEDURE CheckReturn;  
        BEGIN    { CheckReturn }          IF (( internal_result <> GOOD ) OR ( hiterror )) THEN        BEGIN             IF hiterror THEN           BEGIN    { fix error condition }            hiterror := FALSE;            pascal_error.ernumber := 0;           END;     { fix error condition }             GOTO 300;             END;     END;     { CheckReturn }       $ SUBTITLE 'InputError', PAGE $          BEGIN       { InputError }          internal_result := GOOD;          IF initglobals.IG_interactive THEN         BEGIN    { set up error message for print }             { input interactive.  User knows prompt & response }            WriteOnInput( errormessage, internal_result );  	      CheckReturn; 	           END      { set up error message for print }        ELSE         BEGIN    { abort; not interactive }             { Since not interactive must give user more info than          just an error message.  Print prompt, response & error           before aborting the program.                            }             WriteOnLog( responsewas, internal_result );   	      CheckReturn; 	     '      internal_result := MinOf2Int16s( Strlen( promptstring ), STRINGSIZE );   '       display_msg := Str( promptstring, 1, internal_result );         WriteOnLog( display_msg, internal_result );   	      CheckReturn; 	           WriteOnLog( responsestring, internal_result );  	      CheckReturn; 	           WriteOnLog( erroris + errormessage, internal_result );  	      CheckReturn; 	     "      { tell caller can't get new input, main will print abort msg } "       internal_result := ERRUSERINPUT;            END;     { abort; not interactive }       300:     passed_result := internal_result;         END;        { InputError }       $ SUBTITLE 'IntInput', PAGE $   {------------------------------------------------------------}  {                                                            }  {                       IntInput                             }  {                                                            }  {------------------------------------------------------------}  	PROCEDURE IntInput 	   (    promptstring:        PromptType;      VAR default:             Boolean;     VAR terminator:          Boolean;         hi_value:            Int16;         lo_value:            Int16;     VAR int16_value:         Int16;     VAR passed_result:       Int16);   #   { Prompt with promptstring; read a positive integer from the user } # {}      {}  "{  Purpose: To prompt a user for integer input, to read in a string, " !{     check it for "/D" and "/E", convert the input to an integer, ! {     and check it against the ranges passed by the caller.   {   { Input:   {   promptstring   character string prompt for interactive user    {   haveprompt     TRUE if this prompt/response in answer file  {                    should be overwritten  {   default        TRUE if caller wants to accept "/D'  {                    as valid (use defaults)  {   terminator     TRUE if caller wants to accept "/E"  {                    as valid (end of input)  "{   hi_value       highest accepted value for the integer to be read " "{   lo_value       lowest accepted value for the integer to be read  " {   {   { Output:   !{   int16_value    integer value of input if default & terminator  ! {                       are FALSE and  result = 0.  {                       Otherwise -1.   !{   default        TRUE if caller will accept & user entered "/D"  ! !{   terminator     TRUE if caller will accept & user entered "/E"  ! {   result         = 0 if no error occurred during execution,   {                       < 0 Otherwise   {   {  Global variables accessed: none  {  Side Effects:  {     The input device will be temporarily changed to the log    {     device if the input device is not interactive and there is   !{     an error getting the input.  This will only occur if the log ! {     device is interactive.  When the user enters the correct  "{     response to the prompt, the input device will be changed back  " {     to the old device.  {   {  Routines called:  InputError, Display, StrUpshift,   !{                    GetInt16, CommentCheck, Prompt_ReadResponse.  ! {   { Description:  "{     IntInput calls Prompt_ReadResponse to write a prompt and read  " ${     a response from the input device.  The prompt will also be written $ !{     to the output device if the device is open.  The input will  ! "{     be checked if it is a comment ("*" in column 1).  If it is, it " #{     is saved in the output file.  The input string is then returned  # 	{     to IntInput. 	 {   {     If result = IABORT IntInput returns to the caller.  {   !{     After reading the input, the character string is checked for ! !{     /D and /E if the default and terminator flags indicate that  ! {     the caller will accept these as valid input.  {   !{     If the string is "/D" or "/E", and this is acceptable input, ! {     control is returned to the caller.  {   "{     If The string is not one of these values it is converted to an " #{     integer by calling GetInt16.  GetInt16 sets result = BAD if the  # {     string is not numeric.  {     No further checks are performed on the string.  {   {     If the input was an integer, it is compared against the    {     ranges passed to it by the caller.  If the input is within   {     the high and low values passed to IntInput, the routine   {     will terminate without error.   {   !{     If the input is not what was expected, and the input device  ! !{     is interactive, the prompt will be re-written and the input  ! {     will be re-read until it is acceptable.   {   {     If the device is not interactive, the input device   {     will be changed to be the log device if the log device is    {     interactive.  If the log device is not interactive,   {     result will be set to ERROR.  {   {     If the input is not acceptable & the input device   {     is not interactive, IntInput will set result = error, as  {     there are no options to re-read the input.  {}  LABEL       "   900;               { label to go to to exit IntInput for errors } "     CONST   
   andmsg = ' and '; 
 	   starmsg = '**'; 	         VAR       &   enter_def:     Boolean;      { TRUE if caller accepts & user entered /D } & &   enter_term:    Boolean;      { TRUE if caller accepts & user entered /E } &     goodresponse:  Boolean;      { TRUE if input read was good }       internal_result: Int16;      { internal value for result }   (   haveprompt:        Boolean;      { TRUE if already prompted for this input }  (    temp_len:      Int16;  !   test_string:   TwoCharType;  { string to test for "/D" & "/E" } !    testlen:       Int16;        { length of test string }       $ SUBTITLE 'CheckReturn (IntInput)', PAGE $   {------------------------------------------------------------}  {  ( LOCAL )        CheckReturn       ( LOCAL )              }  {------------------------------------------------------------}      
   PROCEDURE CheckReturn;  
 { }   {  Input:   none  {   {  Output:  {   {  Global variables accessed: none  {  Side Effects, Routines called: none  {   {}        BEGIN    { CheckReturn }            IF (( internal_result <> GOOD ) OR ( hiterror )) THEN            BEGIN       { error }      
         IF hiterror THEN  
             BEGIN    { hit pascal error catcher }               hiterror := FALSE;              pascal_error.ernumber := 0;               IF internal_result = GOOD THEN                 BEGIN    { need to print an error }                 internal_result := ERRPASCAL_ERRC;                  END;     { need to print an error }              END;     { hit pascal error catcher }       	         GOTO 900; 	          END;        { error }            END;     { CheckReturn }      $ SUBTITLE ' BuildErrorMsg (IntInput)', PAGE $   {--------------------------------------------------------------}    {   ( LOCAL )       BuildErrorMsg          ( LOCAL )           }    {--------------------------------------------------------------}   PROCEDURE BuildErrorMsg    (     hi_value:        Int16;         lo_value:        Int16;     VAR estring:         String );          { builds an error message in estring for IntInput }  { }   {  Input:   {     hi_value- hi value caller wants put in message  {     lo_value- lo value caller wants put in message  {  Output:  {     estring contains the error message.   {   {  Global variables accessed, routines called: None   {  Side Effects: none   {   {}         BEGIN    { BuildErrorMsg }          { prepare error message.  Get start of message }       estring :=  $       '** (9002) NS: Input not within Range. Input must be between  ';  $            { stuff the low value in the string }     Strwrite( estring, Strlen( estring ), temp_len,                     lo_value:1, andmsg );         { stuff the hi value in the string }       Strwrite( estring, temp_len, temp_len, hi_value:1, starmsg );          END;     { BuildErrorMsg }       $ SUBTITLE 'IntInput ', PAGE $         BEGIN   {IntInput}          internal_result := GOOD;      enter_def := FALSE;     enter_term := FALSE;          { if range invalid flag right here }      IF hi_value < lo_value THEN        BEGIN       { bad range }         internal_result := BADRANGE;  	      CheckReturn; 	       END;        { bad range }          haveprompt := FALSE;   
   goodresponse := FALSE;  
    SetStrlen( test_string, 0 );          REPEAT   { keep prompting until good input from user }             { assume everything is ok, clear result indicator }         internal_result := GOOD;            { assume data isn't "/D" or "/E" }  
      enter_def := FALSE;  
 
      enter_term := FALSE; 
           { get a line from the input device }        Prompt_ReadResponse( haveprompt, promptstring,                           user_string, internal_result );  	      CheckReturn; 	           { save input read in case we're building output file }        save_string := user_string;             StrUpshift( user_string );        SetStrlen( test_string, 0 );      !      testlen := MinOf2Int16s( Strlen( user_string ), TWOCHAR );   !       Strmove( testlen, user_string, 1, test_string, 1 );             IF (( default ) AND ( test_string = '/D' )) THEN           BEGIN       { checking for default }            goodresponse := TRUE;           enter_def := TRUE;            END         { checking for default }           ELSE           IF (( terminator ) AND ( test_string = '/E' )) THEN              BEGIN       { checking for terminator }               goodresponse := TRUE;               enter_term := TRUE;               END         { checking for terminator }              ELSE               BEGIN    { convert ascii to number }                  { strip off end-of-line comments if necessary }               CommentCheck( user_string );      !            GetInt16( user_string, int16_value, internal_result ); !             IF internal_result <> GOOD THEN                  BEGIN    { error converting }                     { if not an integer, flag right here }                  haveprompt := TRUE;                 internal_result := GOOD;                  END      { error converting }  	              ELSE 	                BEGIN    { range check }                      { check that input within expected range }                  IF (( int16_value <= hi_value ) AND                     ( int16_value >= lo_value )) THEN                    BEGIN    { in range }                     goodresponse := TRUE;                     END;     { in range }                      END;     { range check }                   IF NOT goodresponse THEN                 BEGIN    { input error }       "               { build the error message with high and low values }  "                 BuildErrorMsg( hi_value, lo_value, errorstring );                      { go handle input error }  !               InputError( promptstring, save_string, errorstring, !                   internal_result );                     haveprompt := TRUE;                     END;     { input error }               END;     { convert ascii to number }            UNTIL (( goodresponse ) OR (internal_result <> GOOD ));          IF internal_result = GOOD THEN         BEGIN   { have good response }            { save user input in output file }        WriteOnOutput( save_string, internal_result );  	      CheckReturn; 	       END;     { have good response }       900:         passed_result := internal_result;         default := enter_def;     terminator := enter_term;         END;     { IntInput }      $ SUBTITLE 'MinOf2Int16s', PAGE $   FUNCTION MinOf2Int16s     (    integer1:     Int16;          integer2:     Int16 ):  Int16;      { Find the minimum of integer1 and integer2 }     { This routine is necessary because MIN0 cannot be        be called from a CDS program.                      }       
   BEGIN { MinOf2Int16s }  
        IF integer1 < integer2 THEN        MinOf2Int16s := integer1       ELSE         MinOf2Int16s := integer2;       
   END;  { MinOf2Int16s }  
     $ SUBTITLE 'MsgFilePrint', PAGE $   PROCEDURE MsgFilePrint  (     msgnumber:     Int16;         whichroutine:  PrintMsgType;        printinfo:     Int16;     VAR result:        Int16 );       VAR      alreadyprinted:      Boolean;     internal_result:     Int16;     msgfilename: IStringType;     dummy:       Int16;     readlength:  Int16;                  PROCEDURE OpenMsgFile;  CONST      SHARED = 'SHARED';   VAR      dresult:    Int16;          BEGIN    { OpenMsgFile }          msgfileopen := FALSE;         msgfilename := '/SYSTEM/NSINIT.MSG   ';      
   opening := TRUE;  
    RESET( msgfile, msgfilename, SHARED );   
   opening := FALSE; 
        IF NOT hiterror THEN         BEGIN    { message file is open }       
      msgfileopen := TRUE; 
       END      { message file is open }        ELSE         BEGIN    { no file; clear flag }            hiterror := FALSE;        IF NOT toldusernofile THEN           BEGIN    { print the error message }            { Tell the user to put the message file here. }           errorstring := '';            Strwrite( errorstring, 1, dummy,                 '** (9010) NS Error: Message file ',  !            msgfilename:Strlen( msgfilename ), 'not found. **' );  !              PrintError( errorstring, dresult );               toldusernofile := TRUE;           END;     { print the error message }         END;     { no file; clear flag }         END;     { OpenMsgFile }       $ SUBTITLE 'GetMessageString', PAGE $   
PROCEDURE GetMessageString 
 (    msgnumber:       Int16;   VAR msgstring:       String );       VAR      fileno:           Int16;      found:            Boolean;      msgreaderror:     Boolean;      position:         Int16;          BEGIN    { GetMessageString }     errorstring := '';   	   found := FALSE; 	 
   msgreaderror := FALSE;  
        WHILE (( NOT EOF( msgfile )) AND ( NOT found ) AND                     ( NOT msgreaderror )) DO        BEGIN    { read a line from the file }        reading := TRUE;        hiterror := FALSE;        READLN( msgfile, msgstring );         reading := FALSE;         IF hiterror THEN           BEGIN    { error reading file }               msgreaderror := TRUE;           END      { error reading file }          ELSE           BEGIN    { see if this line is the one we want }                position := Strpos( msgstring, '(' );           IF position > 0 THEN               BEGIN    { have start of number indication }      %            { use errorstring to extract the number from the parenthesis } %             errorstring := Str( msgstring, position + 1,                    Strlen( msgstring ) - position );                   position := Strpos( errorstring, ')' );                   IF position > 0 THEN                 BEGIN    { have end of number indication }                      Strdelete( errorstring, position,                       Strlen( errorstring ) - position );      "               { convert the number from char to int16 for compare } "                converting := TRUE;                 Strread( errorstring, 1, position, fileno );                  converting := FALSE;                       { IF the number in parenthesis = to the msgnumber   !                 then we have found the string to print.         } !                 IF (( NOT hiterror ) AND ( fileno = msgnumber ))                      THEN found := TRUE                   ELSE hiterror := FALSE;                     END;     { have end of number indication }               END;     { have start of number indication }           END;     { see if this line is the one we want }         END;     { read a line from the file }         { If we didn't find the message in the file indicate that       to the caller by re-initializing the message string.    }     IF NOT found then msgstring := '';          END;     { GetMessageString }      $ SUBTITLE 'MsgFilePrint', PAGE $   BEGIN  { MsgFilePrint }       IF msgnumber = 0 THEN      BEGIN    { initialize flag }   !   { Users of this routine MUST call it once with a msgnumber of 0 ! "     to initialize the "toldusernofile" flag.                      } "    toldusernofile := FALSE;      END      { initialize flag }     ELSE     BEGIN    { use the message file }         OpenMsgFile;      internal_result := GOOD;      save_string := '';          IF msgfileopen THEN        BEGIN    { get the message from the file }            GetMessageString( msgnumber, save_string );         END;     { get the message from the file }         IF save_string = '' THEN         BEGIN    { build a generic message }      "      { Either there was no file or the message wasn't in the file.  " #        Build a generic message, appending the error number.        }  #     "      Strwrite( save_string, 1, dummy, '** NSINIT message number: ', "             msgnumber:1, '. ' );        END;     { build a generic message }         IF whichroutine = PMT_PROMPT THEN        BEGIN { call PrintPrompt }        IF printinfo < 0 THEN            alreadyprinted := TRUE           ELSE           alreadyprinted := FALSE;       !      PrintPrompt( alreadyprinted, save_string, internal_result )  !       END   { call PrintPrompt }       ELSE         BEGIN { call PrintError }             IF printinfo <> 0 THEN           BEGIN    { append the errorvalue to the string. }      &         Strwrite( save_string, Strlen( save_string )+1, dummy, printinfo:1, & 
                  '.**' ); 
          END;     { append the errorvalue to the string }             PrintError( save_string, internal_result );         END;  { call PrintError }          { pass any error back to caller }     result := internal_result;      END;     { use the message file }  END;  { MsgFilePrint }      $ SUBTITLE 'PrintPrompt', PAGE $  {------------------------------------------------------------}  {                                                            }  {               PrintPrompt                                  }  {                                                            }  {------------------------------------------------------------}  PROCEDURE PrintPrompt     (    haveprompt:             Boolean;          promptstring:       PromptType;     VAR passed_result:      Int16);      {}  { Purpose:  !{  To print a prompt on the device from which input is to be read, ! {  and on the output device if appropriate.   {   {  Input:   #{     haveprompt:       TRUE if caller does not wish prompt displayed  # {                       on the output device  {     promptstring: string to be displayed  {   {  Output:  {     result:       =0 if no error, <0 otherwise.   {   {  Global variables accessed:   none  {  Side Effects: none   {   {}      LABEL      900;       CONST      COMMENT_DELIM = '* ';          VAR   "   internal_result:     Int16;          { internal error parameter } " "   finish:              Int16;          { used by GetPromptSection } " "   msg_left:            Int16;          { used by GetPromptSection } " "   msg_section:         IStringType;    { used by GetPromptSection } " "   prompt_printed:      Boolean;        { used:by GetPromptSection } "     $ SUBTITLE 'CheckReturn (PrintPrompt)', PAGE $  {------------------------------------------------------------}  {  ( LOCAL )      CheckReturn         ( LOCAL )              }  {------------------------------------------------------------}  PROCEDURE CheckReturn;  {}  {  This procedure is used to test the return parameter from   {  PrintPrompt's subroutine calls.  If an error was bubbled   {  back up the routine does a GOTO to exit from PrintPrompt.  {   {}      
   BEGIN   { CheckReturn } 
        IF (( internal_result <> GOOD ) OR ( hiterror )) THEN        BEGIN    { error getting input }            IF hiterror THEN           BEGIN       { hit pascal error catcher }            hiterror := FALSE;            pascal_error.ernumber := 0;           IF internal_result = GOOD THEN               BEGIN    { need to print an error }               internal_result := ERRPASCAL_ERRC;              END;     { need to print an error }            END;        { hit pascal error catcher }             GOTO 900;         END;     { error getting input }      
   END;    { CheckReturn } 
     $ SUBTITLE 'GetPromptSection (PrintPrompt)', PAGE $   {------------------------------------------------------------}  {  ( LOCAL )      GetPromptSection    ( LOCAL )              }  {------------------------------------------------------------}     PROCEDURE GetPromptSection;         CONST            { is this value reasonable? }         MAX_LINE_LEN = 76;         VAR        section_len:      Int16;        start:            Int16;        start_of_prompt:  Int16;          {    PrintPrompt variables accessed:        promptstring       Passed to PrintPrompt by its caller.                           Contains the message to be sectioned.             finish            Initialized by PrintPrompt.   #                        Used to keep track where last print finished.  #           msg_left          Initialized by GetPromptSection.  !                        Accessed only by this routine; need value  !                             to stay constant through calls.             msg_section       Initialized by PrintPrompt.   #                        Will contain the section for printing on exit. #           prompt_printed    Initialized by GetPromptSection.  "                        Will be TRUE if last section of promptstring " #                            is in msg_section; FALSE if more calls to  # $                            the routine are necessary for more sections. $ }          BEGIN    { GetPromptSection }      !   { get position of where caller's prompt will start in section } !    start_of_prompt := Strlen( msg_section ) + 1;      
   start := finish;  
        { msg_left will be set on entry of PrintPrompt and         will be updated as the message is sectioned.    }          IF msg_left > MAX_LINE_LEN THEN        BEGIN    { section print }            finish := start + MAX_LINE_LEN;             IF promptstring[ finish ] <> ' ' THEN            BEGIN    { find word boundary }               REPEAT               finish := finish - 1;               UNTIL (( finish < start ) OR                        ( promptstring[ finish ] = ' ' ));               IF finish < start THEN               BEGIN    { Error }              internal_result := ERRPRINTPROMPT;              CheckReturn;              END;     { Error }               { increment past ' ' }            finish := finish + 1;               END;     { find word boundary }            section_len := finish - start;        prompt_printed := FALSE;        msg_left := msg_left - section_len;             END      { section print }       ELSE         BEGIN    { no sectioning needed }             section_len := msg_left;        prompt_printed := TRUE;             END;     { no sectioning needed }          Strmove( section_len, promptstring, start,                            msg_section, start_of_prompt );         END;     { GetPromptSection }      $ SUBTITLE 'PrintPromptSection (PrintPrompt)', PAGE $   {------------------------------------------------------------}  {  ( LOCAL )   PrintPromptSection     ( LOCAL )              }  {------------------------------------------------------------}     PROCEDURE PrintPromptSection;      !{ Print a section of the prompt the caller passed to PrintPrompt } ! {}         BEGIN   { PrintPromptSection }          internal_result := GOOD;          WriteOnInput( msg_section, internal_result );     CheckReturn;       
   IF NOT haveprompt THEN  
       BEGIN    { print prompt on output device }            WriteOnOutput( msg_section, internal_result );  	      CheckReturn; 	       END;     { print prompt on output device }         END;    { PrintPromptSection }   $ SUBTITLE 'PrintPrompt' , PAGE $       
   BEGIN   { PrintPrompt } 
        internal_result := GOOD;          SetStrlen( msg_section, 0 );      finish := 1;          { get length of the new message }     msg_left := Strlen( promptstring );         REPEAT      { prompt_printed }             { Break prompt into sections }        GetPromptSection;   	      CheckReturn; 	           { Note: GetPromptSection will set prompt_printed to           TRUE when it has the last section ready for printing }            { Print the prompt in the proper place(s) }   
      PrintPromptSection;  
 	      CheckReturn; 	           IF NOT prompt_printed THEN           BEGIN    { have more to print }           { set msg_section up for the next print }           msg_section := COMMENT_DELIM;           END;     { have more to print }             UNTIL (( prompt_printed ) OR ( internal_result <> GOOD ));       900:         passed_result := internal_result;      
   END;    { PrintPrompt } 
     $ SUBTITLE 'Prompt_ReadResponse', PAGE $  {------------------------------------------------------------}  {                                                            }  {               Prompt_ReadResponse                          }  {                                                            }  {------------------------------------------------------------}  PROCEDURE Prompt_ReadResponse     (    haveprompt:             Boolean;          promptstring:       PromptType;     VAR input_string:       String;     VAR passed_result:      Int16);      {}  { Purpose:  %{  To print a prompt on the input device, and to read a response from the  % !{  input device. The input is checked if it is a comment, and will ! "{  be saved in the output device if it is.  A new input line will be " {  read if the previous one was a comment.  {   {  Input:   #{     haveprompt:       TRUE if caller does not wish prompt displayed  #  {     promptstring: string to be displayed before reading input    {   {  Output:  {     input_string: string where user input is placed.  {     result:       =0 if no error, <0 otherwise.   {   {  Global variables accessed: none  {  Side Effects: none   {   {  Routines called:  Display, ReadInput.  {   {}  LABEL      900;       VAR   "   internal_result:     Int16;          { internal error parameter } "     $ SUBTITLE 'CheckReturn (Prompt_ReadResponse)', PAGE $  {------------------------------------------------------------}  {  ( LOCAL )       CheckReturn        ( LOCAL )              }  {------------------------------------------------------------}  PROCEDURE CheckReturn;  {}  {  This procedure checks the return from subroutines called   {  by Prompt_ReadResponse.  It then does a GOTO to  {  exit from the routine if the return was an error.  {   {}      
   BEGIN   { CheckReturn } 
        IF (( internal_result <> GOOD ) OR ( hiterror )) THEN        BEGIN    { error getting input }        IF internal_result = IABORT THEN           BEGIN    { user entered abort seq. }            input_string := 'AB';           END      { user entered abort seq. }           ELSE           BEGIN    { other error }            input_string := '';  
         IF hiterror THEN  
             BEGIN          { hit pascal error catcher }               hiterror := FALSE;              pascal_error.ernumber := 0;               IF internal_result = GOOD THEN                 BEGIN    { need to print an error }                 internal_result := ERRPASCAL_ERRC;                  END;     { need to print an error }              END;           { hit pascal error catcher }            END;     { other error }             GOTO 900;             END;     { error getting input }  
   END;    { CheckReturn } 
     $ PAGE $         BEGIN   { Prompt_ReadResponse }         internal_result := GOOD;          REPEAT         { input_string[1] <> '*' }            { print ( sectioned if necessary ) on proper devices }         PrintPrompt( haveprompt, promptstring, internal_result );    	      CheckReturn; 	           { Get the user input }        ReadInput( input_string, internal_result );   	      CheckReturn; 	           IF input_string[1] = '*' THEN            BEGIN    { save comment }               WriteOnOutput( input_string, internal_result );           CheckReturn;                haveprompt := TRUE;           END;     { save comment }            UNTIL input_string[1] <> '*';       900:        passed_result := internal_result;          END;    { Prompt_ReadResponse }      $ SUBTITLE 'WordInput', PAGE $  {------------------------------------------------------------}  {                                                            }  {                        WordInput                           }  {                                                            }  {------------------------------------------------------------}  
PROCEDURE WordInput  
   (    promptstring:       PromptType;     VAR default:            Boolean;      VAR string_of_tokens:   String;     VAR token_from_user:    String;     VAR passed_result:      Int16);     { Prompt user with promptstring; read input and make sure        it is one of the tokens in string_of_tokens            }      {}   {  WordInput is used to have the user enter one of the tokens in   #{  string_of_tokens.  It is a standard input routine like YesNoInput.  # {   {  Input:   !{     promptstring-     prompt to display for the interactive user ! {     default-          TRUE if caller accepts /D   {     string_of_tokens  String of tokens- separated by commas.  {   {  Output:  "{     token_from_user   token that user entered if passed_result = 0 " {                       undefined otherwise   {     passed_result     =0 if no error <> 0 Otherwise   {   {  Global Variables Accessed:   {     From Parser: errorstring, save_string, user_string.   {     From Init_Dec: hiterror, pascal_error   {   {  Routines called: Strupshift, CommentCheck, InputError.   {     Prompt_ReadResponse, WriteOnOutput, MinOf2Int16s.   {   {  Side Effects: none   {   {  Algorithm:   !{     The string_of_tokens is checked for validity.  If there are  !  {     no tokens the result parameter is set to INVALIDCOUNT and    {     the routine returns to the caller.  {   !{     The routine prompts the user for input and gets the response ! {     from Prompt_ReadResponse.   {   {     The input is then checked for comments and default.   {    {     A token is then extracted from string_of_tokens by calling   {     ExtractString.  It is compared against the user's input.  "{     If there is a match, the user input is returned to the caller. " {   !{     If there is no match, the next token in string_of tokens is  ! !{     tested.  This will continue until a match is found or there  ! {     are no more tokens in string_of_tokens to test.   {   !{     If there is no match, an error is printed and the user will  ! "{     be reprompted for a new token if possible.  The error message  " ${     will be constructed from string_of_tokens if the number of tokens  $ "{     is <= 8.  If the number of tokens is greater than 8 a generic  " {     error will be printed.  {   {     If the user cannot be reprompted to enter the input,  {     the routine returns the result param= ERROR.  {   #{     If the input is valid it will be saved in the output file before # {     returning to the caller.  {}      LABEL      900;       CONST      GENERICMSG = '** (9003) NS: Invalid Input. **';  
   MAXTOKENERR = 40; 
     VAR      enter_def:        Boolean;      internal_result:  Int16;      match:            Boolean;      haveprompt:       Boolean;      lastpos:          Int16;      testlen:          Int16;      token:            IStringType;       $ SUBTITLE 'BuildErrorMsg (WordInput)', PAGE $  {------------------------------------------------------------}  {  ( LOCAL )      BuildErrorMsg       ( LOCAL )              }  {------------------------------------------------------------}      
   PROCEDURE BuildErrorMsg 
     (    string_of_tokens:    IStringType;       VAR display_msg:           String );       {}  !{  BuildErrorMsg is used to build an error message for WordInput.  !  {  It changes the comma delimiters between tokens to slashes and   #{  builds the message around this string.  Note that string_of_tokens  # "{  is not a VAR variable, so the string remains as is in WordInput.  " {   !{  input:   string_of_tokens- tokens used to build the error msg.  ! {   {  output:  display_msg- the error message to be displayed  {   {  global variables accessed: none  {  side effects:  none  {   {}     CONST         BASEERR = '** (9004) NS: Invalid Input.  Enter one of: ';          ENDERR = '. **';         VAR        commapos:   Int16;            BEGIN    { BuildErrorMsg }            REPEAT               commapos := Strpos( string_of_tokens, ' ' );                IF commapos <> 0 THEN              BEGIN       { change comma to slash }                   string_of_tokens[ commapos ] := '/';              END;        { change comma to slash }                UNTIL commapos = 0;            display_msg := BASEERR + string_of_tokens + ENDERR;             END;     { BuildErrorMsg }          $ SUBTITLE 'CheckReturn (WordInput)', PAGE $  {------------------------------------------------------------}  {  ( LOCAL )         CheckReturn       ( LOCAL )             }  {------------------------------------------------------------}      
   PROCEDURE CheckReturn;  
     {}  {  CheckReturn is used so there is only one GOTO in WordInput.   {  It is used to exit WordInput in the event of an irrecoverable   {  error.   {   {  input:   none  {  output:  none  {   #{  global variables accessed: pascal_error, hiterror, internal_result  # %{  side effects:  token_from_user will be set to null if an error occurs.  % {   {}        BEGIN    { CheckReturn }            IF (( internal_result <> GOOD ) OR ( hiterror )) THEN            BEGIN    { an error has occurred }            { An irrecoverable error occurred in WordInput.  &           Note that if the error is abort this too will be handled here. }  &     
         IF hiterror THEN  
             BEGIN    { hit pascal error catcher }               hiterror := FALSE;              pascal_error.ernumber := 0;               IF internal_result = GOOD THEN                 BEGIN    { need to print an error }                 internal_result := ERRPASCAL_ERRC;                  END;     { need to print an error }              END;     { hit pascal error catcher }                token_from_user := '';   	         GOTO 900; 	              END;     { an error has occurred }         END;     { CheckReturn }      $ SUBTITLE 'WordInput', PAGE $         BEGIN   { WordInput }         enter_def := FALSE;     internal_result := GOOD;      haveprompt := FALSE;          { upshift the tokens passed by the caller }     StrUpshift( string_of_tokens );         REPEAT   { keep prompting until good input from user }             { assume caller doesn't need "/D" }   
      enter_def := FALSE;  
 	      CheckReturn; 	           token_from_user := '';            { get a line from the input device }        Prompt_ReadResponse( haveprompt, promptstring,                    user_string, internal_result );   	      CheckReturn; 	           { save input in case we're building output file }         save_string := user_string;             StrUpshift( user_string );        token_from_user := '';             testlen := MinOf2Int16s( Strlen( user_string ), TWOCHAR );         Strmove( testlen, user_string, 1, token_from_user, 1 );             { if caller will accept default, check for it }         IF (( default ) AND ( token_from_user = '/D' )) THEN           BEGIN       { default }           { user wants defaults }               enter_def := TRUE;            match := TRUE;            token_from_user := '';                END         { default }          ELSE           BEGIN       { not default }               { strip any comments from the input }           CommentCheck( user_string );                { Find out if the user input matches a toekn in               string_of_tokens.  If it does, token_from_user will    #            contain the token.  If not, contine testing all the tokens # $            in string_of_tokens.  ExtractString will set internal_result $ %            to ERREND_STR when it hits the end of the string.           }  %              { set up offset into string_of_tokens. }            lastpos := 0;           match := FALSE;               REPEAT       $            { token_from_user is used to tell ExtractString not to check $ %               the string for a match.  It should always be null.        } %             token_from_user := '';  #            ExtractString( string_of_tokens, lastpos, token_from_user, #                   token, internal_result );               IF internal_result = GOOD THEN                 BEGIN    { compare user's input to one token }                      testlen := MinOf2Int16s( Strlen( token ),  #                                              Strlen( user_string ));  # !               token_from_user := Str( user_string, 1, testlen );  !                IF token_from_user = token THEN                                           match := TRUE;                  END;     { compare user's input to one token }                   { Note: token is initialized in ExtractString }               UNTIL ( match OR                           ( internal_result = ERREND_STR ));                END;        { not default }            IF internal_result <> GOOD THEN            BEGIN    { invalid response }               IF Strlen( string_of_tokens ) < MAXTOKENERR THEN               BEGIN    { build error msg with caller's tokens }                   BuildErrorMsg( string_of_tokens, errorstring );               END      { build error msg with caller's tokens }              ELSE               BEGIN    { use generic error msg }                  errorstring := GENERICMSG;              END;     { use generic error msg }               InputError( promptstring, save_string, errorstring,                       internal_result );                haveprompt := TRUE;               END      { invalid response }          ELSE           BEGIN    { have match }           match := TRUE;            END;     { have match }            UNTIL ( match OR ( internal_result <> GOOD ));         IF internal_result = GOOD THEN         BEGIN  { good input from user }             WriteOnOutput( save_string, internal_result );  	      CheckReturn; 	           END;   { good input from user }       900:         passed_result := internal_result;     default := enter_def;      
   END;     { WordInput }  
     $ SUBTITLE 'YesNoInput', PAGE $   {------------------------------------------------------------}  {                                                            }  {                       YesNoInput                           }  {                                                            }  {------------------------------------------------------------}  
PROCEDURE YesNoInput 
   (    promptstring:       PromptType;     VAR default:            Boolean;      VAR yesnovalue:         OneCharType;      VAR passed_result:      Int16);     { Prompt user with promptstring; read a Y/N from the user }  {}       {  Purpose: To prompt a user for input and to read and check an    
{     input string.  
 {   {  Input:   "{     promptstring  character string to be displayed as input prompt " #{     haveprompt    TRUE if the promptstring was previously displayed  # {                    for the same question.  FALSE otherwise  {                    NOT USED CURRENTLY   !{     default       TRUE if caller will accept "/D" as valid input ! {   {  Output:  #{     default       TRUE if user entered "/D" and this was valid input # "{     yesnovalue    value of single character user entered. Will be  " !{                   y/n if input good, d for default, e for error. ! !{     result        <= 0 if problem during execution, =0 otherwise ! {   {  Global variables accessed: none  {  Side Effects:  {     The input device will be temporarily changed to the log    {     device if the input device is not interactive and there is   !{     an error getting the input.  This will only occur if the log ! {     device is interactive.  When the user enters the correct  "{     response to the prompt, the input device will be changed back  " {     to the old device.  {  Routines called:  Display, Prompt_ReadResponse, StrUpshift,  {                    CommentCheck, InputError.  {   {}      {}  {  Description:   #{     YesNoInput calls Prompt_ReadResponse to get a line of input from # {     the input device.   {   ${     The input will be returned to YesNoInput, after it is checked for  $ {     comments.   {   {     If result = IABORT YesNoInput returns to the caller.  {   !{     After reading the input, the character string is checked for ! !{     /D if the default flag indicates that the caller will accept ! 
{     this as valid input. 
 {   !{     If the string is "/D" and this is acceptable input, control  ! {     is returned to the caller.  {   #{     If the string is not one of these values it is checked to see if # ${     the first char of the string is "Y" or "N".  If it is one of these $ {     characters, the routine terminates with no errors.  {   !{     If the input is not ok and the input device is interactive,  ! %{     the prompt will be re-written and the input re-read until it is ok.  % ${     If the device is not interactive, the input device will be changed $ #{     to be the log device if it is interactive.  If the log device is # {     not interactive, result will be set to ERROR.   #{     If the input is not ok and the input device is not interactive,  #  {     IntInput will set result = error, as there are no options    {     to re-read the input.   {   !{     yesnovalue will be Y or N if the user entered yes or no, as  ! ${     appropriate.  If the default value was entered yesnovalue will be  $ !{     D. The value will be E if any error occurred in YesNoInput.  ! {}  $ PAGE $      LABEL       "   900;                 { used to exit out of YesNoInput on errors } "     VAR       $   enter_def:     Boolean;     { TRUE if user entered "/D" and "/D" ok } $    goodresponse:  Boolean;     { TRUE if good input was read }  
   internal_result: Int16; 
 '   haveprompt:        Boolean;     { TRUE if already prompted for this input } '    testlen:       Int16;  %   test_string:   TwoCharType;  { temp. storage to test for "/D" & "/E" }  %     $ SUBTITLE 'CheckReturn (YesNoInput)', PAGE $   {------------------------------------------------------------}  {  ( LOCAL )          CheckReturn            ( LOCAL )       }  {------------------------------------------------------------}  
   PROCEDURE CheckReturn(  
       VAR yesnovalue:   OneCharType);       {}   {  CheckReturn is used so there is only one GOTO in YesNoInput.    !{  It is used to exit YesNoInput in the event of an irrecoverable  ! {  error.   {   {  input:   none  {  output:   {     yesnovalue - changed to 'E' to indicate an error occurred.   {   {  global variables accessed: none  {  side effects:  none  {   {}        BEGIN    { CheckReturn }            IF (( internal_result <> GOOD ) OR ( hiterror )) THEN            BEGIN           { An irrecoverable error occurred in YesNoInput.              Make the user input string= 'E'.   &           Note that if the error is abort this too will be handled here. }  &     
         IF hiterror THEN  
             BEGIN    { hit pascal error catcher }               hiterror := FALSE;              pascal_error.ernumber := 0;               IF internal_result = GOOD THEN                 BEGIN    { need to print an error }                 internal_result := ERRPASCAL_ERRC;                  END;     { need to print an error }              END;     { hit pascal error catcher }                yesnovalue := 'E';   	         GOTO 900; 	              END;         END;     { CheckReturn }      $ PAGE $         BEGIN   {YesNoInput}       
   goodresponse := FALSE;  
    internal_result := GOOD;      enter_def := FALSE;      
   yesnovalue := ''; 
    haveprompt := FALSE;      test_string := '';          REPEAT   { keep prompting until good input from user }         CheckReturn( yesnovalue );        { assume caller doesn't need "/D" }   
      enter_def := FALSE;  
           { get a line from the input device }        Prompt_ReadResponse( haveprompt, promptstring,                    user_string, internal_result );         CheckReturn( yesnovalue );            { save input in case we're building output file }         save_string := user_string;             StrUpshift( user_string );        test_string := '';      !      testlen := MinOf2Int16s( Strlen( user_string ), TWOCHAR );   !       Strmove( testlen, user_string, 1, test_string, 1 );             { if caller will accept default, check for it }         IF (( default ) AND ( test_string = '/D' )) THEN           BEGIN       { default }           { user wants defaults }           enter_def := TRUE;            goodresponse := TRUE;           yesnovalue := 'D';            END         { default }          ELSE           BEGIN       { not default }      !         { user did not enter "/D" to indicate he wants defaults } !          enter_def := FALSE;               { check input for yes or no }  "         IF ((user_string[1] = 'Y') OR (user_string[1] = 'N')) THEN  "             BEGIN          { yes/no check }                   goodresponse := TRUE;               yesnovalue := Str( user_string, 1, 1 );                   END;           { yes/no check }            END;        { not default }            IF NOT goodresponse THEN           BEGIN    { Not yes/no response }       !         errorstring := '** (9012) NS: Enter Yes or No (Y/N). **'; !          InputError( promptstring, save_string, errorstring,                       internal_result );                haveprompt := TRUE;               END;     { Not yes/no response }         UNTIL (( goodresponse ) OR ( internal_result <> GOOD ));         IF internal_result = GOOD THEN         BEGIN  { good input from user }             WriteOnOutput( save_string, internal_result );        CheckReturn( yesnovalue );            internal_result := GOOD;            END;   { good input from user }       900:         passed_result := internal_result;     default := enter_def;      
   END;     {YesNoInput }  
     END                  { Module parser }  .  