 $PASCAL ',20,9 91790-16173 REV.4010 <860107.1804>'  $TITLE 'Outbound Protocol Main Seg'$  $debug$   $WIDTH 90   $HEAPPARMS OFF  
$RECURSIVE OFF, RANGE OFF$ 
 $HEAP 0   	$HEAP_DISPOSE OFF  	 $STANDARD_LEVEL 'HP1000'      PROGRAM OUTPRO;       {------------------------------------------------------------        (c) COPYRIGHT HEWLETT PACKARD COMPANY 1986. ALL RIGHTS    RESERVED. NO PART OF THIS PROGRAM MAY BE PHOTOCOPIED,   REPRODUCED OR TRANSLATED TO ANOTHER PROGRAM LANGUAGE WITHOUT    THE PRIOR WRITTEN CONSENT OF THE HEWLETT-PACKARD COMPANY.       ------------------------------------------------------------}      {}  
{      NAME: OUTPRO  
 {    SOURCE: 91790-18173  {     RELOC: 91790-16173  {      PGMR: jar  {}      !{---------------------------------------------------------------}  ! !{  OUTPRO.PAS                                                   }  ! !{                                                               }  ! !{  Programmer: CW                                               }  ! !{  Modified  : jr 840208 implement "import from .rel"           }  ! !{     cwj 850214     Added Loadseg call to ensure that segments }  ! !{                    get loaded into memory before DS starts    }  ! !{     cwj 850305     Added IMPORT needed by IPLIB (ipdb, trglb) }  ! {  5/30/85  cwj      Add DS_EnvOK check   {                    Add Dtach call to detach from session   {                    Change PrintMsgType to avoid conflict with    {                    init_dec.  {  6/4/85   cwj      Merged in changes to add LAN   {  7/9/85   lms      Deleted dres, init_dec.  {  7/26/85  jar      Convert to CDS (dump OUTP.PAS)   {  1/ 6/86  jar      Provide OTHERWISE/ELSE for all CASE/IF   {}  {  End of Modifications   !{---------------------------------------------------------------}  !     LABEL 99;       IMPORT                $SEARCH 'phtm/BODEC.XPT'     bodec,                 $SEARCH 'phtm/SODEC.XPT'     sodec,                 $SEARCH 'phtm/MMDEC.XPT'     mmdec,                 $SEARCH 'phtm/MMEXT.XPT'     ds_mm,                 $SEARCH 'phtm/envok.xpt'$      envok,                 $SEARCH 'phtm/TRCMOD.XPT'      trcmod,                $SEARCH 'phtm/SIGMOD.XPT'      sigmod,                $SEARCH 'phtm/TMRDEC.XPT'      tmrdec,                $SEARCH 'phtm/TCPGB.XPT'     tg,                $SEARCH 'phtm/TUSER.XPT'     tuser,   "              $SEARCH 'phtm/IPDEC.XPT,phtm/iplib.XPT,phtm/ipdb.XPT'  "    iplib,   $              $SEARCH 'phtm/IPPATH.XPT,phtm/IPPCTL.XPT,phtm/IPACTP.XPT'  $    ippath,                $SEARCH 'phtm/TCPLB.XPT'     tl,                $SEARCH 'phtm/LKLB.XPT'      lk,                $SEARCH 'phtm/PXPLB.XPT'     px,                $SEARCH 'phtm/LAN8.XPT'$     lan8,                $SEARCH 'phtm/SREGLIB.XPT'$      sreglib,                 $SEARCH 'phtm/outdec.XPT'$     outdec;      VAR      class_num    : Int16;  
   done         : BOOLEAN; 
    enter_err    : Int16;     gsd          : Int16;     gsdbound     : Int16;     gsdmask      : SelBitMapType;     i            : Int16;     lu           : Int16;     rn           : Int16;     wkmp         : Int16;     dummy        : Int16;      !{---------------------------------------------------------------}  ! !{                                                               }  ! !{   EXTERNAL AND FORWARD ROUTINES                               }  ! !{                                                               }  ! !{---------------------------------------------------------------}  !     PROCEDURE AdrOf (     object    : Int16;                        offset    : Int16;                   VAR  byteaddr  : Int16  ); EXTERNAL;       PROCEDURE CNUMD (     value     : Int16;                   VAR  ascii     : Int16  ); EXTERNAL;       PROCEDURE CNUMO (     value     : Int16;                   VAR  ascii     : Int16  ); EXTERNAL;       PROCEDURE DequeueAndPass (     gsd  : Int16;                             VAR wkmp : Int16 ); FORWARD;       PROCEDURE DispatchEvent (     gsd  : Int16;                             VAR wkmp : Int16 ); FORWARD;      PROCEDURE DispatchCall (     gsd    : Int16;                           VAR socket : SocketRecord;                            VAR wkmp   : Int16 ); FORWARD;       PROCEDURE DispatchIFPM (    gsd     : Int16;                          VAR socket  : SocketRecord;                           VAR wkmp    : Int16 ); FORWARD;       PROCEDURE DispatchRoot (     gsd    : Int16;                           VAR socket : SocketRecord;                            VAR wkmp   : Int16    ); FORWARD;      PROCEDURE DispatchVC   (     gsd    : Int16;                           VAR socket : SocketRecord;                            VAR wkmp   : Int16 ); FORWARD;       PROCEDURE Dtach        ( VAR  dummy : Int16);  EXTERNAL;      !FUNCTION $DIRECT$ IAnd ( i : Int16; j : Int16 ) : Int16; EXTERNAL; !     !FUNCTION $DIRECT$ Ior ( i : Int16; j : Int16 ) : Int16; EXTERNAL;  !     !FUNCTION $DIRECT$ Ixor ( i : Int16; j : Int16 ) : Int16; EXTERNAL; !     PROCEDURE PrepTimerResponse (     sigval     : Int16;                                     gsd        : Int16;                                 VAR socket     : SocketRecord;                                VAR wkmp       : Int16;   #                              VAR emsg       : EventMsgType );FORWARD; #     PROCEDURE ProSw ( VAR emsg : EventMsgType;                    VAR ierr : Int16        ); EXTERNAL;      PROCEDURE Rnrq (     icon  : Int16;                    VAR irn   : Int16;                    VAR istat : Int16 ); EXTERNAL;       {---------------------------------------------------------}   {                   PROCEDURES                            }   {---------------------------------------------------------}       PROCEDURE GetOurClass          $ALIAS 'CKCLS'$     (in_class   : Int16;       out_class  : Int16);     EXTERNAL;      !{----------------------------------------------------------------} ! !{   DS SB DEQUEUE                                                } ! !{----------------------------------------------------------------} !     PROCEDURE DS_SBDequeue     (     sbufid      : Int16;            queue       : Int16;            offset      : Int16;       VAR  mbufid      : Int16 );       {}  { Abstract:   {  This is a special routine to dequeue an mbuf from an sbuf.   {  It is provided here as a stopgap measure until the Memory  {  Manager exports the real thing. This routine should be    {  removed as soon as the real MMGR routine has been completed.    {}  VAR   
   ierr     : Int16; 
 
   sbcc     : Int16; 
 
   sbuf     : SBufRecord;  
     BEGIN   DS_MBCopy (-sbufid, 0, MMCOPYALL, mbufid, ierr);  IF (ierr <> SUCCESSFUL) THEN     BEGIN         pathref.ints[1] := sbufid DIV 2;      pathref.ints[2] := ierr;          outp_err_msg.chars := 'DS_SBDequeue problem:';      CNUMD ( ierr, outp_err_msg.ints[12] );          Log_Event ( EL_ERROR, ENTITY_OUTPRO, 1,        pathref, -OUTPLINEBYTELEN, outp_err_msg.ints[1], ierr );         END;   DS_SBDrop (sbufid, -1, SBDATAQ, ierr);      { Now try to correctly reset the outbound DATAREADABLE signal.  {}  DS_SBFetchElement (sbufid, sbuf.int);   sbuf.sb_newcc := sbuf.sb_cc;  DS_SBStoreElement (sbufid, sbuf.int);   DS_SBCheckRdAD (sbufid, SBDATAQ);   
END; {DS_SBDequeue}  
     !{----------------------------------------------------------------} ! !{   DEQUEUE AND PASS                                             } ! !{----------------------------------------------------------------} !     PROCEDURE DequeueAndPass {     gsd  : Int16;                             VAR wkmp : Int16 };  VAR   
   cc             : Int16; 
    mmflags        : MMFlagsType;  
   sbufid         : Int16; 
    vdbuf          : VectoredDataType;       {}  { Abstract:   {  This routine reads in an event message from the control   {  queue of the outbound sbuf of the the socket whose descriptor   {  was passed. Once read in, the event message is sent via  {  ProSw() to the protocol handler to which it is addressed.  {   
{  Entry:   Critical 
 {  Exit:    Uncritical  {   {}      BEGIN       sbufid := gsd + gsd; {sbufid of outbound sbuf}      AdrOf ( outp_emsg.int, 0, vdbuf[1] );   
vdbuf[2] := EMSG_BYTE_LEN; 
     	mmflags.int := 0;  	     
cc := EMSG_BYTE_LEN; 
     DS_SBGet ( vdbuf, 4, sbufid, SBCTRLQ, mmflags, cc, outp_ierr);      
IF ( outp_ierr <> 0 ) THEN 
    BEGIN {  Failed on the DS_SBGet }     pathref.ints[1] := sbufid DIV 2;      pathref.ints[2] := outp_ierr;         outp_err_msg.chars := 'DequeueAndPass problem:';      CNUMD ( outp_ierr, outp_err_msg.ints[12] );         Log_Event ( EL_ERROR, ENTITY_OUTPRO, 11,   "      pathref, -OUTPLINEBYTELEN, outp_err_msg.ints[1], outp_ierr );  "        END;  {  Failed on the DS_SBGet }      
DS_LeaveCritical ( wkmp ); 
 ProSw ( outp_emsg, outp_ierr );       END; {DequeueAndPass}       !{----------------------------------------------------------------} ! !{   DISPATCH CALL                                                } ! !{----------------------------------------------------------------} !     PROCEDURE DispatchCall {     gsd    : Int16;                           VAR socket : SocketRecord;                            VAR wkmp   : Int16 };      {}  { Abstract:   {  This routine is responsible for determining which of   {  the events signalled on a CALL socket should be processed  {  first.   {   
{  Entry:   Critical 
 {  Exit:    Uncritical  {   {}      VAR      signal   : SignalRecord;       BEGIN   WITH socket DO     BEGIN  '   signal.er_ints[1] := Iand (so_ProtoSig.er_ints[1], so_ProtoSig.er_ints[2]); '        IF signal.er_flags[CTRL_READABLE] THEN         BEGIN         CASE so_b.state OF      
         CALL_BOUND: 
 	            BEGIN  	             so_down_cnt := so_down_cnt + 1;               { An event message is queued on the root socket.               { We assume it represents a CONNECT_REQUEST and that               { it is addressed to the SregOb protocol handler.   !            { We want to dequeue it and dispatch it through ProSw. !             {}              DequeueAndPass (gsd, wkmp);               END; {CALL_BOUND case}               CALL_AWAITING_CLEANUP,   
         CALL_CLOSING_OUT: 
 	            BEGIN  	             FlushCallVcq ( socket, outp_ierr );               so_down_cnt := so_down_cnt + 1;               DequeueAndPass (gsd, wkmp);               END; {CALL_AWAITING_CLEANUP}      	         OTHERWISE 	 	            BEGIN  	                 pathref.ints[1] := gsd;               pathref.ints[2] := so_b.state;                  outp_err_msg.chars  :=                 'DispatchCall() CTRL_READABLE state error.';                   Log_Event ( EL_ERROR, ENTITY_OUTPRO, 2,   &               pathref, -OUTPLINEBYTELEN, outp_err_msg.ints[1], outp_ierr ); &                 DS_LeaveCritical ( wkmp );                  END; {OTHERWISE case}            END; {CASE so_b.state}         END      ELSE IF signal.er_flags[EXCEPTIONAL] THEN        BEGIN         so_ProtoSig.er_flags[EXCEPTIONAL] := FALSE;         IF (so_b.state = CALL_CLOSING_OUT) THEN            BEGIN           FlushCallVcq ( socket, outp_ierr );           so_down_cnt := so_down_cnt + 1;           so_b.state := CALL_AWAITING_ABCONF;  
         WITH outp_emsg DO 
 	            BEGIN  	             em_event := ABORT_REQUEST;              ehport := so_down_pid * EHS_PER + EHOB_OFFSET;              emareq_down_ref := so_down_pathref;               emareq_msg_cnt := so_down_cnt;              emareq_reason := -222;              END; {WITH outp_emsg}            DS_Signal ( gsd, OUTBOUND_SIG, socket);           DS_LeaveCritical ( wkmp );            ProSw ( outp_emsg, outp_ierr );           END        ELSE IF (so_b.state = CALL_AWAITING_CLEANUP) THEN            BEGIN           IF (so_up_cnt <> so_final_up) THEN   	            BEGIN  	             so_b.state := CALL_COUNTING_DOWN;               DS_Signal (gsd, OUTBOUND_SIG, socket);              END            ELSE   	            BEGIN  	             FlushCallVcq ( socket, outp_ierr );               MakeSocketFree ( gsd, socket );               END; {IF so_up_cnt}   
         WITH outp_emsg DO 
 	            BEGIN  	             em_event := ABORT_RESPONSE;               ehport := so_down_pid * EHS_PER + EHOB_OFFSET;              emarep_down_ref := so_down_pathref;               emarep_msg_cnt := so_down_cnt;              END; {WITH outp_emsg}            DS_LeaveCritical (wkmp);            Prosw (outp_emsg, outp_ierr);           END        ELSE           BEGIN               pathref.ints[1] := gsd;           pathref.ints[2] := so_b.state;                outp_err_msg.chars  :=               'DispatchCall() EXCEPTIONAL state error.';               Log_Event ( EL_ERROR, ENTITY_OUTPRO, 3,  %            pathref, -OUTPLINEBYTELEN, outp_err_msg.ints[1], outp_ierr );  %              DS_LeaveCritical (wkmp);                END; {IF so_b.state}         END      ELSE         BEGIN          { We've received a kind of signal that shouldn't even have         { been enabled on a CALL socket. This is serious. We do         { what we can to disable the spurious signal. We also         { print out an error message.         {}            pathref.ints[1] := gsd;             outp_err_msg.chars :=            'DispatchCall() bad signal. ';         CNUMO ( so_protosig.er_ints[1], outp_err_msg.ints[15] );        CNUMO ( so_protosig.er_ints[2], outp_err_msg.ints[19] );            Log_Event ( EL_ERROR, ENTITY_OUTPRO, 4,   #         pathref, -OUTPLINEBYTELEN, outp_err_msg.ints[1], outp_ierr ); #           so_protosig.longint := 0;         so_protosig.er_flags[CTRL_RSELENABLE] := TRUE;        so_protosig.er_flags[XSELENABLE] := TRUE;             DS_LeaveCritical (wkmp);            END; {IF signal}     END; {WITH socket}   
END; {DispatchCall}  
     !{----------------------------------------------------------------} ! !{   DISPATCH ROOT                                                } ! !{----------------------------------------------------------------} !     PROCEDURE DispatchRoot {     gsd    : Int16;                           VAR socket : SocketRecord;                            VAR wkmp   : Int16     };      {}  { Abstract:   {  This routine determines which of the events signalled in a   {  socket's outbound signal record should be processed first.   {   
{  Entry:   Critical 
 {  Exit:    Uncritical  {   {}      VAR      signal      : SignalRecord;      BEGIN   WITH socket DO     BEGIN  '   signal.er_ints[1] := Iand (so_ProtoSig.er_ints[1], so_ProtoSig.er_ints[2]); '    IF signal.er_flags[CTRL_READABLE] THEN         BEGIN         IF (so_b.state = ROOT_TRANSACTING) THEN            BEGIN           DS_SoStoreElement (gsd, socket.int );           DequeueAndPass (gsd, wkmp);           END        ELSE           BEGIN               pathref.ints[1] := gsd;           pathref.ints[2] := so_b.state;                outp_err_msg.chars  :=               'DispatchRoot() CTRL_READABLE state error.';               Log_Event ( EL_ERROR, ENTITY_OUTPRO, 5,  %            pathref, -OUTPLINEBYTELEN, outp_err_msg.ints[1], outp_ierr );  %              DS_LeaveCritical ( wkmp );                END; {IF so_b.state}         END      ELSE IF signal.er_flags[SAT_BEAMABLE] THEN         BEGIN         so_ProtoSig.er_flags[SAT_BEAMABLE] := FALSE;        DS_Signal (gsd, OUTBOUND_SIG, socket);        WITH outp_emsg DO            BEGIN           em_event := SAT_BEAM;           ehport := so_down_pid * EHS_PER + EHOB_OFFSET;            emsb_down_ref := so_down_pathref;           END; {WITH outp_emsg}        DS_LeaveCritical (wkmp);        ProSw(outp_emsg, outp_ierr);        END      ELSE IF signal.er_flags[TIMERABLE_1] THEN        BEGIN   "      PrepTimerResponse(TIMERABLE_1, gsd, socket, wkmp, outp_emsg);  "       END      ELSE IF signal.er_flags[TIMERABLE_2] THEN        BEGIN   "      PrepTimerResponse(TIMERABLE_2, gsd, socket, wkmp, outp_emsg);  "       END      ELSE IF signal.er_flags[TIMERABLE_3] THEN        BEGIN   "      PrepTimerResponse(TIMERABLE_3, gsd, socket, wkmp, outp_emsg);  "       END      ELSE         BEGIN             pathref.ints[1] := gsd;             outp_err_msg.chars :=            'DispatchRoot() bad signal:';        CNUMO ( signal.er_ints[1], outp_err_msg.ints[15] );         CNUMO ( signal.er_ints[2], outp_err_msg.ints[19] );             Log_Event ( EL_ERROR, ENTITY_OUTPRO, 6,   #         pathref, -OUTPLINEBYTELEN, outp_err_msg.ints[1], outp_ierr ); #           DS_LeaveCritical ( wkmp );            END; {IF signal.er_flags}      END; {WITH socket}   
END; {DispatchRoot}  
     !{----------------------------------------------------------------} ! !{   DISPATCH VC                                                  } ! !{----------------------------------------------------------------} !     PROCEDURE DispatchVC   {     gsd    : Int16;                           VAR socket : SocketRecord;                            VAR wkmp   : Int16 };      {}  { Abstract:   {  Determines which of the reportable outbound events that are  {  currently signalled on a socket should be handled first.   {   
{  Entry:   Critical 
 {  Exit:    Uncritical  {   {}      VAR      signal   : SignalRecord;       BEGIN   WITH socket DO     BEGIN  '   signal.er_ints[1] := Iand (so_ProtoSig.er_ints[1], so_ProtoSig.er_ints[2]); '    IF signal.er_flags[EXCEPTIONAL] THEN         BEGIN         { Our VC socket's state has changed significantly.        {}        CASE so_b.state OF      
         VC_USER_ABORTED:  
 	            BEGIN  	             so_b.state := VC_AWAITING_ABCONF;               so_ProtoSig.er_flags[EXCEPTIONAL] := FALSE;               so_down_cnt := so_down_cnt + 1;               DS_Signal ( gsd, OUTBOUND_SIG, socket );                  WITH outp_emsg DO   
               BEGIN 
                em_event := ABORT_REQUEST;   "               ehport := socket.so_down_pid * EHS_PER + EHOB_OFFSET; "                emareq_down_ref := socket.so_down_pathref;                  emareq_msg_cnt := so_down_cnt;                  emareq_reason := U_ABORTED_BY_PEER;                 END; {WITH outp_emsg}              DS_LeaveCritical ( wkmp );              ProSw ( outp_emsg, outp_ierr );               END; {VC_USER_ABORTED case}                VC_OPEN_ACCEPTING:   	            BEGIN  	             so_b.state := VC_OPEN;              so_ProtoSig.er_flags[EXCEPTIONAL] := FALSE;               so_down_cnt := so_down_cnt + 1;               DS_Signal ( gsd, OUTBOUND_SIG, socket );                  WITH outp_emsg DO   
               BEGIN 
                em_event := CONNECT_RESPONSE;                 ehport := so_down_pid * EHS_PER + EHOB_OFFSET;                  emcrs_up_ref := gsd;                  emcrs_down_ref := so_down_pathref;   #               emcrs_max_window := so_k.max_rcvcc * so_k.max_burstin;  #                emcrs_max_snds := so_k.max_burstout;                  emcrs_options.int := 0;                 emcrs_options.bits[0] := so_f.msgmode;                  emcrs_options.bits[-1] := so_f.checksum;                  END; {WITH outp_emsg}              DS_LeaveCritical ( wkmp );              ProSw ( outp_emsg, outp_ierr );               END; {VC_OPEN_ACCEPTING}               VC_AWAITING_CLEANUP:   	            BEGIN  	             MakeSocketFree (gsd, socket);               DS_LeaveCritical ( wkmp);               END; {VC_AWAITING_CLEANUP case}       	         OTHERWISE 	 	            BEGIN  	                 pathref.ints[1] := gsd;               pathref.ints[2] := so_b.state;                  outp_err_msg.chars :=                  'DispatchVC() EXCEPTIONAL state error.';                   Log_Event ( EL_ERROR, ENTITY_OUTPRO, 8,   &               pathref, -OUTPLINEBYTELEN, outp_err_msg.ints[1], outp_ierr ); &                 DS_LeaveCritical ( wkmp );                  END;               END; {Case so_b.state}         END      ELSE IF signal.er_flags[DATA_READABLE] THEN        BEGIN         so_down_cnt := so_down_cnt + 1;         DS_SoStoreElement (gsd, socket.int);        CASE so_b.state OF      	         VC_OPEN:  	 	            BEGIN  	             WITH outp_emsg DO   
               BEGIN 
                em_event := SEND_REQUEST;                 ehport := so_down_pid * EHS_PER + EHOB_OFFSET;                  emsr_down_ref := so_down_pathref;                 emsr_mbufid := MEANINGLESS;                 emsr_dlen := 0;                 emsr_flags.int := 0;                  emsr_opt_mbufid := MEANINGLESS;                 END; {WITH outp_emsg}              DS_LeaveCritical ( wkmp );              ProSw ( outp_emsg, outp_ierr );               END; {VC_OPEN case}       	         OTHERWISE 	 	            BEGIN  	                 pathref.ints[1] := gsd;               pathref.ints[2] := so_b.state;                  outp_err_msg.chars :=                  'DispatchVC() DATA_READABLE state error.';                   Log_Event ( EL_ERROR, ENTITY_OUTPRO, 9,   &               pathref, -OUTPLINEBYTELEN, outp_err_msg.ints[1], outp_ierr ); &                 DS_LeaveCritical ( wkmp );                  END;               END; {CASE so_b.state}         END      ELSE IF signal.er_flags[SAT_BEAMABLE] THEN         BEGIN         WITH outp_emsg DO            BEGIN           em_event := SAT_BEAM;           ehport := so_down_pid * EHS_PER + EHOB_OFFSET;            emsb_down_ref := so_down_pathref;           END; {WITH outp_emsg}            { Clear out the SAT_BEAM signal and see to it that        { the pmap gets cleared if necessary. Also we increment         { our socket's emsg reference count so we don't run into        { any problems while abort processing.        {}        so_down_cnt := so_down_cnt + 1;         so_ProtoSig.er_flags[SAT_BEAMABLE] := FALSE;        DS_Signal ( gsd, OUTBOUND_SIG, socket);         DS_LeaveCritical (wkmp);        ProSw (outp_emsg, outp_ierr);         END      ELSE IF signal.er_flags[WRITEABLE] THEN        BEGIN         WITH outp_emsg DO            BEGIN           em_event := WSELECT_NOTIFICATION;           ehport := so_down_pid * EHS_PER + EHOB_OFFSET;            emwn_up_ref := so_down_pathref;           emwn_down_ref := so_down_pathref;           END; {WITH outp_emsg}  &      so_down_cnt := so_down_cnt + 1; {counts the emsg we're about to send}  &       DS_SoStoreElement (gsd, socket.int);        DS_LeaveCritical (wkmp);        ProSw (outp_emsg, outp_ierr);         END      ELSE IF signal.er_flags[TIMERABLE_1] THEN        BEGIN   "      PrepTimerResponse(TIMERABLE_1, gsd, socket, wkmp, outp_emsg);  "       END      ELSE IF signal.er_flags[TIMERABLE_2] THEN        BEGIN   "      PrepTimerResponse(TIMERABLE_2, gsd, socket, wkmp, outp_emsg);  "       END      ELSE IF signal.er_flags[TIMERABLE_3] THEN        BEGIN   "      PrepTimerResponse(TIMERABLE_3, gsd, socket, wkmp, outp_emsg);  "       END      ELSE         BEGIN             pathref.ints[1] := gsd;             outp_err_msg.chars :=            'DispatchVC() bad signal:';        CNUMO ( signal.er_ints[1], outp_err_msg.ints[15] );         CNUMO ( signal.er_ints[2], outp_err_msg.ints[19] );             Log_Event ( EL_ERROR, ENTITY_OUTPRO, 10,  #         pathref, -OUTPLINEBYTELEN, outp_err_msg.ints[1], outp_ierr ); #           DS_LeaveCritical ( wkmp );            END; {IF signal.er_flags}      END; {WITH socket}   	END; {DispatchVC}  	     !{----------------------------------------------------------------} ! !{   Dispatch Event                                               } ! !{----------------------------------------------------------------} !     PROCEDURE DispatchEvent {     gsd     : Int16;                            VAR wkmp    : Int16 };      {}  { Abstract:   {  Invoked when the occurence of a reportable event has been  {  detected. Evaluates the nature of the event and then   {  invokes the appropriate protocol handler to process the  {  event.   {   {   
{  Entry:   Critical 
 
{  Exit:    Critical 
 {   
{ Input parameters:  
 {    {  gsd: Global socket descriptor of a socket upon which a signal   {     has been detected.  {    {  wkmp: Active working map of the critical caller -- this value   {     must have been obtained from a DS_EnterCritical call.   {}      VAR      signal         : SignalRecord;      socket         : SocketRecord;           BEGIN  {DispathEvent}   DS_SoFetchElement ( gsd, socket.int );  WITH socket DO     BEGIN     signal.er_ints[1] := Iand ( so_ProtoSig.er_ints[1],                                    so_ProtoSig.er_ints[2] );   
   CASE so_b.kind OF 
           ROOTSOCKET:  DispatchRoot ( gsd, socket, wkmp);             CALL:        DispatchCall (gsd, socket, wkmp);            VC:          DispatchVC   (gsd, socket, wkmp);            IFPM:        DispatchIFPM (gsd, socket, wkmp);            OTHERWISE            BEGIN               pathref.ints[1] := gsd;           pathref.ints[2] := so_b.kind;               outp_err_msg.chars :=              'DispatchEvent() Illegal Socket Kind.';                Log_Event ( EL_ERROR, ENTITY_OUTPRO, 7,  %            pathref, -OUTPLINEBYTELEN, outp_err_msg.ints[1], outp_ierr );  %              DS_LeaveCritical ( wkmp );                END; {OTHERWISE case}  
      END; {CASE so_kind}  
        END; {WITH socket}   DS_EnterCritical (wkmp, outp_ierr);   
END; {DispatchEvent} 
     !{----------------------------------------------------------------} ! !{   DISPATCH IFPM                                                } ! !{----------------------------------------------------------------} !     PROCEDURE DispatchIFPM  
   {      gsd     : Int16; 
      VAR  socket  : SocketRecord;        VAR  wkmp    : Int16 };      {}  {  Abstract: Picks a message from IFP's socket, and passes it   {     down the prostack.  {   
{  Entry:   Critical 
 {  Exit:    Uncritical  {   {}      VAR   
   mbufid   : Int16; 
 
   sbuf     : SBufRecord;  
 
   sbufid   : Int16; 
     BEGIN   
sbufid := gsd + gsd; 
 DS_SBDequeue (sbufid, SBDATAQ, 0, mbufid);  
WITH outp_emsg, socket DO  
    BEGIN     em_event := SEND_REQUEST;     ehport := so_down_pid * EHS_PER + EHOB_OFFSET;      emsr_down_ref := so_down_pathref;  
   emsr_mbufid := mbufid;  
        { WARNING: The character count sent down to the supporting      { protocol will be negative if EOM was not found by MMGR.     {}      DS_CharsInMbuf (mbufid, 0, emsr_dlen, outp_ierr);         { We need to make sure that the socket's outbound readable      { signal gets reset appropriately.      {}      DS_SBFetchElement (sbufid, sbuf.int);     WITH socket, sbuf DO         BEGIN         sb_newcc := sb_cc;  $      so_protosig.er_flags[DATA_READABLE] := (sb_newcc >= sb_rdthresh);  $       END; {WITH socket}     DS_SBStoreElement (sbufid, sbuf.int);     DS_SoStoreElement (gsd, socket.int);      DS_SBCheckRdAD (sbufid, SBDATAQ);         emsr_flags.int := 0;      emsr_opt_mbufid := MEANINGLESS;     END; {WITH outp_emsg}  DS_LeaveCritical (wkmp);  ProSw (outp_emsg, outp_ierr);   
END; {DispatchIFPM}  
     !{----------------------------------------------------------------} ! !{   PREP TIMER RESPONSE                                          } ! !{----------------------------------------------------------------} !     PROCEDURE PrepTimerResponse {     sigval     : Int16;                                     gsd        : Int16;                                 VAR socket     : SocketRecord;                                VAR wkmp       : Int16;                                 VAR emsg       : EventMsgType };      {}  { Abstract:   {  This routine may be called by any of the various Dispatch*   {  routines. PrepTimerResponse will prepare a TIMER_RESPONSE  {  event message and ProSw() it down to the protocol that   {  the referenced socket is bound to. The routine will also   {  clear the TIMERABLE_* signal flag in the referenced socket   {  and will write the socket out to DSAM.   {   
{  Entry:   Critical 
 {  Exit:    Uncritical  {   
{ Input Parameters:  
 {   {  sigval: The kind of timer signal that should be processed.   {   "{  gsd: The global descriptor of the socket through which the timer  " {     signal has been sent.   {   {  socket: The SocketRecord associated with "gsd."  {}      BEGIN   
WITH emsg, socket DO 
    BEGIN     em_event := TIMER_RESPONSE;     ehport := so_down_pid * EHS_PER + EHOB_OFFSET;      emtr_up_ref := gsd;     emtr_down_ref := so_down_pathref;  
   emtr_data[0] := sigval; 
    so_down_cnt := so_down_cnt + 1;     so_protosig.er_flags[sigval] := FALSE;   
   END; {WITH emsg}  
 DS_Signal (gsd, OUTBOUND_SIG, socket);  DS_LeaveCritical (wkmp);  ProSw (emsg, outp_ierr);  END; {PrepTimerResponse}      
BEGIN {  Outpro   }  
 { Before doing anything, detach from the local session and  {    verify that the environment is OK  {}  Dtach (dummy);  
DS_EnvOk ('OUTPRO'); 
     DS_EnterCritical ( wkmp, enter_err );       !{ Get the ressource number that OUTPRO will use to detect signals. ! {}  DS_FetchElement ( DS_TrackTD, TL_OUTPRO_RN, rn);      !{ Initialize the bit mask to be used when evaluating the protocol  ! 	{ select bit mask. 	 {}  FOR i := 1 TO SELBITMAPSIZE DO gsdmask.ints[i] := -1; {sets}  DS_FetchGlobal ( DS_SbTotal, 1, gsdbound ); {last sbuf record}  gsdbound := gsdbound DIV 2 + 1;       
DS_LeaveCritical ( wkmp ); 
     REPEAT     DS_EnterCritical ( wkmp, enter_err );     { Scan, and continue to scan, the protocol bit map until it      { indicates there are no more sockets with outbound events to      { process.      {}      DS_SoSel (gsdmask, -1, gsd);      WHILE (gsd <> MEANINGLESS) DO        BEGIN         DispatchEvent (gsd, wkmp);        DS_SoSel (gsdmask, -1, gsd);  
      END;  { WHILE gsd }  
     !   { No sockets have reportable events at this time. We therefore  !    { sleep to await new events. Before sleeping we must enable     { the RNTable entry that we sleep on.     {}      DS_RNStoreElement ( RND_OUTBOUND, rn );     DS_LeaveCritical ( wkmp );      Rnrq ( RN_AWAIT, rn, outp_ierr );  UNTIL FALSE;      99:;  END.  { OUTPRO } 