 $PASCAL '91790-16246 REV.4010 <860204.1512>'  
$STANDARD_LEVEL 'HP1000' $ 
 $DEBUG $  $RECURSIVE OFF$   $CODE_INFO ON$  	$CODE_OFFSETS ON$  	 $RANGE OFF$   $SEGMENTED ON $   $TITLE 'Module Description', PAGE$          PROGRAM NSPeek;       %{------------------------------------------------------------------------  %     "   (c) COPYRIGHT HEWLETT PACKARD COMPANY 1986.  ALL RIGHTS RESERVED. "    NO PART OF THIS PROGRAM MAY BE PHOTOCOPIED, REPRODUCED, OR   "   TRANSLATED TO ANOTHER PROGRAM LANGUAGE WITHOUT THE PRIOR WRITTEN  "    CONSENT OF THE HEWLETT-PACKARD COMPANY.      % ------------------------------------------------------------------------} %     {}  {        NAME : NSPeek  {      SOURCE : 91790-18246   {       RELOC : 91790-16246   
{        PGMR : JXL  
 {}  {   	{  MODIFICATIONS:  	 {   {   6/6/85  #{     1. Search list and globals put into include file for NSPeek and  # {        all segments NSSEG1..NSSEG6.   {     2. Procedure added to check state of NS/1000  ${     3. Procedure called to prepend error label and number to messages  $ {   7/17/85   {     1. Add Memory Manager Error Statistics (jar)  {}  $ PAGE $  {}  { PROGRAM DESCRIPTION:  {}  #{  This program is the Information Utility for Network Services/1000.  # "{    It is an interactive utility that supplies the user with a menu " "{    of choices from which s/he selects the set of information that  " "{    will be displayed to the scheduling LU.  The program continues  "  {    to prompt the user for selections until the Exit command is   {    issued.  Joan Lawler 12-26-84  {   {}  {  Program Flow:  {   %{     Check the state of NS/1000 and write warning message if any applies. % {     Assign LU 1 for writing and reading.  {     Write the top level menu to LU 1,   {       and prompt user for command   {     Read the user's selection.   {     (Enter the program loop; loop until user's choice is EXit)   {        WHILE choice NOT EXit DO   
{          CASE choice OF  
 {             HE               : Display the menu again.  {             any info command : Load the appropriate segment.  %{                                Call the procedure that handles command.  % ${             PR               : Call procedure to get new LU from user. $ {             EX               : Exit loop.   {             undefinded comm. : Display the menu again.  
{          END CASE  
 {          Prompt user from command.  {          Read the user's selection.   	{        END WHILE 	 {}  !$ INCLUDE 'src/NSPeek.PASI', SUBTITLE 'Import Search List', PAGE $ !     $ SUBTITLE 'EXTERNALS AND FORWARDS', PAGE$  #{--------------------------------------------------------------------} # #{                                                                    } # #{              EXTERNAL AND FORWARD DECLARATIONS                     } # #{                                                                    } # #{--------------------------------------------------------------------} #     
PROCEDURE CallDSInf; 
    EXTERNAL;      PROCEDURE CallIpcInf;      EXTERNAL;      
PROCEDURE CallIpInf; 
    EXTERNAL;      PROCEDURE CallLanInf;      EXTERNAL;      
PROCEDURE CallLUInf  
    (selection : Int16);      EXTERNAL;      
PROCEDURE CallMmInf  
    (selection : Int16);      EXTERNAL;      
PROCEDURE CallMUInf; 
    EXTERNAL;      PROCEDURE CallPrbInf;      EXTERNAL;      PROCEDURE CallPxpInf;      EXTERNAL;      PROCEDURE CallTcpInf;      EXTERNAL;          {   #{  CheckNSStates makes calls to InitEnterCritical and DSStateofDSAM to # #{    determine the exact state of NS/1000.  Any state but initialized  # ${    requires that the user be warned (1) of any irregular state or (2)  $ "{    that not all categories of information are available to NSPeek. " {}  PROCEDURE CheckNSStates;     FORWARD;       {   {  LoadSegment is used for segmentation.  {   {}  PROCEDURE LoadSegment    $ ALIAS 'Pas.SegmentLoad' $     (segment_name : Charray6);      EXTERNAL;      {   !{  Prompt the user for an LU number which will be used in the Exec ! {    writes until this procedure is invoked again.  {}  PROCEDURE SelectPrintLU      (VAR output_LU : Int16);      FORWARD;       {   "{ Issues the top-level menu to LU 1 for the user to make a selection " {   among the sets of information available or to exit.   {}  
PROCEDURE PrintMenu  
    (VAR selection : Int16);      FORWARD;       $ SUBTITLE 'CheckNSStates', PAGE $  %{-----------------------------------------------------------------------}  % {   {                   PROCEDURE CheckNSStates   {   %{-----------------------------------------------------------------------}  % PROCEDURE CheckNSStates;      {   #{  CheckNSStates makes calls to InitEnterCritical and DSStateofDSAM to # #{    determine the exact state of NS/1000.  Any state but initialized  # ${    requires that the user be warned (1) of any irregular state or (2)  $ "{    that not all categories of information are available to NSPeek. " {}  {  Algorithm :  {   {    InitEnterCritical  {    if no error then   {       .get StateofDSAM  
{       .get NS statewords 
 
{       .InitLeaveCritical 
 
{       .case StateofDSAM  
 {          .Initialized   {             .Do nothing; no problems  {          .Partial initialization  {             .case NS state  {                 .Shutting, Starting, or Dsam is up  {                     .print a message and Proto value  !{                 .otherwise stateword is bad value, inconsistant  ! "{                     .print a message and stateword and Proto value " {          .otherwise there is a critical inconsistency   {             .print a message  {    else   {       .get StateofDSAM  
{       .case StateofDSAM  
 {           .Uninitialized, or Parity Errors  {              .print a message   {           .Initialized, Partial initialization  {              .print a message of inconsistency   {           .otherwise there is a critical system inconsistency    {              .print a message   {}      $ PAGE $      VAR   
   next_pos : Int16; 
    errn : Int16;     wmsr : Int16;          { Working Map Set Register }     ds_so_dsam : Int16;    { DS State of DSAM }     ds_so_ds : Int16;      { DS State of DS }     ds_proto_word : Int16; { DS Proto Seg Stateword }      
BEGIN   { CheckNSStates }  
     WITH info DO     BEGIN         DS_InitEnterCritical (wmsr, errn);   
   IF errn = 0 THEN  
       BEGIN { no EnterCrit error }         ds_so_dsam := DS_StateofDSAM;   { Get the DSAM Stateword }         IF ds_so_dsam = ADSINITIALIZING THEN           BEGIN  { if }           DS_FetchGlobal (DS_STATEOFDS, 1, ds_so_ds);           DS_FetchGlobal (DS_INITPROTOSEG, 1, ds_proto_word);           END;   { if }            DS_InitLeaveCritical (wmsr);      "      CASE ds_so_dsam OF      { First check the Stateword of DSAM }  "     %         ADSINIT :  BEGIN   { No action required if DSAM is successfully } % %                    END;    {   initialized                              } %     
         ADSINITIALIZING : 
             BEGIN  { AdsInitializing }              buffer := WARN_PART_INIT;               PrError (buffer,ERRN_PART_INIT);                  CASE ds_so_ds OF                     DSINIT_SHUT :                    BEGIN  { dsinit_shut }                    buffer := WARN_INIT_SHUT;   &                  temp_buf := WARN_PROTO;  { append the protocol stateword } &                    InsrtChr (buffer, temp_buf, 24, 33, next_pos);   #                  InsrtDec (buffer, ds_proto_word, 57, next_pos, -1);  #                   PrError (buffer, ERRN_INIT_SHUT);                     END;   { dsinit_shut }      $PAGE$                 DSINIT_START :                     BEGIN  { dsinit_start }                     buffer := WARN_INIT_START;  &                  temp_buf := WARN_PROTO;  { append the protocol stateword } &                    InsrtChr (buffer, temp_buf, 24, 32, next_pos);   #                  InsrtDec (buffer, ds_proto_word, 56, next_pos, -1);  #                   PrError (buffer, ERRN_INIT_START);                    END;   { dsinit_start }       '               DSINIT_UNINIT :             { message is same as for startup }  ' '                  BEGIN  { dsinit_uninit }           { DSAM has been alloc. }  ' '                  buffer := WARN_INIT_START;         {  but no other startup}  ' '                  PrError (buffer, ERRN_INIT_UNINIT);{  has occurred        }  '                   END;   { dsinit_uninit }      &               Otherwise     { Includes DSINIT_INIT case and anything else } &                   BEGIN  { dsinit_init }                    buffer := WARN_INIT_INCONST;  "                                           { add the DS stateword }  "                    InsrtDec (buffer, ds_so_DS, 45, next_pos, -1);                     PrError (buffer, ERRN_INIT_INCONST);      &                  buffer := WARN_PROTO;    { print the protocol stateword }  & #                  InsrtDec (buffer, ds_proto_word, 25, next_pos, -1);  #                   PrMenu (buffer);                    END;   { dsinit_init }                     END; { case ds_so_ds }                   buffer := WARN_INFO_LIMIT;              PrError (buffer, ERRN_INFO_LIMIT);                  END;   { AdsInitializing }      &(*  this constant not yet declared: ParityError, Memory unlinked,proceeding  & !(*       -2 :     { No action to be taken in this unlikely event } ! !(*          BEGIN {   because entering Critical is still allowed } ! (*          END;  (**)  %                      { Any other Stateword value is totally unexpected }  % %         Otherwise    {   and inconsistant with EnterCritical return    }  % 	            BEGIN  	             buffer := DISAST_INCONSISTANT;              PrError (buffer, ERRN_DIST_INCONST);              END;               END;   { case ds_so_dsam }             END  { no EnterCrit error }       $PAGE$     ELSE BEGIN  { not allowed to enter Critical }            ds_so_dsam := DS_StateofDSAM;       "      CASE ds_so_dsam OF      { First check the Stateword of DSAM }  "     
         ADSUNINIT,  
          DSAMPECLMBUFS,            DSAMPEGLOBALS,            DSAMPETABLES  :              BEGIN  { Expected Stateword values }      %            CASE ds_so_dsam OF      { First check the Stateword of DSAM }  %                    ADSUNINIT :  BEGIN { AdsUnInit }                               buffer := WARN_UNINIT;                              errn := ERRN_ADSUNINIT;                               END;  { AdsUnInit }                      DSAMPECLMBUFS :  BEGIN  { DsamPeClMbufs }                                  buffer := WARN_PE_CLMBUFS;                                  errn := ERRN_ADSPECLMBUFS;                                  END;   { DsamPeClMbufs }                     DSAMPEGLOBALS :  BEGIN  { DsamPeGlobals }                                  buffer := WARN_PE_GLOBALS;                                  errn := ERRN_ADSPEGLOBALS;                                  END;   { DsamPeGlobals }                     DSAMPETABLES :  BEGIN  { DsamPeTables }                                 buffer := WARN_PE_TABLES;                                 errn := ERRN_ADSPETABLES;                                 END;   { DsamPeTables }                     END;  { case }                       PrError (buffer, errn);               buffer := WARN_INFO_LIMIT;              PrError (buffer, ERRN_INFO_LIMIT);                  END;   { Expected Stateword values }      	         ADSINIT,  	 
         ADSINITIALIZING : 
 &(*  this constant not yet declared: ParityError, Memory unlinked,proceeding  & 
(*       DS_PE_AskLissa :  
 (**)  &            BEGIN  { Unexpected in the event when not allowed to EnterCrit } &             buffer := WARN_INCONSISTANT;              PrError (buffer, ERRN_INCONST);               END;      &         Otherwise      { This is a serious and unexpected error condition } &             BEGIN  { Otherwise }              buffer := WARN_SYS_DISASTER;              InsrtDec (buffer, ds_so_dsam, 57, next_pos, -1);              PrError (buffer, ERRN_SYS_DIST);              END;   { Otherwise }               END;  { case }             END;     { not allowed to enter Critical }      	   END;  { with }  	     
END;    { CheckNSStates }  
     $ SUBTITLE 'PrintMenu', PAGE $  %{-----------------------------------------------------------------------}  % {   {                   PROCEDURE PrintMenu   {   %{-----------------------------------------------------------------------}  %     
PROCEDURE PrintMenu  
    (VAR selection : Int16);       { Discussion:   "{  Procedure to present the user with the selection codes at the top " "{  level for viewing various collections of information.  Among the  "  {  choices is Exit, which is the selection code used to exit the   {  main program loop to bring the program to an end.  {   { Parameters:   "{  selection   OUTPUT      Integer code to exit or select particular " {                            information.   {}  VAR      i : Int16;       
BEGIN  { PrintMenu } 
     
FOR i := 0 TO 20 DO  
    BEGIN     CASE i OF        0: ;        1: buffer := '              NSPeek/1000 Information';         2: ;        3: buffer := 'HE = Help';         4: buffer := 'BM = Buffer Manager statistics';        5: buffer := 'DS = DS/1000-IV services menu';         6: buffer := 'DV = DVA66 DVT and IFT information';         7: buffer := 'IC = IC (Inter-process Communication) menu';         8: buffer := 'IO = NS/1000 LUs';        9: buffer := 'IP = IP (Internetwork Protocol) menu';       10: buffer := 'LA = LAN Interface menu';        11: buffer := 'LU = Information on an NS/1000 LU';        12: buffer := 'ME = Memory Manager Error statistics';       13: buffer := 'MM = Memory Manager statistics';       14: buffer := 'MU = MultiUser information';       15: buffer := 'PB = Probe protocol menu';        16: buffer := 'PR = Change the print LU for NSPeek output';        17: buffer := 'PX = PXP (Packet Exchange Protocol) menu';  "     18: buffer := 'TC = TCP (Transmission Control Protocol) menu';  "      19: buffer := 'EX = Exit';        20: ;        Otherwise;      
      END;  { case } 
     
   PrMenu (buffer);  
     	   END;   { for }  	     
END;   { PrintMenu } 
         $ SUBTITLE 'SelectPrintLU', PAGE $  %{-----------------------------------------------------------------------}  % {   {                   PROCEDURE SelectPrintLU   {   %{-----------------------------------------------------------------------}  %     PROCEDURE SelectPrintLU      (VAR output_LU : Int16);       { Discussion:   !{  Prompt the user for an LU number which will be used in the Exec ! {    writes until this procedure is invoked again.  {   { Parameters:   "{  output_LU   OUTPUT      LU to which all output will be directed.  " {}  VAR      response : BOOLEAN;      BEGIN  { SelectPrintLU }         REPEAT          buffer := '';  	   output_LU := 1; 	 
   PrInfo (buffer);  
    buffer := 'NSPeek: Enter output LU [ Default = 1 ] >';      response := PromptUser (buffer, output_LU);         IF NOT response THEN         output_LU := 1;          IF (output_LU < 0) OR (output_LU > 255) THEN         BEGIN       
      buffer := '';  
       PrMenu (buffer);        buffer := VALID_LU_ERR;         PrError (buffer, ERRN_VALID_LU);            END;         UNTIL (output_LU >= 0) AND (output_LU <= 255);       END;   { SelectPrintLU }      $ SUBTITLE 'Main of NSPeek', PAGE $       BEGIN          InitializeIO;  	   CheckNSStates;  	     	   output_LU := 1; 	 
   PrintMenu (selection);  
        REPEAT          buffer := '';  
   PrMenu (buffer);  
    buffer := 'NSPeek: Enter your selection >';     response := PromptMenu (buffer, selection);         IF NOT response THEN         BEGIN         selection := HE;        END;          
   CASE selection OF 
          HE : PrintMenu (selection);    { Help function }       !     BM : BEGIN                     { Buffer Manager Statistics }  !           LoadSegment ('NSBML');            CallMmInf (selection);            END;            DS : BEGIN                     { DS/1000-IV services menu }             LoadSegment ('NSDSI');  
          CallDSInf; 
           END;      #     DV : BEGIN                     { DVA66 DVT and IFT information }  #           LoadSegment ('NSMLU');            CallLUInf (selection);            END;           IC : BEGIN                     { IPC menu }            LoadSegment ('NSIPX');            CallIpcInf;             END;           IO : BEGIN                     { NS/1000 LUs List }            LoadSegment ('NSMLU');            CallLUInf (selection);            END;           IT : BEGIN                     { IP menu }             LoadSegment ('NSIPI');  
          CallIpInf; 
           END;           LA : BEGIN                     { LAN menu }            LoadSegment ('NSBML');            CallLanInf;             END;      !     LU : BEGIN                     { Single NS/1000 LU inform. }  !           LoadSegment ('NSMLU');            CallLUInf (selection);            END;      $     ME : BEGIN                     { Memory Manager Error Statistics }  $           LoadSegment ('NSBML');            CallMmInf (selection);            END;      !     MM : BEGIN                     { Memory Manager Statistics }  !           LoadSegment ('NSBML');            CallMmInf (selection);            END;           MU : BEGIN                     { MultiUser Information }             LoadSegment ('NSMLU');  
          CallMUInf; 
           END;           PB : BEGIN                     { Probe Information }             LoadSegment ('NSIPX');            CallPrbInf;             END;           PR : SelectPrintLU (output_LU);           PX : BEGIN                     { PXP menu }            LoadSegment ('NSIPX');            CallPxpInf;             END;           TC : BEGIN                     { TCP menu }            LoadSegment ('NSTCP');            CallTcpInf;             END;           EX : exit_choice := TRUE;           Otherwise           PrintMenu (selection);    { Help function }      
      END;  { case } 
            UNTIL exit_choice;       END. 