 $PASCAL ',7 91790-1X152 REV.4010 <860516.1616> '  $STANDARD_LEVEL 'HP1000'  $debug$   "$HEAP 2, HEAPPARMS OFF, HEAP_DISPOSE OFF, RECURSIVE OFF, RANGE OFF$  "     	MODULE NSLNKinit;  	 
$ALIAS 'N$NSLNKINIT' 
     {------------------------------------------------------------    (c) COPYRIGHT HEWLETT PACKARD COMPANY 1986. ALL RIGHTS    RESERVED. NO PART OF THIS PROGRAM MAY BE PHOTOCOPIED,   REPRODUCED OR TRANSLATED TO ANOTHER PROGRAM LANGUAGE WITHOUT    THE PRIOR WRITTEN CONSENT OF THE HEWLETT-PACKARD COMPANY.   ------------------------------------------------------------}  {}  {    NAME:   NSLNKINIT  {    SOURCE: 91790-18152  	{    RELOC:  NONE  	 {    PGMR:   EMS  {}      {------------------------------------------------------------   { MODIFICATIONS:  {   {  Date  Prgmr  Description   {  860225 lms   Enhance init/shutdown error handling (n356).  {  860212 lms   Set Nosuspend bit in XLUEX calls.   {                   Call Disconnect_LU, CheckXLUEXCall,   {                   HandleAbortReturn  (n370).  {  860320 lms   Abort for wrong driver type errors (n370).  "{  860516 jc    Fix a bug to quit GGOpenLines when error (line 229)  " {------------------------------------------------------------   {}      {}  { PROGRAM DESCRIPTION:  {   "{     This module contains the link initialization code for NSINIT.  " {   {}  IMPORT      $SEARCH 'phtm/BODEC.REL'     bodec,   $SEARCH 'phtm/SODEC.REL'     sodec,   $SEARCH 'phtm/MMDEC.REL'     mmdec,   $SEARCH 'phtm/MMEXT.REL'     ds_mm,   $SEARCH 'phtm/init_dec.rel'      init_dec,  $SEARCH 'phtm/initmulti.xpt'     initmulti,   
$SEARCH 'phtm/parsdd.xpt'  
    parser,  
$SEARCH 'phtm/filemad.xpt' 
    fileman,   $SEARCH 'phtm/dres.xpt'      dres,  $SEARCH 'phtm/init_rte_if.xpt'     init_rte_if,   
$SEARCH 'phtm/trcmod.rel'  
    trcmod,  $SEARCH 'phtm/lklb.rel'      lk,  
$SEARCH 'phtm/sigmod.rel'  
    sigmod,  
$SEARCH 'phtm/tmrdec.rel'  
    tmrdec,  $SEARCH 'phtm/tuser.rel'     tuser,   $SEARCH 'phtm/ipdec.rel'     ipdec,   $SEARCH 'phtm/iplib.rel, phtm/ipdb.rel'      iplib,   $SEARCH 'phtm/lan8.xpt'      lan8,  $SEARCH 'phtm/lanui.xpt'     lanui,   
$SEARCH 'phtm/laninit.xpt' 
    laninit;       $SUBTITLE ' Export procedures ', PAGE$      EXPORT      {--------------------------------------------------------}  {                                                        }  {          EXPORT   PROCEDURES                           }  {                                                        }  {--------------------------------------------------------}      
PROCEDURE ShutNSLNK  
    (    trustvar    : TrustType;      VAR result      : Int16);       
PROCEDURE InitNSLNK  
    (VAR result : Int16);      {----------------------------------------------------}  {               Implement Section                    }  {----------------------------------------------------}      IMPLEMENT       TYPE      
   StType = PACKED RECORD  
       STT_upperbyte : Byte;         STT_dvrerrcode: Int4;      {error code from driver}         STT_ds_bit    : Boolean;   {ds request if true.   }         STT_wr_bit    : Boolean;   {write request if true }         STT_dvrerr_bit: Boolean;   {error if true         }         STT_syserr_bit: Boolean;   {reserved for system   }         END;      
   EqtStatusType = RECORD  
       CASE boolean OF            false: (int:   Int16);            true:  (st:    StType);           END;       PROCEDURE GGOpenLines     ( VAR ierr         : Int16 );   FORWARD;      PROCEDURE GetABRegisters      $ALIAS 'ABREG'$   
   (VAR  areg    : Int16;  
 
    VAR  breg    : Int16); 
    EXTERNAL;      PROCEDURE GGCloseLines     (    trustvar     : TrustType;       VAR ierr         : Int16 );   FORWARD;      PROCEDURE OpenLine           $ALIAS 'XLUEX'$     $ NOABORT $     (icode    : Int16;       icnwd    : ControlWordType;       ipram    : Int16);     EXTERNAL;      $SubTitle 'GGOpenLines', page$  {------------------------------------------}  {        GGOpenLines                       }  {------------------------------------------}      PROCEDURE GGOpenLines     ( VAR ierr         : Int16 );       {}  { Description: The procedure is called at the end   {  of DS initialization to open the gateway line(s) for   {  communication. The procedure scans the Gateway Line table  {  for entries which have valid LUs and the option to open  {  now. If such entry is found, an Open Request is sent to  {  the link driver. NOTE: this procedure assumes the level 2  {  has been configured.   {}      LABEL      66,     99;      CONST   	   GGOPENERR_374 = 	 !        '** (374) NSINIT- GWY Link Enable Error. Driver reports:'; !     VAR      index     : Int16;      dummy     : Int16;      areg      : Int16OrCharType;      breg      : Int16OrCharType;      lkerr     : EqtStatusType;      gg_td     : TableDescriptorType;      ni_error  : Int16;      gg_wkmap  : Int16;      icode     : Int16;      ipram     : Int16;   
   ggpath    : GGPathType; 
    icnwd     : ControlWordType;      message   : IStringType;           $ SUBTITLE 'GGOpenLines', PAGE $      BEGIN {ggopen}  {Open the links}  ierr     := 0;  ni_error := 0;      DS_InitEnterCritical(gg_wkmap, ni_error);   IF ni_error <> 0 THEN      BEGIN     {GGINTERR: Gateway Line Internal Error}     MsgFilePrint( -GGINTERR, PMT_ERROR, ni_error, dummy);     Goto 99;      END;       {Find the size of our table}  DS_FetchTableDescriptor(DS_ggtd, gg_td, ni_error);  DS_InitLeaveCritical(gg_wkmap);           IF ni_error <> 0 THEN      BEGIN     {Bad table access}      MsgFilePrint( -GGINTERR, PMT_ERROR, ni_error, dummy);     Goto 99;      END  ELSE     IF gg_td.TD_wordsperelement = 0 THEN         BEGIN         MsgFilePrint( -GGINTERR, PMT_ERROR, ni_error, dummy);         goto 99;        END;      index := gg_td.TD_minelementindex;          REPEAT  {Sacn the table to open the lines}      DS_InitEnterCritical(gg_wkmap, ni_error);   IF ni_error <> 0 THEN      BEGIN     MsgFilePrint( -GGINTERR, PMT_ERROR, ni_error, dummy);     GOTO 99;      END;       DS_FetchElement(DS_ggtd, index, ggpath.int);  DS_InitLeaveCritical(gg_wkmap);       IF (ggpath.lu <> 0) AND (ggpath.options[0]) then     BEGIN     {Need to see if the driver type is ok; it should be 66B}      CheckDriverType(ggpath.lu, 54, ni_error);     IF ni_error <> 0 THEN        BEGIN         IF ni_error = CHKDRIVER_BADTYPE THEN           BEGIN    { bad driver type }            { this is a catastrophic error. }           {GGCFGERR: Gateway Line Configuration error}             MsgFilePrint( -GGCFGERR, PMT_ERROR, ggpath.lu, dummy);    	         GOTO 99;  	          END      { bad driver type }           ELSE           BEGIN    { other LU error }  !         MsgFilePrint( -GGLNKDOWN, PMT_ERROR, ggpath.lu, dummy );  !          ni_error := ERR_ALREADY_PRINTED;            END;     { other LU error }            END      ELSE   
      BEGIN {open request} 
       {Say its process id is 6 and traffic type is 2}         ipram    := (32 + 6) * 256 + ggpath.lu;         icode    := EXEC3 + NOSUSPENDBIT;         icnwd[1] := ggpath.lu;        icnwd[2] := 24 * 64 ;         OpenLine(icode, icnwd, ipram);           BEGIN { error return }                GetABRegisters(areg.IIOrCType, breg.IIOrCType);           HandleAbortReturn( areg, breg, ggpath.lu, ni_error );  	         GOTO 66;  	          END;  { error return }                 GetABRegisters(areg.IIOrCType, breg.IIOrCType);   $      CheckXLUEXCall( areg, breg, ggpath.lu, GGOPENERR_374, ni_error );  $     
      END;  {open request} 
           66:      END;       
index := index + 1;  
     UNTIL index > gg_td.TD_maxelement;      99:;  	ierr := ni_error;  	 END;  {ggopen}          $SubTitle 'GGCloseLines', page$   {------------------------------------------}  {        GGCloseLines                      }  {------------------------------------------}      PROCEDURE GGCloseLines     (    trustvar     : TrustType;       VAR ierr         : Int16 );       {}  { Description: The procedure is called by the Shutdown Process   {  to disable all Gateway links as part of the orderly shutdown    
{  of NS/1000 sub-system.  
 {}      LABEL      99;      VAR      index     : Int16;   
   ggpath    : GGPathType; 
    gg_td     : TableDescriptorType;      dummy     : Int16;      ni_error  : Int16;      gg_wkmap  : Int16;      icnwd     : ControlWordType;       PROCEDURE Exit  (    exitparm  :   Int16 );       
   BEGIN    { Exit } 
     
   ierr := exitparm; 
    GOTO 99;   
   END;     { Exit } 
     $ SUBTITLE 'GGCloseLines', PAGE $       BEGIN {ggclose}       ierr     := 0;  ni_error := 0;      DS_InitEnterCritical(gg_wkmap, ni_error);   IF ni_error <> 0 THEN Exit( CANT_ENTER_CRIT );      {Find the size of our table}  DS_FetchTableDescriptor(DS_ggtd, gg_td, ni_error);  DS_InitLeaveCritical(gg_wkmap);       IF ni_error <> 0 THEN      BEGIN     {Error: even if no GG have loopback entry in the table }      { Even so, keep caller going through shutdown.  Return 0 }      MsgFilePrint( -GGINTERR, PMT_ERROR, ni_error, dummy);     Goto 99;      END  ELSE     IF gg_td.TD_wordsperelement = 0 THEN         BEGIN         MsgFilePrint( -GGINTERR, PMT_ERROR, ni_error, dummy);         { even so, don't stop shutdown }        goto 99;        END;      index := gg_td.TD_minelementindex;      REPEAT      DS_InitEnterCritical(gg_wkmap, ni_error);   IF ni_error <> 0 THEN Exit( CANT_ENTER_CRIT );      DS_FetchElement(DS_ggtd, index, ggpath.int);  DS_InitLeaveCritical(gg_wkmap);       IF (ggpath.lu <> 0) THEN     BEGIN         Disconnect_LU( ggpath.lu, ni_error );     { disconnect_LU prints error message, if any }      END;       
index := index + 1;  
     UNTIL index > gg_td.TD_maxelement;      99:;      END;  {ggclose}       $SUBTITLE 'NSLNK Shutdown module', PAGE$  {-------------------------------------------}   {              ShutNSLNK                    }   {-------------------------------------------}       
PROCEDURE ShutNSLNK  
    (    trustvar    : TrustType;      VAR result      : Int16 );      {}  { Description: Module to be called by NSINIT at shutdown.   {   { Parameters:   {    trustvar   (input)  Indicates potential corruption of  {                        data structures.   {   {}  VAR   	   ierr :   Int16; 	        BEGIN { ShutNSLNK }     ierr := 0;      result := 0;          LanClearClass( trustvar, ierr );   	   result := ierr; 	        GGCloseLines( trustvar, ierr );         { return error, either from lan or gg, whichever had one }      IF result = 0 THEN result := ierr;          END;  { ShutNSLNK }          $SUBTITLE 'InitNSLNK', PAGE$  {------------------------------------------------------------}  {                                                            }  {                   InitNSLNK                                }  {                                                            }  {------------------------------------------------------------}      
PROCEDURE InitNSLNK  
    (VAR result:       Int16);       VAR      lanresult:    Int16;      gwyresult:    Int16;          BEGIN { InitNSLNK }  !   { The only error from these routines that will cause          } ! !   { initialization to terminate is a "wrong driver type" error. } !        LanOpenLines( lanresult );      IF ( lanresult = CHKDRIVER_BADTYPE ) THEN        BEGIN    { problem opening LAN line }   
      result := lanresult; 
       END      { problem opening LAN line }        ELSE         BEGIN    { continue opening lines }             GGOpenLines( gwyresult );         IF gwyresult = CHKDRIVER_BADTYPE THEN            BEGIN    { wrong GWY driver }           result := gwyresult;            END      { wrong GWY driver }          ELSE           BEGIN    { check for non-critical errors }                IF lanresult <> GOOD THEN              BEGIN    { lan error }                  result := lanresult;              END      { lan error }             ELSE IF gwyresult <> GOOD THEN                  BEGIN    { gwy error }                      result := gwyresult;                  END;     { gwy error }            END;     { check for non-critical errors }         END;     { continue opening lines }      END; { InitNSLNK }   END   .  