 $PASCAL '91790-16145 REV.4010 <860403.1301>'      
$STANDARD_LEVEL 'HP1000' $ 
 $RECURSIVE OFF$   $DEBUG$       PROGRAM NSInf;      %{------------------------------------------------------------------------  %     "   (c) COPYRIGHT HEWLETT-PACKARD COMPANY 1986.  ALL RIGHTS RESERVED. "    NO PART OF THIS PROGRAM MAY BE PHOTOCOPIED, REPRODUCED, OR   "   TRANSLATED TO ANOTHER PROGRAM LANGUAGE WITHOUT THE PRIOR WRITTEN  "    CONSENT OF THE HEWLETT-PACKARD COMPANY.      % ------------------------------------------------------------------------} %     {}  {        NAME : NSInf   {      SOURCE : 91790-18145   {       RELOC : 91790-16145   
{        PGMR : ASH  
 {}      ${----------------------------------------------------------------------- $    MODIFICATIONS  11/3/85      Added CheckNSStates, a procedure from NSPeek.  11/14/85     Get log mask from DS_LogMask.     Print local socket descriptor     Check for presence of EvMon in Util  11/19/85     Reverse reference counts for IP in FormatIP  12/13/85     Report Gateway links in Locals   1/8/86     Initialize j and nrrsize in FetchRTRLus. Add some comments   1/14/86      Print IP down path reference counts from ANH record  2/19/86      Print all gwy LUs in Locals if there are more than 2   ----------------------RELEASE------------------------------   3/31/86      Print log file name in Utils   	4/2/86   SR#035394 	 $   Print local address from LU contained in down ref field in FormatLan  $ 
   Include NGT in Locals.  
 % -----------------------------------------------------------------------}  % {}  { PROGRAM DESCRIPTION :   "{  Program to provide users with Information about the current state " {  of NS.   {   #{  Note: The IO in this program is very funky.  The main program uses  # "{  Pascal IO.  The three modules LUINF, MMINF, and DSINF were taken  " ${  without change from NSINF's predecessor NSPEEK.  NSPEEK was segmented $ %{  instead of being CDS, and so used EXEC IO in order to save code space.  % #{  So, the IO goes through two different paths in order to get to the  # {  scheduling terminal.   {   #{  There are global variables which are used for the EXEC IO, declared # {  in INFLB, which are initialized in the main of NSINF.  {}      LABEL      99;              IMPORT     $search 'phtm/bodec.xpt'   bodec,     $search 'phtm/sodec.xpt'   sodec,     $search 'phtm/mmdec.xpt'   mmdec,     $search 'phtm/mmext.xpt'   ds_mm,     $search 'phtm/trcmod.xpt'  trcmod,      $search 'phtm/sigmod.xpt'  sigmod,      $search 'phtm/tmrdec.xpt'  tmrdec,      $search 'phtm/tuser.xpt'   tuser,     $search 'phtm/tcpgb.rel'   tg,      $search 'phtm/pxplb.rel'   px,   
   $search 'phtm/lklb.rel' 
 lk,      $search 'phtm/rrdec.rel'   rrdec,     $search 'phtm/ipdec.xpt'   ipdec,     $search 'phtm/ipdb.xpt, phtm/iplib.xpt'  iplib,  
   $search 'phtm/lan8.xpt' 
 lan8,   
   $search 'phtm/ipui.rel' 
 ipui,      $search 'phtm/lanui.rel'   lanui,     $search 'phtm/prbdec.rel'  prbdec,      $search 'phtm/inflb.rel'   inflb,     $search 'phtm/init_dec.rel'  init_dec,   
   $search 'phtm/dres.xpt' 
 dres,      $search 'phtm/luinf.rel'   luinf,     $search 'phtm/dsinf.rel'   dsinf,     $Search 'phtm/mminf.rel'   mminf;      $ PAGE $  CONST      TWENTYSPACES   = '                    ';          { error constants }  
   NSINFEB = 16000;  
     !   { The following error codes occur when IP thinks the down pid } ! !   { is on thing, but the down pid has no table space configured } !    NSIPNORTR   = NSInfEB + 1;      NSIPNOGG    = NSInfEB + 2;      NSIPNOLAN   = NSInfEB + 3;           { Station address configured, but no multicast for this lu }       NSLANNOMCAST   = NSInfEB + 4;         { No local IP addresses configured for this node }      NSNOLIPAD   = NSInfEB + 5;          { No IP Path records configured }     NSNOIP      = NSInfEB + 6;          { these are self explanatory }      NSNOUSERRECORDS   = NSInfEB + 7;      NSNOSOCKETS = NSInfEB + 8;      NSNONAMES   = NSInfEB + 9;      NSNOPROBE   = NSInfEB + 10;         { data structure error }      NSLINKEDLISTERR   = NSInfEB + 11;      TYPE     InfoRec  = RECORD       { Used in HS collision protection }               tos,            { top of stack }                toh,            { top of heap  }                init_tos,               init_toh,               high_tos,               high_toh,               curr_free,      { address of current free list }                curr_mark : Int16;   
            END; {InfoRec} 
        masktype = PACKED ARRAY [1..6] of CHAR;     nrrbuftype  = ARRAY[1..2] of Int16;     rtrbuftype  = ARRAY[1..6] of Int16;      VAR   (* chars    : String[10];   { for the pause routine } *)  
   choice   : String[10];  
 
   infile   : TEXT;  
 "   info     : InfoRecordType; { needed by the routines from nsinf }  " 
   outfile  : TEXT;  
 
   outline  : String[80];  
     { Procedure to convert a number to octal pac }  PROCEDURE ConvertToOctal       $ALIAS 'CNumO' $      (     numb  : Int16;       VAR  oct   : MaskType);      EXTERNAL;      { Procedure to check NSStates before starting }   PROCEDURE CheckNSStates;     FORWARD;       { Procedure to report configured resource usage }   	PROCEDURE Config;  	    FORWARD;       { Procedure to print entercrit errors }   PROCEDURE EnterCritError     (VAR error  : Int16);     FORWARD;       { Procedure to fetch rtr links }  	PROCEDURE Fetch_LV 	 
   (     i : Int16;  
     VAR rtrbuf : rtrbuftype);      EXTERNAL;      { Procedure to fetch non rtr links }  
PROCEDURE Fetch_NRR_Index  
 
   (     i : Int16;  
     VAR nrrbuf : nrrbuftype);      EXTERNAL;      
PROCEDURE Fetch_NRV_Index  
 
   (     nrvindex : Int16; 
     VAR  NRVEntry : NRVEntryType);     EXTERNAL;      { Heap management routine; get available memory to avoid a }  {  collision between the heap and stack.   }  PROCEDURE GetHSInfo        $ALIAS 'Pas.GetMemInfo1' $   
   (VAR hsinfo : InfoRec); 
    EXTERNAL;      { Procedure to mask out bits }  FUNCTION IAND                   $DIRECT $   
   (     number   : Int16; 
 
         mask     : Int16) 
 
                  : Int16; 
    EXTERNAL;      FUNCTION LANLocalAddress     (VAR IPAddr : Int32;   
    VAR Staddr : Stataddr; 
     VAR ierr   : Int16)                  : Int16;      FORWARD;       { Procedure to print local address information }  	PROCEDURE Locals;  	    FORWARD;       { Procedure to print the main menu }  PROCEDURE Menu;      FORWARD;       { Procedure to give info on the buffer and mmgr }   PROCEDURE MMgr;      FORWARD;       { Procedure to make output easier to read }   	(* PROCEDURE Pause 	 (*    (VAR chars  : string);  (*    FORWARD;  (**)  { Procedure to print program info }   	PROCEDURE Sktinf;  	    FORWARD;       { Procedure to make choices easier }  
PROCEDURE UpperCase  
 
   (VAR choice : String);  
    FORWARD;       { Procedure to report on Utilities }  Procedure Utils;     FORWARD;       $ Title 'Check NS States', PAGE $       %{-----------------------------------------------------------------------}  % {   {                   PROCEDURE CheckNSStates   {   %{-----------------------------------------------------------------------}  % PROCEDURE CheckNSStates;      {   #{  CheckNSStates makes calls to InitEnterCritical and DSStateofDSAM to # #{    determine the exact state of NS/1000.  Any state but initialized  # ${    requires that the user be warned (1) of any irregular state or (2)  $ "{    that not all categories of information are available to NSPeek. " {}  {  Algorithm :  {   {    InitEnterCritical  {    if no error then   {       .get StateofDSAM  
{       .get NS statewords 
 
{       .InitLeaveCritical 
 
{       .case StateofDSAM  
 {          .Initialized   {             .Do nothing; no problems  {          .Partial initialization  {             .case NS state  {                 .Shutting, Starting, or Dsam is up  {                     .print a message and Proto value  !{                 .otherwise stateword is bad value, inconsistant  ! "{                     .print a message and stateword and Proto value " {          .otherwise there is a critical inconsistency   {             .print a message  {    else   {       .get StateofDSAM  
{       .case StateofDSAM  
 {           .Uninitialized, or Parity Errors  {              .print a message   {           .Initialized, Partial initialization  {              .print a message of inconsistency   {           .otherwise there is a critical system inconsistency    {              .print a message   {}      $ PAGE $      VAR   
   next_pos : Int16; 
    errn : Int16;     wmsr : Int16;          { Working Map Set Register }     ds_so_dsam : Int16;    { DS State of DSAM }     ds_so_ds : Int16;      { DS State of DS }     ds_proto_word : Int16; { DS Proto Seg Stateword }      
BEGIN   { CheckNSStates }  
     WITH info DO     BEGIN         DS_InitEnterCritical (wmsr, errn);   
   IF errn = 0 THEN  
       BEGIN { no EnterCrit error }         ds_so_dsam := DS_StateofDSAM;   { Get the DSAM Stateword }         IF ds_so_dsam = ADSINITIALIZING THEN           BEGIN  { if }           DS_FetchGlobal (DS_STATEOFDS, 1, ds_so_ds);           DS_FetchGlobal (DS_INITPROTOSEG, 1, ds_proto_word);           END;   { if }            DS_InitLeaveCritical (wmsr);      "      CASE ds_so_dsam OF      { First check the Stateword of DSAM }  "     %         ADSINIT :  BEGIN   { No action required if DSAM is successfully } % %                    END;    {   initialized                              } %     
         ADSINITIALIZING : 
             BEGIN  { AdsInitializing }              buffer := WARN_PART_INIT;               PrError (buffer,ERRN_PART_INIT);                  CASE ds_so_ds OF                     DSINIT_SHUT :                    BEGIN  { dsinit_shut }                    buffer := WARN_INIT_SHUT;   &                  temp_buf := WARN_PROTO;  { append the protocol stateword } &                    InsrtChr (buffer, temp_buf, 24, 33, next_pos);   #                  InsrtDec (buffer, ds_proto_word, 57, next_pos, -1);  #                   PrError (buffer, ERRN_INIT_SHUT);                     END;   { dsinit_shut }      $PAGE$                 DSINIT_START :                     BEGIN  { dsinit_start }                     buffer := WARN_INIT_START;  &                  temp_buf := WARN_PROTO;  { append the protocol stateword } &                    InsrtChr (buffer, temp_buf, 24, 32, next_pos);   #                  InsrtDec (buffer, ds_proto_word, 56, next_pos, -1);  #                   PrError (buffer, ERRN_INIT_START);                    END;   { dsinit_start }       '               DSINIT_UNINIT :             { message is same as for startup }  ' '                  BEGIN  { dsinit_uninit }           { DSAM has been alloc. }  ' '                  buffer := WARN_INIT_START;         {  but no other startup}  ' '                  PrError (buffer, ERRN_INIT_UNINIT);{  has occurred        }  '                   END;   { dsinit_uninit }      &               Otherwise     { Includes DSINIT_INIT case and anything else } &                   BEGIN  { dsinit_init }                    buffer := WARN_INIT_INCONST;  "                                           { add the DS stateword }  "                    InsrtDec (buffer, ds_so_DS, 45, next_pos, -1);                     PrError (buffer, ERRN_INIT_INCONST);      &                  buffer := WARN_PROTO;    { print the protocol stateword }  & #                  InsrtDec (buffer, ds_proto_word, 25, next_pos, -1);  #                   PrMenu (buffer);                    END;   { dsinit_init }                     END; { case ds_so_ds }                   buffer := WARN_INFO_LIMIT;              PrError (buffer, ERRN_INFO_LIMIT);                  END;   { AdsInitializing }      &(*  this constant not yet declared: ParityError, Memory unlinked,proceeding  & !(*       -2 :     { No action to be taken in this unlikely event } ! !(*          BEGIN {   because entering Critical is still allowed } ! (*          END;  (**)  %                      { Any other Stateword value is totally unexpected }  % %         Otherwise    {   and inconsistant with EnterCritical return    }  % 	            BEGIN  	             buffer := DISAST_INCONSISTANT;              PrError (buffer, ERRN_DIST_INCONST);              END;               END;   { case ds_so_dsam }             END  { no EnterCrit error }       $PAGE$     ELSE BEGIN  { not allowed to enter Critical }            ds_so_dsam := DS_StateofDSAM;       "      CASE ds_so_dsam OF      { First check the Stateword of DSAM }  "     
         ADSUNINIT,  
          DSAMPECLMBUFS,            DSAMPEGLOBALS,            DSAMPETABLES  :              BEGIN  { Expected Stateword values }      %            CASE ds_so_dsam OF      { First check the Stateword of DSAM }  %                    ADSUNINIT :  BEGIN { AdsUnInit }                               buffer := WARN_UNINIT;                              errn := ERRN_ADSUNINIT;                               END;  { AdsUnInit }                      DSAMPECLMBUFS :  BEGIN  { DsamPeClMbufs }                                  buffer := WARN_PE_CLMBUFS;                                  errn := ERRN_ADSPECLMBUFS;                                  END;   { DsamPeClMbufs }                     DSAMPEGLOBALS :  BEGIN  { DsamPeGlobals }                                  buffer := WARN_PE_GLOBALS;                                  errn := ERRN_ADSPEGLOBALS;                                  END;   { DsamPeGlobals }                     DSAMPETABLES :  BEGIN  { DsamPeTables }                                 buffer := WARN_PE_TABLES;                                 errn := ERRN_ADSPETABLES;                                 END;   { DsamPeTables }                     END;  { case }                       PrError (buffer, errn);               buffer := WARN_INFO_LIMIT;              PrError (buffer, ERRN_INFO_LIMIT);                  END;   { Expected Stateword values }      	         ADSINIT,  	 
         ADSINITIALIZING : 
 &(*  this constant not yet declared: ParityError, Memory unlinked,proceeding  & 
(*       DS_PE_AskLissa :  
 (**)  &            BEGIN  { Unexpected in the event when not allowed to EnterCrit } &             buffer := WARN_INCONSISTANT;              PrError (buffer, ERRN_INCONST);               END;      &         Otherwise      { This is a serious and unexpected error condition } &             BEGIN  { Otherwise }              buffer := WARN_SYS_DISASTER;              InsrtDec (buffer, ds_so_dsam, 57, next_pos, -1);              PrError (buffer, ERRN_SYS_DIST);              END;   { Otherwise }               END;  { case }             END;     { not allowed to enter Critical }      	   END;  { with }  	     
END;    { CheckNSStates }  
         $ Title 'Config Info', PAGE $   	PROCEDURE Config;  	  { Procedure to report configured information and to calculate }    {  what of that information is in use }       LABEL      9;       TYPE     UniversalGlobal   = RECORD Case Int16 OF      1 : (ipg : IPGlobalsType);      2 : (pbg : PROBEGRecord);     3 : (tcg : TCPListBufType);        END; { UniversalGlobal }      VAR   	   error : Int16;  	    freeptr  : Int16;    { pointer to follow on free list }     ippa  : PathRecType;   	   ipcnt : Int16;  	 	   ipsiz : Int16;  	 
   nr : NameRecord;  
 	   nrcnt : Int16;  	 	   nrsiz : Int16;  	 	   pb : PCBRecord; 	 	   pbcnt : Int16;  	 	   pbsiz : Int16;  	    sk : SocketRecord;   	   skcnt : Int16;  	 	   sksiz : Int16;  	    tcpsegsize  : Int16;      td : TableDescriptorType;     ug : UniversalGlobal;  
   ur : UserRecord;  
 	   urcnt : Int16;  	 	   ursiz : Int16;  	 	   wkmp  : Int16;  	        inproclass  : Int16;      outproclass : Int16;      ifpclass    : Int16;      ifpmclass   : Int16;      nftbufsize  : Int16;      nftchecksum : Int16;       $SUBTITLE 'Escape ', PAGE $   PROCEDURE Escape  
   (error : Int16);  
    BEGIN     DS_LeaveCritical (wkmp);   %   writeln (outfile, 'NSINF: Internal configuration error encountered. ',  %                      'Error code ',error:1);     goto 9;     END;       $SUBTITLE 'CountIP ', PAGE $  	PROCEDURE CountIP  	    (VAR ipcnt  : Int16;       VAR ipsiz  : Int16);      VAR   	   ierr  : Int16;  	     BEGIN   DS_FetchTableDescriptor (DS_IP_Path_Rec_TD, td, ierr);  	IF ierr <> 0 THEN  	    BEGIN  	   escape (ierr);  	    END  ELSE IF td.td_wordsperelement = 0 THEN  	   BEGIN { no IP } 	 
   escape (NSNOIP);  
 	   END;  { no IP } 	     ipsiz := td.td_maxelement - td.td_minelementindex + 1;      { Now get the pointer to the freelist }   DS_FetchElement (DS_IP_Globals_TD, 1, ug.ipg.ipg_bufr);   freeptr := ug.ipg.ipg_pr_free;      &ipcnt := ipsiz;   { assume they are all in use and decrement from free list} & WHILE freeptr <> NULL DO     BEGIN     IF ipcnt = 0 THEN escape (NSLINKEDLISTERR);     DS_FetchElement (DS_IP_Path_Rec_TD, freeptr, ippa.pr_bufr);     ipcnt := ipcnt - 1;     freeptr := ippa.pr_free_link;  	   END; { while }  	 	END;  { CountIP }  	     $SUBTITLE 'CountNR', PAGE $       	PROCEDURE CountNR  	    (VAR nrcnt  : Int16;       VAR nrsiz  : Int16);      VAR   	   ierr  : Int16;  	     BEGIN   DS_FetchTableDescriptor (DS_NamesTD, td, ierr);   	IF ierr <> 0 THEN  	    BEGIN  	   escape (ierr);  	    END  ELSE IF td.td_wordsperelement = 0 THEN     BEGIN { no Name Records }     escape (NSNONAMES);     END;  { no name records }      nrsiz := td.td_maxelement - td.td_minelementindex + 1;      { Now get the pointer to the freelist }   DS_FetchElement (DS_TrackTD, TL_NAME_FREEPTR, freeptr);       &nrcnt := nrsiz;   { assume they are all in use and decrement from free list} & WHILE freeptr <> NULL DO     BEGIN     IF nrcnt = 0 THEN escape (NSLINKEDLISTERR);     DS_FetchElement (DS_NamesTD, freeptr, nr.int);      nrcnt := nrcnt - 1;     freeptr := nr.nr_hash_fptr;  	   END; { while }  	     !{ now subtract the buckets, since they aren't available to users } !  nrsiz := nrsiz - (LAST_NAME_BINDING_BUCKET + LAST_GIVE_BUCKET);     nrcnt := nrcnt - (LAST_NAME_BINDING_BUCKET + LAST_GIVE_BUCKET);    	END;  { CountNR }  	     $ SUBTITLE 'CountPB',PAGE $   	PROCEDURE CountPB  	    (VAR pbcnt  : Int16;       VAR pbsiz  : Int16);      VAR   	   ierr  : Int16;  	     BEGIN   DS_FetchTableDescriptor (DS_ProbePCBTD, td, ierr);  	IF ierr <> 0 THEN  	    BEGIN  	   escape (ierr);  	    END  ELSE IF td.td_wordsperelement = 0 THEN     BEGIN { no PROBE }      escape (NSNOPROBE);     END;  { no PROBE }       pbsiz := td.td_maxelement - td.td_minelementindex + 1;      { Now get the pointer to the freelist }   DS_FetchElement (DS_ProbeGTD, 1, ug.pbg.int);   freeptr := ug.pbg.pg_freeq;       &pbcnt := pbsiz;   { assume they are all in use and decrement from free list} & 
WHILE (freeptr <> NULL) DO 
    BEGIN     IF pbcnt = 0 THEN escape (NSLINKEDLISTERR);     DS_FetchElement (DS_ProbePCBTD, freeptr, pb.int);     pbcnt := pbcnt - 1;     freeptr := pb.pcb_nxtptr;  	   END; { while }  	 	END;  { CountPB }  	     $ SUBTITLE 'CountSK',PAGE $       	PROCEDURE CountSK  	    (VAR skcnt  : Int16;       VAR sksiz  : Int16);      VAR       firstptr : Int16; { sockets are in a circularly linked list }   	   ierr  : Int16;  	     	BEGIN { CountSK }  	 DS_FetchGlobal (DS_SBTotal, 1, sksiz);  	IF sksiz = 0 THEN  	 	   BEGIN { no IP } 	    escape (NSNOSOCKETS);  	   END;  { no IP } 	     sksiz := sksiz DIV 2; { we want sockets, not sbufs }      { Now get the pointer to the freelist }   DS_FetchElement (DS_TrackTD, TL_SOCKET_FREEPTR, freeptr);       
firstptr := freeptr; 
 &skcnt := sksiz;   { assume they are all in use and decrement from free list} & IF freeptr <> NULL THEN      REPEAT { we have some free ones }  #   { The socket may be in the process of releasing, but this is good } #    { enough for a rough cut }      IF skcnt = 0 THEN escape (NSLINKEDLISTERR);     DS_SoFetchElement (freeptr, sk.int);      skcnt := skcnt - 1;  
   freeptr := sk.so_fptr;  
    UNTIL (firstptr = freeptr);      { now subtract the sockets reserved for the system }  sksiz := sksiz - ((MMMAXSYSSB + 1) DIV 2);  skcnt := skcnt - ((MMMAXSYSSB + 1) DIV 2);  	END;  { CountSK }  	     $ SUBTITLE 'CountUR',PAGE $       	PROCEDURE CountUR  	    (VAR urcnt  : Int16;       VAR ursiz  : Int16);      VAR   	   ierr  : Int16;  	     BEGIN   DS_FetchGlobal(DS_MAXURID, 1, ursiz);   	IF ursiz = 0 THEN  	    BEGIN { no User records }     escape (NSNOUSERRECORDS);     END;  { no UserRecords }       { Now get the pointer to the freelist }   DS_FetchElement (DS_TrackTD, TL_USER_FREEPTR, freeptr);       &urcnt := ursiz;   { assume they are all in use and decrement from free list} & WHILE freeptr <> NULL DO     BEGIN     IF urcnt = 0 THEN escape (NSLINKEDLISTERR);     DS_UrFetchElement (freeptr, ur.int);      urcnt := urcnt - 1;     freeptr := ur.ur_urecptr;  	   END; { while }  	      { now subtract the user records which are used as hash buckets }   ursiz := ursiz - NUM_UR_BUCKETS;  urcnt := urcnt - NUM_UR_BUCKETS;  	END;  { CountUR }  	     $ SUBTITLE ' ',PAGE $       BEGIN   DS_EnterCritical (wkmp, error);      IF error <> 0 THEN EnterCritError (error);       CountIP (ipcnt, ipsiz);   CountNR (nrcnt, nrsiz);   CountPB (pbcnt, pbsiz);   CountSK (skcnt, sksiz);   CountUR (urcnt, ursiz);       DS_FetchElement (DS_TCP_LISTHDTD, 1, ug.tcg.int);   tcpsegsize := ug.tcg.segsize;       DS_FetchGlobal (NFT_BUFF_SIZE, 1, nftbufsize);  DS_FetchGlobal (NFT_CHECKSUM, 1, nftchecksum);  DS_FetchGlobal (DS_INPRO_CLASS, 1, inproclass);   DS_FetchGlobal (DS_OUTPRO_CLASS, 1, outproclass);   DS_FetchGlobal (DS_IFPM_CLASS, 1, ifpmclass);   DS_FetchGlobal (DS_IFP_CLASS, 1, ifpclass);   DS_LeaveCritical (wkmp);      { Now format the stuff }  	writeln (outfile); 	 writeln (outfile, '                       Resource Usage ');  	writeln (outfile); 	  writeln (outfile, '                 Max Configured           ',                       'Currently Active');   	writeln (outfile); 	     writeln (outfile, 'NS Programs            ',ursiz:3,                    '                      ',urcnt:3);  writeln (outfile, 'Sockets                ',sksiz:3,                    '                      ',skcnt:3);  writeln (outfile, 'Name Records           ',nrsiz:3,                    '                      ',nrcnt:3);  writeln (outfile, 'IP Path Records        ',ipsiz:3,                    '                      ',ipcnt:3);  writeln (outfile, 'Probe PCB Records      ',pbsiz:3,                    '                      ',pbcnt:3);  	writeln (outfile); 	 writeln (outfile, '   INPRO  class  ',IAND(63, inproclass):1);   writeln (outfile, '   OUTPRO class  ',IAND(63, outproclass):1);        $ page $  IF ifpmclass <> 0 THEN     BEGIN  !   writeln (outfile, '   IFPM   class  ', IAND(63, ifpmclass):1);  !    END;   IF ifpclass <> 0 THEN      BEGIN      writeln (outfile, '   IFP    class  ', IAND(63, ifpclass):1);      END;       	writeln (outfile); 	  writeln (outfile, ' TCP Segment Size : ',tcpsegsize:1,' bytes');   IF nftbufsize <> 0 THEN      BEGIN { have NFT }      nftbufsize := nftbufsize * 2; { convert to bytes }   "   writeln (outfile, ' NFT Buffer  Size : ',nftbufsize:1,' bytes');  "    outline := ' NFT Checksum     : ';   
   IF nftchecksum = 0 THEN 
       outline := outline + 'OFF'     ELSE outline := outline + 'ON';         writeln (outfile, outline);     END;  { have NFT }       	writeln (outfile); 	 	writeln (outfile); 	     9:  END; { config }       $ TITLE 'EnterCritError', PAGE $  PROCEDURE EnterCritError     (VAR error  : Int16);         BEGIN { EnterCritError }      writeln (outfile, 'NSINF: Access to DSAM not allowed.  ',                       'Error code: ',error:1);      goto 99;          END;  { EnterCritError }       $TITLE 'LANLocalAddr', PAGE $       FUNCTION LANLocalAddress     (VAR IPAddr : Int32;   
    VAR Staddr : Stataddr; 
     VAR ierr   : Int16)                  : Int16;       VAR      mask  :  RECORD CASE Int16 OF  
      1 : ( bufr : Int16); 
       2 : ( ipad  : Int32);   
      END;  { mask } 
 	   index : Int16;  	     BEGIN   #   mask.ipad := GETNet (ipaddr);  { look  only for the network part }  #        DS_SerialFindandfetchFields (DS_LANRouteTD,        MININT16,      { Start at the beginning of the table }        MAXINT16,      { Stop at the end of the table }         IPADOFF,       { Look at each Ip address }        IPADDRLEN,     { for the length of an IP address }        mask.bufr,        STATIONOFF,    { start at the station address }         STATADDRLEN,   { for the length of the stat addr }        staddr[1],        index,         { lrtindex }         ierr);      
   IF ierr <> 0 THEN 
       BEGIN         LANLocalAddress := -1;        IF ierr = MMNOTFOUND THEN ierr := NSIPNOLAN;        END      ELSE         BEGIN         LANLocalAddress := index;         END;      END; { LANLocalAddress }      $ TITLE 'Locals', PAGE $  	PROCEDURE Locals;  	 "{ Procedure to print all local addressing information.  This is a }  " "{ display routine, and does no internal consistency checking with }  " "{ what is configured through NRINIT or NMGR (on LAN).             }  " #{  I hope this may be used to do that necessary checking externally }  #     LABEL      9;       CONST   
   NOLINKINFO  = -1; 
     TYPE     LipadlstType   = ARRAY [1..5] of LIpadType;  
   AddrsType      = RECORD 
 
               ip : Int32; 
                dn_pid   : Int16;  
               lu : Int16; 
                status   : Int16;                 lanaddrs : ARRAY[1..3] of StatAddr;                    END;      
   lustat   = RECORD 
 
            rlu   : Int16; 
 
            rstat : Int16; 
             END;     lulist   = ARRAY [1..5] of lustat;       CONST      { a list of bogus values }      listinit = lulist [5 of LuStat [rlu:-99, rstat:-99]];      VAR   	   error : Int16;  	 
   ggsize   : Int16; 
 	   ggcnt : Int16;  	    gglus : LUList;   { list of gwy lus and their status }   &   hexf  : UserFormat;  { 12 hex digits of LAN station address with hyphens} &    LAddrlist   : ARRAY[1..5] of AddrsType;     LIPAdlst    : LipadLstType;  
   i, j, k  : Int16; 
 !   IPSz     : Int16;    { number of local IP addresses (up to 5) } !    LocalNode   : Int16;      NameOfNode  : String[MAX_ENVIRON_NAMELEN];      ng       : NGTRecType;  { record from the NGT }     noderec  : NodeRecord;  { contains the local node name }   
   rrsize   : Int16; 
 
   rtrcnt   : Int16; 
    rtrlus   : LUList;      { list of router lus }      td       : TableDescriptorType; { used to get table sizes }  !   WarnIp   : BOOLEAN;  { true if more than 5 local IP addresses } ! "   WarnLUs  : BOOLEAN;  { true if more than 5 of one link type LU }  " 	   wkmp  : Int16;  	     
$ SUBTITLE 'Escape',page $ 
 PROCEDURE Escape  
   (error : Int16);  
    BEGIN     DS_LeaveCritical (wkmp);   %   writeln (outfile, 'NSINF: Internal configuration error encountered. ',  %                      '  Error code ',error:1);     goto 9;     END;       $ SUBTITLE 'FetchLANInfo', PAGE $       PROCEDURE FetchLANInfo     (VAR Laddrs :  AddrsType);       VAR   	   error : Int16;  	 
   found : BOOLEAN;  
 
   gbl   : LANGlobalType;  
 	   i     : Int16;  	 	   ipnet : Int32;  	 
   lrtele   : LRTElement;  
 
   lrtindex : Int16; 
         BEGIN   "lrtindex := LANLocalAddress (laddrs.ip, laddrs.lanaddrs[1], error);  " IF error <> 0 THEN escape (error);      DS_Fetchelement (DS_LANRouteTD, lrtindex, lrtele.bufr);   laddrs.lu := lrtele.lu;   laddrs.status  := lrtele.status;  DS_FetchElement (DS_LANGlobalsTD, 1, gbl.bufr);   found := FALSE;   FOR i := 1 TO (gbl.netcount - 1) DO      IF gbl.mcast[i].mc_lu = laddrs.lu THEN         BEGIN   
      found := TRUE; 
       laddrs.lanaddrs[2] := gbl.mcast[i].mc_target;         laddrs.lanaddrs[3] := gbl.mcast[i].mc_proxy;        END;      IF NOT found THEN escape (NSLANNOMCAST);  END; { fetchLANInfo }       $ SUBTITLE 'FetchLIPAd', PAGE $       
PROCEDURE FetchLipad 
 
   (VAR ipsz      : Int16; 
     VAR warnip    : BOOLEAN;      VAR lipadlst  : LipadLstType);     { Procedure to fetch all local IP addresses. }       VAR   	   error : Int16;  	 	   i , j : Int16;  	 	   start : Int16;  	 	   stop  : Int16;  	        BEGIN {FetchLipad }     DS_FetchTableDescriptor (DS_IP_LOCAL_ADDRS_TD, td, error);   #   IF (error <> 0) OR (td.td_wordsperelement = 0) THEN escape (error); #        ipsz := (td.td_maxelement - td.td_minelementindex + 1);  
   IF ipsz > 5 THEN  
       BEGIN         ipsz := 5;        WarnIP := TRUE;         END;         start := td.td_minelementindex;     stop := start + ipsz - 1;     j := 1;         FOR i := start to stop DO        BEGIN   #      DS_FetchElement (DS_IP_LOCAL_ADDRS_TD, i, lipadlst[j].lpd_bufr); # 	      j := j + 1;  	       END;         END;  {FetchLipad }      $ SUBTITLE 'FetchGWY', PAGE $   PROCEDURE FetchGWYLinks      (VAR GGLus : LUList;       VAR ggsize : Int16);      { This procedure will create a list of all gateway LUs, and }   {  indicate whether the link is up or down.                 }   VAR   	   error : Int16;  	 	   i, j  : Int16;  	 
   gp       : GGPathType;  
 
   start    : Int16; 
 
   stop     : Int16; 
     BEGIN { fetchgwylinks }   { find out how many rerouting links we have }   DS_FetchTableDescriptor (DS_GGTD, td, error);   IF error <> 0 THEN escape (error);      IF td.td_wordsperelement <> 0 THEN     BEGIN     start := td.td_minelementindex;     ggsize := td.td_maxelement - td.td_minelementindex + 1;  !   { we really want the ggsize to be ignoring the loopback path }  !    ggsize := ggsize - 1;     IF ggsize > 5 THEN         BEGIN   	      ggsize := 5; 	       warnlus  := TRUE;         END;      #   stop := start + ggsize; { remember we have dropped the first one }  #    j := 1;      { start at the second entry; the first is the loopback path }      FOR i := start+1 TO stop DO        BEGIN         DS_FetchElement (DS_GGTD, i, gp.int);         gglus[j].rlu := gp.lu;  
      IF gp.flags[0] THEN  
          BEGIN { bit 0 is set }            gglus[j].rstat := LINKISUP;           END   { bit 0 is set }         ELSE           BEGIN           gglus[j].rstat := LINKISDOWN;           END;   	      j := j + 1;  	       END;     END  ELSE     BEGIN { have no gateway links }     END;  { have no gateway links }  END;  { fetchgwylinks }   $ SUBTITLE 'FetchRTR', PAGE $   PROCEDURE FetchRTRLus      (VAR RTRLus : LUList;      VAR rrsize : Int16);      {}  "{ This procedure will create a list of all router LUs.  If a link }  " "{  is a rerouting link, tells whether the link is up or down.     }  " {   { PARAMETERS:   {  INPUT    none  #{  OUTPUT   rtrlus      will contain the list of lus and their status  # "{           rrsize      contains the size of valid entries in RTRlus " {}      VAR   	   error : Int16;  	 	   i, j  : Int16;  	 
   nrrbuf   : Nrrbuftype;  
 
   nrrsize  : Int16; 
 
   rtrbuf   : rtrbuftype;  
 
   start    : Int16; 
 
   stop     : Int16; 
     BEGIN { fetchrtrlus }   { init local variables }  j := 1;   nrrsize := 0;       { find out how many rerouting links we have }   DS_FetchTableDescriptor (DS_LV_TD, td, error);  IF error <> 0 THEN escape (error);      IF td.td_wordsperelement <> 0 THEN     BEGIN     start := td.td_minelementindex;     rrsize := td.td_maxelement - td.td_minelementindex + 1;     IF rrsize > 5 THEN         BEGIN   	      rrsize := 5; 	       warnlus := TRUE;        END;         stop := start + rrsize - 1;         j := 1;     FOR i := start TO stop DO        BEGIN         Fetch_LV (i, rtrbuf);         { lu is the lower 8 bits of the lu }        rtrlus[j].rlu := IAND(rtrbuf[1], octal('377'));         IF rtrbuf [1] < 0 THEN           BEGIN { bit 15 is set }           rtrlus[j].rstat := LINKISUP;            END   { bit 15 is set }        ELSE           BEGIN           rtrlus[j].rstat := LINKISDOWN;            END;   	      j := j + 1;  	       END;     END  	ELSE rrsize := 0;  	     $ page $  { Now get the non rerouting links }   DS_FetchTableDescriptor (DS_NON_RR_TD, td, error);  IF error <> 0 THEN escape (error);      IF td.td_wordsperelement <> 0 THEN     BEGIN     start := td.td_minelementindex;     nrrsize := td.td_maxelement - td.td_minelementindex + 1;      IF rrsize+nrrsize > 5 THEN         BEGIN   
      nrrsize := 5-rrsize; 
       warnlus := TRUE;        END;         stop := start + nrrsize - 1;          FOR i := start to stop DO        BEGIN         Fetch_nrr_index (i, nrrbuf);        rtrlus[j].rlu := nrrbuf[1];         rtrlus[j].rstat := NOLINKINFO;  	      j := j + 1;  	       END;     END  	ELSE nrrsize := 0; 	     rrsize := rrsize + nrrsize;       END;  { fetchrtrlus }       $ SUBTITLE ' Display NGT', PAGE $   PROCEDURE DisplayNGT;   #{ Procedure to fetch all entries in the NGT and display them beneath } # %{  the local addresses.  The NGT is static and created at initialization } % {  time. }  {}      LABEL      888;       TYPE     str8  = string[8];   #   { note that the pids which are supporting IP are hard coded here }  #    { and should be changed if the PIDs do }      pidids   =  ARRAY [IEEE_802..GG_PID] of str8;      CONST      pids  = PidIds [ str8 ['IEEE-802'],                      str8 ['        '],                      str8 ['        '],                      str8 ['        '],                      str8 ['        '],                      str8 ['  RTR   '],                      str8 ['        '],                      str8 ['  GWY   ']   
                  ]; 
     VAR   	   i, j  : Int16;  	 	   ierr  : Int16;  	 
   ipaddr   : String[20];  
 
   ngtrec   : NGTRecType;  
 
   outline  : String [80]; 
    td    : TableDescriptorType;   	   wkmp  : Int16;  	     PROCEDURE MMError (ierr : Int16);      BEGIN     writeln (outfile, 'Error Accessing DSAM: ', ierr:1);      goto 888;     END;               
BEGIN { displayNGT } 
     DS_EnterCritical (wkmp, ierr);  IF ierr <> 0 THEN EnterCritError (ierr);      DS_FetchTableDescriptor (DS_IP_Neigh_Gate_TD, td, ierr);  DS_LeaveCritical (wkmp);  IF ierr <> 0 THEN MMError (ierr);       	writeln (outfile); 	 	writeln (outfile); 	 "writeln (outfile, '                       NEIGHBOR GATEWAY TABLE');  " 	writeln (outfile); 	 	writeln (outfile); 	 	writeln (outfile,  	 %'Destination net   Neighbor Gateway   Down PID  Segment Size  Max Hops');  % 	writeln (outfile,  	 %'---------------   ----------------   --------  ------------  --------');  %     FOR i := td.td_minelementindex TO td.td_maxelement DO      BEGIN { get an element }      DS_EnterCritical (wkmp, ierr);      IF ierr <> 0 THEN EnterCritError (ierr);          DS_FetchElement (DS_IP_Neigh_Gate_TD, i, ngtrec.ngt_bufr);      DS_LeaveCritical (wkmp);       	   WITH ngtrec DO  	       BEGIN         ipaddr := IPArpaStr (ngt_dstnet);         outline := ipaddr;        IF ngt_neighgate = 0 THEN            BEGIN { leave blanks if on the DCN }            ipaddr := '   local net   ';            END        ELSE           BEGIN           ipaddr := IPArpaStr (ngt_neighgate);            END;             outline := outline + '   ' + ipaddr + '    ';       !      strwrite (outline, strlen(outline) + 1, j, pids[ngt_dnpid],  ! "                '      ', ngt_segsize:4, '         ', ngt_hopwd:2);  "       writeln (outfile, outline);   
      END;  { with } 
    END;  { get an element }   888:  
END;  { displayNGT } 
     $ SUBTITLE ' ', PAGE $  BEGIN {locals}  
{ assign initial values }  
 warnIP := FALSE;  	warnLUs := FALSE;  	     ggsize := 0;  rrsize := 0;      	gglus := listinit; 	 
rtrlus := listinit;  
     DS_EnterCritical (wkmp, error);      IF error <> 0 THEN EnterCritError (error);   { get all values needed from DSAM for this routine }  DS_FetchElement (DS_NodesTD, 1, noderec.int);   DS_FetchGlobal (DS_Local_Node, 1, localnode);   FetchLipad (ipsz, warnIP, lipadlst);      IF localnode <> -1 THEN      BEGIN {have router }      FetchRTRLUs (RTRLus, rrsize);     END;  {have router }       FOR i := 1 To ipsz DO      BEGIN     laddrlist[i].ip := lipadlst[i].lpd_addr;      FindNGTRec (laddrlist[i].ip, ng, error);      IF error <> ips_GOOD_RETURN then escape (error);          laddrlist[i].dn_pid := ng.ngt_dnpid; { store the down pid }          CASE ng.ngt_dnpid OF    { and get the rest of the addresses }         IEEE_802 : FetchLANInfo (laddrlist[i]);         GG_PID   : BEGIN                   FetchGwyLinks (GGLUs, ggsize);                    IF ggsize = 0 THEN                       BEGIN { internal error }                      error := NSIPNOGG;                      escape (error);                       END;                   END;         otherwise; { we already have the router links }   
      END;  { case } 
    END;  { for }      	IF ggsize = 0 THEN 	 '   BEGIN { check for gateway links not associated with a special IP address }  '    FetchGwyLinks (GGLUs, ggsize);   '   END;  { check for gateway links not associated with a special IP address }  '     DS_LeaveCritical (wkmp);      { convert nodename to a string }  	NameOfNode := '';  	 strmove (noderec.nr_nodenamelen, noderec.nr_nodename.chars, 1,           NameofNode, 1);      	writeln (outfile); 	 "writeln (outfile,'                       LOCAL NAME AND ADDRESSES'); " 	writeln (outfile); 	 	writeln (outfile); 	 outline :=' Local Name: ' + nameofnode;   
write (outfile, outline);  
 IF localnode <> -1 THEN      BEGIN { router is enabled }      write (outfile, '             Router Address ',localnode:1);       END;  { router is enabled }      	writeln (outfile); 	 	writeln (outfile); 	 IF WarnIP THEN     BEGIN  
   writeln (outfile, 
 $   '*** Warning:  Only the first 5 local IP addresses will be listed.'); $    writeln (outfile);      END;       IF WarnLUs THEN      BEGIN  
   writeln (outfile, 
 !   '*** Warning:  Only the first 5 RTR/GWY LUs will be listed.');  !    writeln (outfile);      END;       	writeln (outfile,  	 &'IP address        LU Status Type  Station address    Multicast addresses'); & 	writeln (outfile,  	 &'---------------  --- ------ ----  -----------------  -------------------'); &     rtrcnt := 1;   { start in rtrlus }  ggcnt := 1;   { start in gglus }      FOR i := 1 To ipsz DO      BEGIN     outline := IparpaStr(laddrlist[i].ip) + '   ';          CASE laddrlist[i].dn_pid OF        IEEE_802 :           BEGIN  !         strwrite (outline, strlen(outline), j,laddrlist[i].lu:3); !          IF laddrlist[i].status = LINKISUP THEN               outline := outline + '   UP   '            ELSE               outline := outline + '  DOWN  ';           outline := outline + ' LAN';   
         hexf := ''; 
          FOR k := 1 TO 2 DO   	            BEGIN  	             InternalToUser (laddrlist[i].lanaddrs[k], hexf);              outline := outline + '  ';              strwrite (outline, strlen(outline) + 1, j, hexf);               END;           writeln (outfile, outline);           outline := '';            InternalToUser (laddrlist[i].lanaddrs[3], hexf);            strwrite (outline, 1, j, hexf);  &         outline := TWENTYSPACES + TWENTYSPACES + '             ' + outline; &          END;  { lan case }       
      ROUTER: BEGIN  
 #         strwrite (outline, strlen(outline), j, rtrlus[rtrcnt].rlu:3); #          IF rtrlus[rtrcnt].rstat = LINKISUP THEN              outline := outline + '   UP   '            ELSE IF rtrlus[rtrcnt].rstat = LINKISDOWN THEN               outline := outline + '  DOWN  '            ELSE outline := outline + '        ';               outline := outline + ' RTR';            rtrcnt := rtrcnt + 1;           END;             GG_PID:            BEGIN  "         strwrite (outline, strlen(outline), j, gglus[ggcnt].rlu:3); "          IF gglus[ggcnt].rstat = LINKISUP THEN              outline := outline + '   UP   '            ELSE IF gglus[ggcnt].rstat = LINKISDOWN THEN               outline := outline + '  DOWN  ';               outline := outline + ' GWY';            ggcnt := ggcnt + 1;           END;             otherwise;  
      END;  { case } 
    writeln (outfile, outline);         END;   { now we may have other lus which are not listed }  FOR i := ggcnt TO ggsize DO      BEGIN { more gateway links }      outline := '                  ';      strwrite (outline, strlen(outline), j, gglus[i].rlu:3);     IF gglus[i].rstat = LINKISUP THEN        outline := outline + '   UP   '      ELSE IF gglus[i].rstat = LINKISDOWN THEN         outline := outline + '  DOWN  ';         outline := outline + ' GWY';      writeln (outfile, outline);     END;  { more gateway links }       FOR i := rtrcnt TO rrsize DO     BEGIN { more router links }     outline := '                  ';      strwrite (outline, strlen(outline), j, rtrlus[i].rlu:3);      IF rtrlus[i].rstat = LINKISUP THEN         outline := outline + '   UP   '      ELSE IF rtrlus[i].rstat = LINKISDOWN THEN        outline := outline + '  DOWN  '      ELSE outline := outline + '        ';         outline := outline + ' RTR';      writeln (outfile, outline);     END;  { more router links }      DisplayNGT;       9:  END;  { locals }  $ TITLE 'SktInf', page $          {}  { PROGRAM DESCRIPTION :   #{  This is the info utility for socket information.  It uses and frees # !{  large sections of the heap each time it is called, in order to  ! {  create its list of sockets.  {}      	PROCEDURE Sktinf;  	         LABEL      999;           TYPE  "   { this variant record will be used for all of the path records }  "    PRecTYPE = RECORD Case Int16 OF         { Table descriptor : DS_TCP_PathTD, dcl file tcpgb.pas }      1 : ( pr_tcp : TCPPathRecType);         { Table descriptor : DS_PXPPathTD, dcl file pxplb.pas }     2 : ( pr_pxp : PXPPathRecType);          { Table descriptor : DS_IP_Path_Rec_TD, dcl file ipdec.pas }       3 : ( pr_ippa  : PathRecType);          { Table descriptor : DS_IP_Anh_Rec_TD, dcl file ipdec.pas }     4 : ( pr_ipah  : AnhRecType);         { Table descriptor : DS_LANRouteTD, dcl file lan8.pas }     5 : ( pr_lan   : LRTElement);         { Table descriptor : DS_GGTD, dcl file lklb.pas }     6 : ( pr_gg    : GGPathType);         { Table descriptor : DS_NRV_TD, dcl file rrdec.pas }      7 : ( pr_rtr   : NRVEntryType);         END;  { PrecType }       $ PAGE $         ProtoStackType =  RECORD                        sd :  RECORD   &                           lsd   : Int16;       { local socket descriptor }  &                            gsd   : Int16;                              sp    : ^SocketRecord;                              END;  { sd }                        protos   : ARRAY[1..4] of                             RECORD                                 pd : Int16;                                 pp : ^PRecType;                              END;  { protos }                        END; { ProtoStackType }      { One of these is allocated for each socket a program owns }         Sktptr   =  RECORD                  link  : ^Sktptr;                  psptr : ^ProtoStackType;   
               END;  
         
   SocketlistType = RECORD 
                head  : ^Sktptr;                  tail  : ^sktptr;   
               END;  
     VAR   	   error : Int16;  	 %   continue    : BOOLEAN;  { whether user wants to continue the printout } % &   gotthemall  : BOOLEAN;  { whether we got all sockets owned by the prog }  &    pname : string [80];       { name from input }      ProgName : PrognameType;   { PAC 6 for user record }      socketlist : SocketlistType;      urec  : UserRecord;  	   wkmp  : Int16;  	     $ PAGE $  PROCEDURE FindSockets      (VAR urec   : UserRecord;      VAR SocketList   : SocketListType;      VAR gotthemall   : BOOLEAN);     FORWARD;       
PROCEDURE FormatPath 
    (VAR socketlist   : SocketListType);      FORWARD;       
PROCEDURE FreeSpace  
    (VAR socketlist   : SocketListType);      FORWARD;       	PROCEDURE GetPath  	    (VAR  ProtoStack  :  ProtoStackType);     FORWARD;       	FUNCTION HaveUrec  	    (VAR Urec   : UserRecord )         : BOOLEAN;     FORWARD;       
PROCEDURE InitSktPtr 
    (VAR newsktptr : sktptr);     FORWARD;       
PROCEDURE StrToUrec  
    (VAR pname : String;       VAR progname  : PrognameType);     FORWARD;       $SUBTITLE 'FindSockets', PAGE $       PROCEDURE FindSockets      (VAR urec   : UserRecord;      VAR SocketList   : SocketListType;      VAR gotthemall : BOOLEAN);      {}  { Discussion:   !{  This proc finds each of hte programs sockets, making sure that  !  {  there will still be enough space in the heap/stack area.  The   ${  magic number 800 comes because that is what is needed in stack space  $ {  in order to get to the proc which frees space.   {}  VAR      hsinfo   : InfoRec;  	   i     : Int16;  	    kind  : Int16;    { kind of socket }   
   morespace   : BOOLEAN;  
    urskt    : ^sktptr;      BEGIN { FindSockets }       { Initialize }  socketlist.head := NIL;   socketlist.tail := NIL;   
gotthemall := TRUE;  
     FOR i := 0 TO MAX_SOCKETS_PER_USER DO      BEGIN     IF (urec.ur_smap [i] > 0) AND (urec.ur_smap[i] < 255) THEN         BEGIN { we have a valid gsd }   
      GetHSInfo (hsinfo);  
       morespace := ((hsinfo.toh - hsinfo.tos) >= 800);        IF morespace THEN            BEGIN { and we have enough room to process }            NEW (urskt);  { allocate room to store all the info }           InitSktPtr (urskt^);                { link into the previously existing list, if any }             IF socketlist.head = NIL THEN socketlist.head := urskt;            IF socketlist.tail <> NIL THEN   	            BEGIN  	             socketlist.tail^.link := urskt;               END;      !         socketlist.tail := urskt;  { always link it to the tail } !              WITH urskt^.psptr^.sd DO   	            BEGIN  	              { the local descriptor is the index into the smap }                lsd := i;               gsd := urec.ur_smap [i]; { store the gsd }              DS_SoFetchElement (gsd, sp^.int);               kind := sp^.so_b.kind;  
            END; { with }  
              IF (kind = CALL) OR (kind = VC) THEN              BEGIN              GetPath (urskt^.psptr^);             END;            END   { we have enough room to process }         ELSE           BEGIN { more sockets but no more space }            gotthemall := FALSE;            END;  { more sockets but no more space }         END; { we have a valid gsd }  	   END;   { for }  	     END;  { FindSockets }           $ SUBTITLE 'FormatPath', PAGE $       
PROCEDURE FormatPath 
    (VAR  SocketList : SocketListType);  {}  { Discussion  ${  Procedure to format the huge data structure which has been created }  $ ${  we start by writing the socket index, kind and state, and then     }  $ ${  proceed from there if there is an acceptable path connected to it. }  $ {}      TYPE     str21 = string[21];     str25 = string[25];     str16 = string[16];  !   CallStates = ARRAY[CALL_BINDING..CALL_COUNTING_DOWN] of Str21;  !    VCStates   = ARRAY[VC_EMERGING..VC_COUNTING_DOWN] of Str25;     RootStates = ARRAY[ROOT_CLEAR..ROOT_DOWNED] of Str16;      CONST      CALLS = CallStates [         Str21['CALL_BINDING'],        Str21['CALL_BUD_NIPPED'],   
      Str21['CALL_BOUND'], 
       Str21['CALL_REJECTED'],         Str21['CALL_CLOSING_OUT'],        Str21['CALL_CLOSING_IN'],         Str21['CALL_AWAITING_CLEANUP'],         Str21['CALL_AWAITING_ABCONF'],        Str21['CALL_COUNTING_DOWN']];          Roots = RootStates [   
      Str16['ROOT_CLEAR'], 
       Str16['ROOT_TRANSACTING'],        Str16['ROOT_RESPONDED'],        Str16['ROOT_DOWNED']];         VCs   = VCStates [         Str25['VC_EMERGING'],         Str25['VC_BUD_NIPPED'],         Str25['VC_ESTAB_CONFIRM_PENDING'],        Str25['VC_ESTAB_RESPONSE_PENDING'],         Str25['VC_ACCEPT_REJECT_PENDING'],        Str25['VC_OPEN_CONFIRMING'],        Str25['VC_OPEN_ACCEPTING'],         Str25['VC_OPEN'],         Str25['VC_GRELEASING'],         Str25['VC_AWAITING_GRCONF'],        Str25['VC_USER_ABORTED'],         Str25['VC_AWAITING_ABCONF'],        Str25['VC_SERVER_ABORTED'],         Str25['VC_AWAITING_CLEANUP'],         Str25['VC_COUNTING_DOWN']];   $ page $      VAR   
   i        : Int16; 
 
   kind     : string [6];  
 $   MyIPAddr : Int32; { my ip address needed between IP and LAN formats } $    sktpath  : ^SktPtr;   { take this one socket at a time }   
   so_state : Int16; 
     st_desc  : String[25];  { ascii string describing the state }   
   TheresAPath : BOOLEAN;  
     $ SUBTITLE 'FormatTCP', PAGE$   
PROCEDURE FormatTCP  
    (VAR tcppath   : PRecType);     BEGIN { formatTCP }  
   WITH tcppath.pr_tcp DO  
       BEGIN         write (outfile, ' TCP    source port: ', p_s_port:6);         IF p_si_addr <> 0 THEN           BEGIN { we have a drec }   "         writeln (outfile, '             dest port: ', p_d_port:6);  "          writeln (outfile,  '         rcv ulp ct: ',  !               p_msg_cnt:6,'            snd ulp ct: ',p_up_cnt:6); !          writeln (outfile, '          snd dn ct: ',   "               p_snd_cnt:6,'             rcv dn ct: ',p_ref_cnt:6);  "          writeln (outfile, '  down ref: ',p_dn_refr:1);            END   { we have a drec }         ELSE           BEGIN {we have an irec; no more to say }            writeln (outfile);            END;  {we have an irec; no more to say }         END;     END;  { formatTCP }      $ SUBTITLE 'FormatIP', PAGE $       	PROCEDURE FormatIP 	    (VAR  ippath   : PRecType;       VAR myipaddr  : Int32);       
   BEGIN {FormatIP}  
 
   WITH ippath.pr_ippa DO  
       BEGIN         myipaddr := pr_local;   { remember this for lan }         writeln (outfile, ' IP     source addr: ',  #        IPArpaStr(pr_local), '    dest addr: ', IPArpaStr(pr_remote)); #       writeln (outfile,  '         rcv ulp ct: ',   %        pr_ulp_dn_emscnt:6,'            snd ulp ct: ',pr_ulp_up_emscnt:6); %       END;  
   END;  {FormatIP}  
     $ SUBTITLE 'FormatANH', PAGE $  PROCEDURE FormatIPAnh      (VAR  ipanh    : PRecType);     BEGIN {FormatIPAnh }      WITH ipanh.pr_ipah DO  
      BEGIN { with } 
       writeln (outfile, '          snd dn ct: ',  !        ah_dn_emscnt:6,'             rcv dn ct: ',ah_up_emscnt:6); !       writeln (outfile, '  down ref: ',ah_dnpath:1);  
      END; { with }  
    END;  {FormatIPAnh}      $ SUBTITLE 'FormatLAN', PAGE $      
PROCEDURE FormatLAN  
    (VAR  lanpath  : PRecType;       VAR  ipref    : Int16);           VAR      found    : BOOLEAN;     gbl      : LANGlobalType;     i        : Int16;       { loop counter }   
   ierr     : Int16; 
 
   lrtele   : LRTElement;  
     lrtindex : Int16;       { index into the LAN routing table }       myele    : LRTElement;  { path reference for my alias }  
   mylanaddr   : StatAddr; 
    pref     : pathreftype; { variant to split the ref apart }       useraddr : userformat;  { hex format of the station address }   
   wkmp     : Int16; 
     $ PAGE $      
   BEGIN {FormatLAN} 
    { first get my local lan address }      IF (lanpath.pr_lan.lanaddr[1] = 0) AND         (lanpath.pr_lan.lanaddr[2] = 0) AND         (lanpath.pr_lan.lanaddr[3] = 0) THEN        BEGIN { we have loopback }        mylanaddr := DEFAULT_STATION;         lrtele.lu := 0; { use loopback lu }         END   { we have loopback }     ELSE         BEGIN { we will go out the machine }        DS_EnterCritical (wkmp, ierr);        IF ierr <> 0 THEN EnterCritError (ierr);      
      pref.bufr := ipref;  
       lrtindex := pref.ref.statindex;         DS_FetchElement (DS_LANRouteTD, lrtindex, lrtele.bufr);         DS_FetchElement (DS_LANGlobalsTD, 1, gbl.bufr);       "      { search through all LAN aliases to find a match between LUs } " $      { The LAN station address contained in the record is the station } $ "      {  address used by the card when transmitting out that LU.   } "           found := FALSE;         FOR i := 2 TO gbl.netcount DO            BEGIN { find the LU }           DS_FetchElement (DS_LANRouteTD, i, myele.bufr);           IF myele.lu = lrtele.lu THEN              BEGIN             mylanaddr := myele.lanaddr;  
           found := TRUE;  
            END;            END;  { find the LU }            DS_LeaveCritical (wkmp);            END;      
   WITH lanpath.pr_lan DO  
       BEGIN   
      IF found THEN  
          BEGIN           InternalToUser (mylanaddr, useraddr);           write (outfile, ' LAN    source addr: ',useraddr);            END        ELSE           BEGIN { tell user there is a problem }   '         writeln (outfile, 'Internal configuration error. LAN does not know',  ' "            ' of LU ',lrtele.lu:1, ' contained in IP ref ',ipref:1); "          END;  { tell user there is a problem }             InternalToUser (lanaddr, useraddr);         writeln (outfile, '  dest addr: ', useraddr);         writeln (outfile,  '         rcv ulp ct: ',           rcvulpct:6,'            snd ulp ct: ',sndulpct:6);        writeln (outfile, '  lu: ',lrtele.lu:1);        END;      
   END;  {FormatLAN} 
     $ SUBTITLE 'FormatRTR', PAGE $      
PROCEDURE FormatRTR  
    (VAR  rtrpath  : PRecType);  ${ We need only to display the destination node and the LU we will use }  $     	BEGIN {FormatRTR}  	 WITH rtrpath.pr_rtr DO     BEGIN     writeln (outfile, ' RTR    dest node: ',nv_node_number:1,                       '        LU: ',nv_link_lu:1);     END; {with}  	END;  {FormatRTR}  	     $ SUBTITLE 'FormatGWY', PAGE $      { We have only to display the lu and the link type }  
PROCEDURE FormatGWY  
    (VAR  ggpath   : PRecType);      TYPE     str4  = String [4];      !   { note: the type below is dependent on the constants GLT_HDLC.. !    {  which are declared in LKLB}      lktype = ARRAY [1..3] OF str4;       CONST      gglink   = lktype [  
      str4['HDLC'],  
 
      str4['X.25'],  
 
      str4['LAPB']]; 
     VAR   
   linktype : Int16; 
         	BEGIN {FormatGWY}  	 outline := ' GWY   linktype: ';   linktype := ggpath.pr_gg.link_type;   IF linktype = GLT_LOOPBACK THEN      BEGIN     outline := outline + 'LOOPBACK';      END  ELSE     BEGIN     outline := outline + gglink[linktype] + '    ';     end;       writeln (outfile, outline, '   LU: ',ggpath.pr_gg.lu:1);      	END;  {FormatGWY}  	     $ SUBTITLE 'FormatPath', PAGE $       
BEGIN { FormatPath } 
 kind := '';   continue := TRUE;  { initialize }       	writeln (outfile); 	 Writeln (Outfile, ' Sockets owned by program ',pname);  sktpath := socketlist.head;  { get the first socket }   WHILE (sktpath <> NIL) AND (continue) DO     BEGIN { while there is still another socket to format }     WITH sktpath^.psptr^.sd DO         BEGIN         so_state := sp^.so_b.state;         CASE sp^.so_b.kind OF            CALL        : BEGIN                         kind :=   'CALL';                         st_desc := Calls[so_state];                         TheresAPath := (so_state = CALL_BOUND);                         END;            VC          : BEGIN                         kind :=   'VC';                         st_desc := VCs[so_state];  #                       TheresAPath := (so_state <= VC_GRELEASING) AND  # !                          (so_state >= VC_ESTAB_CONFIRM_PENDING);  !                        END;            ROOTSOCKET  : BEGIN                         kind :=   'ROOT';                         st_desc := ROOTs[so_state];                         TheresAPath := FALSE;                         END;            Otherwise     BEGIN                         kind := '?';                          st_desc := '';                          TheresAPath := FALSE;                         END;            END;  { case }             writeln (outfile);  %      writeln (outfile, 'LSD: ', lsd:1, '   GSD: ', gsd:1, '   UrecID: ',  % %               sp^.so_urecid:1, '   Kind: ', kind, '   State: ', st_desc); %     
      END;  { with } 
     $ PAGE $     IF TheresAPath THEN        BEGIN { protocol paths to format }        WITH sktpath^.psptr^ DO            BEGIN  #         writeln (outfile, '  down ref: ', sd.sp^.so_down_pathref:1);  #          i := 1;           WHILE (i <= 4) AND (protos[i].pd <> MEANINGLESS) DO  	            BEGIN  	             CASE protos[i].pd OF                 TCP   : FormatTCP (protos[i].pp^);                  IP    : BEGIN { IP case }                         FormatIP  (protos[i].pp^, myipaddr);                          i := i + 1;   { now get anh record }                          FormatIPAnh (protos[i].pp^);                          END;   { IP case }   
               IEEE_802 :  
                        BEGIN                         FormatLAN (protos[i].pp^,  #                                  protos[i-1].pp^.pr_ipah.ah_dnpath);  #                        END;   { LAN case }                 ROUTER: FormatRTR (protos[i].pp^);                  GG_PID: FormatGwy (protos[i].pp^);                  END;  { case }               i := i + 1;               END;  { while }            END;  { with }         END;  { protocol paths to format }      
   { get the next record } 
    sktpath := sktpath^.link;      "   { If we have just printed a big one and there is more to print }  "    IF (i > 4) AND (sktpath <> NIL) THEN         BEGIN         continue := More;         END;         END;  { while there is still another socket to format }  
END;  { FormatPath } 
     $SUBTITLE 'FreeSpace', PAGE$      #{ Procedure to reclaim the space in the heap.  Deallocation is done }  # #{  in the reverse order of allocation.                              }  #     
PROCEDURE FreeSpace  
    (VAR socketlist   : SocketListType);       VAR   
   i        : Int16; 
 
   nexttofree  : ^sktptr;  
 
   temp        : ^sktptr;  
     
BEGIN { FreeSpace }  
 nexttofree := socketlist.head;  
WHILE nexttofree <> NIL DO 
    BEGIN { free everything }     temp := nexttofree^.link;  { save the next guy }      FOR i := 1 TO 4 DO         BEGIN { free the protocol records }         Dispose (nexttofree^.psptr^.protos[i].pp);        END;  { free the protocol records }          Dispose (nexttofree^.psptr^.sd.sp);         Dispose (nexttofree^.psptr);          Dispose (nexttofree);         nexttofree := temp;     END;  { free everything }      
END;  { FreeSpace }  
     $SUBTITLE 'HaveUrec', PAGE $      ${ Function to determine whether the program entered has a user record }  $ 	FUNCTION HaveUrec  	    (VAR Urec   : UserRecord )         : BOOLEAN;      VAR   
   found : BOOLEAN;  
 	   i     : Int16;  	     BEGIN {HaveUrec}      i := 1;   found := FALSE;   "{ The user records are chained off the first num_ur_buckets in the } " "{  user record table.  We will go through each bucket and follow   } " "{  each chain, searching for the user record with the matching name} "     WHILE (NOT found) AND (i <= NUM_UR_BUCKETS) DO     BEGIN { search for the user record }      DS_UrFetchElement (i, urec.int);      { now follow the chain from this bucket }     WHILE (urec.ur_urecptr <> NULL) AND (NOT found) DO         BEGIN { get the next one }        DS_UrFetchElement (urec.ur_urecptr, urec.int);        IF (urec.ur_progname.chars = progname.chars) THEN            BEGIN { we found one }            found := TRUE;            END;  { we found one }         END;  { get the next one }     i := i + 1;  { try the next bucket }      END;  { search for the user record }       	HaveUrec := Found; 	 END;  {HaveUrec}          $ SUBTITLE 'GetPath', PAGE $      	PROCEDURE GetPath  	    (VAR  ProtoStack  :  ProtoStackType);      VAR      i  : Int16;     ippathindex : Int16;      ipanhindex  : Int16;   	   lkidx :  Int16; 	     
PROCEDURE GetGGPath  
 
   (     ggindex : Int16;  
     VAR  path  : PrecType);          BEGIN { GetGGPath }     DS_FetchElement (DS_GGTD, ggindex, path.pr_gg.int);     END;  { GetGGPath }          	PROCEDURE GetIPAnh 	    (     ipanhindex : Int16;      VAR  path  : Prectype);          BEGIN { getIPAnh }   $   DS_FetchElement (DS_IP_Anh_Rec_TD, ipanhindex, path.pr_ipah.ah_bufr); $    END;  { getIPAnh }           
PROCEDURE GetIPPath  
    (     ippathindex : Int16;       VAR  path  : PrecType);          BEGIN { getIPPath }     DS_FetchElement (DS_IP_Path_Rec_TD, ippathindex,                       path.pr_ippa.pr_bufr);     END;  { getIPPath }      $ page $  
PROCEDURE GetLANPath 
 
   (     lanindex : Int16; 
     VAR  path  : PrecType);          VAR        LRTIndex : Int16;         pref     : pathreftype;              BEGIN { getLANPath }   
   pref.bufr := lanindex;  
    lrtindex := pref.ref.statindex;      DS_FetchElement (DS_LANRouteTD, lrtindex, path.pr_lan.bufr);       END;  { GetLANPath }           
PROCEDURE GetRTRPath 
    (     nrvindex    : Int16;       VAR  path  : PrecType);          BEGIN { GetRTRPath }      Fetch_NRV_Index (NRVIndex, path.pr_rtr);      END;  { GetRTRPath }           
PROCEDURE GetPXPPath 
 
   (     pxpindex : Int16; 
     VAR  path  : PrecType);          BEGIN { GetPXPPath }      DS_FetchElement (DS_PXPPathTD, pxpindex, path.pr_pxp.int);      END;  { GetPXPPath }           
PROCEDURE GetTCPPath 
    (     tcppathindex : Int16;      VAR  path  : PrecType);          BEGIN { gettcppath }   !   DS_FetchElement (DS_TCP_PathTD, tcppathindex, path.pr_tcp.int); !        END;  { gettcppath }       $ Page $  	BEGIN { getpath }  	 #{ We have the socket, now find the kind of socket.  If it is a call }  # #{  socket, we will have a path only to TCP ( an IPath).  If it is a }  # #{  VC socket, then the length and validity of the path will depend  }  # #{  on the state of the socket.                                      }  #         	WITH Protostack DO 	    BEGIN { with socket }     CASE sd.sp^.so_b.kind OF         CALL  :            BEGIN { call socket processing }            protos [1].pd := TCP; { check the socket ?}           GetTCPPath (sd.sp^.so_down_pathref, protos[1].pp^);           END;  { call socket processing }         VC    :            BEGIN { VC socket processing }            protos [1].pd := TCP;           GetTCPPath (sd.sp^.so_down_pathref, protos[1].pp^);           CASE sd.sp^.so_b.state OF              VC_ESTAB_CONFIRM_PENDING..VC_GRELEASING :                  BEGIN { a valid extended path }                 ippathindex := protos[1].pp^.pr_tcp.p_dn_refr;                  protos [2].pd := IP;                  GetIPPath (ippathindex, protos[2].pp^);                 IPAnhIndex := protos[2].pp^.pr_ippa.pr_anh_idx;                 protos [3].pd := IP;                  GetIPAnh (ipanhIndex, protos[3].pp^);                 lkidx := protos[3].pp^.pr_ipah.ah_dnpath;                     CASE protos[3].pp^.pr_ipah.ah_dnpid OF                     GG_PID   :                       BEGIN { gateway case }                        protos [4].pd := GG_PID;                        GetGGPath (lkidx, protos [4].pp^);                        END;  { gateway case }                         IEEE_802 :                       BEGIN { lan case }                        protos [4].pd := IEEE_802;                        GetLANPath (lkidx, protos [4].pp^);                       END;  { lan case }                         ROUTER   :                       BEGIN { rtr case }                        protos [4].pd := ROUTER;                        GetRTRPath (lkidx, protos [4].pp^);                       END;  { rtr case }                         Otherwise                        BEGIN { unknown pid }                       END;  { unknown pid }                        END; { case }                      END;  { a valid extended path }              Otherwise                  BEGIN { no further path records }                 END;  { no further path records }              END; { case so_b.state }                   END;  { VC socket processing }         Otherwise            BEGIN { some other state }            END;  { some other state }             END;  { case so_b.kind }         END;  { with socket }      	END;  { getpath }  	     $ SUBTITLE 'InitSktPtr', PAGE $       
PROCEDURE InitSktPtr 
    (VAR newsktptr : sktptr);      VAR      i : Int16;       	BEGIN {InitSktPtr} 	     !{ we will first set the link pointer values in the record to NIL } ! newsktptr.link := NIL;      { allocate space for the protocol stack }   NEW (newsktptr.psptr);      "{ now set all protos to MEANINGLESS, so that we will know when to }  " "{  stop formatting the paths.                                     }  "     	FOR i := 1 TO 4 DO 	    BEGIN     newsktptr.psptr^.protos[i].pd := MEANINGLESS;         { and allocate space for the path record }      NEW (newsktptr.psptr^.protos[i].pp);      END;       { allocate space for the socket record which heads each path }  NEW (newsktptr.psptr^.sd.sp);       	END;  {InitSktPtr} 	     $ SUBTITLE 'StrToUrec', PAGE $      ${ Procedure to convert the program name as enetered to the type which }  $ ${ is stored in a user record:  max 5 characters, padded with spaces   }  $     
PROCEDURE StrToUrec  
    (VAR pname : String;       VAR progname  : PrognameType);      VAR      i  : Int16;  	   len   : Int16;  	     
BEGIN { StrToUrec }  
 progname.chars := '      ';   
IF strlen (pname) < 5 THEN 
    len := strlen (pname)  ELSE     len := 5;      { Now shift to Upper Case if necessary }  
FOR i := 1 TO len DO 
    BEGIN  
   CASE pname [i] of 
    'a'..'z':        BEGIN         progname.chars [i] := chr (ord(pname[i]) - 32);         END;     Otherwise        BEGIN         progname.chars [i] := pname[i];         END;  
      END;  { case } 
    END;  { for }      
END;  { StrToUrec }  
     $ SUBTITLE ' ', PAGE $      BEGIN { sktinf }      Prompt (outfile, 'ProgName: ');   pname := '';   { Initialize }   readln (infile, pname);       StrToUrec (pname, progname);      DS_EnterCritical (wkmp, error);   IF error <> 0 THEN EnterCritError (error);      IF NOT HaveUrec (urec) THEN      BEGIN { end this silliness }      DS_LeaveCritical (wkmp);      writeln (outfile, 'No User record exists for ',pname);      goto 999;     END;  { end this silliness }       ${ Once found, we need to get all the sockets belonging to this program } $ ${  Their gsd's are found in the smap array of the user record          } $     FindSockets (urec, socketlist, gotthemall);   DS_LeaveCritical (wkmp);      IF NOT gotthemall THEN     BEGIN  %   writeln (outfile, 'WARNING: Not enough space in the heap for all of ',  %                      pname, '''s sockets.');     END;       IF socketlist.head <> NIL THEN     BEGIN { if anything to do }     FormatPath (socketlist);   
   FreeSpace (socketlist); 
    END;  { if anything to do }      999:  END;  { sktinf }  $ TITLE 'Utils', PAGE $   {-------------------------------------------------------}   
{              UTILS 
 {-------------------------------------------------------}           PROCEDURE Utils;  {}  {  Procedure to give the current status of the utilities,   {  currently Event logging and NSTRC.   {}  TYPE     str14 = String[14];     levels   = ARRAY[0..LASTEVENT] OF str14;       CONST   
   desc  = levels [  
              str14 ['              '],    { logstat; for brevl }                str14 ['              '],    { proto specific }               str14 ['Event Message '],               str14 ['Warning       '],               str14 ['Error         '],               str14 ['Disaster      '],               str14 ['Resource Limit'],               str14 ['              ']     { for test programs }  
                  ]; 
     VAR   
   error    : Int16; 
    evlmask  : MMFlagsType;    { event logging mask }     gbl      : EventGlobal;   { Event logging global block }   
   i, j     : Int16; 
    hltclass : Int16;         { socket level trace class }      lltclass : Int16;         { network level trace class }     logmask  : masktype;      { octal representation of mask }   { Note: LOGFNAMESIZE is declared in trcmod }  "   logname  : String [LOGFNAMESIZE*2]; { log file name as a string } " "   netclass : Int16;         { NSTRC class if skt only is enabled }  " 
   wkmp     : Int16; 
         $ PAGE $  BEGIN { Utils }   DS_EnterCritical (wkmp, error);   	IF error <> 0 THEN 	 
   EnterCritError (error); 
     DS_FetchElement (DS_EventGlobalsTD, 1, gbl.bufr);   DS_FetchGlobal  (DS_Logmask, 1, evlmask.int);   DS_FetchGlobal  (DS_HLTClass, 1, hltclass);   DS_FetchGlobal  (DS_LLTClass, 1, lltclass);   DS_FetchGlobal  (DS_NETClass, 1, netclass);   DS_LeaveCritical (wkmp);      "ConvertToOctal (evlmask.int, logmask);  { convert logmask to octal } "     { mask out security bits in the class numbers }   hltclass := IAND (hltclass, 63);  lltclass := IAND (lltclass, 63);  netclass := IAND (netclass, 63);      	Writeln (outfile); 	 #writeln (outfile,'                 NS Utility Status and Statistics'); # 	writeln (outfile); 	 !writeln (outfile, '                      Event Logging Summary');  ! 	writeln (outfile); 	 writeln (outfile, '  Current Log Mask:     ',logmask,'b');      IF gbl.sbufid = 0 THEN     BEGIN { evmon is not there }      writeln (outfile);   !   writeln (outfile, 'Warning: EVMON is not currently running.');  !    END   { evmon is not there }   ELSE     BEGIN { we have EVMON, write out the log file name }      logname := '';    { initialize this }     { convert the PAC into a string }     strmove (gbl.logfnamelen, gbl.logfilename, 1, logname, 1);      writeln (outfile, '  Log file name:      ', logname);     END;  { we have EVMON, write out the log file name }       	writeln (outfile); 	     
i := LASTEVENT - 1;  
 { we want to display only fields which have meaning here }  WITH gbl DO      REPEAT      IF evlmask.bits [-i] THEN        BEGIN         outline := TWENTYSPACES + '  * ' + desc[i];         END      ELSE         BEGIN         outline := TWENTYSPACES + '    ' + desc[i];         END;     outline := outline + ' ';     strwrite (outline, strlen(outline), j, evtype[i]:6);      writeln (outfile, outline);     i := i - 1;     UNTIL i = 1;    { this ends the with as well }       $ PAGE $  { Now to display the mesage tracing information }   	writeln (outfile); 	 outline := 'Message Tracing ';  
IF lltclass = 0 THEN 
    IF hltclass = 0 THEN         BEGIN         writeln (outfile, outline, 'is not enabled.');        END      ELSE         BEGIN         outline := outline + TWENTYSPACES;         writeln (outfile, outline, '       Trace level: Socket');          writeln (outfile);  &      writeln (outfile, TWENTYSPACES,'   Socket class number ',hltclass:1);  & &      writeln (outfile, TWENTYSPACES,'   NSTRC  class number ',netclass:1);  &       END   ELSE { netwrok level tracing is enabled }      BEGIN     outline := outline + TWENTYSPACES;      IF hltclass = 0 THEN         BEGIN { net level only }         writeln (outfile, outline, '       Trace level: Network');         writeln (outfile);  &      writeln (outfile, TWENTYSPACES,'   NSTRC  class number ',lltclass:1);  &       END      ELSE         BEGIN { we have both levels enabled }         writeln (outfile, outline, '       Trace level: Both');         writeln (outfile);  &      writeln (outfile, TWENTYSPACES,'   Socket class number ',hltclass:1);  & &      writeln (outfile, TWENTYSPACES,'   NSTRC  class number ',lltclass:1);  &       END;     END;   END;  { Utils }   $ PAGE $  PROCEDURE Menu;       	   BEGIN { menu }  	    writeln (outfile);   '   writeln (outfile, '                      NSInf Main Menu (''e'' to exit)'); '    writeln (outfile);      writeln (outfile, 'Configuration Information');     writeln (outfile, '      C     Configured Resources');      writeln (outfile, '      A     Local Name and Addresses');      writeln (outfile);      writeln (outfile, 'DS/1000-IV Information');      writeln (outfile, '      T     List Tables');     writeln (outfile, '      M     Message Accounting');      writeln (outfile, '      N     Nodal Routing Vector');      writeln (outfile, '      R     Rerouting information');     writeln (outfile, '      S     Remote Session');      writeln (outfile, '      V     DS/1000-IV Values');     writeln (outfile);      writeln (outfile, 'Status and Statistics');     writeln (outfile, '      I     List all NS/1000 LUs');   #   writeln (outfile, '      L     Detailed information on an NS LU');  # "   writeln (outfile, '      B     Buffer and Memory Manager Info');  " #   writeln (outfile, '      U     NS Utility Status and Statistics');  # "   writeln (outfile, '      P     Individual Program Information');  " 	   END;  { menu }  	 $PAGE $   PROCEDURE MMgr;   !   { Procedure to pront the memory manager status and statistics } !     CONST   #   MENU_LEVEL  = 0;     { used to index into case statement in mminf } #     VAR      another  : BOOLEAN;     i  : Int16;      BEGIN { mmgr }  WITH info DO     BEGIN { with Info }     i := 0;  
   another := TRUE;  
        WHILE (i <= 2) AND (another) DO        BEGIN         inputs[MENU_LEVEL] := i*4;            WHILE mminf (info) > 0 DO            BEGIN  
         PrInfo (buffer);  
          END;       	      i := i + 1;  	 
      IF i <= 2 THEN 
          BEGIN           another :=  More; { ask user if they want out }           END;   
      END; { while } 
    END;  { with info }  END;  { mmgr }      $ PAGE $  (*  (*PROCEDURE Pause (VAR chars : string);   (*  (*BEGIN   %(*   { writeln (outfile, 'More... (''a'' to abort, <cr> to continue)'); }  % (*   IF eoln (infile)   (*      THEN reset (infile)   (*   ELSE readln (infile, chars); { hang a read }   (*  (* IF chars = '' THEN chars := ' ';   (*  	(* END; { pause }  	 (**)          
PROCEDURE UpperCase  
 
   (VAR choice : String);  
     BEGIN      IF (ord (choice[1]) <= 122) AND {'z'}        (ord (choice[1]) >= 97)  THEN {'a'}         choice[1] := chr(ord(choice[1]) - 32);      	END;{ UpperCase }  	         $ PAGE $  BEGIN { NSInf }   
reset (infile, '1'); 
 rewrite (outfile, '1');   InitializeIO;  { initialize the io for the inflb routines }   CheckNSStates; { check the state of NS }  output_lu := 1;       	writeln (outfile); 	 	writeln (outfile); 	 REPEAT { guard against null input }      prompt (outfile, 'NSInf > ');     readln (infile, choice);   
UNTIL choice <> '';  
     
UpperCase (choice);  
     
WHILE choice[1] <> 'E' DO  
    BEGIN     CASE choice[1] OF{ Make the choice }   	   'C'   : Config; 	 	   'A'   : Locals; 	        'T'   : LIInfo (info.buffer);     'M'   : MAInfo (info.buffer);     'N'   : NRInfo (Info.buffer);     'R'   : RRInfo (Info.buffer);     'S'   : RSInfo (info.buffer);     'V'   : VAInfo (info.buffer);         'I'   : IOInf (info);     'L'   : LUInf (info);     'B'   : MMgr;  	   'U'   : Utils;  	 	   'P'   : Sktinf; 	        Otherwise        BEGIN         menu;         END;      	   END;  { case }  	        writeln (outfile);      writeln (outfile);          REPEAT      Prompt (outfile, 'NSInf > ');     Readln (infile, choice);      UNTIL choice <> '';         UpperCase (choice);  	   END;  {while }  	     99:   END.  { NSInf }  