 $PASCAL '91790-1X235 REV.4010 <860317.1436>'  $DEBUG  $HEAP 0   $WIDTH 90   $HEAPPARMS OFF  $RANGE OFF  $RECURSIVE OFF  $STANDARD_LEVEL 'HP1000'      MODULE nrerr;       {-----------------------------------------------------------       (c) COPYRIGHT HEWLETT PACKARD COMPANY 1986. ALL RIGHTS    RESERVED. NO PART OF THIS PROGRAM MAY BE PHOTOCOPIED,   REPRODUCED OR TRANSLATED TO ANOTHER PROGRAM LANGUAGE WITHOUT    THE PRIOR WRITTEN CONSENT OF THE HEWLETT-PACKARD COMPANY.       ----------------------------------------------------------- }      {}  {   	{  NAME    : NRERR 	 {  SOURCE  : 91790-18235  	{  RELOC   : NONE  	 {  PGMR    : CLC  !{ ---------------------------------------------------------------- ! {  Modification History:  
{  After Release I:  
 !{  2/21/85  Included $RANGE OFF compiler directive, Submittal N337 ! {           SR# 033287  "{ -----------------------------------------------------------------  " {   {}      IMPORT     $SEARCH 'phtm/BODEC.REL'$ bodec;           EXPORT      $subtitle 'Error Codes',page$   &{-------------------------------------------------------------------------}  & &{                              Error Codes                                }  & &{-------------------------------------------------------------------------}  &     CONST         er_ds_not_initialized    = 6000; { DS not initialized }     er_state_changed         = 6001; { state of DSAM changed }     er_nreg_corrupt          = 6002; { nodal registry is corrupt }   "  er_lock_failed           = 6003; { attempt to lock tables failed } " $  er_not_superuser         = 6004; { Must be superuser to run program }  $ &  er_DSAM_not_set          = 6005; { Must run NSINIT to set up DSAM first }  & &  er_no_nreg_space         = 6006; { Insufficient nodal reg space for name}  &   er_NRegAdd               = 6007; { NRegAdd error }     er_IP_subf_r             = 6008; { IP subfield out of range }      er_report_2big           = 6009; { report is too long}  "  er_802_bad_fmt           = 6010; { bad format for IEEE802 address} "   er_name_fmt              = 6011; { bad name format}     er_proto_ID              = 6012; { unknown protocol ID}      er_no_ip                 = 6013; { IP required but not given }      er_IP_bad_fmt            = 6014; { bad format for IP address }     er_no_IPaddr             = 6015; { Missing IP address}  $  er_exp_pid_or_beg_or_end = 6016; { expected protocol ID, Begin or End} $   er_exp_beg_or_end        = 6017; { expected begin or end}     er_path_incompl          = 6018; { path incomplete}     er_missing_begin         = 6019; { Missing begin}   !  er_name_subf_2big        = 6020; { subfield in name > 16 chars}  ! &  er_bad_IP_Sep            = 6021; { IP subfields not separated by periods.} & &  er_not_4_subf            = 6022; { IP address does not have 4 subfields }  &   er_X25_addr_2big         = 6023; { X25 address is too long }  $  er_X25_badc              = 6024; { illegal character in X25 address }  $   er_sap_len               = 6025; { bad sap length }     er_sap_badc              = 6026; { bad character in sap }   &  er_cont_state            = 6027; { cont'd state error till begin received} & "  er_int_ovf               = 6028; { overflow in integer conversion} " &  er_diff_name             = 6029; { more than one env name in same entry }  & %  er_net_zero              = 6030; { zero valued network number illegal }  % $  er_node_zero             = 6031; { zero valued node address illegal }  $ $  er_reserved_class        = 6032; { address is in the reserved class }  $ #  er_ieee802_id            = 6033; { only IEEE802 id is allowed here } # "  er_int_dsam              = 6034; { internal DSAM error reported }  " %  er_entry_559             = 6035; { total entry length exceeds max size } % %  er_env_50                = 6036; { node name length larger than max sz } %   er_version_unknown       = 6037; { version/domain unknown. }    er_ill_subf_syntax       = 6038; { illegal subfield syntax }    er_invalid_name          = 6039; { invalid file name }  #  er_prog_size             = 6040; { program size not large enough to  #                                      check for duplicates }     er_no_default_IP         = 6041; { no default IP address }  #  er_illegal_env_syntax    = 6042; { illegal environment name syntax } #   er_integer_expected      = 6043; { integer value expected }      er_num_not_positive      = 6044; { number should be positive }      er_not_1_to_255          = 6045; { number should be 1 to 255 }     er_dup_IP_address        = 6046; { duplicate address }    er_illegal_ieee802_add   = 6047; { illegal ieee802 address }    er_NRegFind              = 6048; { NRegFind error }     er_dup_node_name         = 6049; { Duplicate node name }        er_fatal_43              = 43;   { fatal error}     er_fatal_45              = 44;   { fatal error}     er_fatal_55              = 45;   { fatal error}           "{------------------------------------------------------------------} " "{                          Describe_error                          } " "{------------------------------------------------------------------} "      PROCEDURE Describe_error (VAR outf:text; err, errnum : Int16 );        IMPLEMENT       %{------------------------------------------------------------------------} % %{                              Describe_error                            } % %{------------------------------------------------------------------------} % %{ This routine returns an ASCII string which describes the error.        } %     PROCEDURE Describe_error { (err, errnum : Int16) } ;  BEGIN          write (outf,'** (',err:4,') NRERR: ');      CASE err OF        er_ds_not_initialized :              write(outf,'DS not initialized ');         er_state_changed :             write(outf,'State of DSAM changed');         er_nreg_corrupt :              write(outf,'Nodal Registry is corrupt');         er_lock_failed :             write(outf,'Attempt to lock tables failed');         er_not_superuser :             write(outf,'You must be a superuser');         er_DSAM_not_set :   !           write(outf,'You must run NSINIT to set up DSAM first'); !       er_no_nreg_space :  "           write(outf,'Insufficient Nodal Registry space for name'); " 	      er_NRegAdd : 	            write(outf,'NRegAdd error ',errnum:4);   
      er_IP_subf_r : 
            write(outf,'IP subfield not in range 0..255');         er_report_2big :             write(outf,'Path report is too long');         er_X25_addr_2big :             write(outf,'X.25 address is too long');  
      er_X25_badc :  
            write(outf,'Illegal character in X.25 address');         er_802_bad_fmt :             write(outf,'Incorrect format for IEEE802 address');        er_no_ip :             write(outf,'IP is required but was not supplied');   
      er_name_fmt :  
            write(outf,'Illegal environment name format');   	      er_sap_len : 	            write(outf,'SAP length is too big');   
      er_sap_badc :  
            write(outf,'Illegal character in SAP');  
      er_proto_id :  
            write(outf,'Unknown protocol ID');   
      er_no_IPaddr : 
            write(outf,'IP address is missing');         er_ip_bad_fmt :              write(outf,'Illegal format for IP address');         er_exp_pid_or_beg_or_end :             write(outf,'Expected protocol ID, BEGIN, or END');   
      er_exp_beg_or_end :  
            write(outf,'Expected BEGIN or END');         er_path_incompl :              write(outf,'Last path not complete');        er_missing_begin :             write(outf,'Missing Begin');         er_name_subf_2big:  $           write(outf,'Subfield in name is greater than 16 characters'); $       er_bad_IP_Sep :               write(outf,'IP subfields not separated by periods');          er_cont_state :   %           write(outf,'Continued state error until a BEGIN encountered');  % 	      er_int_ovf : 	            write(outf,'Overflow in integer conversion');  
      er_diff_name : 
 #           write(outf,'Conflicting environment names in same record'); # 
      er_net_zero :  
            write(outf,'Zero-valued network number illegal');  
      er_node_zero : 
            write(outf,'Zero-valued node address illegal');  
      er_reserved_class :  
            write(outf,'Address is in the reserved class');        er_not_4_subf :              write(outf,'IP address does not have 4 subfields');        er_ieee802_id :   !           write(outf,'Only IEEE802 protocol id is allowed here'); ! 
      er_entry_559 : 
 !           write(outf,'Total entry length exceeds maximum size');  ! 	      er_env_50 :  	 "           write(outf,'Node name length larger than maximum size');  " 
      er_version_unknown : 
 !           write(outf,'Version/domain unknown. Skipping record');  ! 
      er_ill_subf_syntax : 
            write(outf,'Illegal subfield syntax');         er_invalid_name :              write(outf,'Invalid file name');   
      er_prog_size : 
 &        write(outf,'Program size not large enough to check for duplicates'); &       er_no_default_IP :             write(outf,'No default IP address available');         er_illegal_env_syntax :              write(outf,'Illegal environment name syntax');         er_integer_expected :              write(outf,'Integer value expected');        er_num_not_positive :              write(outf,'Number should be positive');         er_not_1_to_255 :   #           write(outf,'Number should be between 1 to 255 inclusive');  # 
      er_dup_IP_address :  
            write(outf,'Duplicate IP address');        er_dup_node_name :             write(outf,'Duplicate node name');   
      er_NRegFind :  
            write(outf,'NRegFind error');  
      er_fatal_43 :  
            write(outf,'Fatal error 43');  
      er_fatal_45 :  
            write(outf,'Fatal error 45');     OTHERWISE         END; {CASE on error number}         writeln(outf,' **');       END; {Describe_error}       END. { module nrerr }  