 $PASCAL '91790-1X131 REV.4010 <860813.1758> '   $STANDARD_LEVEL 'HP1000'  $DEBUG$   $WIDTH 90   $HEAPPARMS OFF  $RECURSIVE OFF  $RANGE OFF  $HEAP 0   	$HEAP_DISPOSE OFF  	     MODULE NftInit;   	$ALIAS 'n$NftInit' 	         {------------------------------------------------------------    (c) COPYRIGHT HEWLETT PACKARD COMPANY 1986. ALL RIGHTS    RESERVED. NO PART OF THIS PROGRAM MAY BE PHOTOCOPIED,   REPRODUCED OR TRANSLATED TO ANOTHER PROGRAM LANGUAGE WITHOUT    THE PRIOR WRITTEN CONSENT OF THE HEWLETT-PACKARD COMPANY.   ------------------------------------------------------------}  {}  {     NAME:   NFTINIT   
{     SOURCE: 91790-18131  
 	{     RELOC:  NONE 	 	{     PGMR:   TDS  	 {}      {}  {   {  This module contains the  NFT initialization routines  {  for NSINIT.  {   {}  {------------------------------------------------------------}  {  MODIFICATIONS  {   {     Date     Pgmr        Description  #{     850426   lms         moved nft_buffer_size byte/word conversion  # {   {------------------------------------------------------------}      $SUBTITLE 'Import section', PAGE$   #{-------------------------------------------------------------------}  # #{                            IMPORT SECTION                         }  # #{-------------------------------------------------------------------}  #     IMPORT     $SEARCH 'phtm/BODEC.REL'      bodec,      $SEARCH 'phtm/MMDEC.REL'      mmdec,      $SEARCH 'phtm/MMEXT.REL'      ds_mm,      $SEARCH 'phtm/init_dec.rel'     init_dec,     $ SEARCH 'phtm/initmulti.xpt'     initmulti,      $ SEARCH 'phtm/filemad.xpt'     fileman,      $ SEARCH 'phtm/parsdd.xpt'      parser,  
   $SEARCH 'phtm/dres.xpt' 
    dres,     $SEARCH 'phtm/init_rte_if.xpt'      init_rte_if;       $SUBTITLE 'Export section', PAGE$   #{-------------------------------------------------------------------}  # #{                            EXPORT SECTION                         }  # #{-------------------------------------------------------------------}  #     EXPORT      PROCEDURE SynNFT     (VAR smbsize     : Int16;      VAR dsamtbsize  : Int16;      VAR socketcnt   : Int16;      VAR classcnt    : Int16;      VAR rsncnt      : Int16;      VAR result      : Int16);       	PROCEDURE ShutNFT  	    (    trustvar    : TrustType;      VAR result      : Int16);       	PROCEDURE InitNFT  	    (VAR result      : Int16);           $SUBTITLE 'Implement section', PAGE$  #{--------------------------------------------------------------------} # #{                          IMPLEMENT SECTION                         } # #{--------------------------------------------------------------------} #     IMPLEMENT       CONST      CHECKSUM_FLAG_ON     = -32768;      NFT_DEF_BUFF_BYTES   = 2048;      NFT_MAX_BUFF_BYTES   = 4096;      NFT_MIN_BUFF_BYTES   = 700;     NFT_MONITOR_NAME     = 'NFTMN ';      ELEMENT_SIZE_WORDS   = 37;       TYPE     NftBannerMsgs = ARRAY [1..8] OF IStringType;       CONST      NFT_BANNER = NftBannerMsgs[     IStringType[         '* Do you want Network File Transfer (NFT) [(Y)/N]?_' ],     IStringType[          '*++  Network File Transfer (NFT) ++*'],      IStringType[          '*   Default Buffer Size:      2048 Bytes'],      IStringType[          '*   Transport Checksum Used:  No'],      IStringType[          '*'],     IStringType[          '* Do you want to modify these values [Y/(N)]?_'],      IStringType[   $       '* Enter the default buffer size in bytes [700..(2048)..4096]_'], $    IStringType[   "       '* Should NFT always use transport checksumming [Y/(N)]?_' ]  "       ];      VAR      nft_buffer_size   : Int16;      nft_checksum_flag : Int16;      schedule_monitor  : BOOLEAN;           $SUBTITLE 'Initialize NFT stuff', PAGE$   #{-------------------------------------------------------------------}  # #{                             INIT NFT                              }  # #{-------------------------------------------------------------------}  #     	PROCEDURE InitNFT  	    (VAR result      : Int16);       LABEL      99;      VAR   
   result1  : Int16; 
 
   wkmap:     Int16; 
     	BEGIN { InitNFT }  	        DS_InitEnterCritical( wkmap, result );      IF result <> GOOD THEN GOTO 99;         DS_StoreGlobal (NFT_BUFF_SIZE, 1, nft_buffer_size);     DS_StoreGlobal (NFT_CHECKSUM,  1, nft_checksum_flag);         DS_InitLeaveCritical( wkmap );          IF schedule_monitor THEN         BEGIN         ErrorMsgsToDsam (result);             IF result = 0 THEN           BEGIN            DS_StartMonitor (NFT_MONITOR_NAME, 0, TRUE, result1 );                 { Complain if we could not schedule the monitor, but               don't pass the error back to the caller, it is not              an error that should make us abort initialization,  $            since the customer can always XQ NFTMN at his/her leisure. } $     &         { If the error is NOTDORMANT this is a catastrophic error. Abort }  &          IF result1 = NOTDORMANT THEN GOTO 99;           IF result1 <> 0 THEN               BEGIN    { error scheduling }               PrintError (NO_REQ_MONMSG, result1);              IF result1 <> GOOD THEN                  { If error printing we're in big trouble }                  result := result1;               END;           END;  { IF result }  	      END;  { IF } 	     99:       	END;  { InitNFT }  	         $SUBTITLE 'NFT Syntax Check routine',PAGE$  #{--------------------------------------------------------------------} # #{                              SYN NFT                               } # #{--------------------------------------------------------------------} #     PROCEDURE SynNFT     (VAR smbsize     : Int16;      VAR dsamtbsize  : Int16;      VAR socketcnt   : Int16;      VAR classcnt    : Int16;      VAR rsncnt      : Int16;      VAR result      : Int16);       LABEL      99;   { Labels end of the procedure }      VAR   
   total_errors   : Int16; 
    yes_or_no      : OneCharType;     default:         Boolean;     terminator:      Boolean;  
   loop:            Int16; 
    input_string:    IStringType;      BEGIN { SynNFT }          { Set the DSAM global values in case user does not want NFT }   
   nft_buffer_size   := 0; 
 
   nft_checksum_flag := 0; 
        schedule_monitor  := FALSE;         { Ask if user wants NFT }  
   default := TRUE;  
    YesNoInput (NFT_BANNER [1], default, yes_or_no, result);          { If an error occurs then we expect yes_or_no to be 'E' }     IF default OR (yes_or_no = 'Y') THEN         BEGIN       #      { Count the total number of error message strings in the file }  #       CountErrorMsgs (total_errors);        dsamtbsize  := total_errors * ELEMENT_SIZE_WORDS;             { User wants NFT }        schedule_monitor := TRUE;   !      nft_buffer_size  := NFT_DEF_BUFF_BYTES;   { Set to default } !           { tell caller one RN will be required for NFTMN }   	      rsncnt := 1; 	     #      { Increment some global resource counters since NFT is desired } # 
      WITH initglobals DO  
          BEGIN  "         { The increment on the total sockets is totally arbitrary } "          IG_tot_nodal_sockets := IG_tot_nodal_sockets + 9;           IG_tot_nodal_progs   := IG_tot_nodal_progs   + 1;           END;             { Prompt user with current defaults }         FOR loop := 2 TO 5 DO            BEGIN           PrintPrompt (FALSE, NFT_BANNER [loop], result);           IF result <> 0 THEN  
            GOTO 99; 
          END;  { FOR }            { Ask if defaults should be changed }         default := TRUE;        YesNoInput (NFT_BANNER [6], default, yes_or_no, result);            { If an error occurs we expect yes_or_no to be 'E' }        IF yes_or_no = 'Y' THEN            BEGIN            { User wants to change defaults. First is buffer size }            default    := TRUE;           terminator := FALSE;   &         IntInput (NFT_BANNER [7], default, terminator, NFT_MAX_BUFF_BYTES,  &                     NFT_MIN_BUFF_BYTES, nft_buffer_size, result);                IF result = 0 THEN   	            BEGIN  	             { Now prompt for checksum choice }              default    := TRUE;               terminator := FALSE;  !            CharInput (NFT_BANNER [8], TRUE, default, terminator,  !                        input_string, result);                   { If user wants checksumming then set the flag }              IF (result = GOOD) THEN                  BEGIN    { fix checksum }  #               { If default then turn off, but this was set earlier }  #                IF (input_string [1] = 'Y') THEN                     nft_checksum_flag := CHECKSUM_FLAG_ON;                 END;     { fix checksum }              END;  { IF result }            END;  { IF default }   
      END;  { IF default } 
        { Convert buffer size from bytes to words. NFT code wants }     { the buffer size in words.  Do this always.              }     nft_buffer_size := nft_buffer_size DIV 2;      99:   END;  { SynNFT }          $SUBTITLE 'NFT Shutdown module', PAGE$  #{-------------------------------------------------------------------}  # #{                             SHUT NFT                              }  # #{-------------------------------------------------------------------}  #     	PROCEDURE ShutNFT  	    (    trustvar    : TrustType;      VAR result      : Int16);       	BEGIN { ShutNFT }  	        result := 0;          DS_StopMonitor (NFT_MONITOR_NAME, result);      result := 0;       	END;  { ShutNFT }  	         END.  { END of MODULE NftInit }  