 $PASCAL ' 91790-1X128 REV.4010 <860226.1546>'   $ TITLE 'MultiUser Initializer' $   $ RECURSIVE OFF, RANGE OFF $  $ HEAP 0  	$ HEAP_DISPOSE OFF 	 $ HEAPPARMS OFF   $ DEBUG       MODULE muinit;  	$ALIAS 'n$muinit'  	     {------------------------------------------------------------        (c) COPYRIGHT HEWLETT PACKARD COMPANY 1986. ALL RIGHTS    RESERVED. NO PART OF THIS PROGRAM MAY BE PHOTOCOPIED,   REPRODUCED OR TRANSLATED TO ANOTHER PROGRAM LANGUAGE WITHOUT    THE PRIOR WRITTEN CONSENT OF THE HEWLETT-PACKARD COMPANY.       ------------------------------------------------------------}      {}  
{      NAME: muinit  
 {    SOURCE: 91790-18128  	{     RELOC: NONE  	 {      PGMR: jar  {}      {}  {------------------------------------------------------------   { MODIFICATIONS:  {   {  Date   PCO  Prgmr Description  {  850208      jar   Implement "import from .rels"  {  850308      lms   add some error handling, prepare for   {                     dsinit integration.   #{  860115      EW    Call Ds_Rsm_InitLogoff rather than Ds_Rsm_logoff. # #{  860115      EW    Change logoff at shutdown: make it in-line code.  # #{  860224      lms   Correct Error handling at shutdown, init (n356).  # {  Last edit: <860226.1546>   {   {------------------------------------------------------------   {}      {}  { PROGRAM DESCRIPTION:  {   {  Starts the MultiUser system.   {}             IMPORT                           $SEARCH 'phtm/BODEC.REL'         bodec,   {  General-purpose declarations                 }                           $SEARCH 'phtm/MMDEC.REL'         mmdec,   {  Memory-Manager declarations                  }                           $SEARCH 'phtm/MMEXT.REL'         ds_mm,   {  The Memory Manager                           }                           $SEARCH 'phtm/init_dec.rel'          init_dec,{  Initialization declarations                  }                           $ SEARCH 'phtm/dres.xpt'        dres,                           $ SEARCH 'phtm/initmulti.xpt'         initmulti,                          $ SEARCH 'phtm/parsdd.xpt'         parser,  {  Parsing routines                             }                           $ SEARCH 'phtm/filemad.xpt'          fileman; {  File Manipulation routines                   }                  EXPORT             PROCEDURE SynMu            (  VAR   smbsize     : Int16;              VAR   dsamsize    : Int16;              VAR   socketcnt   : Int16;              VAR   classcnt    : Int16;              VAR   resourcecnt : Int16;              VAR   result      : Int16 );            PROCEDURE InitMu           (  VAR   ierr  :  Int16 );             PROCEDURE ShutMu           (        trustvar :  TrustType;              VAR   result   :  Int16 );             IMPLEMENT            CONST             SESENTSIZE  =  4; {  Size of one DS_RSM_Sessions_TD   }                               {  entry.                           }                 TYPE           FiveInts =  ARRAY [1..5] OF Int16;                SessionEntryType = RECORD CASE INTEGER OF              0: (  bt:   Int16 );              1: (  sid:  Int16;                    rnd:  Int16;                    auth: Int16;                    time: Int16 );           END;  {  SessionEntryType }                CONST            EMPTYSESSIONENTRY = SessionEntryType               [  sid:  0,                  rnd:  0,                  auth: 0,   
               time: 0 ];  
           VAR            maxses      :  Int16;      
      FUNCTION Ixor  
          (  int1  :  Int16;               int2  :  Int16) : Int16;  	         EXTERNAL; 	     
      FUNCTION LocalLogoff 
          (  sid   : int16) : Int16;   	         EXTERNAL; 	     
$ SUBTITLE 'SynMu', PAGE $ 
       PROCEDURE SynMu            (  VAR   smbsize     : Int16;              VAR   dsamsize    : Int16;              VAR   socketcnt   : Int16;              VAR   classcnt    : Int16;              VAR   resourcecnt : Int16;              VAR   result      : Int16 );      
      BEGIN {  SynMu    }  
           maxses   := DS_GetDollarUIDLb;            { For first release double the count that should be used  !      to get around a problem with NFT and multiple logons.  Once  !       the enhancement is made to Multi-user to reference count        sessions the table can be the same size as the number of  "      sessions in the system.                                     }  "           maxses := maxses * 2;       %      dsamsize := maxses * SESENTSIZE  { Space for DS_RSM_Sessions table } % '         +  1;                            { Space for DS_RSM_Seed table     }  '     
      END;  {  SynMu    }  
     $ SUBTITLE 'InitMu', PAGE $         PROCEDURE InitMu           (  VAR   ierr  :  Int16 );          LABEL        99;             VAR            i     :  Int16;           wkmp  :  Int16;           time  :  FiveInts;            entry :  SessionEntryType;       
      BEGIN {  InitMu   }  
           {}        {  Set up session table.        {}        DS_InitEnterCritical ( wkmp, ierr );        IF ierr <> 0 THEN GOTO 99;      &      DS_GetTableSpace ( DS_RSM_Sessions_TD, 1, maxses, SESENTSIZE, ierr );  &     
      IF ( ierr = 0 ) THEN 
           BEGIN {  GetTableSpace worked                         }                entry := EMPTYSESSIONENTRY;               FOR i := 1 to MAXSES DO  "            BEGIN {  Stomp a blank entry onto each entry          }  "              DS_StoreElement ( DS_RSM_Sessions_TD, i, entry.bt );   "            END;  {  Stomp a blank entry onto each entry          }  "              DS_GetTableSpace ( DS_RSM_Seed_TD, 1, 1, 1, ierr  );                 END;  {  GetTableSpace worked                         }             DS_InitLeaveCritical ( wkmp );      99:          { Note that ierr from the MMGR is bubbled back to caller }       
      END;  {  InitMu   }  
     $ SUBTITLE 'ShutMu', PAGE $         PROCEDURE ShutMu           (        trustvar :  TrustType;              VAR   result   :  Int16 );  %{-----------------------------------------------------------------------}  % %{ This procedure will attempt to logoff any sessions which were         }  % %{ created by the NS/1000 software. It will first check the environment  }  % %{ to be sure we can trust our tables. Then it will check each entry     }  % %{ in the session table in DSAM. If any entry is marked as created by    }  % %{ NS (word 4 <= 0) we will call the RTE routine locallogoff to log the  }  % %{ session off. Before call this routine we will do at least a little    }  % %{ check to make sure the session key is valid.                          }  % %{-----------------------------------------------------------------------}  %       LABEL            99;      { for early escape from loop }            VAR            error    :  Int16;            error1   :  Int16;            keynum   :  Int16;            wkmp     :  Int16;            entry    :  SessionEntryType;           td       :  TableDescriptorType;           PROCEDURE Exit  (     exitparm  :   Int16 );  
   BEGIN    { Exit } 
    result := exitparm;     GOTO 99;   
   END;     { Exit } 
     $ PAGE $      
      BEGIN {  ShutMu   }  
       { initialize our variables }  	      result := 0; 	 	      error  := 0; 	           IF ( trustvar = TRUST ) THEN           BEGIN { Can believe our tables }                DS_InitEnterCritical ( wkmp, result );            IF result <> 0 THEN Exit( CANT_ENTER_CRIT );       "         DS_FetchTableDescriptor ( DS_RSM_Sessions_TD, td, result ); "          IF result <> 0 THEN              BEGIN    { No multi-user table }              { print warning, but don't abort shutdown }               DS_InitLeaveCritical ( wkmp );              MsgFilePrint( NO_MU_TABLE, PMT_ERROR, 0, result );              Exit( 0 );              END;     { No multi-user table }      
         WITH td DO  
             BEGIN {  WITH td DO  }                  IF ( TD_WordsPerElement <> 0 ) THEN                  BEGIN { Still can believe our tables }                      FOR keynum := 1 TO TD_MaxElement DO                    BEGIN { Shoot each session }                         DS_FetchElement ( DS_RSM_Sessions_TD, keynum,                         entry.bt );                        IF ( entry.time <= 0 ) THEN                        BEGIN { Log this one off }                        { If the 4th word in the entry is <= 0 }                        { we may assume we created this entry. }                        { Before we call local logoff, however,}                        { we will do a little more checking on }                        { this key.                            }   "                     IF (entry.auth = Ixor (32677, Ixor (entry.sid,  "                            entry.rnd))) THEN                          BEGIN { key o.k. }                          DS_InitLeaveCritical ( wkmp );                              error1 := locallogoff ( entry.sid );                              DS_InitEnterCritical ( wkmp, error );   "                        IF error <> 0 THEN Exit( CANT_ENTER_CRIT );  "                         END;  { key o.k. }                       END;  { log this one off }                     END;  { Shoot each session }                 END;  { Still can believe our tables }               END;  { WITH td DO }               DS_InitLeaveCritical ( wkmp );                END;  {  Can believe our tables }  99:       
      END;  {  ShutMu   }  
 
END.  {  muinit   }  
