 $PASCAL '91790-1X110 REV.4010 <851122.1300>'$   $STANDARD_LEVEL 'HP1000'  $debug$   $WIDTH 90   $HEAPPARMS OFF  
$RECURSIVE OFF, RANGE OFF$ 
 $HEAP 0   	$HEAP_DISPOSE OFF  	     MODULE lk;  $ALIAS 'n$lk'$      {------------------------------------------------------------    (c) COPYRIGHT HEWLETT PACKARD COMPANY 1986. ALL RIGHTS    RESERVED. NO PART OF THIS PROGRAM MAY BE PHOTOCOPIED,   REPRODUCED OR TRANSLATED TO ANOTHER PROGRAM LANGUAGE WITHOUT    THE PRIOR WRITTEN CONSENT OF THE HEWLETT-PACKARD COMPANY.   ------------------------------------------------------------}  {   {}  {       NAME: LKLB.PAS                               }  {     SOURCE: 91790-18110                            }  {      RELOC: NONE                                   }  {       PGMR: MCL                                    }  {}      { MODIFICATIONS:  {  5/30/85  ash   Remove Ieee802Init and IEEE802AddElement.   {                 Add GetIP, a routine which parses VNA record  {                 and returns the IP address.   {   !{  6/25/85  cww   Replace constants  ROUTER and GATEWAY line with  ! !{                 more mnemonic names: RTR_LINKTYPE, GG_LINKTYPE,  ! {                 and LAN802_LINKTYPE.  {   {  4/2/86   ash   Remove LILogError.  {}      IMPORT     $SEARCH 'phtm/BODEC.REL'      bodec,      $SEARCH 'phtm/SODEC.REL'      sodec,      $SEARCH 'phtm/MMDEC.REL'      mmdec,      $SEARCH 'phtm/MMEXT.REL'      ds_mm,      $SEARCH 'phtm/TRCMOD.REL'     trcmod;  {}  {  $search 'phtm/tmrdec.rel, phtm/ipdec.rel'  {  ipdec,   $WIDTH 150$   4{  $search 'phtm/trglb.rel,phtm/sigmod.rel,phtm/iplib.rel,phtm/tmrdec.rel,phtm/tuser.rel,phtm/ipdb.rel'$ 4 $WIDTH 80   {  iplib;   {}      !{----------------------------------------------------------------} ! !{                                                                } ! !{   EXPORT DECLARATIONS                                          } ! !{                                                                } ! !{----------------------------------------------------------------} !     EXPORT      TYPE         NIOptType      = ARRAY [1..3] OF Int16;     NIFlagsType    = PACKED ARRAY [-15 .. 0] OF BOOLEAN;          {LineType       = PACKED ARRAY [1..22] OF CHAR;}       {}  {  GGPathType   {   up_pid    : up_protocol id  {   address   : ulp's addresss field for searching  {   lu        : logical unit of the link  {   link_type : type of link ie, x.25, lapb or bisync   {   options   : user options [0] means open now; [-1] = true  {               means the link interface is of DTE type else  {               it is of DCE type.  {   flags     : control flags ie, status and reply  {               bit[0] = true if link is up and bit [-1] is   {               true if waiting for reply.  {               bit[-15] is the trigger enabled flag.   {   timer_id  : timer id {not used for the time being}  {   up_ref    : ulp's path reference  {}     GGPathType = RECORD        CASE boolean OF         false: (int : Int16);         true : (up_pid    : Int16;                address   : Int32;                lu        : Int16;                link_type : Int16;                options   : NIFlagsType;                flags     : NIFlagsType;                timer_id  : Int32;                up_ref    : Int16 );        END;      {}  {  ApndgeBufType  {   Use to receive the appendage words of the message   {   {   so_id      : socket ID of the message   {   seq        : sequence number of the message   {   ni_type    : network interface id   {   link_lu    : logical unit of the link   {}  
   ApndgeBufType = RECORD  
       so_id    : Int16;         seq      : Int16;         ni_type  : Int16;         link_lu  : Int16;         END;      {}  
{  RouterHeaderType  
 {}     FakeRRHeaderType = RECORD        CASE BOOLEAN OF            FALSE : (int    : int16);           TRUE  : (hdr    : ARRAY[1..13] OF Int16;                     rh_lap : ApndgeBufType);           END;          AppendageBuffer = RECORD   
      CASE INT16 OF  
          1 : (bufr : Int16);           2 : (rr_hdr : FakeRRHeaderType);            3 : (lan_gg : ApndgeBufType);           END;       {}  { GGLuListType  {  ulp_pid    : Upper level protocol id   {  gg_addr    : Ip type of address  {  link_lu    : Link interface logical Unit.  {  Link_type  : type of data link protocol  {  options    : option flags [0] = open now; [-1] DTE etc.  {}      
GGLuRecType = RECORD 
 	  CASE boolean OF  	   false: (int:  Int16);     true:  (       ulp_pid    : Int16;       gg_addr    : Int32;       link_lu    : Int16;       link_type  : Int16;       options    : NIFlagsType);     END;          {Buffer to hold event logging info}   
EvInfoType = RECORD  
 	  CASE boolean OF  	   false: (int:  Int16);     true:  (       err_code   : Int16;       emsg       : EventMsgType);    END;          {List of gateway lines to be initialized; for the time being}   {we will use an array of 20 elements .                      }   GGLuListType = ARRAY[1..20] OF GGLuRecType;       {DVT word 6}  StatusWordType = PACKED RECORD  
   b15    : Boolean; 
 
   b14    : Boolean; 
 	   dvtype : Int6;  	 	   pad    : Int8;  	    END;           {Control words for XLUEX Calls}   ControlWordType = Array [1..2] OF Int16;                  {----------------------------------------------------------}  {  Constants                                               }  {----------------------------------------------------------}      CONST      { Link type constants. These are the constants that appear      { in z-buffer delivered up by the various link drivers used     { in the NS product.      {}   
   GG_LINKTYPE       = 2;  
 
   RTR_LINKTYPE      = 0;  
 
   LAN802_LINKTYPE   = 7;  
     CONST      CONN_INDICATE       = CONNECT_INDICATION;     DATA_INDICATE       = DATA_INDICATION;      IPINBOUNDIDX        = IP * EHS_PER + EHIB_OFFSET;     GGLOOPBACK          = 77;         EXEC3               = -32765; {Control + No abort bit}      SCH10               = -32758; {Exec 10 + No Abort bit}      TIMESCH             = -32756; {Exec 12 time scheduling}     SECONDS             = 2;      {Should be changed to msec}         {Lengths and sizes}     EVMSG_LEN           = 21;     APNDGE_LEN          = 4;      SIZEOFGGPATH        = 10;         {Link Types}      GLT_LOOPBACK        = 77;     GLT_HDLC            = 1;      GLT_X25             = 2;      GLT_LAPB            = 3;          GG                  = GG_PID;         NOOPTS              = NIOptType [0,0,0];              {Configuration Items}         MAXGGENTRY          = 10; {for testing only}      MEMGINBDSB          =  4;         {Event Logging Locations}     GG_OB               =  1; {In Main Procedure GGOB}      GG_OB_EXEC          =  2; {In Send Request Handling GGOB}     GG_IB               =  3; {In Main Procedure GGIB}       GG_IB_DATA          =  4; {In Data Indication Handling GGIB}       GG_SEARCH           =  5; {In routine GGSEARCH}         {Error Codes}     GGEB                =  13000; {GG error base}     GGNOPATH            =  GGEB+1;   {can find a path}      GGLINKDOWN          =  GGEB+2;   {path is down   }      GGNOSAM             =  GGEB+3;   {cannot get SAM }      GGBADREFERENCE      =  GGEB+4;   {bad path reference}     GGBADPATHREC        =  GGEB+5;   {path record is bad}      GGBADMSGTYPE        =  GGEB+6;   {unknown event message type}   !   GGBADLITYPE         =  GGEB+7;   {unknown Link Interface Type}  !     GGBADEXECCALL       =  GGEB+8;   {cannot do time scheduling}    #   GGREQUEUEFAILED     =  GGEB+9;   {cannot requeue request to driver} # "   GGDSAMERROR         =  GGEB+10;  {error returned on DSAM access}  " "   GGSEVERERROR        =  GGEB+11;  {invalid outbound class number}  "     &   { Generic link error codes to be imported by all link interface modules } &     #   LI_EXEC_CALL_ERR        = 30;{General exec call errors.           } # #   LI_PATH_RECORD_INVALID  = 31;{The path record is bad.             } # #   LI_PATH_REF_INVALID     = 32;{There is no path for this ref.      } # #   LI_LINK_DOWN            = 33;{Link lu is down.                    } # #   LI_PATH_NONEXISTANT     = 34;{ No path having specified field.    } # #   LI_EVENT_MSG_INVALID    = 35;{Event msg. not supported.           } # #   LI_HEADER_INVALID       = 36;{Header invalid                      } #     #   LI_SEND_DSAM_ERR        = 50;{DSAM error in send routine.         } # #   LI_SEND_REQUEUE_ERR     = 51;{Requeue err in send routine.        } # #   LI_SEND_NO_SAM          = 52;{No sam on send routine.             } # #   LI_SEND_INVALID_CLASSNO = 53;{Bad class number on send routine.   } #     #   LI_RECV_DSAM_ERR        = 60;{Receive routine general dsam error. } # #   LI_RECV_NO_DSAM         = 61;{Receive routine can't allocate DSAM.} #     {----------------------------------------------}  {     Exported Procedures                      }  {----------------------------------------------}      FUNCTION GetIP     (VAR VNA          : VNARecord;       VAR ierr         : Int16)                        : Int32;       PROCEDURE GatewaySearch      (VAR vna        : VNARecord;           ulp        : Int16;       VAR down_ref   : Int16;       VAR ierr       : Int16);      PROCEDURE LISend     (    mbuf_ptr     : Int16;           snd_len      : Int16;       VAR apndge_buf   : AppendageBuffer;           apn_len      : Int16;       VAR rtn_error    : Int16 );       PROCEDURE GGOB     (    e_msg      : EventMsgType;      VAR rtnerr     : Int16        );      PROCEDURE GGIB     (    e_msg      : EventMsgType;      VAR ierr       : Int16        );      PROCEDURE X25AddElement      ( VAR sp        : Int16;        VAR stack     : TemplateControlStack;       VAR crec      : TemplateControlRecord;        VAR vnarec    : VNARecord;        VAR pathstart : Int16;        VAR rptr      : Int16;        VAR report    : PathReportRecord;       VAR dynamicptr: Int16;        VAR ierr      : Int16 );       PROCEDURE X25Init ( VAR ierr : Int16 );       !{----------------------------------------------------------------} ! !{                                                                } ! !{   IMPLEMENT DECLARATIONS                                       } ! !{                                                                } ! !{----------------------------------------------------------------} !     IMPLEMENT       {-----------------------------------------------------}   {                GLOBAL VARIABLES                     }   {-----------------------------------------------------}       VAR      gg_msg    : EventMsgType;  
   ggevinfo  : EvInfoType; 
    pathrefr  : ContextWords;  
   ggpath    : GGPathType; 
    ni_error  : Int16;      pr_ierr   : Int16;      gg_wkmap  : Int16;      icode     : Int16;      ipram     : Int16;      icnwd     : ControlWordType;      ifunc     : Int16;   
   iop1      : NIOptType;  
    areg      : Int16;      breg      : Int16;           {-------------------------------------------------}   {           External Procedures                   }   {-------------------------------------------------}       PROCEDURE GetSam                  $ALIAS 'D$GSM'$      (    class_num   : Int16;      VAR samaddr     : Int16;          data_len    : Int16;      VAR apndge_addr : Int16;          apn_len     : Int16;      VAR error       : Int16 );     EXTERNAL;          PROCEDURE ProSw     (VAR e_msg        : EventMsgType;      VAR error        : Int16            );     EXTERNAL;           	FUNCTION CTrigger  	    (    trigger_case   : Int16;       VAR data           : Int16) : Int16;     EXTERNAL;      FUNCTION LocalAddress             $ALIAS 'N$IPL.LOCALADDRESS'$     (   vna_address     : Int32) : Boolean;     EXTERNAL;          {}  {PROCEDURE Printline               $ALIAS 'REIO'$   
{   (    icode    : Int16; 
 
{        cnwd     : Int16; 
 {    VAR line_buf : LineType;   {        length   : Int16     );  {   EXTERNAL;   {}      PROCEDURE Release_Sam             $ALIAS 'D$RSM'$      ( VAR class       : Int16;        VAR error       : Int16);     EXTERNAL;          PROCEDURE Requeue_Req             $ALIAS 'REQUE'$      (VAR apndge_buf   : AppendageBuffer;           apn_len      : Int16;           li_type      : Int16;           line_lu      : Int16;           out_class    : Int16;           dst_class    : Int16;       VAR error        : Int16);     EXTERNAL;      PROCEDURE GetABRegisters      $ALIAS 'ABREG'$   
   (VAR  areg    : Int16;  
 
    VAR  breg    : Int16); 
    EXTERNAL;          PROCEDURE CheckStatus        $ALIAS 'XLUEX'$     $ NOABORT $     (icode    : Int16;       icnwd    : ControlWordType;       ipram    : Int16);     EXTERNAL;      PROCEDURE Get_Class           $ALIAS 'CLRQ'$     (    ifunc      : Int16;       VAR iclass     : Int16;           iop1       : NIOptType );      EXTERNAL;          {PROCEDURE GetGrpmClass        $ALIAS 'GTGRM'$     (VAR in_class   : Int16);     EXTERNAL;}           $Subtitle 'Exported Modules Section', PAGE$   {------------------------------------------------}  {Exported Modules                                }  {------------------------------------------------}      {------------------------------------------------}  {        FUNCTION GetIP   {------------------------------------------------}  FUNCTION GetIP     (VAR VNA    : VNARecord;       VAR ierr   : Int16)                  : Int32;       { Given a virtual network address, extracts the IP address }  {  in 32 bit format.                                       }      TYPE     IPAdType = RECORD Case INT16 of                1 : ( addr : Int32);                2 : ( arry : ARRAY [1..2] of Int16);  	              END; 	     VAR      IPAddr : IPAdType;       BEGIN       IF (VNA.bytes[0] = 0) AND (VNA.bytes[1] = HPDSN_DOMAIN) THEN          BEGIN         ierr := 0;        IPAddr.arry[1] := VNA.ints[1];        IPAddr.arry[2] := VNA.ints[2];        GetIP := IPAddr.addr;         END      ELSE         BEGIN { bad version or domain }         ierr := U_INTERNALERR;  	      GetIP := -1; 	       END;  { bad version or domain }   END;  { getIP }               $Subtitle 'Link Inf Send Routine', Page$  {------------------------------------------}  {             LISend()                     }  {------------------------------------------}      PROCEDURE LISend     {    mbuf_ptr     : Int16;           snd_len      : Int16;       VAR apndge_buf   : AppendageBuffer;           apn_len      : Int16;       VAR rtn_error    : Int16 };       {}  { Description:  {   Get SAM.  {   Move data from DSAM to SAM.   {   Requeue data to driver.   {   {   { Globals:   {   DS_OUTPROCLASS   : class number of outbound process in DSAM    {                      GLOBAL area.   {}      LABEL      77;      VAR   
   done        : BOOLEAN;  
    send_len    : Int16;      retry_cnt   : Int16;      offset      : Int16;      m_ptr       : Int16;      sam_ptr     : Int16;      link_refr   : Int16;      apndge_addr : Int16;      outbnd_cls  : Int16;      dest_cls    : Int16;      inbnd_cls   : Int16;      grpm_cls    : Int16;   
   tracing_class : Int16;  
    li_type     : Int16;      sb          : Int16;      seqno       : Int16;      error       : Int16;       {----------------------------------}  {         LIEscape                 }  {----------------------------------}      PROCEDURE LIEscape(err_code : Int16);       BEGIN {esc}   rtn_error  := err_code;   GOTO 77;  END;  {esc}       
PROCEDURE CheckExecError;  
     BEGIN {error}   GetABRegisters (areg, breg);  
{Report EXEC Call Failed } 
 Goto 77;  END;  {error}           	BEGIN {send data}  	 retry_cnt := 0;   rtn_error := 0;   
done      := false;  
     {Before we do anything let's get the inbound and the  }   {outbound class numbers.  If the class numbers are no }   {good tell the caller and return immediately.         }       {May want to move them to the main to aviod repetitive fetch}          DS_FetchGlobal(DS_Inpro_Class, 1, inbnd_cls);     DS_FetchGlobal(DS_Grpm_Class, 1, grpm_cls);     DS_FetchGlobal(DS_Outpro_Class, 1, outbnd_cls);      
   IF outbnd_cls = 0 THEN  
       BEGIN         LIEscape(LI_SEND_INVALID_CLASSNO);        END;      	WHILE NOT done DO  	    BEGIN {while}      !   { Initialize the link references and destination class number}  ! !   { If link type is RR, the destination class is GRPM's class  }  !        IF apn_len > APNDGE_LEN THEN         BEGIN         {For now we just use the INPRO for Dennis}        dest_cls   := grpm_cls;         link_refr  := apndge_buf.rr_hdr.rh_lap.link_lu;         li_type    := apndge_buf.rr_hdr.rh_lap.ni_type;         END      ELSE         BEGIN         dest_cls   := inbnd_cls;        link_refr  := apndge_buf.lan_gg.link_lu;        li_type    := apndge_buf.lan_gg.ni_type;        END;         {Before we try to get a piece of SAM, need to find out the}     {requet is from LAN. If that is the case, the snd_len must}     {be in negative number of bytes. Oh, we don't have to do  }     {that anymore because LAN will use a negative length...   }         {}      {IF li_type = LAN802 THEN     {   snd_len := -snd_len;      {}          {Get a piece of SAM buffer using the outbound class number}     GetSam (outbnd_cls, sam_ptr, snd_len,                apndge_addr, apn_len, rtn_error);          IF rtn_error = 0 THEN        BEGIN {had sam}         {Yes, we got a piece of SAM now; let's move the user}         {data from DSAM to SAM...                           }   
      IF snd_len < 0 THEN  
          snd_len := -snd_len;   	      offset := 0; 	     $      DS_IntoSAM (sam_ptr, snd_len, mbuf_ptr, offset, sb, seqno, error); $       IF error <> 0 THEN           BEGIN           Release_SAM(outbnd_cls, error);           LIEscape(LI_SEND_DSAM_ERR);           END;       !      {If tracing is on, get sequence #, socket id and build the}  ! !      {appendage for the tracer.                                }  !           DS_FetchGlobal(DS_LLTClass, 1, tracing_class);             IF (tracing_class <> 0) AND (li_type <> RTR_LINKTYPE) THEN            BEGIN           apndge_buf.lan_gg.so_id := sb;            apndge_buf.lan_gg.seq   := seqno;           END;             WITH apndge_buf DO           BEGIN           Requeue_Req (apndge_buf, apn_len, li_type, link_refr,              outbnd_cls, dest_cls, rtn_error);            END;             IF rtn_error <> 0 THEN           BEGIN  #         {Report the problem to the caller and return the SAM buffer}  #          rtn_error := LI_SEND_REQUEUE_ERR;           Release_Sam(outbnd_cls, error);           END;             {All done}  	      done:= true; 	 
      END  {had sam} 
    ELSE   
      BEGIN {nosam}  
       {No SAM is available try 2 more times; if}        {not successful we just have to give up. }        retry_cnt := retry_cnt + 1;             IF retry_cnt > 2 THEN            BEGIN           done := true ;            {return error to caller}            rtn_error := LI_SEND_NO_SAM;            END        ELSE           BEGIN           {We just give up and hope the ULP can recover}            END;   
      END;  {nosam}  
   END;  {while}   77:;      	END;  {send data}  	             $Subtitle 'Send Kill Indication', Page$   {--------------------------------------------}  {        SendKillInd                         }  {--------------------------------------------}  {}  { Description: Called by GG routines to send  {  a kill message to ULP. The routine reference   {  the LK module's global variable ggpath. And  
{  uses the global gg_msg. 
 {}      PROCEDURE SendKillInd   
   (killrefr:       Int16; 
     killerr :       Int16);       BEGIN {kill}  gg_msg.em_event := KILL_INDICATION;   gg_msg.ehport := ggpath.up_pid                      * EHS_PER + EHIB_OFFSET;  gg_msg.emki_down_ref := killrefr;   gg_msg.emki_down_pid := GG;   gg_msg.emki_reason   := killerr;      DS_LeaveCritical(gg_wkmap);   ProSw (gg_msg, pr_ierr);  DS_EnterCritical(gg_wkmap, ni_error);   END;  {kill}              $Subtitle 'Gateway Line Outbound', Page$  {--------------------------------------------------}  {                GGOB                              }  {--------------------------------------------------}      PROCEDURE GGOB     {    e_msg      : EventMsgType;      VAR rtnerr     : Int16        };      {}  { Description:   {    This is the gateway line network interface outbound routine   {    It performs the following functions:   {   {    1. Handle Send Request from ULP.   {    2. Handle Dpath request.   {    3. Handle Abort path request.  {    4. Handle Timer Indication.  {   {}      LABEL 444;      VAR   
   sendit      : Boolean;  
    lkstat      : MMFlagsType;      pptr        : Int16;      data_len    : Int16;      mbuf_ptr    : Int16;      go_error    : Int16;      class_num   : Int16;      dummy       : Int16;      samaddr     : Int16;      apndge_buf  : Appendagebuffer;           {--------------------------------------------}  {              Internal Procedures           }  {--------------------------------------------}      {----------------------------------}  {  CheckExecError                  }  {----------------------------------}      PROCEDURE CheckError;       BEGIN {error}   
{Report EXEC Call Failed } 
 go_error          := GGBADEXECCALL;   ggevinfo.err_code := GGBADEXECCALL;   
pathrefr.longint  := pptr; 
 Log_Event(EL_ERROR, GG, GG_OB_EXEC, pathrefr,                EVMSG_LEN, ggevinfo.int, ni_error);  Goto 444;   END;  {error}       {----------------------------------}  { Find_Path_ok                     }  {----------------------------------}      FUNCTION Find_Path_ok : BOOLEAN;      {}  { Description:  !{   Copy path to local space and verify it is good; also check the ! "{   outbound class number; if no class number all path is considered " {   as bad.   {   { Paramters:  {   Find_Path_ok  OUTPUT   set to false if no path entry.   {                          set to true if valid.  	{ Global Variable: 	 {   e_msg     : used to locate the path entry.  {   gg_path   : local copy of the path entry.   {   pptr      : index to GG's path record array.  {   {}      BEGIN {findpath}      IF (pptr < 1) OR (pptr > MAXGGENTRY) THEN   
    BEGIN {bad pptr} 
 
    pptr      := 0;  
     go_error  := GGBADREFERENCE;  
    END   {bad pptr} 
 ELSE  	   BEGIN {pptrok}  	        {get the path record}         DS_FetchElement (DS_ggtd, pptr, ggpath.int);          {See if the path record is a good one}       IF (ggpath.lu = 0) AND (ggpath.link_type <> GGLOOPBACK) THEN          BEGIN         pptr       := 0;        go_error   := GGBADPATHREC;         END;  	   END;  {pptrok}  	     {}  { IF class_num = 0 THEN   {    BEGIN  {    CheckClass(class_num, dummy);  
{    IF class_num = 0 THEN 
 	{       pptr := 0; 	 {    END;   {}      
Find_Path_ok := pptr > 0;  
 END;  {findpath}              {-------------------------------------}   { Main body of gateway  LINE outbound }   {-------------------------------------}   
BEGIN {gg outbound}  
     DS_EnterCritical(gg_wkmap, ni_error);           {Log the Event message if tracing is on}  Log_Event(EL_EVENT, GG_PID, 0, pathrefr,               EMSG_WORD_LEN, e_msg.int, ni_error);               WITH e_msg DO      BEGIN {with e_msg}       
   CASE em_event OF  
     
      SEND_REQUEST:  
          BEGIN  {send}      
         sendit  := false; 
                  pptr := emsr_down_ref;                IF Find_Path_OK THEN               BEGIN {path ok}                   IF NOT ggpath.flags[0] THEN                  BEGIN {bad status}   #               {The link was marked as down. Do a dynamic status call} # #               {to see if the link is still down. If it is up we just} # $               {change status and send the data, otherwise return kill}  $ $               {indication to ulp.                                    }  $                icnwd[1]    := 30 * 256;   {Control 36B}                  icnwd[2]    := ggpath.lu;                     DS_LeaveCritical(gg_wkmap);                 CheckStatus(EXEC3, icnwd, ipram);  
               BEGIN 
                GetABRegisters (areg, breg);   
               CheckError; 
 
               END;  
                    GetABRegisters(lkstat.int, breg);      !               {Here we go critical to restore the correct status} !                DS_EnterCritical(gg_wkmap, ni_error);                 ggpath.flags[0] := NOT lkstat.bits[-2];                 IF ggpath.flags[0] THEN                    BEGIN                     {link status changed from bad to good}                    {need to update the copy in DSAM     }                    sendit := true;                     DS_StoreElement(DS_GGTD, pptr, ggpath.int);                     END                  END   {bad status}               ELSE  
               BEGIN 
                {The link status is good, send it}                  sendit := true;  
               END;  
     
            IF sendit THEN 
                BEGIN {link is up}                  mbuf_ptr := emsr_mbufid;                  data_len := emsr_dlen;       !               {Fix up the appendage for INPRO and Trace program}  !                apndge_buf.lan_gg.seq     := 0;                 apndge_buf.lan_gg.ni_type := GG_LINKTYPE;                 apndge_buf.lan_gg.link_lu := ggpath.lu;      '               LISend (mbuf_ptr, data_len, apndge_buf, APNDGE_LEN, go_error);  '                IF go_error <> 0 THEN                    BEGIN                     SendKillInd(pptr, go_error);                    END;                 END   {link is up}               ELSE  
               BEGIN 
                {Bad link status, need to send a kill}                  {message to our upper level buddy.   }                  go_error := GGLINKDOWN;                 SendKillInd(pptr, go_error);   
               END;  
 
            END  {path ok} 
          ELSE   	            BEGIN  	             {If the path reference is bad or the}               {path record is bad; there is not   }               {much we can do; just ignore this   }               {send request.                      }               ggevinfo.err_code := go_error;              pathrefr.longint  := -1;              Log_Event(EL_ERROR, GG, GG_OB_EXEC, pathrefr,                            EVMSG_LEN, ggevinfo.int, ni_error);              END;               {Regardless, dispose the buffer in DSAM}            DS_MDispose (mbuf_ptr, go_error);           END;   {send}            TIMER_RESPONSE:   
         BEGIN  {connect}  
          {Check status bit if up then done else  }           {close path and send it (status bit) to }           {DSSM. NOT IMPLEMENTED!                 }  
         END;   {connect}  
     
      REQUEST_DPATH: 
          BEGIN {query}           END;  {query}      
      KILL_REQUEST:  
          BEGIN {kill}            {Here we know the the ulp (IP) has no more use of  }            {this path for the moment but we should not discard}            {the path nor should we tell the link to disconnect}            {The link and the path may be closed via a seperate}            {call and may only be done by AdvDS/1000 ADSMOD.   }            {So we just ignore the kill request for now...     }            END;  {kill}             OTHERWISE            BEGIN {unknown}           go_error          := GGBADMSGTYPE;            ggevinfo.err_code := GGBADMSGTYPE;            {negative path reference means we don't know}           pathrefr.longint  := -1;            Log_Event(EL_ERROR, GG, GG_OB, pathrefr,                         EVMSG_LEN, ggevinfo.int, ni_error);            END;  {unknown}  
      rtnerr := go_error;  
 
      END;{end case} 
    END;  {with e_msg}       444:;       DS_LeaveCritical(gg_wkmap);   
END;  {gg outbound}  
         $Subtitle 'Gateway Line Inbound', Page$   {--------------------------------------------------}  {                    GGIB                          }  {--------------------------------------------------}      PROCEDURE GGIB     {    e_msg    : EventMsgType;      VAR ierr     : Int16 };       {}  { Description:  "{    This is the gateway line link level interface inbound routine.  " {    It performs the following functions:   {   {    1. Delivers data to user in DSSM.  {    2. Handle link up indication from link driver.   {    3. Completion status from driver.  {   {}      {----------------------------------------------------------}  {                     GLOBAL VARIABLES                     }  {----------------------------------------------------------}      VAR      pptr      : Int16;     {Pointer to the path record.  }      mbuf_ptr  : Int16;     {pointer to the data in DSAM  }      gi_error  : Int16;     {error parameter for GGIB     }      line_lu   : Int16;     {Originating LU of the msg    }           {------------------------------------}  { Find_Path_ok                       }  {------------------------------------}      FUNCTION Find_Path_ok : BOOLEAN;      {}  { Description:  {   Locate the path entry. Copy path to local space.  {   { Paramters:  {   Find_Path_ok  OUTPUT   set to false if no path entry.   {                          set to true if found.  	{ Global Variable: 	 {   e_msg     : used to locate the path entry.  {   gg_path   : local copy of the path entry.   {   {}      BEGIN {findpath}  {Use e_msg.dn_refr (LU) as the key to search the entry}   {in DSAM. If located read the entry into gg_path.     }       gi_error := 0;  pptr     := 1;      DS_SerialFindAndFetchFields( DS_GGtd, pptr, MAXGGENTRY,       3, 1, line_lu, 0, SIZEOFGGPATH,           ggpath.int, pptr, gi_error);      Find_Path_ok := gi_error = 0;   END;  {findpath}                  {---------------------------------------------------------}   { Rcv_Data                                                }   {---------------------------------------------------------}       
PROCEDURE Rcv_Data;  
     {}  { Description:  {   Deliver data to user based on the path entry.   {}      
BEGIN {receive data} 
     {Call upper level protocol; for now we know it is IP.}  {In the future we will get upper level pid from our  }  {path structure which should have been configured at }  {initialization time...                              }      WITH gg_msg DO     BEGIN     ehport        := IPINBOUNDIDX;      em_event      := DATA_INDICATE;     emdi_down_pid := GG;   
   emdi_down_ref := pptr;  
    emdi_mbufid   := mbuf_ptr;      emdi_dlen     := e_msg.emdi_dlen;     END;       DS_LeaveCritical(gg_wkmap);   ProSw(gg_msg, pr_ierr);   DS_EnterCritical(gg_wkmap, ni_error);   
END;  {receive data} 
         	BEGIN {gg inbound} 	     {We received a data indication; the down reference for}   {for this message is its incoming logical unit which  }   {is placed in the event message (down_ref) by inpro.  }       DS_EnterCritical(gg_wkmap, ni_error);           {Log the Event message if tracing is on}  Log_Event(EL_EVENT, GG_PID, 0, pathrefr,               EMSG_WORD_LEN, e_msg.int, ni_error);                   WITH e_msg DO      BEGIN {with e_msg}   
   CASE em_event OF  
     
      DATA_INDICATE: 
          BEGIN  {data}  !         {Try to locate the gateway to gateway ni path structure;} ! !         {It is a configuration error if no such path record is  } ! !         {located. In that case the message is tossed... wait,   } ! !         {check with Ann to see if she wants the orphan.         } !              line_lu := emdi_down_ref;               IF Find_Path_Ok THEN               BEGIN {path ok}               {We found the path record. Send it to ULP  }              mbuf_ptr := emdi_mbufid;              Rcv_data;   
            END  {path ok} 
          ELSE   	            BEGIN  	             {No such path; for gg this is a bado.}              {Send a message to error loggor.     }              gi_error          := GGBADREFERENCE;              ggevinfo.err_code := GGBADREFERENCE;              {negative path reference means we don't know}               pathrefr.longint  := -1;              Log_Event(EL_ERROR, GG, GG_IB_DATA, pathrefr,                            EVMSG_LEN, ggevinfo.int, ni_error);              END;           END;   {data}                KILL_INDICATION:           BEGIN {disconnect}            {Set status bit to down and write it back }           {to DSAM. We got this because the inbound }           {interface received a really bad write    }           {completion status which means that there }           {is serious error at the link level. IF   }           {the status is down already, just return. }               line_lu := emki_down_ref;               IF Find_Path_OK THEN               BEGIN {path ok}               IF ggpath.flags[0] = true THEN                 BEGIN {mark it}                     ggpath.flags[0] := false;                     {DS_EnterCritical(gg_wkmap, ni_error);}                 DS_StoreElement(DS_ggtd, pptr, ggpath.int);                 {DS_LeaveCritical(gg_wkmap);}                     {send ulp a kill message}                 gi_error := GGLINKDOWN;                 SendKillInd(pptr, gi_error);                  END;  {mark it}  
            END; {path ok} 
          END;  {disconnect}       
      CONN_INDICATE: 
          BEGIN {connect}           {Set status bit to up   and write it back  }            {to DSSM. If we cannot find the path record}            {then we just ignore the indication.       }                line_lu := emci_down_ref;               IF Find_Path_OK THEN               BEGIN {path ok}   
            WITH ggpath DO 
 
               BEGIN 
                flags[0]  := true;                  DS_StoreElement(DS_ggtd, pptr, ggpath.int);  
               END;  
             END;  {path ok}            END;  {connect}            OTHERWISE            BEGIN {unknown}           {Unknown message; just log it...}           gi_error          := GGBADMSGTYPE;            ggevinfo.err_code := GGBADMSGTYPE;            {negative path reference means we don't know}           pathrefr.longint := -1;           Log_Event(EL_ERROR, GG, GG_IB, pathrefr,                         EVMSG_LEN, ggevinfo.int, ni_error);            END;  {unknown}  
      END;{end case} 
 
   END; {with e_msg} 
     DS_LeaveCritical(gg_wkmap);       	END;  {gg inbound} 	         !{----------------------------------------------------------------} ! 	{   GatewaySearch  	 !{----------------------------------------------------------------} !     PROCEDURE GatewaySearch      {VAR vna        : VNARecord;           ulp        : Int16;       VAR down_ref   : Int16;       VAR ierr       : Int16};      VAR      ggpath     : GGPathType;      pptr       : Int16;     go_error   : Int16;      BEGIN {GGSEARCH}      ierr := 0;  ggpath.address := GetIP(vna, ierr);       IF ierr = 0 THEN     BEGIN {query}     {Search for an existing path; if there is }     {one, use it; if there is none, something }     {is terribly wrong.  In that case we just }     {return an error. If the path is down try }     {to open the path first and then return   }     {the path. So if the path is still down   }     {the user will find out when using it.    }          pptr           := 1;          {IF what they what is local loopback, it is ok}       IF LocalAddress(ggpath.address) THEN         BEGIN         down_ref := pptr;         END      ELSE         BEGIN  {search}         go_error       := 0;          ggpath.up_pid  := ulp;              DS_SerialFindAndFetchFields( DS_GGtd, pptr, MAXGGENTRY,            0, 3, ggpath.int, 0, SIZEOFGGPATH,               ggpath.int, down_ref, go_error);              IF go_error <> 0 THEN            BEGIN             ierr := U_NO_USEABLE_PATHS;             END;         END;  {search}      END {query}  ELSE     BEGIN  
   ierr := U_INTERNALERR;  
    ggevinfo.err_code := ierr;      pathrefr.longint  := down_ref;      Log_Event(EL_ERROR, GG, GG_SEARCH, pathrefr,                EVMSG_LEN, ggevinfo.int, go_error);     END;       END; {GGSEARCH}               !{----------------------------------------------------------------} ! !{   X25 INIT                                                     } ! !{----------------------------------------------------------------} !     PROCEDURE X25Init { VAR ierr   : Int16 };       {}  { Abstract:   !{  This procedure pretends to be the initialization procedure for  ! "{  X.25. As such it registers itself as being a member of the HPDSN  "  {  protocol domain, and as a protocol that directly supports IP.   {}      VAR      domainrec   : DomainRecord;     protorec    : ProtocolRecord;     wkmap       : Int16;       BEGIN   DS_EnterCritical (wkmap, ierr);       { First register X.25 in the HPDSN domain.  {}  DS_FetchElement (DS_DomainsTD, HPDSN_DOMAIN, domainrec.int);  domainrec.dr_memberpids.bits[X25] := TRUE;  DS_StoreElement (DS_DomainsTD, HPDSN_DOMAIN, domainrec.int);      { Now register X.25 as a supporter of IP.   {}  DS_FetchElement (DS_ProtosTD, IP, protorec.int);  protorec.pr_supportingpids.bits[X25] := TRUE;   DS_StoreElement (DS_ProtosTD, IP, protorec.int);      
DS_LeaveCritical (wkmap);  
 END; {X25Init}      !{----------------------------------------------------------------} ! !{   X25 ADD ELEMENT                                              } ! !{----------------------------------------------------------------} !     PROCEDURE X25AddElement { VAR sp        : Int16;                             VAR stack     : TemplateControlStack;                               VAR crec      : TemplateControlRecord;                             VAR vnarec    : VNARecord;                            VAR pathstart : Int16;                            VAR rptr      : Int16;                            VAR report    : PathReportRecord;                             VAR dynamicptr: Int16;                            VAR ierr      : Int16 };      {}  { Abstract:   {  Called to add protocol elements to path report templates.  {}      LABEL 99;       VAR   
   dirty       : BOOLEAN;  
    i           : Int16;      protorec    : ProtocolRecord;     tempcrec    : TemplateControlRecord;       PROCEDURE Escape ( error  : Int16 );     BEGIN  	   ierr := error;  	    GOTO 99;      END; {Escape}      BEGIN   #{ For testbed purposes only we assume that our node is connected both  # !{ to network 1 and network 2. Net 1 is X.25-based and net 2 is LAN !  { based. If the VNA for the current domain report is anchored in   !{ network 1 then we shouldn't add an X.25 element to paths in the  ! { current domain report.  {}  IF (vnarec.ints[1] = 1) THEN     BEGIN     { Add an X25 protocol element to the path report buffer.      {}      report.bytes[rptr] := X25;   
   rptr := rptr + 1; 
 %   report.bytes[rptr] := 9; {element length -- there will be pad byte too} %    rptr := rptr + 1;     {index sap field}     IF (crec.tc_uppid = IP) THEN         BEGIN   !      { We're supposed to add a path element under an IP element.  !       {}  $      report.ints[rptr DIV 2] := 1280; {2400b = canonical address of IP} $       END      ELSE         BEGIN         Escape (U_INTERNALERR);         END; {IF crec.tc_uppid}          rptr := rptr + 2; {index machine address field}     FOR i := rptr TO (rptr + 6) DO         BEGIN   !      { Plug in a bogus 14 digit BCD address based on node's VNA.  !       {}        report.bytes[i] := vnarec.ints[1];  	      END; {FOR i} 	    rptr := rptr + 7; {index pad byte}      report.bytes[rptr] := 0;      rptr := rptr + 1;  {index first byte beyond X25 element}   
   END; {IF vnarec}  
     
ierr := SUCCESSFUL;  
     99:;  
END; {X25AddElement} 
             END. 